# AI skill levels:
#           0:     Wild Pokémon
#           1-31:  Basic trainer (young/inexperienced)
#           32-47: Some skill
#           48-90: Average skill 
#           90-99+: High Skill
#           100+: Bosses
module PBTrainerAI
  # Minimum skill level to be in each AI category
  def PBTrainerAI.minimumSkill; 1; end
  def PBTrainerAI.mediumSkill; 32; end
  def PBTrainerAI.averageSkill; 48; end
  def PBTrainerAI.highSkill; 90; end 
  def PBTrainerAI.bestSkill; 100; end
end



class PokeBattle_Battle
  attr_accessor :scores
  attr_accessor :targets
  attr_accessor :myChoices
  
  ################################################################################
  # Get a score for each move being considered (trainer-owned Pokémon only).
  # Moves with higher scores are more likely to be chosen.
  ################################################################################
  def pbGetMoveScore(move,attacker,opponent,skill=100,roughdamage=10,initialscores=[],scoreindex=-1,shutup=false,naturepri=false)
    if roughdamage<1
      roughdamage=1
    end
    if move.id < 1000
      PBDebug.log(sprintf("%s: initial score: %d",PBMoves.getName(move.id),roughdamage)) if $INTERNAL && shutup==false
    else
      PBDebug.log(sprintf("%s: initial score: %d",attacker.moves[4].name,roughdamage)) if $INTERNAL && shutup==false
    end
    skill=PBTrainerAI.minimumSkill if skill<PBTrainerAI.minimumSkill
    $shutupmega=true
    #Temporarly mega-ing pokemon if it can    #perry
    if (move.basedamage==0 || naturepri) && attacker.hasWorkingAbility(:PRANKSTER)
      prankpri = true
    end
    #Little bit of prep before getting into the case statement
    oppitemworks = opponent.itemWorks?
    attitemworks = attacker.itemWorks?
    aimem = getAIMemory(skill,opponent.pokemonIndex)
    if @doublebattle && !opponent.pbPartner.isFainted?
      aimem2 = getAIMemory(skill,opponent.pbPartner.pokemonIndex)
    end
    #score=(pbRoughDamage(move,attacker,opponent,skill,move.basedamage)*100/opponent.hp) #roughdamage
    score=roughdamage
    bettertype = move.pbType(move.type,attacker,opponent)
    opponent=attacker.pbOppositeOpposing if !opponent
    opponent=opponent.pbPartner if opponent && opponent.isFainted?
    roles = pbGetMonRole(attacker,opponent,skill)
    if (move.priority>0) || prankpri || (!attacker.abilitynulled && (attacker.ability == PBAbilities::GALEWINGS && move.type==PBTypes::FLYING) && attacker.hp==attacker.totalhp) || (attacker.species == PBSpecies::FERALIGATR && attitemworks && attacker.item == PBItems::FERACREST && attacker.turncount==0) ||  (!attacker.abilitynulled && attacker.ability == PBAbilities::TRIAGE && move.isHealingMove?)
      if move.basedamage>0 && !move.zmove
        PBDebug.log(sprintf("Priority Check Begin")) if $INTERNAL && shutup==false
        fastermon = (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        fastermon2 = (attacker.pbSpeed>pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0) if @doublebattle
        speedtie=(attacker.pbSpeed==opponent.pbSpeed)
        if fastermon
          PBDebug.log(sprintf("AI Pokemon is faster.")) if $INTERNAL && shutup==false
        elsif speedtie
          PBDebug.log(sprintf("Speed tie. Speeds are equal.")) if $INTERNAL && shutup==false
        else
          PBDebug.log(sprintf("Player Pokemon is faster.")) if $INTERNAL && shutup==false
        end
        pridam = 0
        pridam2=0
        for i in attacker.moves
          #if (attacker.pbSpeed<=pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
            if (i.priority>0 && !(i.id==(PBMoves::FAKEOUT) && attacker.turncount!=0)) ||
              (!attacker.abilitynulled && attacker.ability == PBAbilities::GALEWINGS && i.type==PBTypes::FLYING && attacker.hp==attacker.totalhp) || 
              ((attacker.species == PBSpecies::FERALIGATR) && attitemworks && attacker.item == PBItems::FERACREST && attacker.turncount==0) ||
              (!attacker.abilitynulled && attacker.ability == PBAbilities::TRIAGE && i.isHealingMove?) && i.basedamage>0
              temppridam = pbRoughDamage(i,attacker,opponent,skill,i.basedamage)
              temppridam2 = pbRoughDamage(i,attacker,opponent.pbPartner,skill,i.basedamage)
              movepriority=i.priority
              if temppridam>pridam
                pridam = temppridam
              end
              if temppridam2>pridam2
                pridam2 = temppridam2
              end
            end
          #end
        end
        cheesing=false
        olddata = PBMove.new(opponent.lastMoveUsed)
        abusing=false
        if olddata!=-1
          oldmove = PokeBattle_Move.pbFromPBMove(self,olddata,opponent)
          #if oldmove.basepower==0
          if oldmove.basedamage==0 && opponent.effects[PBEffects::Attacking]==false
            rndpredict=pbAIRandom(4)
            if rndpredict>=2
              abusing=true
            end
          end
        end
        movedamage = 0
        movedamage2 = 0
        movedamage=checkAIdamage(aimem,attacker,opponent,skill)
        if !(attacker==@battlers[2])
          restoreamount=pbHPConversion(opponent.effects[PBEffects::UsingItem][0],opponent)
          if restoreamount>0
            if !@doublebattle
              if opponent.effects[PBEffects::UsingItem].length>0 && opponent.effects[PBEffects::UsingItem][0]>0 && opponent.effects[PBEffects::UsingItem][1]==opponent.pokemonIndex
                abusing=true
              end
            elsif @doublebattle
              if opponent.effects[PBEffects::UsingItem].length>0 && opponent.effects[PBEffects::UsingItem][0]>0 && opponent.effects[PBEffects::UsingItem][1]==opponent.pokemonIndex
                abusing=true
              end
              if opponent.effects[PBEffects::UsingItem].length>0 && opponent.effects[PBEffects::UsingItem][0]>0 && opponent.effects[PBEffects::UsingItem][1]==opponent.pbPartner.pokemonIndex
                abusing=true
              end
            end
          end
          if opponent.effects[PBEffects::Substitute]>0
            if hasgreatmoves(initialscores,scoreindex,skill) && !(movedamage>attacker.hp)
              abusing=true
            end
          end
        end
        if abusing==true
          PBDebug.log(sprintf("abusing"))
        end
        if score>100
          if !fastermon
            if abusing==false
              score*=2
            else
              score*=0.99
            end
          else
            if abusing==false
              score*=1.3
              if score>=110
                score*=1.1
              end
            else
              score*=0.99
            end
          end
        else
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::STANCECHANGE)
            if !fastermon
              score*=0.8
            end
          end
        end
        shielddam = 0
        opppri = false
        partneropppri = false
        ourpridam = 0
        ourpridam2 = 0
        quickcheck = false
        icansurvive=false
        movepriority=0
        for j in aimem
          quickcheck = true if j.id==getID(PBMoves,:QUICKGUARD) 
        end 
        if @doublebattle && @aiMoveMemory[2][opponent.pbPartner.pokemonIndex].length>0
          for j in @aiMoveMemory[2][opponent.pbPartner.pokemonIndex]
            quickcheck = true if j.id==(PBMoves::QUICKGUARD)
          end
        end
        if quickcheck
          score*=0.2
        end  
        if (attacker.item == PBItems::RAMPCREST && attacker.species==PBSpecies::RAMPARDOS && !attacker.effects[PBEffects::RampCrestUsage]) || ((attacker.item == PBItems::FOCUSSASH || attacker.ability == PBAbilities::STURDY) && attacker.hp==attacker.totalhp) 
          icansurvive=true
        else
          icansurvive=false
        end
        aegischeck=false
        if (attacker.species == PBSpecies::AEGISLASH && attacker.form==1)
          aegischeck=true
          originalform = attacker.form
          shieldmon=pbAegislashStats(attacker) 
          shieldmon.pbUpdate
          for i in opponent.moves
            tempdam = pbRoughDamage(i,opponent,shieldmon,skill,i.basedamage)
            shielddam = tempdam if tempdam>shielddam
          end
          shieldmon.form = originalform
          shieldmon.pbUpdate
        end
        for i in opponent.moves
          #if (attacker.pbSpeed<=pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
            next if i.priority<0 || i.id==PBMoves::ENDEAVOR
            if (i.priority>0 && !(i.id==(PBMoves::FAKEOUT) && opponent.turncount!=0)) ||
              (!opponent.abilitynulled && opponent.ability == PBAbilities::GALEWINGS && i.type==PBTypes::FLYING && opponent.hp==opponent.totalhp) || 
              ((opponent.species == PBSpecies::FERALIGATR) && oppitemworks && opponent.item == PBItems::FERACREST && opponent.turncount==0) ||
              (!opponent.abilitynulled && opponent.ability == PBAbilities::TRIAGE && i.isHealingMove?)
              temppridam = pbRoughDamage(i,opponent,attacker,skill,i.basedamage)
              opppri=true
              if temppridam>ourpridam
                ourpridam = temppridam
              end
            end
          #end
        end
        if !$game_switches[1500]
          if @doublebattle && !opponent.pbPartner.isFainted?
            for i in opponent.pbPartner.moves
                next if i.priority<0 || i.id==PBMoves::ENDEAVOR
              #if (attacker.pbSpeed<=pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
                if (i.priority>0 && !(i.id==(PBMoves::FAKEOUT) && opponent.turncount!=0)) ||
                  (!opponent.pbPartner.abilitynulled && opponent.ability == PBAbilities::GALEWINGS && i.type==PBTypes::FLYING && opponent.pbPartner.hp==opponent.pbPartner.totalhp) || 
                  ((opponent.pbPartner.species == PBSpecies::FERALIGATR) && opponent.pbPartner.item == PBItems::FERACREST && opponent.pbPartner.turncount==0) ||
                  (!opponent.pbPartner.abilitynulled && opponent.pbPartner.ability == PBAbilities::TRIAGE && i.isHealingMove?) && i.basedamage>0
                  temppridam = pbRoughDamage(i,opponent.pbPartner,attacker,skill,i.basedamage)
                  partneropppri=true
                  if temppridam>ourpridam2
                    ourpridam2 = temppridam
                  end
                end
              #end
            end
          end
        end
        if @doublebattle && !(opponent.pbPartner.isFainted?)
          movedamage2=checkAIdamage(aimem,attacker,opponent.pbPartner,skill)
        end
        if !@doublebattle
          if !(opponent.effects[PBEffects::SomethingCrazy].nil?)
            incomingmove=opponent.effects[PBEffects::SomethingCrazy]
          else 
            incomingmove=checkAIdamage(aimem,attacker,opponent,skill,true,true)[1]
          end
          if ((attacker.effects[PBEffects::Substitute]>0 && !(incomingmove.isSoundBased?) && !(opponent.ability==PBAbilities::INFILTRATOR)) || attacker.effects[PBEffects::Disguise])
            movedamage=0
            ourpridam=0
          end
        end
        fakefree=false
        if (@doublebattle && !(attacker.pbPartner.isFainted?))
          if attacker.pbPartner.pbHasMove?((PBMoves::FAKEOUT)) && attacker.pbPartner.turncount==0 && !opponent.pbHasType?(:GHOST)
            if movedamage>movedamage2 && (movedamage2<attacker.hp)
              fakefree=true
            end
          end
        end
        PBDebug.log(sprintf("Expected damage taken: %d",movedamage)) if $INTERNAL && shutup==false
        PBDebug.log(sprintf("Expected damage taken from partner: %d",movedamage2)) if $INTERNAL && @doublebattle && shutup==false 
        PBDebug.log(sprintf("Expected damage taken in Shield Form: %d",shielddam)) if $INTERNAL && attacker.species == PBSpecies::AEGISLASH && attacker.form==1 && shutup==false     
        shielded=false
        if attacker.effects[PBEffects::KingsShield]== true ||
          attacker.effects[PBEffects::BanefulBunker]== true ||
          attacker.effects[PBEffects::SpikyShield]== true
          shielded=true
        end
        if !fastermon
          if ((movedamage>=attacker.hp && aegischeck==false || movedamage>attacker.hp && shielddam>attacker.hp && aegischeck==true) && !(opponent.status==PBStatuses::SLEEP && opponent.statusCount>1) && !icansurvive && !shielded) && !(attacker.species == PBSpecies::PARASECT && attacker.form==1) && abusing==false && !(@shieldCount>0)
            if (@doublebattle)
              if fakefree==false
                score+=75
              end
            else
              if !((opponent.moves.any? {|moveloop| (PBStuff::SETUPMOVE).include?(moveloop.id)}) && (pridam<opponent.hp/3))
                score+=150 
              elsif ((opponent.moves.any? {|moveloop| (PBStuff::SETUPMOVE).include?(moveloop.id)}) && !(pridam<opponent.hp/3))
                score+=75
              elsif (((opponent.moves.any? {|moveloop| (PBStuff::SETUPMOVE).include?(moveloop.id)}) && (pridam<opponent.hp/3)) || (opponent.moves.any? {|moveloop| (PBStuff::DEFSETUPMOVE).include?(moveloop.id)}) && (pridam<opponent.hp/3))
                if abusing==false
                  score+=50
                end
              else
                score+=75
              end 
            end
          end
        end
        if @doublebattle && aegischeck==false
          if !fastermon2 && movedamage2>attacker.hp && (movedamage<attacker.hp || movedamage>=attacker.hp)
            if fakefree==false && (pridam2<pridam)
              score+=75
            end
          end
        end
        if opppri
          if abusing==false
            score*=1.1
          end
          if (((ourpridam>attacker.hp && aegischeck==false || ourpridam>attacker.hp && shielddam<attacker.hp && aegischeck==true || ourpridam>attacker.hp && shielddam>attacker.hp && aegischeck==true) && !(opponent.status==PBStatuses::SLEEP && opponent.statusCount>1) && !(shielded) && !icansurvive) && !(attacker.species == PBSpecies::PARASECT && attacker.form==1)) && abusing==false  && !(@shieldCount>0)
            if fastermon 
              score*=3
            else      
              score*=0.5
            end
          end
        end
        if ($game_variables[665] == 9 && $game_variables[181] == 56) && !fastermon
          score*=1.5
        end
        if !fastermon && opponent.effects[PBEffects::TwoTurnAttack]>0
          score*=0
        end
        if $fefieldeffect==37
          score*=0
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::DAZZLING) || (!opponent.abilitynulled && opponent.ability == PBAbilities::QUEENLYMAJESTY) ||
          (!opponent.pbPartner.abilitynulled && opponent.pbPartner.ability == PBAbilities::DAZZLING) || (!opponent.pbPartner.abilitynulled && opponent.pbPartner.ability == PBAbilities::QUEENLYMAJESTY) ||
          $fefieldeffect==34 && (!opponent.abilitynulled && opponent.ability == PBAbilities::MIRRORARMOR) || (!opponent.pbPartner.abilitynulled && opponent.pbPartner.ability == PBAbilities::MIRRORARMOR) 
          score*=0
        end
      end
      if prankpri
         score*=1.5 if (PBStuff::SLEEPMOVE).include?(move.id) || (PBStuff::BURNMOVE).include?(move.id) || 
         (PBStuff::PARAMOVE).include?(move.id) 
      end
      PBDebug.log(sprintf("Priority Check End")) if $INTERNAL && shutup==false
    elsif move.priority<0
      if fastermon
        score*=0.9
        if move.basedamage>0
          if opponent.effects[PBEffects::TwoTurnAttack]>0
            score*=2
          end
        end
      end
    end
    ##### Alter score depending on the move's function code ########################
    case move.function
    when 0x00 # No extra effect
      if skill>=PBTrainerAI.highSkill
        if $fefieldeffect == 30 # Mirror Arena
          if move.id==getID(PBMoves,:DAZZLINGGLEAM)
            if (attacker.stages[PBStats::ACCURACY] < 0 || opponent.stages[PBStats::EVASION] > 0 ||
                opponent.hasWorkingItem(:BRIGHTPOWDER) || opponent.hasWorkingItem(:LAXINCENSE) ||
                ((!opponent.abilitynulled && opponent.ability == PBAbilities::SANDVEIL) && pbWeather==PBWeather::SANDSTORM) ||
                ((!opponent.abilitynulled && opponent.ability == PBAbilities::SNOWCLOAK) && pbWeather==PBWeather::HAIL) ||
                opponent.vanished) && !(!opponent.abilitynulled && opponent.ability == PBAbilities::NOGUARD) && !(!attacker.abilitynulled && attacker.ability == PBAbilities::NOGUARD)
              score*=2
            end
          end
          if move.id==getID(PBMoves,:BOOMBURST) || move.id==getID(PBMoves,:HYPERVOICE)
            score*=0.3
          end
        end
        if move.id==getID(PBMoves,:DAZZLINGGLEAM)
          if $fefieldeffect==40 && $fefieldeffect!=$febackup
            holymon=false
            for i in pbParty(attacker.index)
              next if i.nil?
              next if i.hp==0
              if i.hasType?(:NORMAL) || i.hasType?(:PSYCHIC) || i.hasType?(:FAIRY)
                holymon=true
              end
            end
            if holymon
              score*=1.4
            end
          end
        end
        if $fefieldeffect == 33 # Flower Garden
          if $fecounter < 0
            if move.id==getID(PBMoves,:CUT)
              goodmon = false
              for i in pbParty(attacker.index)
                next if i.nil?
                if i.hasType?(:GRASS) || i.hasType?(:BUG)
                  goodmon=true
                end
              end
              if goodmon
                score*=0.3
              else
                score*=2
              end
            end
            if move.id==getID(PBMoves,:PETALBLIZZARD) && $fecounter==4
              if @doublebattle
                score*=1.5
              end
            end
          end
        end
        if $fefieldeffect == 23 # Cave
          if move.id==getID(PBMoves,:POWERGEM)
            score*=1.3
            goodmon = false
            for i in pbParty(attacker.index)
              next if i.nil?
              if i.hasType?(:DRAGON) || i.hasType?(:FLYING) || i.hasType?(:ROCK)
                goodmon=true
              end
            end
            if goodmon
              score*=1.3
            end
          end
        end
      end
    when 0x01 # Splash
      if $fefieldeffect == 21 && move.id==getID(PBMoves,:SPLASH) # Water Surface
        if opponent.stages[PBStats::ACCURACY]==-6 || opponent.stages[PBStats::ACCURACY]>0 ||
          (!opponent.abilitynulled && opponent.ability == PBAbilities::CONTRARY)
          score=0
        else
          miniscore = 100
          if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
            miniscore*=1.3
          end
          count = -1
          sweepvar = false
          for i in pbParty(attacker.index)
            count+=1
            next if i.nil?
            temprole = pbGetMonRole(i,opponent,skill,count,pbParty(attacker.index))
            if temprole.include?(PBMonRoles::SWEEPER)
              sweepvar = true
            end
          end
          miniscore*=1.1 if sweepvar
          livecount = 0
          for i in pbParty(opponent.index)
            next if i.nil?
            livecount+=1 if i.hp!=0
          end
          if livecount==1 || (!attacker.abilitynulled && attacker.ability == PBAbilities::SHADOWTAG) || opponent.effects[PBEffects::MeanLook]>0
            miniscore*=1.4
          end
          if opponent.status==PBStatuses::BURN || opponent.status==PBStatuses::POISON
            miniscore*=1.3
          end
          if opponent.stages[PBStats::ACCURACY]<0
            minimini = 5*opponent.stages[PBStats::ACCURACY]
            minimini+=100
            minimini/=100.0
            miniscore*=minimini
          end
          miniscore/=100.0
          score*=miniscore
        end
      end
      if (move.zmove)
        if !move.name == "Z-Splash"
          miniscore = setupminiscore(attacker,opponent,skill,move,true,31,false,initialscores,scoreindex)
        else
          miniscore = setupminiscore(attacker,opponent,skill,move,true,1,true,initialscores,scoreindex)
        end
        ministat=0
        ministat+=opponent.stages[PBStats::ATTACK]
        ministat+=opponent.stages[PBStats::SPATK]
        ministat+=opponent.stages[PBStats::SPEED]
        if ministat>0
          minimini=(-5)*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        miniscore/=100.0
        score*=miniscore
        miniscore=100
        miniscore*=1.2 if checkAIhealing(aimem)
        if (attacker.pbSpeed<=pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
          miniscore*=1.3
        end
        if roles.include?(PBMonRoles::SWEEPER)
          miniscore*=1.3
        end
        if attacker.status==PBStatuses::PARALYSIS || (attacker.status==PBStatuses::BURN && move.name == "Z-Splash")
          miniscore*=0.5
        end
        if attacker.hp==attacker.totalhp && ((attacker.hasWorkingItem(:FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) && !attacker.moldbroken) || (isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST)))  && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
          miniscore*=1.4
        end
        miniscore*=0.6 if checkAIpriority(aimem)
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::SPEEDBOOST)
          miniscore*=0.3
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEAMENGINE)
          if $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==21 || $fefieldeffect==22 || $fefieldeffect==45
            miniscore*=0.7
          end
        end
        if @trickroom!=0
          miniscore*=0.5
        else
          miniscore*=0.5 if checkAImoves([PBMoves::TRICKROOM],aimem)
        end
        miniscore+=100
        miniscore/=100.0
        score*=miniscore
        score*=0 if (opponent.moves.any? {|moveloop| (PBStuff::PHASEMOVE).include?(moveloop.id)})
        score*=0.3 if ((opponent.moves.any? {|moveloop| (PBMoves::CLEARSMOG).include?(moveloop.id)}) || (opponent.moves.any? {|moveloop| (PBMoves::HAZE).include?(moveloop.id)}))
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
          score=0.2
        end
        if !move.name == "Z-Splash" && (attacker.pbTooHigh?(PBStats::ATTACK) && attacker.pbTooHigh?(PBStats::SPEED) && attacker.pbTooHigh?(PBStats::SPATK) && attacker.pbTooHigh?(PBStats::SPDEF) && attacker.pbTooHigh?(PBStats::DEFENSE))
          score*=0
        else
          score*=0 if attacker.pbTooHigh?(PBStats::ATTACK)
        end
      end
    when 0x02 # Struggle
    when 0x03 # Sleep
      if opponent.pbCanSleep?(false) && opponent.effects[PBEffects::Yawn]==0
        miniscore=100
        miniscore*=1.3
        if attacker.pbHasMove?((PBMoves::DREAMEATER)) || attacker.pbHasMove?((PBMoves::NIGHTMARE)) ||
          (!attacker.abilitynulled && attacker.ability == PBAbilities::BADDREAMS)
          miniscore*=1.5
        end
        miniscore*=1.3 if attacker.moves.any? {|moveloop| (PBStuff::SETUPMOVE).include?(moveloop.id)}
        if attacker.pbHasMove?((PBMoves::LEECHSEED)) 
          miniscore*=1.3
        end
        if attacker.pbHasMove?((PBMoves::HEX)) || attacker.pbHasMove?((PBMoves::IRRITATION)) 
          miniscore*=1.3
        end
        if attacker.pbHasMove?((PBMoves::SUBSTITUTE))
          miniscore*=1.3
        end
        if opponent.hp==opponent.totalhp
          miniscore*=1.2
        end
        ministat = statchangecounter(opponent,1,7)
        if ministat>0
          minimini=5*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        miniscore*=0.1 if checkAImoves([PBMoves::SLEEPTALK,PBMoves::SNORE,PBMoves::MAGICCOAT],aimem)
        if !opponent.abilitynulled
          miniscore*=0.3 if opponent.ability == PBAbilities::NATURALCURE
          miniscore*=0.4 if opponent.ability == PBAbilities::SHEDSKIN
          miniscore*=0.5 if (opponent.ability == PBAbilities::WONDERSKIN || (opponent.ability == PBAbilities::MAGICIAN && $fefieldeffect==37))
          miniscore*=1.5 if (opponent.ability == PBAbilities::STURDY) && (opponent.hp==opponent.totalhp)
          miniscore*=0.7 if opponent.ability == PBAbilities::MARVELSCALE || SilvallyCheck(opponent,PBTypes::WATER)
          miniscore*=0.5 if opponent.ability == PBAbilities::SYNCHRONIZE && attacker.status==0
        end
        if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL) || roles.include?(PBMonRoles::TANK) || roles.include?(PBMonRoles::SWEEPER) || roles.include?(PBMonRoles::CLERIC) || roles.include?(PBMonRoles::PIVOT) || roles.include?(PBMonRoles::STALLBREAKER) || roles.include?(PBMonRoles::LEAD)  
          miniscore*=1.3
        end
        fastermon=(attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0) || (attacker.hasWorkingAbility(:PRANKSTER)) 
        maxdam=checkAIdamage(aimem,attacker,opponent,skill)
        icansurvive=false
        if (attacker.item == PBItems::RAMPCREST && attacker.species==PBSpecies::RAMPARDOS && !attacker.effects[PBEffects::RampCrestUsage]) || 
        ((attacker.item == PBItems::FOCUSSASH || attacker.ability == PBAbilities::STURDY)) 
           if attacker.hp==attacker.totalhp 
              icansurvive=true
           end
        end
        if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0) || (!attacker.abilitynulled && attacker.ability == PBAbilities::PRANKSTER) || (attacker.species==PBSpecies::PARASECT && attacker.form==1)
          miniscore*=1.3
          if @doublebattle && !attacker.pbPartner.isFainted?
            if attacker.pbPartner.moves.any? {|moveloop| (PBStuff::SLEEPMOVE).include?(moveloop.id)}
              if (!attacker.pbPartner.abilitynulled && attacker.pbPartner.ability == PBAbilities::PRANKSTER) || (attacker.pbPartner.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0) 
                score*=1.3
              end
            end
          end
        elsif (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0) && !(!attacker.abilitynulled && attacker.ability == PBAbilities::PRANKSTER)
          if maxdam>(attacker.hp) && !icansurvive
            miniscore*=0.5
          end
          if opponent.pbHasMove?((PBMoves::SAFEGUARD))
            miniscore*=0.3
          end
        end
        if (attitemworks && attacker.item == PBItems::LEFTOVERS) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::POISONHEAL) || (isConst?(attacker.species,PBSpecies,:ZANGOOSE) && isConst?(attacker.item,PBItems,:ZANGCREST)) && attacker.status==PBStatuses::POISON)
          miniscore*=1.2
        end
        if opponent.effects[PBEffects::Confusion]>0
          miniscore*=0.6
        end
        if opponent.effects[PBEffects::Attract]>=0
          miniscore*=0.7
        end
        if initialscores.length>0
          miniscore*=1.3 if hasbadmoves(initialscores,scoreindex,35)
        end
        maxdam2=checkAIdamage(aimem,opponent,attacker,skill)
        if opponent.moves.any? {|moveloop| (PBStuff::SETUPMOVE).include?(moveloop.id)} 
          if maxdam2*2>opponent.hp && (maxdam2<opponent.hp*1.1)
            miniscore*=1.3 
            if (opponent.pbHasMove?((PBMoves::QUIVERDANCE)) || opponent.pbHasMove?((PBMoves::CALMMIND))) && !fastermon
              if attacker.spatk>attacker.attack
                if (maxdam2*0.66)<opponent.hp && (maxdam*1.5)>attacker.hp
                  score*=1.3
                end
              end
            end
          end
        end
        if skill>=PBTrainerAI.highSkill
          if move.id==(PBMoves::SING)
            if $fefieldeffect==6 # Big Top
              miniscore*=1.2
            end
            if (!opponent.abilitynulled && opponent.ability == PBAbilities::SOUNDPROOF)
              miniscore=0
            end
          end
          if move.id==(PBMoves::GRASSWHISTLE)
            if $fefieldeffect==2 || $fefieldeffect==42 # Grassy Terrain
              miniscore*=1.6
            end
            if (!opponent.abilitynulled && opponent.ability == PBAbilities::SOUNDPROOF)
              miniscore=0
            end
          end
        end
        if move.id==(PBMoves::SPORE)
          if (oppitemworks && opponent.item == PBItems::SAFETYGOGGLES) || (!opponent.abilitynulled && opponent.ability == PBAbilities::OVERCOAT) || opponent.pbHasType?(:GRASS)
            miniscore=0
          end
        end
        if skill>=PBTrainerAI.highSkill
          if move.id==(PBMoves::SLEEPPOWDER)
            if $fefieldeffect==8 || $fefieldeffect==10 # Swamp or Corrosive
              miniscore*=1.5
            end
            if (oppitemworks && opponent.item == PBItems::SAFETYGOGGLES) || (!opponent.abilitynulled && opponent.ability == PBAbilities::OVERCOAT) || opponent.pbHasType?(:GRASS)
              miniscore=0
            end
            if $fefieldeffect==33 # Flower Garden
              miniscore*=1.3
              if @doublebattle
                miniscore*= 2
              end
            end
          end
          if move.id==(PBMoves::HYPNOSIS)
            if $fefieldeffect==37 || $fefieldeffect==40
              miniscore*=1.6
            end
          end
          if move.id==(PBMoves::DARKVOID)
            if $fefieldeffect==4 || $fefieldeffect==35 # Dark Crystal or New World
              miniscore*=2
            elsif $fefieldeffect==25 # Crystal Cavern
              miniscore*=1.6
            end
          end
        end
        if (!opponent.abilitynulled && opponent.ability==PBAbilities::HYDRATION && ((pbWeather==PBWeather::RAINDANCE) || $fefieldeffect==21 || $fefieldeffect==22)) || (!opponent.abilitynulled && opponent.ability==PBAbilities::WATERVEIL && ($fefieldeffect==21 && $fefieldeffect==22))  
          score=0
        end
        if move.basedamage>0
          miniscore-=100
          if move.addlEffect.to_f != 100
            miniscore*=(move.addlEffect.to_f/100)
            if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
              miniscore*=2
            end
          end
          miniscore+=100
          miniscore/=100.0
          score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !((!opponent.abilitynulled && opponent.ability == PBAbilities::SHIELDDUST) && !opponent.moldbroken) && !hasgreatmoves(initialscores,scoreindex,skill,true)
        else
          miniscore/=100.0
          score*=miniscore
        end 
        if move.basedamage==0 && attacker.hasWorkingAbility(:SHADOWTAG) && (opponent.hasWorkingItem(:CHESTOBERRY) || opponent.hasWorkingItem(:LUMBERRY)) &&
          !attacker.hasWorkingAbility(:UNNERVE) && !attacker.pbPartner.hasWorkingAbility(:UNNERVE)
          maxdam=0
          tempdam=0
          pridam=0
          for j in opponent.moves
            if j.priority>0
              tempdam = pbRoughDamage(j,opponent,attacker,skill,j.basedamage)
              pridam=tempdam if tempdam>pridam
            end
            tempdam = pbRoughDamage(j,opponent,attacker,skill,j.basedamage)
            maxdam=tempdam if tempdam>maxdam
          end  
          hpchange=(EndofTurnHPChanges(attacker,opponent,false,false,true)) # what % of our hp will change after end of turn effects go through
          healing=((attacker.totalhp*(1-hpchange)))
          if maxdam>(attacker.hp/3) 
            if ((pbRoughStat(opponent,PBStats::SPEED,skill)<attacker.pbSpeed) ^ (@trickroom!=0)) && (!(maxdam>(attacker.hp))) #|| (maxdam>(attacker.hp) && icansurvive==true))
              score*=0.5
              if maxdam2>(opponent.hp/2)
                score*=0.5
              end
            else
              if maxdam>=(attacker.hp/2) 
                if maxdam2>(opponent.hp/2)
                  score*=0.1
                else
                  if maxdam>=(attacker.hp+healing/2) 
                    score*=0.3
                  else
                    score*=0.4
                  end
                end 
              else
                score*=0.5
              end                       
            end  
          end                        
        end 
        if (move.id == PBMoves::DARKVOID) && !(attacker.species == PBSpecies::DARKRAI) && !(attacker.species == PBSpecies::GARDEVOIR) 
          score=0
        end
      else
        if move.basedamage==0
          score=0
        end
      end
    when 0x04 # Yawn
      if opponent.effects[PBEffects::Yawn]<=0 && opponent.pbCanSleep?(false)
        score*=1.2
        if attacker.pbHasMove?((PBMoves::DREAMEATER)) ||
          attacker.pbHasMove?((PBMoves::NIGHTMARE)) ||
          (!attacker.abilitynulled && attacker.ability == PBAbilities::BADDREAMS)
          score*=1.4
        end
        if opponent.hp==opponent.totalhp
          score*=1.2
        end
        ministat = statchangecounter(opponent,1,7)
        if ministat>0
          miniscore=10*ministat
          miniscore+=100
          miniscore/=100.0
          score*=miniscore
        end
        score*=0.1 if checkAImoves([PBMoves::SLEEPTALK,PBMoves::SNORE],aimem)
        if !opponent.abilitynulled
          score*=0.1 if opponent.ability == PBAbilities::NATURALCURE
          score*=0.8 if opponent.ability == PBAbilities::MARVELSCALE || SilvallyCheck(opponent, "water")
        end
        if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL) || roles.include?(PBMonRoles::CLERIC) || roles.include?(PBMonRoles::PIVOT)
          score*=1.2
        end
        if opponent.effects[PBEffects::Confusion]>0
          score*=0.4
        end
        if opponent.effects[PBEffects::Attract]>=0
          score*=0.5
        end
        if (!opponent.abilitynulled && opponent.ability==PBAbilities::HYDRATION && ((pbWeather==PBWeather::RAINDANCE) || $fefieldeffect==21 || $fefieldeffect==22)) || (!opponent.abilitynulled && opponent.ability==PBAbilities::WATERVEIL && ($fefieldeffect==21 && $fefieldeffect==22))  
          score=0
        end
        if initialscores.length>0
          score*=1.3 if hasbadmoves(initialscores,scoreindex,30)
        end
      else
        score=0
      end
    when 0x05 # Poison
      if opponent.pbCanPoison?(false)
        miniscore=100
        miniscore*=1.2
        ministat=0
        ministat+=opponent.stages[PBStats::DEFENSE]
        ministat+=opponent.stages[PBStats::SPDEF]
        ministat+=opponent.stages[PBStats::EVASION]
        if ministat>0
          minimini=5*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        if !opponent.abilitynulled
          miniscore*=0.3 if opponent.ability == PBAbilities::NATURALCURE 
          miniscore*=0.7 if opponent.ability == PBAbilities::MARVELSCALE || SilvallyCheck(opponent, "water")
          miniscore*=0.2 if opponent.ability == PBAbilities::TOXICBOOST || opponent.ability == PBAbilities::GUTS || opponent.ability == PBAbilities::QUICKFEET
          miniscore*=0.1 if opponent.ability == PBAbilities::POISONHEAL || opponent.ability == PBAbilities::MAGICGUARD || (isConst?(opponent.species,PBSpecies,:ZANGOOSE) && isConst?(opponent.item,PBItems,:ZANGCREST))
          miniscore*=0.7 if opponent.ability == PBAbilities::SHEDSKIN 
          miniscore*=1.1 if opponent.ability == PBAbilities::STURDY || (isConst?(opponent.species,PBSpecies,:RAMPARDOS) && isConst?(opponent.item,PBItems,:RAMPCREST)) && move.basedamage>0
          miniscore*=0.5 if opponent.ability == PBAbilities::SYNCHRONIZE && attacker.status==0 && !attacker.pbHasType?(:POISON) && !attacker.pbHasType?(:STEEL)
        end
        miniscore*=0.2 if checkAImoves([PBMoves::FACADE],aimem)
        miniscore*=0.1 if checkAImoves([PBMoves::REST],aimem)
        if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
          miniscore*=1.5
        end
        if initialscores.length>0
          miniscore*=1.2 if hasbadmoves(initialscores,scoreindex,30)
        end
        if attacker.pbHasMove?((PBMoves::VENOSHOCK)) || attacker.pbHasMove?((PBMoves::VENOMDRENCH)) || (!attacker.abilitynulled && attacker.ability == PBAbilities::MERCILESS) || (isConst?(attacker.species,PBSpecies,:ARIADOS) && attacker.hasWorkingItem(:ARIACREST))
          miniscore*=1.6
        end
        if opponent.effects[PBEffects::Yawn]>0
          miniscore*=0.4
        end
        if skill>=PBTrainerAI.highSkill
          if move.id==(PBMoves::SLUDGEWAVE)
            if $fefieldeffect==21 || $fefieldeffect==22 # Water Surface/Underwater
              poisonvar=false
              watervar=false
              for mon in pbParty(attacker.index)
                next if mon.nil?
                if mon.hasType?(:WATER)
                  watervar=true
                end
                if mon.hasType?(:POISON)
                  poisonvar=true
                end
              end
              if poisonvar && !watervar
                miniscore*=1.75
              end
            end
          end
          if move.id==(PBMoves::SMOG) || move.id==(PBMoves::POISONGAS)
            if $fefieldeffect==3 # Misty Terrain
              poisonvar=false
              fairyvar=false
              for mon in pbParty(attacker.index)
                next if mon.nil?
                if mon.hasType?(:FAIRY)
                  fairyvar=true
                end
                if mon.hasType?(:POISON)
                  poisonvar=true
                end
              end
              if poisonvar && !fairyvar
                miniscore*=1.75
              end
            end
          end
          if move.id==(PBMoves::POISONPOWDER)
            if $fefieldeffect==10 || ($fefieldeffect==33 && $fecounter>0)  # Corrosive/Flower Garden Stage 2+
              miniscore*=1.25
            end
            if (oppitemworks && opponent.item == PBItems::SAFETYGOGGLES) || (!opponent.abilitynulled && opponent.ability == PBAbilities::OVERCOAT) || opponent.pbHasType?(:GRASS)
              miniscore=0
            end
          end
        end
        if (!opponent.abilitynulled && opponent.ability==PBAbilities::HYDRATION && ((pbWeather==PBWeather::RAINDANCE) || $fefieldeffect==21 || $fefieldeffect==22)) || (!opponent.abilitynulled && opponent.ability==PBAbilities::WATERVEIL && ($fefieldeffect==21 && $fefieldeffect==22))  
          score=0
        end
        if move.basedamage>0
          miniscore-=100
          if move.addlEffect.to_f != 100
            miniscore*=(move.addlEffect.to_f/100)
            if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
              miniscore*=2
            end
          end
          miniscore+=100
          miniscore/=100.0
          score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !((!opponent.abilitynulled && opponent.ability == PBAbilities::SHIELDDUST) && !opponent.moldbroken) && !hasgreatmoves(initialscores,scoreindex,skill,true)
        else
          miniscore/=100.0
          score*=miniscore
        end
      else
        poisonvar=false
        fairyvar=false
        for mon in pbParty(attacker.index)
          next if mon.nil?
          if mon.hasType?(:FAIRY)
            fairyvar=true
          end
          if mon.hasType?(:POISON)
            poisonvar=true
          end
        end
        if skill>=PBTrainerAI.highSkill
          if move.id==(PBMoves::SMOG)
            if $fefieldeffect==3 # Misty Terrain
              if poisonvar && !fairyvar
                score*=1.75
              end
            end
          end
        end
        if move.basedamage<=0
          score=0
          if skill>=PBTrainerAI.highSkill
            if move.id==(PBMoves::SMOG) || move.id==(PBMoves::POISONGAS)
              if $fefieldeffect==3 # Misty Terrain
                if poisonvar && !fairyvar
                  score = 15
                end
              end
            end
          end
        end
      end
    when 0x06 # Toxic
      if opponent.pbCanPoison?(false)
        miniscore=100
        miniscore*=1.3
        ministat=0
        ministat+=opponent.stages[PBStats::DEFENSE]
        ministat+=opponent.stages[PBStats::SPDEF]
        ministat+=opponent.stages[PBStats::SPEED]
        ministat+=opponent.stages[PBStats::EVASION]
        if ministat>0
          minimini=5*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
          PBDebug.log(sprintf("kill2")) if $INTERNAL && shutup==false
        end
        miniscore*=2 if checkAIhealing(aimem)
        if !opponent.abilitynulled
          miniscore*=0.2 if opponent.ability == PBAbilities::NATURALCURE 
          miniscore*=0.8 if opponent.ability == PBAbilities::MARVELSCALE || SilvallyCheck(opponent, "water")
          miniscore*=0.2 if opponent.ability == PBAbilities::TOXICBOOST || opponent.ability == PBAbilities::GUTS || opponent.ability == PBAbilities::QUICKFEET
          miniscore*=0.1 if opponent.ability == PBAbilities::POISONHEAL || opponent.ability == PBAbilities::MAGICGUARD || (isConst?(opponent.species,PBSpecies,:ZANGOOSE) && isConst?(opponent.item,PBItems,:ZANGCREST))
          miniscore*=0.7 if opponent.ability == PBAbilities::SHEDSKIN 
          miniscore*=1.1 if opponent.ability == PBAbilities::STURDY || (isConst?(opponent.species,PBSpecies,:RAMPARDOS) && isConst?(opponent.item,PBItems,:RAMPCREST)) && move.basedamage>0
          miniscore*=0.5 if opponent.ability == PBAbilities::SYNCHRONIZE && attacker.status==0 && attacker.pbCanPoison?(false) 
        end
        miniscore*=0.3 if checkAImoves([PBMoves::FACADE],aimem)
        miniscore*=0.1 if checkAImoves([PBMoves::REST],aimem)
        if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL) || roles.include?(PBMonRoles::LEAD)
          miniscore*=1.6
        end
        if initialscores.length>0
          miniscore*=1.3 if hasbadmoves(initialscores,scoreindex,30)
        end
        if attacker.pbHasMove?((PBMoves::VENOSHOCK)) || attacker.pbHasMove?((PBMoves::VENOMDRENCH)) || (!attacker.abilitynulled && attacker.ability == PBAbilities::MERCILESS) || (isConst?(attacker.species,PBSpecies,:ARIADOS) && attacker.hasWorkingItem(:ARIACREST))
          miniscore*=1.6
        end
        if opponent.effects[PBEffects::Yawn]>0
          miniscore*=0.1
        end
        if move.id==(PBMoves::TOXIC)
          if attacker.pbHasType?(:POISON)
            miniscore*=1.1
          end
        end
        if (!opponent.abilitynulled && opponent.ability==PBAbilities::HYDRATION && ((pbWeather==PBWeather::RAINDANCE) || $fefieldeffect==21 || $fefieldeffect==22)) || (!opponent.abilitynulled && opponent.ability==PBAbilities::WATERVEIL && ($fefieldeffect==21 && $fefieldeffect==22))  
          score=0
        end
        if move.basedamage>0
          miniscore-=100
          if move.addlEffect.to_f != 100
            miniscore*=(move.addlEffect.to_f/100)
            if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
              miniscore*=2
            end
          end
          miniscore+=100
          miniscore/=100.0
          score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !((!opponent.abilitynulled && opponent.ability == PBAbilities::SHIELDDUST) && !opponent.moldbroken) && !hasgreatmoves(initialscores,scoreindex,skill,true)
        else
          miniscore/=100.0
          score*=miniscore
        end
      else
        if move.basedamage<=0
          PBDebug.log(sprintf("KILL")) if $INTERNAL && shutup==false
          score=0
        end
      end
    when 0x07 # Paralysis
      wavefail=false
      if move.id==(PBMoves::THUNDERWAVE)
        typemod=move.pbTypeModifier(move.type,attacker,opponent)
        if typemod==0
          wavefail=true
        end
      end
      if opponent.pbCanParalyze?(false) && !wavefail
        miniscore=100
        miniscore*=1.1 if attacker.moves.any? {|moveloop| (PBStuff::SETUPMOVE).include?(moveloop.id)}
        if opponent.hp==opponent.totalhp
          miniscore*=1.2
        end
        ministat=0
        ministat+=opponent.stages[PBStats::ATTACK]
        ministat+=opponent.stages[PBStats::SPATK]
        ministat+=opponent.stages[PBStats::SPEED]
        if ministat>0
          minimini=5*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        if !opponent.abilitynulled
          miniscore*=0.3 if opponent.ability == PBAbilities::NATURALCURE
          miniscore*=0.5 if opponent.ability == PBAbilities::MARVELSCALE || SilvallyCheck(opponent,PBTypes::WATER)
          miniscore*=0.2 if opponent.ability == PBAbilities::GUTS || opponent.ability == PBAbilities::QUICKFEET
          miniscore*=0.5 if opponent.ability == PBAbilities::SHEDSKIN
          miniscore*=0.2 if opponent.ability == PBAbilities::SYNCHRONIZE && attacker.status==0 && attacker.pbCanParalyze?(false)
        end
        miniscore*=1.2 if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL) || roles.include?(PBMonRoles::PIVOT) || roles.include?(PBMonRoles::TANK)
        if move.basedamage==0
          if !@doublebattle
            if ((pbRoughStat(opponent,PBStats::SPEED,skill)>attacker.pbSpeed)) ^ (@trickroom!=0)
              if ((pbRoughStat(opponent,PBStats::SPEED,skill)/2)<attacker.pbSpeed) ^ (@trickroom!=0) 
                miniscore*=1.5 
              end
            end
          elsif @doublebattle
            if ((((pbRoughStat(opponent,PBStats::SPEED,skill)>attacker.pbSpeed)) ^ (@trickroom!=0)) && (((pbRoughStat(opponent,PBStats::SPEED,skill)/2)<attacker.pbSpeed) ^ (@trickroom!=0))) || ((((pbRoughStat(opponent,PBStats::SPEED,skill)>attacker.pbPartner.pbSpeed)) ^ (@trickroom!=0)) && (((pbRoughStat(opponent,PBStats::SPEED,skill)/2)<attacker.pbPartner.pbSpeed) ^ (@trickroom!=0)))
              miniscore*=1.5
            end
          end
          if (@trickroom!=0)
            if (((pbRoughStat(opponent,PBStats::SPEED,skill)<attacker.pbSpeed)) ^ (@trickroom!=0))
              score*=0.6
            end
          end
        end
        miniscore*=1.1 if pbRoughStat(opponent,PBStats::SPATK,skill)>pbRoughStat(opponent,PBStats::ATTACK,skill)
        count = -1
        sweepvar = false
        for i in pbParty(attacker.index)
          count+=1
          next if i.nil?
          next if i.hp==0
          temprole = pbGetMonRole(i,opponent,skill,count,pbParty(attacker.index))
          if temprole.include?(PBMonRoles::SWEEPER)
            sweepvar = true
          end
        end
        miniscore*=1.1 if sweepvar
        miniscore*=1.1 if opponent.effects[PBEffects::Confusion]>0
        miniscore*=1.1 if opponent.effects[PBEffects::Attract]>=0
        if opponent.effects[PBEffects::Yawn]>0
          miniscore*=0.3
        end
        if attacker.moves.any? {|moveloop| (PBStuff::FLINCHMOVE).include?(moveloop.id)}
          miniscore*=1.1
          if ((pbRoughStat(opponent,PBStats::SPEED,skill)/2.0)<attacker.pbSpeed && @trickroom==0) && attacker.ability == PBAbilities::SERENEGRACE
            miniscore*=1.5
          end
        end
        if skill>=PBTrainerAI.highSkill
          if move.id==(PBMoves::ZAPCANNON)
            if $fefieldeffect==18 # Short-Circuit
              miniscore*=1.3
            end
          end
          if move.id==(PBMoves::DISCHARGE)
            ghostvar=false
            for mon in pbParty(attacker.index)
              next if mon.nil?
              if mon.hasType?(:GHOST)
                ghostvar=true
              end
            end
            if $fefieldeffect==17# Factory
              miniscore*=1.1
              if ghostvar
                miniscore*=1.3
              end
            end
            if $fefieldeffect==18  # Short-Circuit
              miniscore*=1.1
              if ghostvar
                miniscore*=0.8
              end
            end
          end
          if move.id==(PBMoves::STUNSPORE)
            if $fefieldeffect==10 || ($fefieldeffect==33 && $fecounter>0)  # Corrosive/Flower Garden Stage 2+
              miniscore*=1.25
            end
            if (oppitemworks && opponent.item == PBItems::SAFETYGOGGLES) || (!opponent.abilitynulled && opponent.ability == PBAbilities::OVERCOAT) || opponent.pbHasType?(:GRASS)
              miniscore=0
            end
          end
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::HYDRATION) && (pbWeather==PBWeather::RAINDANCE || $fefieldeffect == 21 || $fefieldeffect == 22)
          miniscore=0
        end
        if move.basedamage>0
          miniscore-=100
          if move.addlEffect.to_f != 100
            miniscore*=(move.addlEffect.to_f/100)
            if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
              miniscore*=2
            end
          end
          miniscore+=100
          miniscore/=100.0
          score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !((!opponent.abilitynulled && opponent.ability == PBAbilities::SHIELDDUST) && !opponent.moldbroken) && !hasgreatmoves(initialscores,scoreindex,skill,true)
        else
          miniscore/=100.0
          score*=miniscore
        end
      else
        if move.basedamage==0
          score=0
        end
      end
    when 0x08 # Thunder + Paralyze
      if opponent.pbCanParalyze?(false) && opponent.effects[PBEffects::Yawn]<=0
        miniscore=100
        miniscore*=1.1 if attacker.moves.any? {|moveloop| (PBStuff::SETUPMOVE).include?(moveloop.id)}
        if opponent.hp==opponent.totalhp
          miniscore*=1.2
        end
        ministat=0
        ministat+=opponent.stages[PBStats::ATTACK]
        ministat+=opponent.stages[PBStats::SPATK]
        ministat+=opponent.stages[PBStats::SPEED]
        if ministat>0
          minimini=5*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        if !opponent.abilitynulled
          miniscore*=0.3 if opponent.ability == PBAbilities::NATURALCURE
          miniscore*=0.5 if opponent.ability == PBAbilities::MARVELSCALE || SilvallyCheck(opponent, "water")
          miniscore*=0.2 if opponent.ability == PBAbilities::GUTS || opponent.ability == PBAbilities::QUICKFEET
          miniscore*=0.7 if opponent.ability == PBAbilities::SHEDSKIN
          miniscore*=0.5 if opponent.ability == PBAbilities::SYNCHRONIZE && attacker.status==0
        end
        miniscore*=1.2 if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL) || roles.include?(PBMonRoles::PIVOT)
        miniscore*=1.3 if roles.include?(PBMonRoles::TANK) 
        miniscore*=1.5 if pbRoughStat(opponent,PBStats::SPEED,skill)>attacker.pbSpeed && (pbRoughStat(opponent,PBStats::SPEED,skill)/2.0)<attacker.pbSpeed && @trickroom==0
        miniscore*=1.1 if pbRoughStat(opponent,PBStats::SPATK,skill)>pbRoughStat(opponent,PBStats::ATTACK,skill)
        miniscore*=2 if attacker.moves.any? {|moveloop| (PBStuff::FLINCHMOVE).include?(moveloop.id)}
        count = -1
        sweepvar = false
        for i in pbParty(attacker.index)
          count+=1
          next if i.nil?
          temprole = pbGetMonRole(i,opponent,skill,count,pbParty(attacker.index))
          if temprole.include?(PBMonRoles::SWEEPER)
            sweepvar = true
          end
        end
        miniscore*=1.1 if sweepvar
        if opponent.effects[PBEffects::Confusion]>0
          miniscore*=1.1
        end
        if opponent.effects[PBEffects::Attract]>=0
          miniscore*=1.1
        end
        if opponent.effects[PBEffects::Yawn]>0
          miniscore*=0.6
        end
        miniscore-=100
        if move.addlEffect.to_f != 100
          miniscore*=(move.addlEffect.to_f/100)
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE) 
            miniscore*=2
          end
        end
        miniscore+=100
        miniscore/=100.0
        if !(attacker.ability == PBAbilities::SHEERFORCE) && !(opponent.ability == PBAbilities::SHIELDDUST && !opponent.moldbroken) && !hasgreatmoves(initialscores,scoreindex,skill,true)
          score*=miniscore 
        end
        invulmove=$pkmn_move[opponent.effects[PBEffects::TwoTurnAttack]][0]
        if invulmove==0xC9 || invulmove==0xCC || invulmove==0xCE
          if (pbRoughStat(opponent,PBStats::SPEED,skill)<attacker.pbSpeed) ^ (@trickroom!=0)
            score*=2
          end
        end
        if (pbRoughStat(opponent,PBStats::SPEED,skill)>attacker.pbSpeed) ^ (@trickroom!=0)
          score*=1.2 if checkAImoves(PBStuff::TWOTURNAIRMOVE,aimem)
        end
      end
    when 0x09 # Paralysis + Flinch
      if opponent.pbCanParalyze?(false)
        miniscore=100
        miniscore*=1.1 if attacker.moves.any? {|moveloop| (PBStuff::SETUPMOVE).include?(moveloop.id)}
        if opponent.hp==opponent.totalhp
          miniscore*=1.1
        end
        ministat=0
        ministat+=opponent.stages[PBStats::ATTACK]
        ministat+=opponent.stages[PBStats::SPATK]
        ministat+=opponent.stages[PBStats::SPEED]
        if ministat>0
          minimini=5*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        if !opponent.abilitynulled
          miniscore*=0.3 if opponent.ability == PBAbilities::NATURALCURE
          miniscore*=0.5 if opponent.ability == PBAbilities::MARVELSCALE || SilvallyCheck(opponent, "water")
          miniscore*=0.2 if opponent.ability == PBAbilities::GUTS || opponent.ability == PBAbilities::QUICKFEET
          miniscore*=0.7 if opponent.ability == PBAbilities::SHEDSKIN
          miniscore*=0.5 if opponent.ability == PBAbilities::SYNCHRONIZE && attacker.status==0
        end
        if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL) || roles.include?(PBMonRoles::PIVOT)
          miniscore*=1.2
        end
        if roles.include?(PBMonRoles::TANK)
          miniscore*=1.1
        end
        if pbRoughStat(opponent,PBStats::SPEED,skill)>attacker.pbSpeed && (pbRoughStat(opponent,PBStats::SPEED,skill)/2)<attacker.pbSpeed && @trickroom==0
          miniscore*=1.1
        end
        if pbRoughStat(opponent,PBStats::SPATK,skill)>pbRoughStat(opponent,PBStats::ATTACK,skill)
          miniscore*=1.1
        end
        count = -1
        sweepvar = false
        for i in pbParty(attacker.index)
          count+=1
          next if i.nil?
          temprole = pbGetMonRole(i,opponent,skill,count,pbParty(attacker.index))
          if temprole.include?(PBMonRoles::SWEEPER)
            sweepvar = true
          end
        end
        miniscore*=1.1 if sweepvar
        if opponent.effects[PBEffects::Confusion]>0
          miniscore*=1.1
        end
        if opponent.effects[PBEffects::Attract]>=0
          miniscore*=1.1
        end
        if opponent.effects[PBEffects::Yawn]>0
          miniscore*=0.8
        end
        if opponent.effects[PBEffects::Substitute]==0 && !(!opponent.abilitynulled && opponent.ability == PBAbilities::INNERFOCUS)
          if (pbRoughStat(opponent,PBStats::SPEED,skill)<attacker.pbSpeed) ^ (@trickroom!=0)
            miniscore*=1.1
            if skill>=PBTrainerAI.highSkill
              if $fefieldeffect==14 # Rocky
                miniscore*=1.1
              end
            end
          end
          if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEADFAST)
            miniscore*=0.3
          end
        end
        miniscore-=100
        if move.addlEffect.to_f != 100
          miniscore*=(move.addlEffect.to_f/100)
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
            miniscore*=2
          end
        end
        miniscore+=100
        miniscore/=100.0
        score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !((!opponent.abilitynulled && opponent.ability == PBAbilities::SHIELDDUST) && !opponent.moldbroken) && !hasgreatmoves(initialscores,scoreindex,skill,true)
      end
    when 0x0A # Burn
      if opponent.pbCanBurn?(false)
        miniscore=100
        miniscore*=1.1
        ministat=0
        ministat+=opponent.stages[PBStats::ATTACK]
        ministat+=opponent.stages[PBStats::SPATK]
        ministat+=opponent.stages[PBStats::SPEED]
        if ministat>0
          minimini=5*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        if !opponent.abilitynulled
          miniscore*=0.3 if opponent.ability == PBAbilities::NATURALCURE
          miniscore*=0.7 if opponent.ability == PBAbilities::MARVELSCALE || SilvallyCheck(opponent,PBTypes::WATER)
          miniscore*=0.1 if opponent.ability == PBAbilities::GUTS || opponent.ability == PBAbilities::FLAREBOOST
          miniscore*=0.4 if opponent.ability == PBAbilities::SHEDSKIN
          miniscore*=0.5 if opponent.ability == PBAbilities::SYNCHRONIZE && attacker.status==0 && attacker.pbCanBurn?(false)
          miniscore*=0.5 if opponent.ability == PBAbilities::MAGICGUARD
          miniscore*=0.8 if opponent.ability == PBAbilities::QUICKFEET
          miniscore*=1.1 if opponent.ability == PBAbilities::STURDY && move.basedamage>0 || (isConst?(opponent.species,PBSpecies,:RAMPARDOS) && isConst?(opponent.item,PBItems,:RAMPCREST))
        end
        miniscore*=0.1 if checkAImoves([PBMoves::REST],aimem)
        miniscore*=0.3 if checkAImoves([PBMoves::FACADE],aimem)
        if (pbRoughStat(opponent,PBStats::ATTACK,skill)>pbRoughStat(opponent,PBStats::SPATK,skill))
          if move.basedamage==0 || move.addlEffect.to_f>=30 
            miniscore*=1.4
          end
        end
        if opponent.effects[PBEffects::Yawn]>0
          miniscore*=0.3
        end
        if move.basedamage==0
          if (pbRoughStat(opponent,PBStats::SPATK,skill)>pbRoughStat(opponent,PBStats::ATTACK,skill))
            miniscore*=0.5
          end
          if opponent.effects[PBEffects::Disguise] || (opponent.species==PBSpecies::PARASECT && opponent.form==1)
             if (pbRoughStat(attacker,PBStats::ATTACK,skill)>pbRoughStat(opponent,PBStats::SPATK,skill))
              miniscore*=1.5
             end
          end
          if attacker.pbHasMove?((PBMoves::HEX)) 
            miniscore*=1.3
          end
          if checkAImoves([PBMoves::MAGICCOAT],aimem)
            lastmove = PBMove.new(attacker.lastMoveUsed)
            lastmove2 = PokeBattle_Move.pbFromPBMove(self,lastmove,attacker)
            lastmoveopp = PBMove.new(opponent.lastMoveUsed)
            lastmoveopp2 = PokeBattle_Move.pbFromPBMove(self,lastmove,opponent)
            if lastmove2.id==move.id && lastmoveopp2.id==PBMoves::MAGICCOAT
              rnd=pbAIRandom(3)
              if rnd>=1
                miniscore*=0.1
              end
            end
          end
        end
        maxdam=checkAIdamage(aimem,attacker,opponent,skill)
        # if move.basedamage==0 && (opponent.hasWorkingItem(:RAWSTBERRY) || opponent.hasWorkingItem(:LUMBERRY)) &&
        #   !attacker.hasWorkingAbility(:UNNERVE) && !attacker.pbPartner.hasWorkingAbility(:UNNERVE)
        #   if ((pbRoughStat(opponent,PBStats::SPEED,skill)<attacker.pbSpeed) ^ (@trickroom!=0)) && maxdam>attacker.hp/2 && maxdam<attacker.hp
        #     miniscore*=0.6
        #   elsif (((pbRoughStat(opponent,PBStats::SPEED,skill)>attacker.pbSpeed) ^ (@trickroom!=0)) || ((pbRoughStat(opponent,PBStats::SPEED,skill)<attacker.pbSpeed) ^ (@trickroom!=0)) && maxdam>attacker.hp)
        #     miniscore*=0.3
        #   end
        # end
        # maxdam=checkAIdamage(aimem,attacker,opponent,skill)
        # if maxdam>attacker.hp
        #   if !(opponent.hasWorkingItem(:LUMBERRY) || opponent.hasWorkingItem(:RAWSTBERRY)) && !(opponent.ability == PBAbilities::GUTS || opponent.ability == PBAbilities::FLAREBOOST)
        #       if opponent.status==0 
        #         opponent.status=PBStatuses::BURN
        #         maxdam2=checkAIdamage(aimem,attacker,opponent,skill)
        #         burned=true
        #         if maxdam2<attacker.hp*0.6
        #           miniscore*=1.2
        #         end
        #       end
        #    if burned
        #     opponent.status=0
        #    end
        #   end
        # end
        if skill>=PBTrainerAI.highSkill
          if move.id==(PBMoves::HEATWAVE) || move.id==(PBMoves::SEARINGSHOT) || move.id==(PBMoves::LAVAPLUME)
            if ($fefieldeffect==33 && $fecounter>1)  # Grassy/Forest/Flower Garden
              roastvar=false
              firevar=false
              for mon in pbParty(attacker.index)
                next if mon.nil?
                if mon.hasType?(:GRASS) || mon.hasType?(:BUG)
                  roastvar=true
                end
                if mon.hasType?(:FIRE)
                  firevar=true
                end
              end
              if firevar && !roastvar
                miniscore*=2
              end
            end
            if $fefieldeffect==11 # Corrosive Mist
              poisonvar=false
              for mon in pbParty(attacker.index)
                next if mon.nil?
                if mon.hasType?(:POISON)
                  poisonvar=true
                end
              end
              if !poisonvar
                miniscore*=1.2
              end
              if (attacker.hp.to_f)/attacker.totalhp<0.2
                miniscore*=2
              end
              count=0
              for mon in pbParty(opponent.index)
                next if mon.nil?
                count+=1 if mon.hp>0
              end
              if count==1
                miniscore*=5
              end
            end
            if $fefieldeffect==13 || $fefieldeffect==28 # Icy/Snowy Mountain
              icevar=false
              for mon in pbParty(attacker.index)
                next if mon.nil?
                if mon.hasType?(:ICE)
                  icevar=true
                end
              end
              if !icevar
                miniscore*=1.5
              end
            end
          end
          if move.id==(PBMoves::WILLOWISP)
            if $fefieldeffect==7 || $fefieldeffect==40  # Burning or Haunted 
              miniscore*=1.5
            end
          end
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::HYDRATION) && (pbWeather==PBWeather::RAINDANCE || $fefieldeffect == 21 || $fefieldeffect == 22)
          miniscore=0
        end
        if move.basedamage>0
          miniscore-=100
          if move.addlEffect.to_f != 100
            miniscore*=(move.addlEffect.to_f/100)
            if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
              miniscore*=2
            end
          end
          miniscore+=100
          miniscore/=100.0
          score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !((!opponent.abilitynulled && opponent.ability == PBAbilities::SHIELDDUST) && !opponent.moldbroken) && !hasgreatmoves(initialscores,scoreindex,skill,true)
        else
          miniscore/=100.0
          score*=miniscore
        end
      else
        if move.basedamage==0
          score=0
        end
      end
    when 0x0B # Burn + Flinch
      if opponent.pbCanBurn?(false)
        miniscore=100
        ministat=0
        ministat+=opponent.stages[PBStats::ATTACK]
        ministat+=opponent.stages[PBStats::SPATK]
        ministat+=opponent.stages[PBStats::SPEED]
        if ministat>0
          minimini=5*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        if !opponent.abilitynulled
          miniscore*=0.3 if opponent.ability == PBAbilities::NATURALCURE
          miniscore*=0.7 if opponent.ability == PBAbilities::MARVELSCALE || SilvallyCheck(opponent, "water")
          miniscore*=0.1 if opponent.ability == PBAbilities::GUTS || opponent.ability == PBAbilities::FLAREBOOST
          miniscore*=0.7 if opponent.ability == PBAbilities::SHEDSKIN
          miniscore*=0.5 if opponent.ability == PBAbilities::SYNCHRONIZE && attacker.status==0
          miniscore*=0.5 if opponent.ability == PBAbilities::MAGICGUARD
          miniscore*=0.3 if opponent.ability == PBAbilities::QUICKFEET
          miniscore*=1.1 if opponent.ability == PBAbilities::STURDY && move.basedamage>0 || (isConst?(opponent.species,PBSpecies,:RAMPARDOS) && isConst?(opponent.item,PBItems,:RAMPCREST))
        end
        miniscore*=0.1 if checkAImoves([PBMoves::REST],aimem)
        miniscore*=0.3 if checkAImoves([PBMoves::FACADE],aimem)
        if pbRoughStat(opponent,PBStats::ATTACK,skill)>pbRoughStat(opponent,PBStats::SPATK,skill)
          miniscore*=1.4
        end
        if opponent.effects[PBEffects::Yawn]>0
          miniscore*=0.4
        end
        if opponent.effects[PBEffects::Substitute]==0 && !(!opponent.abilitynulled && opponent.ability == PBAbilities::INNERFOCUS)
          if (pbRoughStat(opponent,PBStats::SPEED,skill)<attacker.pbSpeed) ^ (@trickroom!=0)
            miniscore*=1.1
            if skill>=PBTrainerAI.highSkill
              if $fefieldeffect==14 # Rocky
                miniscore*=1.1
              end
            end
          end
          if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEADFAST)
            miniscore*=0.3
          end
        end
        miniscore-=100
        if move.addlEffect.to_f != 100
          miniscore*=(move.addlEffect.to_f/100)
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
            miniscore*=2
          end
        end
        miniscore+=100
        miniscore/=100.0
        score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !((!opponent.abilitynulled && opponent.ability == PBAbilities::SHIELDDUST) && !opponent.moldbroken) && !hasgreatmoves(initialscores,scoreindex,skill,true)
      end
    when 0x0C # Freeze
      if opponent.pbCanFreeze?(false)
        miniscore=100
        if move.addlEffect.to_f>=30 
          miniscore*=1.2
        end
        miniscore*=0 if checkAImoves(PBStuff::UNFREEZEMOVE,aimem)
        miniscore*=1.2 if attacker.moves.any? {|moveloop| (PBStuff::SETUPMOVE).include?(moveloop.id)}
        miniscore*=1.2 if checkAIhealing(aimem)
        ministat = statchangecounter(opponent,1,7)
        if ministat>0
          minimini=5*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        if !opponent.abilitynulled
          miniscore*=0.3 if opponent.ability == PBAbilities::NATURALCURE
          miniscore*=0.8 if opponent.ability == PBAbilities::MARVELSCALE || SilvallyCheck(opponent, "water")
          miniscore*=0.5 if opponent.ability == PBAbilities::SYNCHRONIZE && attacker.status==0
        end
        miniscore-=100
        if move.addlEffect.to_f != 100
          miniscore*=(move.addlEffect.to_f/100)
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
            miniscore*=2
          end
        end
        miniscore+=100
        miniscore/=100.0
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect==13 # Icy Field
            miniscore*=1.5
          end
        end
        score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !((!opponent.abilitynulled && opponent.ability == PBAbilities::SHIELDDUST) && !opponent.moldbroken) && !hasgreatmoves(initialscores,scoreindex,skill,true)
      end
    when 0x0D # Blizzard Freeze
      if opponent.pbCanFreeze?(false)
        miniscore=100
        miniscore*=1.2
        miniscore*=0 if checkAImoves(PBStuff::UNFREEZEMOVE,aimem)
        miniscore*=1.3 if attacker.moves.any? {|moveloop| (PBStuff::SETUPMOVE).include?(moveloop.id)}
        miniscore*=1.2 if checkAIhealing(aimem)
        ministat = statchangecounter(opponent,1,7)
        if ministat>0
          minimini=5*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        if !opponent.abilitynulled
          miniscore*=0.3 if opponent.ability == PBAbilities::NATURALCURE
          miniscore*=0.8 if opponent.ability == PBAbilities::MARVELSCALE || SilvallyCheck(opponent, "water")
          miniscore*=0.5 if opponent.ability == PBAbilities::SYNCHRONIZE && attacker.status==0
        end
        miniscore-=100
        if move.addlEffect.to_f != 100
          miniscore*=(move.addlEffect.to_f/100)
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
            miniscore*=2
          end
        end
        miniscore+=100
        miniscore/=100.0
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect==13 # Icy Field
            miniscore*=1.3
          end
        end
        score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !((!opponent.abilitynulled && opponent.ability == PBAbilities::SHIELDDUST) && !opponent.moldbroken)
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect==26 # Murkwater Surface
            icevar=false
            murkvar=false
            for mon in pbParty(attacker.index)
              next if mon.nil?
              if mon.hasType?(:ICE)
                icevar=true
              end
              if mon.hasType?(:POISON) || mon.hasType?(:WATER)
                murkvar=true
              end
            end
            if icevar
              score*=1.3
            end
            if !murkvar
              score*=1.3
            else
              score*=0.5
            end
          end
          if $fefieldeffect==21 # Water Surface
            icevar=false
            wayervar=false
            for mon in pbParty(attacker.index)
              next if mon.nil?
              if mon.hasType?(:ICE)
                icevar=true
              end
              if mon.hasType?(:WATER)
                watervar=true
              end
            end
            if icevar
              score*=1.3
            end
            if !watervar
              score*=1.3
            else
              score*=0.5
            end
          end
          if $fefieldeffect==27 # Mountain
            icevar=false
            for mon in pbParty(attacker.index)
              next if mon.nil?
              if mon.hasType?(:ICE)
                icevar=true
              end
            end
            if icevar
              score*=1.3
            end
          end
          if $fefieldeffect==16 # Superheated Field
            icevar=false
            firevar=false
            for mon in pbParty(attacker.index)
              next if mon.nil?
              if mon.hasType?(:ICE)
                icevar=true
              end
              if mon.hasType?(:FIRE)
                firevar=true
              end
            end
            if icevar
              score*=1.3
            end
            if !firevar
              score*=1.3
            else
              score*=0.5
            end
          end
          if $fefieldeffect==24 # Glitch
            score*=1.2
          end
        end
      end
    when 0x0E # Freeze + Flinch
      if opponent.pbCanFreeze?(false)
        miniscore=100
        miniscore*=1.1
        miniscore*=0 if checkAImoves(PBStuff::UNFREEZEMOVE,aimem)
        miniscore*=1.3 if attacker.moves.any? {|moveloop| (PBStuff::SETUPMOVE).include?(moveloop.id)}
        miniscore*=1.2 if checkAIhealing(aimem)
        ministat = statchangecounter(opponent,1,7)
        if ministat>0
          minimini=5*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        if !opponent.abilitynulled
          miniscore*=0.3 if opponent.ability == PBAbilities::NATURALCURE
          miniscore*=0.8 if opponent.ability == PBAbilities::MARVELSCALE || SilvallyCheck(opponent, "water")
          miniscore*=0.5 if opponent.ability == PBAbilities::SYNCHRONIZE && attacker.status==0
        end
        if opponent.effects[PBEffects::Substitute]==0 && !(!opponent.abilitynulled && opponent.ability == PBAbilities::INNERFOCUS)
          if (pbRoughStat(opponent,PBStats::SPEED,skill)<attacker.pbSpeed) ^ (@trickroom!=0)
            miniscore*=1.1
            if skill>=PBTrainerAI.highSkill
              if $fefieldeffect==14 # Rocky
                miniscore*=1.1
              end
            end
          end
          if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEADFAST)
            miniscore*=0.3
          end
        end
        miniscore-=100
        if move.addlEffect.to_f != 100
          miniscore*=(move.addlEffect.to_f/100)
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
            miniscore*=2
          end
        end
        miniscore+=100
        miniscore/=100.0
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect==13 # Icy Field
            miniscore*=1.3
          end
        end
        score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !((!opponent.abilitynulled && opponent.ability == PBAbilities::SHIELDDUST) && !opponent.moldbroken) && !hasgreatmoves(initialscores,scoreindex,skill,true)
      end
    when 0x0F # Flinch
      if opponent.effects[PBEffects::Substitute]==0 && !(!opponent.abilitynulled && opponent.ability == PBAbilities::INNERFOCUS)
        if (pbRoughStat(opponent,PBStats::SPEED,skill) < attacker.pbSpeed) ^ (@trickroom!=0)
          miniscore=100
          if move.addlEffect.to_f>=30 
            miniscore*=1.3
          end
          if skill>=PBTrainerAI.highSkill
            if $fefieldeffect==14 # Rocky
              miniscore*=1.2
            end
            if move.id==getID(PBMoves,:DARKPULSE) && $fefieldeffect==25 # Crystal Cavern
              miniscore*=1.3
              dragonvar=false
              for mon in pbParty(attacker.index)
                next if mon.nil?
                if mon.hasType?(:DRAGON)
                  dragonvar=true
                end
              end
              if !dragonvar
                miniscore*=1.3
              end
            end
          end
          if opponent.status==PBStatuses::POISON || opponent.status==PBStatuses::BURN || (pbWeather == PBWeather::HAIL && !opponent.pbHasType?(:ICE)) || (pbWeather == PBWeather::SANDSTORM && !opponent.pbHasType?(:ROCK) && !opponent.pbHasType?(:GROUND) && !opponent.pbHasType?(:STEEL)) || opponent.effects[PBEffects::LeechSeed]>-1 || opponent.effects[PBEffects::Curse]
            miniscore*=1.1
            if opponent.effects[PBEffects::Toxic]>0
              miniscore*=1.2
            end
          end
          if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEADFAST)
            miniscore*=0.3 if move.addlEffect.to_f >= 30 
          end
          miniscore-=100
          miniscore*=(move.addlEffect.to_f/100)
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
            miniscore*=2
          end
          miniscore+=100
          miniscore/=100.0
          score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !((!opponent.abilitynulled && opponent.ability == PBAbilities::SHIELDDUST) && !opponent.moldbroken) && !hasgreatmoves(initialscores,scoreindex,skill,true)
        end
      end
    when 0x10 # Stomp
      if opponent.effects[PBEffects::Substitute]==0 && !(!opponent.abilitynulled && opponent.ability == PBAbilities::INNERFOCUS)
        if (pbRoughStat(opponent,PBStats::SPEED,skill)<attacker.pbSpeed) ^ (@trickroom!=0)
          miniscore=100
          if move.addlEffect.to_f>=30 
            miniscore*=1.3
          end
          if skill>=PBTrainerAI.highSkill
            if $fefieldeffect==14 # Rocky
              miniscore*=1.2
            end
          end
          if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEADFAST)
            miniscore*=0.3 if move.addlEffect.to_f >= 30 
          end
          miniscore-=100
          miniscore*=(move.addlEffect.to_f/100)
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
            miniscore*=2
          end
          miniscore+=100
          miniscore/=100.0
          score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !((!opponent.abilitynulled && opponent.ability == PBAbilities::SHIELDDUST) && !opponent.moldbroken)
        end
      end
      score*=2 if opponent.effects[PBEffects::Minimize]
    when 0x11 # Snore
      if attacker.status==PBStatuses::SLEEP
        score*=2
        if opponent.effects[PBEffects::Substitute]!=0
          score*=1.3
        end
        if !(!opponent.abilitynulled && opponent.ability == PBAbilities::INNERFOCUS) && ((pbRoughStat(opponent,PBStats::SPEED,skill)<attacker.pbSpeed) ^ (@trickroom!=0))
          miniscore=100
          if move.addlEffect.to_f>=30 
            miniscore*=1.3
          end
          if skill>=PBTrainerAI.highSkill
            if $fefieldeffect==14 # Rocky
              miniscore*=1.2
            end
          end
          if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEADFAST)
            miniscore*=0.3 if move.addlEffect.to_f >= 30 
          end
          miniscore-=100
          miniscore*=(move.addlEffect.to_f/100)
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
            miniscore*=2
          end
          miniscore+=100
          miniscore/=100.0
          score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !((!opponent.abilitynulled && opponent.ability == PBAbilities::SHIELDDUST) && !opponent.moldbroken) && !hasgreatmoves(initialscores,scoreindex,skill,true)
        end
      else
        score=0
      end
    when 0x12 # Fake Out
      if attacker.turncount==0
        if opponent.effects[PBEffects::Substitute]==0 && !(!opponent.abilitynulled && opponent.ability == PBAbilities::INNERFOCUS)
          if score>=110
            score*=4.5
          end
          if score>1 && score<110
            score=100
            score=120 if (pbRoughStat(opponent,PBStats::SPEED,skill)>attacker.pbSpeed && @doublebattle) || !@doublebattle
            if !(hasgreatmoves(initialscores,scoreindex,skill) && (pbRoughStat(opponent,PBStats::SPEED,skill)>attacker.pbSpeed && @doublebattle)) && @doublebattle
              score=140
            end
          end
          if opponent.statusCount>1 && opponent.status==PBStatuses::SLEEP
            score*=0.2
          end
          if skill>=PBTrainerAI.highSkill
            if $fefieldeffect==14 # Rocky
              score*=1.5
              if attacker.hasWorkingItem(:NORMALGEM)
                score*=1.1
                if (!attacker.abilitynulled && attacker.ability == PBAbilities::UNBURDEN)
                  score*=2
                end
              end
            end
          end
          if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEADFAST)
            score*=0.3
          end
          for i in opponent.moves
            if i.priority>0 || (!opponent.abilitynulled && opponent.ability == PBAbilities::GALEWINGS && move.type==PBTypes::FLYING && opponent.hp==opponent.totalhp) || 
              ((opponent.species == PBSpecies::FERALIGATR) && oppitemworks && opponent.item == PBItems::FERACREST && opponent.turncount==0) ||
              (!opponent.abilitynulled && opponent.ability == PBAbilities::TRIAGE && move.isHealingMove?)
            score*=1.3
            end
          end
          if !@opponent.is_a?(Array) && @opponent!=nil 
            if @opponent.trainertype==PBTrainers::LEADER_FLORIN
              weathervane=false
              busted=false
              for i in 0...4
                if !(pbWeather==PBWeather::RAINDANCE) && (pbRoughStat(opponent,PBStats::SPEED,skill)>attacker.pbSpeed)
                  weathervane=true
                end
                if opponent.moves[i].id==getID(PBMoves,:WIDEGUARD) || opponent.moves[i].id==getID(PBMoves,:TRICKROOM) || opponent.moves[i].id==getID(PBMoves,:STICKYWEB) || (opponent.pbPartner.moves[i].id==getID(PBMoves,:FAKEOUT) && (pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)>attacker.pbSpeed))
                  busted=true
                end
              end
            end          
          end
          score*=4 if (weathervane || busted) 
        end
      else
        score=0
      end
    when 0x13 # Confusion
      if opponent.pbCanConfuse?(false)
        miniscore=100
        miniscore*=1.2
        ministat=0
        ministat+=opponent.stages[PBStats::ATTACK]
        if ministat>0
          minimini=10*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        if pbRoughStat(opponent,PBStats::ATTACK,skill)>pbRoughStat(opponent,PBStats::SPATK,skill)
          miniscore*=1.2
        end
        if roles.include?("Physical Wall") || roles.include?("Special Wall")
          miniscore*=1.3
        end
        if opponent.effects[PBEffects::Attract]>=0
          miniscore*=1.1
        end
        if opponent.status==PBStatuses::PARALYSIS
          miniscore*=1.1
        end
        if opponent.effects[PBEffects::Yawn]>0 || opponent.status==PBStatuses::SLEEP
          miniscore*=0.4
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::TANGLEDFEET)
          miniscore*=0.7
        end
        if attacker.pbHasMove?(getID(PBMoves,:SUBSTITUTE))
          miniscore*=1.2
          if attacker.effects[PBEffects::Substitute]>0
            miniscore*=1.3
          end
        end
        if skill>=PBTrainerAI.highSkill
          if move.id==getID(PBMoves,:SIGNALBEAM)
            if $fefieldeffect==30 # Mirror Arena
              if (attacker.stages[PBStats::ACCURACY] < 0 || opponent.stages[PBStats::EVASION] > 0 ||
                  opponent.hasWorkingItem(:BRIGHTPOWDER) || opponent.hasWorkingItem(:LAXINCENSE) ||
                  ((!opponent.abilitynulled && opponent.ability == PBAbilities::SANDVEIL) && pbWeather==PBWeather::SANDSTORM) ||
                  ((!opponent.abilitynulled && opponent.ability == PBAbilities::SNOWCLOAK) && pbWeather==PBWeather::HAIL) ||
                  opponent.vanished) && !(!opponent.abilitynulled && opponent.ability == PBAbilities::NOGUARD) && !(!attacker.abilitynulled && attacker.ability == PBAbilities::NOGUARD)
                miniscore*=2
              end
            end
          end
          if move.id==getID(PBMoves,:SWEETKISS)
            if $fefieldeffect==3 # Misty
              miniscore*=1.25
            end
            if $fefieldeffect==31 # Fairy Tale
              if opponent.status==PBStatuses::SLEEP
                miniscore*=0.2
              end
            end
          end
        end
        if move.basedamage>0
          miniscore-=100
          miniscore*=(move.addlEffect.to_f/100)
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
            miniscore*=2
          end
          miniscore+=100
        end
        miniscore/=100.0
        score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !((!opponent.abilitynulled && opponent.ability == PBAbilities::SHIELDDUST) && !opponent.moldbroken) && !hasgreatmoves(initialscores,scoreindex,skill,true)
      else
        if move.basedamage<=0
          score=0
        end
      end
    when 0x14 # Chatter
      #This is no longer used, Chatter works off of the standard confusion
      #function code, 0x13
    when 0x15 # Hurricane
      if opponent.pbCanConfuse?(false)
        miniscore=100
        miniscore*=1.2
        ministat=0
        ministat+=opponent.stages[PBStats::ATTACK]
        if ministat>0
          minimini=10*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        if pbRoughStat(opponent,PBStats::ATTACK,skill)>pbRoughStat(opponent,PBStats::SPATK,skill)
          miniscore*=1.2
        end
        if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
          miniscore*=1.3
        end
        if opponent.effects[PBEffects::Attract]>=0
          miniscore*=1.1
        end
        if opponent.status==PBStatuses::PARALYSIS
          miniscore*=1.1
        end
        if opponent.effects[PBEffects::Yawn]>0 || opponent.status==PBStatuses::SLEEP
          miniscore*=0.4
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::TANGLEDFEET)
          miniscore*=0.7
        end
        if attacker.pbHasMove?((PBMoves::SUBSTITUTE))
          miniscore*=1.2
          if attacker.effects[PBEffects::Substitute]>0
            miniscore*=1.3
          end
        end
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect==3 # Misty
            score*=1.3
            fairyvar=false
            for mon in pbParty(attacker.index)
              next if mon.nil?
              if mon.hasType?(:FAIRY)
                fairyvar=true
              end
            end
            if !fairyvar
              score*=1.3
            else
              score*=0.6
            end
          end
          if $fefieldeffect==7 # Burning
            firevar=false
            for mon in pbParty(attacker.index)
              next if mon.nil?
              if mon.hasType?(:FIRE)
                firevar=true
              end
            end
            if !firevar
              score*=1.8
            else
              score*=0.5
            end
          end
          if $fefieldeffect==11 # Corrosive Mist
            poisonvar=false
            for mon in pbParty(attacker.index)
              next if mon.nil?
              if mon.hasType?(:POISON)
                poisonvar=true
              end
            end
            if !poisonvar
              score*=3
            else
              score*=0.8
            end
          end
        end
        miniscore-=100
        if move.addlEffect.to_f != 100
          miniscore*=(move.addlEffect.to_f/100)
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
            miniscore*=2
          end
        end
        miniscore+=100
        miniscore/=100.0
        score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !((!opponent.abilitynulled && opponent.ability == PBAbilities::SHIELDDUST) && !opponent.moldbroken) && !hasgreatmoves(initialscores,scoreindex,skill,true)
      end
      invulmove=$pkmn_move[opponent.effects[PBEffects::TwoTurnAttack]][0] #the function code of the current move
      if invulmove==0xC9 || invulmove==0xCC || invulmove==0xCE
        if (pbRoughStat(opponent,PBStats::SPEED,skill)<attacker.pbSpeed) ^ (@trickroom!=0)
          score*=2
        end
      end
      if (pbRoughStat(opponent,PBStats::SPEED,skill)>attacker.pbSpeed) ^ (@trickroom!=0)
        score*=1.2 if checkAImoves(PBStuff::TWOTURNAIRMOVE,aimem)
      end
    when 0x16 # Attract
      canattract=true
      agender=attacker.gender
      ogender=opponent.gender
      if agender==2 || ogender==2 || agender==ogender # Pokemon are genderless or same gender
        canattract=false
      elsif opponent.effects[PBEffects::Attract]>=0
        canattract=false
      elsif (!opponent.abilitynulled && opponent.ability == PBAbilities::OBLIVIOUS)
        canattract=false
      end
      if canattract
        score*=1.2
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::CUTECHARM)
          score*=0.7
        end
        if roles.include?("Physical Wall") || roles.include?("Special Wall")
          score*=1.3
        end
        if opponent.effects[PBEffects::Confusion]>0
          score*=1.1
        end
        if opponent.status==PBStatuses::PARALYSIS
          score*=1.1
        end
        if opponent.effects[PBEffects::Yawn]>0 || opponent.status==PBStatuses::SLEEP
          score*=0.5
        end
        if opponent.hasWorkingItem(:DESTINYKNOT)
          score*=0.1
        end
        if attacker.pbHasMove?(getID(PBMoves,:SUBSTITUTE))
          score*=1.2
          if attacker.effects[PBEffects::Substitute]>0
            score*=1.3
          end
        end
      else
        score=0
      end
    when 0x17 # Tri Attack
      if opponent.status==0
        miniscore=100
        miniscore*=1.4
        ministat = statchangecounter(opponent,1,7)
        if ministat>0
          minimini=5*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        if !opponent.abilitynulled
          miniscore*=0.3 if opponent.ability == PBAbilities::NATURALCURE
          miniscore*=0.7 if opponent.ability == PBAbilities::MARVELSCALE || SilvallyCheck(opponent, "water")
          miniscore*=0.3 if opponent.ability == PBAbilities::GUTS || opponent.ability == PBAbilities::QUICKFEET
          miniscore*=0.7 if opponent.ability == PBAbilities::SHEDSKIN
          miniscore*=0.5 if opponent.ability == PBAbilities::SYNCHRONIZE && attacker.status==0
        end
        miniscore-=100
        if move.addlEffect.to_f != 100
          miniscore*=(move.addlEffect.to_f/100)
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
            miniscore*=2
          end
        end
        miniscore+=100
        miniscore/=100.0
        score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !((!opponent.abilitynulled && opponent.ability == PBAbilities::SHIELDDUST) && !opponent.moldbroken) && !hasgreatmoves(initialscores,scoreindex,skill,true)
      end
    when 0x18 # Refresh
      if attacker.status==PBStatuses::BURN || attacker.status==PBStatuses::POISON || attacker.status==PBStatuses::PARALYSIS
        score*=3
      else
        score=0
      end
      if (attacker.hp.to_f)/attacker.totalhp>0.5
        score*=1.5
      else
        score*=0.3
      end
      if opponent.effects[PBEffects::Yawn]>0
        score*=0.1
      end
      score*=0.1 if checkAIdamage(aimem,attacker,opponent,skill)>attacker.hp
      if opponent.effects[PBEffects::Toxic]>2
        score*=1.3
      end
      score*=1.3 if checkAImoves([PBMoves::HEX],aimem)
    when 0x19 # Aromatherapy
      party=pbParty(attacker.index)
      statuses=0
      for i in 0...party.length
        statuses+=1 if party[i] && party[i].status!=0
      end
      if statuses!=0
        score*=1.2
        statuses=0
        count=-1
        for i in 0...party.length
          count+=1
          next if party[i].nil?
          temproles = pbGetMonRole(party[i],opponent,skill,count,party)
          if party[i].status==PBStatuses::POISON && (isConst?(party[i].ability,PBAbilities,:POISONHEAL) || (isConst?(party[i].species,PBSpecies,:ZANGOOSE) && isConst?(party[i].item,PBItems,:ZANGCREST)))
            score*=0.5
          end
          if (party[i].ability == PBAbilities::GUTS) || (party[i].ability == PBAbilities::QUICKFEET) || party[i].knowsMove?(:FACADE)
            score*=0.8
          end
          if party[i].status==PBStatuses::SLEEP || party[i].status==PBStatuses::FROZEN
            score*=1.1
          end
          if (temproles.include?(PBMonRoles::PHYSICALWALL) || temproles.include?(PBMonRoles::SPECIALWALL)) && party[i].status==PBStatuses::POISON
            score*=1.2
          end
          if temproles.include?(PBMonRoles::SWEEPER) && party[i].status==PBStatuses::PARALYSIS
            score*=1.2
          end
          if party[i].attack>party[i].spatk && party[i].status==PBStatuses::BURN
            score*=1.2
          end
        end
        if attacker.status!=0
          score*=1.3
        end
        if attacker.effects[PBEffects::Toxic]>2
          score*=1.3
        end
        score*=1.1 if checkAIhealing(aimem)
      else
        score=0
      end
    when 0x1A # Safeguard
      if attacker.pbOwnSide.effects[PBEffects::Safeguard]<=0 && ((pbRoughStat(opponent,PBStats::SPEED,skill)<attacker.pbSpeed) ^ (@trickroom!=0)) && attacker.status==0 && !roles.include?(PBMonRoles::STATUSABSORBER)
        score+=50 if checkAImoves([PBMoves::SPORE],aimem)
      end
    when 0x1B # Psycho Shift
      if attacker.status!=0 && opponent.effects[PBEffects::Substitute]<=0
        score*=1.3
        if opponent.status==0 && opponent.effects[PBEffects::Yawn]==0
          score*=1.3
          if attacker.status==PBStatuses::BURN && opponent.pbCanBurn?(false)
            if pbRoughStat(opponent,PBStats::ATTACK,skill)>pbRoughStat(opponent,PBStats::SPATK,skill)
              score*=1.2
            end
            if (!opponent.abilitynulled && opponent.ability == PBAbilities::FLAREBOOST)
              score*=0.7
            end
          end
          if attacker.status==PBStatuses::PARALYSIS && opponent.pbCanParalyze?(false)
            if pbRoughStat(opponent,PBStats::ATTACK,skill)<pbRoughStat(opponent,PBStats::SPATK,skill)
              score*=1.1
            end
            if (pbRoughStat(opponent,PBStats::SPEED,skill)>attacker.pbSpeed) ^ (@trickroom!=0)
              score*=1.2
            end
          end
          if attacker.status==PBStatuses::POISON && opponent.pbCanPoison?(false)
            score*=1.1 if checkAIhealing(aimem)
            if attacker.effects[PBEffects::Toxic]>0
              score*=1.4
            end
            if (!opponent.abilitynulled && opponent.ability == PBAbilities::POISONHEAL)
              score*=0.3
            end
            if (!opponent.abilitynulled && opponent.ability == PBAbilities::TOXICBOOST)
              score*=0.7
            end
          end
          if !opponent.abilitynulled && (opponent.ability == PBAbilities::SHEDSKIN || opponent.ability == PBAbilities::NATURALCURE || opponent.ability == PBAbilities::GUTS || opponent.ability == PBAbilities::QUICKFEET || opponent.ability == PBAbilities::MARVELSCALE) || SilvallyCheck(opponent, "water")
            score*=0.7
          end
          score*=0.7 if checkAImoves([PBMoves::HEX],aimem)
        end
        if attacker.pbHasMove?((PBMoves::HEX))
          score*=1.3
        end
      else
        score=0
      end
    when 0x1C # Howl
      miniscore = setupminiscore(attacker,opponent,skill,move,true,1,false,initialscores,scoreindex)
      if attacker.stages[PBStats::SPEED]<0
        ministat=attacker.stages[PBStats::SPEED]
        minimini=5*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      ministat=0
      ministat+=opponent.stages[PBStats::ATTACK]
      ministat+=opponent.stages[PBStats::SPATK]
      ministat+=opponent.stages[PBStats::SPEED]
      if ministat>0
        minimini=(-5)*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      miniscore*=1.3 if checkAIhealing(aimem)
      if attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill) && @trickroom==0
        miniscore*=1.5
      end
      if roles.include?(PBMonRoles::SWEEPER)
        miniscore*=1.3
      end
      if attacker.status==PBStatuses::BURN || attacker.status==PBStatuses::PARALYSIS
        miniscore*=0.5
      end
      miniscore*=0.3 if checkAImoves([PBMoves::FOULPLAY],aimem)
      if attacker.hp==attacker.totalhp && (((attitemworks && attacker.item == PBItems::FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY || (isConst?(opponent.species,PBSpecies,:RAMPARDOS) && isConst?(opponent.item,PBItems,:RAMPCREST))) && !attacker.moldbroken))  && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
        miniscore*=1.4
      end
      miniscore*=0.6 if checkAIpriority(aimem)
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::SPEEDBOOST)
        miniscore*=0.6
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEAMENGINE)
        if $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==21 || $fefieldeffect==22 || $fefieldeffect==45
          miniscore*=0.6
        end
      end
      if skill>=PBTrainerAI.highSkill
        if move.id==(PBMoves::MEDITATE)
          if $fefieldeffect==9 # Rainbow
            miniscore*=2
          end
          if $fefieldeffect==20 || $fefieldeffect==37 # Ashen Beach/Psychic Terrain
            miniscore*=3
          end
        end
      end
      if isConst?(attacker.species,PBSpecies,:LEDIAN) && attacker.hasWorkingItem(:LEDICREST) &&
        move.isPunchingMove?
        miniscore*=1.5
      end
      if move.basedamage>0
        miniscore-=100
        if move.addlEffect.to_f != 100
          miniscore*=(move.addlEffect.to_f/100)
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
            miniscore*=2
          end
        end
        miniscore+=100
        miniscore/=100.0
        if attacker.pbTooHigh?(PBStats::ATTACK)
          miniscore=1
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
          miniscore*=0.5
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::PARENTALBOND)
          miniscore*=1.5
        end
        score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !hasgreatmoves(initialscores,scoreindex,skill,true)
      else
        miniscore/=100.0
        if attacker.pbTooHigh?(PBStats::ATTACK)
          miniscore=0
        end
        miniscore*=0 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
          miniscore*=0
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
          miniscore=1
        end
        score*=miniscore
      end
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
      if move.basedamage==0 && $fefieldeffect!=37
        physmove=false
        for j in attacker.moves
          if j.pbIsPhysical?(j.type)
            physmove=true
          end
        end
        score=0 if !physmove
      end
    when 0x1D # Harden
      miniscore = setupminiscore(attacker,opponent,skill,move,false,2,false,initialscores,scoreindex)
      if attacker.stages[PBStats::DEFENSE]>0
        ministat=attacker.stages[PBStats::DEFENSE]
        minimini=-15*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      if pbRoughStat(opponent,PBStats::ATTACK,skill)>pbRoughStat(opponent,PBStats::SPATK,skill)
        miniscore*=1.3
      end
      if skill>=PBTrainerAI.mediumSkill
        miniscore*=0.3 if (checkAIdamage(aimem,attacker,opponent,skill).to_f/attacker.hp)<0.12 
      end
      if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
        miniscore*=1.5
      end
      if (attitemworks && attacker.item == PBItems::LEFTOVERS) || ((attitemworks && attacker.item == PBItems::BLACKSLUDGE) && attacker.pbHasType?(:POISON))
        miniscore*=1.2
      end
      healmove=false
      for j in attacker.moves
        if j.isHealingMove?
          healmove=true
        end
      end
      if healmove
        miniscore*=1.3
      end
      if attacker.pbHasMove?((PBMoves::LEECHSEED))
        miniscore*=1.3
      end
      if attacker.pbHasMove?((PBMoves::PAINSPLIT))
        miniscore*=1.2
      end
      if move.basedamage>0
        miniscore-=100
        if move.addlEffect.to_f != 100
          miniscore*=(move.addlEffect.to_f/100)
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
            miniscore*=2
          end
        end
        miniscore+=100
        miniscore/=100.0
        if attacker.pbTooHigh?(PBStats::DEFENSE)
          miniscore=1
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
          miniscore*=0.5
        end
        score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !hasgreatmoves(initialscores,scoreindex,skill,true)
      else
        miniscore/=100.0
        if attacker.pbTooHigh?(PBStats::DEFENSE)
          miniscore=0
        end
        miniscore*=0 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
          miniscore*=0
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
          miniscore=1
        end
        score*=miniscore
      end
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
    when 0x1E # Defense Curl
      miniscore = setupminiscore(attacker,opponent,skill,move,false,2,false,initialscores,scoreindex)
      if attacker.stages[PBStats::DEFENSE]>0
        ministat=attacker.stages[PBStats::DEFENSE]
        minimini=-15*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      if pbRoughStat(opponent,PBStats::ATTACK,skill)>pbRoughStat(opponent,PBStats::SPATK,skill)
        miniscore*=1.3
      end
      if skill>=PBTrainerAI.mediumSkill
        maxdam = checkAIdamage(aimem,attacker,opponent,skill)
        if (maxdam.to_f/attacker.hp)<0.12 
          miniscore*=0.3
        end
      end
      if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
        miniscore*=1.3
      end
      if (attitemworks && attacker.item == PBItems::LEFTOVERS) || ((attitemworks && attacker.item == PBItems::BLACKSLUDGE) && attacker.pbHasType?(:POISON))
        miniscore*=1.2
      end
      healmove=false
      for j in attacker.moves
        if j.isHealingMove?
          healmove=true
        end
      end
      if healmove
        miniscore*=1.3
      end
      if attacker.pbHasMove?((PBMoves::LEECHSEED))
        miniscore*=1.3
      end
      if attacker.pbHasMove?((PBMoves::PAINSPLIT))
        miniscore*=1.2
      end
      if move.basedamage>0
        miniscore-=100
        if move.addlEffect.to_f != 100
          miniscore*=(move.addlEffect.to_f/100)
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
            miniscore*=2
          end
        end
        miniscore+=100
        miniscore/=100.0
        if attacker.pbTooHigh?(PBStats::DEFENSE)
          miniscore=1
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
          miniscore*=0.5
        end
        score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !hasgreatmoves(initialscores,scoreindex,skill,true)
      else
        miniscore/=100.0
        if attacker.pbTooHigh?(PBStats::DEFENSE)
          miniscore=0
        end
        miniscore*=0 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
          miniscore*=0
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
          miniscore=1
        end
        score*=miniscore
      end
      if attacker.pbHasMove?((PBMoves::ROLLOUT)) && attacker.effects[PBEffects::DefenseCurl]==false
        score*=1.3
      end
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
    when 0x1F # Flame Charge
      miniscore = setupminiscore(attacker,opponent,skill,move,true,16,false,initialscores,scoreindex)
      if attacker.attack<attacker.spatk
        if attacker.stages[PBStats::SPATK]<0
          ministat=attacker.stages[PBStats::SPATK]
          minimini=5*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
      else
        if attacker.stages[PBStats::ATTACK]<0
          ministat=attacker.stages[PBStats::ATTACK]
          minimini=5*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
      end
      ministat=0
      ministat+=opponent.stages[PBStats::DEFENSE]
      ministat+=opponent.stages[PBStats::SPDEF]
      if ministat>0
        minimini=(-5)*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      if roles.include?(PBMonRoles::SWEEPER)
        miniscore*=1.3
      end
      if @trickroom!=0 || checkAImoves([PBMoves::TRICKROOM],aimem)
        miniscore*=0.2
      end
      if attacker.status==PBStatuses::PARALYSIS
        miniscore*=0.2
      end
      if attacker.hp==attacker.totalhp && ((attacker.hasWorkingItem(:FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) && !attacker.moldbroken) || (isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST)))  && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
        miniscore*=1.4
      end
      miniscore*=0.6 if checkAIpriority(aimem)
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::MOXIE) || SilvallyCheck(attacker,PBTypes::FIRE)
        miniscore*=1.3
      end
      if move.basedamage>0
        miniscore-=100
        if move.addlEffect.to_f != 100
          miniscore*=(move.addlEffect.to_f/100)
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
            miniscore*=2
          end
        end
        miniscore+=100
        miniscore/=100.0
        if attacker.pbTooHigh?(PBStats::SPEED)
          miniscore=1
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
          miniscore*=0.5
        end
        score*=miniscore
      else
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::SPEEDBOOST)
          miniscore*=0.6
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEAMENGINE)
          if $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==21 || $fefieldeffect==22 || $fefieldeffect==45
            miniscore*=0.6
          end
        end
        miniscore/=100.0
        if attacker.pbTooHigh?(PBStats::SPEED)
          miniscore=0
        end
        miniscore*=0 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
          miniscore*=0
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
          miniscore=1
        end
        score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !hasgreatmoves(initialscores,scoreindex,skill,true)
      end
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
    when 0x20 # Charge Beam
      miniscore = setupminiscore(attacker,opponent,skill,move,true,4,false,initialscores,scoreindex)
      if attacker.stages[PBStats::SPEED]<0
        ministat=attacker.stages[PBStats::SPEED]
        minimini=5*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      ministat=0
      ministat+=opponent.stages[PBStats::ATTACK]
      ministat+=opponent.stages[PBStats::SPATK]
      ministat+=opponent.stages[PBStats::SPEED]
      if ministat>0
        minimini=(-5)*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      miniscore*=1.3 if checkAIhealing(aimem)
      if attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill) && @trickroom==0
        miniscore*=1.5
      end
      if roles.include?(PBMonRoles::SWEEPER)
        miniscore*=1.3
      end
      if attacker.status==PBStatuses::PARALYSIS
        miniscore*=0.5
      end
      if attacker.hp==attacker.totalhp && ((attacker.hasWorkingItem(:FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) && !attacker.moldbroken) || (isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST)))  && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
        miniscore*=1.4
      end
      miniscore*=0.6 if checkAIpriority(aimem)
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::SPEEDBOOST)
        miniscore*=0.6
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEAMENGINE)
        if $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==21 || $fefieldeffect==22 || $fefieldeffect==45
          miniscore*=0.6
        end
      end
      if skill>=PBTrainerAI.highSkill
        if move.id==(PBMoves::CHARGEBEAM)
          if $fefieldeffect==18 # Short Circuit
            miniscore*=1.2
          end
        end
      end
      if move.basedamage>0
        miniscore-=100
        if move.addlEffect.to_f != 100
          miniscore*=(move.addlEffect.to_f/100)
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
            miniscore*=2
          end
        end
        miniscore+=100
        miniscore/=100.0
        if attacker.pbTooHigh?(PBStats::SPATK)
          miniscore=1
        end
        if miniscore<1
          miniscore = 1
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
          miniscore*=0.5
        end
        score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !hasgreatmoves(initialscores,scoreindex,skill,true)
      else
        miniscore/=100.0
        if attacker.pbTooHigh?(PBStats::SPATK)
          miniscore=0
        end
        miniscore*=0 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
          miniscore*=0
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
          miniscore=1
        end
        score*=miniscore
      end
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
      if move.basedamage==0
        specmove=false
        for j in attacker.moves
          if j.pbIsSpecial?(j.type)
            specmove=true
          end
        end
        score=0 if !specmove
      end
    when 0x21 # Charge
      miniscore = setupminiscore(attacker,opponent,skill,move,false,8,false,initialscores,scoreindex)
      if attacker.stages[PBStats::SPDEF]>0
        ministat=attacker.stages[PBStats::SPDEF]
        minimini=-15*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      if pbRoughStat(opponent,PBStats::ATTACK,skill)<pbRoughStat(opponent,PBStats::SPATK,skill)
        miniscore*=1.1
      end
      if skill>=PBTrainerAI.mediumSkill
        maxdam = checkAIdamage(aimem,attacker,opponent,skill)
        if (maxdam.to_f/attacker.hp)<0.12 
          miniscore*=0.3
        end
      end
      if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
        miniscore*=1.3
      end
      if (attitemworks && attacker.item == PBItems::LEFTOVERS) || ((attitemworks && attacker.item == PBItems::BLACKSLUDGE) && attacker.pbHasType?(:POISON))
        miniscore*=1.2
      end
      healmove=false
      for j in attacker.moves
        if j.isHealingMove?
          healmove=true
        end
      end
      if healmove
        miniscore*=1.3
      end
      if attacker.pbHasMove?((PBMoves::LEECHSEED))
        miniscore*=1.3
      end
      if attacker.pbHasMove?((PBMoves::PAINSPLIT))
        miniscore*=1.2
      end
      elecmove=false
      for j in attacker.moves
        if j.type==13 # Move is Electric
          if j.basedamage>0
            elecmove=true
          end
        end
      end
      if elecmove==true && attacker.effects[PBEffects::Charge]==0
        miniscore*=1.5
      end
      if move.basedamage>0
        miniscore-=100
        if move.addlEffect.to_f != 100
          miniscore*=(move.addlEffect.to_f/100)
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
            miniscore*=2
          end
        end
        miniscore+=100
        miniscore/=100.0
        if attacker.pbTooHigh?(PBStats::SPDEF)
          miniscore=1
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
          miniscore*=0.5
        end
        score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !hasgreatmoves(initialscores,scoreindex,skill,true)
      else
        miniscore/=100.0
        if attacker.pbTooHigh?(PBStats::SPDEF)
          miniscore=0
        end
        miniscore*=0 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
          miniscore*=0
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
          miniscore=1
        end
        score*=miniscore
      end
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
    when 0x22 # Double Team
      miniscore = setupminiscore(attacker,opponent,skill,move,false,0,false,initialscores,scoreindex)
      if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
        miniscore*=1.3
      end
      if (attitemworks && attacker.item == PBItems::LEFTOVERS) || ((attitemworks && attacker.item == PBItems::BLACKSLUDGE) && attacker.pbHasType?(:POISON))
        miniscore*=1.2
      end
      healmove=false
      for j in attacker.moves
        if j.isHealingMove?
          healmove=true
        end
      end
      if healmove
        miniscore*=1.3
      end
      if attacker.pbHasMove?((PBMoves::LEECHSEED))
        miniscore*=1.3
      end
      if attacker.pbHasMove?((PBMoves::PAINSPLIT))
        miniscore*=1.2
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::NOGUARD) || checkAIaccuracy(aimem)
        miniscore*=0.2
      end
      if (attitemworks && attacker.item == PBItems::BRIGHTPOWDER) || (attitemworks && attacker.item == PBItems::LAXINCENSE) ||
        ((!attacker.abilitynulled && attacker.ability == PBAbilities::SANDVEIL) && pbWeather==PBWeather::SANDSTORM) ||
        ((!attacker.abilitynulled && attacker.ability == PBAbilities::SNOWCLOAK) && pbWeather==PBWeather::HAIL)
        miniscore*=1.3
      end
      if skill>=PBTrainerAI.highSkill
        if move.id==(PBMoves::DOUBLETEAM)
          if $fefieldeffect==30 # Mirror Arena
            miniscore*=2
          end
        end
      end
      if move.basedamage>0
        miniscore-=100
        if move.addlEffect.to_f != 100
          miniscore*=(move.addlEffect.to_f/100)
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
            miniscore*=2
          end
        end
        miniscore+=100
        miniscore/=100.0
        if attacker.pbTooHigh?(PBStats::EVASION)
          miniscore=1
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
          miniscore*=0.5
        end
        score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !hasgreatmoves(initialscores,scoreindex,skill,true)
      else
        miniscore/=100.0
        if attacker.pbTooHigh?(PBStats::EVASION)
          miniscore=0
        end
        miniscore*=0 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
          miniscore*=0
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
          miniscore=1
        end
        score*=miniscore
      end
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
    when 0x23 # Focus Energy
      if attacker.effects[PBEffects::FocusEnergy]!=2
        if (attacker.hp.to_f)/attacker.totalhp>0.75
          score*=1.2
        end
        if (attacker.hp.to_f)/attacker.totalhp<0.33
          score*=0.3
        end
        if (attacker.hp.to_f)/attacker.totalhp<0.75 && ((!attacker.abilitynulled && attacker.ability == PBAbilities::EMERGENCYEXIT) || (!attacker.abilitynulled && attacker.ability == PBAbilities::WIMPOUT) || (attitemworks && attacker.item == PBItems::EJECTBUTTON))
          score*=0.3
        end
        if attacker.pbOpposingSide.effects[PBEffects::Retaliate]
          score*=0.3
        end
        if opponent.effects[PBEffects::HyperBeam]>0
          score*=1.3
        end
        if opponent.effects[PBEffects::Yawn]>0
          score*=1.7
        end
        score*=1.2 if (attacker.hp/4.0)>checkAIdamage(aimem,attacker,opponent,skill) 
        if attacker.turncount<2
          score*=1.2
        end
        if opponent.status!=0
          score*=1.2
        end
        if opponent.status==PBStatuses::SLEEP || opponent.status==PBStatuses::FROZEN
          score*=1.3
        end
        if opponent.effects[PBEffects::Encore]>0
          if opponent.moves[(opponent.effects[PBEffects::EncoreIndex])].basedamage==0
            score*=1.5
          end
        end
        if attacker.effects[PBEffects::Confusion]>0
          score*=0.2
        end
        if attacker.effects[PBEffects::LeechSeed]>=0 || attacker.effects[PBEffects::Attract]>=0
          score*=0.6
        end
        score*=0.5 if checkAImoves(PBStuff::SWITCHOUTMOVE,aimem)
        if @doublebattle
          score*=0.5
        end
        if !attacker.abilitynulled && (attacker.ability == PBAbilities::SUPERLUCK || attacker.ability == PBAbilities::SNIPER)
          score*=2
        end
        if attitemworks && (attacker.item == PBItems::SCOPELENS || attacker.item == PBItems::RAZORCLAW || (attacker.item == PBItems::STICK && (attacker.pokemon.species==83 || attacker.pokemon.species==865)) || (attacker.item == PBItems::LUCKYPUNCH && attacker.pokemon.species==113))
          score*=1.2
        end
        if (attitemworks && attacker.item == PBItems::LANSATBERRY)
          score*=1.3
        end
        if !opponent.abilitynulled && (opponent.ability == PBAbilities::ANGERPOINT || opponent.ability == PBAbilities::SHELLARMOR || opponent.ability == PBAbilities::BATTLEARMOR)
          score*=0.2
        end
        if attacker.pbHasMove?((PBMoves::LASERFOCUS)) || attacker.pbHasMove?((PBMoves::FROSTBREATH)) || attacker.pbHasMove?((PBMoves::STORMTHROW))
          score*=0.5
        end
        for j in attacker.moves
          if j.hasHighCriticalRate?
            score*=2
          end
        end
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect==20 # Ashen Beach
            score*=1.5
          end
        end
      else
        score=0
      end
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
    when 0x24 # Bulk Up
      miniscore = setupminiscore(attacker,opponent,skill,move,true,3,false,initialscores,scoreindex)
      if attacker.stages[PBStats::SPEED]<0
        ministat=attacker.stages[PBStats::SPEED]
        minimini=5*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      ministat=0
      ministat+=opponent.stages[PBStats::ATTACK]
      ministat+=opponent.stages[PBStats::SPATK]
      ministat+=opponent.stages[PBStats::SPEED]
      if ministat>0
        minimini=(-5)*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      miniscore/=100.0
      score*=miniscore
      miniscore=100
      miniscore*=1.3 if checkAIhealing(aimem)
      if attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill) && @trickroom==0
        miniscore*=1.5
      end
      if roles.include?(PBMonRoles::SWEEPER)
        miniscore*=1.3
      end
      if attacker.status==PBStatuses::BURN || attacker.status==PBStatuses::PARALYSIS
        miniscore*=0.5
      end
      miniscore*=0.3 if checkAImoves([PBMoves::FOULPLAY],aimem)
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::SPEEDBOOST)
        miniscore*=0.6
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEAMENGINE)
        if $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==21 || $fefieldeffect==22 || $fefieldeffect==45
          miniscore*=0.6
        end
      end
      physmove=false
      for j in attacker.moves
        if j.pbIsPhysical?(j.type)
          physmove=true
        end
      end
      if physmove && !attacker.pbTooHigh?(PBStats::ATTACK)
        miniscore/=100.0
        score*=miniscore
      end
      miniscore=100
      if attacker.effects[PBEffects::Toxic]>0
        miniscore*=0.2
      end
      if pbRoughStat(opponent,PBStats::SPATK,skill)<pbRoughStat(opponent,PBStats::ATTACK,skill)
        if !(roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL))
          if ((attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) && (attacker.hp.to_f)/attacker.totalhp>0.75
            miniscore*=1.3
          elsif (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
            miniscore*=0.7
          end
        end
        miniscore*=1.3
      end
      if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
        miniscore*=1.2
      end
      if (attitemworks && attacker.item == PBItems::LEFTOVERS) || ((attitemworks && attacker.item == PBItems::BLACKSLUDGE) && attacker.pbHasType?(:POISON))
        miniscore*=1.2
      end
      healmove=false
      for j in attacker.moves
        if j.isHealingMove?
          healmove=true
        end
      end
      if healmove
        miniscore*=1.3
      end
      if attacker.pbHasMove?((PBMoves::LEECHSEED))
        miniscore*=1.3
      end
      if attacker.pbHasMove?((PBMoves::PAINSPLIT))
        miniscore*=1.2
      end
      if !attacker.pbTooHigh?(PBStats::DEFENSE)
        miniscore/=100.0
        score*=miniscore
      end
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
      score*=0.3 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        score=0
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
        score=0
      end
      if attacker.pbTooHigh?(PBStats::ATTACK) && attacker.pbTooHigh?(PBStats::DEFENSE)
        score*=0
      end
    when 0x25 # Coil
      miniscore = setupminiscore(attacker,opponent,skill,move,true,5,false,initialscores,scoreindex)
      if attacker.stages[PBStats::SPEED]<0
        ministat=attacker.stages[PBStats::SPEED]
        minimini=5*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      ministat=0
      ministat+=opponent.stages[PBStats::ATTACK]
      ministat+=opponent.stages[PBStats::SPATK]
      ministat+=opponent.stages[PBStats::SPEED]
      if ministat>0
        minimini=(-5)*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      miniscore/=100.0
      score*=miniscore
      miniscore=100
      miniscore*=1.3 if checkAIhealing(aimem)
      if attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill) && @trickroom==0
        miniscore*=1.3
      end
      if roles.include?(PBMonRoles::SWEEPER)
        miniscore*=1.1
      end
      if attacker.status==PBStatuses::BURN || attacker.status==PBStatuses::PARALYSIS
        miniscore*=0.5
      end
      miniscore*=0.3 if checkAImoves([PBMoves::FOULPLAY],aimem)
      if attacker.hp==attacker.totalhp && ((attacker.hasWorkingItem(:FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) && !attacker.moldbroken) || (isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST)))  && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
        miniscore*=1.4
      end
      miniscore*=0.6 if checkAIpriority(aimem)
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::SPEEDBOOST)
        miniscore*=0.6
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEAMENGINE)
        if $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==21 || $fefieldeffect==22 || $fefieldeffect==45
          miniscore*=0.6
        end
      end
      physmove=false
      for j in attacker.moves
        if j.pbIsPhysical?(j.type)
          physmove=true
        end
      end
      if physmove && !attacker.pbTooHigh?(PBStats::ATTACK)
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect==2 # Grassy Terrain
            miniscore*=2
          end
        end
        miniscore/=100.0
        score*=miniscore
      end
      miniscore=100
      if attacker.effects[PBEffects::Toxic]>0
        miniscore*=0.2
      end
      if pbRoughStat(opponent,PBStats::SPATK,skill)<pbRoughStat(opponent,PBStats::ATTACK,skill)
        if !(roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL))
          if ((attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) && (attacker.hp.to_f)/attacker.totalhp>0.75
            miniscore*=1.1
          elsif (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
            miniscore*=0.7
          end
        end
        miniscore*=1.1
      end
      if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
        miniscore*=1.1
      end
      if (attitemworks && attacker.item == PBItems::LEFTOVERS) || ((attitemworks && attacker.item == PBItems::BLACKSLUDGE) && attacker.pbHasType?(:POISON))
        miniscore*=1.1
      end
      healmove=false
      for j in attacker.moves
        if j.isHealingMove?
          healmove=true
        end
      end
      if healmove
        miniscore*=1.2
      end
      if attacker.pbHasMove?((PBMoves::LEECHSEED))
        miniscore*=1.2
      end
      if attacker.pbHasMove?((PBMoves::PAINSPLIT))
        miniscore*=1.2
      end
      if !attacker.pbTooHigh?(PBStats::DEFENSE)
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect==2 # Grassy Terrain
            miniscore*=2
          end
        end
        miniscore/=100.0
        score*=miniscore
      end
      miniscore=100
      weakermove=false
      for j in attacker.moves
        if j.basedamage<95
          weakermove=true
        end
      end
      if weakermove
        miniscore*=1.1
      end
      if opponent.stages[PBStats::EVASION]>0
        ministat=opponent.stages[PBStats::EVASION]
        minimini=5*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      if (oppitemworks && opponent.item == PBItems::BRIGHTPOWDER) || (oppitemworks && opponent.item == PBItems::LAXINCENSE) ||
        ((!opponent.abilitynulled && opponent.ability == PBAbilities::SANDVEIL) && pbWeather==PBWeather::SANDSTORM) ||
        ((!opponent.abilitynulled && opponent.ability == PBAbilities::SNOWCLOAK) && pbWeather==PBWeather::HAIL)
        miniscore*=1.1
      end
      if !attacker.pbTooHigh?(PBStats::ACCURACY)
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect==2 # Grassy Terrain
            miniscore*=2
          end
        end
        miniscore/=100.0
        score*=miniscore
      end
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
      score*=0.3 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        score=0
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
        score=0
      end
      if attacker.pbTooHigh?(PBStats::ATTACK) && attacker.pbTooHigh?(PBStats::DEFENSE) && attacker.pbTooHigh?(PBStats::ACCURACY)
        score*=0
      end
    when 0x26 # Dragon Dance
      miniscore = setupminiscore(attacker,opponent,skill,move,true,17,false,initialscores,scoreindex)
      ministat=0
      ministat+=opponent.stages[PBStats::ATTACK]
      ministat+=opponent.stages[PBStats::SPATK]
      ministat+=opponent.stages[PBStats::SPEED]
      if ministat>0
        minimini=(-5)*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      miniscore/=100.0
      score*=miniscore
      miniscore=100
      miniscore*=1.2 if checkAIhealing(aimem)
      if (attacker.pbSpeed<=pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        miniscore*=1.5
      end
      if roles.include?(PBMonRoles::SWEEPER)
        miniscore*=1.3
      end
      if attacker.status==PBStatuses::BURN || attacker.status==PBStatuses::PARALYSIS
        miniscore*=0.5
      end
      miniscore*=0.3 if checkAImoves([PBMoves::FOULPLAY],aimem)
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::SPEEDBOOST)
        miniscore*=0.3
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEAMENGINE)
        if $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==21 || $fefieldeffect==22 || $fefieldeffect==45
          miniscore*=0.7
        end
      end
      physmove=false
      for j in attacker.moves
        if j.pbIsPhysical?(j.type)
          physmove=true
        end
      end
      if physmove && !attacker.pbTooHigh?(PBStats::ATTACK)
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect==6 || $fefieldeffect==32 # Big Top/Dragon's Den
            miniscore*=2
          end
        end
        miniscore/=100.0
        score*=miniscore
      end
      miniscore=100
      if attacker.stages[PBStats::ATTACK]<0
        ministat=attacker.stages[PBStats::ATTACK]
        minimini=5*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        miniscore*=0.8
      end
      if @trickroom!=0
        miniscore*=0.2
      else
        miniscore*=0.2 if checkAImoves([PBMoves::TRICKROOM],aimem)
      end
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::MOXIE) || SilvallyCheck(attacker,PBTypes::FIRE)
        miniscore*=1.3
      end
      if !attacker.pbTooHigh?(PBStats::SPEED)
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect==6 || $fefieldeffect==32 # Big Top/Dragon's Den
            miniscore*=2
          end
        end
        miniscore/=100.0
        score*=miniscore
      end
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
      score*=0.3 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        score=0
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
        score=0
      end
      if attacker.pbTooHigh?(PBStats::ATTACK) && attacker.pbTooHigh?(PBStats::SPEED)
        score*=0
      end
    when 0x27 # Work Up
      miniscore = setupminiscore(attacker,opponent,skill,move,true,5,false,initialscores,scoreindex)
      if attacker.stages[PBStats::SPEED]<0
        ministat=attacker.stages[PBStats::SPEED]
        minimini=5*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      ministat=0
      ministat+=opponent.stages[PBStats::ATTACK]
      ministat+=opponent.stages[PBStats::SPATK]
      ministat+=opponent.stages[PBStats::SPEED]
      if ministat>0
        minimini=(-5)*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      miniscore/=100.0
      score*=miniscore
      miniscore=100
      miniscore*=1.3 if checkAIhealing(aimem)
      if attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill) && @trickroom==0
        miniscore*=1.5
      end
      if roles.include?(PBMonRoles::SWEEPER)
        miniscore*=1.3
      end
      specmove=false
      for j in attacker.moves
        if j.pbIsSpecial?(j.type)
          specmove=true
        end
      end
      if attacker.status==PBStatuses::BURN && !specmove
        miniscore*=0.5
      end
      if attacker.status==PBStatuses::PARALYSIS
        miniscore*=0.5
      end
      miniscore*=0.3 if checkAImoves([PBMoves::FOULPLAY],aimem)
      if attacker.hp==attacker.totalhp && ((attacker.hasWorkingItem(:FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) && !attacker.moldbroken) || (isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST)))  && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
        miniscore*=1.4
      end
      miniscore*=0.6 if checkAIpriority(aimem)
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::SPEEDBOOST)
        miniscore*=0.6
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEAMENGINE)
        if $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==21 || $fefieldeffect==22 || $fefieldeffect==45
          miniscore*=0.6
        end
      end
      physmove=false
      for j in attacker.moves
        if j.pbIsPhysical?(j.type)
          physmove=true
        end
      end
      if (physmove && !attacker.pbTooHigh?(PBStats::ATTACK)) || (specmove && !attacker.pbTooHigh?(PBStats::SPATK))
        miniscore/=100.0
        score*=miniscore
      end
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
      score*=0.3 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        score=0
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
        score=0
      end
      if attacker.pbTooHigh?(PBStats::SPATK) && attacker.pbTooHigh?(PBStats::ATTACK)
        score*=0
      end
    when 0x28 # Growth
      miniscore = setupminiscore(attacker,opponent,skill,move,true,5,false,initialscores,scoreindex)
      if attacker.stages[PBStats::SPEED]<0
        ministat=attacker.stages[PBStats::SPEED]
        minimini=5*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      ministat=0
      ministat+=opponent.stages[PBStats::ATTACK]
      ministat+=opponent.stages[PBStats::SPATK]
      ministat+=opponent.stages[PBStats::SPEED]
      if ministat>0
        minimini=(-5)*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      miniscore/=100.0
      score*=miniscore
      miniscore=100
      miniscore*=1.3 if checkAIhealing(aimem)
      if attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill) && @trickroom==0
        miniscore*=1.5
      end
      if roles.include?(PBMonRoles::SWEEPER)
        miniscore*=1.3
      end
      specmove=false
      for j in attacker.moves
        if j.pbIsSpecial?(j.type)
          specmove=true
        end
      end
      if attacker.status==PBStatuses::BURN && !specmove
        miniscore*=0.5
      end
      if attacker.status==PBStatuses::PARALYSIS
        miniscore*=0.5
      end
      miniscore*=0.3 if checkAImoves([PBMoves::FOULPLAY],aimem)
      if attacker.hp==attacker.totalhp && ((attacker.hasWorkingItem(:FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) && !attacker.moldbroken) || (isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST)))  && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
        miniscore*=1.4
      end
      miniscore*=0.6 if checkAIpriority(aimem)
      physmove=false
      for j in attacker.moves
        if j.pbIsPhysical?(j.type)
          physmove=true
        end
      end
      if (physmove && !attacker.pbTooHigh?(PBStats::ATTACK)) || (specmove && !attacker.pbTooHigh?(PBStats::SPATK))
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect==2 || $fefieldeffect==15 || pbWeather==PBWeather::SUNNYDAY # Grassy/Forest
            miniscore*=2
          end
          if ($fefieldeffect==33) # Flower Garden
            if $fecounter>2
              miniscore*=3
            else
              miniscore*=2
            end
          end
        end
        miniscore/=100.0
        score*=miniscore
      end
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
      score*=0.3 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        score=0
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
        score=0
      end
      if attacker.pbTooHigh?(PBStats::SPATK) && attacker.pbTooHigh?(PBStats::ATTACK)
        score*=0
      end
    when 0x29 # Hone Claws
      miniscore = setupminiscore(attacker,opponent,skill,move,true,1,false,initialscores,scoreindex)
      if attacker.stages[PBStats::SPEED]<0
        ministat=attacker.stages[PBStats::SPEED]
        minimini=5*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      ministat=0
      ministat+=opponent.stages[PBStats::ATTACK]
      ministat+=opponent.stages[PBStats::SPATK]
      ministat+=opponent.stages[PBStats::SPEED]
      if ministat>0
        minimini=(-5)*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      miniscore*=1.3 if checkAIhealing(aimem)
      if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        miniscore*=1.5
      end
      if roles.include?(PBMonRoles::SWEEPER)
        miniscore*=1.3
      end
      if attacker.status==PBStatuses::BURN || attacker.status==PBStatuses::PARALYSIS
        miniscore*=0.5
      end
      miniscore*=0.3 if checkAImoves([PBMoves::FOULPLAY],aimem)
      if attacker.hp==attacker.totalhp && ((attacker.hasWorkingItem(:FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) && !attacker.moldbroken) || (isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST)))  && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
        miniscore*=1.4
      end
      miniscore*=0.6 if checkAIpriority(aimem)
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::SPEEDBOOST)
        miniscore*=0.6
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEAMENGINE)
        if $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==21 || $fefieldeffect==22 || $fefieldeffect==45
          miniscore*=0.6
        end
      end
      physmove=false
      for j in attacker.moves
        if j.pbIsPhysical?(j.type)
          physmove=true
        end
      end
      if physmove && !attacker.pbTooHigh?(PBStats::ATTACK)
        miniscore/=100.0
        score*=miniscore
      end
      miniscore=100
      weakermove=false
      for j in attacker.moves
        if j.basedamage<95
          weakermove=true
        end
      end
      if weakermove
        miniscore*=1.3
      end
      if opponent.stages[PBStats::EVASION]>0
        ministat=opponent.stages[PBStats::EVASION]
        minimini=5*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      if (oppitemworks && opponent.item == PBItems::BRIGHTPOWDER) || (oppitemworks && opponent.item == PBItems::LAXINCENSE) ||
        ((!opponent.abilitynulled && opponent.ability == PBAbilities::SANDVEIL) && pbWeather==PBWeather::SANDSTORM) ||
        ((!opponent.abilitynulled && opponent.ability == PBAbilities::SNOWCLOAK) && pbWeather==PBWeather::HAIL)
        miniscore*=1.3
      end
      if !attacker.pbTooHigh?(PBStats::ACCURACY)
        miniscore/=100.0
        score*=miniscore
      end
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
      score*=0.3 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        score=0
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
        score=0
      end
      if attacker.pbTooHigh?(PBStats::ACCURACY) && attacker.pbTooHigh?(PBStats::ATTACK)
        score*=0
      end
    when 0x2A # Cosmic Power
      miniscore = setupminiscore(attacker,opponent,skill,move,false,10,false,initialscores,scoreindex)
      if attacker.stages[PBStats::SPDEF]>0 || attacker.stages[PBStats::DEFENSE]>0
        ministat=attacker.stages[PBStats::SPDEF]
        ministat+=attacker.stages[PBStats::DEFENSE]
        minimini=-5*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      miniscore/=100.0
      score*=miniscore
      miniscore=100
      if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
        miniscore*=1.5
      end
      if (attitemworks && attacker.item == PBItems::LEFTOVERS) || ((attitemworks && attacker.item == PBItems::BLACKSLUDGE) && attacker.pbHasType?(:POISON))
        miniscore*=1.2
      end
      healmove=false
      for j in attacker.moves
        if j.isHealingMove?
          healmove=true
        end
      end
      if healmove
        miniscore*=1.7
      end
      if attacker.pbHasMove?((PBMoves::BODYPRESS)) || attacker.pbHasMove?((PBMoves::ULTRAMEGADEATH)) || attacker.pbHasMove?((PBMoves::STOREDPOWER)) || attacker.pbHasMove?((PBMoves::POWERTRIP))
        miniscore*=1.5
      end
      if attacker.pbHasMove?((PBMoves::LEECHSEED))
        miniscore*=1.3
      end
      if attacker.pbHasMove?((PBMoves::PAINSPLIT))
        miniscore*=1.2
      end
      if !attacker.pbTooHigh?(PBStats::SPDEF) || !attacker.pbTooHigh?(PBStats::DEFENSE)
        if skill>=PBTrainerAI.highSkill
          if move.id==(PBMoves::COSMICPOWER)
            if $fefieldeffect==29 || $fefieldeffect==34 || $fefieldeffect==35 # Holy/Starlight Arena/New World
              miniscore*=2
            end
            if $fefieldeffect==24 # Cosmic Power also raises general special, so it shouldbe preferred.
              miniscore*=1.5
            end
          end
          if move.id==(PBMoves::DEFENDORDER)
            if $fefieldeffect==15 # Forest
              miniscore*=2
            end
          end
        end
        miniscore/=100.0
        score*=miniscore
      end
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
      score*=0.3 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        score=0
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
        score=0
      end
      if attacker.pbTooHigh?(PBStats::SPDEF) && attacker.pbTooHigh?(PBStats::DEFENSE)
        score*=0
      end
    when 0x2B # Quiver Dance
      miniscore = setupminiscore(attacker,opponent,skill,move,true,28,false,initialscores,scoreindex)
      miniscore/=100.0
      score*=miniscore
      miniscore=100
      if attacker.stages[PBStats::SPEED]<0
        ministat=attacker.stages[PBStats::SPEED]
        minimini=5*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      ministat=0
      ministat+=opponent.stages[PBStats::ATTACK]
      ministat+=opponent.stages[PBStats::SPATK]
      ministat+=opponent.stages[PBStats::SPEED]
      if ministat>0
        minimini=(-5)*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      miniscore*=1.3 if checkAIhealing(aimem)
      if attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill) && @trickroom==0
        miniscore*=1.5
      end
      if roles.include?(PBMonRoles::SWEEPER)
        miniscore*=1.3
      end
      if attacker.status==PBStatuses::PARALYSIS
        miniscore*=0.5
      end
      if attacker.hp==attacker.totalhp && ((attacker.hasWorkingItem(:FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) && !attacker.moldbroken) || (isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST)))  && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
        miniscore*=1.4
      end
      miniscore*=0.6 if checkAIpriority(aimem)
      specmove=false
      for j in attacker.moves
        if j.pbIsSpecial?(j.type)
          specmove=true
        end
      end
      if specmove && !attacker.pbTooHigh?(PBStats::SPATK)
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect==6 # Big Top
            miniscore*=2
          end
        end
        miniscore/=100.0
        score*=miniscore
      end
      miniscore=100
      if attacker.effects[PBEffects::Toxic]>0
        miniscore*=0.2
      end
      if pbRoughStat(opponent,PBStats::SPATK,skill)>pbRoughStat(opponent,PBStats::ATTACK,skill)
        if !(roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL))
          if ((attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) && (attacker.hp.to_f)/attacker.totalhp>0.75
            miniscore*=1.3
          elsif (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
            miniscore*=0.7
          end
        end
        miniscore*=1.3
      end
      if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
        miniscore*=1.3
      end
      if (attitemworks && attacker.item == PBItems::LEFTOVERS) || ((attitemworks && attacker.item == PBItems::BLACKSLUDGE) && attacker.pbHasType?(:POISON))
        miniscore*=1.2
      end
      healmove=false
      for j in attacker.moves
        if j.isHealingMove?
          healmove=true
        end
      end
      if healmove
        miniscore*=1.3
      end
      if attacker.pbHasMove?((PBMoves::LEECHSEED))
        miniscore*=1.3
      end
      if attacker.pbHasMove?((PBMoves::PAINSPLIT))
        miniscore*=1.2
      end
      if !attacker.pbTooHigh?(PBStats::SPDEF)
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect==6 # Big Top
            miniscore*=2
          end
        end
        miniscore/=100.0
        score*=miniscore
      end
      miniscore=100
      if attacker.stages[PBStats::SPATK]<0
        ministat=attacker.stages[PBStats::SPATK]
        minimini=5*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        miniscore*=0.8
      end
      if @trickroom!=0
        miniscore*=0.2
      else
        miniscore*=0.2 if checkAImoves([PBMoves::TRICKROOM],aimem)
      end
      if !attacker.pbTooHigh?(PBStats::SPEED)
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect==6 # Big Top
            miniscore*=2
          end
        end
        miniscore/=100.0
        score*=miniscore
      end
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
      score*=0.3 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        score=0
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
        score=0
      end
      if attacker.pbTooHigh?(PBStats::SPATK) && attacker.pbTooHigh?(PBStats::SPDEF) && attacker.pbTooHigh?(PBStats::SPEED)
        score*=0
      end
    when 0x2C # Calm Mind
      miniscore = setupminiscore(attacker,opponent,skill,move,true,12,false,initialscores,scoreindex)
      miniscore/=100.0
      score*=miniscore
      miniscore=100
      if attacker.stages[PBStats::SPEED]<0
        ministat=attacker.stages[PBStats::SPEED]
        minimini=5*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      ministat=0
      ministat+=opponent.stages[PBStats::ATTACK]
      ministat+=opponent.stages[PBStats::SPATK]
      ministat+=opponent.stages[PBStats::SPEED]
      if ministat>0
        minimini=(-5)*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      if attacker.stages[PBStats::SPDEF]>0 || attacker.stages[PBStats::SPATK]>0
        ministat=attacker.stages[PBStats::SPDEF]
        ministat+=attacker.stages[PBStats::SPATK]
        minimini=-5*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      miniscore*=1.3 if checkAIhealing(aimem)
      if attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill) && @trickroom==0
        miniscore*=1.5
      end
      if roles.include?(PBMonRoles::SWEEPER)
        miniscore*=1.3
      end
      if attacker.status==PBStatuses::PARALYSIS
        miniscore*=0.5
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::SPEEDBOOST)
        miniscore*=0.6
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEAMENGINE)
        if $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==21 || $fefieldeffect==22 || $fefieldeffect==45
          miniscore*=0.6
        end
      end
      if attacker.pbHasMove?((PBMoves::ULTRAMEGADEATH))
        miniscore*=1.5
      end
      specmove=false
      for j in attacker.moves
        if j.pbIsSpecial?(j.type) 
          specmove=true
        end
      end
      if specmove && !attacker.pbTooHigh?(PBStats::SPATK)
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect==5 || $fefieldeffect==20 || $fefieldeffect==37 # Chess/Ashen Beach/Psychic Terrain
            miniscore*=1.5
          end
        end
        miniscore/=100.0
        score*=miniscore
      end
      miniscore=100
      if attacker.effects[PBEffects::Toxic]>0
        miniscore*=0.2
      end
      if pbRoughStat(opponent,PBStats::SPATK,skill)>pbRoughStat(opponent,PBStats::ATTACK,skill)
        if !(roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL))
          if ((attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) && (attacker.hp.to_f)/attacker.totalhp>0.75
            miniscore*=1.3
          elsif (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
            miniscore*=0.7
          end
        end
        miniscore*=1.3
      end
      if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
        miniscore*=1.3
      end
      if (attitemworks && attacker.item == PBItems::LEFTOVERS) || ((attitemworks && attacker.item == PBItems::BLACKSLUDGE) && attacker.pbHasType?(:POISON))
        miniscore*=1.2
      end
      healmove=false
      for j in attacker.moves
        if j.isHealingMove?
          healmove=true
        end
      end
      if healmove
        miniscore*=1.4
      end
      if attacker.pbHasMove?((PBMoves::LEECHSEED))
        miniscore*=1.3
      end
      if attacker.pbHasMove?((PBMoves::PAINSPLIT))
        miniscore*=1.2
      end
      if !attacker.pbTooHigh?(PBStats::SPDEF)
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect==5 || $fefieldeffect==20 || $fefieldeffect==37 # Chess/Ashen Beach/Psychic Terrain
            miniscore*=1.5
          end
        end
        miniscore/=100.0
        score*=miniscore
      end
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
      score*=0.3 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        score=0
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
        score=0
      end
      if attacker.pbTooHigh?(PBStats::SPATK) && attacker.pbTooHigh?(PBStats::SPDEF)
        score*=0
      end
    when 0x2D # Ancient power
      if move.zmove && move.name=="Extreme Evoboost" 
        miniscore = setupminiscore(attacker,opponent,skill,move,false,10,false,initialscores,scoreindex)
        if opponent.status==PBStatuses::SLEEP || opponent.status==PBStatuses::FROZEN
          miniscore*=1.3
        end
        if roles.include?(PBMonRoles::BATONPASSER)
          miniscore*=1.5
        end
      else
        miniscore=100
        miniscore*=2
        if score == 110
          miniscore *= 1.2
        end
        if (attacker.hp.to_f)/attacker.totalhp>0.75
          miniscore*=1.1
        end
        if opponent.effects[PBEffects::HyperBeam]>0
          miniscore*=1.2
        end
        if opponent.effects[PBEffects::Yawn]>0
          miniscore*=1.3
        end
        if skill>=PBTrainerAI.mediumSkill
          maxdam = checkAIdamage(aimem,attacker,opponent,skill)
          if maxdam<(attacker.hp/3.0) 
            miniscore*=1.1
          else
            if move.basedamage==0
              miniscore*=0.8
              if maxdam>attacker.hp
                miniscore*=0.1
              end
            end
          end
        end
        if attacker.turncount<2
          miniscore*=1.1
        end
        if opponent.status!=0
          miniscore*=1.1
        end
        if opponent.status==PBStatuses::SLEEP || opponent.status==PBStatuses::FROZEN
          miniscore*=1.3
        end
        if opponent.effects[PBEffects::Encore]>0
          if opponent.moves[(opponent.effects[PBEffects::EncoreIndex])].basedamage==0
            miniscore*=1.3
          end
        end
        miniscore*=0.2 if checkAImoves(PBStuff::SWITCHOUTMOVE,aimem)
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::SIMPLE)
          miniscore*=2
        end
        if @doublebattle
          miniscore*=0.3
        end
        if attacker.hp==attacker.totalhp && ((attacker.hasWorkingItem(:FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) && !attacker.moldbroken) || (isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST)))  && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
          miniscore*=1.4
        end
      end
      miniscore*=0.6 if checkAIpriority(aimem)
      miniscore-=100
      if move.zmove && move.name=="Extreme Evoboost" 
        miniscore*=1.5
      else
        if move.addlEffect.to_f != 100
          miniscore*=(move.addlEffect.to_f/100)
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
            miniscore*=2
          end
        end
      end
      miniscore+=100
      miniscore/=100.0
      if attacker.pbTooHigh?(PBStats::ATTACK) && attacker.pbTooHigh?(PBStats::DEFENSE) && attacker.pbTooHigh?(PBStats::SPATK) && attacker.pbTooHigh?(PBStats::SPDEF) && attacker.pbTooHigh?(PBStats::SPEED)
        miniscore=0
      end
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
      miniscore*=0 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        score *= 0.9
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
        miniscore*=0.9
      end
      if miniscore > 1
        score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !hasgreatmoves(initialscores,scoreindex,skill,true)
      end
    when 0x2E # Swords Dance
      miniscore = setupminiscore(attacker,opponent,skill,move,true,1,true,initialscores,scoreindex)
      if attacker.stages[PBStats::SPEED]<0
        ministat=attacker.stages[PBStats::SPEED]
        minimini=5*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      ministat=0
      ministat+=opponent.stages[PBStats::ATTACK]
      ministat+=opponent.stages[PBStats::SPATK]
      ministat+=opponent.stages[PBStats::SPEED]
      sweeping = setupminiscore(attacker,opponent,skill,move,true,1,false,initialscores,scoreindex,true)
      if sweeping == false
        if ministat>0
          minimini=(-5)*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
      end
      miniscore*=1.3 if checkAIhealing(aimem)
      attackerpridam=0
      for m in attacker.moves
        if m.priority>0 || (m.type==PBTypes::FLYING && attacker.ability == PBAbilities::GALEWINGS && (attacker.hp==attacker.totalhp || (($fefieldeffect == 16 || $fefieldeffect == 27 || $fefieldeffect == 28) && pbWeather == PBWeather::STRONGWINDS) || $fefieldeffect == 43)) ||
          (attacker.species==PBSpecies::FERALIGATR && attacker.item == PBItems::FERACREST && attacker.turncount==0) ||
          (attacker.ability == PBAbilities::TRIAGE && (PBStuff::HEALFUNCTIONS).include?(m.function) && m.basedamage>0)
          tempdam=pbRoughDamage(m,attacker,opponent,skill,m.basedamage) 
          if tempdam>attackerpridam
            attackerpridam=tempdam
          end
        end
      end
      if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill) && @trickroom==0)
        miniscore*=1.3
      end
      if roles.include?(PBMonRoles::SWEEPER)
        miniscore*=1.3
      end
      if (attacker.status==PBStatuses::BURN && !(attacker.ability==PBAbilities::GUTS) || attacker.status==PBStatuses::PARALYSIS)
        miniscore*=0.5
      end
      miniscore*=0.2 if checkAImoves([PBMoves::FOULPLAY],aimem)
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::SPEEDBOOST)
        miniscore*=0.6
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEAMENGINE)
        if $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==21 || $fefieldeffect==22 || $fefieldeffect==45
          miniscore*=0.6
        end
      end
      if skill>=PBTrainerAI.highSkill
        if move.id==(PBMoves::SWORDSDANCE)
          if $fefieldeffect==6 || $fefieldeffect==31  # Big Top/Fairy Tale
            miniscore*=1.5
          end
        end
      end
      miniscore/=100.0
      if attacker.pbTooHigh?(PBStats::ATTACK)
        miniscore=0
      end
      score*=0.3 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        miniscore*=0
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
        miniscore*=1
      end
      physmove=false
      for j in attacker.moves
        if j.pbIsPhysical?(j.type)
          physmove=true
        end
      end
      miniscore=0 if !physmove
      score*=miniscore
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
    when 0x2F # Iron Defense
      miniscore = setupminiscore(attacker,opponent,skill,move,false,2,true,initialscores,scoreindex)
      if attacker.stages[PBStats::DEFENSE]>0
        ministat=attacker.stages[PBStats::DEFENSE]
        minimini=-15*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      if pbRoughStat(opponent,PBStats::ATTACK,skill)>pbRoughStat(opponent,PBStats::SPATK,skill)
        miniscore*=1.3
      end
      if skill>=PBTrainerAI.mediumSkill
        maxdam = checkAIdamage(aimem,attacker,opponent,skill)
        if (maxdam.to_f/attacker.hp)<0.12 
          miniscore*=0.3
        end
      end
      if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
        miniscore*=1.3
      end
      if (attitemworks && attacker.item == PBItems::LEFTOVERS) || ((attitemworks && attacker.item == PBItems::BLACKSLUDGE) && attacker.pbHasType?(:POISON))
        miniscore*=1.2
      end
      healmove=false
      for j in attacker.moves
        if j.isHealingMove?
          healmove=true
        end
      end
      if healmove
        miniscore*=1.3
      end
      if attacker.pbHasMove?((PBMoves::LEECHSEED))
        miniscore*=1.3
      end
      if attacker.pbHasMove?((PBMoves::PAINSPLIT))
        miniscore*=1.2
      end
      if skill>=PBTrainerAI.highSkill
        if move.id==(PBMoves::IRONDEFENSE)
          if $fefieldeffect==17 # Factory
            miniscore*=1.5
          end
        end
        if move.id==(PBMoves::DIAMONDSTORM)
          if $fefieldeffect==23 # Cave
            miniscore*=1.5
          end
        end
      end
      if move.basedamage>0
        miniscore-=100
        if move.addlEffect.to_f != 100
          miniscore*=(move.addlEffect.to_f/100)
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
            miniscore*=2
          end
        end
        miniscore+=100
        miniscore/=100.0
        if attacker.pbTooHigh?(PBStats::DEFENSE)
          miniscore=1
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
          miniscore*=0.5
        end
        score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !hasgreatmoves(initialscores,scoreindex,skill,true)
      else
        miniscore/=100.0
        if attacker.pbTooHigh?(PBStats::DEFENSE)
          miniscore=0
        end
        miniscore*=0 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
          miniscore*=0
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
          miniscore*=1
        end
        score*=miniscore
      end
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
    when 0x30 # Agility
      miniscore = setupminiscore(attacker,opponent,skill,move,true,16,true,initialscores,scoreindex)
      if attacker.attack<attacker.spatk
        if attacker.stages[PBStats::SPATK]<0
          ministat=attacker.stages[PBStats::SPATK]
          minimini=5*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
      else
        if attacker.stages[PBStats::ATTACK]<0
          ministat=attacker.stages[PBStats::ATTACK]
          minimini=5*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
      end
      ministat=0
      ministat+=opponent.stages[PBStats::DEFENSE]
      ministat+=opponent.stages[PBStats::SPDEF]
      if ministat>0
        minimini=(-5)*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        miniscore*=0.3
        livecount=0
        for i in pbParty(opponent.index)
          next if i.nil?
          livecount+=1 if i.hp!=0
        end
        if livecount==1
          miniscore*=0.1
        end
      end
      if roles.include?(PBMonRoles::SWEEPER)
        miniscore*=1.3
      end
      if @trickroom!=0
        miniscore*=0.2
      else
        miniscore*=0.2 if checkAImoves([PBMoves::TRICKROOM],aimem)
      end
      if attacker.status==PBStatuses::PARALYSIS
        miniscore*=0.2
      end
      if attacker.item == PBItems::WEAKNESSPOLICY 
        miniscore*=1.5
      end
      if attacker.hp==attacker.totalhp && ((attacker.hasWorkingItem(:FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) && !attacker.moldbroken) || (isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST)))  && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
        miniscore*=1.4
      end
      miniscore*=0.6 if checkAIpriority(aimem)
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::SPEEDBOOST)
        miniscore*=0.6
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEAMENGINE)
        if $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==21 || $fefieldeffect==22 || $fefieldeffect==45
          miniscore*=0.6
        end
      end
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::MOXIE) || SilvallyCheck(attacker,PBTypes::FIRE)
        miniscore*=1.3
      end
      if skill>=PBTrainerAI.highSkill
        if move.id==(PBMoves::ROCKPOLISH)
          if $fefieldeffect==14 # Rocky Field
            miniscore*=1.5
          end
          if $fefieldeffect==25 # Crystal Cavern
            miniscore*=2
          end
        end
      end
      miniscore/=100.0
      if attacker.pbTooHigh?(PBStats::SPEED)
        miniscore=0
      end
      score*=0.3 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        miniscore*=0
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
        miniscore*=1
      end
      score*=miniscore
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
    when 0x31 # Autotomize
      miniscore = setupminiscore(attacker,opponent,skill,move,true,16,true,initialscores,scoreindex)
      if attacker.attack<attacker.spatk
        if attacker.stages[PBStats::SPATK]<0
          ministat=attacker.stages[PBStats::SPATK]
          minimini=5*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
      else
        if attacker.stages[PBStats::ATTACK]<0
          ministat=attacker.stages[PBStats::ATTACK]
          minimini=5*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
      end
      ministat=0
      ministat+=opponent.stages[PBStats::DEFENSE]
      ministat+=opponent.stages[PBStats::SPDEF]
      if ministat>0
        minimini=(-5)*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        miniscore*=0.3
        livecount=0
        for i in pbParty(opponent.index)
          next if i.nil?
          livecount+=1 if i.hp!=0
        end
        if livecount==1
          miniscore*=0.1
        end
      end
      if roles.include?(PBMonRoles::SWEEPER)
        miniscore*=1.3
      end
      if @trickroom!=0
        miniscore*=0.2
      else
        miniscore*=0.2 if checkAImoves([PBMoves::TRICKROOM],aimem)
      end
      if attacker.status==PBStatuses::PARALYSIS
        miniscore*=0.2
      end
      if attacker.hp==attacker.totalhp && ((attacker.hasWorkingItem(:FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) && !attacker.moldbroken) || (isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST)))  && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
        miniscore*=1.4
      end
      miniscore*=0.6 if checkAIpriority(aimem)
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::SPEEDBOOST)
        miniscore*=0.6
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEAMENGINE)
        if $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==21 || $fefieldeffect==22 || $fefieldeffect==45
          miniscore*=0.6
        end
      end
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::MOXIE) || SilvallyCheck(attacker,PBTypes::FIRE)
        miniscore*=1.3
      end
      if skill>=PBTrainerAI.highSkill
        if $fefieldeffect==17 # Factory
          miniscore*=1.5
        end
      end
      miniscore*=1.5 if checkAImoves([PBMoves::LOWKICK,PBMoves::GRASSKNOT],aimem)
      miniscore*=0.5 if checkAImoves([PBMoves::HEATCRASH,PBMoves::HEAVYSLAM],aimem)
      if attacker.pbHasMove?((PBMoves::HEATCRASH)) || attacker.pbHasMove?((PBMoves::HEAVYSLAM))
        miniscore*=0.8
      end
      miniscore/=100.0
      if attacker.pbTooHigh?(PBStats::SPEED)
        miniscore=0
      end
      score*=0.3 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        miniscore*=0
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
        miniscore*=1
      end
      score*=miniscore
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
    when 0x32 # Nasty Plot
      miniscore = setupminiscore(attacker,opponent,skill,move,true,4,true,initialscores,scoreindex)
      maxdam=checkAIdamage(aimem,attacker,opponent,skill)
      if attacker.stages[PBStats::SPEED]<0
        ministat=attacker.stages[PBStats::SPEED]
        minimini=5*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      ministat=0
      ministat+=opponent.stages[PBStats::ATTACK]
      ministat+=opponent.stages[PBStats::SPATK]
      ministat+=opponent.stages[PBStats::SPEED]
      if ministat>0
        minimini=(-5)*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      miniscore*=1.3 if checkAIhealing(aimem)
      if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill) && @trickroom==0) 
        miniscore*=1.3
      end
      if roles.include?(PBMonRoles::SWEEPER)
        miniscore*=1.3
      end
      if attacker.status==PBStatuses::PARALYSIS
        miniscore*=0.5
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::SPEEDBOOST)
        miniscore*=0.6
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEAMENGINE)
        if $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==21 || $fefieldeffect==22 || $fefieldeffect==45
          miniscore*=0.6
        end
      end
      if skill>=PBTrainerAI.highSkill
        if $fefieldeffect==5 || $fefieldeffect==37 # Chess/Psychic Terrain
          miniscore*=1.2
        end
      end
      miniscore/=100.0
      if attacker.pbTooHigh?(PBStats::SPATK)
        miniscore=0
      end
      score*=0.3 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        miniscore*=0
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
        miniscore*=1
      end
      specmove=false
      for j in attacker.moves
        if j.pbIsSpecial?(j.type)
          specmove=true
        end
      end
      miniscore=0 if !specmove
      score*=miniscore
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
    when 0x33 # Amnesia
      miniscore = setupminiscore(attacker,opponent,skill,move,false,0,true,initialscores,scoreindex)
      if attacker.stages[PBStats::SPDEF]>0
        ministat=attacker.stages[PBStats::SPDEF]
        minimini=-15*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      if pbRoughStat(opponent,PBStats::ATTACK,skill)<pbRoughStat(opponent,PBStats::SPATK,skill)
        miniscore*=1.3
      end
      if skill>=PBTrainerAI.mediumSkill
        maxdam = checkAIdamage(aimem,attacker,opponent,skill)
        if (maxdam.to_f/attacker.hp)<0.12 
          miniscore*=0.3
        end
      end
      if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
        miniscore*=1.3
      end
      if (attitemworks && attacker.item == PBItems::LEFTOVERS) || ((attitemworks && attacker.item == PBItems::BLACKSLUDGE) && attacker.pbHasType?(:POISON))
        miniscore*=1.2
      end
      healmove=false
      for j in attacker.moves
        if j.isHealingMove?
          healmove=true
        end
      end
      if healmove
        miniscore*=1.3
      end
      if attacker.pbHasMove?((PBMoves::LEECHSEED))
        miniscore*=1.3
      end
      if attacker.pbHasMove?((PBMoves::PAINSPLIT))
        miniscore*=1.2
      end
      miniscore/=100.0
      if attacker.pbTooHigh?(PBStats::SPDEF)
        miniscore=0
      end
      score*=0.3 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        miniscore*=0
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
        miniscore*=1
      end
      score*=miniscore
      if skill>=PBTrainerAI.highSkill
        if $fefieldeffect==25 # Glitch
          score *= 2
        end
      end
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
    when 0x34 # Minimize
      miniscore = setupminiscore(attacker,opponent,skill,move,false,0,true,initialscores,scoreindex)
      if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
        miniscore*=1.3
      end
      if (attitemworks && attacker.item == PBItems::LEFTOVERS) || ((attitemworks && attacker.item == PBItems::BLACKSLUDGE) && attacker.pbHasType?(:POISON))
        miniscore*=1.2
      end
      healmove=false
      for j in attacker.moves
        if j.isHealingMove?
          healmove=true
        end
      end
      if healmove
        miniscore*=1.3
      end
      if attacker.pbHasMove?((PBMoves::LEECHSEED))
        miniscore*=1.3
      end
      if attacker.pbHasMove?((PBMoves::PAINSPLIT))
        miniscore*=1.2
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::NOGUARD) || checkAIaccuracy(aimem)
        miniscore*=0.2
      end
      if (attitemworks && (attacker.item == PBItems::BRIGHTPOWDER || attacker.item == PBItems::LAXINCENSE)) ||
        ((!attacker.abilitynulled && attacker.ability == PBAbilities::SANDVEIL) && pbWeather==PBWeather::SANDSTORM) ||
        ((!attacker.abilitynulled && attacker.ability == PBAbilities::SNOWCLOAK) && pbWeather==PBWeather::HAIL)
        miniscore*=1.3
      end
      miniscore/=100.0
      if attacker.pbTooHigh?(PBStats::EVASION)
        miniscore=0
      end
      score*=0.3 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        miniscore*=0
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
        miniscore*=1
      end
      score*=miniscore
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
    when 0x35 # Shell Smash
      miniscore = setupminiscore(attacker,opponent,skill,move,true,21,true,initialscores,scoreindex)
      miniscore/=100.0
      score*=miniscore
      miniscore=100
      miniscore*=1.3 if checkAIhealing(aimem)
      if attacker.pbSpeed<=pbRoughStat(opponent,PBStats::SPEED,skill) && (2*attacker.pbSpeed)>pbRoughStat(opponent,PBStats::SPEED,skill) && @trickroom==0
        miniscore*=1.3
      end
      if roles.include?(PBMonRoles::SWEEPER)
        miniscore*=1.5
      end
      specmove=false
      for j in attacker.moves
        if j.pbIsSpecial?(j.type)
          specmove=true
        end
      end
      if attacker.status==PBStatuses::BURN && !specmove
        miniscore*=0.5
      end
      if attacker.status==PBStatuses::PARALYSIS
        miniscore*=0.5
      end
      if attacker.hp==attacker.totalhp && ((attacker.hasWorkingItem(:FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) && !attacker.moldbroken) || (isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST)))  && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
        miniscore*=1.5
      end
      miniscore*=0.2 if checkAIpriority(aimem)
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::SPEEDBOOST)
        miniscore*=0.6
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEAMENGINE)
        if $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==21 || $fefieldeffect==22 || $fefieldeffect==45
          miniscore*=0.6
        end
      end
      miniscore/=100.0
      score*=miniscore
      miniscore=100
      if (attitemworks && attacker.item == PBItems::WHITEHERB)
        miniscore *= 1.5
      else
        if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
          miniscore*=0.1
        end
      end
      if @trickroom!=0
        miniscore*=0.2
      else
        miniscore*=0.2 if checkAImoves([PBMoves::TRICKROOM],aimem)
      end
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::MOXIE) || SilvallyCheck(attacker,PBTypes::FIRE)
        miniscore*=1.3
      end
      if (attitemworks && attacker.item == PBItems::WHITEHERB)
        miniscore*=1.5
      end
      if !attacker.pbTooHigh?(PBStats::SPEED)
        miniscore/=100.0
        score*=miniscore
      end
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
      healmove=false
      for j in attacker.moves
        if j.isHealingMove?
          healmove=true
        end
      end
      score*=0.3 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY) && !healmove
        score=0
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
        score=0
      end
    when 0x36 # Shift Gear
      miniscore = setupminiscore(attacker,opponent,skill,move,true,17,false,initialscores,scoreindex)
      ministat=0
      ministat+=opponent.stages[PBStats::ATTACK]
      ministat+=opponent.stages[PBStats::SPATK]
      ministat+=opponent.stages[PBStats::SPEED]
      if ministat>0
        minimini=(-5)*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      miniscore/=100.0
      score*=miniscore
      miniscore=100
      miniscore*=1.3 if checkAIhealing(aimem)
      if (attacker.pbSpeed<=pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        miniscore*=1.3
      end
      if roles.include?(PBMonRoles::SWEEPER)
        miniscore*=1.5
      end
      if attacker.status==PBStatuses::BURN || attacker.status==PBStatuses::PARALYSIS
        miniscore*=0.5
      end
      miniscore*=0.3 if checkAImoves([PBMoves::FOULPLAY],aimem)
      if attacker.hp==attacker.totalhp && ((attacker.hasWorkingItem(:FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) && !attacker.moldbroken) || (isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST)))  && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
        miniscore*=1.4
      end
      miniscore*=0.6 if checkAIpriority(aimem)
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::SPEEDBOOST)
        miniscore*=0.6
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEAMENGINE)
        if $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==21 || $fefieldeffect==22 || $fefieldeffect==45
          miniscore*=0.6
        end
      end
      physmove=false
      for j in attacker.moves
        if j.pbIsPhysical?(j.type)
          physmove=true
        end
      end
      if physmove && !attacker.pbTooHigh?(PBStats::ATTACK)
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect==17 # Factory Field
            miniscore*=1.5
          end
        end
        miniscore/=100.0
        score*=miniscore
      end
      miniscore=100
      if attacker.stages[PBStats::ATTACK]<0
        ministat=attacker.stages[PBStats::ATTACK]
        minimini=5*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        miniscore*=0.8
      end
      if @trickroom!=0 || checkAImoves([PBMoves::TRICKROOM],aimem)
        miniscore*=0.1
      end
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::MOXIE) || SilvallyCheck(attacker,PBTypes::FIRE)
        miniscore*=1.3
      end
      if !attacker.pbTooHigh?(PBStats::SPEED)
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect==17 # Factory Field
            miniscore*=1.5
          end
        end
        miniscore/=100.0
        score*=miniscore
      end
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
      score*=0.3 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        score=0
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
        score = 0
      end
    when 0x37 # Acupressure
      miniscore = setupminiscore(attacker,opponent,skill,move,false,0,false,initialscores,scoreindex)
      if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
        miniscore*=1.3
      end
      if (attitemworks && attacker.item == PBItems::LEFTOVERS) || ((attitemworks && attacker.item == PBItems::BLACKSLUDGE) && attacker.pbHasType?(:POISON))
        miniscore*=1.2
      end
      healmove=false
      for j in attacker.moves
        if j.isHealingMove?
          healmove=true
        end
      end
      if healmove
        miniscore*=1.3
      end
      if attacker.pbHasMove?((PBMoves::LEECHSEED))
        miniscore*=1.3
      end
      if attacker.pbHasMove?((PBMoves::PAINSPLIT))
        miniscore*=1.2
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::NOGUARD) || checkAIaccuracy(aimem)
        miniscore*=0.2
      end
      if (attitemworks && attacker.item == PBItems::BRIGHTPOWDER) || (attitemworks && attacker.item == PBItems::LAXINCENSE) ||
        ((!attacker.abilitynulled && attacker.ability == PBAbilities::SANDVEIL) && pbWeather==PBWeather::SANDSTORM) ||
        ((!attacker.abilitynulled && attacker.ability == PBAbilities::SNOWCLOAK) && pbWeather==PBWeather::HAIL)
        miniscore*=1.3
      end
      miniscore/=100.0
      maxstat=0
      maxstat+=1 if attacker.pbTooHigh?(PBStats::ATTACK)
      maxstat+=1 if attacker.pbTooHigh?(PBStats::DEFENSE)
      maxstat+=1 if attacker.pbTooHigh?(PBStats::SPATK)
      maxstat+=1 if attacker.pbTooHigh?(PBStats::SPDEF)
      maxstat+=1 if attacker.pbTooHigh?(PBStats::SPEED)
      maxstat+=1 if attacker.pbTooHigh?(PBStats::ACCURACY)
      maxstat+=1 if attacker.pbTooHigh?(PBStats::EVASION)
      if maxstat>1
        miniscore=0
      end
      score*=0.3 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        miniscore*=0
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
        miniscore*=1
      end
      score*=miniscore
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
    when 0x38 # Cotton Guard
      miniscore = setupminiscore(attacker,opponent,skill,move,false,2,true,initialscores,scoreindex)
      if attacker.stages[PBStats::DEFENSE]>0
        ministat=attacker.stages[PBStats::DEFENSE]
        minimini=-15*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      if pbRoughStat(opponent,PBStats::ATTACK,skill)>pbRoughStat(opponent,PBStats::SPATK,skill)
        miniscore*=1.3
      end
      if skill>=PBTrainerAI.mediumSkill
        maxdam = checkAIdamage(aimem,attacker,opponent,skill)
        if (maxdam.to_f/attacker.hp)<0.12 
          miniscore*=0.3
        end
      end
      if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
        miniscore*=1.3
      end
      if (attitemworks && attacker.item == PBItems::LEFTOVERS) || ((attitemworks && attacker.item == PBItems::BLACKSLUDGE) && attacker.pbHasType?(:POISON))
        miniscore*=1.2
      end
      healmove=false
      for j in attacker.moves
        if j.isHealingMove?
          healmove=true
        end
      end
      if healmove
        miniscore*=1.3
      end
      if attacker.pbHasMove?((PBMoves::LEECHSEED))
        miniscore*=1.3
      end
      if attacker.pbHasMove?((PBMoves::PAINSPLIT))
        miniscore*=1.2
      end
      miniscore/=100.0
      if attacker.pbTooHigh?(PBStats::DEFENSE)
        miniscore=0
      end
      score*=0.3 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        miniscore*=0
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
        miniscore*=1
      end
      score*=miniscore
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
    when 0x39 # Tail Glow
      miniscore = setupminiscore(attacker,opponent,skill,move,true,4,true,initialscores,scoreindex)
      if attacker.stages[PBStats::SPEED]<0
        ministat=attacker.stages[PBStats::SPEED]
        minimini=5*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      ministat=0
      ministat+=opponent.stages[PBStats::ATTACK]
      ministat+=opponent.stages[PBStats::SPATK]
      ministat+=opponent.stages[PBStats::SPEED]
      if ministat>0
        minimini=(-5)*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      miniscore*=1.3 if checkAIhealing(aimem)
      if attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill) && @trickroom==0
        miniscore*=1.5
      end
      if roles.include?(PBMonRoles::SWEEPER)
        miniscore*=1.3
      end
      if attacker.status==PBStatuses::PARALYSIS
        miniscore*=0.5
      end
      if attacker.hp==attacker.totalhp && ((attacker.hasWorkingItem(:FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) && !attacker.moldbroken) || (isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST)))  && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
        miniscore*=1.4
      end
      miniscore*=0.6 if checkAIpriority(aimem)
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::SPEEDBOOST)
        miniscore*=0.6
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEAMENGINE)
        if $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==21 || $fefieldeffect==22 || $fefieldeffect==45
          miniscore*=0.6
        end
      end
      miniscore/=100.0
      if attacker.pbTooHigh?(PBStats::SPATK)
        miniscore=0
      end
      score*=0.3 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        miniscore*=0
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
        miniscore*=1
      end
      specmove=false
      for j in attacker.moves
        if j.pbIsSpecial?(j.type)
          specmove=true
        end
      end
      miniscore=0 if !specmove
      score*=miniscore
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
    when 0x3A # Belly Drum
      miniscore=100
      specmove=false
      for j in opponent.moves
        if j.pbIsSpecial?(j.type)
          specmove=true
        end
      end
      if attacker.effects[PBEffects::Substitute]>0 || attacker.effects[PBEffects::Disguise] || (attacker.effects[PBEffects::IceFace] && !specmove) || (attacker.effects[PBEffects::IceFace] && $fefieldeffect==39)
        miniscore*=1.5
      end
      if initialscores.length>0
        miniscore*=1.3 if hasbadmoves(initialscores,scoreindex,20)
      end
      if (attacker.hp.to_f)/attacker.totalhp>0.85
        miniscore*=1.2
      end
      if opponent.effects[PBEffects::HyperBeam]>0
        miniscore*=1.5
      end
      if opponent.effects[PBEffects::Yawn]>0
        miniscore*=1.7
      end
      if skill>=PBTrainerAI.mediumSkill
        maxdam = checkAIdamage(aimem,attacker,opponent,skill)
        if maxdam<(attacker.hp/4.0)
          miniscore*=1.4
        else
          if move.basedamage==0
            miniscore*=0.8
            if maxdam>attacker.hp
              miniscore*=0.1
            end
          end
        end
      else
        if move.basedamage==0
          effcheck = PBTypes.getCombinedEffectiveness(opponent.type1,attacker.type1,attacker.type2)
          if effcheck > 4
            miniscore*=0.5
          end
          effcheck2 = PBTypes.getCombinedEffectiveness(opponent.type2,attacker.type1,attacker.type2)
          if effcheck2 > 4
            miniscore*=0.5
          end
        end
      end
      if attacker.turncount<1
        miniscore*=1.2
      end
      if opponent.status!=0
        miniscore*=1.2
      end
      if opponent.status==PBStatuses::SLEEP || opponent.status==PBStatuses::FROZEN
        miniscore*=1.4
      end
      if opponent.effects[PBEffects::Encore]>0
        if opponent.moves[(opponent.effects[PBEffects::EncoreIndex])].basedamage==0
          miniscore*=1.5
        end
      end
      if attacker.effects[PBEffects::Confusion]>0
        miniscore*=0.1
      end
      if attacker.effects[PBEffects::LeechSeed]>=0 || attacker.effects[PBEffects::Attract]>=0
        miniscore*=0.2
      end
      miniscore*=0.1 if checkAImoves(PBStuff::SWITCHOUTMOVE,aimem)
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE)
        miniscore*=0
      end
      if @doublebattle
        miniscore*=0.1
      end
      if attacker.stages[PBStats::SPEED]<0
        ministat=attacker.stages[PBStats::SPEED]
        minimini=10*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      ministat=0
      ministat+=opponent.stages[PBStats::ATTACK]
      ministat+=opponent.stages[PBStats::SPATK]
      ministat+=opponent.stages[PBStats::SPEED]
      if ministat>0
        minimini=(-10)*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      miniscore*=1.3 if checkAIhealing(aimem)
      if attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill) && @trickroom==0
        miniscore*=1.5
      else
        primove=false
        for j in attacker.moves
          if j.priority>0
            primove=true
          end
        end
        if !primove
          miniscore*=0.3
        end
      end
      if roles.include?(PBMonRoles::SWEEPER)
        miniscore*=1.3
      end
      if attacker.status==PBStatuses::BURN
        miniscore*=0.8
      end
      if attacker.status==PBStatuses::PARALYSIS
        miniscore*=0.2
      end
      miniscore*=0.1 if checkAImoves([PBMoves::FOULPLAY],aimem)
      miniscore*=0.1 if checkAIpriority(aimem)
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::SPEEDBOOST)
        miniscore*=0.6
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEAMENGINE)
        if $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==21 || $fefieldeffect==22 || $fefieldeffect==45
          miniscore*=0.6
        end
      end
      if skill>=PBTrainerAI.highSkill
        if $fefieldeffect==6  # Big Top
          miniscore*=1.5
        end
      end
      miniscore/=100.0
      if attacker.pbTooHigh?(PBStats::ATTACK)
        miniscore=0
      end
      score*=0.3 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        miniscore*=0
      end
      physmove=false
      for j in attacker.moves
        if j.pbIsPhysical?(j.type)
          physmove=true
        end
      end
      miniscore=0 if !physmove
      score*=miniscore
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
    when 0x3B # Superpower
      thisinitial = score
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        score*=1.7
      else
        if thisinitial<100
          score*=0.9
          if (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
            score*=1.2
          else
            score*=0.5 if checkAIhealing(aimem)
          end
        end
        if initialscores.length>0
          score*=0.7 if hasgreatmoves(initialscores,scoreindex,skill)
        end
        miniscore=100
        livecount=0
        for i in pbParty(opponent.index)
          next if i.nil?
          livecount+=1 if i.hp!=0
        end
        if livecount>1
          miniscore*=(livecount-3)
          miniscore/=100.0
          miniscore*=0.05
          miniscore=(1-miniscore)
          score*=miniscore
        end
        count=-1
        party=pbParty(attacker.index)
        pivotvar=false
        for i in 0...party.length
          count+=1
          next if party[i].nil?
          temproles = pbGetMonRole(party[i],opponent,skill,count,party)
          if temproles.include?(PBMonRoles::PIVOT)
            pivotvar=true
          end
        end
        if pivotvar && !@doublebattle
          score*=1.2
        end
        livecount2=0
        for i in pbParty(attacker.index)
          next if i.nil?
          livecount2+=1 if i.hp!=0
        end
        if livecount>1 && livecount2==1
          score*=0.8
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::MOXIE)
          score*=1.5
        end
      end
    when 0x3C # Close Combat
      thisinitial = score
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        score*=1.5
      else
        if thisinitial<100
          score*=0.9
          if (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
            score*=1.3
          end
          score*=0.7 if checkAIhealing(aimem)
        end
        if initialscores.length>0
          score*=0.7 if hasgreatmoves(initialscores,scoreindex,skill)
        end
        miniscore=100
        livecount=0
        for i in pbParty(opponent.index)
          next if i.nil?
          livecount+=1 if i.hp!=0
        end
        if livecount>1 && livecount<7
          miniscore*=(livecount-3)
          miniscore/=100.0
          miniscore*=0.05
          miniscore=(1-miniscore)
          score*=miniscore
        end
        count=-1
        party=pbParty(attacker.index)
        pivotvar=false
        for i in 0...party.length
          count+=1
          next if party[i].nil?
          temproles = pbGetMonRole(party[i],opponent,skill,count,party)
          if temproles.include?(PBMonRoles::PIVOT)
            pivotvar=true
          end
        end
        if pivotvar && !@doublebattle
          score*=1.2
        end
        livecount2=0
        for i in pbParty(attacker.index)
          next if i.nil?
          livecount2+=1 if i.hp!=0
        end
        if livecount>1 && livecount2==1
          score*=0.9
        end
      end
    when 0x3D # V-Create
      thisinitial = score
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        score*=1.7
      else
        if thisinitial<100
          score*=0.8
          if (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
            score*=1.3
          else
            livecount=0
            for i in pbParty(opponent.index)
              next if i.nil?
              livecount+=1 if i.hp!=0
            end
            livecount2=0
            for i in pbParty(attacker.index)
              next if i.nil?
              livecount2+=1 if i.hp!=0
            end
            if livecount>1 && livecount2==1
              score*=0.7
            end
            score*=0.7 if checkAIpriority(aimem)
          end
        end
        if initialscores.length>0
          score*=0.7 if hasgreatmoves(initialscores,scoreindex,skill)
        end
        miniscore=100
        livecount=0
        for i in pbParty(opponent.index)
          next if i.nil?
          livecount+=1 if i.hp!=0
        end
        if livecount>1
          miniscore*=(livecount-3)
          miniscore/=100.0
          miniscore*=0.05
          miniscore=(1-miniscore)
          score*=miniscore
        end
        count=-1
        party=pbParty(attacker.index)
        pivotvar=false
        for i in 0...party.length
          count+=1
          next if party[i].nil?
          temproles = pbGetMonRole(party[i],opponent,skill,count,party)
          if temproles.include?(PBMonRoles::PIVOT)
            pivotvar=true
          end
        end
        if pivotvar && !@doublebattle
          score*=1.2
        end
      end
    when 0x3E # Hammer Arm
      thisinitial = score
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        score*=1.3
      else
        if thisinitial<100
          score*=0.9
        end
        if initialscores.length>0
          score*=0.7 if hasgreatmoves(initialscores,scoreindex,skill)
        end
        livecount=0
        for i in pbParty(opponent.index)
          next if i.nil?
          livecount+=1 if i.hp!=0
        end
        livecount2=0
        for i in pbParty(attacker.index)
          next if i.nil?
          livecount2+=1 if i.hp!=0
        end
        if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
          score*=0.8
          if livecount>1 && livecount2==1
            score*=0.8
          end
        else
          score*=1.1
        end
        if roles.include?(PBMonRoles::TANK)
          score*=1.1
        end
        miniscore=100
        livecount=0
        for i in pbParty(opponent.index)
          next if i.nil?
          livecount+=1 if i.hp!=0
        end
        if livecount>1
          miniscore*=(livecount-3)
          miniscore/=100.0
          miniscore*=0.05
          miniscore=(1-miniscore)
          score*=miniscore
        end
        count=-1
        party=pbParty(attacker.index)
        pivotvar=false
        for i in 0...party.length
          count+=1
          next if party[i].nil?
          temproles = pbGetMonRole(party[i],opponent,skill,count,party)
          if temproles.include?(PBMonRoles::PIVOT)
            pivotvar=true
          end
        end
        if pivotvar && !@doublebattle
          score*=1.2
        end
      end
    when 0x3F # Overheat
      thisinitial = score
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        score*=1.7
      else
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect==24 # Glitch
            if attacker.spdef>attacker.spatk
              score*=1.4
            end
          end
        end
        if thisinitial<100
          score*=0.9
          score*=0.5 if checkAIhealing(aimem)
        end
        if initialscores.length>0
          score*=0.7 if hasgreatmoves(initialscores,scoreindex,skill)
        end
        miniscore=100
        livecount=0
        for i in pbParty(opponent.index)
          next if i.nil?
          livecount+=1 if i.hp!=0
        end
        if livecount>1
          miniscore*=(livecount-1)
          miniscore/=100.0
          miniscore*=0.05
          miniscore=(1-miniscore)
          score*=miniscore
        end
        count=-1
        party=pbParty(attacker.index)
        pivotvar=false
        for i in 0...party.length
          count+=1
          next if party[i].nil?
          temproles = pbGetMonRole(party[i],opponent,skill,count,party)
          if temproles.include?(PBMonRoles::PIVOT)
            pivotvar=true
          end
        end
        if pivotvar && !@doublebattle
          score*=1.2
        end
        livecount2=0
        for i in pbParty(attacker.index)
          next if i.nil?
          livecount2+=1 if i.hp!=0
        end
        if livecount>1 && livecount2==1
          score*=0.8
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::SOULHEART)
          score*=1.3
        end
      end
    when 0x40 # Flatter
      if opponent != attacker.pbPartner
        if opponent.pbCanConfuse?(false)
          miniscore=100
          ministat=0
          ministat+=opponent.stages[PBStats::ATTACK]
          if ministat>0
            minimini=10*ministat
            minimini+=100
            minimini/=100.0
            miniscore*=minimini
          end
          if opponent.attack>opponent.spatk
            miniscore*=1.5
          else
            miniscore*=0.3
          end
          if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
            miniscore*=1.3
          end
          if opponent.effects[PBEffects::Attract]>=0
            miniscore*=1.1
          end
          if opponent.status==PBStatuses::PARALYSIS
            miniscore*=1.1
          end
          if opponent.effects[PBEffects::Yawn]>0 || opponent.status==PBStatuses::SLEEP
            miniscore*=0.4
          end
          if (!opponent.abilitynulled && opponent.ability == PBAbilities::TANGLEDFEET)
            miniscore*=0.7
          end
          if (!opponent.abilitynulled && opponent.ability == PBAbilities::CONTRARY)
            miniscore*=1.5
          end
          if attacker.pbHasMove?((PBMoves::SUBSTITUTE))
            miniscore*=1.2
            if attacker.effects[PBEffects::Substitute]>0
              miniscore*=1.3
            end
          end
          miniscore/=100.0
          score*=miniscore
        else
          score=0
        end
      else
        if opponent.pbCanConfuse?(false)
          score*=0.5
        else
          score*=1.5
        end
        if opponent.attack<opponent.spatk
          score*=1.5
        end
        if (1.0/opponent.totalhp)*opponent.hp < 0.6
          score*=0.3
        end
        if opponent.effects[PBEffects::Attract]>=0 || opponent.status==PBStatuses::PARALYSIS || opponent.effects[PBEffects::Yawn]>0 || opponent.status==PBStatuses::SLEEP
          score*=0.3
        end
        if oppitemworks && (opponent.item == PBItems::PERSIMBERRY || opponent.item == PBItems::LUMBERRY)
          score*=1.2
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::CONTRARY)
          score*=0
        end
        if opponent.effects[PBEffects::Substitute]>0
          score*=0
        end
        opp1 = attacker.pbOppositeOpposing
        opp2 = opp1.pbPartner
        if opponent.pbSpeed > opp1.pbSpeed && opponent.pbSpeed > opp2.pbSpeed
          score*=1.3
        else
          score*=0.7
        end
      end
    when 0x41 # Swagger
      if opponent != attacker.pbPartner
        if opponent.pbCanConfuse?(false)
          miniscore=100
          if opponent.attack<opponent.spatk
            miniscore*=1.5
          else
            miniscore*=0.7
          end
          if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
            miniscore*=1.3
          end
          if opponent.effects[PBEffects::Attract]>=0
            miniscore*=1.3
          end
          if opponent.status==PBStatuses::PARALYSIS
            miniscore*=1.3
          end
          if opponent.effects[PBEffects::Yawn]>0 || opponent.status==PBStatuses::SLEEP
            miniscore*=0.4
          end
          if (!opponent.abilitynulled && opponent.ability == PBAbilities::TANGLEDFEET)
            miniscore*=0.7
          end
          if (!opponent.abilitynulled && opponent.ability == PBAbilities::CONTRARY)
            miniscore*=1.5
          end
          if attacker.pbHasMove?((PBMoves::SUBSTITUTE))
            miniscore*=1.2
            if attacker.effects[PBEffects::Substitute]>0
              miniscore*=1.3
            end
          end
          if attacker.pbHasMove?((PBMoves::FOULPLAY))
            miniscore*=1.5
          end
          miniscore/=100.0
          score*=miniscore
        else
          score=0
        end
      else
        if opponent.pbCanConfuse?(false)
          score*=0.5
        else
          score*=1.5
        end
        if opponent.attack>opponent.spatk
          score*=1.5
        end
        if (1.0/opponent.totalhp)*opponent.hp < 0.6
          score*=0.3
        end
        if opponent.effects[PBEffects::Attract]>=0 || opponent.status==PBStatuses::PARALYSIS || opponent.effects[PBEffects::Yawn]>0 || opponent.status==PBStatuses::SLEEP
          score*=0.3
        end
        if (oppitemworks && opponent.item == PBItems::PERSIMBERRY) || (oppitemworks && opponent.item == PBItems::LUMBERRY)
          score*=1.2
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::CONTRARY)
          score*=0
        end
        if opponent.effects[PBEffects::Substitute]>0
          score*=0
        end
        opp1 = attacker.pbOppositeOpposing
        opp2 = opp1.pbPartner
        if opponent.pbSpeed > opp1.pbSpeed && opponent.pbSpeed > opp2.pbSpeed
          score*=1.3
        else
          score*=0.7
        end
        if opp1.pbHasMove?((PBMoves::FOULPLAY)) || opp2.pbHasMove?((PBMoves::FOULPLAY))
          score*=0.3
        end
      end
    when 0x42 # Growl
      if (pbRoughStat(opponent,PBStats::SPATK,skill)>pbRoughStat(opponent,PBStats::ATTACK,skill)) || opponent.stages[PBStats::ATTACK]>0 || !opponent.pbCanReduceStatStage?(PBStats::ATTACK)
        if move.basedamage==0
          score=0
        end
      else
        miniscore=100
        if skill>=PBTrainerAI.highSkill
          if move.id==(PBMoves::LUNGE)
            if $fefieldeffect==13 # Icy Field
              miniscore*=1.5
            end
          end
          if move.id==(PBMoves::AURORABEAM)
            if $fefieldeffect==30 # Mirror Field
              if (attacker.stages[PBStats::ACCURACY] < 0 || opponent.stages[PBStats::EVASION] > 0 ||
                  (oppitemworks && opponent.item == PBItems::BRIGHTPOWDER) || (oppitemworks && opponent.item == PBItems::LAXINCENSE) ||
                  ((!opponent.abilitynulled && opponent.ability == PBAbilities::SANDVEIL) && pbWeather==PBWeather::SANDSTORM) ||
                  ((!opponent.abilitynulled && opponent.ability == PBAbilities::SNOWCLOAK) && pbWeather==PBWeather::HAIL) ||
                  opponent.vanished) && !(!opponent.abilitynulled && opponent.ability == PBAbilities::NOGUARD) && !(!attacker.abilitynulled && attacker.ability == PBAbilities::NOGUARD)
                miniscore*=2
              end
            end
          end
        end
        miniscore *= unsetupminiscore(attacker,opponent,skill,move,roles,1,true,false,initialscores,scoreindex)
        miniscore/=100.0
        score*=miniscore
      end
    when 0x43 # Tail Whip
      physmove=false
      for j in attacker.moves
        if j.pbIsPhysical?(j.type)
          physmove=true
        end
      end
      if !physmove || opponent.stages[PBStats::DEFENSE]>0 || !opponent.pbCanReduceStatStage?(PBStats::DEFENSE)
        if move.basedamage==0
          score=0
        end
      else
        miniscore=100
        if move.id==(PBMoves::GRAVAPPLE)
          if (@field.effects[PBEffects::Gravity]>0 || $fefieldeffect == 15)
            miniscore*=1.3
          end
        if $fefieldeffect==21 # Water Surface
          if !opponent.pbHasType?(PBTypes::WATER)
            miniscore*=2
          else
            for mon in pbParty(attacker.index)
              watervar=false
              next if mon.nil?
              if mon.hasType?(:WATER)
                watervar=true
              end
              if watervar
                miniscore*=1.3
              end
            end
          end
        end
        if $fefieldeffect==43 # Sky
          if !opponent.pbHasType?(PBTypes::FLYING)
            miniscore*=2
          else
            for mon in pbParty(attacker.index)
              flyingvar=false
              next if mon.nil?
              if mon.hasType?(:FLYING)
                flyingvar=true
              end
              if flyingvar
                score*=1.3
              end
            end
          end
        end
        end
        miniscore*=unsetupminiscore(attacker,opponent,skill,move,roles,2,true,false,initialscores,scoreindex)
        miniscore/=100.0
        score*=miniscore if !hasgreatmoves(initialscores,scoreindex,skill,true)
      end
    when 0x44 # Rock Tomb / Bulldoze / Glaciate 
      if ((pbRoughStat(opponent,PBStats::SPEED,skill)<attacker.pbSpeed) ^ (@trickroom!=0)) || opponent.stages[PBStats::SPEED]>0 || !opponent.pbCanReduceStatStage?(PBStats::SPEED)
        if move.basedamage==0
          score=0
        end
      else
        miniscore=100
        if opponent.stages[PBStats::SPEED]<0
          minimini = 5*opponent.stages[PBStats::SPEED]
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
          miniscore*=1.1
        end
        if skill>=PBTrainerAI.highSkill
          if move.id==(PBMoves::GLACIATE)
            if $fefieldeffect==26 # Murkwater Surface
              poisonvar=false
              watervar=false
              icevar=false
              for mon in pbParty(attacker.index)
                next if mon.nil?
                if mon.hasType?(:POISON)
                  poisonvar=true
                end
                if mon.hasType?(:WATER)
                  watervar=true
                end
                if mon.hasType?(:ICE)
                  icevar=true
                end
              end
              if !poisonvar && !watervar
                miniscore*=1.3
              end
              if icevar
                miniscore*=1.5
              end
            end
            if $fefieldeffect==21 # Water Surface
              watervar=false
              icevar=false
              for mon in pbParty(attacker.index)
                next if mon.nil?
                if mon.hasType?(:WATER)
                  watervar=true
                end
                if mon.hasType?(:ICE)
                  icevar=true
                end
              end
              if !watervar
                miniscore*=1.3
              end
              if icevar
                miniscore*=1.5
              end
            end
            if $fefieldeffect==32 # Dragon's Den
              dragonvar=false
              rockvar=false
              for mon in pbParty(attacker.index)
                next if mon.nil?
                if mon.hasType?(:DRAGON)
                  dragonvar=true
                end
                if mon.hasType?(:ROCK)
                  rockvar=true
                end
              end
              if !dragonvar
                miniscore*=1.3
              end
              if rockvar
                miniscore*=1.3
              end
            end
            if $fefieldeffect==16 # Superheated
              firevar=false
              for mon in pbParty(attacker.index)
                next if mon.nil?
                if mon.hasType?(:FIRE)
                  firevar=true
                end
              end
              if !firevar
                miniscore*=1.5
              end
            end
          end
          if move.id==(PBMoves::BULLDOZE)
            if $fefieldeffect==4 # Dark Crystal Cavern
              darkvar=false
              rockvar=false
              for mon in pbParty(attacker.index)
                next if mon.nil?
                if mon.hasType?(:DARK)
                  darkvar=true
                end
                if mon.hasType?(:ROCK)
                  rockvar=true
                end
              end
              if !darkvar
                miniscore*=1.3
              end
              if rockvar
                miniscore*=1.2
              end
            end
            if $fefieldeffect==25 # Crystal Cavern
              dragonvar=false
              rockvar=false
              for mon in pbParty(attacker.index)
                next if mon.nil?
                if mon.hasType?(:DRAGON)
                  dragonvar=true
                end
                if mon.hasType?(:ROCK)
                  rockvar=true
                end
              end
              if !dragonvar
                miniscore*=1.3
              end
              if rockvar
                miniscore*=1.2
              end
            end
            if $fefieldeffect==13 # Icy Field
              icevar=false
              for mon in pbParty(attacker.index)
                next if mon.nil?
                if mon.hasType?(:ICE)
                  icevar=true
                end
              end
              if !icevar
                miniscore*=1.5
              end
            end
            if $fefieldeffect==17 # Factory
              miniscore*=1.2
              darkvar=false
              for mon in pbParty(attacker.index)
                next if mon.nil?
                if mon.hasType?(:DARK)
                  darkvar=true
                end
              end
              if darkvar
                miniscore*=1.3
              end
            end
            if $fefieldeffect==23 # Cave
              if !(!attacker.abilitynulled && attacker.ability == PBAbilities::ROCKHEAD) && !(!attacker.abilitynulled && attacker.ability == PBAbilities::BULLETPROOF)
                miniscore*=0.7
                if $fecounter >=1
                  miniscore *= 0.3
                end
              else
                if  (!attacker.abilitynulled && (attacker.pbPartner.ability == PBAbilities::ROCKHEAD || attacker.pbPartner.ability == PBAbilities::BULLETPROOF || attacker.pbPartner.ability == PBAbilities::TELEPATHY || attacker.pbPartner.ability == PBAbilities::FILTER || attacker.pbPartner.ability == PBAbilities::STURDY || attacker.pbPartner.ability == PBAbilities::SOLIDROCK || attacker.pbPartner.ability == PBAbilities::STALWART))
                  miniscore*=2
                else
                  miniscore*=1.5
                end
              end 
            end
            if $fefieldeffect==30 # Mirror Arena
              if opponent.stages[PBStats::EVASION] > 0 ||
                (oppitemworks && opponent.item == PBItems::BRIGHTPOWDER) || (oppitemworks && opponent.item == PBItems::LAXINCENSE) ||
                ((!opponent.abilitynulled && opponent.ability == PBAbilities::SANDVEIL) && pbWeather==PBWeather::SANDSTORM) ||
                ((!opponent.abilitynulled && opponent.ability == PBAbilities::SNOWCLOAK) && pbWeather==PBWeather::HAIL)
                miniscore*=1.3
              else
                miniscore*=0.5
              end
            end
          end
        end
        greatmoves = hasgreatmoves(initialscores,scoreindex,skill)
        miniscore*=unsetupminiscore(attacker,opponent,skill,move,roles,3,false,greatmoves,initialscores,scoreindex)
        miniscore/=100.0
        score*=miniscore
      end
      if move.id==getID(PBMoves,:BULLDOZE) && $fefieldeffect==43
        score*=0
      end
    when 0x45 # Snarl
      if ((pbRoughStat(opponent,PBStats::SPATK,skill)<pbRoughStat(opponent,PBStats::ATTACK,skill)) || opponent.stages[PBStats::SPATK]>3 || !opponent.pbCanReduceStatStage?(PBStats::SPATK))
        if move.basedamage==0
          score=0
        end
        if !opponent.abilitynulled && (opponent.ability == PBAbilities::COMPETITIVE || opponent.ability == PBAbilities::DEFIANT || opponent.ability == PBAbilities::CONTRARY) || SilvallyCheck(opponent,PBTypes::FIGHTING) || SilvallyCheck(opponent, PBTypes::FAIRY)
          if !hasgreatmoves(initialscores,scoreindex,skill,true)
            score*=0.6
          end
        end
      else
        if (!hasgreatmoves(initialscores,scoreindex,skill,true) && !attacker.isBoss)
          score*=unsetupminiscore(attacker,opponent,skill,move,roles,1,false,false,initialscores,scoreindex) 
        end
      end
    when 0x46 # Psychic
      specmove=false
      for j in attacker.moves
        if j.pbIsSpecial?(j.type)
          specmove=true
        end
      end
      if !specmove || opponent.stages[PBStats::SPDEF]>0 || !opponent.pbCanReduceStatStage?(PBStats::SPDEF)
        if move.basedamage==0
          score=0
        end
      else
        miniscore=100
        if opponent.stages[PBStats::SPDEF]<0
          minimini = 5*opponent.stages[PBStats::SPDEF]
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        if skill>=PBTrainerAI.highSkill
          if move.id==(PBMoves::FLASHCANNON) || move.id==(PBMoves::LUSTERPURGE)
            if $fefieldeffect==30 # Mirror Arena
              if (attacker.stages[PBStats::ACCURACY] < 0 || opponent.stages[PBStats::EVASION] > 0 ||
                  (oppitemworks && opponent.item == PBItems::BRIGHTPOWDER) || (oppitemworks && opponent.item == PBItems::LAXINCENSE) ||
                  ((!opponent.abilitynulled && opponent.ability == PBAbilities::SANDVEIL) && pbWeather==PBWeather::SANDSTORM) ||
                  ((!opponent.abilitynulled && opponent.ability == PBAbilities::SNOWCLOAK) && pbWeather==PBWeather::HAIL) ||
                  opponent.vanished) && !(!opponent.abilitynulled && opponent.ability == PBAbilities::NOGUARD) && !(!attacker.abilitynulled && attacker.ability == PBAbilities::NOGUARD)
                miniscore*=2
              end
            end
          end
        end
        miniscore*= unsetupminiscore(attacker,opponent,skill,move,roles,2,false,false,initialscores,scoreindex)
        miniscore/=100.0
        score*=miniscore if !hasgreatmoves(initialscores,scoreindex,skill,true)
      end
    when 0x47 # Sand Attack
      if checkAIaccuracy(aimem) || opponent.stages[PBStats::ACCURACY]>0 || !opponent.pbCanReduceStatStage?(PBStats::ACCURACY)
        if move.basedamage==0
          score=0
        end
      else
        miniscore=100
        if opponent.stages[PBStats::ACCURACY]<0
          minimini = 5*opponent.stages[PBStats::ACCURACY]
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        if skill>=PBTrainerAI.highSkill
          if move.id==(PBMoves::KINESIS)
            if $fefieldeffect==20 # Ashen Beach
              miniscore*=1.3
            end
            if $fefieldeffect==37 # Psychic Terrain
              miniscore*=1.6
            end
          end
          if move.id==(PBMoves::SANDATTACK)
            if $fefieldeffect==20 || $fefieldeffect==12 # Ashen Beach/Desert
              miniscore*=1.3
            end
          end
          if move.id==(PBMoves::MIRRORSHOT)
            if $fefieldeffect==30 # Mirror Arena
              if (attacker.stages[PBStats::ACCURACY] < 0 || opponent.stages[PBStats::EVASION] > 0 ||
                  (oppitemworks && opponent.item == PBItems::BRIGHTPOWDER) || (oppitemworks && opponent.item == PBItems::LAXINCENSE) ||
                  ((!opponent.abilitynulled && opponent.ability == PBAbilities::SANDVEIL) && pbWeather==PBWeather::SANDSTORM) ||
                  ((!opponent.abilitynulled && opponent.ability == PBAbilities::SNOWCLOAK) && pbWeather==PBWeather::HAIL) ||
                  opponent.vanished) && !(!opponent.abilitynulled && opponent.ability == PBAbilities::NOGUARD) && !(!attacker.abilitynulled && attacker.ability == PBAbilities::NOGUARD)
                miniscore*=2
              end
            end
          end
          if move.id==(PBMoves::MUDDYWATER)
            if $fefieldeffect==7 # Burning
              firevar=false
              for mon in pbParty(attacker.index)
                next if mon.nil?
                if mon.hasType?(:FIRE)
                  firevar=true
                end
              end
              if firevar
                miniscore*=0
              else
                miniscore*=2
              end
            end
            if $fefieldeffect==16 # Superheated
              miniscore*=0.7
            end
            if $fefieldeffect==32 # Dragon's Den
              firevar=false
              dragonvar=false
              for mon in pbParty(attacker.index)
                next if mon.nil?
                if mon.hasType?(:FIRE)
                  firevar=true
                end
                if mon.hasType?(:DRAGON)
                  dragonvar=true
                end
              end
              if firevar || dragonvar
                miniscore*=0
              else
                miniscore*=1.5
              end
            end
          end
          if move.id==(PBMoves::NIGHTDAZE)
            if $fefieldeffect==25 # Crystal Cavern
              darkvar=false
              dragonvar=false
              for mon in pbParty(attacker.index)
                next if mon.nil?
                if mon.hasType?(:DARK)
                  darkvar=true
                end
                if mon.hasType?(:DRAGON)
                  dragonvar=true
                end
              end
              if darkvar
                miniscore*=2
              end
              if dragonvar
                miniscore*=0.75
              end
            end
          end
          if move.id==(PBMoves::LEAFTORNADO)
            if $fefieldeffect==20 # Ahsen Beach
              miniscore*=0.7
            end
          end
          if move.id==(PBMoves::FLASH)
            if $fefieldeffect==4 || $fefieldeffect==18 || $fefieldeffect==30 || $fefieldeffect==34 || $fefieldeffect==35 # Dark Crystal Cavern/Short-Circuit/Mirror/Starlight/New World
              miniscore*=1.3
            end
            if $fefieldeffect==40
              normalvar=false
              for mon in pbParty(attacker.index)
                next if mon.nil?
                if mon.hasType?(:NORMAL)
                  normalvar=true
                end
              end
              if normalvar && ($febackup==29) 
                miniscore*=2
              end
            end
          end
          if move.id==(PBMoves::SMOKESCREEN)
            if $fefieldeffect==7 || $fefieldeffect==11 # Burning/Corrosive Mist
              miniscore*=1.3
            end
          end
        end
        miniscore*= unsetupminiscore(attacker,opponent,skill,move,roles,1,false,false,initialscores,scoreindex)
        miniscore/=100.0
        score*=miniscore
      end
    when 0x48 # Sweet Scent
      score=0 #no
    when 0x49 # Defog
      miniscore=100
      livecount1=0
      for i in pbParty(attacker.index)
        next if i.nil?
        livecount1+=1 if i.hp!=0
      end
      livecount2=0
      for i in pbParty(opponent.index)
        next if i.nil?
        livecount2+=1 if i.hp!=0
      end
      if livecount1>1
        miniscore*=2 if attacker.pbOwnSide.effects[PBEffects::StealthRock]
        miniscore*=3 if attacker.pbOwnSide.effects[PBEffects::StickyWeb]
        miniscore*=(1.5**attacker.pbOwnSide.effects[PBEffects::Spikes])
        miniscore*=(1.7**attacker.pbOwnSide.effects[PBEffects::ToxicSpikes])
      end
      miniscore-=100
      miniscore*=(livecount1-1) if livecount1>1
      minimini=100
      if livecount2>1
        minimini*=0.5 if opponent.pbOwnSide.effects[PBEffects::StealthRock]
        minimini*=0.3 if opponent.pbOwnSide.effects[PBEffects::StickyWeb]
        minimini*=(0.7**opponent.pbOwnSide.effects[PBEffects::Spikes])
        minimini*=(0.6**opponent.pbOwnSide.effects[PBEffects::ToxicSpikes])
      end
      minimini-=100
      minimini*=(livecount2-1) if livecount2>1
      miniscore+=minimini
      miniscore+=100
      if miniscore<0
        miniscore=0
      end
      miniscore/=100.0
      score*=miniscore
      if opponent.pbOwnSide.effects[PBEffects::Reflect]>0
        score*=2
      end
      if opponent.pbOwnSide.effects[PBEffects::LightScreen]>0
        score*=2
      end
      if opponent.pbOwnSide.effects[PBEffects::Safeguard]>0
        score*=1.3
      end
      if opponent.pbOwnSide.effects[PBEffects::AuroraVeil]>0
        score*=3
      end
      if opponent.pbOwnSide.effects[PBEffects::Mist]>0
        score*=1.3
      end
    when 0x4A # Tickle
      miniscore=100
      if (pbRoughStat(opponent,PBStats::SPATK,skill)>pbRoughStat(opponent,PBStats::ATTACK,skill)) || opponent.stages[PBStats::ATTACK]>0 || !opponent.pbCanReduceStatStage?(PBStats::ATTACK)
        if move.basedamage==0
          miniscore*=0.5
        end
      else
        if opponent.stages[PBStats::ATTACK]+opponent.stages[PBStats::DEFENSE]<0
          minimini = 5*opponent.stages[PBStats::ATTACK]
          minimini+= 5*opponent.stages[PBStats::DEFENSE]
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        miniscore*= unsetupminiscore(attacker,opponent,skill,move,roles,1,true,false,initialscores,scoreindex)
      end
      miniscore/=100.0
      score*=miniscore
      miniscore=100
      physmove=false
      for j in attacker.moves
        if j.pbIsPhysical?(j.type)
          physmove=true
        end
      end
      if !physmove || opponent.stages[PBStats::DEFENSE]>0 || !opponent.pbCanReduceStatStage?(PBStats::DEFENSE)
        if move.basedamage==0
          miniscore*=0.5
        end
      else
        miniscore*= unsetupminiscore(attacker,opponent,skill,move,roles,2,true,false,initialscores,scoreindex)
      end
      miniscore/=100.0
      score*=miniscore
    when 0x4B # Feather Dance
      if (pbRoughStat(opponent,PBStats::SPATK,skill)>pbRoughStat(opponent,PBStats::ATTACK,skill)) || opponent.stages[PBStats::ATTACK]>1 || !opponent.pbCanReduceStatStage?(PBStats::ATTACK)
        if move.basedamage==0
          score=0
        end
      else
        miniscore=100
        if opponent.stages[PBStats::ATTACK]<0
          minimini = 5*opponent.stages[PBStats::ATTACK]
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect==6 # Big Top
            miniscore*=1.5
          end
        end
        miniscore*= unsetupminiscore(attacker,opponent,skill,move,roles,1,true,false,initialscores,scoreindex)
        miniscore/=100.0
        score*=miniscore
      end
    when 0x4C # Screech
      physmove=false
      for j in attacker.moves
        if j.pbIsPhysical?(j.type)
          physmove=true
        end
      end
      if !physmove || opponent.stages[PBStats::DEFENSE]>1 && !opponent.isBoss || !opponent.pbCanReduceStatStage?(PBStats::DEFENSE)
        if move.basedamage==0
          score=0
        end
      else
        miniscore=100
        if opponent.stages[PBStats::DEFENSE]<0
          minimini = 5*opponent.stages[PBStats::DEFENSE]
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        miniscore*= unsetupminiscore(attacker,opponent,skill,move,roles,2,true,false,initialscores,scoreindex)
        miniscore/=100.0
        score*=miniscore
      end
    when 0x4D # Scary Face
      if ((pbRoughStat(opponent,PBStats::SPEED,skill)<attacker.pbSpeed) ^ (@trickroom!=0)) || opponent.stages[PBStats::SPEED]>1 || !opponent.pbCanReduceStatStage?(PBStats::SPEED)
        if move.basedamage==0
          score=0
        end
      else
        miniscore=100
        if opponent.stages[PBStats::SPEED]<0
          minimini = 5*opponent.stages[PBStats::SPEED]
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        greatmoves = hasgreatmoves(initialscores,scoreindex,skill)
        miniscore*=unsetupminiscore(attacker,opponent,skill,move,roles,3,false,greatmoves,initialscores,scoreindex)
        miniscore/=100.0
        score*=miniscore
      end
    when 0x4E # Captivate
      canattract=true
      agender=attacker.gender
      ogender=opponent.gender
      if agender==2 || ogender==2 || agender==ogender # Pokemon are genderless or same gender
        canattract=false
      elsif (!opponent.abilitynulled && opponent.ability == PBAbilities::OBLIVIOUS)
        canattract=false
      end
      if (pbRoughStat(opponent,PBStats::SPATK,skill)<pbRoughStat(opponent,PBStats::ATTACK,skill)) || opponent.stages[PBStats::SPATK]>1 || !opponent.pbCanReduceStatStage?(PBStats::SPATK)
        if move.basedamage==0
          score=0
        end
      elsif !canattract
        score=0
      else
        miniscore=100
        if opponent.stages[PBStats::SPATK]<0
          minimini = 5*opponent.stages[PBStats::SPATK]
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        miniscore*=unsetupminiscore(attacker,opponent,skill,move,roles,1,false,false,initialscores,scoreindex)
        miniscore/=100.0
        score*=miniscore
      end
    when 0x4F # Acid Spray
      specmove=false
      for j in attacker.moves
        if j.pbIsSpecial?(j.type)
          specmove=true
        end
      end
      if !specmove || opponent.stages[PBStats::SPDEF]>1 || !opponent.pbCanReduceStatStage?(PBStats::SPDEF)
        if move.basedamage==0
          score=0
        end
      else
        miniscore=100
        if skill>=PBTrainerAI.highSkill
          if move.id==(PBMoves::METALSOUND)
            if $fefieldeffect==17 || $fefieldeffect==18 # Factory/Short-Circuit
              miniscore*=1.5
            end
          end
          if move.id==(PBMoves::SEEDFLARE)
            if $fefieldeffect==10 # Corrosive
              poisonvar=false
              grassvar=false
              for mon in pbParty(attacker.index)
                next if mon.nil?
                if mon.hasType?(:POISON)
                  poisonvar=true
                end
                if mon.hasType?(:GRASS)
                  grassvar=true
                end
              end
              if !poisonvar
                miniscore*=1.5
              end
              if grassvar
                miniscore*=1.5
              end
            end
          end
        end
        miniscore*= unsetupminiscore(attacker,opponent,skill,move,roles,2,false,false,initialscores,scoreindex)
        miniscore/=100.0
        score*=miniscore if !hasgreatmoves(initialscores,scoreindex,skill)
        if hasgreatmoves(initialscores,scoreindex,skill)
          score=(score*0.99).floor
        end
      end
    when 0x50 # Clear Smog
      if opponent.effects[PBEffects::Substitute]<=0
        miniscore = 5*statchangecounter(opponent,1,7)
        miniscore+=100
        miniscore/=100.0
        score*=miniscore
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::SPEEDBOOST)
          score*=1.1
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEAMENGINE)
          if $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==21 || $fefieldeffect==22 || $fefieldeffect==45
            miniscore*=1.1
          end
        end
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect==3 # Misty
            poisonvar=false
            fairyvar=false
            for mon in pbParty(attacker.index)
              next if mon.nil?
              if mon.hasType?(:POISON)
                poisonvar=true
              end
              if mon.hasType?(:FAIRY)
                fairyvar=true
              end
            end
            if poisonvar
              score*=1.3
            end
            if !fairyvar
              score*=1.3
            end
          elsif $fefieldeffect==16 || $fefieldeffect==27 || $fefieldeffect==28 # Mountains > Sky Field
            flyingvar=false
            for mon in pbParty(attacker.index)
              next if mon.nil?
              if mon.hasType?(:FLYING)
                flyingvar=true
              end
            end
            if flyingvar
              score*=1.3
            end
          end
        end
      end  
    when 0x51 # Haze
      miniscore = (-10)* statchangecounter(attacker,1,7)
      minimini = (10)* statchangecounter(opponent,1,7)
      if @doublebattle
        if attacker.pbPartner.hp>0
          miniscore+= (-10)* statchangecounter(attacker.pbPartner,1,7)
        end
        if opponent.pbPartner.hp>0
          minimini+= (10)* statchangecounter(opponent.pbPartner,1,7)
        end
      end
      if miniscore==0 && minimini==0
        score*=0
      else
        miniscore+=minimini
        miniscore+=100
        miniscore/=100.0
        score*=miniscore
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::SPEEDBOOST) || checkAImoves(PBStuff::SETUPMOVE,aimem)
        score*=0.8
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEAMENGINE)
        if $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==21 || $fefieldeffect==22 || $fefieldeffect==45
          miniscore*=0.6
        end
      end
    when 0x52 # Power Swap
      stages=0
      stages+=attacker.stages[PBStats::ATTACK]
      stages+=attacker.stages[PBStats::SPATK]
      miniscore = (-10)*stages
      if attacker.attack > attacker.spatk
        if attacker.stages[PBStats::ATTACK]!=0
          miniscore*=2
        end
      else
        if attacker.stages[PBStats::SPATK]!=0
          miniscore*=2
        end
      end
      maxdam=checkAIdamage(aimem,attacker,opponent,skill)
      oppatk=opponent.stages[PBStats::ATTACK]
      oppspatk=opponent.stages[PBStats::SPATK]
      opponent.stages[PBStats::SPATK]=attacker.stages[PBStats::SPATK]
      opponent.stages[PBStats::ATTACK]=attacker.stages[PBStats::ATTACK]
      maxdam2=checkAIdamage(aimem,attacker,opponent,skill)
      opponent.stages[PBStats::ATTACK]=oppatk
      opponent.stages[PBStats::SPATK]=oppspatk
      if maxdam>attacker.hp*0.75
        if maxdam>maxdam2
          score*=2
          if maxdam>attacker.hp
            score*=2
          end
        end
      end
      if hasgreatmoves(initialscores,scoreindex,skill) && (maxdam>attacker.hp && maxdam2<maxdam) 
        score*=6
      end
      stages=0
      stages+=opponent.stages[PBStats::ATTACK]
      stages+=opponent.stages[PBStats::SPATK]
      minimini = (10)*stages
      if opponent.attack > opponent.spatk
        if opponent.stages[PBStats::ATTACK]!=0
          minimini*=2
        end
      else
        if opponent.stages[PBStats::SPATK]!=0
          minimini*=2
        end
      end
      if miniscore==0 && minimini==0
        score*=0
      else
        miniscore+=minimini
        miniscore+=100
        miniscore/=100.0
        score*=miniscore
        if @doublebattle
          score*=0.8
        end
      end
    when 0x53 # Guard Swap
      stages=0
      stages+=attacker.stages[PBStats::DEFENSE]
      stages+=attacker.stages[PBStats::SPDEF]
      miniscore = (-10)*stages
      if attacker.defense > attacker.spdef
        if attacker.stages[PBStats::DEFENSE]!=0
          miniscore*=2
        end
      else
        if attacker.stages[PBStats::SPDEF]!=0
          miniscore*=2
        end
      end
      stages=0
      stages+=opponent.stages[PBStats::DEFENSE]
      stages+=opponent.stages[PBStats::SPDEF]
      minimini = (10)*stages
      if opponent.defense > opponent.spdef
        if opponent.stages[PBStats::DEFENSE]!=0
          minimini*=2
        end
      else
        if opponent.stages[PBStats::SPDEF]!=0
          minimini*=2
        end
      end
      if miniscore==0 && minimini==0
        score*=0
      else
        miniscore+=minimini
        miniscore+=100
        miniscore/=100.0
        score*=miniscore
        if @doublebattle
          score*=0.8
        end
      end
    when 0x54 # Heart Swap
      stages=0
      stages+=attacker.stages[PBStats::ATTACK] unless attacker.attack<attacker.spatk
      stages+=attacker.stages[PBStats::DEFENSE] unless opponent.attack<opponent.spatk
      stages+=attacker.stages[PBStats::SPEED]
      stages+=attacker.stages[PBStats::SPATK] unless attacker.attack>attacker.spatk
      stages+=attacker.stages[PBStats::SPDEF] unless opponent.attack>opponent.spatk
      stages+=attacker.stages[PBStats::EVASION]
      stages+=attacker.stages[PBStats::ACCURACY]
      miniscore = (-10)*stages
      stages=0
      stages+=opponent.stages[PBStats::ATTACK] unless opponent.attack<opponent.spatk
      stages+=opponent.stages[PBStats::DEFENSE] unless attacker.attack<attacker.spatk
      stages+=opponent.stages[PBStats::SPEED]
      stages+=opponent.stages[PBStats::SPATK] unless opponent.attack>opponent.spatk
      stages+=opponent.stages[PBStats::SPDEF] unless attacker.attack>attacker.spatk
      stages+=opponent.stages[PBStats::EVASION]
      stages+=opponent.stages[PBStats::ACCURACY]
      minimini = (10)*stages
      if !(miniscore==0 && minimini==0)
        miniscore+=minimini
        miniscore+=100
        miniscore/=100.0
        score*=miniscore
        if @doublebattle
          score*=0.8
        end
      else
        if $fefieldeffect==35 # New World
          score=25
        else
          score=0
        end
      end
      if $fefieldeffect==35 # New World
        ministat = opponent.hp + attacker.hp*0.5
        maxdam = checkAIdamage(aimem,attacker,opponent,skill)
        if maxdam>ministat
          score*=0.5
        else
          if maxdam>attacker.hp
            if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
              score*=2
            else
              score*=0*5
            end
          else
            miniscore = opponent.hp * (1.0/attacker.hp)
            score*=miniscore
          end
        end
      end
    when 0x55 # Psych Up
      stages=0
      stages+=attacker.stages[PBStats::ATTACK] unless attacker.attack<attacker.spatk
      stages+=attacker.stages[PBStats::DEFENSE] unless opponent.attack<opponent.spatk
      stages+=attacker.stages[PBStats::SPEED]
      stages+=attacker.stages[PBStats::SPATK] unless attacker.attack>attacker.spatk
      stages+=attacker.stages[PBStats::SPDEF] unless opponent.attack>opponent.spatk
      stages+=attacker.stages[PBStats::EVASION]
      stages+=attacker.stages[PBStats::ACCURACY]
      miniscore = (-10)*stages
      stages=0
      stages+=opponent.stages[PBStats::ATTACK] unless attacker.attack<attacker.spatk
      stages+=opponent.stages[PBStats::DEFENSE] unless opponent.attack<opponent.spatk
      stages+=opponent.stages[PBStats::SPEED]
      stages+=opponent.stages[PBStats::SPATK] unless attacker.attack>attacker.spatk
      stages+=opponent.stages[PBStats::SPDEF] unless opponent.attack>opponent.spatk
      stages+=opponent.stages[PBStats::EVASION]
      stages+=opponent.stages[PBStats::ACCURACY]
      minimini = (10)*stages
      if !(miniscore==0 && minimini==0)
        miniscore+=minimini
        miniscore+=100
        miniscore/=100
        score*=miniscore
      else
        if $fefieldeffect==37 # Psychic Terrain
          score=35
        else
          score=0
        end
      end
      if $fefieldeffect==37 # Psychic Terrain
        miniscore=100
        if initialscores.length>0
          miniscore*=1.3 if hasbadmoves(initialscores,scoreindex,20)
        end
        if attacker.hp*(1.0/attacker.totalhp)>=0.75
          miniscore*=1.2
        end
        if opponent.effects[PBEffects::HyperBeam]>0
          miniscore*=1.3
        end
        if opponent.status==PBStatuses::SLEEP || opponent.status==PBStatuses::FROZEN
          miniscore*=1.3
        end
        if opponent.effects[PBEffects::Encore]>0
          if opponent.moves[(opponent.effects[PBEffects::EncoreIndex])].basedamage==0
            miniscore*=1.5
          end
        end
        if attacker.effects[PBEffects::Confusion]>0
          miniscore*=0.5
        end
        if attacker.effects[PBEffects::LeechSeed]>=0 || attacker.effects[PBEffects::Attract]>=0
          miniscore*=0.5
        end
        if skill>=PBTrainerAI.highSkill
          miniscore*=1.3 if checkAIhealing(aimem)
          miniscore*=0.6 if checkAIpriority(aimem)
        end
        if roles.include?(PBMonRoles::SWEEPER)
          miniscore*=1.3
        end
        specialvar = false
        for i in attacker.moves
          if i.pbIsSpecial?(i.type)
            special=true
          end
        end
        if attacker.stages[PBStats::SPATK]!=6 && specialvar
          score*=miniscore
        else
          score=0
        end
      end
    when 0x56 # Mist
      miniscore = 1
      minimini = 1
      if attacker.pbOwnSide.effects[PBEffects::Mist]==0
        minimini*=1.1
        movecheck=false
        # check opponent for stat decreasing moves
        for j in aimem
          movecheck=true if (j.function==0x42 || j.function==0x43 || j.function==0x44 || j.function==0x45 || j.function==0x46 || j.function==0x47 || j.function==0x48 || j.function==0x49 || j.function==0x4A || j.function==0x4B || j.function==0x4C || j.function==0x4D || j.function==0x4E || j.function==0x4F || j.function==0xE2 || j.function==0x138 || j.function==0x13B || j.function==0x13F)
        end
        if movecheck
          minimini*=1.3
        end
      end
      if $fefieldeffect!=3 && $fefieldeffect!=22 && $fefieldeffect!=35# (not) Misty Terrain
        miniscore*=getFieldDisruptScore(attacker,opponent,skill)
        fairyvar=false
        for mon in pbParty(attacker.index)
          next if mon.nil?
          if mon.hasType?(:FAIRY)
            fairyvar=true
          end
        end
        if fairyvar
          miniscore*=1.3
        end
        if opponent.pbHasType?(:DRAGON) && !attacker.pbHasType?(:FAIRY)
          miniscore*=1.3
        end
        if attacker.pbHasType?(:DRAGON)
          miniscore*=0.5
        end
        if opponent.pbHasType?(:FAIRY)
          miniscore*=0.5
        end
        if attacker.pbHasType?(:FAIRY) && opponent.spatk>opponent.attack
          miniscore*=1.5
        end
        if (attitemworks && attacker.item == PBItems::AMPLIFIELDROCK)
          miniscore*=2
        end
      end
      score*=miniscore
      score*=minimini
      if miniscore<=1 && minimini<=1
        score*=0
      end
    when 0x57 # Power Trick
      if attacker.attack - attacker.defense >= 100
        if attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill) || (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill) && @trickroom!=0)
          score*=1.5
        end
        if pbRoughStat(opponent,PBStats::ATTACK,skill)>pbRoughStat(opponent,PBStats::SPATK,skill)
          score*=2
        end
        healmove=false
        for j in attacker.moves
          if j.isHealingMove?
            healmove=true
          end
        end
        if healmove
          score*=2
        end
      elsif attacker.defense - attacker.attack >= 100
        if attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill) || (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill) && @trickroom!=0)
          score*=1.5
          if attacker.hp==attacker.totalhp && (((attitemworks && attacker.item == PBItems::FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) || (isConst?(opponent.species,PBSpecies,:RAMPARDOS) && isConst?(opponent.item,PBItems,:RAMPCREST)) && !attacker.moldbroken)) && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
            score*=2
          end
        else
          score*=0
        end
      else
        score*=0.1
      end
      if attacker.effects[PBEffects::PowerTrick]
        score*=0.1
      end
    when 0x58 # Power Split
      if  pbRoughStat(opponent,PBStats::ATTACK,skill)> pbRoughStat(opponent,PBStats::SPATK,skill)
        if attacker.attack > pbRoughStat(opponent,PBStats::ATTACK,skill)
          score*=0
        else
          miniscore = pbRoughStat(opponent,PBStats::ATTACK,skill) - attacker.attack
          miniscore+=100
          miniscore/=100
          if attacker.attack>attacker.spatk
            miniscore*=2
          else
            miniscore*=0.5
          end
          score*=miniscore
        end
      else
        if attacker.spatk > pbRoughStat(opponent,PBStats::SPATK,skill)
          score*=0
        else
          miniscore = pbRoughStat(opponent,PBStats::SPATK,skill) - attacker.spatk
          miniscore+=100
          miniscore/=100
          if attacker.attack<attacker.spatk
            miniscore*=2
          else
            miniscore*=0.5
          end
          score*=miniscore
        end
      end
    when 0x59 # Guard Split
      if  pbRoughStat(opponent,PBStats::ATTACK,skill)> pbRoughStat(opponent,PBStats::SPATK,skill)
        if attacker.defense > pbRoughStat(opponent,PBStats::DEFENSE,skill)
          score*=0
        else
          miniscore = pbRoughStat(opponent,PBStats::DEFENSE,skill) - attacker.defense
          miniscore+=100
          miniscore/=100
          if attacker.attack>attacker.spatk
            miniscore*=2
          else
            miniscore*=0.5
          end
          score*=miniscore
        end
      else
        if attacker.spdef > pbRoughStat(opponent,PBStats::SPDEF,skill)
          score*=0
        else
          miniscore = pbRoughStat(opponent,PBStats::SPDEF,skill) - attacker.spdef
          miniscore+=100
          miniscore/=100
          if attacker.attack<attacker.spatk
            miniscore*=2
          else
            miniscore*=0.5
          end
          score*=miniscore
        end
      end
    when 0x5A # Pain Split
      if opponent.effects[PBEffects::Substitute]<=0 && !(opponent.isbossmon)
        ministat = opponent.hp + (attacker.hp/2.0)
        maxdam = checkAIdamage(aimem,attacker,opponent,skill)
        if maxdam>ministat
          score*=0
        elsif maxdam>attacker.hp
          if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
            score*=2
          else
            score*=0
          end
        else
          miniscore=(opponent.hp/(attacker.hp).to_f)
          score*=miniscore
        end
      else
        score*=0
      end
    when 0x5B # Tailwind
      maxdam = checkAIdamage(aimem,attacker,opponent,skill)
      if attacker.pbOwnSide.effects[PBEffects::Tailwind]>0
        score = 0
      else
        score*=1.5
        if ((attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) && !(roles.include?(PBMonRoles::LEAD) && @doublebattle)
          score*=0.9
          livecount=0
          outspeedcount=0
          for i in pbParty(attacker.index)
            next if i.nil?
            livecount+=1 if i.hp!=0
            outspeedcount+=1 if i.speed>opponent.speed
          end
          if livecount==1 && !roles.include?(PBMonRoles::SWEEPER)
            score*=0.4
          end
          if !@doublebattle
            if outspeedcount>=3 && maxdam>attacker.hp 
              score*=0.5
            end
          end
        end
        if maxdam>attacker.hp
          if ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) && (attacker.ability==PBAbilities::PRANKSTER && !attacker.abilitynulled) &&  ($fefieldeffect==16 || $fefieldeffect==27 || $fefieldeffect==28)
            score*=1.5
            if hasgreatmoves(initialscores,scoreindex,skill)
              score*=5
            end
          end
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::SPEEDBOOST)
          score*=0.8
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEAMENGINE)
          if $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==21 || $fefieldeffect==22 || $fefieldeffect==45
            score*=0.8
          end
        end
        score*=0.1 if @trickroom!=0 || checkAImoves([PBMoves::TRICKROOM],aimem)
        if roles.include?(PBMonRoles::LEAD)
          score*=1.4
        end
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect==3 # Misty
            fairyvar=false
            for mon in pbParty(attacker.index)
              next if mon.nil?
              if mon.hasType?(:FAIRY)
                fairyvar=true
              end
            end
            if !fairyvar
              score*=1.5
            end
          end
          if $fefieldeffect==7 # Burning
            firevar=false
            for mon in pbParty(attacker.index)
              next if mon.nil?
              if mon.hasType?(:FIRE)
                firevar=true
              end
              if !firevar
                score*=1.2
              end
            end
          end
          if $fefieldeffect==11 # Corromist
            poisonvar=false
            for mon in pbParty(attacker.index)
              next if mon.nil?
              if mon.hasType?(:POISON)
                poisonvar=true
              end
              if !poisonvar
                score*=1.2
              end
            end
          end
          if $fefieldeffect==16 || $fefieldeffect==27 || $fefieldeffect==28 # VolcanicTop/Mountain/Snowy Mountain
            for mon in pbParty(attacker.index)
              flyingvar=false
              next if mon.nil?
              if mon.hasType?(:FLYING)
                flyingvar=true
              end
              if flyingvar
                score*=1.5
              end
            end
          end
        end
      end
      if attacker.effects[PBEffects::FocusEnergy]!=2 &&  (move.name == "Z-Tailwind" && move.zmove)  && maxdam<attacker.hp
        miniscore=100     
        miniscore*=1.1 if (attacker.hp.to_f)/attacker.totalhp>0.75
        miniscore*=1.3 if opponent.effects[PBEffects::HyperBeam]>0
        miniscore*=1.7 if opponent.effects[PBEffects::Yawn]>0
        miniscore*=1.2 if (attacker.hp/2.0)>checkAIdamage(aimem,attacker,opponent,skill) 
        maxdamattacker=checkAIdamage(aimem,opponent,attacker,skill) 
        miniscore*=1.5 if (maxdamattacker*1.5>opponent.hp) && (maxdamattacker<opponent.hp)
        miniscore*=1.3 if opponent.status==PBStatuses::SLEEP || opponent.status==PBStatuses::FROZEN
        if opponent.effects[PBEffects::Encore]>0
          if opponent.moves[(opponent.effects[PBEffects::EncoreIndex])].basedamage==0
            miniscore*=1.5
          end
        end
        miniscore*=0.2 if attacker.effects[PBEffects::Confusion]>0
        miniscore*=0.6 if attacker.effects[PBEffects::LeechSeed]>=0 || attacker.effects[PBEffects::Attract]>=0
        miniscore*=0.5 if checkAImoves(PBStuff::SWITCHOUTMOVE,aimem)
        miniscore*=1.2 if !attacker.abilitynulled && (attacker.ability == PBAbilities::SUPERLUCK || attacker.ability == PBAbilities::SNIPER)
        miniscore/=100
        score*=miniscore
      end
    when 0x5C # Mimic
      blacklist=[
        0x02,   # Struggle
        0x14,   # Chatter
        0x5C,   # Mimic
        0x5D,   # Sketch
        0xB6    # Metronome
      ]
      miniscore = $pkmn_move[opponent.lastMoveUsed][1]
      if miniscore=0
        miniscore=40
      end
      miniscore+=100
      miniscore/=100.0
      if miniscore<=1.5
        miniscore*=0.5
      end
      score*=miniscore
      if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        if blacklist.include?($pkmn_move[opponent.lastMoveUsed][1]) || opponent.lastMoveUsed<0
          score*=0
        end
      else
        score*=0.5
      end
      if opponent.effects[PBEffects::Substitute] > 0
        score*=0
      end
    when 0x5D # Sketch
      blacklist=[
        0x02,   # Struggle
        0x14,   # Chatter
        0x5D,   # Sketch
      ]
      miniscore = $pkmn_move[opponent.lastMoveUsedSketch][1]
      if miniscore=0
        miniscore=40
      end
      miniscore+=100
      miniscore/=100.0
      if miniscore<=1.5
        miniscore*=0.5
      end
      score*=miniscore
      if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        if blacklist.include?($pkmn_move[opponent.lastMoveUsedSketch][0]) || opponent.lastMoveUsedSketch<0
          score*=0
        end
      else
        score*=0.5
      end
      if opponent.effects[PBEffects::Substitute]>0
        score*= 0
      end
    when 0x5E # Conversion
      fastermon = (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
      converted=attacker.clone
      miniscore = checkAIdamage(aimem,attacker,opponent,skill,true)
      convtype=attacker.type1
      convtype2=attacker.type2
      if !(converted.type1==attacker.moves[0].type)
        converted.type1=attacker.moves[0].type
        converted.type2=attacker.moves[0].type
        minimini  = checkAIdamage(aimem,converted,opponent,skill,true)
      else
        miniscore = checkAIdamage(aimem,attacker,opponent,skill,true)
        minimini  = checkAIdamage(aimem,attacker,opponent,skill,true)
      end
      if minimini<miniscore || (move.name == "Z-Conversion" && move.zmove)
        score*=3
        if fastermon
          score*=1.2
        else
          score*=0.8
        end
        stabvar = false
        for i in attacker.moves
          if i.type==attacker.type1 || i.type==attacker.type2
            stabvar = true
          end
        end
        if !stabvar
          score*=1.3
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::ADAPTABILITY)
          score*=1.5
        end
        if $feconversionuse==1
          score*=0.3
        end
      else 
        score*=0
      end
      if (move.name == "Z-Conversion" && move.zmove)
        if fastermon
          miniscore = setupminiscore(converted,opponent,skill,move,true,31,false,initialscores,scoreindex)
        else
          miniscore = setupminiscore(attacker,opponent,skill,move,true,31,false,initialscores,scoreindex)
        end
        ministat=0
        ministat+=opponent.stages[PBStats::ATTACK]
        ministat+=opponent.stages[PBStats::SPATK]
        ministat+=opponent.stages[PBStats::SPEED]
        if ministat>0
          minimini=(-5)*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        miniscore/=100.0
        score*=miniscore
        miniscore=100
        miniscore*=1.2 if checkAIhealing(aimem)
        if (attacker.pbSpeed<=pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
          miniscore*=1.3
        end
        if roles.include?(PBMonRoles::SWEEPER)
          miniscore*=1.3
        end
        if attacker.status==PBStatuses::PARALYSIS
          miniscore*=0.5
        end
        if attacker.hp==attacker.totalhp && ((attacker.hasWorkingItem(:FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) && !attacker.moldbroken) || (isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST)))  && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
          miniscore*=1.4
        end
        miniscore*=0.6 if checkAIpriority(aimem)
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::SPEEDBOOST)
          miniscore*=0.3
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEAMENGINE)
          if $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==21 || $fefieldeffect==22 || $fefieldeffect==45
            miniscore*=0.7
          end
        end
        if @trickroom!=0
          miniscore*=0.2
        else
          miniscore*=0.2 if checkAImoves([PBMoves::TRICKROOM],aimem)
        end
        miniscore+=100
        miniscore/=100.0
        score*=miniscore
        #score*=0 if (opponent.moves.any? {|moveloop| (PBStuff::PHASEMOVE).include?(moveloop.id)})
        #score*=0.3 if ((opponent.moves.any? {|moveloop| (PBMoves::CLEARSMOG).include?(moveloop.id)}) || (opponent.moves.any? {|moveloop| (PBMoves::HAZE).include?(moveloop.id)}))
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
          score=0.2
        end
        if attacker.pbTooHigh?(PBStats::ATTACK) && attacker.pbTooHigh?(PBStats::SPEED) && attacker.pbTooHigh?(PBStats::SPATK) && attacker.pbTooHigh?(PBStats::SPDEF) && attacker.pbTooHigh?(PBStats::DEFENSE)
          score*=0
        end
      end
      attacker.type1=convtype
      attacker.type2=convtype2
      if $fefieldeffect!=24 && $feconversionuse=1 && !(move.name == "Z-Conversion" && move.zmove)
        miniscore = getFieldDisruptScore(attacker,opponent,skill)
        if $feconversionuse!=2
          miniscore-=1
          miniscore/=2.0
          miniscore+=1
        end
        score*=miniscore
      end
    when 0x5F # Conversion 2
      if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        score*=1.2
      else
        score*=0.7
      end
      stabvar = false
      for i in attacker.moves
        if i.type==attacker.type1 || i.type==attacker.type2
          stabvar = true
        end
      end
      if stabvar
        score*=1.3
      else
        score*=0.7
      end
      if $feconversionuse==2
        score*=0.3
      end
      if $fefieldeffect!=24
        miniscore = getFieldDisruptScore(attacker,opponent,skill)
        if $feconversionuse!=1
          miniscore-=1
          miniscore/=2.0
          miniscore+=1
        end
        score*=miniscore
      end
    when 0x60 # Camouflage
      type = 0
      case $fefieldeffect
      when 1
        type = :ELECTRIC || 0
      when 2
        type = :GRASS || 0
      when 3
        type = :FAIRY || 0
      when 4
        type = :DARK || 0
      when 5
        type = :PSYCHIC || 0
      when 6
        type = :NORMAL || 0
      when 7
        type = :FIRE || 0
      when 8
        type = :WATER || 0
      when 9
        type = :DRAGON || 0
      when 10
        type = :POISON || 0
      when 11
        type = :POISON || 0
      when 12
        type = :GROUND || 0
      when 13
        type = :ICE || 0
      when 14
        type = :ROCK || 0
      when 15
        type = :GRASS || 0
      when 16
        type = :FIRE || 0
      when 17
        type = :STEEL || 0
      when 18
        type = :ELECTRIC || 0
      when 19
        type = :POISON || 0
      when 20
        type = :GROUND || 0
      when 21
        type = :WATER || 0
      when 22
        type = :WATER || 0
      when 23
        type = :ROCK || 0
      when 24
        type = :FLYING || 0
      when 26
        type = :POISON || 0
      when 27
        type = :ROCK || 0
      when 28
        type = :ICE || 0
      when 29
        type = :NORMAL || 0
      when 30
        type = :STEEL || 0
      when 31
        type = :FAIRY || 0
      when 32
        type = :DRAGON || 0
      when 33
        type = :GRASS || 0
      when 34
        type = :DARK || 0
      when 36
        type = :NORMAL || 0
      when 37
        type = :PSYCHIC || 0
      when 38
        type = :DARK || 0
      when 39
        type = :ICE || 0
      when 40
        type = :GHOST || 0
      when 41
        type = :POISON || 0
      when 42
        type = :FAIRY || 0
      when 43
        type = :FLYING || 0
      when 44
        type = :STEEL || 0
      when 45
        type = :FIRE || 0
      else
        type = :NORMAL || 0
      end
      typeid=getID(PBTypes,type)
      miniscore = [PBTypes.getCombinedEffectiveness(opponent.type1,attacker.type1,attacker.type2),PBTypes.getCombinedEffectiveness(opponent.type2,attacker.type1,attacker.type2)].max
      minimini = [PBTypes.getEffectiveness(opponent.type1,typeid),PBTypes.getEffectiveness(opponent.type2,typeid)].max
      if minimini < miniscore
        score*=2
        if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
          score*=1.2
        else
          score*=0.7
        end
        stabvar = false
        for i in attacker.moves
          if i.type==attacker.type1 || i.type==attacker.type2
            stabvar = true
          end
        end
        if !stabvar
          score*=1.2
        else
          score*=0.6
        end
      else
        score*=0
      end
    when 0x61 # Soak
      sevar = false
      for i in attacker.moves
        if (i.type == PBTypes::ELECTRIC) || (i.type == PBTypes::GRASS)
          sevar = true
        end
      end
      if sevar
        score*=1.5
      else
        score*=0.7
      end
      if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
        if attacker.pbHasMove?((PBMoves::TOXIC))
          if attacker.pbHasType?(:STEEL) || attacker.pbHasType?(:POISON)
            score*=1.5
          end
        end
      end
      movecheck=false
      for j in aimem
        movecheck=true if (j.type == PBTypes::WATER)
      end
      if movecheck
        score*=0.5
      else
        score*=1.1
      end
      if opponent.type1==(PBTypes::WATER) && opponent.type1==(PBTypes::WATER)
        score=0
      end
    when 0x62 # Reflect Type
      typeid=getID(PBTypes,type)
      miniscore = [PBTypes.getCombinedEffectiveness(opponent.type1,attacker.type1,attacker.type2),PBTypes.getCombinedEffectiveness(opponent.type2,attacker.type1,attacker.type2)].max
      minimini = [PBTypes.getCombinedEffectiveness(opponent.type1,opponent.type1,opponent.type2),PBTypes.getCombinedEffectiveness(opponent.type2,opponent.type1,opponent.type2)].max
      if minimini < miniscore
        score*=3
        if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
          score*=1.2
        else
          score*=0.7
        end
        stabvar = false
        oppstab = false
        for i in attacker.moves
          if i.type == attacker.type1 || i.type == attacker.type2
            stabvar = true
          end
          if i.type == opponent.type1 || i.type == opponent.type2
            oppstab = true
          end
        end
        if !stabvar
          score*=1.2
        end
        if oppstab
          score*=1.3
        end
      else
        score*=0
      end
      if isConst?(attacker.ability,PBAbilities,:MULTITYPE) || (attacker.type1 == opponent.type1 && attacker.type2 == opponent.type2) || (attacker.type1 == opponent.type2 && attacker.type2 == opponent.type1)
        score*=0
      end
    when 0x63 # Simple Beam
      if !(opponent.ability == PBAbilities::SIMPLE) && !(PBStuff::FIXEDABILITIES).include?(opponent.ability)
        miniscore = getAbilityDisruptScore(move,attacker,opponent,skill)
        if opponent == attacker.pbPartner
          if miniscore < 2
            miniscore = 2 - miniscore
          else
            miniscore = 0
          end
        end
        score*=miniscore
        if checkAImoves(PBStuff::SETUPMOVE,aimem)
          if opponent==attacker.pbPartner
            score*=1.3
          else
            score*=0.5
          end
        end
      else
        score*=0
      end
    when 0x64 # Worry Seed
      if !(opponent.ability == PBAbilities::INSOMNIA)  && opponent.effects[PBEffects::Substitute]<=0 && !(PBStuff::FIXEDABILITIES).include?(opponent.ability)
        miniscore = getAbilityDisruptScore(move,attacker,opponent,skill)
        score*=miniscore
        if checkAImoves([PBMoves::SNORE,PBMoves::SLEEPTALK],aimem)
          score*=1.3
        end
        if checkAImoves([PBMoves::REST],aimem)
          score*=2
        end
        if attacker.pbHasMove?((PBMoves::SPORE)) || attacker.pbHasMove?((PBMoves::SLEEPPOWDER)) || attacker.pbHasMove?((PBMoves::HYPNOSIS)) || attacker.pbHasMove?((PBMoves::SING)) || attacker.pbHasMove?((PBMoves::GRASSWHISTLE)) || attacker.pbHasMove?((PBMoves::DREAMEATER)) || attacker.pbHasMove?((PBMoves::NIGHTMARE)) || (!attacker.abilitynulled && attacker.ability == PBAbilities::BADDREAMS)
          score*=0.3
        end
      else
        score*=0
      end
    when 0x65 # Role Play
      score = 0 if (PBStuff::ABILITYBLACKLIST).include?(opponent.ability)
      score = 0 if (PBStuff::FIXEDABILITIES).include?(attacker.ability)
      if !(opponent.ability ==0 || attacker.ability==opponent.ability || attacker.ability == PBAbilities::DISGUISE) && score != 0
        miniscore = getAbilityDisruptScore(move,opponent,attacker,skill)
        minimini = getAbilityDisruptScore(move,attacker,opponent,skill)
        score *= (1 + (minimini-miniscore))
      else
        score=0
      end
    when 0x66 # Entrainment
      score = 0 if (PBStuff::FIXEDABILITIES).include?(opponent.ability)
      score = 0 if opponent.ability == PBAbilities::TRUANT
      score = 0 if (PBStuff::ABILITYBLACKLIST).include?(attacker.ability) && attacker.ability != PBAbilities::WONDERGUARD
      if !(opponent.ability ==0 || attacker.ability==opponent.ability) && score != 0
        miniscore = getAbilityDisruptScore(move,opponent,attacker,skill)
        minimini = getAbilityDisruptScore(move,attacker,opponent,skill)
        if opponent != attacker.pbPartner
          score *= (1 + (minimini-miniscore))
          if (attacker.ability == PBAbilities::TRUANT)
            score*=3
          elsif (attacker.ability == PBAbilities::WONDERGUARD)
            score=0
          end
        else
          score *= (1 + (miniscore-minimini))
          if (attacker.ability == PBAbilities::WONDERGUARD)
            score +=85
          elsif (attacker.ability == PBAbilities::SPEEDBOOST)
            score +=25
          elsif (opponent.ability == PBAbilities::DEFEATIST)
            score +=30
          elsif (opponent.ability == PBAbilities::SLOWSTART)
            score +=50
          end
        end
      else
        score=0
      end
    when 0x67 # Skill Swap
      score = 0 if (PBStuff::FIXEDABILITIES).include?(attacker.ability) && attacker.ability != PBAbilities::ZENMODE
      score = 0 if (PBStuff::FIXEDABILITIES).include?(opponent.ability) && opponent.ability != PBAbilities::ZENMODE
      score = 0 if opponent.ability == PBAbilities::ILLUSION || attacker.ability == PBAbilities::ILLUSION
      if !(opponent.ability ==0 || attacker.ability==opponent.ability) && score !=0
        miniscore = getAbilityDisruptScore(move,opponent,attacker,skill)
        minimini = getAbilityDisruptScore(move,attacker,opponent,skill)
        if opponent == attacker.pbPartner
          if minimini < 2
            minimini = 2 - minimini
          else
            minimini = 0
          end
        end
        score *= (1 + (minimini-miniscore)*2)
        if (attacker.ability == PBAbilities::TRUANT) && opponent!=attacker.pbPartner
          score*=2
        end
        if (opponent.ability == PBAbilities::TRUANT) && opponent==attacker.pbPartner
          score*=2
        end
      else
        score=0
      end
    when 0x68 # Gastro Acid
      miniscore = getAbilityDisruptScore(move,attacker,opponent,skill)
      score*=miniscore
      if opponent.effects[PBEffects::GastroAcid]  || opponent.effects[PBEffects::Substitute]>0 ||
        (PBStuff::FIXEDABILITIES).include?(opponent.ability)
        score = 0
      end
    when 0x69 # Transform
      if !(attacker.effects[PBEffects::Transform] || attacker.effects[PBEffects::Illusion] || attacker.effects[PBEffects::Substitute]>0)
        miniscore = opponent.level
        miniscore -= attacker.level
        miniscore*=5
        miniscore+=100
        miniscore/=100.0
        score*=miniscore
        miniscore=(10)*statchangecounter(opponent,1,5)
        miniscore+=100
        miniscore/=100.0
        score*=miniscore
        miniscore=(-10)*statchangecounter(attacker,1,5)
        miniscore+=100
        miniscore/=100.0
        score*=miniscore
      else
        score=0
      end
    when 0x6A # Sonicboom
    when 0x6B # Dragon Rage
    when 0x6C # Super Fang
    when 0x6D # Seismic Toss
    when 0x6E # Endeavor
      if attacker.hp > opponent.hp
        score=0
      else
        privar = false
        for i in attacker.moves
          if i.priority>0
            privar=true
          end
        end
        if privar
          score*=1.5
        end
        if ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) || attacker.hasWorkingItem(:FOCUSSASH) || (isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST))) && attacker.hp == attacker.totalhp
          score*=1.5
        end
        if pbWeather==PBWeather::SANDSTORM && (!opponent.pbHasType?(:ROCK) && !opponent.pbHasType?(:GROUND) && !opponent.pbHasType?(:STEEL))
          score*=1.5
        end
        if opponent.level - attacker.level > 9
          score*=2
        end
      end
    when 0x6F # Psywave
    when 0x70 # Fissure
      if !(opponent.level>attacker.level) && !(!opponent.abilitynulled && opponent.ability == PBAbilities::STURDY) && !(isConst?(opponent.species,PBSpecies,:RAMPARDOS) && isConst?(opponent.item,PBItems,:RAMPCREST))
        if opponent.effects[PBEffects::LockOn]>0 || (!attacker.abilitynulled && attacker.ability == PBAbilities::NOGUARD) 
          score*=3.5
        else
          score*=0.7
        end
      else
        score*=0
      end
      if move.id==getID(PBMoves,:FISSURE)
        if $fefieldeffect==17 # Factory
          score*=1.2
          darkvar=false
          for mon in pbParty(attacker.index)
            next if mon.nil?
            next if mon.hp==0
            if mon.hasType?(:DARK)
              darkvar=true
            end
          end
          if darkvar
            score*=1.5
          end
        end
      end
    when 0x71..0x73 # Counter, Mirror Coat, Metal Burst
      maxdam = checkAIdamage(aimem,attacker,opponent,skill)
      if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        score*=0.5
        score*=0.01 if move.function == 0x73
      end
      if ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) || (attitemworks && attacker.item == PBItems::FOCUSSASH) || (isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST))) && attacker.hp == attacker.totalhp
        score*=1.2
      else
        score*=0.8
        if maxdam>attacker.hp
          score*=0.8
        end
      end
      score*=0.7 if $pkmn_move[attacker.lastMoveUsed][0] == move.function
      score*=0.6 if checkAImoves(PBStuff::SETUPMOVE,aimem)
      score*=attacker.hp*(1.0/attacker.totalhp)
      if move.function == 0x71
        score*=0.3 if opponent.spatk>opponent.attack
        score*=0.05 if checkAIbest(aimem,3,[],false,attacker,opponent,skill)
        score*=1.1 if $pkmn_move[attacker.lastMoveUsed][0]==0x72
      elsif move.function == 0x72
        score*=0.3 if opponent.spatk<opponent.attack
        score*=0.05 if checkAIbest(aimem,2,[],false,attacker,opponent,skill)
        score*=1.1 if $pkmn_move[attacker.lastMoveUsed][0]==0x72
      end
    when 0x74 # Flame Burst
      if @doublebattle && opponent.pbPartner.hp>0
        score*=1.1
      end
      if $fefieldeffect != 0
        roastvar=false
        firevar=false
        poisvar=false
        icevar=false
        for mon in pbParty(attacker.index)
          next if mon.nil?
          next if mon.hp==0
          if mon.hasType?(:GRASS) || mon.hasType?(:BUG)
            roastvar=true
          end
          if mon.hasType?(:FIRE)
            firevar=true
          end
          if mon.hasType?(:POISON)
            poisvar=true
          end
          if mon.hasType?(:ICE)
            icevar=true
          end
        end
        if $fefieldeffect==2 || $fefieldeffect==15 || ($fefieldeffect==33 && $fecounter>1)
          if firevar && !roastvar
            score*=2
          end
        end
        if $fefieldeffect==16
          if firevar
            score*=2
          end
        end
        if $fefieldeffect==11
          if !poisvar
            score*=1.2
          end
          if attacker.hp*(1.0/attacker.totalhp)<0.2
            score*=2
          end
          if pbPokemonCount(pbParty(opponent.index))==1
            score*=5
          end
        end
        if $fefieldeffect==13 || $fefieldeffect==28
          if !icevar
            score*=1.5
          end
        end
      end
    when 0x75 # Surf
      if $fefieldeffect != 0
        firevar=false
        dragvar=false
        darkvar=false
        icevar=false
        rockvar=false
        flyvar=false
        eruptionvar=false
        for mon in pbParty(attacker.index)
          next if mon.nil?
          next if mon.hp==0
          if mon.hasType?(:FIRE)
            firevar=true
          end
          if mon.hasType?(:DRAGON)
            dragvar=true
          end
          if mon.hasType?(:DARK)
            darkvar=true
          end
          if mon.hasType?(:ICE)
            icevar=true
          end
          if mon.hasType?(:ROCK)
            rockvar=true
          end
          if mon.hasType?(:FLYING)
            flyvar=true
          end
        end
        if (attacker.ability == PBAbilities::BLAZE || attacker.ability == PBAbilities::FLAREBOOST || 
           attacker.ability == PBAbilities::FLASHFIRE || attacker.ability == PBAbilities::MAGMAARMOR)
           eruptionvar=true
        end
        if move.id==getID(PBMoves,:SURF)
          if $fefieldeffect==7
            if firevar
              score=0.7
            else
              score*=2
            end
          end
          if $fefieldeffect==16
            score*=0.7
          end
          if $fefieldeffect==32
            if dragvar || firevar
              score=0.7
            else
              score*=1.5
            end
          end
        end
        if move.id==getID(PBMoves,:LAVASURF)
          if $fefieldeffect==13
            if icevar
              score*=0.7
            else
              score*=2
            end
          end
          if $fefieldeffect==16
            if eruptionvar && !(attacker.effects[PBEffects::FlashFire]==true || attacker.effects[PBEffects::Blazed]==true)
              score*=1.5
            end
          end
          if $fefieldeffect==23 || $fefieldeffect==25
            if rockvar
              score*=0.7
            else
              score*=2
            end
          end
          if $fefieldeffect==27
            if flyvar || rockvar
              score*=0.7
            else
              score*=2
            end
          end
          if $fefieldeffect==28
            if flyvar || rockvar || icevar
              score*=0.7
            else
              score*=2
            end
          end
        end
      end
    when 0x76 # Earthquake
      darkvar=false
      rockvar=false
      dragvar=false
      icevar=false
      watervar
      for mon in pbParty(attacker.index)
        next if mon.nil?
        next if mon.hp==0
        if mon.hasType?(:DARK)
          darkvar=true
        end
        if mon.hasType?(:ROCK)
          rockvar=true
        end
        if mon.hasType?(:DRAGON)
          dragvar=true
        end
        if mon.hasType?(:ICE)
          icevar=true
        end
        if mon.hasType?(:WATER)
          watervar=true
        end
      end
      if $fefieldeffect==4
        if !darkvar
          score*=1.3
          if rockvar
            score*=1.2
          end
        end
      end
      if $fefieldeffect==25
        if !dragonvar
          score*=1.3
          if rockvar
            score*=1.2
          end
        end
      end
      if $fefieldeffect==13
        if (!icevar || watervar && ($febackup==21 || $febackup==22))
          score*=1.5
        end
      end
      if $fefieldeffect==17
        score*=1.2
        if darkvar
          score*=1.3
        end
      end
      if $fefieldeffect==23
        if !((!attacker.abilitynulled && attacker.ability == PBAbilities::ROCKHEAD) || (!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) || attacker.isbossmon)
          score*=0.7
        end
      end
      if $fefieldeffect==30
        if (opponent.stages[PBStats::EVASION] > 0 || opponent.hasWorkingItem(:BRIGHTPOWDER) || opponent.hasWorkingItem(:LAXINCENSE) ||
            ((!opponent.abilitynulled && opponent.ability == PBAbilities::SANDVEIL) && pbWeather==PBWeather::SANDSTORM) || ((!opponent.abilitynulled && opponent.ability == PBAbilities::SNOWCLOAK) && pbWeather==PBWeather::HAIL))
          score*=1.3
        else
          score*=0.5
        end
      end
      if $fefieldeffect==43
        score*=0
      end
    when 0x77 # Gust
      fairvar=false
      firevar=false
      poisvar=false
      for mon in pbParty(attacker.index)
        next if mon.nil?
        next if mon.hp==0
        if mon.hasType?(:FAIRY)
          fairvar=true
        end
        if mon.hasType?(:FIRE)
          firevar=true
        end
        if mon.hasType?(:POISON)
          poisvar=true
        end
      end
      if $fefieldeffect==3
        score*=1.3
        if !fairyvar
          score*=1.3
        else
          score*=0.6
        end
      end
      if $fefieldeffect==7
        if !firevar
          score*=1.8
        else
          score*=0.5
        end
      end
      if $fefieldeffect==11
        if !poisvar
          score*=3
        else
          score*=0.8
        end
      end
    when 0x78 # Twister
      if opponent.effects[PBEffects::Substitute]==0 && !(!opponent.abilitynulled && opponent.ability == PBAbilities::INNERFOCUS)
        if (pbRoughStat(opponent,PBStats::SPEED,skill)<attacker.pbSpeed) ^ (@trickroom!=0)
          miniscore=100
          miniscore*=1.3
          if skill>=PBTrainerAI.highSkill
            if $fefieldeffect==14 # Rocky
              miniscore*=1.2
            end
          end
          if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEADFAST)
            miniscore*=0.3
          end
          miniscore-=100
          miniscore*=(move.addlEffect.to_f/100)
          miniscore+=100
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
            miniscore*=2
          end
          miniscore/=100.0
          score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !((!opponent.abilitynulled && opponent.ability == PBAbilities::SHIELDDUST) && !opponent.moldbroken) && !hasgreatmoves(initialscores,scoreindex,skill,true)
        end
      end
      fairvar=false
      firevar=false
      poisvar=false
      for mon in pbParty(attacker.index)
        next if mon.nil?
        if mon.hasType?(:FAIRY)
          fairvar=true
        end
        if mon.hasType?(:FIRE)
          firevar=true
        end
        if mon.hasType?(:POISON)
          poisvar=true
        end
      end
      if $fefieldeffect==3
        score*=1.3
        if !fairyvar
          score*=1.3
        else
          score*=0.6
        end
      end
      if $fefieldeffect==7
        if !firevar
          score*=1.8
        else
          score*=0.5
        end
      end
      if $fefieldeffect==11
        if !poisvar
          score*=3
        else
          score*=0.8
        end
      end
      if $fefieldeffect==20
        score*=0.7
      end
    when 0x79 # Fusion Bolt - to do
    when 0x7A # Fusion Flare - to do
    when 0x7B # Venoshock- handled in base damage
    when 0x7C # Smelling Salts
      if opponent.status==PBStatuses::PARALYSIS
        score*=0.8
        if opponent.speed>attacker.speed && opponent.speed/2.0<attacker.speed
          score*=0.5
        end
      end
    when 0x7D # Wake-Up Slap
      if opponent.status==PBStatuses::SLEEP
        score*=0.8
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::BADDREAMS) || attacker.pbHasMove?(getID(PBMoves,:DREAMEATER)) || attacker.pbHasMove?(getID(PBMoves,:NIGHTMARE))
          score*=0.3
        end
        if opponent.pbHasMove?(getID(PBMoves,:SNORE)) || opponent.pbHasMove?(getID(PBMoves,:SLEEPTALK))
          score*=1.3
        end
      end
    when 0x7E # Facade - to do
    when 0x7F # Hex/Irritation - to do
    when 0x80 # Brine - to do
    when 0x81 # Revenge
      if (pbRoughStat(opponent,PBStats::SPEED,skill)<attacker.pbSpeed) ^ (@trickroom!=0)
        score*=0.5
      else
        score*=1.5
      end
      if attacker.hp==attacker.totalhp
        score*=1.2
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) || (attitemworks && attacker.item == PBItems::FOCUSSASH)
          score*=1.1
        end
      else
        score*=0.3 if checkAIdamage(aimem,attacker,opponent,skill)>attacker.hp
      end
      score*=0.8 if checkAImoves(PBStuff::SETUPMOVE,aimem)
    when 0x82 # Assurance
      if (pbRoughStat(opponent,PBStats::SPEED,skill)>attacker.pbSpeed) ^ (@trickroom!=0)
        score*=1.5
      end
    when 0x83 # Round
      if @doublebattle && attacker.pbPartner.pbHasMove?((PBMoves::ROUND))
        score*=1.5
      end
    when 0x84 # Payback
      if (pbRoughStat(opponent,PBStats::SPEED,skill)>attacker.pbSpeed) ^ (@trickroom!=0)
        score*=2
      end
    when 0x85 # Retaliate - to do
    when 0x86 # Acrobatics - to do
    when 0x87 # Weather Ball - to do
      if pbWeather==PBWeather::RAINDANCE && ((!opponent.abilitynulled && opponent.ability == PBAbilities::DRYSKIN) ||
          (!opponent.abilitynulled && opponent.ability == PBAbilities::STORMDRAIN) || (!opponent.abilitynulled && opponent.ability == PBAbilities::WATERABSORB))
        score*=0.1
      elsif pbWeather==PBWeather::SUNNYDAY && ((!opponent.abilitynulled && opponent.ability == PBAbilities::FLASHFIRE))
        score*0.1
      end
    when 0x88 # Pursuit
      miniscore=(-10)*statchangecounter(opponent,1,7,-1)
      miniscore+=100
      miniscore/=100.0
      score*=miniscore
      if opponent.effects[PBEffects::Confusion]>0
        score*=1.2
      end
      if opponent.effects[PBEffects::LeechSeed]>=0
        score*=1.5
      end
      if opponent.effects[PBEffects::Attract]>=0
        score*=1.3
      end
      if opponent.effects[PBEffects::Substitute]>0
        score*=0.7
      end
      if opponent.effects[PBEffects::Yawn]>0
        score*=1.5
      end
      if pbTypeModNoMessages(bettertype,attacker,opponent,move,skill)>4
        score*=1.5
      end
    when 0x89 # Return - to do
    when 0x8A # Frustration - to do
    when 0x8B # Water Spout
      if (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        score*=0.5
      end
      if skill>=PBTrainerAI.highSkill
        if move.id==getID(PBMoves,:WATERSPOUT)
          firevar=false
          watervar=false
          for mon in pbParty(attacker.index)
            next if mon.nil?
            if mon.hasType?(:FIRE)
              firevar=true
            end
            if mon.hasType?(:WATER)
              watervar=true
            end
          end
          
          if $fefieldeffect==7 # Burning
            if !firevar
              score*=1.5
            end
            if watervar
              score*=1.5
            end
          end
          if $fefieldeffect==16 # Superheated
            score*=0.7
          end
        end
        if move.id==getID(PBMoves,:ERUPTION)
          poisonvar=false
          watervar=false
          icevar=false
          firevar=false
          rockvar=false
          grassvar=false
          bugvar=false
          for mon in pbParty(attacker.index)
            next if mon.nil?
            if mon.hasType?(:POISON)
              poisonvar=true
            end
            if mon.hasType?(:WATER)
              watervar=true
            end
            if mon.hasType?(:ICE)
              icevar=true
            end
            if mon.hasType?(:FIRE)
              firevar=true
            end
            if mon.hasType?(:ROCK)
              rockvar=true
            end
            if mon.hasType?(:GRASS)
              grassvar=true
            end
            if mon.hasType?(:BUG)
              bugvar=true
            end
          end
          if $fefieldeffect==11 # Corromist
            if !poisonvar
              score*=1.5
            end
            if (attacker.hp.to_f)/attacker.totalhp<0.5
              score*=2
            end
          end
          if $fefieldeffect==13 # Icy
            if watervar
              score*=1.3
            end
            if !icevar
              score*=1.2
            end
          end
          if $fefieldeffect==16 # Superheated
            if pbWeather!=PBWeather::RAINDANCE && @field.effects[PBEffects::WaterSport]==0
              if (attacker.hp.to_f)/attacker.totalhp>0.5
                if firevar
                  score*=1.1
                end
              end
            end
          end
          if $fefieldeffect==23 # Cave
            if pbWeather!=PBWeather::RAINDANCE && @field.effects[PBEffects::WaterSport]==0
              if firevar
                score*=1.5
              end
              if !rockvar
                score*=1.5
              end
            end
          end
          if $fefieldeffect==27 # Mountain
            if !rockvar
              score*=1.5
            end
            if firevar
              score*=1.5
            end
          end
          if $fefieldeffect==28 # Snowy Mountain
            if !icevar
              score*=1.5
            end
            if firevar
              score*=1.5
            end
          end
          if $fefieldeffect==33 && $fecounter>=2 # Flower Garden
            if pbWeather!=PBWeather::RAINDANCE && @field.effects[PBEffects::WaterSport]==0
              if firevar
                score*=1.5
              end
              if !grassvar && !bugvar
                score*=1.5
              end
            end
          end
        end
      end
    when 0x8C # Crush Grip - to do
    when 0x8D # Gyro Ball - to do
    when 0x8E # Stored Power - to do
    when 0x8F # Punishment - to do
    when 0x90 # Hidden Power - to do
    when 0x91 # Fury Cutter
      if attacker.status==PBStatuses::PARALYSIS
        score*=0.7
      end
      if attacker.effects[PBEffects::Confusion]>0
        score*=0.7
      end
      if attacker.effects[PBEffects::Attract]>=0
        score*=0.7
      end
      if attacker.stages[PBStats::ACCURACY]<0
        ministat = attacker.stages[PBStats::ACCURACY]
        minimini = 15 * ministat
        minimini += 100
        minimini /= 100.0
        score*=minimini
      end
      miniscore = opponent.stages[PBStats::EVASION]
      miniscore*=(-5)
      miniscore+=100
      miniscore/=100.0
      score*=miniscore
      if attacker.hp==attacker.totalhp
        score*=1.3
      end
      score*=1.5 if checkAIdamage(aimem,attacker,opponent,skill)<(attacker.hp/3.0) 
      score*=0.8 if checkAImoves(PBStuff::PROTECTMOVE,aimem)
    when 0x92 # Echoed Voice
      if attacker.status==PBStatuses::PARALYSIS
        score*=0.7
      end
      if attacker.effects[PBEffects::Confusion]>0
        score*=0.7
      end
      if attacker.effects[PBEffects::Attract]>=0
        score*=0.7
      end
      if attacker.hp==attacker.totalhp
        score*=1.3
      end
      score*=1.5 if checkAIdamage(aimem,attacker,opponent,skill)<(attacker.hp/3.0)
    when 0x93 # Rage
      if attacker.attack>attacker.spatk
        score*=1.2
      end
      if attacker.hp==attacker.totalhp
        score*=1.3
      end
      score*=1.3 if checkAIdamage(aimem,attacker,opponent,skill)<(attacker.hp/4.0) 
    when 0x94 # Present
      if opponent.hp==opponent.totalhp
        score*=1.2
      end
    when 0x95 # Magnitude
      darkvar=false
      rockvar=false
      dragvar=false
      icevar=false
      for mon in pbParty(attacker.index)
        next if mon.nil?
        if mon.hasType?(:DARK)
          darkvar=true
        end
        if mon.hasType?(:ROCK)
          rockvar=true
        end
        if mon.hasType?(:DRAGON)
          dragvar=true
        end
        if mon.hasType?(:ICE)
          icevar=true
        end
      end
      if $fefieldeffect==4
        if !darkvar
          score*=1.3
          if rockvar
            score*=1.2
          end
        end
      end
      if $fefieldeffect==25
        if !dragonvar
          score*=1.3
          if rockvar
            score*=1.2
          end
        end
      end
      if $fefieldeffect==13
        if !icevar
          score*=1.5
        end
      end
      if $fefieldeffect==17
        score*=1.2
        if darkvar
          score*=1.3
        end
      end
      if $fefieldeffect==23
        score*=0.7
      end
      if $fefieldeffect==30
        if (opponent.stages[PBStats::EVASION] > 0 || opponent.hasWorkingItem(:BRIGHTPOWDER) || opponent.hasWorkingItem(:LAXINCENSE) ||
            ((!opponent.abilitynulled && opponent.ability == PBAbilities::SANDVEIL) && pbWeather==PBWeather::SANDSTORM) || ((!opponent.abilitynulled && opponent.ability == PBAbilities::SNOWCLOAK) && pbWeather==PBWeather::HAIL))
          score*=1.3
        else
          score*=0.5
        end
      end
      if $fefieldeffect==43
        score*=0
      end
    when 0x96 # Natural Gift
      if !pbIsBerry?(attacker.item) || (!attacker.abilitynulled && attacker.ability == PBAbilities::KLUTZ) || @field.effects[PBEffects::MagicRoom]>0 || attacker.effects[PBEffects::Embargo]>0 || (!opponent.abilitynulled && opponent.ability == PBAbilities::UNNERVE)
        score*=0
      end
    when 0x97 # Trump Card
      if attacker.hp==attacker.totalhp
        score*=1.2
      end
      score*=1.3 if checkAIdamage(aimem,attacker,opponent,skill)<(attacker.hp/3.0) 
    when 0x98 # Reversal
      if (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        score*=1.1
        if attacker.hp<attacker.totalhp
          score*1.3
        end
      end
    when 0x99 # Electro Ball - to do
    when 0x9A # Low Kick - to do
    when 0x9B # Heavy Slam - to do
    when 0x9C # Helping Hand
      if @doublebattle
        effvar = false
        for i in attacker.moves
          if pbTypeModNoMessages(i.type,attacker,opponent,i,skill)>=4
            effvar = true
          end
        end
        if !effvar
          score*=2
        end
        if ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) && ((attacker.pbSpeed<pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0))
          score*=1.2
          if attacker.hp*(1.0/attacker.totalhp) < 0.33
            score*=1.5
          end
          if attacker.pbPartner.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill) && attacker.pbPartner.pbSpeed<pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)
            score*=1.5
          end
        end
        ministat = [attacker.pbPartner.attack,attacker.pbPartner.spatk].max
        minimini = [attacker.attack,attacker.spatk].max
        ministat-=minimini
        ministat+=100
        ministat/=100.0
        score*=ministat
        if attacker.pbPartner.hp==0
          score*=0
        end
      else
        score*=0
      end
    when 0x9D # Mud Sport
      if @field.effects[PBEffects::MudSport]==0
        eff1 = PBTypes.getCombinedEffectiveness(PBTypes::ELECTRIC,attacker.type1,attacker.type2)
        eff2 = PBTypes.getCombinedEffectiveness(PBTypes::ELECTRIC,attacker.pbPartner.type1,attacker.pbPartner.type2)
        if eff1>4 || eff2>4 && opponent.hasType?(:ELECTRIC)
          score*=1.5
        end
        elevar=false
        for mon in pbParty(attacker.index)
          next if mon.nil?
          if mon.hasType?(:ELECTRIC)
            elevar=true
          end
        end
        if elevar
          score*=0.7
        end
        if $fefieldeffect==1
          if !elevar
            score*=2
          else
            score*=0.3
          end
        end
      else
        score*=0
      end
    when 0x9E # Water Sport
      if @field.effects[PBEffects::WaterSport]==0
        eff1 = PBTypes.getCombinedEffectiveness(PBTypes::FIRE,attacker.type1,attacker.type2)
        eff2 = PBTypes.getCombinedEffectiveness(PBTypes::FIRE,attacker.pbPartner.type1,attacker.pbPartner.type2)
        if eff1>4 || eff2>4 && opponent.hasType?(:FIRE)
          score*=1.5
        end
        firevar=false
        grassvar=false
        bugvar=false
        for mon in pbParty(attacker.index)
          next if mon.nil?
          if mon.hasType?(:FIRE)
            firevar=true
          end
          if mon.hasType?(:GRASS)
            grassvar=true
          end
          if mon.hasType?(:BUG)
            bugvar=true
          end
        end
        if firevar
          score*=0.7
        end
        if $fefieldeffect==7
          if !firevar
            score*=2
          else
            score*=0
          end
        elsif $fefieldeffect==16
          score*=0.7
          if !firevar
            score*=1.8
          else
            score*=0
          end
        elsif $fefieldeffect==2 || $fefieldeffect==15 || $fefieldeffect==33
          if !attacker.hasType?(:FIRE) && opponent.hasType?(:FIRE)
            score*=3
          end
          if grassvar || bugvar
            score*=2
            if $fefieldeffect==33 && $fecounter<4
              score*=3
            end
          end
          if firevar
            score*=0.5
          end
        end
      else
        score*=0
      end
    when 0x9F # Judgement - to do
      move.type = move.pbType(move.type,attacker,opponent)
    when 0xA0 # Frost Breath
      thisinitial = score
      if !(!opponent.abilitynulled && opponent.ability == PBAbilities::BATTLEARMOR) && !(!opponent.abilitynulled && opponent.ability == PBAbilities::SHELLARMOR) && attacker.effects[PBEffects::LaserFocus]==0
        miniscore = 100
        ministat = 0
        ministat += opponent.stages[PBStats::DEFENSE] if opponent.stages[PBStats::DEFENSE]>0
        ministat += opponent.stages[PBStats::SPDEF] if opponent.stages[PBStats::SPDEF]>0
        miniscore += 10*ministat
        ministat = 0
        ministat -= attacker.stages[PBStats::ATTACK] if attacker.stages[PBStats::ATTACK]<0
        ministat -= attacker.stages[PBStats::SPATK] if attacker.stages[PBStats::SPATK]<0
        miniscore += 10*ministat
        if attacker.effects[PBEffects::FocusEnergy]>0
          miniscore -= 10*attacker.effects[PBEffects::FocusEnergy]
        end
        miniscore/=100.0
        score*=miniscore
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::ANGERPOINT) && opponent.stages[PBStats::ATTACK]!=6
          if opponent == attacker.pbPartner
            if opponent.attack>opponent.spatk
              if thisinitial>99
                score=0
              else
                score = (100-thisinitial)
                enemy1 = attacker.pbOppositeOpposing
                enemy2 = enemy1.pbPartner
                if opponent.pbSpeed > enemy1.pbSpeed && opponent.pbSpeed > enemy2.pbSpeed
                  score*=1.3
                else
                  score*=0.7
                end
              end
            end
          else
            if thisinitial<100
              score*=0.7
              if opponent.attack>opponent.spatk
                score*=0.2
              end
            end
          end
        else
          if opponent == attacker.pbPartner
            score = 0
          end
        end
      else
        score*=0.7
      end
    when 0xA1 # Lucky Chant
      if attacker.pbOwnSide.effects[PBEffects::LuckyChant]==0  && !(!attacker.abilitynulled && attacker.ability == PBAbilities::BATTLEARMOR) || !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHELLARMOR) && (opponent.effects[PBEffects::FocusEnergy]>1 || opponent.effects[PBEffects::LaserFocus])
        score+=20
      end
    when 0xA2 # Reflect
      if attacker.pbOwnSide.effects[PBEffects::Reflect]<=0
        score*=1.2
        if attacker.pbOwnSide.effects[PBEffects::AuroraVeil]>0
          score*=0.5
        end
        if pbRoughStat(opponent,PBStats::ATTACK,skill)>pbRoughStat(opponent,PBStats::SPATK,skill)
          score*=1.3
        end
        if (attitemworks && attacker.item == PBItems::LIGHTCLAY)
          score*=1.5
        end
        maxdam3=checkAIdamage(aimem,attacker,opponent,skill)
        maxdam4=0
        if @doublebattle
          if !opponent.pbPartner.isFainted?
            maxdam4=checkAIdamage(aimem,attacker,opponent,skill)
          end
        end
        if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::PRANKSTER))
          score*=1.1
          maxdamreflect1=0
          maxdamreflect2=0
          attacker.pbOwnSide.effects[PBEffects::Reflect]=1
          for j in opponent.moves
            tempdam = pbRoughDamage(j,opponent,attacker,skill,j.basedamage)
            maxdamreflect1=tempdam if maxdamreflect1<tempdam
            if !(opponent.item == PBItems::INTERCEPTZ2) && pbCanZMove?(opponent.index)
              if opponent.pbCompatibleZMoveFromMove?(j)
                if j.id == PBMoves::NATUREPOWER
                  moveid = pbChangeMove(PBMoves::NATUREPOWER,opponent)
                  newmove = PokeBattle_Move.pbFromPBMove(battle,PBMove.new(moveid),opponent)
                else
                  newmove=j
                end
                zmove = PokeBattle_ZMoves2.new(newmove,opponent.item)
                tempdam = pbRoughDamage(zmove,opponent,attacker,skill,zmove.basedamage) 
                if tempdam>maxdamreflect1
                  maxdamreflect1=tempdam
                end
              end
            end
          end
          if @doublebattle
            if !opponent.pbPartner.isFainted?
              for j in opponent.pbPartner.moves
                tempdam = pbRoughDamage(j,opponent.pbPartner,attacker,skill,j.basedamage)
                maxdamreflect2=tempdam if maxdamreflect2<tempdam
                if !(opponent.pbPartner.item == PBItems::INTERCEPTZ2) && pbCanZMove?(opponent.pbPartner.index)
                  if opponent.pbPartner.pbCompatibleZMoveFromMove?(j)
                    if j.id == PBMoves::NATUREPOWER
                      moveid = pbChangeMove(PBMoves::NATUREPOWER,opponent.pbPartner)
                      newmove = PokeBattle_Move.pbFromPBMove(battle,PBMove.new(moveid),opponent.pbPartner)
                    else
                      newmove=j
                    end
                    zmove = PokeBattle_ZMoves2.new(newmove,opponent.pbPartner.item)
                    tempdam = pbRoughDamage(zmove,opponent.pbPartner,attacker,skill,zmove.basedamage) 
                    if tempdam>maxdamreflect2
                      maxdamreflect2=tempdam
                    end
                  end
                end
              end
            end
            if maxdamreflect1>0 || maxdamreflect2>0
              if (maxdam3>attacker.hp && (maxdamreflect1)<attacker.hp) || ((maxdam3+maxdam4>attacker.hp) && (((((maxdamreflect1)+maxdam4)<maxdam3+maxdam4)) || ((maxdamreflect2)+maxdam3)<maxdam3+maxdam4))
                score*=2
              end
            end
            if hasgreatmoves(initialscores,scoreindex,skill) && ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0))
              score*=5
            end
          end
          attacker.pbOwnSide.effects[PBEffects::Reflect]=0
        end
        score*=0.1 if checkAImoves([PBMoves::SNATCH],aimem)
        if @doublebattle && !opponent.pbPartner.isFainted?
          score*=0.1 if checkAImoves([PBMoves::SNATCH],aimem2)
        end
        livecount=0
        for i in pbParty(opponent.index)
          next if i.nil?
          livecount+=1 if i.hp!=0
          if (i.ability == PBAbilities::SCREENCLEANER) && i.hp>0
            score*=0.7
          end
        end
        if livecount<=2
          score*=0.7
          if livecount==1
            score*=0.7
          end
        end
        score*=0.1 if checkAImoves([PBMoves::SNATCH],aimem)
        if (((attitemworks && attacker.item == PBItems::FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) && !attacker.moldbroken)) && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
          score*=1.3
        end
        score*=0.1 if checkAImoves(PBStuff::SCREENBREAKERMOVE,aimem)
        breakcheck=false
        if !(opponent.pbPartner.nil?)
          if @doublebattle && @aiMoveMemory[2][opponent.pbPartner.pokemonIndex].length>0 && opponent.pbPartner.hp>0 
            for j in @aiMoveMemory[2][opponent.pbPartner.pokemonIndex]
              breakcheck = true if ((j.id==getID(PBMoves,:BRICKBREAK) || (j.id==getID(PBMoves,:PSYCHICFANGS) || (j.id==getID(PBMoves,:DEFOG)))))
            end
          end
        end
        score*=0.1 if breakcheck
      else
        score=0
      end
    when 0xA3 # Light Screen
      if attacker.pbOwnSide.effects[PBEffects::LightScreen]<=0
        score*=1.2
        if attacker.pbOwnSide.effects[PBEffects::AuroraVeil]>0
          score*=0.5
        end
        if pbRoughStat(opponent,PBStats::ATTACK,skill)<pbRoughStat(opponent,PBStats::SPATK,skill)
          score*=1.3
        end
        if (attitemworks && attacker.item == PBItems::LIGHTCLAY)
          score*=1.5
        end
        maxdam3=checkAIdamage(aimem,attacker,opponent,skill)
        maxdam4=0
        if @doublebattle
          if !opponent.pbPartner.isFainted?
            maxdam4=checkAIdamage(aimem,attacker,opponent,skill)
          end
        end
        if ((attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::PRANKSTER))
          score*=1.1
          maxdamlightscreen=0
          maxdamlightscreen2=0
          attacker.pbOwnSide.effects[PBEffects::LightScreen]=1
          for j in opponent.moves
            tempdam = pbRoughDamage(j,opponent,attacker,skill,j.basedamage)
            maxdamlightscreen=tempdam if maxdamlightscreen<tempdam
            if !(opponent.item == PBItems::INTERCEPTZ2) && pbCanZMove?(opponent.index)
              if opponent.pbCompatibleZMoveFromMove?(j)
                if j.id == PBMoves::NATUREPOWER
                  moveid = pbChangeMove(PBMoves::NATUREPOWER,opponent)
                  newmove = PokeBattle_Move.pbFromPBMove(battle,PBMove.new(moveid),opponent)
                else
                  newmove=j
                end
                zmove = PokeBattle_ZMoves2.new(newmove,opponent.item)
                tempdam = pbRoughDamage(zmove,opponent,attacker,skill,zmove.basedamage) 
                if tempdam>maxdamlightscreen
                  maxdamlightscreen=tempdam
                end
              end
            end
          end
          if @doublebattle
            if !opponent.pbPartner.isFainted?
              for j in opponent.pbPartner.moves
                tempdam = pbRoughDamage(j,opponent.pbPartner,attacker,skill,j.basedamage)
                maxdamlightscreen2=tempdam if maxdamlightscreen2<tempdam
                if !(opponent.pbPartner.item == PBItems::INTERCEPTZ2) && pbCanZMove?(opponent.pbPartner.index)
                  if opponent.pbPartner.pbCompatibleZMoveFromMove?(j)
                    if j.id == PBMoves::NATUREPOWER
                      moveid = pbChangeMove(PBMoves::NATUREPOWER,opponent.pbPartner)
                      newmove = PokeBattle_Move.pbFromPBMove(battle,PBMove.new(moveid),opponent.pbPartner)
                    else
                      newmove=j
                    end
                    zmove = PokeBattle_ZMoves2.new(newmove,opponent.pbPartner.item)
                    tempdam = pbRoughDamage(zmove,opponent.pbPartner,attacker,skill,zmove.basedamage) 
                    if tempdam>maxdamlightscreen2
                      maxdamlightscreen2=tempdam
                    end
                  end
                end
              end
            end
          end
          attacker.pbOwnSide.effects[PBEffects::LightScreen]=0
          if maxdamlightscreen>0 || maxdamlightscreen2>0
            if (maxdam3>attacker.hp && (maxdamlightscreen)<attacker.hp) || ((maxdam3+maxdam4>attacker.hp) && (((((maxdamlightscreen)+maxdam4)<maxdam3+maxdam4)) || ((maxdamlightscreen2)+maxdam3)<maxdam3+maxdam4))
              score*=2
            end
          end
          if hasgreatmoves(initialscores,scoreindex,skill) && ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0))
            score*=5
          end
        end
        livecount=0
        for i in pbParty(opponent.index)
          next if i.nil?
          livecount+=1 if i.hp!=0
          if (i.ability == PBAbilities::SCREENCLEANER) && i.hp>0
            score*=0.7
          end
        end
        score*=0.1 if checkAImoves([PBMoves::SNATCH],aimem)
        if @doublebattle && !opponent.pbPartner.isFainted?
          score*=0.1 if checkAImoves([PBMoves::SNATCH],aimem2)
        end
        if livecount<=2
          score*=0.7
          if livecount==1
            score*=0.7
          end
        end
        if (((attitemworks && attacker.item == PBItems::FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) && !attacker.moldbroken)) && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
          score*=1.3
        end
        score*=0.1 if checkAImoves(PBStuff::SCREENBREAKERMOVE,aimem)
        breakcheck=false
        if !(opponent.pbPartner.nil?)
          if @doublebattle && @aiMoveMemory[2][opponent.pbPartner.pokemonIndex].length>0 && opponent.pbPartner.hp>0 
            for j in @aiMoveMemory[2][opponent.pbPartner.pokemonIndex] 
              breakcheck = true if ((j.id==getID(PBMoves,:BRICKBREAK) || (j.id==getID(PBMoves,:PSYCHICFANGS) || (j.id==getID(PBMoves,:DEFOG)))))
            end
          end
        end
        score*=0.1 if breakcheck
      else
        score=0
      end
    when 0xA4 # Secret Power
      score*=1.2
    when 0xA5 # Never Miss
      if score==110
        score*=1.1
      end
      if !(!attacker.abilitynulled && attacker.ability == PBAbilities::NOGUARD) && !(!opponent.abilitynulled && opponent.ability == PBAbilities::NOGUARD)
        if attacker.stages[PBStats::ACCURACY]<0
          miniscore = (-5)*attacker.stages[PBStats::ACCURACY]
          miniscore+=100
          miniscore/=100.0
          score*=miniscore
        end
        if opponent.stages[PBStats::EVASION]>0
          miniscore = (5)*opponent.stages[PBStats::EVASION]
          miniscore+=100
          miniscore/=100.0
          score*=miniscore
        end
        if opponent.hasWorkingItem(:LAXINCENSE) || opponent.hasWorkingItem(:BRIGHTPOWDER)
          score*=1.2
        end
        if ((!opponent.abilitynulled && opponent.ability == PBAbilities::SANDVEIL) && pbWeather==PBWeather::SANDSTORM) || ((!opponent.abilitynulled && opponent.ability == PBAbilities::SNOWCLOAK) && pbWeather==PBWeather::HAIL)
          score*=1.3
        end
        if opponent.vanished && ((attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0))
          score*=3
        end
      end
    when 0xA6 # Lock On
      if opponent.effects[PBEffects::LockOn]>0
        score*=0
      else
        if attacker.pbHasMove?(getID(PBMoves,:INFERNO)) || attacker.pbHasMove?(getID(PBMoves,:ZAPCANNON)) || attacker.pbHasMove?(getID(PBMoves,:DYNAMICPUNCH))
          if !(!attacker.abilitynulled && attacker.ability == PBAbilities::NOGUARD) && !(!opponent.abilitynulled && opponent.ability == PBAbilities::NOGUARD)
            score*=3
          end
        end
        if attacker.pbHasMove?(getID(PBMoves,:GUILLOTINE)) || attacker.pbHasMove?(getID(PBMoves,:SHEERCOLD)) || attacker.pbHasMove?(getID(PBMoves,:GUILLOTINE)) || attacker.pbHasMove?(getID(PBMoves,:FISSURE)) || attacker.pbHasMove?(getID(PBMoves,:HORNDRILL))
          score*=10
        end
        ministat=0
        ministat = attacker.stages[PBStats::ACCURACY] if attacker.stages[PBStats::ACCURACY]<0
        ministat*=10
        ministat+=100
        ministat/=100.0
        score*=ministat
        ministat = opponent.stages[PBStats::EVASION]
        ministat*=10
        ministat+=100
        ministat/=100.0
        score*=ministat
      end
      if $fefieldeffect==37
        if isConst?(move.id,PBMoves,:MINDREADER)
          if attacker.stages[PBStats::SPATK]<6
            score+=10
          end
          if attacker.spatk>attacker.attack
            score*=2
          end
          if attacker.hp==attacker.totalhp
            score*=1.5
          else
            score*=0.8
          end
          if roles.include?("Sweeper")
            score*=1.3
          end
          if attacker.hp<attacker.totalhp*0.5
            score*=0.5
          end
        end
      end
    when 0xA7 # Foresight
      if opponent.effects[PBEffects::Foresight]
        score*=0
      else
        ministat = 0
        ministat = opponent.stages[PBStats::EVASION] if opponent.stages[PBStats::EVASION]>0
        ministat*=10
        ministat+=100
        ministat/=100.0
        score*=ministat
        if opponent.pbHasType?(:GHOST)
          score*=1.5
          effectvar = false
          for i in attacker.moves
            next if i.basedamage==0
            if !isConst?(i.type,PBTypes,:NORMAL) && !isConst?(i.type,PBTypes,:FIGHTING)
              effectvar = true
              break
            end
          end
          if !effectvar && !(!attacker.abilitynulled && attacker.ability == PBAbilities::SCRAPPY) && !SilvallyCheck(attacker,PBTypes::NORMAL)
            score*=5
          end
        end
      end
    when 0xA8 # Miracle Eye
      if opponent.effects[PBEffects::MiracleEye]
        score*=0
      else
        ministat = 0
        ministat = opponent.stages[PBStats::EVASION] if opponent.stages[PBStats::EVASION]>0
        ministat*=10
        ministat+=100
        ministat/=100.0
        score*=ministat
        if opponent.pbHasType?(:GDARK)
          score*=1.1
          effectvar = false
          for i in attacker.moves
            next if i.basedamage==0
            if !isConst?(i.type,PBTypes,:PSYCHIC)
              effectvar = true
              break
            end
          end
          if !effectvar
            score*=2
          end
        end
      end
      if $fefieldeffect==37 || $fefieldeffect==29 || $fefieldeffect==31
        if attacker.stages[PBStats::SPATK]<6
          score+=10
        end
        if attacker.spatk>attacker.attack
          score*=2
        end
        if attacker.hp==attacker.totalhp
          score*=1.5
        else
          score*=0.8
        end
        if roles.include?("Sweeper")
          score*=1.3
        end
        if attacker.hp<attacker.totalhp*0.5
          score*=0.5
        end
      end
    when 0xA9 # Chip Away
      ministat = 0
      ministat+=opponent.stages[PBStats::EVASION] if opponent.stages[PBStats::EVASION]>0
      ministat+=opponent.stages[PBStats::DEFENSE] if opponent.stages[PBStats::DEFENSE]>0
      ministat+=opponent.stages[PBStats::SPDEF] if opponent.stages[PBStats::SPDEF]>0
      ministat*=5
      ministat+=100
      ministat/=100.0
      score*=ministat
    when 0xAA # Protect
      if (opponent.effects[PBEffects::Taunt]==0 && attacker.effects[PBEffects::Wish]==0)
         score*=0.5 if opponent.moves.any? {|moveloop| (PBStuff::SETUPMOVE).include?(moveloop.id)} && !(attacker.ability == PBAbilities::SPEEDBOOST)
      end
      if ((!attacker.abilitynulled && attacker.ability == PBAbilities::SPEEDBOOST) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STEAMENGINE) && $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==21 || $fefieldeffect==22 || $fefieldeffect==45)) && attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill) && @trickroom==0
        if (attacker.pbSpeed*1.5>pbRoughStat(opponent,PBStats::SPEED,skill)) || (opponent.pbOwnSide.effects[PBEffects::Tailwind]>0) || (attacker==@battlers[2] && (attacker.stages[PBStats::SPEED]==0))
          score*=4 
        end
      end
      abusevar=false
      setupvar=false
      increment=0
      speedbuff=false
      for j in opponent.moves
        if (j.id==getID(PBMoves,:SWORDSDANCE) || j.id==getID(PBMoves,:DRAGONDANCE) || j.id==getID(PBMoves,:CALMMIND) || j.id==getID(PBMoves,:WORKUP) || j.id==getID(PBMoves,:NASTYPLOT) || j.id==getID(PBMoves,:TAILGLOW) || j.id==getID(PBMoves,:BELLYDRUM) || j.id==getID(PBMoves,:BULKUP) || j.id==getID(PBMoves,:COIL) || j.id==getID(PBMoves,:CURSE) || j.id==getID(PBMoves,:GROWTH) || j.id==getID(PBMoves,:HONECLAWS) || j.id==getID(PBMoves,:QUIVERDANCE) || j.id==getID(PBMoves,:SHELLSMASH))
          setupvar=true
        end
        if setupvar==true
          increment=1.5
        end
        if (j.id==PBMoves::NASTYPLOT && opponent.spatk>opponent.attack) || (j.id==PBMoves::SWORDSDANCE && opponent.attack>opponent.spatk) || ((j.id==PBMoves::SHELLSMASH))
          increment=2
        end
        if ((j.id==PBMoves::TAILGLOW))
          increment=2.5
        end
        if ((j.id==PBMoves::BELLYDRUM))
          increment=4
        end
        if (j.id==PBMoves::QUIVERDANCE && opponent.spatk>opponent.attack) ||  (j.id==PBMoves::DRAGONDANCE && opponent.spatk>opponent.attack) || (j.id==PBMoves::SHELLSMASH)
          if ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)*1.5) ^ (@trickroom!=0)) || ((j.id==PBMoves::SHELLSMASH) && ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)*2) ^ (@trickroom!=0)))
            speedbuff=true
          end
        end
      end
      if opponent.pbHasMove?(getID(PBMoves,:SUBSTITUTE))
        abusevar=true
      end
      fastermon=((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0))
      score*=1.1 if (isConst?(opponent.species,PBSpecies,:FERALIGATR) && oppitemworks && opponent.item == PBItems::FERACREST && opponent.turncount==0)
      score*=1.2 if (opponent.status==PBStatuses::POISON || opponent.status==PBStatuses::BURN)
      score*=1.3 if opponent.effects[PBEffects::Toxic]>0
      score*=0.3 if opponent.status==PBStatuses::SLEEP || opponent.status==PBStatuses::FROZEN
      hpchange=(EndofTurnHPChanges(attacker,opponent,false,false,true)) # what % of our hp will change after end of turn effects go through
      maxdam=checkAIdamage(aimem,attacker,opponent,skill)
      maxdam2=checkAIdamage(aimem,opponent,attacker,skill)
      if hpchange>1 ## we are going to be healing more hp than we take chip damage for  
        if attacker.hp!=attacker.totalhp
          score*=(1.3*hpchange) 
          if maxdam>attacker.hp
            healing=((attacker.totalhp*(hpchange-1)))
            if attacker.hp+(healing)>maxdam 
              if (abusevar==false || (abusevar==true && fastermon==true && speedbuff==false && maxdam2>opponent.hp/4)) && (!fastermon && maxdam2>opponent.hp)
                score*=2
              end
            end
          end
        end
      elsif hpchange<1 ## we are going to be taking more chip damage than we are going to heal
        score*=(1*hpchange)
        score*=0.3 if attacker.effects[PBEffects::Toxic]>4
      elsif hpchange<=0 ## we are going to die to future sight/doom desire or huge overstack of end of turn effects. hence we should just not heal.
        score*=0.1
      end
      opphpchange=(EndofTurnHPChanges(opponent,attacker,false,false,true)) # what % of our hp will change after end of turn effects go through
      if opphpchange!=1
        if opphpchange<1
          opphploss=1-opphpchange
          if opphploss<1
            opphploss=(opphploss*opponent.totalhp)
            if opphploss>(opponent.totalhp/4)
              score*=1.5
              if maxdam>attacker.hp
                score*=2
              end
            end
            if opphploss>opponent.hp
              if !(attacker.lastMoveUsed == 391)
                score*=2
              end
              if ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) 
                if maxdam>attacker.hp 
                  score*=4
                  if attacker.lastMoveUsed == 391
                    score/=(attacker.effects[PBEffects::ProtectRate]*3.0)
                  end
                end
              end
            else
              if ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) && maxdam>attacker.hp
                score*=4
              else
                if maxdam>attacker.hp
                  score*=4
                  if attacker.lastMoveUsed == 391
                    score/=(attacker.effects[PBEffects::ProtectRate]*3.0)
                  end
                end
              end
            end
          end
        end
      end
      if opponent.effects[PBEffects::PerishSong]!=0
        score*=2
        if opponent.effects[PBEffects::PerishSong]==2
          score*=1.5 if maxdam>(attacker.hp/2)
        end
      end
      if opponent.effects[PBEffects::Torment]
        lastuseddam=0
        for i in opponent.moves
          if i.function==$pkmn_move[opponent.lastMoveUsed][0]
            tempdam = pbRoughDamage(i,opponent,attacker,skill,i.basedamage)
            lastuseddam=tempdam if lastuseddam<tempdam
          end
        end
        if maxdam==lastuseddam
          score*=2
        end
      end
      if attacker.lastMoveUsed!=391 && attacker.lastMoveUsed!=121
        if (opponent.lastMoveUsed==254 || opponent.lastMoveUsed==510)
          score*=2
        end
      end
      if (opponent.effects[PBEffects::KingsShield]== true ||
        opponent.effects[PBEffects::BanefulBunker]== true ||
        opponent.effects[PBEffects::SpikyShield]== true) || (attitemworks && attacker.item == PBItems::FOCUSSASH) && opponent.pbHasMove?(getID(PBMoves,:FAKEOUT))
        if maxdam2>(opponent.hp/2)
          score*=2
        end
      end
      if (opponent.pbOwnSide.effects[PBEffects::Tailwind]>0) 
        if attacker.pbOwnSide.effects[PBEffects::Tailwind]>0 
          if (opponent.pbOwnSide.effects[PBEffects::Tailwind] < attacker.pbOwnSide.effects[PBEffects::Tailwind]) && ((attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0))
             score*=0.5
          elsif ((opponent.pbOwnSide.effects[PBEffects::Tailwind] < attacker.pbOwnSide.effects[PBEffects::Tailwind]) && ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)))
            if opponent.pbOwnSide.effects[PBEffects::Tailwind]==1
              score*=6
            end
            if maxdam>attacker.hp
              if attacker.lastMoveUsed == 391
                if !((maxdam*0.85)<attacker.hp)
                  score*=2
                end
              else
                if (abusevar==false) && (setupvar==false || setupvar==true && (speedbuff==false || increment<2)) 
                  score*=5
                end
              end
            end
          elsif (opponent.pbOwnSide.effects[PBEffects::Tailwind]>attacker.pbOwnSide.effects[PBEffects::Tailwind])
             score*=1.5
             if attacker.pbOwnSide.effects[PBEffects::Tailwind]==1 
                if ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0))
                  if maxdam>attacker.hp
                    if (abusevar==false) && (setupvar==false || setupvar==true && (speedbuff==false || increment<2)) 
                      score*=2
                    end
                  end
                end
             end
             if opponent.pbOwnSide.effects[PBEffects::Tailwind]==1
               score*=6
             end
          end
        else  
          if opponent.pbOwnSide.effects[PBEffects::Tailwind]==1
            if (abusevar==false) && (setupvar==false || setupvar==true && (speedbuff==false || increment<2)) 
              score*=6
            else
              if (setupvar==true && ((attacker.pbSpeed>opponent.speed && speedbuff==true) || increment>2 && opponent.speed>attacker.pbSpeed)) 
                if !(maxdam*increment>attacker.hp && maxdam<attacker.hp)
                  score*=6
                end
              elsif (abusevar==true)
                if (!fastermon && maxdam2>opponent.hp/4 && maxdam<attacker.hp)
                  score*=4
                end
              end
            end
          end
          if ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) 
            if maxdam>attacker.hp
              if attacker.lastMoveUsed == 391
                if !((maxdam*0.85)<attacker.hp)
                  score*=2
                end
              else
                if (abusevar==false) && (setupvar==false || setupvar==true && (speedbuff==false || increment<2)) 
                  score*=5
                end
              end
            end
          else
            if attacker.lastMoveUsed == 391
              score/=(attacker.effects[PBEffects::ProtectRate]*3.0)
            end
          end
        end
      elsif attacker.pbOwnSide.effects[PBEffects::Tailwind]>0 
        score*=0.4
      end
      if attacker.effects[PBEffects::KingsShield]== true  ||
        attacker.effects[PBEffects::BanefulBunker]== true ||
        attacker.effects[PBEffects::SpikyShield]== true
        score*=0
      end
      if @doublebattle && !(attacker.lastMoveUsed == 391)
        if !(opponent.isFainted?) && !(opponent.pbPartner.isFainted?)
          maxdam3=checkAIdamage(aimem,opponent,attacker.pbPartner,skill)
          maxdam4=checkAIdamage(aimem,opponent.pbPartner,attacker.pbPartner,skill)
          maxdam5=checkAIdamage(aimem,attacker.pbPartner,opponent,skill)
          maxdam6=checkAIdamage(aimem,attacker.pbPartner,opponent.pbPartner,skill)
          maxdam7=checkAIdamage(aimem,attacker,opponent.pbPartner,skill)
          if ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0) && (((attacker.pbPartner.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0) && maxdam3>opponent.hp) || ((attacker.pbSpeed<pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0) && (attacker.pbPartner.pbSpeed>pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0) && maxdam4>opponent.pbPartner.hp)))
            if (maxdam>attacker.hp || maxdam7>attacker.hp || maxdam+maxdam7>attacker.hp && (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0) && (attacker.pbSpeed<pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0))
              score*=4
            end
          end
        end
      end
      if @weather!=@weatherbackup
        score*=2 if (!attacker.abilitynulled && attacker.ability == PBAbilities::SWIFTSWIM) && (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) && @weatherbackup==PBWeather::RAINDANCE && @weatherduration==1
        score*=2 if (!attacker.abilitynulled && attacker.ability == PBAbilities::SANDRUSH) && (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) && @weatherbackup==PBWeather::SANDSTORM && @weatherduration==1
        score*=2 if (!attacker.abilitynulled && attacker.ability == PBAbilities::CHLOROPHYLL) && (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) && @weatherbackup==PBWeather::SUNNYDAY && @weatherduration==1
        score*=2 if (!attacker.abilitynulled && attacker.ability == PBAbilities::SLUSHRUSH) && (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) && @weatherbackup==PBWeather::HAIL && @weatherduration==1
      end
      if opponent.vanished
        score*=2
        score*=1.5 if (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
      end
      score*=0.1 if checkAImoves(PBStuff::PROTECTIGNORINGMOVE,aimem)
      if !(attacker==@battlers[2])
        if !(opponent.effects[PBEffects::Attacking]==true)
          if !(opponent.effects[PBEffects::AttackingTarget].include?(attacker.index))
            rnd=pbAIRandom(10)
            if rnd>=7
              score*=0.01 
            end
          end
        end
      end
      if attacker.effects[PBEffects::Wish]>0
        if attacker.hp!=attacker.totalhp
          if checkAIdamage(aimem,attacker,opponent,skill)>attacker.hp
            score*=10
          elsif checkAIdamage(aimem,attacker,opponent,skill)>attacker.hp
            score*=3
          end
        end
      end
      ratesharers=[391,121,122,515,361,584,603,641,786]   # Protect, Detect, Quick Guard, Wide Guard, Endure, King's Shield, Spiky Shield, Baneful Bunker, Obstruct in that order
      score/=(attacker.effects[PBEffects::ProtectRate]*3.0) if ratesharers.include?(attacker.lastMoveUsed)
    when 0xAB # Quick Guard
      ratesharers=[391,121,122,515,361,584,603,641,786]   # Protect, Detect, Quick Guard, Wide Guard, Endure, King's Shield, Spiky Shield, Baneful Bunker, Obstruct in that order
      score/=(attacker.effects[PBEffects::ProtectRate]*2.0) if ratesharers.include?(attacker.lastMoveUsed)
      if ((!opponent.abilitynulled && opponent.ability == PBAbilities::GALEWINGS) && opponent.hp == opponent.totalhp) || ((!opponent.abilitynulled && opponent.ability == PBAbilities::PRANKSTER) && attacker.pbHasType?(:DARK)) || checkAIpriority(aimem)
        score*=2
        if @doublebattle
          score*=1.3
          score*=0.3 if checkAIhealing(aimem) || checkAImoves(PBStuff::SETUPMOVE,aimem)
          score*=0.1 if checkAImoves(PBStuff::PROTECTIGNORINGMOVE,aimem)
          if attacker.effects[PBEffects::Wish]>0
            score*=2 if checkAIdamage(aimem,attacker,opponent,skill)>attacker.hp || (attacker.pbPartner.hp*(1.0/attacker.pbPartner.totalhp))<0.25
          end
        end
      else
        score*=0
      end
    when 0xAC # Wide Guard
      ratesharers=[391,121,122,515,361,584,603,641,786]   # Protect, Detect, Quick Guard, Wide Guard, Endure, King's Shield, Spiky Shield, Baneful Bunker, Obstruct in that order
      score/=(attacker.effects[PBEffects::ProtectRate]*2.0) if ratesharers.include?(attacker.lastMoveUsed)
      widevar = false
      for j in aimem
        widevar = true if (j.target == PBTargets::AllOpposing || j.target == PBTargets::AllNonUsers)
      end
      if @doublebattle
        if widevar
          score*=2
          score*=0.3 if checkAIhealing(aimem) || checkAImoves(PBStuff::SETUPMOVE,aimem)
          score*=0.1 if checkAImoves(PBStuff::PROTECTIGNORINGMOVE,aimem)
          if attacker.effects[PBEffects::Wish]>0
            maxdam = checkAIdamage(aimem,attacker,opponent,skill)
            if maxdam>attacker.hp || (attacker.pbPartner.hp*(1.0/attacker.pbPartner.totalhp))<0.25
              score*=2
            end
          end
          if $fefieldeffect==11
            score*=2 if checkAImoves([PBMoves::HEATWAVE,PBMoves::LAVAPLUME,PBMoves::ERUPTION,PBMoves::MINDBLOWN],aimem)
          end
          if $fefieldeffect==23
            score*=2 if checkAImoves([PBMoves::MAGNITUDE,PBMoves::EARTHQUAKE,PBMoves::BULLDOZE],aimem)
          end
          if $fefieldeffect==30
            score*=2 if (checkAImoves([PBMoves::MAGNITUDE,PBMoves::EARTHQUAKE,PBMoves::BULLDOZE],aimem) || checkAImoves([PBMoves::HYPERVOICE,PBMoves::BOOMBURST],aimem))
          end
        end
      else
        score*=0
      end
    when 0xAD # Feint
      if checkAImoves(PBStuff::PROTECTIGNORINGMOVE,aimem)
        score*=1.1
        ratesharers=[
          391,   # Protect
          121,   # Detect
          122,   # Quick Guard
          515,   # Wide Guard
          361,   # Endure
          584,   # King's Shield
          603,    # Spiky Shield
          641,   # Baneful Bunker
          786    # Obstruct
        ]
        if !ratesharers.include?(opponent.lastMoveUsed)
          score*=1.2
        end
      end
    when 0xAE # Mirror Move
      if opponent.lastMoveUsed>0
        mirrored = PBMove.new(opponent.lastMoveUsed)
        mirrmove = PokeBattle_Move.pbFromPBMove(self,mirrored,attacker)
        if mirrmove.flags&0x10==0
          score*=0
        else
          rough = pbRoughDamage(mirrmove,attacker,opponent,skill,mirrmove.basedamage)
          mirrorscore = pbGetMoveScore(mirrmove,attacker,opponent,skill,rough,initialscores,scoreindex)
          score = mirrorscore
          if (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
            score*=0.5
          else
            if rough>opponent.hp && opponent.effects[PBEffects::Attacking]==true
              score*=1.5
            end
          end
        end
      else
        score*=0
      end
    when 0xAF # Copycat
      if opponent.lastMoveUsed>0
        copied = PBMove.new(opponent.lastMoveUsed)
        copymove = PokeBattle_Move.pbFromPBMove(self,copied,attacker)
        if copymove.flags&0x10==0
          score*=0
        else
          rough = pbRoughDamage(copymove,attacker,opponent,skill,copymove.basedamage)
          copyscore = pbGetMoveScore(copymove,attacker,opponent,skill,rough,initialscores,scoreindex)
          score = copyscore
          if (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
            score*=0.5
          end
          if $fefieldeffect==30
            score*=1.5
          end
        end
      else
        score*=0
      end
    when 0xB0 # Me First
      if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        if checkAImoves(PBStuff::SETUPMOVE,aimem)
          score*=0.8
        else
          score*=1.5
        end
        if checkAIpriority(aimem) || (!opponent.abilitynulled && opponent.ability == PBAbilities::PRANKSTER) || ((!opponent.abilitynulled && opponent.ability == PBAbilities::GALEWINGS) && opponent.hp==opponent.totalhp)
          score*=0.6
        else
          score*=1.5
        end
        if opponent.hp>0 && initialscores.length>0
          if checkAIdamage(aimem,attacker,opponent,skill)/(1.0*opponent.hp)>initialscores.max
            score*=2
          else
            score*=0.5
          end
        end
      else
        score*=0
      end
    when 0xB1 # Magic Coat
      if attacker.lastMoveUsed>0
        olddata = PBMove.new(attacker.lastMoveUsed)
        oldmove = PokeBattle_Move.pbFromPBMove(self,olddata,attacker)
        if oldmove.function==0xB1 && opponent.effects[PBEffects::Attacking]==true
          score*=0.2
        else
          if attacker.hp==attacker.totalhp
            score*=1.5
          end
          statvar = true
          for i in opponent.moves
            if i.basedamage>0
              statvar=false
            end
          end
          if statvar
            score*=3
          end
        end
      else
        if attacker.hp==attacker.totalhp
          score*=1.5
        end
        if opponent.effects[PBEffects::AttackingTarget].include?(attacker.index) && !(opponent.effects[PBEffects::Attacking]==true)
          score*=3
        end
        statvar = true
        for i in opponent.moves
          if i.basedamage>0
            statvar=false
          end
        end
        if statvar
          score*=3
        end
      end
    when 0xB2 # Snatch
      if attacker.lastMoveUsed>0
        olddata = PBMove.new(attacker.lastMoveUsed)
        oldmove = PokeBattle_Move.pbFromPBMove(self,olddata,attacker)
        if oldmove.function==0xB2
          score*=0.5
        else
          if opponent.hp==opponent.totalhp
            score*=1.5
          end
          score*=2 if checkAImoves(PBStuff::SETUPMOVE,aimem)
          if opponent.attack>opponent.spatk
            if attacker.attack>attacker.spatk
              score*=1.5
            else
              score*=0.7
            end
          else
            if attacker.spatk>attacker.attack
              score*=1.5
            else
              score*=0.7
            end
          end
        end
      else
        if opponent.hp==opponent.totalhp
          score*=1.5
        end
        score*=2 if checkAImoves(PBStuff::SETUPMOVE,aimem)
        if opponent.attack>opponent.spatk
          if attacker.attack>attacker.spatk
            score*=1.5
          else
            score*=0.7
          end
        else
          if attacker.spatk>attacker.attack
            score*=1.5
          else
            score*=0.7
          end
        end
      end
    when 0xB3 # Nature Power
      case $fefieldeffect
      when 1
        newmove=getConst(PBMoves,:THUNDERBOLT) || 0
      when 2
        newmove=getConst(PBMoves,:ENERGYBALL) || 0
      when 3
        newmove=getConst(PBMoves,:MISTBALL) || 0
      when 4
        newmove=getConst(PBMoves,:DARKPULSE) || 0
      when 5
        newmove=getConst(PBMoves,:ANCIENTPOWER) || 0
      when 6
        newmove=getConst(PBMoves,:ACROBATICS) || 0
      when 7
        newmove=getConst(PBMoves,:FLAMETHROWER) || 0
      when 8
        newmove=getConst(PBMoves,:MUDDYWATER) || 0
      when 9
        newmove=getConst(PBMoves,:AURORABEAM) || 0
      when 10
        newmove=getConst(PBMoves,:ACID) || 0
      when 11
        newmove=getConst(PBMoves,:ACIDSPRAY) || 0
      when 12
        newmove=getConst(PBMoves,:SANDTOMB) || 0
      when 13
        newmove=getConst(PBMoves,:ICEBEAM) || 0
      when 14
        newmove=getConst(PBMoves,:ROCKSMASH) || 0
      when 15
        newmove=getConst(PBMoves,:WOODHAMMER) || 0
      when 16
        newmove=getConst(PBMoves,:ERUPTION) || 0
      when 17
        newmove=getConst(PBMoves,:GEARGRIND) || 0
      when 18
        newmove=getConst(PBMoves,:DISCHARGE) || 0
      when 19
        newmove=getConst(PBMoves,:GUNKSHOT) || 0
      when 20
        newmove=getConst(PBMoves,:MEDITATE) || 0
      when 21
        newmove=getConst(PBMoves,:WHIRLPOOL) || 0
      when 22
        newmove=getConst(PBMoves,:WATERPULSE) || 0
      when 23
        newmove=getConst(PBMoves,:ROCKTOMB) || 0
      when 24
        newmove=getConst(PBMoves,:METRONOME) || 0
      when 25
        newmove=getConst(PBMoves,:POWERGEM) || 0
      when 26
        newmove=getConst(PBMoves,:SLUDGEWAVE) || 0
      when 27
        newmove=getConst(PBMoves,:ROCKSLIDE) || 0
      when 28
        newmove=getConst(PBMoves,:AVALANCHE) || 0
      when 29
        newmove=getConst(PBMoves,:JUDGMENT) || 0
      when 30
        newmove=getConst(PBMoves,:MIRRORSHOT) || 0
      when 31
        newmove=getConst(PBMoves,:SECRETSWORD) || 0
      when 32
        newmove=getConst(PBMoves,:DRAGONPULSE) || 0
      when 33
        if $fecounter == 4
          newmove=getConst(PBMoves,:PETALBLIZZARD) || 0
        else
          newmove=getConst(PBMoves,:GROWTH) || 0
        end
      when 34
        newmove=getConst(PBMoves,:MOONBLAST) || 0
      when 35
        newmove=getConst(PBMoves,:SPACIALREND) || 0
      when 36
        newmove=getConst(PBMoves,:TRICKROOM) || 0
      when 37
        newmove=getConst(PBMoves,:PSYCHIC) || 0
      when 38
        newmove=getConst(PBMoves,:DARKPULSE) || 0
      when 39
        newmove=getConst(PBMoves,:ICEBEAM) || 0
      when 40
        newmove=getConst(PBMoves,:PHANTOMFORCE) || 0
      when 41
        newmove=getConst(PBMoves,:GUNKSHOT) || 0
      when 42
        newmove=getConst(PBMoves,:DAZZLINGGLEAM) || 0
      when 43
        newmove=getConst(PBMoves,:SKYATTACK) || 0
      else
        newmove=getConst(PBMoves,:TRIATTACK) || 0
      end
      newdata = PBMove.new(newmove)
      naturemove = PokeBattle_Move.pbFromPBMove(self,newdata,attacker)
      if naturemove.basedamage<=0
        naturedam=pbStatusDamage(naturemove)
      else
        tempdam=pbRoughDamage(naturemove,attacker,opponent,skill,naturemove.basedamage)
        naturedam=(tempdam*100)/(opponent.hp.to_f)
      end
      naturedam=110 if naturedam>110
      score = pbGetMoveScore(naturemove,attacker,opponent,skill,naturedam,initialscores,scoreindex,false,true)
    when 0xB4 # Sleep Talk
      if attacker.status==PBStatuses::SLEEP
        opponentdamage=checkAIdamage(aimem,attacker,opponent,skill,true,true)[0]
        opponentstrongmove=checkAIdamage(aimem,attacker,opponent,skill,true,true)[1]
        nextdamage=checkAIdamage(aimem,attacker,opponent,skill,true,true)[2]
        cheesed=false
        rnd=pbAIRandom(3)
        if opponentstrongmove!=0
          if opponentstrongmove.id == getID(PBMoves,:WAKEUPSLAP)
            if opponentdamage>nextdamage*2
              if rnd==2
                cheesed=true
              else
                cheesed=false
              end
            end
          end
        end
        if attacker.statusCount<=1
          score*=0
        else
          if attacker.pbHasMove?(getID(PBMoves,:SNORE))
            count=-1
            for k in attacker.moves
              count+=1
              if k.id == 312 # Snore index
                break
              end
            end
            if initialscores
              snorescore = initialscores[count]
              otherscores = 0
              for s in initialscores
                next if s.index==scoreindex
                next if s.index==count
                otherscores+=s
              end
              otherscores/=2.0
              if otherscores>snorescore
                score*=0.1
              else
                if (cheesed==false)
                  score*=10
                end
              end
            end
          end
          if attacker.statusCount>1
            if (cheesed==false)
              score*=10
            end
          end
        end
      else
        score*=0
      end
    when 0xB5 # Assist
      if attacker.pbNonActivePokemonCount > 0
        if initialscores.length>0
          scorecheck = false
          for s in initialscores
            next if initialscores.index(s) == scoreindex
            scorecheck=true if s>25
          end
          if scorecheck
            score*=0.5
          else
            score*=1.5
          end
        end
      else
        score*=0
      end
    when 0xB6 # Metronome
      if $fefieldeffect==24
        if initialscores.length>0
          scorecheck = false
          for s in initialscores
            next if initialscores.index(s) == scoreindex
            scorecheck=true if s>40
          end
          if scorecheck
            score*=0.8
          else
            score*=2
          end
        end
      else
        if initialscores.length>0
          scorecheck = false
          for s in initialscores
            next if initialscores.index(s) == scoreindex
            scorecheck=true if s>21
          end
          if scorecheck
            score*=0.5
          else
            score*=1.2
          end
        end
      end
    when 0xB7 # Torment
      olddata = PBMove.new(opponent.lastMoveUsed)
      oldmove = PokeBattle_Move.pbFromPBMove(self,olddata,opponent)
      moveid = -1
      maxdam = checkAIdamage(aimem,attacker,opponent,skill) 
      if opponent.effects[PBEffects::Torment] || (pbCheckSideAbility(:AROMAVEIL,opponent)!=nil && !(opponent.moldbroken))
        if move.basedamage==0
          score=0
        end
      else
        if ((attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::PRANKSTER) && !opponent.pbHasType?(:DARK))
          score*=1.5
        else
          score*=0.7
        end
        if oldmove.basedamage>0
          score*=1.5
          if moveid == oldmove.id
            score*=1.3
            if maxdam*3<attacker.totalhp
              score*=1.5
            end
          end
          if attacker.pbHasMove?((PBMoves::PROTECT))
            score*=2
          end
          if (attitemworks && attacker.item == PBItems::LEFTOVERS)
            score*=1.3
          end
        else
          if (PBStuff::SETUPMOVE).include?(oldmove.id) || (PBStuff::HEALFUNCTIONS).include?(oldmove.function)
            score*=1.3
          else
            score*=0.5
          end
        end
      end
    when 0xB8 # Imprison
      if attacker.effects[PBEffects::Imprison]
        score*=0
      else
        miniscore=1
        ourmoves = []
        olddata = PBMove.new(opponent.lastMoveUsed)
        oldmove = PokeBattle_Move.pbFromPBMove(self,olddata,attacker)
        for m in attacker.moves
          ourmoves.push(m.id) unless m.id<1
        end
        if ourmoves.include?(oldmove.id)
          score*=1.3
        end
        for j in opponent.moves
          if ourmoves.include?(j.id)
            miniscore+=1
            if j.isHealingMove?
              score*=1.5
            end
          else
            score*=0.5
          end
        end
        score*=miniscore
      end
    when 0xB9 # Disable
      olddata = PBMove.new(opponent.lastMoveUsed)
      oldmove = PokeBattle_Move.pbFromPBMove(self,olddata,opponent)
      maxdam = 0
      moveid = -1
      lowdammoves = 0
      for j in opponent.moves
        tempdam = pbRoughDamage(j,opponent,attacker,skill,j.basedamage)
        if tempdam<(attacker.hp/2)
          lowdammoves+=1
        end
        if tempdam>maxdam
          maxdam=tempdam
          moveid = j.id
        end
      end
      if oldmove.id == -1 && (((attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::PRANKSTER) && !opponent.pbHasType?(:DARK)))
        score=0
      end
      if opponent.effects[PBEffects::Disable]>0 || (pbCheckSideAbility(:AROMAVEIL,opponent)!=nil && !(opponent.moldbroken))
        score=0
      else
        if ((attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::PRANKSTER) && !opponent.pbHasType?(:DARK))
          score*=1.5
        else
          score*=0.3
        end
        if oldmove.basedamage>0 || oldmove.isHealingMove? || (PBStuff::SLEEPMOVE).include?(oldmove.id)
          score*=1.5
          if moveid == oldmove.id || (lowdammoves>=2)
            score*=1.5
            if (maxdam*3<attacker.totalhp) 
              score*=1.5
            end
          end
        else
          score*=0.5
        end
      end
    when 0xBA # Taunt
      olddata = PBMove.new(opponent.lastMoveUsed)
      oldmove = PokeBattle_Move.pbFromPBMove(self,olddata,opponent)
      icansurvive=false
      fastermon=(attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0) || (attacker.hasWorkingAbility(:PRANKSTER)) 
      if (attacker.item == PBItems::RAMPCREST && attacker.species==PBSpecies::RAMPARDOS && !attacker.effects[PBEffects::RampCrestUsage]) || 
      ((attacker.item == PBItems::FOCUSSASH || attacker.ability == PBAbilities::STURDY)) 
         if attacker.hp==attacker.totalhp 
            icansurvive=true
         end
      end
      maxdam=checkAIdamage(aimem,attacker,opponent,skill)
      maxdam2=checkAIdamage(aimem,opponent,attacker,skill)
      knowncount = 0
      alldam = true
      for j in opponent.moves
        knowncount+=1
        if j.basedamage<=0
          alldam = false
        end
      end
      if opponent.effects[PBEffects::Taunt]>0 || alldam
        score=0
      else
        count=-1
        party=pbParty(attacker.index)
        leadvar=false
        for i in 0...party.length
          count+=1
          next if party[i].nil?
          temproles = pbGetMonRole(party[i],opponent,skill,count,party)
          if temproles.include?(PBMonRoles::LEAD)
            leadvar=true
          end
        end
        if (opponent.moves.any? {|moveloop| (PBStuff::SETUPMOVE).include?(moveloop.id)} || opponent.moves.any? {|moveloop| (PBStuff::DEFSETUPMOVE).include?(moveloop.id)} || opponent.moves.any? {|moveloop| (PBStuff::SCREENMOVE).include?(moveloop.id)} ||
          opponent.moves.any? {|moveloop| (PBStuff::HAZARDMOVE).include?(moveloop.id)} || opponent.moves.any? {|moveloop| (PBStuff::SLEEPMOVE).include?(moveloop.id)} && attacker.pbCanSleep?(false) ||
          opponent.moves.any? {|moveloop| (PBStuff::BURNMOVE).include?(moveloop.id)} && attacker.pbCanBurn?(false))
          score*=1.5 
          if (fastermon && maxdam<attacker.hp)
            if opponent.moves.any? {|moveloop| (PBStuff::SETUPMOVE).include?(moveloop.id)} && !(opponent.pbHasMove?(getID(PBMoves,:DRAGONDANCE)) || opponent.pbHasMove?(getID(PBMoves,:QUIVERDANCE) || opponent.pbHasMove?(getID(PBMoves,:SHELLSMASH)) ||
              opponent.pbHasMove?(getID(PBMoves,:SHIFTGEAR)))) && !(opponent.moves.any? {|moveloop| (PBStuff::DEFSETUPMOVE).include?(moveloop.id)} || opponent.pbHasMove?(getID(PBMoves,:BULKUP)) || opponent.pbHasMove?(getID(PBMoves,:CALMMIND)))
              if (maxdam2*2)>opponent.hp
                score*=0.9
              end
            else
              score*=1.4 
            end
          end
        end
        if leadvar
          score*=1.3
          if (icansurvive)
            score*=1.5 
          else
            if maxdam<attacker.hp
              score*=1.1
            end
          end
        else
          score*=0.8
        end
        score*=1.1 if opponent.turncount<=1   
        if opponent.turncount>=1   
          score*=0.9   
          if (opponent.stages[PBStats::ATTACK]>0 || opponent.stages[PBStats::SPATK]>0)
            score*=0.5 
          end
        end
        score*=1.3 if oldmove.isHealingMove?
      end
    when 0xBB # Heal Block
      olddata = PBMove.new(opponent.lastMoveUsed)
      oldmove = PokeBattle_Move.pbFromPBMove(self,olddata,opponent)
      if opponent.effects[PBEffects::HealBlock]>0
        score=0
      else
        if ((attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::PRANKSTER) && !opponent.pbHasType?(:DARK))
          score*=1.5
        end
        if oldmove.isHealingMove?
          score*=2.5
        end
        if opponent.hasWorkingItem(:LEFTOVERS)
          score*=1.3
        end
      end
    when 0xBC # Encore
      olddata = PBMove.new(opponent.lastMoveUsed)
      oldmove = PokeBattle_Move.pbFromPBMove(self,olddata,opponent)
      if opponent.effects[PBEffects::Encore]>0
        score=0
      else
        if (opponent.lastMoveUsed<=0 || oldmove.pp==0)
          score*=0.2
        else
          if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
            score*=1.5
          else
            if ((!attacker.abilitynulled && attacker.ability == PBAbilities::PRANKSTER) && !opponent.pbHasType?(:DARK))
              score*=2
            else
              score*=0.2
            end
          end
          if oldmove.basedamage>0 && pbRoughDamage(oldmove,opponent,attacker,skill,oldmove.basedamage)*3>attacker.hp
            score*=0.3
          else
            if opponent.stages[PBStats::SPEED]>0
              if (opponent.pbHasType?(:DARK) || !(!attacker.abilitynulled && attacker.ability == PBAbilities::PRANKSTER) || (!opponent.abilitynulled && opponent.ability == PBAbilities::SPEEDBOOST))
                score*=0.5
              else
                score*=2
              end
            else
              score*=2
            end
          end
          score*=1.5 if (pbRoughDamage(oldmove,opponent,attacker,skill,oldmove.basedamage)*4<attacker.hp && !hasgreatmoves(initialscores,scoreindex,skill))
          if $fefieldeffect == 6
            score*=1.5
          end
        end
      end
    when 0xBD # Double Kick
      if opponent.hasWorkingItem(:ROCKYHELMET) || (!opponent.abilitynulled && opponent.ability == PBAbilities::IRONBARBS) || (!opponent.abilitynulled && opponent.ability == PBAbilities::ROUGHSKIN)
        score*=0.9
      end
      if opponent.hp==opponent.totalhp && (opponent.hasWorkingItem(:FOCUSSASH) || (!opponent.abilitynulled && opponent.ability == PBAbilities::STURDY) || (isConst?(opponent.species,PBSpecies,:RAMPARDOS) && isConst?(opponent.item,PBItems,:RAMPCREST)))
        score*=1.3
      end
      if opponent.effects[PBEffects::Substitute]>0
        score*=1.3
      end
      if attacker.hasWorkingItem(:RAZORFANG) || attacker.hasWorkingItem(:KINGSROCK)
        score*=1.1
      end
    when 0xBE # Twinneedle
      if opponent.pbCanPoison?(false)
        miniscore=100
        miniscore*=1.2
        ministat=0
        ministat+=opponent.stages[PBStats::DEFENSE]
        ministat+=opponent.stages[PBStats::SPDEF]
        ministat+=opponent.stages[PBStats::EVASION]
        if ministat>0
          minimini=5*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::NATURALCURE)
          miniscore*=0.3
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::MARVELSCALE) || SilvallyCheck(opponent, "water")
          miniscore*=0.7
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::TOXICBOOST) || (!opponent.abilitynulled && opponent.ability == PBAbilities::GUTS)
          miniscore*=0.2
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::POISONHEAL) || (!opponent.abilitynulled && opponent.ability == PBAbilities::MAGICGUARD) ||
          (isConst?(opponent.species,PBSpecies,:ZANGOOSE) && isConst?(opponent.item,PBItems,:ZANGCREST))
          miniscore*=0.1
        end
        if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
          miniscore*=1.5
        end
        if initialscores.length>0
          badmoves=true
          for i in 0...initialscores.length
            next if i==scoreindex
            if initialscores[i]>30
              badmoves=false
            end
          end
          miniscore*=1.2 if badmoves
        end
        miniscore*=0.1 if checkAImoves([PBMoves::REST],aimem)
        miniscore*=0.2 if checkAImoves([PBMoves::FACADE],aimem)
        if attacker.pbHasMove?(getID(PBMoves,:VENOSHOCK)) ||
          attacker.pbHasMove?(getID(PBMoves,:VENOMDRENCH)) ||
          (!attacker.abilitynulled && attacker.ability == PBAbilities::MERCILESS) ||
          (isConst?(attacker.species,PBSpecies,:ARIADOS) && attacker.hasWorkingItem(:ARIACREST))
          miniscore*=1.6
        end
        if opponent.effects[PBEffects::Yawn]>0
          miniscore*=0.4
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::SHEDSKIN)
          miniscore*=0.7
        end
        miniscore-=100
        miniscore*=(move.addlEffect.to_f/100)
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
          miniscore*=2
        end
        miniscore+=100
        miniscore/=100.0
        score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !((!opponent.abilitynulled && opponent.ability == PBAbilities::SHIELDDUST) && !opponent.moldbroken)
      end
      if opponent.hasWorkingItem(:ROCKYHELMET) || (!opponent.abilitynulled && opponent.ability == PBAbilities::IRONBARBS) || (!opponent.abilitynulled && opponent.ability == PBAbilities::ROUGHSKIN)
        score*=0.8
      end
      if opponent.hp==opponent.totalhp && (opponent.hasWorkingItem(:FOCUSSASH) || (!opponent.abilitynulled && opponent.ability == PBAbilities::STURDY) || (isConst?(opponent.species,PBSpecies,:RAMPARDOS) && isConst?(opponent.item,PBItems,:RAMPCREST)))
        score*=1.3
      end
      if opponent.effects[PBEffects::Substitute]>0
        score*=1.3
      end
      if attacker.hasWorkingItem(:RAZORFANG) || attacker.hasWorkingItem(:KINGSROCK)
        score*=1.1
      end
    when 0xBF # Triple Kick
      if opponent.hasWorkingItem(:ROCKYHELMET) || (!opponent.abilitynulled && opponent.ability == PBAbilities::IRONBARBS) || (!opponent.abilitynulled && opponent.ability == PBAbilities::ROUGHSKIN)
        score*=0.8
      end
      if opponent.hp==opponent.totalhp && (opponent.hasWorkingItem(:FOCUSSASH) || (!opponent.abilitynulled && opponent.ability == PBAbilities::STURDY) || (isConst?(opponent.species,PBSpecies,:RAMPARDOS) && isConst?(opponent.item,PBItems,:RAMPCREST)))
        score*=1.3
      end
      if opponent.effects[PBEffects::Substitute]>0
        score*=1.3
      end
      if attacker.hasWorkingItem(:RAZORFANG) || attacker.hasWorkingItem(:KINGSROCK)
        score*=1.2
      end
    when 0xC0 # Bullet Seed
      if opponent.hasWorkingItem(:ROCKYHELMET) || (!opponent.abilitynulled && opponent.ability == PBAbilities::IRONBARBS) || (!opponent.abilitynulled && opponent.ability == PBAbilities::ROUGHSKIN)
        score*=0.7 if move.isContactMove?
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::SKILLLINK)
          score*=0.5 if move.isContactMove?
        end
      end
      if opponent.hp==opponent.totalhp && (opponent.hasWorkingItem(:FOCUSSASH) || (!opponent.abilitynulled && opponent.ability == PBAbilities::STURDY) || (isConst?(opponent.species,PBSpecies,:RAMPARDOS) && isConst?(opponent.item,PBItems,:RAMPCREST)))
        score*=1.3
      end
      if opponent.effects[PBEffects::Substitute]>0
        score*=1.3
      end
      if attacker.hasWorkingItem(:RAZORFANG) || attacker.hasWorkingItem(:KINGSROCK)
        score*=1.3
      end
    when 0xC1 # Beat Up
      count = -1
      for mon in pbParty(attacker.index)
        next if mon.nil?
        count+=1 if mon.hp>0
      end
      if count>0
        if opponent.hasWorkingItem(:ROCKYHELMET) || (!opponent.abilitynulled && opponent.ability == PBAbilities::IRONBARBS) || (!opponent.abilitynulled && opponent.ability == PBAbilities::ROUGHSKIN)
          score*=0.7
        end
        if opponent.hp==opponent.totalhp && (opponent.hasWorkingItem(:FOCUSSASH) || (!opponent.abilitynulled && opponent.ability == PBAbilities::STURDY) || (isConst?(opponent.species,PBSpecies,:RAMPARDOS) && isConst?(opponent.item,PBItems,:RAMPCREST)))
          score*=1.3
        end
        if opponent.effects[PBEffects::Substitute]>0
          score*=1.3
        end
        if attacker.hasWorkingItem(:RAZORFANG) || attacker.hasWorkingItem(:KINGSROCK)
          score*=1.3
        end
        if opponent == attacker.pbPartner && (!opponent.abilitynulled && opponent.ability == PBAbilities::JUSTIFIED)
          if opponent.stages[PBStats::ATTACK]<1 && opponent.attack>opponent.spatk
            score*=5
          end
        end
      end
    when 0xC2 # Hyper Beam
      if $fefieldeffect == 24 || (isConst?(attacker.species,PBSpecies,:CLAYDOL) && attacker.hasWorkingItem(:CLAYCREST)) || ($fefieldeffect == 34 && isConst?(move.id,PBMoves,:METEORASSAULT))
        if score >=110
          score=110
        end
      else
        thisinitial = score
        if thisinitial<100
          score*=0.5
          score*=0.5 if checkAIhealing(aimem)
        end
        if initialscores.length>0
          score*=0.3 if hasgreatmoves(initialscores,scoreindex,skill)
        end
        miniscore=100
        livecount=0
        for i in pbParty(opponent.index)
          next if i.nil?
          livecount+=1 if i.hp!=0
        end
        if livecount>1
          miniscore*=(livecount-1)
          miniscore/=100.0
          miniscore*=0.1
          miniscore=(1-miniscore)
          score*=miniscore
        else
          score*=1.1
        end
        if @doublebattle
          score*=0.5
        end
        livecount2=0
        for i in pbParty(attacker.index)
          next if i.nil?
          livecount2+=1 if i.hp!=0
        end
        if livecount>1 && livecount2==1
          score*=0.7
        end
      end
    when 0xC3 # Razor Wind
      if !(attitemworks && attacker.item == PBItems::POWERHERB) && !($fefieldeffect == 43)
        if checkAIdamage(aimem,attacker,opponent,skill)>attacker.hp
          score*=0.4
        else
          if attacker.hp*(1.0/attacker.totalhp)<0.5
            score*=0.6
          end
        end
        if opponent.effects[PBEffects::TwoTurnAttack]!=0
          if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
            score*=2
          else
            score*=0.5
          end
        end
        greatmove = false
        thisko = false
        if initialscores.length>0
          if initialscores[scoreindex] >= 100
            thisko = true
          end
          for i in initialscores
            if i>=100
              greatmove=true
            end
          end
        end
        if greatmove
          score*=0.1
        end
        if @doublebattle
          score*=0.5
        end
        score*=0.1 if checkAImoves(PBStuff::PROTECTMOVE,aimem)
        if !thisko
          score*=0.7
        end
      else
        score*=1.1
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::UNBURDEN)
          score*=1.5
        end
      end
      fairyvar = false
      firevar = false
      poisonvar = false
      for p in pbParty(attacker.index)
        next if p.nil?
        fairyvar = true if p.hasType?(:FAIRY)
        firevar = true if p.hasType?(:FIRE)
        poisonvar = true if p.hasType?(:POISON)
      end
      if $fefieldeffect==3
        score*=1.3
        if !fairyvar
          score*=1.3
        else
          score*=0.6
        end
      elsif $fefieldeffect==7
        if !firevar
          score*=1.8
        else
          score*=0.5
        end
      elsif $fefieldeffect==11
        if !poisonvar
          score*=3
        else
          score*=0.8
        end
      end
    when 0xC4 # Solar Beam
      if !(attitemworks && attacker.item == PBItems::POWERHERB) && pbWeather!=PBWeather::SUNNYDAY
        if checkAIdamage(aimem,attacker,opponent,skill)>attacker.hp
          score*=0.4
        else
          if attacker.hp*(1.0/attacker.totalhp)<0.5
            score*=0.6
          end
        end
        if opponent.effects[PBEffects::TwoTurnAttack]!=0
          if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
            score*=2
          else
            score*=0.5
          end
        end
        greatmove = false
        thisko = false
        if initialscores.length>0
          if initialscores[scoreindex] >= 100
            thisko = true
          end
          for i in initialscores
            if i>=100
              greatmove=true
            end
          end
        end
        if greatmove
          score*=0.1
        end
        if @doublebattle
          score*=0.5
        end
        score*=0.1 if checkAImoves(PBStuff::PROTECTMOVE,aimem)
        if !thisko
          score*=0.7
        end
      else
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::UNBURDEN) && pbWeather!=PBWeather::SUNNYDAY
          score*=1.5
        end
      end
      if $fefieldeffect==4
        score*=0
      end
    when 0xC5 # Freeze Shock
      if !(attitemworks && attacker.item == PBItems::POWERHERB)
        if checkAIdamage(aimem,attacker,opponent,skill)>attacker.hp
          score*=0.4
        else
          if attacker.hp*(1.0/attacker.totalhp)<0.5
            score*=0.6
          end
        end
        if opponent.effects[PBEffects::TwoTurnAttack]!=0
          if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
            score*=2
          else
            score*=0.5
          end
        end
        greatmove = false
        thisko = false
        if initialscores.length>0
          if initialscores[scoreindex] >= 100
            thisko = true
          end
          for i in initialscores
            if i>=100
              greatmove=true
            end
          end
        end
        if greatmove
          score*=0.1
        end
        if @doublebattle
          score*=0.5
        end
        score*=0.1 if checkAImoves(PBStuff::PROTECTMOVE,aimem)
        if !thisko
          score*=0.7
        end
      else
        score*=1.2
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::UNBURDEN)
          score*=1.5
        end
      end
      if opponent.pbCanParalyze?(false)
        miniscore=100
        miniscore*=1.1
        miniscore*=1.3 if attacker.moves.any? {|moveloop| (PBStuff::SETUPMOVE).include?(moveloop.id)}
        if opponent.hp==opponent.totalhp
          miniscore*=1.2
        end
        ministat=0
        ministat+=opponent.stages[PBStats::ATTACK]
        ministat+=opponent.stages[PBStats::SPATK]
        ministat+=opponent.stages[PBStats::SPEED]
        if ministat>0
          minimini=5*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::NATURALCURE)
          miniscore*=0.3
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::MARVELSCALE)
          miniscore*=0.5
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::QUICKFEET) || (!opponent.abilitynulled && opponent.ability == PBAbilities::GUTS)
          miniscore*=0.2
        end
        if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL) || roles.include?(PBMonRoles::PIVOT)
          miniscore*=1.2
        end
        if roles.include?(PBMonRoles::TANK)
          miniscore*=1.5
        end
        if pbRoughStat(opponent,PBStats::SPEED,skill)>attacker.pbSpeed && (pbRoughStat(opponent,PBStats::SPEED,skill)/2.0)<attacker.pbSpeed && @trickroom==0
          miniscore*=1.5
        end
        if pbRoughStat(opponent,PBStats::SPATK,skill)>pbRoughStat(opponent,PBStats::ATTACK,skill)
          miniscore*=1.3
        end
        count = -1
        sweepvar = false
        for i in pbParty(attacker.index)
          count+=1
          next if i.nil?
          temprole = pbGetMonRole(i,opponent,skill,count,pbParty(attacker.index))
          if temprole.include?(PBMonRoles::SWEEPER)
            sweepvar = true
          end
        end
        miniscore*=1.3 if sweepvar
        if opponent.effects[PBEffects::Confusion]>0
          miniscore*=1.1
        end
        if opponent.effects[PBEffects::Attract]>=0
          miniscore*=1.1
        end
        if opponent.effects[PBEffects::Yawn]>0
          miniscore*=0.4
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::SHEDSKIN)
          miniscore*=0.7
        end
        miniscore-=100
        if move.addlEffect.to_f != 100
          miniscore*=(move.addlEffect.to_f/100)
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
            miniscore*=2
          end
        end
        miniscore+=100
        miniscore/=100.0
        score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !((!opponent.abilitynulled && opponent.ability == PBAbilities::SHIELDDUST) && !opponent.moldbroken) && !hasgreatmoves(initialscores,scoreindex,skill,true)
      end
    when 0xC6 # Ice Burn
      if !(attitemworks && attacker.item == PBItems::POWERHERB)
        if checkAIdamage(aimem,attacker,opponent,skill)>attacker.hp
          score*=0.4
        else
          if attacker.hp*(1.0/attacker.totalhp)<0.5
            score*=0.6
          end
        end
        if opponent.effects[PBEffects::TwoTurnAttack]!=0
          if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
            score*=2
          else
            score*=0.5
          end
        end
        greatmove = false
        thisko = false
        if initialscores.length>0
          if initialscores[scoreindex] >= 100
            thisko = true
          end
          for i in initialscores
            if i>=100
              greatmove=true
            end
          end
        end
        if greatmove
          score*=0.1
        end
        if @doublebattle
          score*=0.5
        end
        score*=0.1 if checkAImoves(PBStuff::PROTECTMOVE,aimem)
        if !thisko
          score*=0.7
        end
      else
        score*=1.2
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::UNBURDEN)
          score*=1.5
        end
      end
      if opponent.pbCanBurn?(false)
        miniscore=100
        miniscore*=1.2
        ministat=0
        ministat+=opponent.stages[PBStats::ATTACK]
        ministat+=opponent.stages[PBStats::SPATK]
        ministat+=opponent.stages[PBStats::SPEED]
        if ministat>0
          minimini=5*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::NATURALCURE)
          miniscore*=0.3
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::MARVELSCALE) || SilvallyCheck(opponent, "water")
          miniscore*=0.7
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::QUICKFEET) || (!opponent.abilitynulled && opponent.ability == PBAbilities::FLAREBOOST) || (!opponent.abilitynulled && opponent.ability == PBAbilities::MAGICGUARD)
          miniscore*=0.3
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::GUTS)
          miniscore*=0.1
        end
        miniscore*=0.3 if checkAImoves([PBMoves::FACADE],aimem)
        miniscore*=0.1 if checkAImoves([PBMoves::REST],aimem)
        if pbRoughStat(opponent,PBStats::ATTACK,skill)>pbRoughStat(opponent,PBStats::SPATK,skill)
          miniscore*=1.7
        end
        if opponent.effects[PBEffects::Yawn]>0
          miniscore*=0.4
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::SHEDSKIN)
          miniscore*=0.7
        end
        miniscore-=100
        if move.addlEffect.to_f != 100
          miniscore*=(move.addlEffect.to_f/100)
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
            miniscore*=2
          end
        end
        miniscore+=100
        miniscore/=100.0
        score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !((!opponent.abilitynulled && opponent.ability == PBAbilities::SHIELDDUST) && !opponent.moldbroken) && !hasgreatmoves(initialscores,scoreindex,skill,true)
      end
    when 0xC7 # Sky Attack
      maxdam = 0
      movecheck = false
      if skill>=PBTrainerAI.highSkill && $fefieldeffect!=43
        if aimem.length>0
          for j in aimem
            tempdam = pbRoughDamage(j,opponent,attacker,skill,j.basedamage)
            if tempdam>maxdam
              maxdam=tempdam
            end
            movecheck=true if j.id==getID(PBMoves,:PROTECT) || j.id==getID(PBMoves,:DETECT) || j.id==getID(PBMoves,:BANEFULBUNKER) || j.id==getID(PBMoves,:SPIKYSHIELD)
          end
        end
      end
      if (!attacker.hasWorkingItem(:POWERHERB) && $fefieldeffect!=43)
        if maxdam>attacker.hp
          score*=0.4
        else
          if attacker.hp*(1.0/attacker.totalhp)<0.5
            score*=0.6
          end
        end
        if opponent.effects[PBEffects::TwoTurnAttack]!=0
          if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
            score*=2
          else
            score*=0.5
          end
        end
        greatmove = false
        thisko = false
        if initialscores.length>0
          if initialscores[scoreindex] >= 100
            thisko = true
          end
          for i in initialscores
            if i>=100
              greatmove=true
            end
          end
        end
        if greatmove
          score*=0.1
        end
        if @doublebattle
          score*=0.5
        end
        if movecheck
          score*=0.1
        end
        if !thisko
          score*=0.7
        end
      else
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::UNBURDEN) && attacker.hasWorkingItem(:POWERHERB)
          score*=1.5
        end
      end
      if opponent.effects[PBEffects::Substitute]==0 && !(!opponent.abilitynulled && opponent.ability == PBAbilities::INNERFOCUS)
        if (pbRoughStat(opponent,PBStats::SPEED,skill)<attacker.pbSpeed) ^ (@trickroom!=0)
          miniscore=100
          miniscore*=1.3
          if skill>=PBTrainerAI.highSkill
            if $fefieldeffect==14 # Rocky
              miniscore*=1.2
            end
          end
          if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEADFAST)
            miniscore*=0.3
          end
          miniscore-=100
          miniscore*=(move.addlEffect.to_f/100)
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
            miniscore*=2
          end
          miniscore+=100
          miniscore/=100.0
          score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !((!opponent.abilitynulled && opponent.ability == PBAbilities::SHIELDDUST) && !opponent.moldbroken) && !hasgreatmoves(initialscores,scoreindex,skill,true)
        end
      end
    when 0xC8 # Skull Bash
      if !(attitemworks && attacker.item == PBItems::POWERHERB)
        if checkAIdamage(aimem,attacker,opponent,skill)>attacker.hp
          score*=0.4
        else
          if attacker.hp*(1.0/attacker.totalhp)<0.5
            score*=0.6
          end
        end
        if opponent.effects[PBEffects::TwoTurnAttack]!=0
          if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
            score*=2
          else
            score*=0.5
          end
        end
        greatmove = false
        thisko = false
        if initialscores.length>0
          if initialscores[scoreindex] >= 100
            thisko = true
          end
          for i in initialscores
            if i>=100
              greatmove=true
            end
          end
        end
        if greatmove
          score*=0.1
        end
        if @doublebattle
          score*=0.5
        end
        score*=0.1 if checkAImoves(PBStuff::PROTECTMOVE,aimem)
        if !thisko
          score*=0.7
        end
      else
        score*=1.2
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::UNBURDEN)
          score*=1.5
        end
      end
      miniscore=100
      if attacker.effects[PBEffects::Substitute]>0 || attacker.effects[PBEffects::Disguise] || (attacker.effects[PBEffects::IceFace] && !specmove) || (attacker.effects[PBEffects::IceFace] && $fefieldeffect==39)
        miniscore*=1.5
      end
      if (attacker.hp.to_f)/attacker.totalhp>0.75
        miniscore*=1.1
      end
      if opponent.effects[PBEffects::HyperBeam]>0
        miniscore*=1.2
      end
      if opponent.effects[PBEffects::Yawn]>0
        miniscore*=1.3
      end
      if skill>=PBTrainerAI.mediumSkill
        maxdam = checkAIdamage(aimem,attacker,opponent,skill)
        if maxdam<(attacker.hp/3.0) 
          miniscore*=1.1
        end
      end
      if attacker.turncount<2
        miniscore*=1.1
      end
      if opponent.status!=0
        miniscore*=1.1
      end
      if opponent.status==PBStatuses::SLEEP || opponent.status==PBStatuses::FROZEN
        miniscore*=1.3
      end
      if opponent.effects[PBEffects::Encore]>0
        if opponent.moves[(opponent.effects[PBEffects::EncoreIndex])].basedamage==0
          miniscore*=1.3
        end
      end
      if attacker.effects[PBEffects::Confusion]>0
        miniscore*=0.3
      end
      if attacker.effects[PBEffects::LeechSeed]>=0 || attacker.effects[PBEffects::Attract]>=0
        miniscore*=0.3
      end
      if attacker.effects[PBEffects::Toxic]>0
        miniscore*=0.2
      end
      miniscore*=0.2 if checkAImoves(PBStuff::SWITCHOUTMOVE,aimem)
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::SIMPLE)
        miniscore*=2
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent,PBTypes::FAIRY)
        miniscore*=0.5
      end
      if @doublebattle
        miniscore*=0.3
      end
      if attacker.stages[PBStats::DEFENSE]>0
        ministat=attacker.stages[PBStats::DEFENSE]
        minimini=-15*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      if pbRoughStat(opponent,PBStats::ATTACK,skill)>pbRoughStat(opponent,PBStats::SPATK,skill)
        miniscore*=1.3
      end
      if skill>=PBTrainerAI.mediumSkill
        maxdam = checkAIdamage(aimem,attacker,opponent,skill)
        if (maxdam.to_f/attacker.hp)<0.12 
          miniscore*=0.3
        end
      end
      if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
        miniscore*=1.3
      end
      if (attitemworks && attacker.item == PBItems::LEFTOVERS) || ((attitemworks && attacker.item == PBItems::BLACKSLUDGE) && attacker.pbHasType?(:POISON))
        miniscore*=1.2
      end
      healmove=false
      for j in attacker.moves
        if j.isHealingMove?
          healmove=true
        end
      end
      if healmove
        miniscore*=1.3
      end
      if attacker.pbHasMove?((PBMoves::LEECHSEED))
        miniscore*=1.3
      end
      if attacker.pbHasMove?((PBMoves::PAINSPLIT))
        miniscore*=1.2
      end
      miniscore-=100
      if move.addlEffect.to_f != 100
        miniscore*=(move.addlEffect.to_f/100)
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
          miniscore*=2
        end
      end
      miniscore+=100
      miniscore/=100.0
      if attacker.pbTooHigh?(PBStats::DEFENSE)
        miniscore=1
      end
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        miniscore*=0.5
      end
      score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !hasgreatmoves(initialscores,scoreindex,skill,true)
    when 0xC9 # Fly
      livecount1=0
      for i in pbParty(opponent.index)
        next if i.nil?
        livecount1+=1 if i.hp!=0
      end
      livecount2=0
      for i in pbParty(attacker.index)
        next if i.nil?
        livecount2+=1 if i.hp!=0
      end
      if skill<PBTrainerAI.highSkill || $fefieldeffect!=23 # Not in a cave
        if opponent.status==PBStatuses::POISON || opponent.status==PBStatuses::BURN || opponent.effects[PBEffects::LeechSeed]>=0 || opponent.effects[PBEffects::MultiTurn]>0 || opponent.effects[PBEffects::Curse]
          score*=1.2
        else
          if livecount1>1
            score*=0.8
          end
        end
        if attacker.status!=0 || attacker.effects[PBEffects::Curse] || attacker.effects[PBEffects::Attract]>-1 || attacker.effects[PBEffects::Confusion]>0
          score*=0.5
        end
        if (attitemworks && attacker.item == PBItems::LEFTOVERS) || ((attitemworks && attacker.item == PBItems::BLACKSLUDGE) && attacker.pbHasType?(:POISON))
          score*=1.1
        end
        if attacker.pbOwnSide.effects[PBEffects::Tailwind]>0 || attacker.pbOwnSide.effects[PBEffects::Reflect]>0 || attacker.pbOwnSide.effects[PBEffects::LightScreen]>0
          score*=0.7
        end
        if opponent.effects[PBEffects::PerishSong]!=0 && attacker.effects[PBEffects::PerishSong]==0
          score*=1.3
        end
        if (attitemworks && attacker.item == PBItems::POWERHERB)
          score*=1.5
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::NOGUARD) || (!opponent.abilitynulled && opponent.ability == PBAbilities::NOGUARD)
          score*=0.1
        end
        if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
          if opponent.vanished
            score*=3
          end
          score*=1.1
        else
          score*=0.8
          score*=0.5 if checkAIhealing(aimem)
          score*=0.7 if checkAIaccuracy(aimem)
        end
        score*=0.3 if checkAImoves([PBMoves::THUNDER,PBMoves::HURRICANE],aimem)
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect==22
            if !attacker.pbHasType?(PBTypes::WATER)
              score*=2
            end
          end
          if $fefieldeffect==43 # Sky Field
            if !opponent.pbHasType?(PBTypes::ROCK)
              score*=2
            end
          end
        end
      end
      if @field.effects[PBEffects::Gravity]>0
        score*=0
      end
      if $fefieldeffect==38
        score*=0
      end
    when 0xCA # Dig
      livecount1=0
      for i in pbParty(opponent.index)
        next if i.nil?
        livecount1+=1 if i.hp!=0
      end
      livecount2=0
      for i in pbParty(attacker.index)
        next if i.nil?
        livecount2+=1 if i.hp!=0
      end
      if !$fefieldeffect==12
        if opponent.status==PBStatuses::POISON || opponent.status==PBStatuses::BURN || opponent.effects[PBEffects::LeechSeed]>=0 || opponent.effects[PBEffects::MultiTurn]>0 || opponent.effects[PBEffects::Curse]
          score*=1.2
        else
          if livecount1>1
            score*=0.8
          end
        end
        if attacker.status!=0 || attacker.effects[PBEffects::Curse] || attacker.effects[PBEffects::Attract]>-1 || attacker.effects[PBEffects::Confusion]>0
          score*=0.5
        end
        if (attitemworks && attacker.item == PBItems::LEFTOVERS) || ((attitemworks && attacker.item == PBItems::BLACKSLUDGE) && attacker.pbHasType?(:POISON))
          score*=1.1
        end
        if attacker.pbOwnSide.effects[PBEffects::Tailwind]>0 || attacker.pbOwnSide.effects[PBEffects::Reflect]>0 || attacker.pbOwnSide.effects[PBEffects::LightScreen]>0
          score*=0.7
        end
        if opponent.effects[PBEffects::PerishSong]!=0 && attacker.effects[PBEffects::PerishSong]==0
          score*=1.3
        end
        if (attitemworks && attacker.item == PBItems::POWERHERB)
          score*=1.5
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::NOGUARD) || (!opponent.abilitynulled && opponent.ability == PBAbilities::NOGUARD)
          score*=0.1
        end
        if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
          if opponent.vanished
            score*=3
          end
          score*=1.1
        else
          score*=0.8
          score*=0.5 if checkAIhealing(aimem)
          score*=0.7 if checkAIaccuracy(aimem)
        end
        score*=0.3 if checkAImoves([PBMoves::EARTHQUAKE],aimem)
      end
      if $fefieldeffect==38 || $fefieldeffect==43
        score*=0
      end
    when 0xCB # Dive
      livecount1=0
      for i in pbParty(opponent.index)
        next if i.nil?
        livecount1+=1 if i.hp!=0
      end
      livecount2=0
      for i in pbParty(attacker.index)
        next if i.nil?
        livecount2+=1 if i.hp!=0
      end
      poisonvar=false
      watervar=false
      swiftvar=false
      if attacker.ability == PBAbilities::SWIFTSWIM
        swiftvar=true
      end
      for mon in pbParty(attacker.index)
        watervar=false
        next if mon.nil?
        if mon.hasType?(:WATER)
          watervar=true
        end
        if mon.hasType?(:POISON)
          poisonvar=true
        end
      end
      if skill>=PBTrainerAI.highSkill && ($fefieldeffect==21 || $fefieldeffect==22)  # Water Surface/Underwater
        if $fefieldeffect==21 # Water Surface
          if !opponent.pbHasType?(PBTypes::WATER)
            score*=1.5
          else
            for mon in pbParty(attacker.index)
              watervar=false
              next if mon.nil?
              if mon.hasType?(:WATER)
                watervar=true
              end
              if watervar
                score*=1.5
              end
            end
          end
        else
          if !attacker.pbHasType?(PBTypes::WATER)
            score*=2
          else
            for mon in pbParty(attacker.index)
              watervar=false
              next if mon.nil?
              if mon.hasType?(:WATER)
                watervar=true
              end
              if watervar
                score*=0.6
              end
            end
          end
        end
      else
        if $fefieldeffect==26 # Murkwater Surface
          if !attacker.pbHasType?(PBTypes::POISON) && !attacker.pbHasType?(PBTypes::STEEL)
            score*=0.3
          end
        end
        if $fefieldeffect==13 # Ice Field
          if $febackup==21 && watervar
            score*=1.5
          elsif $febackup==26 && poisonvar
            score*=1.5
          end
        end
        if opponent.status==PBStatuses::POISON || opponent.status==PBStatuses::BURN || opponent.effects[PBEffects::LeechSeed]>=0 || opponent.effects[PBEffects::MultiTurn]>0 || opponent.effects[PBEffects::Curse]
          score*=1.2
        else
          if livecount1>1
            score*=0.8
          end
        end
        if attacker.status!=0 || attacker.effects[PBEffects::Curse] || attacker.effects[PBEffects::Attract]>-1 || attacker.effects[PBEffects::Confusion]>0
          score*=0.5
        end
        if (attitemworks && attacker.item == PBItems::LEFTOVERS) || ((attitemworks && attacker.item == PBItems::BLACKSLUDGE) && attacker.pbHasType?(:POISON))
          score*=1.1
        end
        if attacker.pbOwnSide.effects[PBEffects::Tailwind]>0 || attacker.pbOwnSide.effects[PBEffects::Reflect]>0 || attacker.pbOwnSide.effects[PBEffects::LightScreen]>0
          score*=0.7
        end
        if opponent.effects[PBEffects::PerishSong]!=0 && attacker.effects[PBEffects::PerishSong]==0
          score*=1.3
        end
        if (attitemworks && attacker.item == PBItems::POWERHERB)
          score*=1.5
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::NOGUARD) || (!opponent.abilitynulled && opponent.ability == PBAbilities::NOGUARD)
          score*=0.1
        end
        if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
          if opponent.vanished
            score*=3
          end
          score*=1.1
        else
          score*=0.8
          score*=0.5 if checkAIhealing(aimem)
          score*=0.7 if checkAIaccuracy(aimem)
        end
        score*=0.3 if checkAImoves([PBMoves::SURF],aimem)
      end
      if $fefieldeffect==38
        score*=0
      end
    when 0xCC # Bounce
      if opponent.pbCanParalyze?(false)
        miniscore=100
        miniscore*=1.1 if attacker.moves.any? {|moveloop| (PBStuff::SETUPMOVE).include?(moveloop.id)}
        if opponent.hp==opponent.totalhp
          miniscore*=1.2
        end
        ministat=0
        ministat+=opponent.stages[PBStats::ATTACK]
        ministat+=opponent.stages[PBStats::SPATK]
        ministat+=opponent.stages[PBStats::SPEED]
        if ministat>0
          minimini=5*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::NATURALCURE)
          miniscore*=0.3
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::MARVELSCALE) || SilvallyCheck(opponent,"water")
          miniscore*=0.5
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::QUICKFEET) || (!opponent.abilitynulled && opponent.ability == PBAbilities::GUTS)
          miniscore*=0.2
        end
        if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL) || roles.include?(PBMonRoles::PIVOT)
          miniscore*=1.2
        end
        if roles.include?(PBMonRoles::TANK)
          miniscore*=1.3
        end
        if pbRoughStat(opponent,PBStats::SPEED,skill)>attacker.pbSpeed && (pbRoughStat(opponent,PBStats::SPEED,skill)/2)<attacker.pbSpeed && @trickroom==0
          miniscore*=1.5
        end
        if pbRoughStat(opponent,PBStats::SPATK,skill)>pbRoughStat(opponent,PBStats::ATTACK,skill)
          miniscore*=1.1
        end
        count = -1
        sweepvar = false
        for i in pbParty(attacker.index)
          count+=1
          next if i.nil?
          temprole = pbGetMonRole(i,opponent,skill,count,pbParty(attacker.index))
          if temprole.include?(PBMonRoles::SWEEPER)
            sweepvar = true
          end
        end
        miniscore*=1.1 if sweepvar
        if opponent.effects[PBEffects::Confusion]>0
          miniscore*=1.1
        end
        if opponent.effects[PBEffects::Attract]>=0
          miniscore*=1.1
        end
        if opponent.effects[PBEffects::Yawn]>0
          miniscore*=0.4
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::SHEDSKIN)
          miniscore*=0.7
        end
        miniscore-=100
        if move.addlEffect.to_f != 100
          miniscore*=(move.addlEffect.to_f/100)
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
            miniscore*=2
          end
        end
        miniscore+=100
        miniscore/=100.0
        score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !((!opponent.abilitynulled && opponent.ability == PBAbilities::SHIELDDUST) && !opponent.moldbroken) && !hasgreatmoves(initialscores,scoreindex,skill,true)
      end
      livecount1=0
      for i in pbParty(opponent.index)
        next if i.nil?
        livecount1+=1 if i.hp!=0
      end
      livecount2=0
      for i in pbParty(attacker.index)
        next if i.nil?
        livecount2+=1 if i.hp!=0
      end
      if skill<PBTrainerAI.highSkill || $fefieldeffect!=23 # Not in a cave
        if opponent.status==PBStatuses::POISON || opponent.status==PBStatuses::BURN || opponent.effects[PBEffects::LeechSeed]>=0 || opponent.effects[PBEffects::MultiTurn]>0 || opponent.effects[PBEffects::Curse]
          score*=1.2
        else
          if livecount1>1
            score*=0.7
          end
        end
        if attacker.status!=0 || attacker.effects[PBEffects::Curse] || attacker.effects[PBEffects::Attract]>-1 || attacker.effects[PBEffects::Confusion]>0
          score*=0.5
        end
        if (attitemworks && attacker.item == PBItems::LEFTOVERS) || ((attitemworks && attacker.item == PBItems::BLACKSLUDGE) && attacker.pbHasType?(:POISON))
          score*=1.1
        end
        if attacker.pbOwnSide.effects[PBEffects::Tailwind]>0 || attacker.pbOwnSide.effects[PBEffects::Reflect]>0 || attacker.pbOwnSide.effects[PBEffects::LightScreen]>0
          score*=0.7
        end
        if opponent.effects[PBEffects::PerishSong]!=0 && attacker.effects[PBEffects::PerishSong]==0
          score*=1.3
        end
        if (attitemworks && attacker.item == PBItems::POWERHERB)
          score*=1.5
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::NOGUARD) || (!opponent.abilitynulled && opponent.ability == PBAbilities::NOGUARD)
          score*=0.1
        end
        if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
          if opponent.vanished
            score*=3
          end
          score*=1.1
        else
          score*=0.8
          score*=0.5 if checkAIhealing(aimem)
          score*=0.7 if checkAIaccuracy(aimem)
        end
        score*=0.3 if checkAImoves([PBMoves::THUNDER,PBMoves::HURRICANE],aimem)
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect==22
            if !attacker.pbHasType?(PBTypes::WATER)
              score*=2
            end
          end
          if $fefieldeffect==43 # Sky Field
            if !opponent.pbHasType?(PBTypes::ROCK)
              score*=2
            end
          end
        end
      end
      if @field.effects[PBEffects::Gravity]>0
        score*=0
      end
      if $fefieldeffect==38
        score*=0
      end
    when 0xCD # Phantom Force
      livecount1=0
      ghostvar=false
      fastermon=false
      for i in pbParty(opponent.index)
        next if i.nil?
        livecount1+=1 if i.hp!=0
      end
      livecount2=0
      for i in pbParty(attacker.index)
        next if i.nil?
        livecount2+=1 if i.hp!=0
        ghostvar=true if i.hasType?(:GHOST)
      end
      if !($fefieldeffect==18 ||$fefieldeffect==40 || attacker.isbossmon)
        if opponent.status==PBStatuses::POISON || opponent.status==PBStatuses::BURN || opponent.effects[PBEffects::LeechSeed]>=0 || opponent.effects[PBEffects::MultiTurn]>0 || opponent.effects[PBEffects::Curse]
          score*=1.2
        else
          if livecount1>1
            score*=0.8
          end
        end
        if attacker.status!=0 || attacker.effects[PBEffects::Curse] || attacker.effects[PBEffects::Attract]>-1 || attacker.effects[PBEffects::Confusion]>0
          score*=0.5
        end
        if (attitemworks && attacker.item == PBItems::LEFTOVERS) || ((attitemworks && attacker.item == PBItems::BLACKSLUDGE) && attacker.pbHasType?(:POISON))
          score*=1.1
        end
        if attacker.pbOwnSide.effects[PBEffects::Tailwind]>0 || attacker.pbOwnSide.effects[PBEffects::Reflect]>0 || attacker.pbOwnSide.effects[PBEffects::LightScreen]>0
          score*=0.7
        end
        if opponent.effects[PBEffects::PerishSong]!=0 && attacker.effects[PBEffects::PerishSong]==0
          score*=1.3
        end
        if (attitemworks && attacker.item == PBItems::POWERHERB)
          score*=1.5
        end
        if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
          fastermon=true
          score*=1.1
        else
          score*=0.8
          score*=0.5 if checkAIhealing(aimem)
          score*=0.7 if checkAIaccuracy(aimem)
        end
        if $fefieldeffect==29
           if fastermon && ghostvar
            score*=1.5
           end
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::NOGUARD) || (!opponent.abilitynulled && opponent.ability == PBAbilities::NOGUARD)
          score*=0.4
        else
          miniscore=100
          if attacker.stages[PBStats::ACCURACY]<0
            miniscore = (-5)*attacker.stages[PBStats::ACCURACY]
            miniscore+=100
            miniscore/=100.0
            score*=miniscore
          end
          if opponent.stages[PBStats::EVASION]>0
            miniscore = (5)*opponent.stages[PBStats::EVASION]
            miniscore+=100
            miniscore/=100.0
            score*=miniscore
          end
          if (oppitemworks && opponent.item == PBItems::LAXINCENSE) || (oppitemworks && opponent.item == PBItems::BRIGHTPOWDER)
            score*=1.2
          end
          if ((!opponent.abilitynulled && opponent.ability == PBAbilities::SANDVEIL) && pbWeather==PBWeather::SANDSTORM) || ((!opponent.abilitynulled && opponent.ability == PBAbilities::SNOWCLOAK) && pbWeather==PBWeather::HAIL)
            score*=1.3
          end
          if opponent.vanished && ((attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0))
            score*=3
          end
        end
      end
    when 0xCE # Sky Drop
      if opponent.pbHasType?(:FLYING)
        score = 5
      end
      livecount1=0
      for i in pbParty(opponent.index)
        next if i.nil?
        livecount1+=1 if i.hp!=0
      end
      livecount2=0
      for i in pbParty(attacker.index)
        next if i.nil?
        livecount2+=1 if i.hp!=0
      end
      if opponent.status==PBStatuses::POISON || opponent.status==PBStatuses::BURN || opponent.effects[PBEffects::LeechSeed]>=0 || opponent.effects[PBEffects::MultiTurn]>0 || opponent.effects[PBEffects::Curse]
        score*=1.5
      end
      if attacker.status!=0 || attacker.effects[PBEffects::Curse] || attacker.effects[PBEffects::Attract]>-1 || attacker.effects[PBEffects::Confusion]>0
        score*=0.5
      end
      if attacker.hasWorkingItem(:LEFTOVERS) || (attacker.hasWorkingItem(:BLACKSLUDGE) && attacker.pbHasType?(:POISON))
        score*=1.1
      end
      if attacker.pbOwnSide.effects[PBEffects::Tailwind]>0 || attacker.pbOwnSide.effects[PBEffects::Reflect]>0 || attacker.pbOwnSide.effects[PBEffects::LightScreen]>0 || opponent.pbOwnSide.effects[PBEffects::AuroraVeil]>0 || opponent.pbOwnSide.effects[PBEffects::AreniteWall]>0
        score*=0.7
      end
      if opponent.pbOwnSide.effects[PBEffects::Tailwind]>0 || opponent.pbOwnSide.effects[PBEffects::Reflect]>0 || opponent.pbOwnSide.effects[PBEffects::LightScreen]>0 || opponent.pbOwnSide.effects[PBEffects::AuroraVeil]>0 || opponent.pbOwnSide.effects[PBEffects::AreniteWall]>0
        score*=1.3
      end
      maxdam=checkAIdamage(aimem,attacker.pbPartner,opponent,skill)
      if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        score*=1.1
        if maxdam>attacker.pbPartner.hp
          score*=1.5
          if ((opponent.pbSpeed>pbRoughStat(attacker.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0)) && ((attacker.pbPartner.pbSpeed>pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0))
            score*=2
          end
        end
      else
        score*=0.8
      end
      if initialscores.length>0
        if hasbadmoves(initialscores,scoreindex,30)
          score*=1.5 
        elsif hasgreatmoves(initialscores,scoreindex,skill)
          score*=0.5
        end
      end
      if opponent.effects[PBEffects::PerishSong]!=0 && attacker.effects[PBEffects::PerishSong]==0
        score*=1.3
      end
      if $fefieldeffect==22
        if !attacker.pbHasType?(:WATER)
          score*=2
        end
      end
      if opponent.weight>2000 || opponent.effects[PBEffects::TwoTurnAttack]>0 ||
        @field.effects[PBEffects::Gravity]>0 || $fefieldeffect==23
        score*=0
      end
    when 0xCF # Fire Spin
      if (opponent.effects[PBEffects::MultiTurn]==0 && opponent.effects[PBEffects::Substitute]==0)
        score*=1.2
        if initialscores.length>0
          score*=1.5 if hasbadmoves(initialscores,scoreindex,30)
        end
        ministat=(-5)*statchangecounter(opponent,1,7,1)
        ministat+=100
        ministat/=100.0
        score*=ministat
        if opponent.totalhp == opponent.hp
          score*=1.2
        elsif opponent.hp*2 < opponent.totalhp
          score*=0.8
        end
        if checkAIdamage(aimem,attacker,opponent,skill)>attacker.hp
          score*=0.7
        elsif attacker.hp*3<attacker.totalhp
          score*=0.7
        end
        if opponent.effects[PBEffects::LeechSeed]>=0
          score*=1.5
        end
        if opponent.effects[PBEffects::Attract]>-1
          score*=1.3
        end
        if attacker.pbHasMove?((PBMoves::PERISHSONG)) || (!attacker.abilitynulled && attacker.ability == PBAbilities::PERISHBODY) ||
          score*=1.5
        elsif @doublebattle && (attacker.pbPartner.pbHasMove?((PBMoves::PERISHSONG))  ||
          (!attacker.pbPartner.abilitynulled && attacker.pbPartner.ability == PBAbilities::PERISHBODY))
          score*=1.5
        end
        if opponent.effects[PBEffects::Confusion]>0
          score*=1.3
        end
        if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL) || roles.include?(PBMonRoles::STALLBREAKER)
          score*=1.2
        end
        score*=1.2 if attacker.moves.any? {|moveloop| (PBStuff::PROTECTMOVE).include?(moveloop.id)}
        if (attitemworks && attacker.item == PBItems::BINDINGBAND)
          score*=1.3
        end
        if (attitemworks && attacker.item == PBItems::GRIPCLAW)
          score*=1.1
        end
      end
      if move.id==(PBMoves::FIRESPIN)
        if $fefieldeffect==20
          score*=0.7
        elsif $fefieldeffect==40
          score*=1.3
        end
      end
      if move.id==(PBMoves::MAGMASTORM)
        if $fefieldeffect==32
          score*=1.3
        end
      end
      if move.id==(PBMoves::SNAPTRAP)
        if $fefieldeffect==2
          score*=1.3
        end
      end
      if move.id==(PBMoves::SANDTOMB)
        if $fefieldeffect==12
          score*=1.3
        elsif $fefieldeffect==20
          score*=1.5 unless opponent.stages[PBStats::ACCURACY]<(-2)
        end
      end
      if move.id==(PBMoves::INFESTATION)
        if $fefieldeffect==15
          score*=1.3
        elsif $fefieldeffect==33
          score*=1.3
          if $fecounter == 3
            score*=1.3
          end
          if $fecounter == 4
            score*=1.5
          end
        end
      end
    when 0xD0 # Whirlpool
      if opponent.effects[PBEffects::MultiTurn]==0 && opponent.effects[PBEffects::Substitute]<=0
        score*=1.2
        if initialscores.length>0
          score*=1.2 if hasbadmoves(initialscores,scoreindex,30)
          score*=0.6 if hasgreatmoves(initialscores,scoreindex,skill)
        end
        ministat=(-5)*statchangecounter(opponent,1,7,1)
        ministat+=100
        ministat/=100.0
        score*=ministat
        if opponent.totalhp == opponent.hp
          score*=1.2
        elsif opponent.hp*2 < opponent.totalhp
          score*=0.8
        end
        if checkAIdamage(aimem,attacker,opponent,skill)>attacker.hp
          score*=0.7
        elsif attacker.hp*3<attacker.totalhp
          score*=0.7
        end
        if opponent.effects[PBEffects::LeechSeed]>=0
          score*=1.5
        end
        if opponent.effects[PBEffects::Attract]>-1
          score*=1.3
        end
        if attacker.pbHasMove?((PBMoves::PERISHSONG)) || (!attacker.abilitynulled && attacker.ability == PBAbilities::PERISHBODY)
          score*=1.5
        end
        if opponent.effects[PBEffects::Confusion]>0
          score*=1.3
        end
        if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
          score*=1.2
        end
        movecheck = false
        for j in attacker.moves
          movecheck = true if j.id==(PBMoves::PROTECT) || j.id==(PBMoves::DETECT) || j.id==(PBMoves::BANEFULBUNKER) || j.id==(PBMoves::SPIKYSHIELD)
        end
        setupcheck=false
        for j in opponent.moves
          setupcheck=true if j.id==(PBMoves::SWORDSDANCE) || j.id==(PBMoves::BELLYDRUM) || j.id==(PBMoves::WORKUP)
        end
        if movecheck
          score*=1.1
        end
        if (attitemworks && attacker.item == PBItems::BINDINGBAND)
          score*=1.3
        end
        if (attitemworks && attacker.item == PBItems::GRIPCLAW)
          score*=1.1
        end
        if $pkmn_move[opponent.effects[PBEffects::TwoTurnAttack]][0]== 0xCB
          score*=1.3
        end
      end
      watervar = false
      poisonvar = false
      for p in pbParty(attacker.index)
        next if p.nil?
        watervar = true if p.hasType?(:WATER)
        poisonvar = true if p.hasType?(:POISON)
      end
      if $fefieldeffect==20
        score*=0.7
      end
      if $fefieldeffect==21 || $fefieldeffect==22
        score*=1.3
        if opponent.effects[PBEffects::Confusion]<=0
          score*=1.2
        end
        if setupcheck
          score*=1.3
        end
      end
      if $fefieldeffect==26
        if score==0
          score+=10
        end
        if !(attacker.pbHasType?(:POISON) || attacker.pbHasType?(:STEEL))
          score*=1.5
        end
        if !poisonvar
          score*=2
        end
        if watervar
          score*=2
        end
      end
    when 0xD1 # Uproar
      if opponent.status==PBStatuses::SLEEP
        score*=0.7
      end
      if opponent.pbHasMove?(getID(PBMoves,:REST))
        score*=1.8
      end
      if opponent.pbNonActivePokemonCount==0 || (!attacker.abilitynulled && attacker.ability == PBAbilities::SHADOWTAG) || opponent.effects[PBEffects::MeanLook]>0
        score*=1.1
      end
      typemod=move.pbTypeModifier(move.type,attacker,opponent)
      if typemod<4
        score*=0.7
      end
      if attacker.hp*(1.0/attacker.totalhp)<0.75
        score*=0.75
      end
      if attacker.stages[PBStats::SPATK]<0
        minimini = attacker.stages[PBStats::SPATK]
        minimini*=5
        minimini+=100
        minimini/=100.0
        score*=minimini
      end
      if opponent.pbNonActivePokemonCount>1
        miniscore = opponent.pbNonActivePokemonCount*0.05
        miniscore = 1-miniscore
        score*=miniscore
      end
    when 0xD2 # Outrage
      livecount1=0
      thisinitial = score
      for i in pbParty(opponent.index)
        next if i.nil?
        livecount1+=1 if i.hp!=0
      end
      if !(!attacker.abilitynulled && attacker.ability == PBAbilities::OWNTEMPO)
        if thisinitial<100
          score*=0.85
        end
        if (attitemworks && attacker.item == PBItems::LUMBERRY) || (attitemworks && attacker.item == PBItems::PERSIMBERRY)
          score*=1.3
        end
        if attacker.stages[PBStats::ATTACK]>0
          miniscore = (-5)*attacker.stages[PBStats::ATTACK]
          miniscore+=100
          miniscore/=100.0
          score*=miniscore
        end
        if livecount1>2
          miniscore=100
          miniscore*=(livecount1-1)
          miniscore*=0.01
          miniscore*=0.05
          miniscore=1-miniscore
          score*=miniscore
        end
        score*=0.7 if checkAImoves(PBStuff::PROTECTMOVE,aimem)
        score*=0.7 if checkAIhealing(aimem)
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect==16 # Superheated Field
            score*=0.8
          end
        end
      else
        score *= 1.2
      end
      if move.id==(PBMoves::PETALDANCE)
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect==33 && $fecounter>1
            score*=1.5
          end
        end
      elsif move.id==(PBMoves::OUTRAGE)
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect!=36
            fairyvar = false
            for mon in pbParty(opponent.index)
              next if mon.nil?
              ghostvar=true if mon.hasType?(:FAIRY)
            end
            if fairyvar
              score*=0.8
            end
          end
        end
      elsif move.id==(PBMoves::THRASH)
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect!=36
            ghostvar = false
            for mon in pbParty(opponent.index)
              next if mon.nil?
              ghostvar=true if mon.hasType?(:GHOST)
            end
            if ghostvar
              score*=0.8
            end
          end
        end
      end
    when 0xD3 # Rollout
      if opponent.pbNonActivePokemonCount==0 || (!attacker.abilitynulled && attacker.ability == PBAbilities::SHADOWTAG) || opponent.effects[PBEffects::MeanLook]>0
        score*=1.1
      end
      if attacker.hp*(1.0/attacker.totalhp)<0.75
        score*=0.75
      end
      if attacker.stages[PBStats::ACCURACY]<0
        miniscore = (5)*attacker.stages[PBStats::ATTACK]
        miniscore+=100
        miniscore/=100.0
        score*=miniscore
      end
      if attacker.stages[PBStats::ATTACK]<0
        miniscore = (5)*attacker.stages[PBStats::ATTACK]
        miniscore+=100
        miniscore/=100.0
        score*=miniscore
      end
      if opponent.stages[PBStats::EVASION]>0
        miniscore = (-5)*attacker.stages[PBStats::ATTACK]
        miniscore+=100
        miniscore/=100.0
        score*=miniscore
      end
      if (oppitemworks && opponent.item == PBItems::LAXINCENSE) || (oppitemworks && opponent.item == PBItems::BRIGHTPOWDER)
        score*=0.8
      end
      if ((!opponent.abilitynulled && opponent.ability == PBAbilities::SANDVEIL) && pbWeather==PBWeather::SANDSTORM) || ((!opponent.abilitynulled && opponent.ability == PBAbilities::SNOWCLOAK) && pbWeather==PBWeather::HAIL)
        score*=0.8
      end
      if attacker.status==PBStatuses::PARALYSIS
        score*=0.5
      end
      if attacker.effects[PBEffects::Confusion]>0
        score*=0.5
      end
      if attacker.effects[PBEffects::Attract]>=0
        score*=0.5
      end
      if opponent.pbNonActivePokemonCount>1
        miniscore = 1 - (opponent.pbNonActivePokemonCount*0.05)
        score*=miniscore
      end
      if attacker.effects[PBEffects::DefenseCurl]
        score*=1.2
      end
      if checkAIdamage(aimem,attacker,opponent,skill)*3<attacker.hp 
        score*=1.5
      end
      score*=0.8 if checkAImoves(PBStuff::PROTECTMOVE,aimem)
      if $fefieldeffect==13
        if (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
          score*=1.3
        end
      end
    when 0xD4 # Bide
      statmove = false
      movelength = -1
      for j in aimem
        movelength = aimem.length
        if j.basedamage==0
          statmove=true
        end
      end
      if ((attitemworks && attacker.item == PBItems::FOCUSSASH) || (!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY))
        score*=1.2
      end
      miniscore = attacker.hp*(1.0/attacker.totalhp)
      score*=miniscore
      if checkAIdamage(aimem,attacker,opponent,skill)*2 > attacker.hp
        score*=0.2
      end
      if attacker.hp*3<attacker.totalhp
        score*=0.7
      end
      if (attitemworks && attacker.item == PBItems::LEFTOVERS) || ((attitemworks && attacker.item == PBItems::BLACKSLUDGE) && attacker.pbHasType?(:POISON))
        score*=1.1
      end
      if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
        score*=1.3
      end
      if (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        score*=1.3
      end
      score*=0.5 if checkAImoves(PBStuff::SETUPMOVE,aimem)
      if statmove
        score*=0.8
      else
        if movelength==4
          score*=1.3
        end
      end
    when 0xD5 # Recover
      fastermon=((attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) || (attacker.hasWorkingAbility(:PRANKSTER) || attacker.hasWorkingAbility(:TRIAGE)) 
      halfhealth=(attacker.totalhp/2)
      maxdam = checkAIdamage(aimem,attacker,opponent,skill)
      if maxdam>attacker.hp
        if maxdam>(attacker.hp+halfhealth)
          score=0
        else
          if maxdam>=halfhealth
            if fastermon
              score*=2
            else
              score*=1.5
            end
          else
            score*=5
            if initialscores.length>0
              score*=3 if hasgreatmoves(initialscores,scoreindex,skill)
            end
          end
        end
      else
        if maxdam*1.5>attacker.hp
          score*=2
        end
        if !fastermon
          if maxdam*2>attacker.hp
            score*=5
            if initialscores.length>0
              score*=3 if hasgreatmoves(initialscores,scoreindex,skill)
            end
          end
        end
      end
      hpchange=(EndofTurnHPChanges(attacker,opponent,false,false,true)) # what % of our hp will change after end of turn effects go through
      opphpchange=(EndofTurnHPChanges(opponent,attacker,false,false,true)) # what % of our hp will change after end of turn effects go through
      if opphpchange<1 ## we are going to be taking more chip damage than we are going to heal
        oppchipdamage=((opponent.totalhp*(1-hpchange)))
      end
      thisdam=(maxdam*1.1)
      hplost=(attacker.totalhp-attacker.hp)
      hplost+=maxdam if !fastermon
      livecount2=0
      for i in pbParty(attacker.index)
        next if i.nil?
        livecount2+=1 if i.hp!=0
      end
      if hpchange<1 ## we are going to be taking more chip damage than we are going to heal
        chipdamage=((attacker.totalhp*(1-hpchange)))
        thisdam+=chipdamage
      elsif hpchange>1 ## we are going to be healing more hp than we take chip damage for  
        healing=((attacker.totalhp*(hpchange-1)))
        thisdam-=healing if !(thisdam>attacker.hp)
      elsif hpchange<=0 ## we are going to die to future sight/doom desire or huge overstack of end of turn effects. hence we should just not heal.
        score*=0
      end
      if thisdam>hplost
        score*=0.1
      else
        if livecount2==1 && hplost<=(halfhealth)
          score*=0.01
        end
        if thisdam<=(halfhealth)
           score*=3
        else
          if fastermon
            if hpchange<1 && thisdam>=halfhealth && !(opphpchange<1)
              score*=0.3
            end
          end
        end
      end
      score*=0.7 if opponent.moves.any? {|moveloop| (PBStuff::SETUPMOVE).include?(moveloop.id)}
      if ((attacker.hp.to_f)<=halfhealth)
        score*=1.5
      else
        score*=0.8
      end
      score/=(attacker.effects[PBEffects::Toxic]) if attacker.effects[PBEffects::Toxic]>0
      score*=0.8 if maxdam>halfhealth
      if (oppitemworks && opponent.item == PBItems::METRONOME)
        met=(1.0+opponent.effects[PBEffects::Metronome]*0.2) 
        score/=met
      end 
      score*=1.3 if move.id==(PBMoves::HEALORDER) && $fefieldeffect==15 # Forest
      score*=1.1 if attacker.status==PBStatuses::PARALYSIS || attacker.effects[PBEffects::Attract]>=0 || attacker.effects[PBEffects::Confusion]>0
      if opponent.status==PBStatuses::POISON || opponent.status==PBStatuses::BURN || opponent.effects[PBEffects::LeechSeed]>=0 || opponent.effects[PBEffects::Curse] || opponent.effects[PBEffects::MultiTurn]>0
        score*=1.3
        score*=1.3 if opponent.effects[PBEffects::Toxic]>0
        score*=1.3 if ((attacker.item == PBItems::BINDINGBAND) ||  ((($fefieldeffect==12 || $fefieldeffect==20) && opponent.effects[PBEffects::MultiTurnAttack]==232) || ($fefieldeffect==15 && opponent.effects[PBEffects::MultiTurnAttack]==582) || (($fefieldeffect==21 || $fefieldeffect==22) && opponent.effects[PBEffects::MultiTurnAttack]==553) ||
        ($fefieldeffect==32 && opponent.effects[PBEffects::MultiTurnAttack]==130) || (($fefieldeffect==7 || $fefieldeffect==40) && opponent.effects[PBEffects::MultiTurnAttack]==147)))
        score *= 1.3 if (opponent.effects[PBEffects::MultiTurnAttack]==582) && $fefieldeffect == 33 && $fecounter > 1
        score *= 2 if (opponent.effects[PBEffects::MultiTurnAttack]==582) && $fefieldeffect == 33 && $fecounter > 2
        score *= 2.6667 if (opponent.effects[PBEffects::MultiTurnAttack]==582) && $fefieldeffect == 33 && $fecounter > 3
      end
      score*=1.3 if checkAImoves(PBStuff::CONTRARYBAITMOVE,aimem)
      score*=1.2 if opponent.vanished || opponent.effects[PBEffects::HyperBeam]>0
      score*=0.1 if ((attacker.hp.to_f)/attacker.totalhp)>0.8
      score*=0.6 if ((attacker.hp.to_f)/attacker.totalhp)>0.6
      score*=2 if ((attacker.hp.to_f)/attacker.totalhp)<0.25
      score=0 if attacker.effects[PBEffects::Wish]>0
    when 0xD6 # Roost
      fastermon=(attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0) || (attacker.hasWorkingAbility(:PRANKSTER) || attacker.hasWorkingAbility(:TRIAGE) || attacker.hasWorkingAbility(:GALEWINGS)) 
      halfhealth=(attacker.totalhp/2)
      maxdam = checkAIdamage(aimem,attacker,opponent,skill)
      if (attacker.type1==PBTypes::FLYING || attacker.type2==PBTypes::FLYING)
        groundeddam=0
        groundedattacker=attacker.clone
        groundedattacker.effects[PBEffects::Roost]=true
        groundedattacker.pbUpdate(true)
        for m in opponent.moves
          tempdam = (pbRoughDamage(m,opponent,groundedattacker,skill,m.basedamage))
          groundeddam=tempdam if tempdam>groundeddam
        end
        maxdam=groundeddam if (fastermon && maxdam>groundeddam)
        PBDebug.log(sprintf("Expected damage taken after Roosting: %d",maxdam)) if $INTERNAL && shutup==false
        groundedattacker.effects[PBEffects::Roost]=false
        groundedattacker.pbUpdate(true)
      end
      if maxdam>attacker.hp
        if maxdam>(attacker.hp+halfhealth)
          score=0
        else
          if maxdam>=halfhealth
            if fastermon
              score*=2
            else
              score*=1.5
            end
          else
            score*=5
            if initialscores.length>0
              score*=3 if hasgreatmoves(initialscores,scoreindex,skill)
            end
          end
        end
      else
        if maxdam*1.5>attacker.hp
          score*=2
        end
        if !fastermon
          if maxdam*2>attacker.hp
            score*=5
            if initialscores.length>0
              score*=3 if hasgreatmoves(initialscores,scoreindex,skill)
            end
          end
        end
      end
      hpchange=(EndofTurnHPChanges(attacker,opponent,false,false,true)) # what % of our hp will change after end of turn effects go through
      thisdam=(maxdam*1.1)
      hplost=(attacker.totalhp-attacker.hp)
      hplost+=maxdam if !fastermon
      livecount2=0
      for i in pbParty(attacker.index)
        next if i.nil?
        livecount2+=1 if i.hp!=0
      end
      if hpchange<1 ## we are going to be taking more chip damage than we are going to heal
        chipdamage=((attacker.totalhp*(1-hpchange)))
        thisdam+=chipdamage
      elsif hpchange>1 ## we are going to be healing more hp than we take chip damage for  
        healing=((attacker.totalhp*(hpchange-1)))
        thisdam-=healing if !(thisdam>attacker.hp)
      elsif hpchange<=0 ## we are going to die to future sight/doom desire or huge overstack of end of turn effects. hence we should just not heal.
        score*=0
      end
      if thisdam>hplost
        score*=0.1
      else
        if livecount2==1 && hplost<(halfhealth*1.1)
          score*=0.01
        end
        if thisdam<(halfhealth)
           score*=3
        end
      end
      score*=0.7 if opponent.moves.any? {|moveloop| (PBStuff::SETUPMOVE).include?(moveloop.id)}
      if ((attacker.hp.to_f)<=halfhealth)
        score*=1.5
      else
        score*=0.9
      end
      score/=(attacker.effects[PBEffects::Toxic]) if attacker.effects[PBEffects::Toxic]>0
      score*=0.6 if maxdam>halfhealth
      if (oppitemworks && opponent.item == PBItems::METRONOME)
        met=(1.0+opponent.effects[PBEffects::Metronome]*0.2) 
        score/=met
      end
      score*=1.1 if attacker.status==PBStatuses::PARALYSIS || attacker.effects[PBEffects::Attract]>=0 || attacker.effects[PBEffects::Confusion]>0
      if opponent.status==PBStatuses::POISON || opponent.status==PBStatuses::BURN || opponent.effects[PBEffects::LeechSeed]>=0 || opponent.effects[PBEffects::Curse] || opponent.effects[PBEffects::MultiTurn]>0
        score*=1.3
        score*=1.3 if opponent.effects[PBEffects::Toxic]>0
        score*=1.3 if ((attacker.item == PBItems::BINDINGBAND) ||  ((($fefieldeffect==12 || $fefieldeffect==20) && opponent.effects[PBEffects::MultiTurnAttack]==232) || ($fefieldeffect==15 && opponent.effects[PBEffects::MultiTurnAttack]==582) || (($fefieldeffect==21 || $fefieldeffect==22) && opponent.effects[PBEffects::MultiTurnAttack]==553) ||
        ($fefieldeffect==32 && opponent.effects[PBEffects::MultiTurnAttack]==130) || (($fefieldeffect==7 || $fefieldeffect==40) && opponent.effects[PBEffects::MultiTurnAttack]==147)))
        score *= 1.3 if (opponent.effects[PBEffects::MultiTurnAttack]==582) && $fefieldeffect == 33 && $fecounter > 1
        score *= 2 if (opponent.effects[PBEffects::MultiTurnAttack]==582) && $fefieldeffect == 33 && $fecounter > 2
        score *= 2.6667 if (opponent.effects[PBEffects::MultiTurnAttack]==582) && $fefieldeffect == 33 && $fecounter > 3
      end
      score*=1.3 if checkAImoves(PBStuff::CONTRARYBAITMOVE,aimem)
      score*=1.2 if opponent.vanished || opponent.effects[PBEffects::HyperBeam]>0 
      score*=0.1 if ((attacker.hp.to_f)/attacker.totalhp)>0.8
      score*=0.6 if ((attacker.hp.to_f)/attacker.totalhp)>0.6
      score*=2 if ((attacker.hp.to_f)/attacker.totalhp)<0.25
      score=0 if attacker.effects[PBEffects::Wish]>0
    when 0xD7 # Wish
      fastermon=(attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0) || (attacker.hasWorkingAbility(:PRANKSTER) || attacker.hasWorkingAbility(:TRIAGE)) 
      protectmove=false
      for j in attacker.moves
        protectmove = true if j.id==(PBMoves::PROTECT) || j.id==(PBMoves::DETECT) || j.id==(PBMoves::BANEFULBUNKER) || j.id==(PBMoves::SPIKYSHIELD)
      end
      halfhealth=(attacker.totalhp/2)
      maxdam = checkAIdamage(aimem,attacker,opponent,skill)
      if maxdam>attacker.hp
          score=0
      else
        if maxdam*1.5>attacker.hp
          score*=2
        end
        if !fastermon
          if (maxdam*2>attacker.hp)
            score*=3
            if initialscores.length>0 && hasgreatmoves(initialscores,scoreindex,skill) && attacker.hp!=attacker.totalhp
              score*=6 
            end
          end
        end
      end
      hpchange=(EndofTurnHPChanges(attacker,opponent,false,false,true)) # what % of our hp will change after end of turn effects go through
      thisdam=(maxdam*1.1)
      hplost=(attacker.totalhp-attacker.hp)
      hplost+=maxdam if !fastermon
      livecount2=0
      for i in pbParty(attacker.index)
        next if i.nil?
        livecount2+=1 if i.hp!=0
      end
      if hpchange<1 ## we are going to be taking more chip damage than we are going to heal
        chipdamage=((attacker.totalhp*(1-hpchange)))
        thisdam+=chipdamage
      elsif hpchange>1 ## we are going to be healing more hp than we take chip damage for  
        healing=((attacker.totalhp*(hpchange-1)))
        thisdam-=healing if !(thisdam>attacker.hp)
      elsif hpchange<=0 ## we are going to die to future sight/doom desire or huge overstack of end of turn effects. hence we should just not heal.
        score*=0
      end
      if thisdam>hplost
        score*=0.1
      else
        if livecount2==1 && hplost<(halfhealth*1.1)
          score*=0.01
        end
        if thisdam<(halfhealth)
           score*=2
        end
      end
      if opponent.effects[PBEffects::Taunt]==0
         score*=0.7 if opponent.moves.any? {|moveloop| (PBStuff::SETUPMOVE).include?(moveloop.id)}
      end
      if ((attacker.hp.to_f)<=halfhealth)
        score*=1.5
      else
        score*=0.8
      end
      score/=(attacker.effects[PBEffects::Toxic]) if attacker.effects[PBEffects::Toxic]>0
      if !(roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL))
        score*=0.8
      end
      score*=1.3 if protectmove
      score*=1.1 if attacker.status==PBStatuses::PARALYSIS || attacker.effects[PBEffects::Attract]>=0 || attacker.effects[PBEffects::Confusion]>0
      if opponent.status==PBStatuses::POISON || opponent.status==PBStatuses::BURN || opponent.effects[PBEffects::LeechSeed]>=0 || opponent.effects[PBEffects::Curse] || opponent.effects[PBEffects::MultiTurn]>0
        score*=1.3
        score*=1.3 if opponent.effects[PBEffects::Toxic]>0
        score*=1.3 if ((attacker.item == PBItems::BINDINGBAND) ||  ((($fefieldeffect==12 || $fefieldeffect==20) && opponent.effects[PBEffects::MultiTurnAttack]==232) || ($fefieldeffect==15 && opponent.effects[PBEffects::MultiTurnAttack]==582) || (($fefieldeffect==21 || $fefieldeffect==22) && opponent.effects[PBEffects::MultiTurnAttack]==553) ||
        ($fefieldeffect==32 && opponent.effects[PBEffects::MultiTurnAttack]==130) || (($fefieldeffect==7 || $fefieldeffect==40) && opponent.effects[PBEffects::MultiTurnAttack]==147)))
        score *= 1.3 if (opponent.effects[PBEffects::MultiTurnAttack]==582) && $fefieldeffect == 33 && $fecounter > 1
        score *= 2 if (opponent.effects[PBEffects::MultiTurnAttack]==582) && $fefieldeffect == 33 && $fecounter > 2
        score *= 2.6667 if (opponent.effects[PBEffects::MultiTurnAttack]==582) && $fefieldeffect == 33 && $fecounter > 3
      end
      score*=1.3 if checkAImoves(PBStuff::CONTRARYBAITMOVE,aimem)
      if opponent.vanished || opponent.effects[PBEffects::HyperBeam]>0
        score*=1.2
      end
      if roles.include?(PBMonRoles::CLERIC)
        wishpass=false
        for i in pbParty(attacker.index)
          next if i.nil?
          if (i.hp.to_f)/(i.totalhp.to_f)<0.6 && (i.hp.to_f)/(i.totalhp.to_f)>0.3
            wishpass=true
          end
        end
        score*=1.3 if wishpass
      end
      if skill>=PBTrainerAI.highSkill
        if $fefieldeffect==3 || $fefieldeffect==9 || $fefieldeffect==29 || $fefieldeffect==31 || $fefieldeffect==34 # Misty/Rainbow/Holy/Fairytale/Starlight
          score*=1.5
        end
      end
      if attacker.effects[PBEffects::Wish]>0
        score=0
      end
    when 0xD8 # Synthesis
      fastermon=((attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) || (attacker.hasWorkingAbility(:PRANKSTER) || attacker.hasWorkingAbility(:TRIAGE)) 
      halfhealth=(attacker.totalhp/2)
      maxdam = checkAIdamage(aimem,attacker,opponent,skill)
      if maxdam>attacker.hp
        if maxdam>(attacker.hp+halfhealth)
          score=0
        else
          if maxdam>=halfhealth
            if fastermon
              score*=2
            else
              score*=1.5
            end
          else
            score*=5
            if initialscores.length>0
              score*=3 if hasgreatmoves(initialscores,scoreindex,skill)
            end
          end
        end
      else
        if maxdam*1.5>attacker.hp
          score*=2
        end
        if !fastermon
          if maxdam*2>attacker.hp
            score*=5
            if initialscores.length>0
              score*=3 if hasgreatmoves(initialscores,scoreindex,skill)
            end
          end
        end
      end
      hpchange=(EndofTurnHPChanges(attacker,opponent,false,false,true)) # what % of our hp will change after end of turn effects go through
      thisdam=(maxdam*1.1)
      hplost=(attacker.totalhp-attacker.hp)
      hplost+=maxdam if !fastermon
      livecount2=0
      for i in pbParty(attacker.index)
        next if i.nil?
        livecount2+=1 if i.hp!=0
      end
      if hpchange<1 ## we are going to be taking more chip damage than we are going to heal
        chipdamage=((attacker.totalhp*(1-hpchange)))
        thisdam+=chipdamage
      elsif hpchange>1 ## we are going to be healing more hp than we take chip damage for  
        healing=((attacker.totalhp*(hpchange-1)))
        thisdam-=healing if !(thisdam>attacker.hp)
      elsif hpchange<=0 ## we are going to die to future sight/doom desire or huge overstack of end of turn effects. hence we should just not heal.
        score*=0
      end
      if thisdam>hplost
        score*=0.1
      else
        if livecount2==1 && hplost<(halfhealth*1.1)
          score*=0.01
        end
        if thisdam<(halfhealth)
           score*=2
        end
      end
      if opponent.effects[PBEffects::Taunt]==0
        score*=0.7 if opponent.moves.any? {|moveloop| (PBStuff::SETUPMOVE).include?(moveloop.id)}
      end
      if ((attacker.hp.to_f)<=halfhealth)
        score*=1.5
      else
        score*=0.8
      end
      score/=(attacker.effects[PBEffects::Toxic]) if attacker.effects[PBEffects::Toxic]>0
      score*=0.8 if maxdam>halfhealth
      if (oppitemworks && opponent.item == PBItems::METRONOME)
        met=(1.0+opponent.effects[PBEffects::Metronome]*0.2) 
        score/=met
      end
      score*=1.1 if attacker.status==PBStatuses::PARALYSIS || attacker.effects[PBEffects::Attract]>=0 || attacker.effects[PBEffects::Confusion]>0
      if opponent.status==PBStatuses::POISON || opponent.status==PBStatuses::BURN || opponent.effects[PBEffects::LeechSeed]>=0 || opponent.effects[PBEffects::Curse] || opponent.effects[PBEffects::MultiTurn]>0
        score*=1.3
        score*=1.3 if opponent.effects[PBEffects::Toxic]>0
        score*=1.3 if ((attacker.item == PBItems::BINDINGBAND) ||  ((($fefieldeffect==12 || $fefieldeffect==20) && opponent.effects[PBEffects::MultiTurnAttack]==232) || ($fefieldeffect==15 && opponent.effects[PBEffects::MultiTurnAttack]==582) || (($fefieldeffect==21 || $fefieldeffect==22) && opponent.effects[PBEffects::MultiTurnAttack]==553) ||
        ($fefieldeffect==32 && opponent.effects[PBEffects::MultiTurnAttack]==130) || (($fefieldeffect==7 || $fefieldeffect==40) && opponent.effects[PBEffects::MultiTurnAttack]==147)))
        score *= 1.3 if (opponent.effects[PBEffects::MultiTurnAttack]==582) && $fefieldeffect == 33 && $fecounter > 1
        score *= 2 if (opponent.effects[PBEffects::MultiTurnAttack]==582) && $fefieldeffect == 33 && $fecounter > 2
        score *= 2.6667 if (opponent.effects[PBEffects::MultiTurnAttack]==582) && $fefieldeffect == 33 && $fecounter > 3
      end
      score*=1.3 if pbWeather==PBWeather::SUNNYDAY || (move.id==(PBMoves::MOONLIGHT) && ($fefieldeffect==4 || $fefieldeffect==34 || $fefieldeffect==35))
      score*=0.5 if $fefieldeffect==4 || (pbWeather==PBWeather::SANDSTORM || pbWeather==PBWeather::RAINDANCE || pbWeather==PBWeather::HAIL)
      score*=1.3 if checkAImoves(PBStuff::CONTRARYBAITMOVE,aimem)
      score*=1.2 if opponent.vanished || opponent.effects[PBEffects::HyperBeam]>0
      score*=0.1 if ((attacker.hp.to_f)/attacker.totalhp)>0.8
      score*=0.6 if ((attacker.hp.to_f)/attacker.totalhp)>0.6
      score*=2 if ((attacker.hp.to_f)/attacker.totalhp)<0.25
      score=0 if attacker.effects[PBEffects::Wish]>0
    when 0xD9 # Rest
      fastermon=((attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) || (attacker.hasWorkingAbility(:PRANKSTER) || attacker.hasWorkingAbility(:TRIAGE)) 
      halfhealth=(attacker.totalhp/2)
      maxdam = checkAIdamage(aimem,attacker,opponent,skill)
      cansurvive=(attacker.item == PBItems::RAMPCREST && attacker.species==PBSpecies::RAMPARDOS && !attacker.effects[PBEffects::RampCrestUsage]) || ((attacker.item == PBItems::FOCUSSASH || attacker.ability == PBAbilities::STURDY) && attacker.hp==attacker.totalhp) 
      if maxdam>attacker.hp
        if maxdam>(attacker.totalhp) && !cansurvive
          score=0
        else
          if maxdam>=halfhealth
            if fastermon
              score*=2.5
            else
              score*=2
            end
          else
            score*=5
            if fastermon && hasgreatmoves(initialscores,scoreindex,skill)
              score*=6
            end
          end
        end
      else
        if maxdam*1.5>attacker.hp
          score*=2
        end
        if !fastermon 
          if maxdam*2>attacker.hp
            score*=5
          end
        end
      end
      if (attacker.hp.to_f)/attacker.totalhp<0.5
        score*=1.5
        if (attacker.hasWorkingAbility(:PRANKSTER) || attacker.hasWorkingAbility(:TRIAGE)) 
          score*=1.4
        end
      else
        score*=0.5
      end
      if (roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL))
        score*=1.2
      end
      if opponent.status==PBStatuses::POISON || opponent.status==PBStatuses::BURN || opponent.effects[PBEffects::LeechSeed]>=0 || opponent.effects[PBEffects::Curse] || opponent.effects[PBEffects::MultiTurn]>0
        score*=1.3
        score*=1.3 if opponent.effects[PBEffects::Toxic]>0
        score*=1.3 if ((attacker.item == PBItems::BINDINGBAND) ||  ((($fefieldeffect==12 || $fefieldeffect==20) && opponent.effects[PBEffects::MultiTurnAttack]==232) || ($fefieldeffect==15 && opponent.effects[PBEffects::MultiTurnAttack]==582) || (($fefieldeffect==21 || $fefieldeffect==22) && opponent.effects[PBEffects::MultiTurnAttack]==553) ||
        ($fefieldeffect==32 && opponent.effects[PBEffects::MultiTurnAttack]==130) || (($fefieldeffect==7 || $fefieldeffect==40) && opponent.effects[PBEffects::MultiTurnAttack]==147)))
        score *= 1.3 if (opponent.effects[PBEffects::MultiTurnAttack]==582) && $fefieldeffect == 33 && $fecounter > 1
        score *= 2 if (opponent.effects[PBEffects::MultiTurnAttack]==582) && $fefieldeffect == 33 && $fecounter > 2
        score *= 2.6667 if (opponent.effects[PBEffects::MultiTurnAttack]==582) && $fefieldeffect == 33 && $fecounter > 3
      end
      if attacker.status==PBStatuses::POISON
        score*=1.3
        if opponent.effects[PBEffects::Toxic]>0
          score*=1.3
        end
      end
      if attacker.status==PBStatuses::BURN
        score*=1.3
        if attacker.spatk<attacker.attack
          score*=1.5
        end
      end
      if attacker.status==PBStatuses::PARALYSIS
        score*=1.3
      end
      score*=1.3 if checkAImoves(PBStuff::CONTRARYBAITMOVE,aimem)
      oppolddata = PBMove.new(opponent.lastMoveUsed)
      oppoldmove = PokeBattle_Move.pbFromPBMove(self,oppolddata,opponent)
      if attacker.hp*(1.0/attacker.totalhp)>=0.8
        if attacker.species == PBSpecies::BASTIODON && attacker.item==PBItems::BASTCREST && attitemworks && !(opponent.pbHasMove?((PBMoves::TAUNT)) || opponent.moves.any? {|moveloop| (PBStuff::HEALFUNCTIONS).include?(moveloop.function)})
          reflectdamage=maxdam
          reflectdamage=attacker.hp-1 if maxdam>=attacker.hp
          reflectdamage*=0.5
          olddata = PBMove.new(attacker.lastMoveUsed)
          oldmove = PokeBattle_Move.pbFromPBMove(self,olddata,attacker)
          abusevar=false
          if opponent.moves.any? {|moveloop| (PBStuff::SETUPMOVE).include?(moveloop.id)} || (oldmove.function==0xD9 && oppoldmove.function != 0x7D)
            rnd=pbAIRandom(4)
            if rnd>=2 || oldmove.function==0xD9
              abusevar=true
            end
          end
          if (reflectdamage>opponent.hp && opponent.effects[PBEffects::UsingItem].length==0 && abusevar==false)
            score*=4
            if initialscores.length>0
              score*=6 if hasgreatmoves(initialscores,scoreindex,skill)
            end
          end
        else
          score*=0
        end
      end
      if !((attitemworks && attacker.item == PBItems::LUMBERRY) || (attitemworks && attacker.item == PBItems::CHESTOBERRY) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::HYDRATION) && (pbWeather==PBWeather::RAINDANCE || $fefieldeffect==21 || $fefieldeffect==22)))
        score*=0.9
        if checkAImoves([PBMoves::WAKEUPSLAP,PBMoves::NIGHTMARE,PBMoves::DREAMEATER],aimem) || (!opponent.abilitynulled && opponent.ability == PBAbilities::BADDREAMS)
          score*=0.7
        end
        if attacker.pbHasMove?((PBMoves::SLEEPTALK)) || attacker.pbHasMove?((PBMoves::HOTTEMPO))
          score*=1.4
        end
        if attacker.pbHasMove?((PBMoves::SNORE))
          score*=1.2
        end
        if !attacker.abilitynulled && (attacker.ability == PBAbilities::SHEDSKIN || attacker.ability == PBAbilities::EARLYBIRD)
          score*=1.1
        end
        if @doublebattle
          score*=0.8
        end
      else
        if attitemworks && (attacker.item == PBItems::LUMBERRY || attacker.item == PBItems::CHESTOBERRY)
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::HARVEST)
            score*=1.2
          else
            score*=0.8
          end
        end
        score*=1.5 if ((!attacker.abilitynulled && attacker.ability == PBAbilities::HYDRATION) && (pbWeather==PBWeather::RAINDANCE || $fefieldeffect==21 || $fefieldeffect==22))
      end
      if (maxdam*2 > attacker.totalhp) && !(cansurvive && attacker.species == PBSpecies::BASTIODON && attacker.item==PBItems::BASTCREST)
        score*=0.4
      else
        if maxdam*3 < attacker.totalhp
          score*=1.3
          #experimental -- cancels out drop if killing moves
          if initialscores.length>0
            score*=6 if hasgreatmoves(initialscores,scoreindex,skill)
          end
          #end experimental
        end
      end
      if attacker.status!=0
        score*=1.4
        if attacker.effects[PBEffects::Toxic]>0
          score*=1.2
        end
      end
      if attacker.status==PBStatuses::SLEEP && attacker.statusCount>1
        if attacker.pbHasMove?((PBMoves::SLEEPTALK)) 
          score*=0.01
        end
      end
      if !(attacker.pbCanSleep?(false,true,true))
        score*=0
      end
    when 0xDA # Aqua Ring
      if !attacker.effects[PBEffects::AquaRing]
        if attacker.hp*(1.0/attacker.totalhp)>0.75
          score*=1.2
        end
        if attacker.hp*(1.0/attacker.totalhp)<0.50
          score*=0.7
          if attacker.hp*(1.0/attacker.totalhp)<0.33
            score*=0.5
          end
        end
        if (attitemworks && attacker.item == PBItems::LEFTOVERS) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::RAINDISH) && pbWeather==PBWeather::RAINDANCE) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::ICEBODY) && pbWeather==PBWeather::HAIL) || attacker.effects[PBEffects::Ingrain] || ((attitemworks && attacker.item == PBItems::BLACKSLUDGE) && attacker.pbHasType?(:POISON)) || $fefieldeffect==2
          score*=1.2
        end
        if attacker.moves.any? {|moveloop| (PBStuff::PROTECTMOVE).include?(moveloop.id)}
          score*=1.2
        end
        if attacker.moves.any? {|moveloop| (PBStuff::PIVOTMOVE).include?(moveloop.id)}
          score*=0.8
        end
        if checkAIdamage(aimem,attacker,opponent,skill)*5 < attacker.totalhp 
          score*=1.2
        elsif checkAIdamage(aimem,attacker,opponent,skill) > attacker.totalhp*0.4
          score*=0.3
        end
        if (roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL) || roles.include?(PBMonRoles::TANK))
          score*=1.2
        end
        score*=0.3 if checkAImoves(PBStuff::SWITCHOUTMOVE,aimem)
        if @doublebattle
          score*=0.5
        end
        if $fefieldeffect==3 || $fefieldeffect==8 || $fefieldeffect==21 || $fefieldeffect==22
          score*=1.3
        end
        if $fefieldeffect==7
          score*=1.3
        end
        if $fefieldeffect==11
          score*=0.3
        end
      else
        score*=0
      end
    when 0xDB # Ingrain
      if !attacker.effects[PBEffects::Ingrain]
        if attacker.hp*(1.0/attacker.totalhp)>0.75
          score*=1.2
        end
        if attacker.hp*(1.0/attacker.totalhp)<0.50
          score*=0.7
          if attacker.hp*(1.0/attacker.totalhp)<0.33
            score*=0.5
          end
        end
        if (attitemworks && attacker.item == PBItems::LEFTOVERS) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::RAINDISH) && pbWeather==PBWeather::RAINDANCE) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::ICEBODY) && pbWeather==PBWeather::HAIL) || attacker.effects[PBEffects::AquaRing] || ((attitemworks && attacker.item == PBItems::BLACKSLUDGE) && attacker.pbHasType?(:POISON)) || $fefieldeffect==2
          score*=1.2
        end
        if attacker.moves.any? {|moveloop| (PBStuff::PROTECTMOVE).include?(moveloop.id)}
          score*=1.2
        end
        if attacker.moves.any? {|moveloop| (PBStuff::PIVOTMOVE).include?(moveloop.id)}
          score*=0.8
        end
        if checkAIdamage(aimem,attacker,opponent,skill)*5 < attacker.totalhp 
          score*=1.2
        elsif checkAIdamage(aimem,attacker,opponent,skill) > attacker.totalhp*0.4
          score*=0.3
        end
        if (roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL) || roles.include?(PBMonRoles::TANK))
          score*=1.2
        end
        score*=0.3 if checkAImoves(PBStuff::SWITCHOUTMOVE,aimem)
        if @doublebattle
          score*=0.5
        end
        if $fefieldeffect==15 || $fefieldeffect==33
          score*=1.3
          if $fefieldeffect==33 && $fecounter>3
            score*=1.3
          end
        end
        if $fefieldeffect==8
          score*=0.1 unless (attacker.pbHasType?(:POISON) || attacker.pbHasType?(:STEEL))
        end
        if $fefieldeffect==10
          score*=0.1
        end
      else
        score*=0
      end
    when 0xDC # Leech Seed
      if (opponent.effects[PBEffects::LeechSeed]<0 && ! opponent.pbHasType?(:GRASS) && opponent.effects[PBEffects::Substitute]<=0) && !opponent.isBoss
        if (roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL) || roles.include?(PBMonRoles::TANK))
          score*=1.2
        end
        if attacker.effects[PBEffects::Substitute]>0
          score*=1.3
        end
        if opponent.hp==opponent.totalhp
          score*=1.1
        else
          score*=(opponent.hp*(1.0/opponent.totalhp))
        end
        if (attitemworks && attacker.item == PBItems::LEFTOVERS) || (attitemworks && attacker.item == PBItems::BIGROOT) || ((attitemworks && attacker.item == PBItems::BLACKSLUDGE) && attacker.pbHasType?(:POISON))
          score*=1.2
        end
        if attacker.effects[PBEffects::Ingrain] || attacker.effects[PBEffects::AquaRing]
          score*=1.2
        end
        if $fefieldeffect==2 || $fefieldeffect==42
          score*=1.2
        end
        if ((!attacker.abilitynulled && attacker.ability == PBAbilities::RAINDISH) && pbWeather==PBWeather::RAINDANCE)
          score*=1.2
        end
        if opponent.status==PBStatuses::PARALYSIS || opponent.status==PBStatuses::SLEEP
          score*=1.2
        end
        if opponent.effects[PBEffects::Confusion]>0
          score*=1.2
        end
        if opponent.effects[PBEffects::Attract]>=0
          score*=1.2
        end
        if opponent.status==PBStatuses::POISON || opponent.status==PBStatuses::BURN
          score*=1.1
        end
        if initialscores.length>0
          score*=1.3 if hasbadmoves(initialscores,scoreindex,30)
        end
        score*=0.2 if checkAImoves([PBMoves::RAPIDSPIN,PBMoves::UTURN,PBMoves::VOLTSWITCH],aimem)
        if opponent.hp*2<opponent.totalhp
          score*=0.8
          if opponent.hp*4<opponent.totalhp
            score*=0.2
          end
        end
        protectmove=false
        for j in attacker.moves
          protectmove = true if j.id==(PBMoves::PROTECT) || j.id==(PBMoves::DETECT) || j.id==(PBMoves::BANEFULBUNKER) || j.id==(PBMoves::SPIKYSHIELD)
        end
        if protectmove
          score*=1.2
        end
        ministat= (5)* statchangecounter(opponent,1,7,1)
        ministat+=100
        ministat/=100.0
        score*=ministat
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::LIQUIDOOZE) || opponent.effects[PBEffects::Substitute]>0
          score*=0
        end
      else
        score*=0
      end
    when 0xDD # Drain Punch
      minimini = score*0.01
      miniscore = (opponent.hp*minimini)/2.0
      if miniscore > (attacker.totalhp-attacker.hp)
        miniscore = (attacker.totalhp-attacker.hp)
      end
      if attacker.totalhp>0
        miniscore/=(attacker.totalhp).to_f
      end
      if attacker.hasWorkingItem(:BIGROOT)
        miniscore*=1.3
      end
      miniscore+=1
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::LIQUIDOOZE)
        miniscore = (2-miniscore)
      end
      if (attacker.hp!=attacker.totalhp || ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0))) && opponent.effects[PBEffects::Substitute]==0
        score*=miniscore
        if hasgreatmoves(initialscores,scoreindex,skill,true)
          score*=1.1
        end
      end
      ghostvar=false
      for mon in pbParty(attacker.index)
        next if mon.nil?
        if mon.hasType?(:GHOST)
          ghostvar=true
        end
      end
      if move.id==getID(PBMoves,:PARABOLICCHARGE)
        if $fefieldeffect==18
          score*=1.1
          if ghostvar
            score*=0.8
          end
        end
      end
    when 0xDE # Dream Eater
      if opponent.status==PBStatuses::SLEEP || (attacker.hasWorkingAbility(:WORLDOFNIGHTMARES))
        minimini = score*0.01
        miniscore = (opponent.hp*minimini)/2.0
        if miniscore > (attacker.totalhp-attacker.hp)
          miniscore = (attacker.totalhp-attacker.hp)
        end
        if attacker.totalhp>0
          miniscore/=(attacker.totalhp).to_f
        end
        if attacker.hasWorkingItem(:BIGROOT)
          miniscore*=1.3
        end
        miniscore+=1
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::LIQUIDOOZE)
          miniscore = (2-miniscore)
        end
        if (attacker.hp!=attacker.totalhp || ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0))) && opponent.effects[PBEffects::Substitute]==0
          score*=miniscore
        end
      else
        score*=0
      end
    when 0xDF # Heal Pulse
      if !@doublebattle || attacker.pbIsOpposing?(opponent.index)
        score*=0
      else
        if !attacker.pbIsOpposing?(opponent.index)
          if opponent.hp*(1.0/opponent.totalhp)<0.7 && opponent.hp*(1.0/opponent.totalhp)>0.3
            score*=1.5
          end
          if opponent.status==PBStatuses::POISON || opponent.status==PBStatuses::BURN || opponent.effects[PBEffects::LeechSeed]>=0 || opponent.effects[PBEffects::Curse]
            score*=0.8
            if opponent.effects[PBEffects::Toxic]>0
              score*=0.7
            end
          end
          if opponent.hp*(1.0/opponent.totalhp)>0.8
            if ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) && ((attacker.pbSpeed<pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0))
              score*=0.5
            else
              score*=0
            end
          end
        else
          score*=0
        end
      end
    when 0xE0 # Explosion
      maxdam=checkAIdamage(aimem,attacker,opponent,skill)
      if (attacker.hp==attacker.totalhp && opponent.pbNonActivePokemonCount>0) && maxdam*2<attacker.hp
        score*=0.2
      else
        if opponent.pbNonActivePokemonCount>0
          miniscore = attacker.hp*(1.0/attacker.totalhp)
          miniscore*=0.5
          miniscore = 1-miniscore
          score*=miniscore
        end
        if attacker.hp*4<attacker.totalhp
          score*=1.3
          if (attitemworks && attacker.item == PBItems::CUSTAPBERRY)
            score*=1.4
          end
        end
      end
      if roles.include?(PBMonRoles::LEAD)
        score*=1.2
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::DISGUISE) || (!opponent.abilitynulled && opponent.ability == PBAbilities::ICEFACE) || opponent.effects[PBEffects::Substitute]>0 
        score*=0.3
      end
      if opponent.moves.any? {|moveloop| (PBStuff::PROTECTMOVE).include?(moveloop.id)} || opponent.moves.any? {|moveloop| (PBStuff::TWOTURNAIRMOVE).include?(moveloop.id)} || opponent.pbHasMove?((PBMoves::SUBSTITUTE))
        score*=0.3
      end
      #score*=0.3 if checkAImoves(PBStuff::PROTECTMOVE,aimem)
      firevar=false
      poisonvar=false
      ghostvar=false
      for mon in pbParty(attacker.index)
        next if mon.nil?
        if mon.hasType?(:FIRE)
          firevar=true
        end
        if mon.hasType?(:POISON)
          poisonvar=true
        end
        if mon.hasType?(:GHOST)
          ghostvar=true
        end
      end
      if $fefieldeffect==11
        if !poisonvar
          score*=1.5
        else
          score*=0.5
        end
      elsif $fefieldeffect==24
        score*=1.5
      elsif $fefieldeffect==17
        score*=1.1
        if ghostvar
          score*=1.3
        end
      end
      if ghostvar && move.type==PBTypes::NORMAL
        if !($fefieldeffect==36) || attacker.ability==PBAbilities::SCRAPPY
          score*=0.5
        end
      end
      if $fefieldeffect==3 || $fefieldeffect==8 || pbCheckGlobalAbility(:DAMP) || (!opponent.abilitynulled && opponent.ability == PBAbilities::DISGUISE)
        score*=0
      end
    when 0xE1 # Final Gambit
      score*=0.7
      if attacker.hp > opponent.hp
        score*=1.1
      else
        score*=0.5
      end
      if (attacker.pbSpeed>pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        score*=1.1
      else
        score*=0.5
      end
      if opponent.hasWorkingItem(:FOCUSSASH) || (!opponent.abilitynulled && opponent.ability == PBAbilities::STURDY) || (isConst?(opponent.species,PBSpecies,:RAMPARDOS) && isConst?(opponent.item,PBItems,:RAMPCREST))
        score*=0.2
      end
    when 0xE2 # Memento
      if initialscores.length>0
        score = 15 if hasbadmoves(initialscores,scoreindex,10)
      end
      if attacker.hp==attacker.totalhp
        score*=0.2
      else
        miniscore = attacker.hp*(1.0/attacker.totalhp)
        miniscore = 1-miniscore
        score*=miniscore
        if attacker.hp*4<attacker.totalhp
          score*=1.3
        end
      end
      if opponent.attack > opponent.spatk
        if opponent.stages[PBStats::ATTACK]<-1
          score*=0.1
        end
      else
        if opponent.stages[PBStats::SPATK]<-1
          score*=0.1
        end
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::CLEARBODY) || (!opponent.abilitynulled && opponent.ability == PBAbilities::WHITESMOKE) || (!opponent.abilitynulled && opponent.ability == PBAbilities::MIRRORARMOR)
        score*=0
      end
    when 0xE3 # Healing Wish
      count=0
      for mon in pbParty(attacker.index)
        next if mon.nil?
        count+=1 if mon.hp!=mon.totalhp
      end
      count-=1 if attacker.hp!=attacker.totalhp
      if count==0
        score*=0
      else
        maxscore = 0
        for mon in pbParty(attacker.index)
          next if mon.nil?
          if mon.hp!=mon.totalhp
            miniscore = 1 - mon.hp*(1.0/mon.totalhp)
            miniscore*=2 if mon.status!=0
            maxscore=miniscore if miniscore>maxscore
          end
        end
        score*=maxscore
      end
      if attacker.hp==attacker.totalhp
        score*=0.2
      else
        miniscore = attacker.hp*(1.0/attacker.totalhp)
        miniscore = 1-miniscore
        score*=miniscore
        if attacker.hp*4<attacker.totalhp
          score*=1.3
          if attacker.hasWorkingItem(:CUSTAPBERRY)
            score*=1.4
          end
        end
      end
      if (attacker.pbSpeed>pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        score*=1.1
      else
        score*0.5
      end
      if $fefieldeffect==31 || $fefieldeffect==34
        score*=1.4
      end
    when 0xE4 # Lunar Dance
      count=0
      for mon in pbParty(attacker.index)
        next if mon.nil?
        count+=1 if mon.hp!=mon.totalhp
      end
      count-=1 if attacker.hp!=attacker.totalhp
      if count==0
        score*=0
      else
        maxscore = 0
        score*=1.2
        for mon in pbParty(attacker.index)
          next if mon.nil?
          if mon.hp!=mon.totalhp
            miniscore = 1 - mon.hp*(1.0/mon.totalhp)
            miniscore*=2 if mon.status!=0
            maxscore=miniscore if miniscore>maxscore
          end
        end
        score*=maxscore
      end
      if attacker.hp==attacker.totalhp
        score*=0.2
      else
        miniscore = attacker.hp*(1.0/attacker.totalhp)
        miniscore = 1-miniscore
        score*=miniscore
        if attacker.hp*4<attacker.totalhp
          score*=1.3
          if attacker.hasWorkingItem(:CUSTAPBERRY)
            score*=1.4
          end
        end
      end
      if (attacker.pbSpeed>pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        score*=1.1
      else
        score*0.5
      end
      if $fefieldeffect==31 || $fefieldeffect==34
        score*=1.4
      elsif $fefieldeffect==35
        score*=2
      end
    when 0xE5 # Perish Song
      livecount1=0
      for i in pbParty(opponent.index)
        next if i.nil?
        livecount1+=1 if i.hp!=0
      end
      livecount2=0
      for i in pbParty(attacker.index)
        next if i.nil?
        livecount2+=1 if i.hp!=0
      end
      if livecount1==1 || (livecount1==2 && @doublebattle)
        score*=4
      else
        if attacker.pbHasMove?((PBMoves::UTURN)) || attacker.pbHasMove?((PBMoves::VOLTSWITCH))
          score*=1.5
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::SHADOWTAG) || (@doublebattle && !attacker.pbPartner.abilitynulled && attacker.pbPartner.ability == PBAbilities::SHADOWTAG) || opponent.effects[PBEffects::MeanLook]>0 ||
          (!attacker.abilitynulled && attacker.ability == PBAbilities::ARENATRAP) || (@doublebattle && !attacker.pbPartner.abilitynulled && attacker.pbPartner.ability == PBAbilities::ARENATRAP)
          score*=3
        end
        if attacker.pbHasMove?((PBMoves::PROTECT))
          score*=1.2
        end
        if @doublebattle
          if !(attacker.pbPartner.nil?)
            if (attacker.pbPartner.pbHasMove?(PBMoves::PERISHSONG) && (!attacker.pbPartner.abilitynulled && attacker.pbPartner.ability == PBAbilities::PRANKSTER))
             score*=0.7
            end
          end
        end
        count = -1
        sweepvar = false
        for i in pbParty(attacker.index)
          count+=1
          next if i.nil?
          temprole = pbGetMonRole(i,opponent,skill,count,pbParty(attacker.index))
          if temprole.include?(PBMonRoles::SWEEPER)
            sweepvar = true
          end
        end
        score*=1.2 if sweepvar
        for j in attacker.moves
          if j.isHealingMove?
            score*=1.2
            break
          end
        end
        miniscore=(-5)*statchangecounter(attacker,1,7)
        miniscore+=100
        miniscore/=100.0
        score*=miniscore
        miniscore= 5*statchangecounter(opponent,1,7)
        miniscore+=100
        miniscore/=100.0
        score*=miniscore
        score*=0.5 if checkAImoves(PBStuff::PIVOTMOVE,aimem)
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::SHADOWTAG) || attacker.effects[PBEffects::MeanLook]>0
          score*=0.1
        end
        count = -1
        pivotvar = false
        for i in pbParty(attacker.index)
          count+=1
          next if i.nil?
          temprole = pbGetMonRole(i,opponent,skill,count,pbParty(attacker.index))
          if temprole.include?(PBMonRoles::PIVOT)
            pivotvar = true
          end
        end
        score*=1.5 if pivotvar
        if initialscores.length>0
          greatmoves=false
          badmoves=true
          iffymoves=true
          for i in 0...initialscores.length
            next if i==scoreindex
            if initialscores[i]>=110
              greatmoves=true
            end
            if initialscores[i]>=25
              badmoves=false
            end
          end
        end
        if livecount2==1 || (livecount2==2 && @doublebattle)
          if (badmoves==false)
            score*=0
          end
        end
      end
      score*=0 if opponent.effects[PBEffects::PerishSong]>0
    when 0xE6 # Grudge
      movenum = 0
      damcount =0
      if aimem.length > 0
        for j in aimem
          movenum+=1
          if j.basedamage>0
            damcount+=1
          end
        end
      end
      if movenum==4 && damcount==1
        score*=3
      end
      if attacker.hp==attacker.totalhp
        score*=0.2
      else
        miniscore = attacker.hp*(1.0/attacker.totalhp)
        miniscore = 1-miniscore
        score*=miniscore
        if attacker.hp*4<attacker.totalhp
          score*=1.3
          if (attitemworks && attacker.item == PBItems::CUSTAPBERRY)
            score*=1.3
          end
        end
      end
      if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        score*=1.3
      else
        score*=0.5
      end
    when 0xE7 # Destiny Bond
      movenum = 0
      damcount =0
      for j in opponent.moves
          movenum+=1
          if j.basedamage>0
            damcount+=1
          end
      end
      abusevar=false
      icansurvive=false
      if (attacker.item == PBItems::RAMPCREST && attacker.species==PBSpecies::RAMPARDOS && !attacker.effects[PBEffects::RampCrestUsage]) ||  ((((attacker.item == PBItems::FOCUSSASH || attacker.ability == PBAbilities::STURDY) && attacker.hp==attacker.totalhp)) && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
        icansurvive=true
      else
        icansurvive=false
      end
      if opponent.pbHasMove?(getID(PBMoves,:SUBSTITUTE)) || opponent.moves.any? {|moveloop| (PBStuff::SLEEPMOVE).include?(moveloop.id)} || opponent.moves.any? {|moveloop| (PBStuff::BURNMOVE).include?(moveloop.id)}
        abusevar=true
      end
      maxdam=checkAIdamage(aimem,attacker,opponent,skill)
      maxdam2=checkAIdamage(aimem,opponent,attacker,skill)
      if movenum==4 && damcount==4
        if maxdam>attacker.hp
          score*=3
        end
      elsif movenum==4 && damcount==3
        score*=1.1
        if abusevar==false && ((attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0))
          if (maxdam>attacker.hp && !icansurvive && maxdam2<opponent.hp)
            score*=1.5
          end
        end
      end
      if initialscores.length>0
        score*=0.1 if hasgreatmoves(initialscores,scoreindex,skill)
      end
      if (attacker.hp==attacker.totalhp) && !(maxdam>attacker.hp)
        score*=0.2
      else
        miniscore=(maxdam.to_f/attacker.hp.to_f)
        if miniscore>1
          score*=1.5
        end
        if attacker.hp*4<attacker.totalhp
          score*=1.3
          if (attitemworks && attacker.item == PBItems::CUSTAPBERRY)
            score*=1.5
          end
        end
      end
      if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        score*=1.5
      else
        score*=0.5
      end
      if attacker.lastMoveUsed == 186
        score=0
      end
    when 0xE8 # Endure
      if attacker.hp>1
        if attacker.hp==attacker.totalhp && ((attitemworks && attacker.item == PBItems::FOCUSSASH) || (!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY))
          score*=0
        end
        if attacker.lastMoveUsed == 361
          score*=0
        end
        maxdam=checkAIdamage(aimem,attacker,opponent,skill,true,false)
        if maxdam>attacker.hp
          score*=2
        end
        if (pbWeather==PBWeather::HAIL && !attacker.pbHasType?(:ICE)) || (pbWeather==PBWeather::SANDSTORM && !(attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
          score*=0
        end
        if $fefieldeffect==7 || $fefieldeffect==26
          score*=0
        end
        if attacker.status==PBStatuses::POISON || attacker.status==PBStatuses::BURN || attacker.effects[PBEffects::LeechSeed]>=0 || attacker.effects[PBEffects::Curse]
          score*=0
        end
        if attacker.pbHasMove?((PBMoves::PAINSPLIT)) || attacker.pbHasMove?((PBMoves::FLAIL)) || attacker.pbHasMove?((PBMoves::REVERSAL)) || attacker.pbHasMove?((PBMoves::ENDEAVOR)) 
          score*=2
        end
        if attitemworks 
            case attacker.item 
            when PBItems::SALACBERRY
              if ((attacker.pbSpeed*1.5)>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
                score*=1.5
              end
            when PBItems::CUSTAPBERRY
              for i in opponent.moves
                if !(i.priority>0) || (i.id==getID(PBMoves,:FAKEOUT) && opponent.turncount>0)
                  score*=1.5
                end
              end
            when PBItems::LIECHIBERRY
              score*=1.2
            when PBItems::PETAYABERRY 
              score*=1.2
            end
        end
        if opponent.status==PBStatuses::POISON || opponent.status==PBStatuses::BURN || opponent.effects[PBEffects::LeechSeed]>=0 || opponent.effects[PBEffects::Curse]
          score*=1.5
        end
        if opponent.effects[PBEffects::TwoTurnAttack]!=0
          if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
            score*=15
          end
        end
      else
        score*=0
      end
    when 0xE9 # False Swipe
      if score>=100
        score*=0.1
      end
    when 0xEA # Teleport
      score*=0
    when 0xEB # Roar
      if opponent.pbOwnSide.effects[PBEffects::StealthRock]
        score*=1.3
      end
      if opponent.pbOwnSide.effects[PBEffects::Spikes]>0
        score*=(1.2**opponent.pbOwnSide.effects[PBEffects::Spikes])
      end
      if opponent.pbOwnSide.effects[PBEffects::ToxicSpikes]>0
        score*=1.1
      end
      ministat = 15*statchangecounter(opponent,1,7)
      ministat+=100
      ministat/=100.0
      score*=ministat
      if opponent.effects[PBEffects::PerishSong]>0 || opponent.effects[PBEffects::Yawn]>0
        score*=0
      end
      if opponent.status==PBStatuses::SLEEP
        score*=1.3
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::SLOWSTART)
        score*=1.3
      end
      if opponent.item ==0 && (!opponent.abilitynulled && opponent.ability == PBAbilities::UNBURDEN)
        score*=1.5
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::INTIMIDATE)
        score*=0.7
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::REGENERATOR) || (!opponent.abilitynulled && opponent.ability == PBAbilities::NATURALCURE) || SilvallyCheck(opponent,PBTypes::POISON)
        score*=0.5
      end
      if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        score*=0.8
      end
      if attacker.effects[PBEffects::Substitute]>0
        score*=1.4
      end
      if opponent.effects[PBEffects::KingsShield]== true ||
        opponent.effects[PBEffects::BanefulBunker]== true ||
        opponent.effects[PBEffects::SpikyShield]== true || opponent.effects[PBEffects::Substitute]>0
        score *=3
        if opponent.moves.any? {|moveloop| (PBStuff::SETUPMOVE).include?(moveloop.id)}
          score*=2
        end
      end
      firevar=false
      poisonvar=false
      fairytvar=false
      for mon in pbParty(attacker.index)
        next if mon.nil?
        if mon.hasType?(:FIRE)
          firevar=true
        end
        if mon.hasType?(:POISON)
          poisonvar=true
        end
        if mon.hasType?(:FAIRY)
          fairyvar=true
        end
      end
      if $fefieldeffect==3
        score*=1.3
        if !fairyvar
          score*=1.3
        else
          score*=0.8
        end
      elsif $fefielfeffect==7
        if !firevar
          score*=1.8
        else
          score*=0.5
        end
      elsif $fefieldeffect==11
        if !poisonvar
          score*=3
        else
          score*=0.8
        end
      end
      if opponent.effects[PBEffects::Ingrain] || (!opponent.abilitynulled && opponent.ability == PBAbilities::SUCTIONCUPS) || opponent.pbNonActivePokemonCount==0
        score*=0
      end
    when 0xEC # Dragon Tail
      if opponent.effects[PBEffects::Substitute]<=0
        miniscore=1
        if opponent.pbOwnSide.effects[PBEffects::StealthRock]
          miniscore*=1.3
        else
          miniscore*=0.8
        end
        if opponent.pbOwnSide.effects[PBEffects::Spikes]>0
          miniscore*=(1.2**opponent.pbOwnSide.effects[PBEffects::Spikes])
        else
          miniscore*=0.8
        end
        if opponent.pbOwnSide.effects[PBEffects::ToxicSpikes]>0
          miniscore*=1.1
        end
        ministat = 10*statchangecounter(opponent,1,7)
        ministat+=100
        ministat/=100.0
        miniscore*=ministat
        if opponent.status==PBStatuses::SLEEP
          miniscore*=1.3
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::SLOWSTART)
          miniscore*=1.3
        end
        if opponent.item ==0 && (!opponent.abilitynulled && opponent.ability == PBAbilities::UNBURDEN)
          miniscore*=1.5
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::INTIMIDATE)
          miniscore*=0.7
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::REGENERATOR) || (!opponent.abilitynulled && opponent.ability == PBAbilities::NATURALCURE) || SilvallyCheck(opponent,PBTypes::POISON)
          miniscore*=0.5
        end
        if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
          miniscore*=0.8
        end
        if opponent.effects[PBEffects::PerishSong]>0 || opponent.effects[PBEffects::Yawn]>0
          miniscore=1
        end
        if attacker.effects[PBEffects::Substitute]>0
          miniscore=1
        end
        if opponent.effects[PBEffects::Ingrain] || (!opponent.abilitynulled && opponent.ability == PBAbilities::SUCTIONCUPS) || opponent.pbNonActivePokemonCount==0
          miniscore=1
        end
        score*=miniscore
      end
    when 0xED # Baton Pass
      if pbCanChooseNonActive?(attacker.index)
        party=pbParty(attacker.index)
        attacker.passing=true
        ministat = 10*statchangecounter(attacker,1,7)
        ministat+=100
        ministat/=100.0
        score*=ministat
        if attacker.effects[PBEffects::Substitute]>0
          score*=1.3
        end
        if attacker.effects[PBEffects::Confusion]>0
          score*=0.5
        end
        if attacker.effects[PBEffects::LeechSeed]>=0
          score*=0.5
        end
        if attacker.effects[PBEffects::Curse]
          score*=0.5
        end
        if attacker.effects[PBEffects::Yawn]>0
          score*=0.5
        end
        if attacker.turncount<1
          score*=0.5
        end
        damvar = false
        for i in attacker.moves
          if i.basedamage>0
            damvar=true
          end
        end
        if !@doublebattle
          switchin=pbSwitchTo(attacker,party,skill,true)
          currentmonscore=switchin[attacker.pokemonIndex]
          count=-1
          bestcount=-1
          highscore=-1000000000000
          for monscore in switchin
            count+1
            next if monscore==switchin[attacker.pokemonIndex]
            next if party[count].nil?
            if (monscore>highscore) #&& (monscore!=currentmonscore)
              highscore=monscore
              bestcount=count
            elsif monscore==highscore
              if party[count].hp>party[bestcount].hp
                bestcount=count
              end
            end
          end
          pivotdam=0
          if currentmonscore>highscore && !(attacker.item == PBItems::EEVIUMZ2)
            tempdam = pbRoughDamage(move,attacker,opponent,skill,move.basedamage)
            pivotdam=tempdam if pivotdam<tempdam
            if !(pivotdam>opponent.hp)
              score*=0.4
            end
          end
        end
        attacker.passing=false
        if !damvar || roles.include?(PBMonRoles::BATONPASSER)
          score*=1.5
        end
        if attacker.effects[PBEffects::Ingrain] || attacker.effects[PBEffects::AquaRing]
          score*=1.2
        end
        if attacker.effects[PBEffects::PerishSong]>0
          score*=0
        else
          if initialscores.length>0
            if damvar && !attacker.pbHasMove?((PBMoves::LASTRESORT))
              if initialscores.max>60
                score*=0.7
                if initialscores.max>100
                  score*=0.3
                end
              end
            end
          end
        end
      else
        score*=0
      end
    when 0xEE # U-Turn
      livecount=0
      party=pbParty(attacker.index)
      for i in pbParty(attacker.index)
        next if i.nil?
        livecount+=1 if i.hp!=0
      end
      if (livecount>1) || (@doublebattle && livecount>2)
        if initialscores.length>0
          greatmoves=false
          badmoves=true
          iffymoves=true
          for i in 0...initialscores.length
            next if i==scoreindex
            if initialscores[i]>=110
              greatmoves=true
            end
            if initialscores[i]>=25
              badmoves=false
            end
            if initialscores[i]>=50
              iffymoves=false
            end
          end
          score*=0.5 if greatmoves
          if badmoves == true
            score+=40
          elsif iffymoves == true
            score+=20
          end
        end
        if attacker.pbOwnSide.effects[PBEffects::StealthRock] || attacker.pbOwnSide.effects[PBEffects::Spikes]>0
          hazpercent = 0
          hazpercent = totalHazardDamage(attacker.pbOwnSide,attacker.type1,attacker.type2,attacker.isAirborne?,skill,attacker)
          if hazpercent>((attacker.hp.to_f/attacker.totalhp)*100)
            score*=0.5
          else
            score*=0.7
          end
        end
        if attacker.pbOwnSide.effects[PBEffects::StickyWeb]
          score*=0.6
        end
        if attacker.pbOwnSide.effects[PBEffects::ToxicSpikes]>0
          score*=0.9**attacker.pbOwnSide.effects[PBEffects::ToxicSpikes]
        end
        count = -1
        sweepvar = false
        for i in pbParty(attacker.index)
          count+=1
          next if i.nil?
          temprole = pbGetMonRole(i,opponent,skill,count,pbParty(attacker.index))
          if temprole.include?(PBMonRoles::SWEEPER)
            sweepvar = true
          end
        end
        if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
          score*=1
        else
          if sweepvar
            score*=1.2
          end
        end
        if roles.include?(PBMonRoles::LEAD) || roles.include?(PBMonRoles::PIVOT)
          score*=1.2
        end
        if ((!attacker.abilitynulled && attacker.ability == PBAbilities::REGENERATOR) || SilvallyCheck(attacker,PBTypes::POISON)) && ((attacker.hp.to_f)/attacker.totalhp)<0.75
          score*=1.2
          if ((!attacker.abilitynulled && attacker.ability == PBAbilities::REGENERATOR) || SilvallyCheck(attacker,PBTypes::POISON)) && ((attacker.hp.to_f)/attacker.totalhp)<0.5
            score*=1.2
          end
        end
        switchin=pbSwitchTo(attacker,party,skill,true)
        currentmonscore=switchin[attacker.pokemonIndex]
        count=-1
        bestcount=-1
        highscore=-1000000000000
        for monscore in switchin
          count+=1
          next if monscore==switchin[attacker.pokemonIndex]
          next if party[count].nil?
          if (monscore>highscore) #&& (monscore!=currentmonscore)
            highscore=monscore
            bestcount=count
          elsif monscore==highscore
            if party[count].hp>party[bestcount].hp
              bestcount=count
            end
          end
        end
        pivotdam=0
        if currentmonscore>highscore
          tempdam = pbRoughDamage(move,attacker,opponent,skill,move.basedamage)
          pivotdam=tempdam if pivotdam<tempdam
          if !(pivotdam>opponent.hp)
            score*=0.2
          end
        else
          newmoncount=-1
          for newmon in party
            currentopponent=attacker.pbOppositeOpposing
            newmoncount+=1
            next if newmoncount!=bestcount
            newenemy = pbMakeFakeBattler(newmon,false,attacker) # turn opponent into a battler object 
            maxdam=checkAIdamage(aimem,newenemy,currentopponent,skill)
            if maxdam>newenemy.hp 
              score*=0.2
            elsif (maxdam*2>newenemy.hp)
              if (newenemy.pbSpeed<pbRoughStat(currentopponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
                score*=0.2
              elsif (newenemy.pbSpeed>=pbRoughStat(currentopponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
                score*=0.6
              end
            end
          end
        end
        loweredstats=0
        loweredstats+=attacker.stages[PBStats::ATTACK] if attacker.stages[PBStats::ATTACK]<0
        loweredstats+=attacker.stages[PBStats::DEFENSE] if attacker.stages[PBStats::DEFENSE]<0
        loweredstats+=attacker.stages[PBStats::SPEED] if attacker.stages[PBStats::SPEED]<0
        loweredstats+=attacker.stages[PBStats::SPATK] if attacker.stages[PBStats::SPATK]<0
        loweredstats+=attacker.stages[PBStats::SPDEF] if attacker.stages[PBStats::SPDEF]<0
        loweredstats+=attacker.stages[PBStats::EVASION] if attacker.stages[PBStats::EVASION]<0
        miniscore= (-15)*loweredstats
        miniscore+=100
        miniscore/=100.0
        score*=miniscore
        raisedstats=0
        if !(attacker.ability==PBAbilities::DOWNLOAD && !attacker.abilitynulled)
          raisedstats+=attacker.stages[PBStats::ATTACK] if attacker.stages[PBStats::ATTACK]>0
          raisedstats+=attacker.stages[PBStats::DEFENSE] if attacker.stages[PBStats::DEFENSE]>0
          raisedstats+=attacker.stages[PBStats::SPEED] if attacker.stages[PBStats::SPEED]>0
          raisedstats+=attacker.stages[PBStats::SPATK] if attacker.stages[PBStats::SPATK]>0
          raisedstats+=attacker.stages[PBStats::SPDEF] if attacker.stages[PBStats::SPDEF]>0
          raisedstats+=attacker.stages[PBStats::EVASION] if attacker.stages[PBStats::EVASION]>0
          miniscore= (-25)*raisedstats
          miniscore+=100
          miniscore/=100.0
          score*=miniscore
        end
        if attacker.effects[PBEffects::Toxic]>0 || attacker.effects[PBEffects::Attract]>-1 || attacker.effects[PBEffects::Confusion]>0
          score*=1.3
        end
        if attacker.effects[PBEffects::LeechSeed]>-1
          score*=1.5
        end
        if (opponent.level-5)>attacker.level
          score*=0.6
          if (opponent.level-10)>attacker.level
            score*=0.2
          end
        end
      end
    when 0xEF # Mean Look
      if !(opponent.effects[PBEffects::MeanLook]>=0 || opponent.effects[PBEffects::Ingrain] || opponent.pbHasType?(:GHOST)) && opponent.effects[PBEffects::Substitute]<=0
        score*=0.1 if checkAImoves(PBStuff::PIVOTMOVE,aimem)
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::RUNAWAY)
          score*=0.1
        end
        if attacker.pbHasMove?((PBMoves::PERISHSONG)) || (!attacker.abilitynulled && attacker.ability == PBAbilities::PERISHBODY)
          score*=1.5
        end
        if opponent.effects[PBEffects::PerishSong]>0
          score*=4
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::ARENATRAP) || (!attacker.abilitynulled && attacker.ability == PBAbilities::SHADOWTAG)
          score*=0
        end
        if opponent.effects[PBEffects::Attract]>=0
          score*=1.3
        end
        if opponent.effects[PBEffects::LeechSeed]>=0
          score*=1.3
        end
        if opponent.effects[PBEffects::Curse]
          score*=1.5
        end
        score*=0.7 if attacker.moves.any? {|moveloop| (PBStuff::SWITCHOUTMOVE).include?(moveloop.id)}
        ministat = (-5)*statchangecounter(opponent,1,7)
        ministat+=100
        ministat/=100.0
        score*=ministat
        if opponent.effects[PBEffects::Confusion]>0
          score*=1.1
        end
      else
        score*=0
      end
    when 0xF0 # Knock Off
      if !hasgreatmoves(initialscores,scoreindex,skill) && opponent.effects[PBEffects::Substitute]<=0
        if (!(!opponent.abilitynulled && opponent.ability == PBAbilities::STICKYHOLD) || opponent.moldbroken) && opponent.item!=0 && !pbIsUnlosableItem(opponent,opponent.item)
          if score<20 && (roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL) || roles.include?(PBMonRoles::TANK) || roles.include?(PBMonRoles::LEAD))
            score=20
          end
          if oppitemworks
            miniscore=100
            case opponent.item
            when (PBItems::CHOICESCARF),(PBStuff::TYPEBERRIES).include?(opponent.item)
              miniscore*=1.5
            when (PBItems::LEFTOVERS),(PBItems::LIFEORB),(PBItems::LUMBERRY),(PBItems::SITRUSBERRY),(PBItems::CHOICESPECS),(PBItems::CHOICEBAND),(PBItems::CUSTAPBERRY)
              miniscore*=1.5
            when (PBItems::ASSAULTVEST), (PBItems::ROCKYHELMET), (PBItems::MAGICALSEED), (PBItems::SYNTHETICSEED), (PBItems::TELLURICSEED), (PBItems::ELEMENTALSEED)
              miniscore*=1.4
            when (PBItems::FOCUSSASH), (PBItems::MUSCLEBAND), (PBItems::WISEGLASSES), (PBItems::EXPERTBELT), (PBItems::WIDELENS)
              miniscore*=1.3
            else 
              miniscore*=1.2
            end
            if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL) || roles.include?(PBMonRoles::TANK) || roles.include?(PBMonRoles::LEAD)
              miniscore*=1.1
            end
            miniscore/=100.0
            score*=miniscore
          end
        end
      end
    when 0xF1 # Covet
      if (!(!opponent.abilitynulled && opponent.ability == PBAbilities::STICKYHOLD) || opponent.moldbroken) && opponent.item!=0 && !pbIsUnlosableItem(opponent,opponent.item) && attacker.item ==0 && opponent.effects[PBEffects::Substitute]<=0
        miniscore = 1.2
        case opponent.item
        when (PBItems::LEFTOVERS),(PBItems::LIFEORB), (PBItems::LUMBERRY), (PBItems::SITRUSBERRY)
          miniscore*=1.5
        when (PBItems::ASSAULTVEST), (PBItems::ROCKYHELMET), (PBItems::MAGICALSEED), (PBItems::SYNTHETICSEED), (PBItems::TELLURICSEED), (PBItems::ELEMENTALSEED)
          miniscore*=1.3
        when (PBItems::FOCUSSASH), (PBItems::MUSCLEBAND), (PBItems::WISEGLASSES), (PBItems::EXPERTBELT), (PBItems::WIDELENS)
          miniscore*=1.2
        when (PBItems::CHOICESCARF)
          if attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill) && @trickroom==0
            miniscore*=1.1
          end
        when (PBItems::CHOICEBAND)
          if attacker.attack>attacker.spatk
            miniscore*=1.1
          end
        when (PBItems::CHOICESPECS)
          if attacker.spatk>attacker.attack
            miniscore*=1.1
          end
        when (PBItems::BLACKSLUDGE)
          if attacker.pbHasType?(:POISON)
            miniscore*=1.5
          else
            miniscore*=0.5
          end
        when (PBItems::TOXICORB), (PBItems::FLAMEORB), (PBItems::LAGGINGTAIL), (PBItems::IRONBALL), (PBItems::STICKYBARB)
          miniscore*=0.5
        end
        score*=miniscore
      end
    when 0xF2 # Trick
      statvar = false
      for m in opponent.moves
        if m.basedamage==0
          statvar=true
        end
      end
      if (!(!opponent.abilitynulled && opponent.ability == PBAbilities::STICKYHOLD) || opponent.moldbroken) && opponent.effects[PBEffects::Substitute]<=0
        miniscore = 1
        minimini = 1
        if opponent.item!=0 && !pbIsUnlosableItem(opponent,opponent.item)
          miniscore*=1.2
          case opponent.item
          when (PBItems::LEFTOVERS), (PBItems::LIFEORB), (PBItems::LUMBERRY), (PBItems::SITRUSBERRY)
            miniscore*=1.5
          when (PBItems::ASSAULTVEST), (PBItems::ROCKYHELMET), (PBItems::MAGICALSEED), (PBItems::SYNTHETICSEED), (PBItems::TELLURICSEED), (PBItems::ELEMENTALSEED)
            miniscore*=1.3
          when (PBItems::FOCUSSASH), (PBItems::MUSCLEBAND), (PBItems::WISEGLASSES), (PBItems::EXPERTBELT), (PBItems::WIDELENS)
            miniscore*=1.2
          when (PBItems::CHOICESCARF)
            if ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0))
              miniscore*=1.1
            end
          when (PBItems::CHOICEBAND)
            if attacker.attack>attacker.spatk
              miniscore*=1.1
            end
          when (PBItems::CHOICESPECS)
            if attacker.spatk>attacker.attack
              miniscore*=1.1
            end
          when (PBItems::BLACKSLUDGE)
            if attacker.pbHasType?(:POISON)
              miniscore*=1.5
            else
              miniscore*=0.5
            end
          when (PBItems::TOXICORB), (PBItems::FLAMEORB), (PBItems::LAGGINGTAIL), (PBItems::IRONBALL), (PBItems::STICKYBARB)
            miniscore*=0.5
          end
        end
        if attacker.item!=0 && !pbIsUnlosableItem(attacker,attacker.item)
          minimini*=0.8
          case attacker.item
          when (PBItems::LEFTOVERS), (PBItems::LIFEORB), (PBItems::LUMBERRY), (PBItems::SITRUSBERRY)
            minimini*=0.5
          when (PBItems::ASSAULTVEST), (PBItems::ROCKYHELMET), (PBItems::MAGICALSEED), (PBItems::SYNTHETICSEED), (PBItems::TELLURICSEED), (PBItems::ELEMENTALSEED)
            minimini*=0.7
          when (PBItems::FOCUSSASH), (PBItems::MUSCLEBAND), (PBItems::WISEGLASSES), (PBItems::EXPERTBELT), (PBItems::WIDELENS)
            minimini*=0.8
          when (PBItems::CHOICESCARF)
            if ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0))
              minimini*=1.5
            else
              minimini*=0.9
            end
            if statvar
              minimini*=1.3
            end
          when (PBItems::CHOICEBAND)
            if opponent.attack<opponent.spatk
              minimini*=1.7
            end
            if attacker.attack>attacker.spatk
              minimini*=0.8
            end
            if statvar
              minimini*=1.3
            end
          when (PBItems::CHOICESPECS)
            if opponent.attack>opponent.spatk
              minimini*=1.7
            end
            if attacker.attack<attacker.spatk
              minimini*=0.8
            end
            if statvar
              minimini*=1.3
            end
          when (PBItems::BLACKSLUDGE)
            if !attacker.pbHasType?(:POISON)
              minimini*=1.5
            else
              minimini*=0.5
            end
            if !opponent.pbHasType?(:POISON)
              minimini*=1.3
            end
          when (PBItems::TOXICORB), (PBItems::FLAMEORB), (PBItems::LAGGINGTAIL), (PBItems::IRONBALL), (PBItems::STICKYBARB)
            minimini*=1.5
          end
        end
        score*=(miniscore*minimini)
      else
        score*=0
      end
      if attacker.item ==opponent.item
        score*=0
      end
    when 0xF3 # Bestow
      if (!(!opponent.abilitynulled && opponent.ability == PBAbilities::STICKYHOLD) || opponent.moldbroken) && attacker.item!=0 && opponent.item ==0 && !pbIsUnlosableItem(attacker,attacker.item) && opponent.effects[PBEffects::Substitute]<=0
        case attacker.item
        when (PBItems::CHOICESPECS)
          if opponent.attack>opponent.spatk
            score+=35
          end
        when (PBItems::CHOICESCARF)
          if (opponent.pbSpeed>attacker.pbSpeed) ^ (@trickroom!=0)
            score+=25
          end
        when (PBItems::CHOICEBAND)
          if opponent.attack<opponent.spatk
            score+=35
          end
        when (PBItems::BLACKSLUDGE)
          if !attacker.pbHasType?(:POISON)
            score+=15
          end
          if !opponent.pbHasType?(:POISON)
            score+=15
          end
        when (PBItems::TOXICORB), (PBItems::FLAMEORB)
          score+=35
        when (PBItems::LAGGINGTAIL), (PBItems::IRONBALL)
          score+=20
        when (PBItems::STICKYBARB)
          score+=25
        end
      else
        score*=0
      end
    when 0xF4 # Bug Bite
      if opponent.effects[PBEffects::Substitute]==0 && pbIsBerry?(opponent.item)
        maxdam=checkAIdamage(aimem,attacker,opponent,skill)
        case opponent.item
        when (PBItems::LUMBERRY)
          score*=2 if attacker.status!=0
        when (PBItems::SITRUSBERRY)
          score*=1.6 if attacker.hp*(1.0/attacker.totalhp)<0.66 && !(maxdam>attacker.totalhp)
        when (PBItems::LIECHIBERRY)
          score*=1.5 if attacker.attack>attacker.spatk
        when (PBItems::PETAYABERRY)
          score*=1.5 if attacker.spatk>attacker.attack
        when (PBItems::CUSTAPBERRY), (PBItems::SALACBERRY)
          score*=1.1
          score*=1.4 if ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0))
        end
      end
    when 0xF5 # Incinerate
      if (pbIsBerry?(opponent.item) || pbIsTypeGem?(opponent.item)) && !(!opponent.abilitynulled && opponent.ability == PBAbilities::STICKYHOLD) && opponent.effects[PBEffects::Substitute]<=0
        if pbIsBerry?(opponent.item) && opponent.item!=(PBItems::OCCABERRY)
          score*=1.2
        end
        if opponent.item ==(PBItems::LUMBERRY) || opponent.item ==(PBItems::SITRUSBERRY) || opponent.item ==(PBItems::PETAYABERRY) || opponent.item ==(PBItems::LIECHIBERRY) || opponent.item ==(PBItems::SALACBERRY) || opponent.item ==(PBItems::CUSTAPBERRY)
          score*=1.3
        end
        if pbIsTypeGem?(opponent.item)
          score*=1.4
        end
        firevar=false
        poisonvar=false
        bugvar=false
        grassvar=false
        icevar=false
        for mon in pbParty(attacker.index)
          next if mon.nil?
          if mon.hasType?(:FIRE)
            firevar=true
          end
          if mon.hasType?(:POISON)
            poisonvar=true
          end
          if mon.hasType?(:BUG)
            bugvar=true
          end
          if mon.hasType?(:GRASS)
            grassvar=true
          end
          if mon.hasType?(:ICE)
            icevar=true
          end
        end
        if $fefieldeffect==2 || $fefieldeffect==15 || ($fefieldeffect==33 && $fecounter>1)
          if firevar && !(bugvar || grassvar)
            score*=2
          end
        elsif $fefieldeffect==16
          if firevar
            score*=2
          end
        elsif $fefieldeffect==13 || $fefieldeffect==28
          if !icevar
            score*=1.5
          end
        end
      end
    when 0xF6 # Recycle
      if attacker.pokemon.itemRecycle!=0
        score*=2
        case attacker.pokemon.itemRecycle
        when (PBItems::LUMBERRY)
          score*=2 if attacker.stats!=0
        when (PBItems::SITRUSBERRY)
          score*=1.6 if attacker.hp*(1.0/attacker.totalhp)<0.66
          if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
            score*=1.5
          end
        end
        if pbIsBerry?(attacker.pokemon.itemRecycle)
          if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNNERVE)
            score*=0
          end
          score*=0 if checkAImoves([PBMoves::INCINERATE,PBMoves::PLUCK,PBMoves::BUGBITE],aimem)
        end
        score*=0 if (!opponent.abilitynulled && opponent.ability == PBAbilities::MAGICIAN) || checkAImoves([PBMoves::KNOCKOFF,PBMoves::THIEF,PBMoves::COVET],aimem)
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::UNBURDEN) || (!attacker.abilitynulled && attacker.ability == PBAbilities::HARVEST) || attacker.pbHasMove?((PBMoves::ACROBATICS))
          score*=0
        end
      else
        score*=0
      end
    when 0xF7 # Fling
      if attacker.item==0 || pbIsUnlosableItem(attacker,attacker.item) || (!attacker.abilitynulled && attacker.ability == PBAbilities::KLUTZ) || (pbIsBerry?(attacker.item) && (!opponent.abilitynulled && opponent.ability == PBAbilities::UNNERVE)) || attacker.effects[PBEffects::Embargo]>0 || @field.effects[PBEffects::MagicRoom]>0
        score*=0
      else
        case attacker.item
        when getID(PBItems,:POISONBARB)
          if opponent.pbCanPoison?(false) && !(!opponent.abilitynulled && opponent.ability == PBAbilities::POISONHEAL) && !(isConst?(opponent.species,PBSpecies,:ZANGOOSE) && isConst?(opponent.item,PBItems,:ZANGCREST))
            score*=1.2
          end
        when getID(PBItems,:TOXICORB)
          if opponent.pbCanPoison?(false) && !(!opponent.abilitynulled && opponent.ability == PBAbilities::POISONHEAL) && !(isConst?(opponent.species,PBSpecies,:ZANGOOSE) && isConst?(opponent.item,PBItems,:ZANGCREST))
            score*=1.2
            if attacker.pbCanPoison?(false) && !(!attacker.abilitynulled && attacker.ability == PBAbilities::POISONHEAL) && !(isConst?(attacker.species,PBSpecies,:ZANGOOSE) && isConst?(attacker.item,PBItems,:ZANGCREST))
              score*=2
            end
          end
        when getID(PBItems,:FLAMEORB)
          if opponent.pbCanBurn?(false) && !(!opponent.abilitynulled && opponent.ability == PBAbilities::GUTS)
            score*=1.3
            if attacker.pbCanBurn?(false) && !(!attacker.abilitynulled && attacker.ability == PBAbilities::GUTS)
              score*=2
            end
          end
        when getID(PBItems,:LIGHTBALL)
          if opponent.pbCanParalyze?(false) && !(!opponent.abilitynulled && opponent.ability == PBAbilities::QUICKFEET)
            score*=1.3
          end
        when getID(PBItems,:KINGSROCK), getID(PBItems,:RAZORCLAW)
          if !(!opponent.abilitynulled && opponent.ability == PBAbilities::INNERFOCUS) && ((attacker.pbSpeed>opponent.pbSpeed) ^ (@trickroom!=0))
            score*=1.3
          end
        when getID(PBItems,:POWERHERB)
          score*=0
        when getID(PBItems,:MENTALHERB)
          score*=0
        when getID(PBItems,:LAXINCENSE), getID(PBItems,:CHOICESCARF), getID(PBItems,:CHOICEBAND), getID(PBItems,:CHOICESPECS), getID(PBItems,:SYNTHETICSEED), getID(PBItems,:TELLURICSEED), getID(PBItems,:ELEMENTALSEED), getID(PBItems,:MAGICALSEED), getID(PBItems,:EXPERTBELT), getID(PBItems,:FOCUSSASH), getID(PBItems,:LEFTOVERS), getID(PBItems,:MUSCLEBAND), getID(PBItems,:WISEGLASSES), getID(PBItems,:LIFEORB), getID(PBItems,:EVIOLITE), getID(PBItems,:ASSAULTVEST), getID(PBItems,:BLACKSLUDGE)
          score*=0
        when getID(PBItems,:STICKYBARB)
          score*=1.2
        when getID(PBItems,:LAGGINGTAIL)
          score*=3
        when getID(PBItems,:IRONBALL)
          score*=1.5
        end
        if pbIsBerry?(attacker.item)
          if attacker.item==getID(PBItems,:FIGYBERRY) || attacker.item==getID(PBItems,:WIKIBERRY) || attacker.item==getID(PBItems,:MAGOBERRY) || attacker.item==getID(PBItems,:AGUAVBERRY) || attacker.item==getID(PBItems,:IAPAPABERRY)
            if opponent.pbCanConfuse?(false)
              score*=1.3
            end
          else
            score*=0
          end
        end
      end
    when 0xF8 # Embargo
      startscore = score
      if opponent.effects[PBEffects::Embargo]>0  && opponent.effects[PBEffects::Substitute]>0
        score*=0
      else
        if opponent.item!=0
          score*=1.1
          if pbIsBerry?(opponent.item)
            score*=1.1
          end
          case opponent.item
          when (PBItems::LAXINCENSE), (PBItems::SYNTHETICSEED), (PBItems::TELLURICSEED), (PBItems::ELEMENTALSEED), (PBItems::MAGICALSEED), (PBItems::EXPERTBELT), (PBItems::MUSCLEBAND), (PBItems::WISEGLASSES), (PBItems::LIFEORB), (PBItems::EVIOLITE), (PBItems::ASSAULTVEST)
            score*=1.2
          when (PBItems::LEFTOVERS), (PBItems::BLACKSLUDGE)
            score*=1.3
          end
          if opponent.hp*2<opponent.totalhp
            score*=1.4
          end
        end
        if score==startscore
          score*=0
        end
      end
    when 0xF9 # Magic Room
      if @field.effects[PBEffects::MagicRoom]>0
        score*=0
      else
        if (attitemworks && attacker.item == PBItems::AMPLIFIELDROCK) || $fefieldeffect==35 || $fefieldeffect==37
          score*=1.3
        end
        if opponent.item!=0
          score*=1.1
          if pbIsBerry?(opponent.item)
            score*=1.1
          end
          case opponent.item
          when (PBItems::LAXINCENSE), (PBItems::SYNTHETICSEED), (PBItems::TELLURICSEED), (PBItems::ELEMENTALSEED), (PBItems::MAGICALSEED), (PBItems::EXPERTBELT), (PBItems::MUSCLEBAND), (PBItems::WISEGLASSES), (PBItems::LIFEORB), (PBItems::EVIOLITE), (PBItems::ASSAULTVEST)
            score*=1.2
          when (PBItems::LEFTOVERS), (PBItems::BLACKSLUDGE)
            score*=1.3
          end
        end
        if attacker.item!=0
          score*=0.8
          if pbIsBerry?(opponent.item)
            score*=0.8
          end
          case opponent.item
          when (PBItems::LAXINCENSE), (PBItems::SYNTHETICSEED), (PBItems::TELLURICSEED), (PBItems::ELEMENTALSEED), (PBItems::MAGICALSEED), (PBItems::EXPERTBELT), (PBItems::MUSCLEBAND), (PBItems::WISEGLASSES), (PBItems::LIFEORB), (PBItems::EVIOLITE), (PBItems::ASSAULTVEST)
            score*=0.6
          when (PBItems::LEFTOVERS), (PBItems::BLACKSLUDGE)
            score*=0.4
          end
        end
      end
    when 0xFA # Take Down
      if !(!attacker.abilitynulled && attacker.ability == PBAbilities::ROCKHEAD)
        score*=0.9
        if attacker.hp==attacker.totalhp && ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) || attacker.hasWorkingItem(:FOCUSSASH) || (isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST)))
          score*=0.7
        end
        if attacker.hp*(1.0/attacker.totalhp)>0.1 && attacker.hp*(1.0/attacker.totalhp)<0.4
          score*=0.8
        end
      end
      ghostvar=false
      for mon in pbParty(attacker.index)
        next if mon.nil?
        if mon.hasType?(:GHOST)
          ghostvar=true
        end
      end
      if move.id==getID(PBMoves,:WILDCHARGE)
        if $fefieldeffect==18
          score*=1.1
          if ghostvar
            score*=0.8
          end
        end
      end
    when 0xFB # Wood Hammer
      if !(!attacker.abilitynulled && attacker.ability == PBAbilities::ROCKHEAD) || ((isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST)))
        if attacker.hp==attacker.totalhp && ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) || attacker.hasWorkingItem(:FOCUSSASH))
          score*=0.9
        end
        if hasgreatmoves(initialscores,scoreindex,skill) && !pbIsZCrystal?(attacker.item)
          score*=0.95
        end
      end
    when 0xFC # Head Smash
      if !(!attacker.abilitynulled && attacker.ability == PBAbilities::ROCKHEAD) || ((isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST)))
        score*=0.9
        movedamage=(pbRoughDamage(move,attacker,opponent,skill,move.basedamage))
        if movedamage>opponent.hp
          recoildamage=(opponent.hp/2)
        else
          recoildamage=(movedamage/2)
          recoildamage/=0.85
        end
        atkhp=attacker.hp
        maxdam=checkAIdamage(aimem,attacker,opponent,skill)
        if movedamage<opponent.hp && maxdam<attacker.hp && ((maxdam+recoildamage)>=attacker.hp) && ((attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) 
          if !hasbadmoves(initialscores,scoreindex,50)
            score*=0.7
          end
        end
        if attacker.hp==attacker.totalhp && ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) || attacker.hasWorkingItem(:FOCUSSASH))
          score*=0.9
        end
      end
    when 0xFD # Volt Tackle
      if !(!attacker.abilitynulled && attacker.ability == PBAbilities::ROCKHEAD) || ((isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST)))
        score*=0.9
        if attacker.hp==attacker.totalhp && ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) || (attitemworks && attacker.item == PBItems::FOCUSSASH))
          score*=0.7
        end
      end
      if opponent.pbCanParalyze?(false)
        miniscore=100
        miniscore*=1.1
        miniscore*=1.3 if attacker.moves.any? {|moveloop| (PBStuff::SETUPMOVE).include?(moveloop.id)}
        if opponent.hp==opponent.totalhp
          miniscore*=1.2
        end
        ministat=0
        ministat+=opponent.stages[PBStats::ATTACK]
        ministat+=opponent.stages[PBStats::SPATK]
        ministat+=opponent.stages[PBStats::SPEED]
        if ministat>0
          minimini=5*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::NATURALCURE)
          miniscore*=0.3
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::MARVELSCALE) || SilvallyCheck(opponent,"water")
          miniscore*=0.5
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::QUICKFEET) || (!opponent.abilitynulled && opponent.ability == PBAbilities::GUTS)
          miniscore*=0.2
        end
        if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL) || roles.include?(PBMonRoles::PIVOT)
          miniscore*=1.2
        end
        if roles.include?(PBMonRoles::TANK)
          miniscore*=1.5
        end
        if pbRoughStat(opponent,PBStats::SPEED,skill)>attacker.pbSpeed && (pbRoughStat(opponent,PBStats::SPEED,skill)/2)<attacker.pbSpeed && @trickroom==0
          miniscore*=1.5
        end
        if pbRoughStat(opponent,PBStats::SPATK,skill)>pbRoughStat(opponent,PBStats::ATTACK,skill)
          miniscore*=1.3
        end
        count = -1
        sweepvar = false
        for i in pbParty(attacker.index)
          count+=1
          next if i.nil?
          temprole = pbGetMonRole(i,opponent,skill,count,pbParty(attacker.index))
          if temprole.include?(PBMonRoles::SWEEPER)
            sweepvar = true
          end
        end
        miniscore*=1.3 if sweepvar
        if opponent.effects[PBEffects::Confusion]>0
          miniscore*=1.1
        end
        if opponent.effects[PBEffects::Attract]>=0
          miniscore*=1.1
        end
        if opponent.effects[PBEffects::Yawn]>0
          miniscore*=0.4
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::SHEDSKIN)
          miniscore*=0.7
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::SYNCHRONIZE) && attacker.status==0 && !attacker.pbHasType?(:ELECTRIC) && !attacker.pbHasType?(:GROUND)
          miniscore*=0.5
        end
        miniscore-=100
        if move.addlEffect.to_f != 100
          miniscore*=(move.addlEffect.to_f/100)
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
            miniscore*=2
          end
        end
        miniscore+=100
        miniscore/=100.0
        score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !((!opponent.abilitynulled && opponent.ability == PBAbilities::SHIELDDUST) && !opponent.moldbroken) && !hasgreatmoves(initialscores,scoreindex,skill,true)
      end
    when 0xFE # Flare Blitz
      if !(!attacker.abilitynulled && attacker.ability == PBAbilities::ROCKHEAD)
        score*=0.9
        if attacker.hp==attacker.totalhp && ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) || (attitemworks && attacker.item == PBItems::FOCUSSASH))
          score*=0.7
        end
      end
      if opponent.pbCanBurn?(false)
        miniscore=100
        miniscore*=1.2
        ministat=0
        ministat+=opponent.stages[PBStats::ATTACK]
        ministat+=opponent.stages[PBStats::SPATK]
        ministat+=opponent.stages[PBStats::SPEED]
        if ministat>0
          minimini=5*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::NATURALCURE)
          miniscore*=0.3
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::MARVELSCALE) || SilvallyCheck(opponent,"water")
          miniscore*=0.7
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::QUICKFEET) || (!opponent.abilitynulled && opponent.ability == PBAbilities::FLAREBOOST) || (!opponent.abilitynulled && opponent.ability == PBAbilities::MAGICGUARD)
          miniscore*=0.3
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::GUTS)
          miniscore*=0.1
        end
        miniscore*=0.3 if checkAImoves([PBMoves::FACADE],aimem)
        miniscore*=0.1 if checkAImoves([PBMoves::REST],aimem)
        if pbRoughStat(opponent,PBStats::ATTACK,skill)>pbRoughStat(opponent,PBStats::SPATK,skill)
          miniscore*=1.7
        end
        if opponent.effects[PBEffects::Yawn]>0
          miniscore*=0.4
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::SYNCHRONIZE) && attacker.status==0
          miniscore*=0.5
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::SHEDSKIN)
          miniscore*=0.7
        end
        if move.basedamage>0
          if (!opponent.abilitynulled && opponent.ability == PBAbilities::STURDY)
            miniscore*=1.1
          end
        end
        miniscore-=100
        if move.addlEffect.to_f != 100
          miniscore*=(move.addlEffect.to_f/100)
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
            miniscore*=2
          end
        end
        miniscore+=100
        miniscore/=100.0
        score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !((!opponent.abilitynulled && opponent.ability == PBAbilities::SHIELDDUST) && !opponent.moldbroken) && !hasgreatmoves(initialscores,scoreindex,skill,true)
      end
    when 0xFF # Sunny Day
      if pbCheckGlobalAbility(:AIRLOCK) ||
        pbCheckGlobalAbility(:CLOUDNINE) ||
        pbCheckGlobalAbility(:DELTASTREAM) ||
        pbCheckGlobalAbility(:DESOLATELAND) ||
        pbCheckGlobalAbility(:PRIMORDIALSEA) ||
        pbWeather==PBWeather::SUNNYDAY
        score*=0
      end
      if attacker.hp==attacker.totalhp && ((attacker.hasWorkingItem(:FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) && !attacker.moldbroken) || (isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST)))  && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
        score*=1.3
      end
      if roles.include?(PBMonRoles::LEAD)
        score*=1.2
      end
      if (attitemworks && attacker.item == PBItems::HEATROCK)
        score*=1.3
      end
      if attacker.pbHasMove?((PBMoves::WEATHERBALL)) || (!attacker.abilitynulled && attacker.ability == PBAbilities::FORECAST)
        score*=2
      end
      if pbWeather!=0 && pbWeather!=PBWeather::SUNNYDAY
        score*=1.5
      end
      if attacker.pbHasMove?((PBMoves::MOONLIGHT)) || attacker.pbHasMove?((PBMoves::SYNTHESIS)) || attacker.pbHasMove?((PBMoves::MORNINGSUN)) || attacker.pbHasMove?((PBMoves::GROWTH)) || attacker.pbHasMove?((PBMoves::SOLARBEAM)) || attacker.pbHasMove?((PBMoves::SOLARBLADE))
        score*=1.5
      end
      if attacker.pbHasType?(:FIRE)
        score*=1.5
      end
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CHLOROPHYLL) || (!attacker.abilitynulled && attacker.ability == PBAbilities::FLOWERGIFT)
        score*=2
        if (attitemworks && attacker.item == PBItems::FOCUSSASH)
          score*=2
        end
        if attacker.effects[PBEffects::KingsShield]== true ||
          attacker.effects[PBEffects::BanefulBunker]== true ||
          attacker.effects[PBEffects::SpikyShield]== true
          score *=3
        end
      end
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::SOLARPOWER) || (!attacker.abilitynulled && attacker.ability == PBAbilities::LEAFGUARD)
        score*=1.2
      end
      watervar=false
      sunvar=false
      for mon in pbParty(attacker.index)
        next if mon.nil?
        next if mon==attacker.index
        if mon.hasType?(:WATER)
          watervar=true
        end
        if mon.hasType?(:FIRE) || (mon.ability == PBAbilities::SOLARPOWER) ||  (mon.ability == PBAbilities::CHLOROPHYLL) ||  (mon.ability == PBAbilities::HARVEST) ||
          (mon.ability == PBAbilities::FLOWERGIFT)
           sunvar=true
        end
      end
      if watervar
        score*=0.5
      end
      if sunvar
        score*=1.3
      end
      if attacker.pbHasMove?((PBMoves::THUNDER)) || attacker.pbHasMove?((PBMoves::HURRICANE))
        score*=0.7
      end
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::DRYSKIN)
        score*=0.5
      end
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::HARVEST)
        score*=1.5
      end
      maxdam = checkAIdamage(aimem,attacker,opponent,skill)
      if ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) && maxdam*2>attacker.hp && !(!attacker.abilitynulled && attacker.ability == PBAbilities::CHLOROPHYLL)
        score*=0.7
      elsif ((attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0))
        if maxdam>attacker.hp && !roles.include?(PBMonRoles::LEAD)
          score*=0.4
        end
      end
      opponentstrongmove=checkAIdamage(aimem,attacker,opponent,skill,true,true)[1]
      nextdamage=checkAIdamage(aimem,attacker,opponent,skill,true,true)[2]
      opponent2ndstrongmove=checkAIdamage(aimem,attacker,opponent,skill,true,true)[3]
      if !opponentstrongmove.is_a?(Integer)
        if opponentstrongmove.type==PBTypes::WATER
          if nextdamage.nil? #||nextdamage<maxdam*0.75
            score*=1.3
          else
            if nextdamage<maxdam*0.75
              score*=1.3
            end
          end
        end
      end
      if pbWeather==PBWeather::RAINDANCE
        miniscore = getFieldDisruptScore(attacker,opponent,skill)
        if attacker.pbHasType?(:NORMAL)
          miniscore*=1.2
        end
        score*=miniscore
      end
      if skill>=PBTrainerAI.highSkill
        if $fefieldeffect==12 || $fefieldeffect==27 || $fefieldeffect==28 # Desert/Mountian/Snowy Mountain
          score*=1.3
        end
        if $fefieldeffect==33 # Flower Garden
          score*=2
        end
        if $fefieldeffect==4 # Dark Crystal
          darkvar=false
          for mon in pbParty(attacker.index)
            next if mon.nil?
            if mon.hasType?(:DARK)
              darkvar=true
            end
          end
          if !darkvar
            score*=3
          end
        end
        if $fefieldeffect==22 || $fefieldeffect==35 # Underwater or New World
          score*=0
        end
      end
    when 0x100 # Rain Dance
      if pbCheckGlobalAbility(:AIRLOCK) ||
        pbCheckGlobalAbility(:CLOUDNINE) ||
        pbCheckGlobalAbility(:DELTASTREAM) ||
        pbCheckGlobalAbility(:DESOLATELAND) ||
        pbCheckGlobalAbility(:PRIMORDIALSEA) ||
        pbWeather==PBWeather::RAINDANCE
        score*=0
      end
      if attacker.hp==attacker.totalhp && ((attacker.hasWorkingItem(:FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) && !attacker.moldbroken) || (isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST)))  && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
        score*=1.3
      end
      if roles.include?(PBMonRoles::LEAD)
        score*=1.2
      end
      if (attitemworks && attacker.item == PBItems::DAMPROCK)
        score*=1.3
      end
      if attacker.pbHasMove?((PBMoves::WEATHERBALL)) || (!attacker.abilitynulled && attacker.ability == PBAbilities::FORECAST)
        score*=2
      end
      if pbWeather!=0 && pbWeather!=PBWeather::RAINDANCE
        score*=1.3
      end
      if attacker.pbHasMove?((PBMoves::THUNDER)) || attacker.pbHasMove?((PBMoves::HURRICANE))
        score*=1.5
      end
      if attacker.pbHasType?(:WATER)
        score*=1.5
      end
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::SWIFTSWIM)
        score*=2
        if (attitemworks && attacker.item == PBItems::FOCUSSASH)
          score*=2
        end
        if attacker.effects[PBEffects::KingsShield]== true ||
          attacker.effects[PBEffects::BanefulBunker]== true ||
          attacker.effects[PBEffects::SpikyShield]== true
          score *=3
        end
      end
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::DRYSKIN) || pbWeather==PBWeather::RAINDANCE
        score*=1.5
      end
      if pbWeather==PBWeather::SUNNYDAY
        miniscore = getFieldDisruptScore(attacker,opponent,skill)
        if attacker.pbHasType?(:NORMAL)
          miniscore*=1.2
        end
        score*=miniscore
      end
      firevar=false
      rainvar=false
      for mon in pbParty(attacker.index)
        next if mon.nil?
        next if mon==attacker.index
        if mon.hasType?(:FIRE)
          firevar=true
        end
        if mon.hasType?(:WATER) || (mon.ability == PBAbilities::SWIFTSWIM) ||  (mon.ability == PBAbilities::DRYSKIN) ||  (mon.ability == PBAbilities::HYDRATION) ||
          (mon.ability == PBAbilities::RAINDISH)
           rainvar=true
        end
      end
      if firevar
        score*=0.5
      end
      if rainvar
        score*=1.3
      end
      maxdam = checkAIdamage(aimem,attacker,opponent,skill)
      if ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) && maxdam*2>attacker.hp && !(!attacker.abilitynulled && attacker.ability == PBAbilities::SWIFTSWIM)
        score*=0.7
      end
      if attacker.pbHasMove?((PBMoves::MOONLIGHT)) || attacker.pbHasMove?((PBMoves::SYNTHESIS)) || attacker.pbHasMove?((PBMoves::MORNINGSUN)) || attacker.pbHasMove?((PBMoves::GROWTH)) || attacker.pbHasMove?((PBMoves::SOLARBEAM)) || attacker.pbHasMove?((PBMoves::SOLARBLADE))
        score*=0.5
      end
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::HYDRATION)
        score*=1.5
      end
      if skill>=PBTrainerAI.highSkill
        if $fefieldeffect==6 # Big Top
          score*=1.2
        end
        if $fefieldeffect==7 || $fefieldeffect==33 # Burning/Flower Garden
          score*=2
        end
        if $fefieldeffect==34 # Starlight
          darkvar=false
          fairyvar=false
          psychicvar=false
          for mon in pbParty(attacker.index)
            next if mon.nil?
            if mon.hasType?(:DARK)
              darkvar=true
            end
            if mon.hasType?(:FAIRY)
              fairyvar=true
            end
            if mon.hasType?(:PSYCHIC)
              psychicvar=true
            end
          end
          if !darkvar && !fairyvar && !psychicvar
            score*=2
          end
        end
        if $fefieldeffect==22 || $fefieldeffect==35 # Underwater or New World
          score*=0
        end
      end
    when 0x101 # Sandstorm
      if pbCheckGlobalAbility(:AIRLOCK) ||
        pbCheckGlobalAbility(:CLOUDNINE) ||
        pbCheckGlobalAbility(:DELTASTREAM) ||
        pbCheckGlobalAbility(:DESOLATELAND) ||
        pbCheckGlobalAbility(:PRIMORDIALSEA) ||
        pbWeather==PBWeather::SANDSTORM
        score*=0
      end
      if attacker.hp==attacker.totalhp && ((attacker.hasWorkingItem(:FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) && !attacker.moldbroken) || (isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST)))  && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
        score*=1.3
      end
      if roles.include?(PBMonRoles::LEAD)
        score*=1.2
      end
      if (attitemworks && attacker.item == PBItems::SMOOTHROCK)
        score*=1.3
      end
      if attacker.pbHasMove?((PBMoves::WEATHERBALL)) || (!attacker.abilitynulled && attacker.ability == PBAbilities::FORECAST)
        score*=2
      end
      if pbWeather!=0 && pbWeather!=PBWeather::SANDSTORM
        score*=2
      end
      if attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)
        score*=1.3
      else
        score*=0.7
      end
      if attacker.pbHasType?(:ROCK)
        score*=1.5
      end
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::SANDRUSH)
        score*=2
        if (attitemworks && attacker.item == PBItems::FOCUSSASH)
          score*=2
        end
        if attacker.effects[PBEffects::KingsShield]== true ||
          attacker.effects[PBEffects::BanefulBunker]== true ||
          attacker.effects[PBEffects::SpikyShield]== true
          score *=3
        end
      end
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::SANDVEIL)
        score*=1.3
      end
      if attacker.pbHasMove?((PBMoves::MOONLIGHT)) || attacker.pbHasMove?((PBMoves::SYNTHESIS)) || attacker.pbHasMove?((PBMoves::MORNINGSUN)) || attacker.pbHasMove?((PBMoves::GROWTH)) || attacker.pbHasMove?((PBMoves::SOLARBEAM)) || attacker.pbHasMove?((PBMoves::SOLARBLADE))
        score*=0.5
      end
      if attacker.pbHasMove?((PBMoves::SHOREUP))
        score*=1.5
      end
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::SANDFORCE)
        score*=1.5
      end
      maxdam = checkAIdamage(aimem,attacker,opponent,skill)
      if ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) && maxdam*2>attacker.hp && !(!attacker.abilitynulled && attacker.ability == PBAbilities::SANDRUSH)
        score*=0.7
      end
      if skill>=PBTrainerAI.highSkill
        if $fefieldeffect==20 || $fefieldeffect==12 # Ashen Beach/Desert
          score*=1.3
        end
        if $fefieldeffect==9 # Rainbow
          score*=1.5
        end
        if $fefieldeffect==7 # Burning
          score*=3
        end
        if $fefieldeffect==34 # Starlight
          darkvar=false
          fairyvar=false
          psychicvar=false
          for mon in pbParty(attacker.index)
            next if mon.nil?
            if mon.hasType?(:DARK)
              darkvar=true
            end
            if mon.hasType?(:FAIRY)
              fairyvar=true
            end
            if mon.hasType?(:PSYCHIC)
              psychicvar=true
            end
          end
          if !darkvar && !fairyvar && !psychicvar
            score*=2
          end
        end
        if $fefieldeffect==22 || $fefieldeffect==35 # Underwater or New World
          score*=0
        end
      end
    when 0x102 # Hail
      if pbCheckGlobalAbility(:AIRLOCK) ||
        pbCheckGlobalAbility(:CLOUDNINE) ||
        pbCheckGlobalAbility(:DELTASTREAM) ||
        pbCheckGlobalAbility(:DESOLATELAND) ||
        pbCheckGlobalAbility(:PRIMORDIALSEA) ||
        pbWeather==PBWeather::HAIL
        score*=0
      end
      if attacker.hp==attacker.totalhp && ((attacker.hasWorkingItem(:FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) && !attacker.moldbroken) || (isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST)))  && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
        score*=1.3
      end
      if roles.include?(PBMonRoles::LEAD)
        score*=1.2
      end
      if (attitemworks && attacker.item == PBItems::ICYROCK)
        score*=1.3
      end
      if attacker.pbHasMove?((PBMoves::WEATHERBALL)) || (!attacker.abilitynulled && attacker.ability == PBAbilities::FORECAST)
        score*=2
      end
      if pbWeather!=0 && pbWeather!=PBWeather::HAIL
        score*=1.3
      end
      if attacker.pbHasType?(:ICE)
        score*=5
      else
        score*=0.7
      end
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::SLUSHRUSH)
        score*=2
        if (attitemworks && attacker.item == PBItems::FOCUSSASH)
          score*=2
        end
        if attacker.effects[PBEffects::KingsShield]== true ||
          attacker.effects[PBEffects::BanefulBunker]== true ||
          attacker.effects[PBEffects::SpikyShield]== true
          score *=3
        end
      end
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::SNOWCLOAK) || (!attacker.abilitynulled && attacker.ability == PBAbilities::ICEBODY)
        score*=1.3
      end
      if attacker.pbHasMove?((PBMoves::MOONLIGHT)) || attacker.pbHasMove?((PBMoves::SYNTHESIS)) || attacker.pbHasMove?((PBMoves::MORNINGSUN)) || attacker.pbHasMove?((PBMoves::GROWTH)) || attacker.pbHasMove?((PBMoves::SOLARBEAM)) || attacker.pbHasMove?((PBMoves::SOLARBLADE))
        score*=0.5
      end
      if attacker.pbHasMove?((PBMoves::AURORAVEIL))
        score*=2
      end
      if attacker.pbHasMove?((PBMoves::BLIZZARD))
        score*=1.3
      end
      maxdam = checkAIdamage(aimem,attacker,opponent,skill)
      if ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) && maxdam*2>attacker.hp && !(!attacker.abilitynulled && attacker.ability == PBAbilities::SLUSHRUSH)
        score*=0.7
      end
      if skill>=PBTrainerAI.highSkill
        if $fefieldeffect==13 || $fefieldeffect==28 # Icy/Snowy Mountain
          score*=1.2
        end
        if $fefieldeffect==9 || $fefieldeffect==27 # Rainbow/Mountian
          score*=1.5
        end
        if $fefieldeffect==16 # Superheated
          score*=0
        end
        if $fefieldeffect==34 # Starlight
          darkvar=false
          fairyvar=false
          psychicvar=false
          for mon in pbParty(attacker.index)
            next if mon.nil?
            if mon.hasType?(:DARK)
              darkvar=true
            end
            if mon.hasType?(:FAIRY)
              fairyvar=true
            end
            if mon.hasType?(:PSYCHIC)
              psychicvar=true
            end
          end
          if !darkvar && !fairyvar && !psychicvar
            score*=2
          end
        end
        if $fefieldeffect==22 || $fefieldeffect==35 # Underwater or New World
          score*=0
        end
      end
    when 0x103 # Spikes
      if attacker.pbOpposingSide.effects[PBEffects::Spikes]!=3
        if roles.include?(PBMonRoles::LEAD)
          score*=1.2
        end
        if attacker.hp==attacker.totalhp && (((attitemworks && attacker.item == PBItems::FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) && !attacker.moldbroken)) && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
          score*=1.1
        end
        if attacker.turncount<2
          score*=1.2
        end
        livecount1=0
        for i in pbParty(opponent.index)
          next if i.nil?
          livecount1+=1 if i.hp!=0
        end
        livecount2=0
        for i in pbParty(attacker.index)
          next if i.nil?
          livecount2+=1 if i.hp!=0
        end
        if initialscores.length>0
          if hasbadmoves(initialscores,scoreindex,40) &&  livecount1>4
            score*=1.3 
          elsif livecount2<3
            score*=0.8
          end
        end
        if livecount1>2
          miniscore=(livecount1)
          miniscore*=0.25
          score*=miniscore
        else
          score*=0.1
        end
        if @doublebattle
          score*=0.6
        end
        if attacker.pbOpposingSide.effects[PBEffects::Spikes]>0
          score*=(0.9**attacker.pbOpposingSide.effects[PBEffects::Spikes])
        end
        score*=0.3 if checkAImoves([PBMoves::DEFOG,PBMoves::RAPIDSPIN,PBMoves::MAGICCOAT],aimem)
        airbornemons=0
        if skill>=PBTrainerAI.highSkill
          for k in 0...pbParty(opponent.index).length
            next if pbParty(opponent.index)[k].nil?
            for j in @aiAbilityMemory[0][k]
              if j==PBAbilities::MAGICBOUNCE && !pbParty(opponent.index)[k].isFainted?
                magiccheck=true
              end
            end   
            airbornemons+= 1 if pbParty(opponent.index)[k].isAirborne?
            if @aiMoveMemory[2][k].length>0
              movecheck=false
              for j in @aiMoveMemory[2][k]
                movecheck=true if j.id==(PBMoves::DEFOG) || j.id==(PBMoves::RAPIDSPIN)
              end
              score*=0.3 if movecheck
            end
          end
          if airbornemons>=4 || airbornemons>opponent.pbNonActivePokemonCount
            score*=0.6
          end
        elsif skill>=PBTrainerAI.mediumSkill
          score*=0.3 if checkAImoves([PBMoves::DEFOG,PBMoves::RAPIDSPIN],aimem)
        end
        if magiccheck
          score*=0.3
        end
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect==21 || $fefieldeffect==26 # (Murk)Water Surface
            score*=0
          end
        end
      else
        score*=0
      end
      if skill>=PBTrainerAI.highSkill
        if $fefieldeffect==19 # Wasteland
          score = ((opponent.totalhp/3.0)/opponent.hp)*100
          score*=1.5 if @doublebattle
        end
      end
    when 0x104 # Toxic Spikes
      if attacker.pbOpposingSide.effects[PBEffects::ToxicSpikes]!=2
        if roles.include?(PBMonRoles::LEAD)
          score*=1.1
        end
        if attacker.hp==attacker.totalhp && (((attitemworks && attacker.item == PBItems::FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) && !attacker.moldbroken)) && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
          score*=1.1
        end
        if attacker.turncount<2
          score*=1.2
        end
        if initialscores.length>0
          score*=1.3 if hasbadmoves(initialscores,scoreindex,40)
        end
        livecount1=0
        for i in pbParty(opponent.index)
          next if i.nil?
          livecount1+=1 if i.hp!=0
        end
        livecount2=0
        for i in pbParty(attacker.index)
          next if i.nil?
          livecount2+=1 if i.hp!=0
        end
        if livecount1>2
          miniscore=(livecount1-1)
          miniscore*=0.25
          score*=miniscore
        else
          score*=0.1
        end
        if attacker.pbOpposingSide.effects[PBEffects::ToxicSpikes]>0
          score*=0.9
        end
        if @doublebattle
          score*=0.6
        end
        score*=0.3 if checkAImoves([PBMoves::DEFOG,PBMoves::RAPIDSPIN,PBMoves::MAGICCOAT],aimem)
        airbornemons=0
        if skill>=PBTrainerAI.highSkill
          for k in 0...pbParty(opponent.index).length
            next if pbParty(opponent.index)[k].nil?
            for j in @aiAbilityMemory[0][k]
              if j==PBAbilities::MAGICBOUNCE && !pbParty(opponent.index)[k].isFainted?
                magiccheck=true
              end
            end   
            airbornemons+= 1 if pbParty(opponent.index)[k].isAirborne?
            if @aiMoveMemory[2][k].length>0
              movecheck=false
              for j in @aiMoveMemory[2][k]
                movecheck=true if j.id==(PBMoves::DEFOG) || j.id==(PBMoves::RAPIDSPIN)
              end
              score*=0.3 if movecheck
            end
          end
          if airbornemons>=4
            score*=0.6
          end
        elsif skill>=PBTrainerAI.mediumSkill
          score*=0.3 if checkAImoves([PBMoves::DEFOG,PBMoves::RAPIDSPIN],aimem)
        end
        if magiccheck
          score*=0.3
        end
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect==21 || $fefieldeffect==26 || $fefieldeffect==43 # (Murk)Water Surface
            score*=0
          end
        end
      else
        score*=0
      end
      if skill>=PBTrainerAI.highSkill
        if $fefieldeffect==19 # Wasteland
          score = ((opponent.totalhp*0.13)/opponent.hp)*100
          if opponent.pbCanPoison?(false)
            score*=1.5
          else
            score*=0
          end
          score*=1.5 if @doublebattle
          if opponent.hasType?(:POISON)
            score*=0
          end
        end
      end
    when 0x105 # Stealth Rock
      if !attacker.pbOpposingSide.effects[PBEffects::StealthRock]
        if roles.include?(PBMonRoles::LEAD) || (initialscores.length>0 && hasbadmoves(initialscores,scoreindex,50))
          score*=1.2
        end
        if attacker.hp==attacker.totalhp && (((attitemworks && attacker.item == PBItems::FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) && !attacker.moldbroken)) && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
          score*=1.5
        end
        if attacker.turncount<2 
          score*=1.2
        end
        livecount1=0
        for i in pbParty(opponent.index)
          next if i.nil?
          livecount1+=1 if i.hp!=0
        end
        if @doublebattle
          score*=0.6
        end
        livecount2=0
        for i in pbParty(attacker.index)
          next if i.nil?
          livecount2+=1 if i.hp!=0
        end
        if livecount1>2
          miniscore=(livecount1-1)
          miniscore*=0.2
          score*=miniscore
        else
          score*=0.1
        end
        score*=0.3 if checkAImoves([PBMoves::DEFOG,PBMoves::RAPIDSPIN,PBMoves::MAGICCOAT],aimem)
        if skill>=PBTrainerAI.highSkill
          for k in 0...pbParty(opponent.index).length
            next if pbParty(opponent.index)[k].nil?
            for j in @aiAbilityMemory[0][k]
              if j==PBAbilities::MAGICBOUNCE && !pbParty(opponent.index)[k].isFainted?
                magiccheck=true
              end
            end    
            if @aiMoveMemory[2][k].length>0
              movecheck=false
              for j in @aiMoveMemory[2][k]
                movecheck=true if j.id==(PBMoves::DEFOG) || j.id==(PBMoves::RAPIDSPIN)
              end
              score*=0.3 if movecheck
            end
          end
        elsif skill>=PBTrainerAI.mediumSkill
          score*=0.3 if checkAImoves([PBMoves::DEFOG,PBMoves::RAPIDSPIN],aimem)
        end
        if magiccheck
          score*=0.3
        end
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect==23 || $fefieldeffect==14 # Cave/Rocky
            score*=2
          end
          if $fefieldeffect==25 # Crystal Cavern
            score*=1.3
          end
        end
      else
        score*=0
      end
      if skill>=PBTrainerAI.highSkill
        if $fefieldeffect==19 # Wasteland
          atype=(PBTypes::ROCK)
          score = ((opponent.totalhp/4.0)/opponent.hp)*100
          score*=2 if pbTypeModNoMessages(atype,attacker,opponent,move,skill)>4
          score*=1.5 if @doublebattle
        end
      end
    when 0x106 # Grass Pledge
      if $fepledgefield != 3 && (opponent.pbHasMove?((PBMoves::FIREPLEDGE)) || opponent.pbHasMove?((PBMoves::WATERPLEDGE)))
        miniscore = getFieldDisruptScore(attacker,opponent,skill)
        if $fepledgefield!=1 && $fepledgefield!=2
          miniscore*=0.7
        else
          firevar=false
          for mon in pbParty(attacker.index)
            next if mon.nil?
            if mon.hasType?(:FIRE)
              firevar=true
            end
          end
          if $fepledgefield==1
            if attacker.pbHasType?(:FIRE)
              miniscore*=1.4
            else
              miniscore*=0.3
            end
            if opponent.pbHasType?(:FIRE)
              miniscore*=0.3
            else
              miniscore*=1.4
            end
            if firevar
              miniscore*=1.4
            else
              miniscore*=1.3
            end
          end
        end
        score*=miniscore
      end
    when 0x107 # Fire Pledge
      firevar=false
      poisonvar=false
      bugvar=false
      grassvar=false
      icevar=false
      poisonvar=false
      for mon in pbParty(attacker.index)
        next if mon.nil?
        if mon.hasType?(:FIRE)
          firevar=true
        end
        if mon.hasType?(:POISON)
          poisonvar=true
        end
        if mon.hasType?(:BUG)
          bugvar=true
        end
        if mon.hasType?(:GRASS)
          grassvar=true
        end
        if mon.hasType?(:ICE)
          icevar=true
        end
        if mon.hasType?(:POISON)
          poisonvar=true
        end
      end
      if $fepledgefield != 1
        miniscore = getFieldDisruptScore(attacker,opponent,skill)
        if $fepledgefield!=3 && $fepledgefield!=2
          miniscore*=0.7
        else
          if $fepledgefield==3
            if attacker.pbHasType?(:FIRE)
              miniscore*=1.4
            else
              miniscore*=0.3
            end
            if opponent.pbHasType?(:FIRE)
              miniscore*=0.3
            else
              miniscore*=1.4
            end
            if firevar
              miniscore*=1.4
            else
              miniscore*=1.3
            end
          end
          if $fepledgefield==2
            miniscore*=1.2
            if attacker.pbHasType?(:NORMAL)
              miniscore*=1.2
            end
          end
        end
        score*=miniscore
      end
      if $fefieldeffect==2 || $fefieldeffect==15 || ($fefieldeffect==33 && $fecounter>1)
        if firevar && !(bugvar || grassvar)
          score*=2
        end
      elsif $fefieldeffect==16
        if firevar
          score*=2
        end
      elsif $fefieldeffect==11
        if !poisonvar
          score*=1.1
        end
        if attacker.hp*5<attacker.totalhp
          score*=2
        end
        if opponent.pbNonActivePokemonCount==0
          score*=5
        end
      elsif $fefieldeffect==13 || $fefieldeffect==28
        if !icevar
          score*=1.5
        end
      end
    when 0x108 # Water Pledge
      if $fefieldeffect==0
        if $fepledgefield != 2
          miniscore = getFieldDisruptScore(attacker,opponent,skill)
          if $fepledgefield!=1 && $fepledgefield!=3
            miniscore*=0.7
          else
            firevar=false
            for mon in pbParty(attacker.index)
              next if mon.nil?
              if mon.hasType?(:FIRE)
                firevar=true
              end
            end
            if $fepledgefield==1
              miniscore*=1.2
              if attacker.pbHasType?(:NORMAL)
                miniscore*=1.2
              end
            end
          end
          score*=miniscore
        end
        if $fefieldeffect==7
          if firevar
            score*=0
          else
            score*=2
          end
        end
      end
    when 0x109 # Pay Day - to do
    when 0x10A # Psychic Fangs / Brick Break
      if attacker.pbOpposingSide.effects[PBEffects::Reflect]>0
        score*=1.8
      end
      if attacker.pbOpposingSide.effects[PBEffects::LightScreen]>0
        score*=1.3
      end
      if attacker.pbOpposingSide.effects[PBEffects::AreniteWall]>0
        score*=1.8
      end
      if attacker.pbOpposingSide.effects[PBEffects::AuroraVeil]>0
        score*=2.0
      end
    when 0x10B # Hi Jump Kick
      score*=0.5 if checkAImoves(PBStuff::PROTECTMOVE,aimem)
      ministat=opponent.stages[PBStats::EVASION]
      ministat*=(-10)
      ministat+=100
      ministat/=100.0
      score*=ministat
      ministat=attacker.stages[PBStats::ACCURACY]
      ministat*=(10)
      ministat+=100
      ministat/=100.0
      score*=ministat
      score*=0 if  @field.effects[PBEffects::Gravity]>0
      if ((!opponent.abilitynulled && opponent.ability == PBAbilities::SANDVEIL) && pbWeather==PBWeather::SANDSTORM) || ((!opponent.abilitynulled && opponent.ability == PBAbilities::SNOWCLOAK) && pbWeather==PBWeather::HAIL)
        score*=0.7
      end
      if (oppitemworks && opponent.item == PBItems::LAXINCENSE) || (oppitemworks && opponent.item == PBItems::BRIGHTPOWDER)
        score*=0.7
      end
      if attacker.index != 2
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect!=36
            ghostvar = false
            for mon in pbParty(opponent.index)
              next if mon.nil?
              next if mon.hp==0
              ghostvar=true if mon.hasType?(:GHOST)
            end
            if ghostvar && opponent.effects[PBEffects::Switching]==true
              score*=0.8
            end
          end
        end
      end
    when 0x10C # Substitute
      if attacker.hp*4>attacker.totalhp
        if attacker.effects[PBEffects::Substitute]>0
          if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
            score*=0
          else
            if opponent.effects[PBEffects::LeechSeed]<0
              score*=0
            end
          end
        else
          if attacker.hp==attacker.totalhp
            score*=1.1
          else
            score*=(attacker.hp*(1.0/attacker.totalhp))
          end
          if opponent.effects[PBEffects::LeechSeed]>=0
            score*=1.2
          end
          if (attitemworks && attacker.item == PBItems::LEFTOVERS)
            score*=1.2
          end
          for j in attacker.moves
            if j.isHealingMove?
              score*=1.2
              break
            end
          end
          if opponent.pbHasMove?((PBMoves::SPORE)) || opponent.pbHasMove?((PBMoves::SLEEPPOWDER))
            score*=1.2
          end
          if attacker.pbHasMove?((PBMoves::FOCUSPUNCH))
            score*=1.5
          end
          if opponent.status==PBStatuses::SLEEP
            score*=1.5
          end
          if opponent.effects[PBEffects::KingsShield] || opponent.effects[PBEffects::SpikyShield] || opponent.effects[PBEffects::BanefulBunker]
            if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
              score*=2
            end
          end
          if (!opponent.abilitynulled && opponent.ability == PBAbilities::INFILTRATOR)
            score*=0.3
          end
          if opponent.pbHasMove?((PBMoves::UPROAR)) || opponent.pbHasMove?((PBMoves::HYPERVOICE)) || opponent.pbHasMove?((PBMoves::ECHOEDVOICE)) || opponent.pbHasMove?((PBMoves::SNARL)) || opponent.pbHasMove?((PBMoves::BUGBUZZ)) || opponent.pbHasMove?((PBMoves::BOOMBURST))
            score*=0.3
          end
          score*=2 if checkAIdamage(aimem,attacker,opponent,skill)*4<attacker.totalhp 
          if opponent.effects[PBEffects::Confusion]>0
            score*=1.3
          end
          if opponent.status==PBStatuses::PARALYSIS
            score*=1.3
          end
          if opponent.effects[PBEffects::Attract]>=0
            score*=1.3
          end
          if attacker.pbHasMove?((PBMoves::BATONPASS))
            score*=1.2
          end
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SPEEDBOOST)
            score*=1.1
          end
          if @doublebattle
            score*=0.9
          end
        end
      else
        score*=0
      end
    when 0x10D # Curse
      if attacker.pbHasType?(:GHOST)
        if opponent.effects[PBEffects::Curse] || attacker.hp*2<attacker.totalhp
          score*=0
        else
          score*=0.7
          if (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
            score*=0.5
          end
          if checkAIdamage(aimem,attacker,opponent,skill)< attacker.hp 
            score*=1.3
          end
          for j in attacker.moves
            if j.isHealingMove?
              score*=1.2
              break
            end
          end
          ministat= 5*statchangecounter(opponent,1,7)
          ministat+=100
          ministat/=100.0
          score*=ministat
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SHADOWTAG) || (!attacker.abilitynulled && attacker.ability == PBAbilities::ARENATRAP) || opponent.effects[PBEffects::MeanLook]>=0 ||  opponent.pbNonActivePokemonCount==0
            score*=1.3
          else
            score*=0.8
          end
          if @doublebattle
            score*=0.5
          end
          if initialscores.length>0
            score*=1.3 if hasbadmoves(initialscores,scoreindex,25)
          end
          case $fefieldeffect
          when 29
            score*=0
          when 40
            hpchange=(EndofTurnHPChanges(attacker,opponent,false,false,true))
            if hpchange>=1
              score*=(1.5*hpchange) 
              if attacker.item == PBItems::SPIRITCREST
                if hasbadmoves(initialscores,scoreindex,35)
                  healing=((attacker.totalhp*(hpchange-1)))
                  if healing>=(attacker.totalhp*0.2)
                    score*=1.5
                  end
                end
              end
            end
          end
        end
      else
        miniscore=100
        if attacker.effects[PBEffects::Substitute]>0 || attacker.effects[PBEffects::Disguise] || (attacker.effects[PBEffects::IceFace] && !specmove) || (attacker.effects[PBEffects::IceFace] && $fefieldeffect==39)
          miniscore*=1.5
        end
        if initialscores.length>0
          miniscore*=1.3 if hasbadmoves(initialscores,scoreindex,20)
        end
        if (attacker.hp.to_f)/attacker.totalhp>0.75
          miniscore*=1.2
        end
        if (attacker.hp.to_f)/attacker.totalhp<0.33
          miniscore*=0.3
        end
        if (attacker.hp.to_f)/attacker.totalhp<0.75 && ((!attacker.abilitynulled && attacker.ability == PBAbilities::EMERGENCYEXIT) || (!attacker.abilitynulled && attacker.ability == PBAbilities::WIMPOUT) || (attitemworks && attacker.item == PBItems::EJECTBUTTON))
          miniscore*=0.3
        end
        if attacker.pbOpposingSide.effects[PBEffects::Retaliate]
          miniscore*=0.3
        end
        if opponent.effects[PBEffects::HyperBeam]>0
          miniscore*=1.3
        end
        if opponent.effects[PBEffects::Yawn]>0
          miniscore*=1.7
        end
        healmove=false
        for j in attacker.moves
          if j.isHealingMove?
            healmove=true
          end
        end
        if healmove
          miniscore*=1.2
        end
        boostedmon=attacker.clone
        unboosteddef=attacker.stages[PBStats::DEFENSE]
        boosteddef=false
        if !attacker.pbTooHigh?(PBStats::DEFENSE)
          boostedmon.stages[PBStats::DEFENSE]+=1  
          boosteddef=true
          if boostedmon.stages[PBStats::DEFENSE]>6
            boostedmon.stages[PBStats::DEFENSE]=6
          end
        end
        if checkAIdamage(aimem,attacker,opponent,skill)<(attacker.hp/2.0) 
          miniscore*=1.2
          if pbRoughStat(opponent,PBStats::SPATK,skill)<pbRoughStat(opponent,PBStats::ATTACK,skill)
            if checkAIdamage(aimem,boostedmon,opponent,skill)<(attacker.hp/3.0) 
              miniscore*=1.4
            end
          end
        elsif checkAIdamage(aimem,attacker,opponent,skill)>(attacker.hp/2.0)
          if (checkAIdamage(aimem,boostedmon,opponent,skill)+checkAIdamage(aimem,attacker,opponent,skill))>attacker.hp
            miniscore*=0.3
          else
            if healmove
              miniscore*=1.3
            end
          end
        end
        if boosteddef
          attacker.stages[PBStats::DEFENSE]=unboosteddef
        end
        if attacker.turncount<2
          miniscore*=1.1
        end
        if opponent.status!=0
          miniscore*=1.2
        end
        if opponent.status==PBStatuses::SLEEP || opponent.status==PBStatuses::FROZEN
          miniscore*=1.3
        end
        if opponent.effects[PBEffects::Encore]>0
          if opponent.moves[(opponent.effects[PBEffects::EncoreIndex])].basedamage==0
            miniscore*=1.5
          end
        end
        if attacker.effects[PBEffects::Confusion]>0
          miniscore*=0.3
        end
        if attacker.effects[PBEffects::LeechSeed]>=0 || attacker.effects[PBEffects::Attract]>=0
          miniscore*=0.3
        end
        score*=0.3 if checkAImoves(PBStuff::SWITCHOUTMOVE,aimem)
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::SIMPLE)
          miniscore*=2
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE)
          miniscore*=0.5
        end
        if @doublebattle
          miniscore*=0.5
        end
        if attacker.stages[PBStats::SPEED]<0
          ministat=attacker.stages[PBStats::SPEED]
          minimini=5*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        ministat=0
        ministat+=opponent.stages[PBStats::ATTACK]
        ministat+=opponent.stages[PBStats::SPATK]
        ministat+=opponent.stages[PBStats::SPEED]
        if ministat>0
          minimini=(-5)*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        miniscore/=100.0
        score*=miniscore
        miniscore=100
        miniscore*=1.3 if checkAIhealing(aimem)
        if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill) && @trickroom==0) &&  !(attacker.item == PBItems::WHITEHERB)
          miniscore*=0.5
        else
          if attacker.item == PBItems::WHITEHERB
            miniscore*=1.2
          else
            miniscore*=1.1
          end
        end
        if attacker.status==PBStatuses::BURN
          miniscore*=0.5
        end
        if attacker.status==PBStatuses::PARALYSIS
          miniscore*=0.5
        end
        miniscore*=0.8 if checkAImoves([PBMoves::FOULPLAY],aimem)
        physmove=false
        for j in attacker.moves
          if j.pbIsPhysical?(j.type)
            physmove=true
          end
        end
        if physmove && !attacker.pbTooHigh?(PBStats::ATTACK)
          miniscore/=100.0
          score*=miniscore
        end
        miniscore=100
        if attacker.effects[PBEffects::Toxic]>0
          miniscore*=0.2
        end
        if pbRoughStat(opponent,PBStats::SPATK,skill)<pbRoughStat(opponent,PBStats::ATTACK,skill)
          if !(roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL))
            if ((attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) && (attacker.hp.to_f)/attacker.totalhp>0.75
              miniscore*=1.3
            elsif (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
              miniscore*=0.7
            end
          end
          miniscore*=1.3
        end
        if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
          miniscore*=1.1
        end
        if (attitemworks && attacker.item == PBItems::LEFTOVERS) || ((attitemworks && attacker.item == PBItems::BLACKSLUDGE) && attacker.pbHasType?(:POISON))
          miniscore*=1.1
        end
        if attacker.pbHasMove?((PBMoves::LEECHSEED))
          miniscore*=1.3
        end
        if attacker.pbHasMove?((PBMoves::PAINSPLIT))
          miniscore*=1.2
        end
        if !attacker.pbTooHigh?(PBStats::DEFENSE)
          miniscore/=100.0
          score*=miniscore
        end
        if (opponent.level-5)>attacker.level
          score*=0.6
          if (opponent.level-10)>attacker.level
            score*=0.2
          end
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
          score=0
        end
        if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
          score*=0.7
        end
        if attacker.pbTooHigh?(PBStats::DEFENSE) && attacker.pbTooHigh?(PBStats::ATTACK)
          score *= 0
        end
      end
    when 0x10E # Spite
      count=0
      for i in opponent.moves
        if i.basedamage>0
          count+=1
        end
      end
      lastmove = PBMove.new(opponent.lastMoveUsed)
      if lastmove.basedamage>0 && count==1
        score+=10
      end
      if (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        score*=0.5
      end
      if $fefieldeffect==40
        score*=1.4
      end
      if lastmove.totalpp<=5 || (lastmove.totalpp<=10 && (attacker.ability==PBAbilities::PRESSURE))
        score*=2
      else
        if lastmove.totalpp<=10 || (lastmove.totalpp<=20 && (attacker.ability==PBAbilities::PRESSURE))
          score*=1.2
        else
          score*=0.7
        end
      end
    when 0x10F # Nightmare
      if !opponent.effects[PBEffects::Nightmare] && (opponent.status==PBStatuses::SLEEP || (!attacker.abilitynulled && attacker.ability == PBAbilities::WORLDOFNIGHTMARES))
        if opponent.statusCount>2 || (!attacker.abilitynulled && attacker.ability == PBAbilities::WORLDOFNIGHTMARES)
          score*=4
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::EARLYBIRD) && !(!attacker.abilitynulled && attacker.ability == PBAbilities::WORLDOFNIGHTMARES)
          score*=0.5
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::COMATOSE)
          score*=6
        end
        if initialscores.length>0
          if hasbadmoves(initialscores,scoreindex,25)
            score*=6 
          elsif  hasbadmoves(initialscores,scoreindex,50)
            score*=2
          end
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::SHEDSKIN) && !(!attacker.abilitynulled && attacker.ability == PBAbilities::WORLDOFNIGHTMARES)
          score*=0.5
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::SHADOWTAG) || (!attacker.abilitynulled && attacker.ability == PBAbilities::WORLDOFNIGHTMARES) || (!attacker.abilitynulled && attacker.ability == PBAbilities::ARENATRAP) || opponent.effects[PBEffects::MeanLook]>=0 ||  opponent.pbNonActivePokemonCount==0
          score*=1.3
        else
          score*=0.8
        end
        if @doublebattle && (!attacker.abilitynulled && attacker.ability == PBAbilities::WORLDOFNIGHTMARES)
          score*=0.5
        end
        if $fefieldeffect==9
          score*=0
        end
      else
        score*=0
      end
    when 0x110 # Rapid Spin
      if attacker.effects[PBEffects::LeechSeed]>=0
        score+=20
      end
      if attacker.effects[PBEffects::MultiTurn]>0
        score+=10
      end
      if attacker.pbNonActivePokemonCount>0
        score+=40 if attacker.pbOwnSide.effects[PBEffects::StealthRock]
        score+=40 if attacker.pbOwnSide.effects[PBEffects::StickyWeb]
        score += (20*attacker.pbOwnSide.effects[PBEffects::Spikes])
        score += (30*attacker.pbOwnSide.effects[PBEffects::ToxicSpikes])
      end
      chipvar=false
      sashvar=false
      weakvar=false
      if attacker.pbOwnSide.effects[PBEffects::StealthRock] || attacker.pbOwnSide.effects[PBEffects::Spikes]>0 || attacker.pbOwnSide.effects[PBEffects::ToxicSpikes]>0
        for mon in pbParty(attacker.index)
          next if mon.nil?
          next if mon==attacker.index
          hazpercent=0
          hazpercent = totalHazardDamage(attacker.pbOwnSide,mon.type1,mon.type2,mon.isAirborne?,skill,mon)
          if hazpercent>=25
            weakvar=true
          end
          if mon.item == PBItems::FOCUSSASH || mon.ability== PBAbilities::STURDY
            sashvar=true
          end
          if mon.item == PBItems::LIFEORB || (mon.item==PBItems::TELLURICSEED && $fefieldeffects==12) || (mon.item==PBItems::ELEMENTALSEED && $fefieldeffects==7)
            chipvar=true
          end
        end
      end
      miniscore = 100
      maxdam = checkAIdamage(aimem,attacker,opponent,skill)
      if ((attacker.pbSpeed*1.5)>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        if maxdam*2<attacker.hp
          miniscore*=1.5
        end
      end
      miniscore*=1.5 if (roles.include?(PBMonRoles::SWEEPER))
      miniscore*=2 if (weakvar || sashvar || chipvar)
      miniscore*=0.4 if (@trickroom!=0 || checkAImoves([PBMoves::TRICKROOM],aimem))
      miniscore*=0.6 if attacker.status==PBStatuses::PARALYSIS && !(attacker.pbOwnSide.effects[PBEffects::StickyWeb] || attacker.pbOwnSide.effects[PBEffects::StealthRock] || attacker.pbOwnSide.effects[PBEffects::Spikes]>0 || attacker.pbOwnSide.effects[PBEffects::ToxicSpikes]>0)
      miniscore=1 if attacker.pbTooHigh?(PBStats::SPEED) && !(attacker.pbOwnSide.effects[PBEffects::StickyWeb] || attacker.pbOwnSide.effects[PBEffects::StealthRock] || attacker.pbOwnSide.effects[PBEffects::Spikes]>0 || attacker.pbOwnSide.effects[PBEffects::ToxicSpikes]>0)
      miniscore*=0.5 if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
      miniscore/=100.0
      score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) 
    when 0x111 # Future Sight
      if opponent.effects[PBEffects::FutureSight]>0
        score*=0
      else
        score*=0.6
        if @doublebattle
          score*=0.7
        end
        if attacker.pbNonActivePokemonCount==0
          score*=0.7
        end
        if attacker.effects[PBEffects::Substitute]>0
          score*=1.2
        end
        protectmove=false
        for j in attacker.moves
          protectmove = true if j.id==getID(PBMoves,:PROTECT) || j.id==getID(PBMoves,:DETECT) || j.id==getID(PBMoves,:BANEFULBUNKER) || j.id==getID(PBMoves,:SPIKYSHIELD)
        end
        if protectmove
          score*=1.2
        end
        if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
          score*=1.1
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::MOODY) || attacker.pbHasMove?(getID(PBMoves,:QUIVERDANCE)) || attacker.pbHasMove?(getID(PBMoves,:NASTYPLOT)) || attacker.pbHasMove?(getID(PBMoves,:TAILGLOW))
          score*=1.2
        end
      end
    when 0x112 # Stockpile
      miniscore=100
      if attacker.effects[PBEffects::Substitute]>0 || attacker.effects[PBEffects::Disguise] || (attacker.effects[PBEffects::IceFace] && !specmove) || (attacker.effects[PBEffects::IceFace] && $fefieldeffect==39)
        miniscore*=1.5
      end
      if initialscores.length>0
        miniscore*=1.3 if hasbadmoves(initialscores,scoreindex,20)
      end
      if (attacker.hp.to_f)/attacker.totalhp>0.75
        miniscore*=1.1
      end
      if opponent.effects[PBEffects::HyperBeam]>0
        miniscore*=1.2
      end
      if opponent.effects[PBEffects::Yawn]>0
        miniscore*=1.3
      end
      if skill>=PBTrainerAI.mediumSkill
        maxdam = checkAIdamage(aimem,attacker,opponent,skill)
        if maxdam<(attacker.hp/4.0) 
          miniscore*=1.1
        else
          if move.basedamage==0
            miniscore*=0.8
            if maxdam>attacker.hp
              miniscore*=0.1
            end
          end
        end
      end
      if attacker.turncount<2
        miniscore*=1.1
      end
      if opponent.status!=0
        miniscore*=1.1
      end
      if opponent.status==PBStatuses::SLEEP || opponent.status==PBStatuses::FROZEN
        miniscore*=1.3
      end
      if opponent.effects[PBEffects::Encore]>0
        if opponent.moves[(opponent.effects[PBEffects::EncoreIndex])].basedamage==0
          miniscore*=1.5
        end
      end
      if attacker.effects[PBEffects::Confusion]>0
        miniscore*=0.5
      end
      if attacker.effects[PBEffects::LeechSeed]>=0 || attacker.effects[PBEffects::Attract]>=0
        miniscore*=0.3
      end
      if attacker.effects[PBEffects::Toxic]>0
        miniscore*=0.2
      end
      miniscore*=0.2 if checkAImoves(PBStuff::SWITCHOUTMOVE,aimem)
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::SIMPLE)
        miniscore*=2
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE)
        miniscore*=0.5
      end
      if @doublebattle
        miniscore*=0.3
      end
      if skill>=PBTrainerAI.mediumSkill
        maxdam = checkAIdamage(aimem,attacker,opponent,skill)
        if (maxdam.to_f/attacker.hp)<0.12 
          miniscore*=0.3
        end
      end
      miniscore/=100.0
      score*=miniscore
      miniscore=100
      if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
        miniscore*=1.5
      end
      if (attitemworks && attacker.item == PBItems::LEFTOVERS) || ((attitemworks && attacker.item == PBItems::BLACKSLUDGE) && attacker.pbHasType?(:POISON))
        miniscore*=1.2
      end
      healmove=false
      for j in attacker.moves
        if j.isHealingMove?
          healmove=true
        end
      end
      if healmove
        miniscore*=1.7
      end
      if attacker.pbHasMove?((PBMoves::LEECHSEED))
        miniscore*=1.3
      end
      if attacker.pbHasMove?((PBMoves::PAINSPLIT))
        miniscore*=1.2
      end
      if attacker.pbHasMove?((PBMoves::SPITUP)) || attacker.pbHasMove?((PBMoves::SWALLOW))
        miniscore*=1.6
      end
      if attacker.effects[PBEffects::Stockpile]<3
        miniscore/=100.0
        score*=miniscore
      else
        score=0
      end
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        score=0
      end
      if attacker.pbTooHigh?(PBStats::SPDEF) && attacker.pbTooHigh?(PBStats::DEFENSE)
        score*=0
      end
    when 0x113 # Spit Up
      startscore = score
      if attacker.effects[PBEffects::Stockpile]==0
        score*=0
      else
        score+=60 if (!attacker.abilitynulled && attacker.ability == PBAbilities::ACCUMULATION)
        score*=0.8
        if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
          score*=0.7
        end
        if roles.include?(PBMonRoles::TANK)
          score*=0.9
        end
        count=0
        for m in attacker.moves
          count+=1 if m.basedamage>0
        end
        if count>1
          score*=0.5
        end
        if opponent.pbNonActivePokemonCount==0
          score*=0.7
        else
          score*=1.2
        end
        if startscore < 110
          score*=0.5
        else
          score*=1.3
        end
        if (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
          score*=1.1
        else
          score*=0.8
        end
        if attacker.pbHasMove?(getID(PBMoves,:SWALLOW))
          if attacker.hp/(attacker.totalhp).to_f < 0.66
            score*=0.8
            if attacker.hp/(attacker.totalhp).to_f < 0.4
              score*=0.5
            end
          end
        end
      end
    when 0x114 # Swallow
      startscore = score
      if attacker.effects[PBEffects::Stockpile]==0
        score*=0
      else
        score+= 10*attacker.effects[PBEffects::Stockpile]
        score*=0.8
        if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
          score*=0.9
        end
        if roles.include?(PBMonRoles::TANK)
          score*=0.9
        end
        count=0
        for m in attacker.moves
          count+=1 if m.isHealingMove?
        end
        if count>1
          score*=0.5
        end
        if (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
          score*=1.1
        else
          score*=0.8
        end
        if checkAIdamage(aimem,attacker,opponent,skill)>attacker.hp
          score*=2
        elsif checkAIdamage(aimem,attacker,opponent,skill)*1.5 > attacker.hp
          score*=1.5
        end
        if (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
          if checkAIdamage(aimem,attacker,opponent,skill)*2 > attacker.hp
            score*=2
          else
            score*=0.2
          end
        end
        if opponent.effects[PBEffects::Taunt]==0
          score*=0.7 if opponent.moves.any? {|moveloop| (PBStuff::SETUPMOVE).include?(moveloop.id)}
        end
        if attacker.hp*2 < attacker.totalhp
          score*=1.5
        end
        if attacker.status==PBStatuses::BURN || attacker.status==PBStatuses::POISON || attacker.effects[PBEffects::Curse] || attacker.effects[PBEffects::LeechSeed]>=0
          score*=1.3
          if attacker.effects[PBEffects::Toxic]>0
            score*=1.3
          end
        end
        if opponent.effects[PBEffects::HyperBeam]>0
          score*=1.2
        end
        if attacker.hp/(attacker.totalhp.to_f) > 0.8
          score*=0
        end
      end
    when 0x115 # Focus Punch
      startscore=score
      soundcheck=false
      multicheck=false
      if aimem.length > 0
        for j in aimem
          soundcheck=true if (j.isSoundBased? && j.basedamage>0)
          multicheck=true if j.pbNumHits(opponent)>1
        end
      end
      if attacker.effects[PBEffects::Substitute]>0
        if multicheck || soundcheck || (!opponent.abilitynulled && opponent.ability == PBAbilities::INFILTRATOR)
          score*=0.9
        else
          score*=1.3
        end
      else
        score *= 0.8
      end
      if opponent.status==PBStatuses::SLEEP && !(!opponent.abilitynulled && opponent.ability == PBAbilities::EARLYBIRD) && !(!opponent.abilitynulled && opponent.ability == PBAbilities::SHEDSKIN)
        score*=1.2
      end
      if @doublebattle
        score *= 0.5
      end
      #if attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill) ^ @trickroom!=0
      #  score*=0.9
      #end
      if opponent.effects[PBEffects::HyperBeam]>0
        score*=1.5
      end
      if score<=startscore && opponent.effects[PBEffects::Attacking]==true
        score*=0.3
      end
    when 0x116 # Sucker Punch
      knowncount = 0
      alldam = true
      prioenabled=false
      higherpriotier=false
      priomove=0
      olddata = PBMove.new(opponent.lastMoveUsed)
      oldmove = PokeBattle_Move.pbFromPBMove(self,olddata,opponent)
      opppriomoves=[]
      for i in opponent.moves
        knowncount+=1
        if i.basedamage<=0
          alldam = false
        end
        if ((i.type==PBTypes::FLYING && opponent.ability == PBAbilities::GALEWINGS && (opponent.hp==opponent.totalhp || (($fefieldeffect == 16 || $fefieldeffect == 27 || $fefieldeffect == 28) && pbWeather == PBWeather::STRONGWINDS) || $fefieldeffect == 43)) ||
          (opponent.species==PBSpecies::FERALIGATR && opponent.item == PBItems::FERACREST && opponent.turncount==0) ||
          (opponent.ability == PBAbilities::TRIAGE && (PBStuff::HEALFUNCTIONS).include?(i.function))) || (i.priority>0 && !((i.id==getID(PBMoves,:FAKEOUT) || i.id==getID(PBMoves,:FIRSTIMPRESSION) && opponent.turncount>0)))
          prioenabled=true
          priomove=i
          opppriomoves.push(priomove)
          if ((opponent.species==PBSpecies::FERALIGATR && opponent.item == PBItems::FERACREST && opponent.turncount==0) ||
            (opponent.ability == PBAbilities::TRIAGE && (PBStuff::HEALFUNCTIONS).include?(i.function))) ||  (i.priority>1 && !((i.id==getID(PBMoves,:FAKEOUT) || i.id==getID(PBMoves,:FIRSTIMPRESSION) && opponent.turncount>0)))
            higherpriotier=true
          end
        end
      end
      maxdam=checkAIdamage(aimem,attacker,opponent,skill)
      if (((attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) && higherpriotier==false)
        score*=0.8
        if initialscores.length>0
          test = initialscores[scoreindex]
          if initialscores.max!=test
            score*=0.6
          end
        end
      else 
        if prioenabled
          if !(@doublebattle && maxdam>attacker.hp && priomove.basedamage==0)
            score*=0.3
          end
        else
          score*=1.3
        end
      end 
      if (attacker.lastMoveUsed==26 && !(attacker==@battlers[2]) && attacker.effects[PBEffects::Tantrum]==true)
        if opponent.effects[PBEffects::Attacking]==false || (opppriomoves.include?(oldmove.id))
          if !(opponent.effects[PBEffects::SomethingCrazy].nil?)
            if (((PBStuff::PROTECTMOVE).include?(opponent.effects[PBEffects::SomethingCrazy].id)) || ((PBStuff::SETUPMOVE).include?(opponent.effects[PBEffects::SomethingCrazy].id)) || ((PBStuff::BURNMOVE).include?(opponent.effects[PBEffects::SomethingCrazy].id)) ||
              ((PBStuff::SLEEPMOVE).include?(opponent.effects[PBEffects::SomethingCrazy].id)) || ((PBStuff::PARAMOVE).include?(opponent.effects[PBEffects::SomethingCrazy].id)) || ((PBStuff::HEALFUNCTIONS).include?(opponent.effects[PBEffects::SomethingCrazy].function))) || (oldmove.basedamage==0 && opponent.turncount>0) || (opppriomoves.include?((opponent.effects[PBEffects::SomethingCrazy].id))) || opponent.effects[PBEffects::Switching]==true
              rnd=pbAIRandom(10)
              if rnd>2 
                score*=0.1
              end
            else
              rnd=pbAIRandom(10)
              if rnd>=5
                score*=0.1
              end
            end
          else
            rnd=pbAIRandom(10)
            if rnd<=6
              score*=0.1
            end
          end
        end
      else
        if knowncount==4 && alldam
          score*=1.3
        else
          score*=0.7 if checkAIhealing(aimem)
          if attacker.lastMoveUsed==26 # Sucker Punch last turn
            check = rand(3)
            if opponent.effects[PBEffects::Taunt]==0
              score*=0.8 if opponent.moves.any? {|moveloop| (PBStuff::SETUPMOVE).include?(moveloop)}
            end
          end
          if !(opponent.effects[PBEffects::SomethingCrazy].nil?)
            if opponent.effects[PBEffects::SomethingCrazy].basedamage==0
              rnd=pbAIRandom(10)
              if rnd>=7 
                score*=0.1
              end
            end
          else
            rnd=pbAIRandom(10)
            if rnd>8
              score*=0.1
            end
          end
        end
      end
    when 0x117 # Follow Me
      if @doublebattle && attacker.pbPartner.hp!=0
        if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL) || roles.include?(PBMonRoles::LEAD)
          score*=1.2
        end
        if (!attacker.pbPartner.abilitynulled && attacker.pbPartner.ability == PBAbilities::MOODY)
          score*=1.3
        end
        if attacker.pbPartner.turncount<1
          score*=1.5
        else
          score*=1.2
        end
        maxdam1=checkAIdamage(aimem,attacker,opponent,skill)
        maxdam2=checkAIdamage(aimem,attacker,opponent.pbPartner,skill)
        if (checkAIHas?([PBMoves::TRICKROOM],attacker.pbPartner) && @trickroom==0 || checkAIHas?([PBMoves::TAILWIND],attacker.pbPartner) && attacker.pbOwnSide.effects[PBEffects::Tailwind]=0)
           score*=1.5
           if attacker.moves.any? {|moveloop| (PBStuff::SLEEPMOVE).include?(moveloop.id)}
              score*=1.5
            end
        elsif (checkAIHas?([PBStuff::SETUPMOVE],attacker.pbPartner))
           score*=1.2
        end
        if attacker.hp==attacker.totalhp
          score*=1.5
        else
          score*=1.2
          if attacker.hp*2 < attacker.totalhp
            score*=0.5
          end
        end
        if attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill) || attacker.pbSpeed<pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)
          score*=1.2
        end
      else
        score*=0
      end
    when 0x118 # Gravity
      maxdam=0
      maxid = -1
      if aimem.length > 0
        for j in aimem
          tempdam = pbRoughDamage(j,opponent,attacker,skill,j.basedamage)
          if tempdam>maxdam
            maxdam=tempdam
            maxid = j.id
          end
        end
      end
      if @field.effects[PBEffects::Gravity]>0
        score*=0
      else
        for i in attacker.moves
          if i.accuracy<=70
            score*=1.5
            break
          end
        end
        if attacker.pbHasMove?((PBMoves::ZAPCANNON)) || attacker.pbHasMove?((PBMoves::INFERNO))
          score*=2
        end
        if maxid==(PBMoves::SKYDROP) || maxid==(PBMoves::BOUNCE) || maxid==(PBMoves::FLY) || maxid==(PBMoves::JUMPKICK) || maxid==(PBMoves::FLYINGPRESS) || maxid==(PBMoves::HIJUMPKICK) || maxid==(PBMoves::SPLASH)
          score*=2
        end
        for m in attacker.moves
          if m.id==(PBMoves::SKYDROP) || m.id==(PBMoves::BOUNCE) || m.id==(PBMoves::FLY) || m.id==(PBMoves::JUMPKICK) || m.id==(PBMoves::FLYINGPRESS) || m.id==(PBMoves::HIJUMPKICK) || m.id==(PBMoves::SPLASH)
            score*=0
            break
          end
        end
        if attacker.pbHasType?(:GROUND) && (opponent.pbHasType?(:FLYING) || (!opponent.abilitynulled && (opponent.ability == PBAbilities::LEVITATE || opponent.ability == PBAbilities::SOLARIDOL || opponent.ability == PBAbilities::LUNARIDOL)) || (oppitemworks && opponent.item == PBItems::AIRBALLOON))
          score*=2
        end
        if (attitemworks && attacker.item == PBItems::AMPLIFIELDROCK) || $fefieldeffect==37
          score*=1.5
        end
        psyvar=false
        poisonvar=false
        fairyvar=false
        darkvar=false
        for mon in pbParty(attacker.index)
          next if mon.nil?
          if mon.hasType?(:PSYCHIC)
            psyvar=true
          end
          if mon.hasType?(:POISON)
            poisonvar=true
          end
          if mon.hasType?(:FAIRY)
            fairyvar=true
          end
          if mon.hasType?(:DARK)
            darkvar=true
          end
        end
        if $fefieldeffect==11
          if !attacker.pbHasType?(:POISON)
            score*=3
          else
            score*=0.5
          end
          if !poisonvar
            score*=3
          end
        elsif $fefieldeffect==21
          if attacker.pbHasType?(:WATER)
            score*=2
          else
            score*=0.5
          end
        elsif $fefieldeffect==35
          if !attacker.pbHasType?(:FLYING) && !(!attacker.abilitynulled && (attacker.ability == PBAbilities::LEVITATE || attacker.ability == PBAbilities::SOLARIDOL || attacker.ability == PBAbilities::LUNARIDOL))
            score*=2
          end
          if opponent.pbHasType?(:FLYING) || (!opponent.abilitynulled && (opponent.ability == PBAbilities::LEVITATE || opponent.ability == PBAbilities::SOLARIDOL || opponent.ability == PBAbilities::LUNARIDOL))
            score*=2
          end
          if psyvar || fairyvar || darkvar
            score*=2
            if attacker.pbHasType?(:PSYCHIC) || attacker.pbHasType?(:FAIRY) || attacker.pbHasType?(:DARK)
              score*=2
            end
          end
        end
      end
    when 0x119 # Magnet Rise
      if !(attacker.effects[PBEffects::MagnetRise]>0 || attacker.effects[PBEffects::Ingrain] || attacker.effects[PBEffects::SmackDown])
        if checkAIbest(aimem,1,[PBTypes::GROUND],false,attacker,opponent,skill)# Highest expected dam from a ground move
          score*=3
        end
        if opponent.pbHasType?(:GROUND)
          score*=3
        end
        if attacker.item==PBItems::AIRBALLOON ||  attacker.item==PBItems::SHUCABERRY
          score*=1.5
        end
        if $fefieldeffect==1 || $fefieldeffect==17 || $fefieldeffect==18
          score*=1.3
        end
      else
        score*=0
      end
    when 0x11A # Telekinesis
      if !(opponent.effects[PBEffects::Telekinesis]>0 || opponent.effects[PBEffects::Ingrain] ||
          opponent.effects[PBEffects::SmackDown] || @field.effects[PBEffects::Gravity]>0 || 
          (oppitemworks && opponent.item == PBItems::IRONBALL) || opponent.pokemon.species==50 ||
          opponent.species==51 || opponent.species==769 || opponent.species==770 ||
          (opponent.species==94 && opponent.form==1))
        for i in attacker.moves
          if i.accuracy<=70
            score+=10
            break
          end
        end
        if attacker.pbHasMove?((PBMoves::ZAPCANNON)) || attacker.pbHasMove?((PBMoves::INFERNO))
          score*=2
        end
        if $fefieldeffect==37
          if !(!opponent.abilitynulled && opponent.ability == PBAbilities::CLEARBODY) && !(!opponent.abilitynulled && opponent.ability == PBAbilities::WHITESMOKE)
            score+=15
            miniscore=100
            miniscore*=1.3 if checkAIhealing(aimem)
            if (!attacker.abilitynulled && attacker.ability == PBAbilities::SHADOWTAG) || (!attacker.abilitynulled && attacker.ability == PBAbilities::ARENATRAP) || opponent.effects[PBEffects::MeanLook]>=0 ||  opponent.pbNonActivePokemonCount==0
              miniscore*=1.4
            end
            if opponent.status==PBStatuses::BURN || opponent.status==PBStatuses::POISON
              miniscore*=1.2
            end
            ministat= 5*statchangecounter(opponent,1,7,-1)
            ministat+=100
            ministat/=100.0
            miniscore*=ministat
            if attacker.pbNonActivePokemonCount==0
              miniscore*=0.5
            end
            if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || (!opponent.abilitynulled && opponent.ability == PBAbilities::DEFIANT) || (!opponent.abilitynulled && opponent.ability == PBAbilities::COMPETITIVE) || (!opponent.abilitynulled && opponent.ability == PBAbilities::CONTRARY) || SilvallyCheck(opponent, "fighting") || SilvallyCheck(opponent, PBTypes::FAIRY)
              miniscore*=0.1
            end
            if attacker.status!=0
              miniscore*=0.7
            end
            miniscore/=100.0
            score*=miniscore
          end
        end
      else
        score*=0
      end
    when 0x11B # Sky Uppercut - to do
    when 0x11C # Smack Down
      if !(opponent.effects[PBEffects::Ingrain] || opponent.effects[PBEffects::SmackDown] || @field.effects[PBEffects::Gravity]>0 || opponent.hasWorkingItem(:IRONBALL))
        miniscore=60
        if (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
          if opponent.pbHasMove?(getID(PBMoves,:BOUNCE)) || opponent.pbHasMove?(getID(PBMoves,:FLY)) || opponent.pbHasMove?(getID(PBMoves,:SKYDROP))
            miniscore*=1.3
          else
            if opponent.effects[PBEffects::TwoTurnAttack]!=0
              miniscore*=2
            end
          end
        end
        groundmove = false
        for i in attacker.moves
          if i.type == 4
            groundmove = true
          end
        end
        if opponent.pbHasType?(:FLYING) || (!opponent.abilitynulled && (opponent.ability == PBAbilities::LEVITATE || opponent.ability == PBAbilities::SOLARIDOL || opponent.ability == PBAbilities::LUNARIDOL))
          miniscore*=2
        end
        miniscore/=100.0
        score*=miniscore
      end
    when 0x11D # After You - to do
    when 0x11E # Quash - to do
    when 0x11F # Trick Room
      count = -1
      sweepvar = false
      for i in pbParty(attacker.index)
        count+=1
        next if i.nil?
        temprole = pbGetMonRole(i,opponent,skill,count,pbParty(attacker.index))
        if temprole.include?(PBMonRoles::SWEEPER)
          sweepvar = true
        end
      end
      if !sweepvar
        score*=1.3
      end
      if roles.include?(PBMonRoles::TANK) || roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL) || roles.include?(PBMonRoles::LEAD) || @doublebattle
        score*=1.3
      end
      if attacker.hasWorkingItem(:AMPLIFIELDROCK)
        score*=1.5
      end
      maxdam = 0
      pridam = 0
      for i in opponent.moves
        if (i.priority>0 && !(i.id==(PBMoves::FAKEOUT) && opponent.turncount!=0)) ||
          (!opponent.abilitynulled && opponent.ability == PBAbilities::GALEWINGS && move.type==PBTypes::FLYING && opponent.hp==opponent.totalhp) || 
          ((opponent.species == PBSpecies::FERALIGATR) && oppitemworks && opponent.item == PBItems::FERACREST && opponent.turncount==0) ||
          (!opponent.abilitynulled && opponent.ability == PBAbilities::TRIAGE && move.isHealingMove?)
          tempdam = pbRoughDamage(i,opponent,attacker,skill,i.basedamage)
          pridam = tempdam if tempdam>pridam
        end
        tempdam = pbRoughDamage(i,opponent,attacker,skill,i.basedamage)
        maxdam = tempdam if tempdam>maxdam
      end
      maxdam2=checkAIdamage(aimem,opponent,attacker,skill)
      ourfastermons=0
      fastersquad=false
      if skill>=PBTrainerAI.highSkill
        for k in 0...pbParty(attacker.index).length
          next if pbParty(attacker.index)[k].nil?
          next if pbParty(attacker.index)[k].isFainted?
          ourfastermons+=1 if opponent.speed<pbParty(attacker.index)[k].speed
        end
        if ourfastermons>2
          fastersquad=true
        end
      end
      if !(@doublebattle)
        if maxdam2<opponent.hp && (maxdam*2>attacker.hp || maxdam+pridam>attacker.hp || maxdam*2+pridam>attacker.hp) && fastersquad
          score*=0.5
        end
      end
      fastermons=0
      if skill>=PBTrainerAI.highSkill
        for k in 0...pbParty(opponent.index).length
          next if pbParty(opponent.index)[k].nil?
          next if pbParty(opponent.index)[k].isFainted?
          fastermons+=1 if attacker.speed<pbParty(opponent.index)[k].speed
        end
        if opponent.pbNonActivePokemonCount<=fastermons
          score*=1.5
        end
      end
      if skill>=PBTrainerAI.highSkill
        if $fefieldeffect==5 || $fefieldeffect==34 || $fefieldeffect==35 || $fefieldeffect==37 # Chess/New World/Psychic Terrain
          score*=1.5
        end
      end
      if attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill) || attacker.hasWorkingItem(:IRONBALL)
        if @trickroom > 0
          score*=0
        else
          score*=2
        end
      else
        if @trickroom > 0 && attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill) &&
          attacker.pbSpeed>pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill) && attacker.pbPartner.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill) &&
          attacker.pbPartner.pbSpeed>pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)
          score*=0.9
        else
          score*=0
        end
      end
    when 0x120 # Ally Switch
      if checkAIdamage(aimem,attacker,opponent,skill)<attacker.hp && attacker.pbNonActivePokemonCount!=0 
        score*=1.3
        sweepvar = false
        for i in pbParty(attacker.index)
          next if i.nil?
          temprole = pbGetMonRole(i,opponent,skill,count,pbParty(attacker.index))
          if temprole.include?(PBMonRoles::SWEEPER)
            sweepvar = true
          end
        end
        if sweepvar
          score*=2
        end
        if attacker.pbNonActivePokemonCount<3
          score*=2
        end
        if attacker.pbOwnSide.effects[PBEffects::StealthRock] || attacker.pbOwnSide.effects[PBEffects::Spikes]>0
          score*=0.5
        end
      else
        score*=0
      end
    when 0x121 # Foul Play - to do
    when 0x122 # Secret Sword - to do
    when 0x123 # Synchronoise
      if !opponent.pbHasType?(attacker.type1) && !opponent.pbHasType?(attacker.type2)
        score*=0
      end
    when 0x124 # Wonder Room
      if @field.effects[PBEffects::WonderRoom]!=0
        score*=0
      else
        if attacker.hasWorkingItem(:AMPLIFIELDROCK) || $fefieldeffect==35 || $fefieldeffect==37
          score*=1.5
        end
        if pbRoughStat(opponent,PBStats::ATTACK,skill)>pbRoughStat(opponent,PBStats::SPATK,skill)
          if attacker.defense>attacker.spdef
            score*=0.5
          else
            score*=2
          end
        else
          if attacker.defense<attacker.spdef
            score*=0.5
          else
            score*=2
          end
        end
        if attacker.attack>attacker.spatk
          if pbRoughStat(opponent,PBStats::DEFENSE,skill)>pbRoughStat(opponent,PBStats::SPDEF,skill)
            score*=2
          else
            score*=0.5
          end
        else
          if pbRoughStat(opponent,PBStats::DEFENSE,skill)<pbRoughStat(opponent,PBStats::SPDEF,skill)
            score*=2
          else
            score*=0.5
          end
        end
      end
    when 0x125 # Last Resort
      totalMoves = []
      for i in attacker.moves
        totalMoves[i.id] = false
        if i.function == 0x125
          totalMoves[i.id] = true
        end
        if i.id == 0
          totalMoves[i.id] = true
        end
      end
      for i in attacker.movesUsed
        for j in attacker.moves
          if i == j.id
            totalMoves[j.id] = true
          end
        end
      end
      for i in attacker.moves
        if !totalMoves[i.id]
          score=0
        end
      end
    when 0x126 # Shadow Stuff
    when 0x127 # Shadow moves + paralyze
      score*=1.2 # Shadow moves are more preferable
      if opponent.pbCanParalyze?(false)
        score*=1.3
        if skill>=PBTrainerAI.mediumSkill
          aspeed=pbRoughStat(attacker,PBStats::SPEED,skill)
          ospeed=pbRoughStat(opponent,PBStats::SPEED,skill)
          if aspeed<ospeed
            score*=1.3
          elsif aspeed>ospeed
            score*=0.6
          end
        end
        if skill>=PBTrainerAI.averageSkill
          score*=0.6 if (!opponent.abilitynulled && opponent.ability == PBAbilities::GUTS)
          score*=0.6 if (!opponent.abilitynulled && opponent.ability == PBAbilities::MARVELSCALE) || SilvallyCheck(opponent, "water")
          score*=0.6 if (!opponent.abilitynulled && opponent.ability == PBAbilities::QUICKFEET)
        end
      end
    when 0x128 # Shadow moves + burn
      score*=1.2 # Shadow moves are more preferable
      if opponent.pbCanBurn?(false)
        score*=1.3
        if skill>=PBTrainerAI.averageSkill
          score*=0.6 if (!opponent.abilitynulled && opponent.ability == PBAbilities::GUTS)
          score*=0.6 if (!opponent.abilitynulled && opponent.ability == PBAbilities::MARVELSCALE) || SilvallyCheck(opponent, "water")
          score*=0.6 if (!opponent.abilitynulled && opponent.ability == PBAbilities::QUICKFEET)
          score*=0.6 if (!opponent.abilitynulled && opponent.ability == PBAbilities::FLAREBOOST)
        end
      end
    when 0x129 # Shadow moves + freeze
      score*=1.2 # Shadow moves are more preferable
      if opponent.pbCanFreeze?(false)
        score*=1.3
        if skill>=PBTrainerAI.averageSkill
          score*=0.8 if (!opponent.abilitynulled && opponent.ability == PBAbilities::MARVELSCALE) || SilvallyCheck(opponent, "water")
        end
      end
    when 0x12A # Shadow moves + confuse
      score*=1.2 # Shadow moves are more preferable
      if opponent.pbCanConfuse?(false)
        score*=1.3
      else
        if skill>=PBTrainerAI.mediumSkill
          score*=0.1
        end
      end
    when 0x12B # Shadow moves + lower def
      score*=1.2 # Shadow moves are more preferable
      if !opponent.pbCanReduceStatStage?(PBStats::DEFENSE)
        score*=0.1
      else
        score*=1.4 if attacker.turncount==0
        score+=opponent.stages[PBStats::DEFENSE]*20
      end
    when 0x12C # Shadow moves + lower evasion
      score*=1.2 # Shadow moves are more preferable
      if !opponent.pbCanReduceStatStage?(PBStats::EVASION)
        score*=0.1
      else
        score+=opponent.stages[PBStats::EVASION]*15
      end
    when 0x12D # Shadow moves
      score*=1.2 # Shadow moves are more preferable
    when 0x12E # Shadow moves + everyone half
      score*=1.2 # Shadow moves are more preferable
      score*=1.2 if opponent.hp>=(opponent.totalhp/2)
      score*=0.8 if attacker.hp<(attacker.hp/2)
    when 0x12F # Shadow moves + cannot escape
      score*=1.2 # Shadow moves are more preferable
      score*=0 if opponent.effects[PBEffects::MeanLook]>=0
    when 0x130 # Shadow moves + recoil
      if !(!attacker.abilitynulled && attacker.ability == PBAbilities::ROCKHEAD)
        score*=0.9
        if attacker.hp==attacker.totalhp && ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) || attacker.hasWorkingItem(:FOCUSSASH) || (isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST)))
          score*=0.7
        end
        if attacker.hp*(1.0/attacker.totalhp)>0.1 && attacker.hp*(1.0/attacker.totalhp)<0.4
          score*=0.8
        end
      end
    when 0x131 # Shadow moves
      score*=1.2 # Shadow moves are more preferable
      if pbCheckGlobalAbility(:AIRLOCK) ||
        pbCheckGlobalAbility(:CLOUDNINE)
        score*=0.1
      elsif pbWeather==PBWeather::SHADOWSKY
        score*=0.1
      end
    when 0x132 # Shadow moves + removes Reflect etc
      score*=1.2 # Shadow moves are more preferable
      if opponent.pbOwnSide.effects[PBEffects::Reflect]>0 ||
        opponent.pbOwnSide.effects[PBEffects::LightScreen]>0 ||
        opponent.pbOwnSide.effects[PBEffects::Safeguard]>0
        score*=1.3
        score*=0.1 if attacker.pbOwnSide.effects[PBEffects::Reflect]>0 ||
        attacker.pbOwnSide.effects[PBEffects::LightScreen]>0 ||
        attacker.pbOwnSide.effects[PBEffects::Safeguard]>0
      else
        score*=0
      end
    when 0x133 # Kings Shield
      if opponent.effects[PBEffects::Taunt]==0
        score*=0.3 if opponent.moves.any? {|moveloop| (PBStuff::SETUPMOVE).include?(moveloop.id)}
       end
      if ((!attacker.abilitynulled && attacker.ability == PBAbilities::SPEEDBOOST) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STEAMENGINE) && $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==21 || $fefieldeffect==22 || $fefieldeffect==45)) && attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill) && @trickroom==0
        score*=4 if (attacker.pbSpeed*1.5>pbRoughStat(opponent,PBStats::SPEED,skill))
        score*=6 if initialscores.length>0 && hasgreatmoves(initialscores,scoreindex,skill)
      end
      score*=1.1 if (isConst?(opponent.species,PBSpecies,:FERALIGATR) && oppitemworks && opponent.item == PBItems::FERACREST && opponent.turncount==0)
      score*=1.2 if (opponent.status==PBStatuses::POISON || opponent.status==PBStatuses::BURN)
      score*=1.3 if opponent.effects[PBEffects::Toxic]>0
      if opponent.pbOwnSide.effects[PBEffects::Reflect]>0 || opponent.pbOwnSide.effects[PBEffects::LightScreen]>0 || opponent.pbOwnSide.effects[PBEffects::AuroraVeil]>0 ||
        opponent.pbOwnSide.effects[PBEffects::AreniteWall]>0 
        score*=1.5 
        if opponent.pbOwnSide.effects[PBEffects::Reflect]<=2 || opponent.pbOwnSide.effects[PBEffects::LightScreen]<=2 || opponent.pbOwnSide.effects[PBEffects::AuroraVeil]<=2 ||
          opponent.pbOwnSide.effects[PBEffects::AreniteWall]<=2 
          score*=1.2
        end
      end
      hpchange=(EndofTurnHPChanges(attacker,opponent,false,false,true)) # what % of our hp will change after end of turn effects go through
      if hpchange>1 ## we are going to be healing more hp than we take chip damage for  
        score*=(1.3*hpchange)
      elsif hpchange<1 ## we are going to be taking more chip damage than we are going to heal
        score*=(0.7*hpchange)
        score*=0.3 if attacker.effects[PBEffects::Toxic]>4
      elsif hpchange<=0 ## we are going to die to future sight/doom desire or huge overstack of end of turn effects. hence we should just not heal.
        score*=0.1
      end
      opphpchange=(EndofTurnHPChanges(opponent,attacker,false,false,true)) # what % of our hp will change after end of turn effects go through
      maxdam=checkAIdamage(aimem,attacker,opponent,skill)
      maxdam2=checkAIdamage(aimem,opponent,attacker,skill)
      if opphpchange!=1
        if opphpchange<1
          opphploss=1-opphpchange
          if opphploss<1
            opphploss=(opphploss*opponent.totalhp)
            if opphploss>(opponent.totalhp/4)
              score*=1.5
              if maxdam>attacker.hp
                score*=2
              end
            end
            if opphploss>opponent.hp
              if !(attacker.lastMoveUsed == 391)
                score*=2
              end
              if ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) 
                if maxdam>attacker.hp
                  score*=4
                  if attacker.lastMoveUsed == 391
                    score/=(attacker.effects[PBEffects::ProtectRate]*3.0)
                  end
                end
              end
            else
              if ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) && maxdam>attacker.hp
                score*=4
              else
                if maxdam>attacker.hp
                  score*=4
                  if attacker.lastMoveUsed == 391
                    score/=(attacker.effects[PBEffects::ProtectRate]*3.0)
                  end
                end
              end
            end
          end
        end
      end
      score*=2 if opponent.effects[PBEffects::PerishSong]!=0
      if @doublebattle && !(attacker.lastMoveUsed == 584)
        if !(opponent.isFainted?) && !(opponent.pbPartner.isFainted?)
          maxdam3=checkAIdamage(aimem,opponent,attacker.pbPartner,skill)
          maxdam4=checkAIdamage(aimem,opponent.pbPartner,attacker.pbPartner,skill)
          maxdam5=checkAIdamage(aimem,attacker.pbPartner,opponent,skill)
          maxdam6=checkAIdamage(aimem,attacker.pbPartner,opponent.pbPartner,skill)
          maxdam7=checkAIdamage(aimem,attacker,opponent.pbPartner,skill)
          if ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0) && (((attacker.pbPartner.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0) && maxdam3>opponent.hp) || ((attacker.pbSpeed<pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0) && (attacker.pbPartner.pbSpeed>pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0) && maxdam4>opponent.pbPartner.hp)))
            if (maxdam>attacker.hp || maxdam7>attacker.hp || maxdam+maxdam7>attacker.hp && (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0) && (attacker.pbSpeed<pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0))
              score*=4
            end
          end
        end
      end
      if pbWeather!=@weatherbackup
        score*=2 if (!attacker.abilitynulled && attacker.ability == PBAbilities::SWIFTSWIM) && (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) && @weatherbackup==PBWeather::RAINDANCE && @weatherduration==1
        score*=2 if (!attacker.abilitynulled && attacker.ability == PBAbilities::SANDRUSH) && (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) && @weatherbackup==PBWeather::SANDSTORM && @weatherduration==1
        score*=2 if (!attacker.abilitynulled && attacker.ability == PBAbilities::CHLOROPHYLL) && (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) && @weatherbackup==PBWeather::SUNNYDAY && @weatherduration==1
        score*=2 if (!attacker.abilitynulled && attacker.ability == PBAbilities::SLUSHRUSH) && (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) && @weatherbackup==PBWeather::HAIL && @weatherduration==1
      end
      score*=0.3 if opponent.status==PBStatuses::SLEEP || opponent.status==PBStatuses::FROZEN
      if opponent.vanished
        score*=2
        score*=1.5 if (attacker.pbSpeed<=pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
      end
      pridam=0
      ourpritier=0
      for i in attacker.moves
        #if (attacker.pbSpeed<=pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
          if (i.priority>0 && !(i.id==(PBMoves::FAKEOUT) && attacker.turncount!=0)) ||
            (!attacker.abilitynulled && attacker.ability == PBAbilities::GALEWINGS && i.type==PBTypes::FLYING && attacker.hp==attacker.totalhp) || 
            ((attacker.species == PBSpecies::FERALIGATR) && attitemworks && attacker.item == PBItems::FERACREST && attacker.turncount==0) ||
            (!attacker.abilitynulled && attacker.ability == PBAbilities::TRIAGE && i.isHealingMove?) && i.basedamage>0 && !(attacker.effects[PBEffects::DisableMove]==i.id)
            temppridam = pbRoughDamage(i,attacker,opponent,skill,i.basedamage)
            movepriority=i.priority
            if temppridam>pridam
              ourpritier=i.priority
              pridam = temppridam
            end
          end
        #end
      end
      opppridam=0
      opppri=false
      oppritier=0
      for i in opponent.moves
        #if (attacker.pbSpeed<=pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
          if (i.priority>0 && !(i.id==(PBMoves::FAKEOUT) && opponent.turncount!=0)) ||
            (!opponent.abilitynulled && opponent.ability == PBAbilities::GALEWINGS && move.type==PBTypes::FLYING && opponent.hp==opponent.totalhp) || 
            ((opponent.species == PBSpecies::FERALIGATR) && oppitemworks && opponent.item == PBItems::FERACREST && opponent.turncount==0) ||
            (!opponent.abilitynulled && opponent.ability == PBAbilities::TRIAGE && move.isHealingMove?)
            temppridam = pbRoughDamage(i,opponent,attacker,skill,i.basedamage)
            opppri=true
            if temppridam>opppridam
              oppritier=i.priority
              opppridam = temppridam
            end
          end
        #end
      end
      shielddam=0
      if (attacker.species == PBSpecies::AEGISLASH && attacker.form==1)
        originalform = attacker.form
        shieldmon=pbAegislashStats(attacker) 
        shieldmon.pbUpdate
        for i in opponent.moves
          tempdam = pbRoughDamage(i,opponent,shieldmon,skill,i.basedamage)
          shielddam = tempdam if tempdam>shielddam
        end
        shieldmon.form = originalform
        shieldmon.pbUpdate
      end
      if (((attacker.pbSpeed<=pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) && ((attacker.species == PBSpecies::AEGISLASH) && attacker.form==1)) && ((!(pridam>=opponent.hp) || pridam>=opponent.hp && opppridam>=attacker.hp))
        if ((maxdam>=attacker.hp/2) || ((maxdam>=attacker.hp && shielddam<attacker.hp))) && (!(pridam>=opponent.hp) || pridam>=opponent.hp && opppridam>=attacker.hp && (oppritier>=ourpritier)) 
          score*=4
          score*=6 if (initialscores.length>0) && hasgreatmoves(initialscores,scoreindex,skill) #experimental -- cancels out drop if killing moves
        end
      else
        score*=0.8
      end
      contactcheck=false
      for j in opponent.moves
        contactcheck=j.isContactMove?
      end
      if contactcheck && !(!opponent.abilitynulled && (opponent.ability == PBAbilities::DEFIANT || opponent.ability == PBAbilities::MIRRORARMOR || opponent.ability == PBAbilities::COMPETITIVE || opponent.ability == PBAbilities::CONTRARY)) 
        score*=1.3
      elsif  contactcheck && (!opponent.abilitynulled && (opponent.ability == PBAbilities::DEFIANT || opponent.ability == PBAbilities::MIRRORARMOR || opponent.ability == PBAbilities::COMPETITIVE || opponent.ability == PBAbilities::CONTRARY)) 
        score*=0.5
      end
      score*=0.1 if checkAImoves(PBStuff::PROTECTIGNORINGMOVE,aimem)
      if !(opponent.effects[PBEffects::Attacking]==true)
        if $fefieldeffect==31
          if !(opponent.effects[PBEffects::AttackingTarget].include?(attacker.index))
            rnd=pbAIRandom(10)
            if rnd>=7
              score*=0.01 
            end
          end
        else
          if !(opponent.effects[PBEffects::Attacking]==true)
            rnd=pbAIRandom(10)
            if rnd>=7
              score*=0.01 
            end
          end
        end
      end
      if attacker.effects[PBEffects::KingsShield]== true  ||
        attacker.effects[PBEffects::BanefulBunker]== true ||
        attacker.effects[PBEffects::SpikyShield]== true
        score*=0
      end
      if attacker.effects[PBEffects::Wish]>0
        if attacker.hp!=attacker.totalhp
          if checkAIdamage(aimem,attacker,opponent,skill)>attacker.hp
            score*=10
          else
            score*=3
          end
          score*=6 if initialscores.length>0 && hasgreatmoves(initialscores,scoreindex,skill)
        end
      end
      if $fefieldeffect==31 # Fairy Tale
        score*=1.4
      else
        score*=1.5 if pbRoughStat(opponent,PBStats::ATTACK,skill)>pbRoughStat(opponent,PBStats::SPATK,skill)
        score*=0.1 if attacker.status==0 && ((checkAImoves([PBMoves::WILLOWISP,PBMoves::THUNDERWAVE],aimem) || checkAImoves(PBStuff::SLEEPMOVE,aimem)) && !(opponent.effects[PBEffects::Attacking]==true))
      end
      ratesharers=[391,121,122,515,361,584,603,641,786]   # Protect, Detect, Quick Guard, Wide Guard, Endure, King's Shield, Spiky Shield, Baneful Bunker, Obstruct in that order
      score/=(attacker.effects[PBEffects::ProtectRate]*2.0) if ratesharers.include?(attacker.lastMoveUsed)
    when 0x134 # Electric Terrain
      sleepvar=false
      if aimem.length > 0
        for j in aimem
          sleepvar = true if j.function==0x03
        end
      end
      if @field.effects[PBEffects::Terrain]==0 && $fefieldeffect!=1 &&
        $fefieldeffect!=22 && $fefieldeffect!=35
        miniscore = getFieldDisruptScore(attacker,opponent,skill)
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::SURGESURFER)
          miniscore*=1.5
        end
        if attacker.pbHasType?(:ELECTRIC)
          miniscore*=1.5
        end
        elecvar=false
        for mon in pbParty(attacker.index)
          next if mon.nil?
          if mon.hasType?(:ELECTRIC)
            elecvar=true
          end
        end
        if elecvar
          miniscore*=2
        end
        if opponent.pbHasType?(:ELECTRIC)
          miniscore*=0.5
        end
        for m in attacker.moves
          if m.function==0x03
            miniscore*=0.5
            break
          end
        end
        if sleepvar
          miniscore*=2
        end
        if (attitemworks && attacker.item == PBItems::AMPLIFIELDROCK)
          miniscore*=2
        end
        score*=miniscore
      else
        score*=0
      end
      if @field.effects[PBEffects::ElectricTerrain]>0
        score*=0
      end    
    when 0x135 # Grassy Terrain
      firevar=false
      grassvar=false
      for mon in pbParty(attacker.index)
        next if mon.nil?
        if mon.hasType?(:FIRE)
          firevar=true
        end
        if mon.hasType?(:GRASS)
          grassvar=true
        end
      end
      if @field.effects[PBEffects::Terrain]==0 && $fefieldeffect!=2 && $fefieldeffect!=22 && $fefieldeffect!=35 && $fefieldeffect!=38 && $fefieldeffect!=39
        miniscore = getFieldDisruptScore(attacker,opponent,skill)
        if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
          miniscore*=1.5
        end
        if attacker.pbHasType?(:FIRE)
          miniscore*=2
        end
        if firevar
          miniscore*=2
        end
        if opponent.pbHasType?(:FIRE)
          miniscore*=0.5
          if pbWeather!=PBWeather::RAINDANCE
            miniscore*=0.5
          end
          if attacker.pbHasType?(:GRASS)
            miniscore*=0.5
          end
        else
          if attacker.pbHasType?(:GRASS)
            miniscore*=2
          end
        end
        if grassvar
          miniscore*=2
        end
        miniscore*=0.5 if checkAIhealing(aimem)
        miniscore*=0.5 if checkAImoves([PBMoves::SLUDGEWAVE],aimem)
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::GRASSPELT)
          miniscore*=1.5
        end
        if (attitemworks && attacker.item == PBItems::AMPLIFIELDROCK)
          miniscore*=2
        end
        score*=miniscore
      else
        score*=0
      end
      if @field.effects[PBEffects::GrassyTerrain]>0
        score*=0
      end  
    when 0x136 # Misty Terrain
      fairyvar=false
      dragonvar=false
      for mon in pbParty(attacker.index)
        next if mon.nil?
        if mon.hasType?(:FAIRY)
          fairyvar=true
        end
        if mon.hasType?(:DRAGON)
          dragonvar=true
        end
      end
      if @field.effects[PBEffects::Terrain]==0 && $fefieldeffect!=3 && $fefieldeffect!=22 && $fefieldeffect!=35
        miniscore = getFieldDisruptScore(attacker,opponent,skill)
        if fairyvar
          miniscore*=2
        end
        if !attacker.pbHasType?(:FAIRY) && opponent.pbHasType?(:DRAGON)
          miniscore*=2
        end
        if attacker.pbHasType?(:DRAGON)
          miniscore*=0.5
        end
        if opponent.pbHasType?(:FAIRY)
          miniscore*=0.5
        end
        if attacker.pbHasType?(:FAIRY) && opponent.spatk>opponent.attack
          miniscore*=2
        end
        if (attitemworks && attacker.item == PBItems::AMPLIFIELDROCK)
          miniscore*=2
        end
        score*=miniscore
      else
        score*=0
      end
      if @field.effects[PBEffects::MistyTerrain]>0 || (attacker.species==PBSpecies::MUSHARNA && attacker.item==PBItems::PULSEPLUS && attacker.form==0)
        score*=0
      end  
    when 0x137 # Flying Press
      if opponent.effects[PBEffects::Minimize]
        score*=2
      end
      if @field.effects[PBEffects::Gravity]>0
        score*=0
      end
    when 0x138 # Noble Roar
      if (!opponent.pbCanReduceStatStage?(PBStats::ATTACK) && !opponent.pbCanReduceStatStage?(PBStats::SPATK)) || (opponent.stages[PBStats::ATTACK]==-6 && opponent.stages[PBStats::SPATK]==-6) || (opponent.stages[PBStats::ATTACK]>0 && opponent.stages[PBStats::SPATK]>0)
        score*=0
      else
        miniscore=100
        ministat= 5*statchangecounter(opponent,1,7,-1)
        ministat+=100
        ministat/=100.0
        miniscore*=ministat
        if move.id==getID(PBMoves,:NOBLEROAR) && ($fefieldeffect==31 || $fefieldeffect==32)
          miniscore*=2
        end
        miniscore*= unsetupminiscore(attacker,opponent,skill,move,roles,1,false,false,initialscores,scoreindex)
        miniscore/=100.0
        score*=miniscore
      end
    when 0x139 # Draining Kiss
      minimini = score*0.01
      miniscore = (opponent.hp*minimini)*(3.0/4.0)
      if miniscore > (attacker.totalhp-attacker.hp)
        miniscore = (attacker.totalhp-attacker.hp)
      end
      if attacker.totalhp>0
        miniscore/=(attacker.totalhp).to_f
      end
      if attacker.hasWorkingItem(:BIGROOT)
        miniscore*=1.3
      end
      miniscore+=1
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::LIQUIDOOZE)
        miniscore = (2-miniscore)
      end
      if attacker.item == PBItems::FOCUSSASH && attacker.hp!=attacker.totalhp
        miniscore*=1.5 if (attacker.hp+(opponent.hp*minimini)*(3.0/4.0))==attacker.totalhp
      end
      if (attacker.hp!=attacker.totalhp || ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0))) && opponent.effects[PBEffects::Substitute]==0
        score*=miniscore
      end
      if score>=110
        score*=1.1
      end
      if $fefieldeffect==31 && move.id==getID(PBMoves,:DRAININGKISS)
        if opponent.status==PBStatuses::SLEEP
          score*=0.8
        end
      end
    when 0x13A # Aromatic Mist
      newopp = attacker.pbOppositeOpposing
      movecheck = false
      if skill>=PBTrainerAI.highSkill
        if @aiMoveMemory[2][newopp.pokemonIndex].length>0
          for j in @aiMoveMemory[2][newopp.pokemonIndex]
            movecheck=true if (PBStuff::PHASEMOVE).include?(j.id)
          end
        end
      elsif skill>=PBTrainerAI.mediumSkill
        movecheck=checkAImoves(PBStuff::PHASEMOVE,aimem)
      end
      if @doublebattle && opponent==attacker.pbPartner && opponent.stages[PBStats::SPDEF]!=6
        if newopp.spatk > newopp.attack
          score*=2
        else
          score*=0.5
        end
        if initialscores.length>0
          score*=1.3 if hasbadmoves(initialscores,scoreindex,20)
        end
        if opponent.hp*(1.0/opponent.totalhp)>0.75
          score*=1.1
        end
        if opponent.effects[PBEffects::Yawn]>0 || opponent.effects[PBEffects::LeechSeed]>=0 || opponent.effects[PBEffects::Attract]>=0 || opponent.status!=0
          score*=0.3
        end
        if movecheck
          score*=0.2
        end
        if !opponent.abilitynulled && opponent.ability == PBAbilities::SIMPLE
          score*=2
        end
        if newopp.hasWorkingAbility(:UNAWARE) || SilvallyCheck(newopp, PBTypes::FAIRY)
          score*=0.5
        end
        if opponent.hasWorkingItem(:LEFTOVERS) || (opponent.hasWorkingItem(:BLACKSLUDGE) && opponent.pbHasType?(:POISON))
          score*=1.2
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::CONTRARY)
          score*=0
        end
        if $fefieldeffect==3
          score*=2
        end
      else
        score*=0
      end
    when 0x13B # Eerie Impulse
      if (pbRoughStat(opponent,PBStats::SPATK,skill)<pbRoughStat(opponent,PBStats::ATTACK,skill)) || opponent.stages[PBStats::SPATK]>1 || !opponent.pbCanReduceStatStage?(PBStats::SPATK)
        if move.basedamage==0
          score=0
        end
      else
        miniscore=100
        if opponent.stages[PBStats::SPATK]<0
          minimini = 5*opponent.stages[PBStats::SPATK]
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        miniscore*= unsetupminiscore(attacker,opponent,skill,move,roles,1,false,false,initialscores,scoreindex)
        miniscore/=100.0
        score*=miniscore
      end
    when 0x13C # Belch
      if $belch==false && !(isConst?(attacker.species,PBSpecies,:SWALOT) && attitemworks && attacker.item == PBItems::SWACREST)
        score*=0
      end
    when 0x13D # Parting Shot
      if (!opponent.pbCanReduceStatStage?(PBStats::ATTACK) && !opponent.pbCanReduceStatStage?(PBStats::SPATK)) || (opponent.stages[PBStats::ATTACK]==-6 && opponent.stages[PBStats::SPATK]==-6) || (opponent.stages[PBStats::ATTACK]>0 && opponent.stages[PBStats::SPATK]>0)
        score*=0
      else
        if attacker.pbNonActivePokemonCount!=0
          if attacker.pbOwnSide.effects[PBEffects::StealthRock]
            score*=0.7
          end
          if attacker.pbOwnSide.effects[PBEffects::StickyWeb]
            score*=0.6
          end
          if attacker.pbOwnSide.effects[PBEffects::Spikes]>0
            score*=0.9**attacker.pbOwnSide.effects[PBEffects::Spikes]
          end
          if attacker.pbOwnSide.effects[PBEffects::ToxicSpikes]>0
            score*=0.9**attacker.pbOwnSide.effects[PBEffects::ToxicSpikes]
          end
          if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
            score*=1.1
          end
          sweepvar = false
          for i in pbParty(attacker.index)
            next if i.nil?
            temprole = pbGetMonRole(i,opponent,skill,count,pbParty(attacker.index))
            if temprole.include?(PBMonRoles::SWEEPER)
              sweepvar = true
            end
          end
          if sweepvar
            score*=1.5
          end
          if roles.include?(PBMonRoles::LEAD)
            score*=1.1
          end
          if roles.include?(PBMonRoles::PIVOT)
            score*=1.2
          end
          miniscore=100
          ministat= 5*statchangecounter(opponent,1,7,-1)
          miniscore+=100
          miniscore/=100.0
          score*=miniscore
          miniscore= (-5)*statchangecounter(attacker,1,7,1)
          miniscore+=100
          miniscore/=100.0
          score*=miniscore
          if attacker.effects[PBEffects::Toxic]>0 || attacker.effects[PBEffects::Attract]>-1 || attacker.effects[PBEffects::Confusion]>0
            score*=1.3
          end
          if attacker.effects[PBEffects::LeechSeed]>-1
            score*=1.5
          end
          miniscore=130
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SHADOWTAG) || (!attacker.abilitynulled && attacker.ability == PBAbilities::ARENATRAP) || opponent.effects[PBEffects::MeanLook]>=0 ||  opponent.pbNonActivePokemonCount==0
            miniscore*=1.4
          end
          ministat= 5*statchangecounter(opponent,1,7,-1)
          ministat+=100
          ministat/=100.0
          miniscore*=ministat
          if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || (!opponent.abilitynulled && opponent.ability == PBAbilities::DEFIANT) || (!opponent.abilitynulled && opponent.ability == PBAbilities::COMPETITIVE) || (!opponent.abilitynulled && opponent.ability == PBAbilities::CONTRARY) || SilvallyCheck(opponent, "fighting") || SilvallyCheck(opponent, PBTypes::FAIRY)
            miniscore*=0.1
          end
          miniscore/=100.0
          score*=miniscore
        end
      end
    when 0x13E # Geomancy
      maxdam = checkAIdamage(aimem,attacker,opponent,skill)
      if !(attitemworks && attacker.item == PBItems::POWERHERB)
        if maxdam>attacker.hp
          score*=0.4
        elsif attacker.hp*(1.0/attacker.totalhp)<0.5
          score*=0.6
        end
        if attacker.turncount<2
          score*=1.5
        else
          score*=0.7
        end
        if opponent.effects[PBEffects::TwoTurnAttack]!=0 || opponent.effects[PBEffects::HyperBeam]>0
          score*=2
        end
        if @doublebattle
          score*=0.5
        end
      else
        score*=2
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::UNBURDEN)
          score*=1.5
        end
      end
      miniscore=100
      if attacker.effects[PBEffects::Substitute]>0 || attacker.effects[PBEffects::Disguise] || (attacker.effects[PBEffects::IceFace] && !specmove) || (attacker.effects[PBEffects::IceFace] && $fefieldeffect==39)
        miniscore*=1.5
      end
      if initialscores.length>0
        miniscore*=1.3 if hasbadmoves(initialscores,scoreindex,40)
      end
      if (attacker.hp.to_f)/attacker.totalhp>0.75
        miniscore*=1.2
      end
      if opponent.effects[PBEffects::Yawn]>0
        miniscore*=1.7
      end
      if maxdam*4<attacker.hp
        miniscore*=1.2
      else
        if move.basedamage==0
          miniscore*=0.8
          if maxdam>attacker.hp
            miniscore*=0.1
          end
        end
      end
      if opponent.status!=0
        miniscore*=1.2
      end
      if opponent.status==PBStatuses::SLEEP || opponent.status==PBStatuses::FROZEN
        miniscore*=1.3
      end
      if opponent.effects[PBEffects::Encore]>0
        if opponent.moves[(opponent.effects[PBEffects::EncoreIndex])].basedamage==0
          miniscore*=1.5
        end
      end
      if attacker.effects[PBEffects::Confusion]>0
        miniscore*=0.5
      end
      if attacker.effects[PBEffects::LeechSeed]>=0 || attacker.effects[PBEffects::Attract]>=0
        miniscore*=0.3
      end
      miniscore*=0.5 if checkAImoves(PBStuff::SWITCHOUTMOVE,aimem)
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::SIMPLE)
        miniscore*=2
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE)
        miniscore*=0.5
      end
      miniscore/=100.0
      score*=miniscore
      miniscore=100
      if attacker.stages[PBStats::SPEED]<0
        ministat=attacker.stages[PBStats::SPEED]
        minimini=5*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      ministat=0
      ministat+=opponent.stages[PBStats::ATTACK]
      ministat+=opponent.stages[PBStats::SPATK]
      ministat+=opponent.stages[PBStats::SPEED]
      if ministat>0
        minimini=(-5)*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      miniscore*=1.3 if checkAIhealing(aimem)
      if attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill) && @trickroom==0
        miniscore*=1.5
      end
      if roles.include?(PBMonRoles::SWEEPER)
        miniscore*=1.3
      end
      if attacker.status==PBStatuses::PARALYSIS
        miniscore*=0.5
      end
      miniscore*=0.6 if checkAIpriority(aimem)
      miniscore/=100.0
      if !attacker.pbTooHigh?(PBStats::SPATK)
        score*=miniscore
      end
      miniscore=100
      if attacker.effects[PBEffects::Toxic]>0
        miniscore*=0.2
      end
      if pbRoughStat(opponent,PBStats::ATTACK,skill)<pbRoughStat(opponent,PBStats::SPATK,skill)
        miniscore*=1.3
      end
      if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
        miniscore*=1.3
      end
      if (attitemworks && attacker.item == PBItems::LEFTOVERS) || ((attitemworks && attacker.item == PBItems::BLACKSLUDGE) && attacker.pbHasType?(:POISON))
        miniscore*=1.2
      end
      healmove=false
      for j in attacker.moves
        if j.isHealingMove?
          healmove=true
        end
      end
      if healmove
        miniscore*=1.3
      end
      if attacker.pbHasMove?((PBMoves::LEECHSEED))
        miniscore*=1.3
      end
      if attacker.pbHasMove?((PBMoves::PAINSPLIT))
        miniscore*=1.2
      end
      miniscore/=100.0
      if !attacker.pbTooHigh?(PBStats::SPDEF)
        score*=miniscore
      end
      miniscore=100
      if attacker.stages[PBStats::SPATK]<0
        ministat=attacker.stages[PBStats::SPATK]
        minimini=5*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        miniscore*=0.8
      end
      if @trickroom!=0
        miniscore*=0.2
      else
        miniscore*=0.2 if checkAImoves([PBMoves::TRICKROOM],aimem)
      end
      miniscore/=100.0
      if !attacker.pbTooHigh?(PBStats::SPEED)
        score*=miniscore=0
      end
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        score*=0
      end
      psyvar=false
      fairyvar=false
      darkvar=false
      for mon in pbParty(attacker.index)
        next if mon.nil?
        if mon.hasType?(:PSYCHIC)
          psyvar=true
        end
        if mon.hasType?(:FAIRY)
          fairyvar=true
        end
        if mon.hasType?(:DARK)
          darkvar=true
        end
      end
      if $fefieldeffect==35
        if !(!attacker.abilitynulled && (attacker.ability == PBAbilities::LEVITATE || attacker.ability == PBAbilities::SOLARIDOL || attacker.ability == PBAbilities::LUNARIDOL)) && !attacker.pbHasType?(:FLYING)
          score*=2
        end
        if (!opponent.abilitynulled && (opponent.ability == PBAbilities::LEVITATE || opponent.ability == PBAbilities::SOLARIDOL || opponent.ability == PBAbilities::LUNARIDOL)) || opponent.pbHasType?(:FLYING)
          score*=2
        end
        if psyvar || fairyvar || darkvar
          score*=2
          if attacker.pbHasType?(:PSYCHIC) || attacker.pbHasType?(:FAIRY) || attacker.pbHasType?(:DARK)
            score*=2
          end
        end
      end
      if attacker.pbTooHigh?(PBStats::SPATK) && attacker.pbTooHigh?(PBStats::SPDEF) && attacker.pbTooHigh?(PBStats::SPEED)
        score*=0
      end
    when 0x13F # Venom Drench
      if opponent.status==PBStatuses::POISON || $fefieldeffect==10 || $fefieldeffect==11 || $fefieldeffect==19 || $fefieldeffect==26
        if (!opponent.pbCanReduceStatStage?(PBStats::ATTACK) && !opponent.pbCanReduceStatStage?(PBStats::SPATK)) || (opponent.stages[PBStats::ATTACK]==-6 && opponent.stages[PBStats::SPATK]==-6) || (opponent.stages[PBStats::ATTACK]>0 && opponent.stages[PBStats::SPATK]>0)
          score*=0.5
        else
          miniscore=100
          if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
            miniscore*=1.4
          end
          sweepvar = false
          for i in pbParty(attacker.index)
            next if i.nil?
            temprole = pbGetMonRole(i,opponent,skill,count,pbParty(attacker.index))
            if temprole.include?(PBMonRoles::SWEEPER)
              sweepvar = true
            end
          end
          if sweepvar
            miniscore*=1.1
          end
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SHADOWTAG) || (!attacker.abilitynulled && attacker.ability == PBAbilities::ARENATRAP) || opponent.effects[PBEffects::MeanLook]>=0 ||  opponent.pbNonActivePokemonCount==0
            miniscore*=1.5
          end
          ministat= 5*statchangecounter(opponent,1,7,-1)
          ministat+=100
          ministat/=100.0
          miniscore*=ministat
          if attacker.pbHasMove?((PBMoves::FOULPLAY))
            miniscore*=0.5
          end
          miniscore/=100.0
          score*=miniscore
        end
        if (pbRoughStat(opponent,PBStats::SPEED,skill)<attacker.pbSpeed) || opponent.stages[PBStats::SPEED]>0 || !opponent.pbCanReduceStatStage?(PBStats::SPEED)
          score*=0.5
        else
          miniscore=100
          if (!opponent.abilitynulled && opponent.ability == PBAbilities::SPEEDBOOST)
            miniscore*=0.9
          end
          if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEAMENGINE)
            if $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==21 || $fefieldeffect==22 || $fefieldeffect==45
              miniscore*=0.9
            end
          end
          if attacker.pbHasMove?((PBMoves::ELECTROBALL))
            miniscore*=1.5
          end
          if attacker.pbHasMove?((PBMoves::GYROBALL))
            miniscore*=0.5
          end
          if (oppitemworks && opponent.item == PBItems::LAGGINGTAIL) || (oppitemworks && opponent.item == PBItems::IRONBALL)
            miniscore*=0.8
          end
          miniscore*=0.1 if checkAImoves([PBMoves::TRICKROOM],aimem) || @trickroom!=0
          miniscore*=1.3 if checkAImoves([PBMoves::ELECTROBALL],aimem)
          miniscore*=0.5 if checkAImoves([PBMoves::GYROBALL],aimem)
          miniscore/=100.0
          score*=miniscore
          if attacker.pbNonActivePokemonCount==0
            score*=0.5
          end
          if (!opponent.abilitynulled && opponent.ability == PBAbilities::MIRRORARMOR) || (!opponent.abilitynulled && opponent.ability == PBAbilities::CONTRARY) || (!opponent.abilitynulled && opponent.ability == PBAbilities::DEFIANT) || SilvallyCheck(opponent, "fighting")
            score*=0
          end
        end
      else
        score*=0
      end
    when 0x140 # Spiky Shield
      if opponent.effects[PBEffects::Taunt]==0
        score*=0.3 if opponent.moves.any? {|moveloop| (PBStuff::SETUPMOVE).include?(moveloop.id)}
      end
      if ((!attacker.abilitynulled && attacker.ability == PBAbilities::SPEEDBOOST) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STEAMENGINE) && $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==21 || $fefieldeffect==22 || $fefieldeffect==45)) && attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill) && @trickroom==0
        score*=4 if (attacker.pbSpeed*1.5>pbRoughStat(opponent,PBStats::SPEED,skill))
        score*=6 if initialscores.length>0 && hasgreatmoves(initialscores,scoreindex,skill)
      end
      score*=1.1 if (isConst?(opponent.species,PBSpecies,:FERALIGATR) && oppitemworks && opponent.item == PBItems::FERACREST && opponent.turncount==0)
      score*=1.2 if (opponent.status==PBStatuses::POISON || opponent.status==PBStatuses::BURN)
      score*=1.3 if opponent.effects[PBEffects::Toxic]>0
      maxdam=checkAIdamage(aimem,attacker,opponent,skill)
      hpchange=(EndofTurnHPChanges(attacker,opponent,false,false,true)) # what % of our hp will change after end of turn effects go through
      if hpchange>1 ## we are going to be healing more hp than we take chip damage for  
        score*=(1.3*hpchange)
      elsif hpchange<1 ## we are going to be taking more chip damage than we are going to heal
        score*=(0.7*hpchange)
        score*=0.3 if attacker.effects[PBEffects::Toxic]>4
      elsif hpchange<=0 ## we are going to die to future sight/doom desire or huge overstack of end of turn effects. hence we should just not heal.
        score*=0.1
      end
      opphpchange=(EndofTurnHPChanges(opponent,attacker,false,false,true)) # what % of our hp will change after end of turn effects go through
      maxdam2=checkAIdamage(aimem,opponent,attacker,skill)
      if opphpchange!=1
        if opphpchange<1
          opphploss=1-opphpchange
          if opphploss<1
            opphploss=(opphploss*opponent.totalhp)
            if opphploss>(opponent.totalhp/4)
              score*=1.5
              if maxdam>attacker.hp
                score*=2
              end
            end
            if opphploss>opponent.hp
              if !(attacker.lastMoveUsed == 391)
                score*=2
              end
              if ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) 
                if maxdam>attacker.hp
                  score*=4
                  if attacker.lastMoveUsed == 391
                    score/=(attacker.effects[PBEffects::ProtectRate]*3.0)
                  end
                end
              end
            else
              if ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) && maxdam>attacker.hp
                score*=4
              else
                if maxdam>attacker.hp
                  score*=4
                  if attacker.lastMoveUsed == 391
                    score/=(attacker.effects[PBEffects::ProtectRate]*3.0)
                  end
                end
              end
            end
          end
        end
      end
      score*=2 if opponent.effects[PBEffects::PerishSong]!=0
      if @doublebattle && !(attacker.lastMoveUsed == 603)
        if !(opponent.isFainted?) && !(opponent.pbPartner.isFainted?)
          maxdam3=checkAIdamage(aimem,opponent,attacker.pbPartner,skill)
          maxdam4=checkAIdamage(aimem,opponent.pbPartner,attacker.pbPartner,skill)
          maxdam5=checkAIdamage(aimem,attacker.pbPartner,opponent,skill)
          maxdam6=checkAIdamage(aimem,attacker.pbPartner,opponent.pbPartner,skill)
          maxdam7=checkAIdamage(aimem,attacker,opponent.pbPartner,skill)
          if ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0) && (((attacker.pbPartner.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0) && maxdam3>opponent.hp) || ((attacker.pbSpeed<pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0) && (attacker.pbPartner.pbSpeed>pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0) && maxdam4>opponent.pbPartner.hp)))
            if (maxdam>attacker.hp || maxdam7>attacker.hp || maxdam+maxdam7>attacker.hp && (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0) && (attacker.pbSpeed<pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0))
              score*=4
            end
          end
        end
      end
      if pbWeather!=@weatherbackup
        score*=2 if (!attacker.abilitynulled && attacker.ability == PBAbilities::SWIFTSWIM) && (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) && @weatherbackup==PBWeather::RAINDANCE && @weatherduration==1
        score*=2 if (!attacker.abilitynulled && attacker.ability == PBAbilities::SANDRUSH) && (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) && @weatherbackup==PBWeather::SANDSTORM && @weatherduration==1
        score*=2 if (!attacker.abilitynulled && attacker.ability == PBAbilities::CHLOROPHYLL) && (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) && @weatherbackup==PBWeather::SUNNYDAY && @weatherduration==1
        score*=2 if (!attacker.abilitynulled && attacker.ability == PBAbilities::SLUSHRUSH) && (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) && @weatherbackup==PBWeather::HAIL && @weatherduration==1
      end
      score*=0.3 if opponent.status==PBStatuses::SLEEP || opponent.status==PBStatuses::FROZEN
      if opponent.vanished
        score*=2
        score*=1.5 if (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
      end
      score*=0.1 if checkAImoves(PBStuff::PROTECTIGNORINGMOVE,aimem)
      if !(opponent.effects[PBEffects::Attacking]==true)
        if !(opponent.effects[PBEffects::AttackingTarget].include?(attacker.index))
          rnd=pbAIRandom(10)
          if rnd>=7
            score*=0.01 
          end
        end
      end
      if attacker.effects[PBEffects::Wish]>0
        if attacker.hp!=attacker.totalhp
          if checkAIdamage(aimem,attacker,opponent,skill)>attacker.hp
            score*=10
          else
            score*=3
          end
          score*=6 if initialscores.length>0 && hasgreatmoves(initialscores,scoreindex,skill)
        end
      end
      if attacker.effects[PBEffects::KingsShield]== true  ||
        attacker.effects[PBEffects::BanefulBunker]== true ||
        attacker.effects[PBEffects::SpikyShield]== true
        score*=0
      end
      if aimem.length > 0
        contactcheck=false
        maxdam=0
        for j in aimem
          contactcheck=j.isContactMove?
        end
        score*=1.3 if contactcheck
      end
      ratesharers=[391,121,122,515,361,584,603,641,786]   # Protect, Detect, Quick Guard, Wide Guard, Endure, King's Shield, Spiky Shield, Baneful Bunker, Obstruct in that order
      score/=(attacker.effects[PBEffects::ProtectRate]*2.0) if ratesharers.include?(attacker.lastMoveUsed)
    when 0x141 # Sticky Web
      if !attacker.pbOpposingSide.effects[PBEffects::StickyWeb]
        if roles.include?(PBMonRoles::LEAD)
          score*=1.3
        end
        if (attitemworks && attacker.item == PBItems::FOCUSSASH) && attacker.hp==attacker.totalhp
          score*=1.3
        end
        if attacker.turncount<2
          score*=1.5
        end
        if opponent.pbNonActivePokemonCount>1
          miniscore = opponent.pbNonActivePokemonCount
          miniscore/=100.0
          miniscore*=0.3
          miniscore+=1
          score*=miniscore
        else
          score*=0.2
        end
        magiccheck=false
        score*=0.3 if checkAImoves([PBMoves::DEFOG,PBMoves::RAPIDSPIN,PBMoves::MAGICCOAT],aimem)
        if skill>=PBTrainerAI.highSkill
          for k in 0...pbParty(opponent.index).length
            next if pbParty(opponent.index)[k].nil?
            next if pbParty(opponent.index)[k].hp==0
            for j in @aiAbilityMemory[0][k]
              if j==PBAbilities::MAGICBOUNCE && !pbParty(opponent.index)[k].isFainted?
                magiccheck=true
              end
            end    
          end
          for k in 0...pbParty(opponent.index).length
            next if pbParty(opponent.index)[k].nil?
            if @aiMoveMemory[2][k].length>0
              movecheck=false
              for j in @aiMoveMemory[2][k]
                movecheck=true if j.id==(PBMoves::DEFOG) || j.id==(PBMoves::RAPIDSPIN)
              end
              score*=0.3 if movecheck
            end
          end
        elsif skill>=PBTrainerAI.mediumSkill
          score*=0.3 if checkAImoves([PBMoves::DEFOG,PBMoves::RAPIDSPIN],aimem)
        end
        if $fefieldeffect==15
          if magiccheck==false
            score*=2
          end
        end
      else
        score*=0
      end
      if $fefieldeffect==19
        if attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill) || opponent.stages[PBStats::SPEED]>0 || !opponent.pbCanReduceStatStage?(PBStats::SPEED)
          score*=0
        else
          score+=15
          miniscore=100
          if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
            miniscore*=1.1
          end
          if opponent.pbNonActivePokemonCount==0 || (!attacker.abilitynulled && attacker.ability == PBAbilities::SHADOWTAG) || opponent.effects[PBEffects::MeanLook]>0
            miniscore*=1.3
          end
          if opponent.stages[PBStats::SPEED]<0
            minimini = 5*opponent.stages[PBStats::SPEED]
            minimini+=100
            minimini/=100.0
            miniscore*=minimini
          end
          if attacker.pbNonActivePokemonCount==0
            miniscore*=0.5
          end
          if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || (!opponent.abilitynulled && opponent.ability == PBAbilities::COMPETITIVE) || (!opponent.abilitynulled && opponent.ability == PBAbilities::DEFIANT) || (!opponent.abilitynulled && opponent.ability == PBAbilities::CONTRARY)
            miniscore*=0.1
          end
          if (!opponent.abilitynulled && opponent.ability == PBAbilities::SPEEDBOOST)
            miniscore*=0.5
          end
          if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEAMENGINE)
            if $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==21 || $fefieldeffect==22 || $fefieldeffect==45
              miniscore*=0.5
            end
          end
          if attacker.pbHasMove?((PBMoves::ELECTROBALL))
            miniscore*=1.5
          end
          if attacker.pbHasMove?((PBMoves::GYROBALL))
            miniscore*=0.5
          end
          if (oppitemworks && opponent.item == PBItems::LAGGINGTAIL) || (oppitemworks && opponent.item == PBItems::IRONBALL)
            miniscore*=0.1
          end
          miniscore*=0.1 if checkAImoves([PBMoves::TRICKROOM],aimem) || @trickroom!=0
          miniscore*=1.3 if checkAImoves([PBMoves::ELECTROBALL],aimem)
          miniscore*=0.5 if checkAImoves([PBMoves::GYROBALL],aimem)
          miniscore/=100.0
          score*=miniscore
        end
      end
    when 0x142 # Topsy-Turvy
      ministat= 10* statchangecounter(opponent,1,7)
      ministat+=100
      if ministat<0
        ministat=0
      end
      ministat/=100.0
      if opponent == attacker.pbPartner
        ministat = 2-ministat
      end
      score*=ministat
      if $fefieldeffect!=22 && $fefieldeffect!=35 && $fefieldeffect!=36
        effcheck = PBTypes.getCombinedEffectiveness(opponent.type1,attacker.type1,attacker.type2)
        if effcheck>4
          score*=2
        else
          if effcheck!=0 && effcheck<4
            score*=0.5
          end
          if effcheck==0
            score*=0.1
          end
        end
        effcheck = PBTypes.getCombinedEffectiveness(opponent.type2,attacker.type1,attacker.type2)
        if effcheck>4
          score*=2
        else
          if effcheck!=0 && effcheck<4
            score*=0.5
          end
          if effcheck==0
            score*=0.1
          end
        end
        effcheck = PBTypes.getCombinedEffectiveness(attacker.type1,opponent.type1,opponent.type2)
        if effcheck>4
          score*=0.5
        else
          if effcheck!=0 && effcheck<4
            score*=2
          end
          if effcheck==0
            score*=3
          end
        end
        effcheck = PBTypes.getCombinedEffectiveness(attacker.type2,opponent.type1,opponent.type2)
        if effcheck>4
          score*=0.5
        else
          if effcheck!=0 && effcheck<4
            score*=2
          end
          if effcheck==0
            score*=3
          end
        end
      end
    when 0x143 # Forest's Curse
      grassvar = false
      if aimem.length > 0
        for j in aimem
          grassvar = true if (j.type == PBTypes::GRASS)
        end
      end
      effmove = false
      for m in attacker.moves
        if (m.type == PBTypes::FIRE) || (m.type == PBTypes::ICE) || (m.type == PBTypes::BUG) || (m.type == PBTypes::FLYING) || (m.type == PBTypes::POISON)
          effmove = true
          break
        end
      end
      if effmove
        score*=1.5
      else
        score*=0.7
      end
      if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
        if attacker.pbHasMove?((PBMoves::TOXIC)) && (opponent.pbHasType?(:STEEL) || opponent.pbHasType?(:POISON))
          score*=1.5
        end
      end
      if grassvar
        score*=0.5
      else
        score*=1.1
      end
      if (opponent.ability == PBAbilities::MULTITYPE) || (opponent.ability == PBAbilities::RKSSYSTEM) || (opponent.type1==(PBTypes::GRASS) && opponent.type2==(PBTypes::GRASS)) || (!opponent.abilitynulled && opponent.ability == PBAbilities::PROTEAN) || (!opponent.abilitynulled && opponent.ability == PBAbilities::LIBERO) || (!opponent.abilitynulled && opponent.ability == PBAbilities::COLORCHANGE)
        score*=0
      end
      if $fefieldeffect == 15 || $fefieldeffect == 31 || $fefieldeffect == 42
        if !opponent.effects[PBEffects::Curse]
          score+=25
          ministat= 5*statchangecounter(opponent,1,7)
          ministat+=100
          ministat/=100.0
          score*=ministat
          if opponent.pbNonActivePokemonCount==0 || (!attacker.abilitynulled && attacker.ability == PBAbilities::SHADOWTAG) || opponent.effects[PBEffects::MeanLook]>0
            score*=1.3
          else
            score*=0.8
          end
          if @doublebattle
            score*=0.5
          end
          if initialscores.length>0
            score*=1.3 if hasbadmoves(initialscores,scoreindex,25)
          end
        end
      end
    when 0x144 # Trick or Treat
      ghostvar = false
      if aimem.length > 0
        for j in aimem
          ghostvar = true if (j.type == PBTypes::GHOST)
        end
      end
      effmove = false
      for m in attacker.moves
        if (m.type == PBTypes::DARK) || (m.type == PBTypes::GHOST)
          effmove = true
          break
        end
      end
      if effmove
        score*=1.5
      else
        score*=0.7
      end
      if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
        if attacker.pbHasMove?((PBMoves::TOXIC)) && (opponent.pbHasType?(:STEEL) || opponent.pbHasType?(:POISON))
          score*=1.5
        end
      end
      if ghostvar
        score*=0.5
      else
        score*=1.1
      end
      if (opponent.ability == PBAbilities::MULTITYPE) || (opponent.ability == PBAbilities::RKSSYSTEM) || (opponent.type1==(PBTypes::GHOST) && opponent.type2==(PBTypes::GHOST)) || (!opponent.abilitynulled && opponent.ability == PBAbilities::PROTEAN)  || (!opponent.abilitynulled && opponent.ability == PBAbilities::LIBERO) || (!opponent.abilitynulled && opponent.ability == PBAbilities::COLORCHANGE)
        score*=0
      end
    when 0x145 # Fairy Lock
      if attacker.effects[PBEffects::PerishSong]==1 || attacker.effects[PBEffects::PerishSong]==2
        score*=0
      else
        if opponent.effects[PBEffects::PerishSong]==2
          score*=10
        end
        if opponent.effects[PBEffects::PerishSong]==1
          score*=20
        end
        if attacker.effects[PBEffects::LeechSeed]>=0
          score*=0.8
        end
        if opponent.effects[PBEffects::LeechSeed]>=0
          score*=1.2
        end
        if opponent.effects[PBEffects::Curse]
          score*=1.3
        end
        if attacker.effects[PBEffects::Curse]
          score*=0.7
        end
        if opponent.effects[PBEffects::Confusion]>0
          score*=1.1
        end
        if attacker.effects[PBEffects::Confusion]>0
          score*=1.1
        end
      end
    when 0x146 # Magnetic Flux
      if !((!attacker.abilitynulled && attacker.ability == PBAbilities::PLUS) || (!attacker.abilitynulled && attacker.ability == PBAbilities::MINUS) || (!attacker.pbPartner.abilitynulled && attacker.pbPartner.ability == PBAbilities::PLUS) || (!attacker.pbPartner.abilitynulled && attacker.pbPartner.ability == PBAbilities::MINUS))
        score*=0
      else
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::PLUS) || (!attacker.abilitynulled && attacker.ability == PBAbilities::MINUS)
          miniscore = setupminiscore(attacker,opponent,skill,move,false,10,true,initialscores,scoreindex)
          score*=miniscore
          miniscore=100
          if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
            miniscore*=1.5
          end
          if (attitemworks && attacker.item == PBItems::LEFTOVERS) || ((attitemworks && attacker.item == PBItems::BLACKSLUDGE) && attacker.pbHasType?(:POISON))
            miniscore*=1.2
          end
          healmove=false
          for j in attacker.moves
            if j.isHealingMove?
              healmove=true
            end
          end
          if healmove
            miniscore*=1.7
          end
          if attacker.pbHasMove?((PBMoves::LEECHSEED))
            miniscore*=1.3
          end
          if attacker.pbHasMove?((PBMoves::PAINSPLIT))
            miniscore*=1.2
          end
          if attacker.stages[PBStats::SPDEF]!=6 && attacker.stages[PBStats::DEFENSE]!=6
            score*=miniscore
          end
        elsif @doublebattle && attacker.pbPartner.stages[PBStats::SPDEF]!=6 && attacker.pbPartner.stages[PBStats::DEFENSE]!=6
          score*=0.7
          if initialscores.length>0
            score*=1.3 if hasbadmoves(initialscores,scoreindex,20)
          end
          if attacker.pbPartner.hp >= attacker.pbPartner.totalhp*0.75
            score*=1.1
          end
          if attacker.pbPartner.effects[PBEffects::Yawn]>0 || attacker.pbPartner.effects[PBEffects::LeechSeed]>=0 || attacker.pbPartner.effects[PBEffects::Attract]>=0 || attacker.pbPartner.status!=0
            score*=0.3
          end
          if movecheck
            score*=0.3
          end
          if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent,PBTypes::FAIRY)
            score*=0.5
          end
          if attacker.pbPartner.hasWorkingItem(:LEFTOVERS) || (attacker.pbPartner.hasWorkingItem(:BLACKSLUDGE) && attacker.pbPartner.pbHasType?(:POISON))
            score*=1.2
          end
        else
          score*=0
        end
      end
    when 0x147 # Fell Stinger
      if attacker.stages[PBStats::ATTACK]!=6
        if score>=100
          score*=2
          if !@doublebattle
            if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
              score*=2
            end
          end
        end
      end
    when 0x148 # Ion Deluge
      maxnormal = checkAIbest(aimem,1,[PBTypes::NORMAL],false,attacker,opponent,skill)
      if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        score*=0.9
      elsif (!attacker.abilitynulled && attacker.ability == PBAbilities::MOTORDRIVE)
        if maxnormal
          score*=1.5
        end
      end
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::LIGHTNINGROD) || (!attacker.abilitynulled && attacker.ability == PBAbilities::VOLTABSORB) || SilvallyCheck(attacker,PBTypes::ELECTRIC)
        if ((attacker.hp.to_f)/attacker.totalhp)<0.6
          if maxnormal
            score*=1.5
          end
        end
      end
      if attacker.pbHasType?(:GROUND)
        score*=1.1
      end
      if @field.effects[PBEffects::ElectricTerrain]>0
        score*=0.5
      end
      if @doublebattle
        if (!attacker.pbPartner.abilitynulled && attacker.pbPartner.ability == PBAbilities::MOTORDRIVE) || (!attacker.pbPartner.abilitynulled && attacker.pbPartner.ability == PBAbilities::LIGHTNINGROD) || (!attacker.pbPartner.abilitynulled && attacker.pbPartner.ability == PBAbilities::VOLTABSORB) || SilvallyCheck(attacker.pbpartner,"electric")
          score*=1.2
        end
        if attacker.pbPartner.pbHasType?(:GROUND)
          score*=1.1
        end
      end
      if !maxnormal
        score*=0.5
      end
      if $fefieldeffect != 35 && $fefieldeffect != 1 && $fefieldeffect != 22
        miniscore = getFieldDisruptScore(attacker,opponent,skill)
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::SURGESURFER)
          miniscore*=1.5
        end
        if attacker.pbHasType?(:ELECTRIC)
          miniscore*=1.5
        end
        elecvar=false
        for mon in pbParty(attacker.index)
          next if mon.nil?
          if mon.hasType?(:ELECTRIC)
            elecvar=true
          end
        end
        if elecvar
          miniscore*=1.5
        end
        if opponent.pbHasType?(:ELECTRIC)
          miniscore*=0.5
        end
        for m in attacker.moves
          if m.function==0x03
            miniscore*=0.5
            break
          end
        end
        if (attitemworks && attacker.item == PBItems::AMPLIFIELDROCK)
          miniscore*=2
        end
        score*=miniscore
      end
    when 0x149 # Crafty Shield
      if attacker.lastMoveUsed==565
        score*=0.5
      else
        nodam = true
        for m in opponent.moves
          if m.basedamage>0
            nodam=false
            break
          end
        end
        if nodam
          score+=10
        end
        if attacker.hp==attacker.totalhp
          score*=1.5
        end
      end
      if $fefieldeffect==31
        score+=25
        miniscore=100
        if attacker.effects[PBEffects::Substitute]>0 || attacker.effects[PBEffects::Disguise] || (attacker.effects[PBEffects::IceFace] && !specmove) || (attacker.effects[PBEffects::IceFace] && $fefieldeffect==39)
          miniscore*=1.5
        end
        if initialscores.length>0
          miniscore*=1.3 if hasbadmoves(initialscores,scoreindex,20)
        end
        if (attacker.hp.to_f)/attacker.totalhp>0.75
          miniscore*=1.1
        end
        if opponent.effects[PBEffects::HyperBeam]>0
          miniscore*=1.2
        end
        if opponent.effects[PBEffects::Yawn]>0
          miniscore*=1.3
        end
        miniscore*=1.1 if checkAIdamage(aimem,attacker,opponent,skill) < attacker.hp*0.3 
        if attacker.turncount<2
          miniscore*=1.1
        end
        if opponent.status!=0
          miniscore*=1.1
        end
        if opponent.status==PBStatuses::SLEEP || opponent.status==PBStatuses::FROZEN
          miniscore*=1.3
        end
        if opponent.effects[PBEffects::Encore]>0
          if opponent.moves[(opponent.effects[PBEffects::EncoreIndex])].basedamage==0
            miniscore*=1.5
          end
        end
        if attacker.effects[PBEffects::Confusion]>0
          miniscore*=0.5
        end
        if attacker.effects[PBEffects::LeechSeed]>=0 || attacker.effects[PBEffects::Attract]>=0
          miniscore*=0.3
        end
        if attacker.effects[PBEffects::Toxic]>0
          miniscore*=0.2
        end
        miniscore*=0.2 if checkAImoves(PBStuff::SWITCHOUTMOVE,aimem)
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::SIMPLE)
          miniscore*=2
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent,PBTypes::FAIRY)
          miniscore*=0.5
        end
        if @doublebattle
          miniscore*=0.3
        end
        miniscore*=0.3 if checkAIdamage(aimem,attacker,opponent,skill)<attacker.hp*0.12 
        miniscore/=100.0
        score*=miniscore
        miniscore=100
        if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
          miniscore*=1.5
        end
        if (attitemworks && attacker.item == PBItems::LEFTOVERS) || ((attitemworks && attacker.item == PBItems::BLACKSLUDGE) && attacker.pbHasType?(:POISON))
          miniscore*=1.2
        end
        healmove=false
        for j in attacker.moves
          if j.isHealingMove?
            healmove=true
          end
        end
        if healmove
          miniscore*=1.7
        end
        if attacker.pbHasMove?((PBMoves::LEECHSEED))
          miniscore*=1.3
        end
        if attacker.pbHasMove?((PBMoves::PAINSPLIT))
          miniscore*=1.2
        end
        if attacker.stages[PBStats::SPDEF]!=6 && attacker.stages[PBStats::DEFENSE]!=6
          score*=miniscore
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
          score=0
        end
      end
    when 0x14A # Doesn't exist
    when 0x14B # Doesn't exist
    when 0x14C # Doesn't exist
    when 0x14D # Doesn't exist
    when 0x14E # Doesn't exist
    when 0x14F # Doesn't exist
    when 0x150 # Flower Shield
      opp1 = attacker.pbOppositeOpposing
      opp2 = opp1.pbPartner
      if @doublebattle && opponent.pbHasType?(:GRASS) && opponent==attacker.pbPartner && opponent.stages[PBStats::DEFENSE]!=6
        if $fefieldeffect!=33 || $fecounter==0
          if opp1.attack>opp1.spatk
            score*=2
          else
            score*=0.5
          end
          if opp2.attack>opp2.spatk
            score*=2
          else
            score*=0.5
          end
        else
          score*=2
        end
        if initialscores.length>0
          score*=1.3 if hasbadmoves(initialscores,scoreindex,20)
        end
        if (opponent.hp.to_f)/opponent.totalhp>0.75
          score*=1.1
        end
        if opponent.effects[PBEffects::LeechSeed]>=0 || opponent.effects[PBEffects::Attract]>=0 || opponent.status!=0 || opponent.effects[PBEffects::Yawn]>0
          score*=0.3
        end
        if movecheck
          score*=0.2
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::SIMPLE)
          score*=2
        end
        if (!opp1.abilitynulled && opp1.ability == PBAbilities::UNAWARE) || SilvallyCheck(opp1, PBTypes::FAIRY)
          score*=0.5
        end
        if $fefieldeffect==33 && $fecounter!=4
          score+=30
        end
        if ($fefieldeffect==33 && $fecounter>0) || $fefieldeffect==31
          score+=20
          miniscore=100
          if attacker.effects[PBEffects::Substitute]>0 || attacker.effects[PBEffects::Disguise] || (attacker.effects[PBEffects::IceFace] && !specmove) || (attacker.effects[PBEffects::IceFace] && $fefieldeffect==39)
            miniscore*=1.5
          end
          if initialscores.length>0
            miniscore*=1.3 if hasbadmoves(initialscores,scoreindex,20)
          end
          if (opponent.hp.to_f)/opponent.totalhp>0.75
            miniscore*=1.1
          end
          if opp1.effects[PBEffects::HyperBeam]>0
            miniscore*=1.2
          end
          if opp1.effects[PBEffects::Yawn]>0
            miniscore*=1.3
          end
          miniscore*=1.1 if checkAIdamage(aimem,attacker,opponent,skill) < opponent.hp*0.3 
          if opponent.turncount<2
            miniscore*=1.1
          end
          if opp1.status!=0
            miniscore*=1.1
          end
          if opp1.status==PBStatuses::SLEEP || opp1.status==PBStatuses::FROZEN
            miniscore*=1.3
          end
          if opp1.effects[PBEffects::Encore]>0
            if opp1.moves[(opp1.effects[PBEffects::EncoreIndex])].basedamage==0
              miniscore*=1.5
            end
          end
          if opponent.effects[PBEffects::Confusion]>0
            miniscore*=0.5
          end
          if opponent.effects[PBEffects::LeechSeed]>=0 || attacker.effects[PBEffects::Attract]>=0
            miniscore*=0.3
          end
          if opponent.effects[PBEffects::Toxic]>0
            miniscore*=0.2
          end
          miniscore*=0.2 if checkAImoves(PBStuff::SWITCHOUTMOVE,aimem)
          if (!opponent.abilitynulled && opponent.ability == PBAbilities::SIMPLE)
            miniscore*=2
          end
          if (!opp1.abilitynulled && opp1.ability == PBAbilities::UNAWARE) || SilvallyCheck(opp1, PBTypes::FAIRY)
            miniscore*=0.5
          end
          if @doublebattle
            miniscore*=0.3
          end
          miniscore*=0.3 if checkAIdamage(aimem,attacker,opponent,skill)<opponent.hp*0.12
          miniscore/=100.0
          score*=miniscore
          miniscore=100
          if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
            miniscore*=1.5
          end
          if (attitemworks && attacker.item == PBItems::LEFTOVERS) || ((attitemworks && attacker.item == PBItems::BLACKSLUDGE) && attacker.pbHasType?(:POISON))
            miniscore*=1.2
          end
          healmove=false
          for j in attacker.moves
            if j.isHealingMove?
              healmove=true
            end
          end
          if healmove
            miniscore*=1.7
          end
          if attacker.pbHasMove?((PBMoves::LEECHSEED))
            miniscore*=1.3
          end
          if attacker.pbHasMove?((PBMoves::PAINSPLIT))
            miniscore*=1.2
          end
          if attacker.stages[PBStats::SPDEF]!=6 && attacker.stages[PBStats::DEFENSE]!=6
            score*=miniscore
          end
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
            score=0
          end
        end
      else
        score*=0
      end
    when 0x151 # Rototiller
      opp1 = attacker.pbOppositeOpposing
      opp2 = opp1.pbPartner
      if @doublebattle && opponent.pbHasType?(:GRASS) && opponent==attacker.pbPartner && opponent.stages[PBStats::SPATK]!=6 && opponent.stages[PBStats::ATTACK]!=6
        if initialscores.length>0
          score*=1.3 if hasbadmoves(initialscores,scoreindex,20)
        end
        if (opponent.hp.to_f)/opponent.totalhp>0.75
          score*=1.1
        end
        if opponent.effects[PBEffects::LeechSeed]>=0 || opponent.effects[PBEffects::Attract]>=0 || opponent.status!=0 || opponent.effects[PBEffects::Yawn]>0
          score*=0.3
        end
        if movecheck
          score*=0.2
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::SIMPLE)
          score*=2
        end
        if (!opp1.abilitynulled && opp1.ability == PBAbilities::UNAWARE) || SilvallyCheck(opp1, PBTypes::FAIRY)
          score*=0.5
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::CONTRARY)
          score*=0
        end
        if $fefieldeffect==33 && $fecounter!=4
          score+=30
        end
        if $fefieldeffect==33
          score+=20
          miniscore=100
          if attacker.effects[PBEffects::Substitute]>0 || attacker.effects[PBEffects::Disguise] || (attacker.effects[PBEffects::IceFace] && !specmove) || (attacker.effects[PBEffects::IceFace] && $fefieldeffect==39)
            miniscore*=1.5
          end
          if initialscores.length>0
            miniscore*=1.3 if hasbadmoves(initialscores,scoreindex,20)
          end
          if (opponent.hp.to_f)/opponent.totalhp>0.75
            miniscore*=1.1
          end
          if opp1.effects[PBEffects::HyperBeam]>0
            miniscore*=1.2
          end
          if opp1.effects[PBEffects::Yawn]>0
            miniscore*=1.3
          end
          miniscore*=1.1 if checkAIdamage(aimem,attacker,opponent,skill) < opponent.hp*0.25 
          if opponent.turncount<2
            miniscore*=1.1
          end
          if opp1.status!=0
            miniscore*=1.1
          end
          if opp1.status==PBStatuses::SLEEP || opp1.status==PBStatuses::FROZEN
            miniscore*=1.3
          end
          if opp1.effects[PBEffects::Encore]>0
            if opp1.moves[(opp1.effects[PBEffects::EncoreIndex])].basedamage==0
              miniscore*=1.5
            end
          end
          if opponent.effects[PBEffects::Confusion]>0
            miniscore*=0.2
          end
          if opponent.effects[PBEffects::LeechSeed]>=0 || attacker.effects[PBEffects::Attract]>=0
            miniscore*=0.6
          end
          miniscore*=0.5 if checkAImoves(PBStuff::SWITCHOUTMOVE,aimem)
          if (!opponent.abilitynulled && opponent.ability == PBAbilities::SIMPLE)
            miniscore*=2
          end
          if (!opp1.abilitynulled && opp1.ability == PBAbilities::UNAWARE) || SilvallyCheck(opp1, PBTypes::FAIRY)
            miniscore*=0.5
          end
          if @doublebattle
            miniscore*=0.3
          end
          ministat=0
          ministat+=opponent.stages[PBStats::SPEED] if opponent.stages[PBStats::SPEED]<0
          ministat*=5
          ministat+=100
          ministat/=100.0
          miniscore*=ministat
          ministat=0
          ministat+=opponent.stages[PBStats::ATTACK]
          ministat+=opponent.stages[PBStats::SPEED]
          ministat+=opponent.stages[PBStats::SPATK]
          if ministat > 0
            ministat*=(-5)
            ministat+=100
            ministat/=100.0
            miniscore*=ministat
          end
          miniscore/=100.0
          score*=miniscore
          miniscore=100
          miniscore*=1.3 if checkAIhealing(aimem)
          if attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill) && @trickroom==0
            miniscore*=1.5
          end
          if roles.include?(PBMonRoles::SWEEPER)
            miniscore*=1.3
          end
          if attacker.status==PBStatuses::PARALYSIS
            miniscore*=0.5
          end
          miniscore*=0.3 if checkAImoves([PBMoves::FOULPLAY],aimem)
          if attacker.hp==attacker.totalhp && (attitemworks && attacker.item == PBItems::FOCUSSASH)
            miniscore*=1.4
          end
          miniscore*=0.4 if checkAIpriority(aimem)
          if attacker.stages[PBStats::SPATK]!=6 && attacker.stages[PBStats::ATTACK]!=6
            score*=miniscore
          end
        end
      else
        score*=0
      end
    when 0x152 # Powder
      firecheck = false
      movecount = 0
      if aimem.length > 0
        for j in aimem
          movecount+=1
          if j.type == (PBTypes::FIRE)
            firecheck = true
          end
        end
      end
      if !(opponent.pbHasType?(:GRASS) || (!opponent.abilitynulled && opponent.ability == PBAbilities::OVERCOAT) || (oppitemworks && opponent.item == PBItems::SAFETYGOGGLES))
        if (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
          score*=1.2
        end
        if checkAIbest(aimem,1,[PBTypes::FIRE],false,attacker,opponent,skill)
          score*=3
        else
          if opponent.pbHasType?(:FIRE)
            score*=2
          else
            score*=0.2
          end
        end
        effcheck = PBTypes.getCombinedEffectiveness((PBTypes::FIRE),attacker.type1,attacker.type2)
        if effcheck>4
          score*=2
          if effcheck>8
            score*=2
          end
        end
        if attacker.lastMoveUsed==600
          score*=0.6
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::MAGICGUARD)
          score*=0.5
        end
        if !firecheck && movecount==4
          score*=0
        end
      else
        score*=0
      end
    when 0x153 # Electrify
      startscore = score
      if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::VOLTABSORB)
          if attacker.hp<attacker.totalhp*0.8
            score*=1.5
          else
            score*=0.1
          end
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::LIGHTNINGROD)
          if attacker.spatk > attacker.attack && attacker.stages[PBStats::SPATK]!=6
            score*=1.5
          else
            score*=0.1
          end
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::MOTORDRIVE) || SilvallyCheck(attacker,PBTypes::ELECTRIC)
          if attacker.stages[PBStats::SPEED]!=6
            score*=1.2
          else
            score*=0.1
          end
        end
        if attacker.pbHasType?(:GROUND)
          score*=1.3
        end
        if score==startscore
          score*=0.1
        end
        score*=0.5 if checkAIpriority(aimem)
      else
        score*=0
      end
    when 0x154 # Mat Block
      if attacker.turncount==0
        if @doublebattle
          score*=1.3
          if ((attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) && ((attacker.pbSpeed>pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0))
            score*=1.2
          else
            score*=0.7
            if ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) && ((attacker.pbSpeed<pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0))
              score*=0
            end
          end
          score*=0.3 if checkAImoves(PBStuff::SETUPMOVE,aimem) && checkAIhealing(aimem)
          if (attitemworks && attacker.item == PBItems::LEFTOVERS) || ((attitemworks && attacker.item == PBItems::BLACKSLUDGE) && attacker.pbHasType?(:POISON)) || attacker.effects[PBEffects::Ingrain] || attacker.effects[PBEffects::AquaRing] || $fefieldeffect==2
            score*=1.2
          end
          if opponent.status==PBStatuses::POISON || opponent.status==PBStatuses::BURN
            score*=1.2
            if opponent.effects[PBEffects::Toxic]>0
              score*=1.3
            end
          end
          if attacker.status==PBStatuses::POISON || attacker.status==PBStatuses::BURN
            score*=0.7
            if attacker.effects[PBEffects::Toxic]>0
              score*=0.3
            end
          end
          if opponent.effects[PBEffects::LeechSeed]>=0
            score*=1.3
          end
          if opponent.effects[PBEffects::PerishSong]!=0
            score*=2
          end
          if opponent.status==PBStatuses::SLEEP || opponent.status==PBStatuses::FROZEN
            score*=0.3
          end
          if opponent.vanished
            score*=2
            if (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
              score*=1.5
            end
          end
          score*=0.1 if checkAImoves(PBStuff::PROTECTMOVE,aimem)
          if attacker.effects[PBEffects::Wish]>0
            score*=1.3
          end
        end
      else
        score*=0
      end
    when 0x155 # Thousand Waves
      if !(opponent.effects[PBEffects::MeanLook]>=0 || opponent.effects[PBEffects::Ingrain] || opponent.pbHasType?(:GHOST)) && opponent.effects[PBEffects::Substitute]<=0
        score*=0.1 if checkAImoves(PBStuff::PIVOTMOVE,aimem)
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::RUNAWAY)
          score*=0.1
        end
        if attacker.pbHasMove?((PBMoves::PERISHSONG))
          score*=1.5
        end
        if opponent.effects[PBEffects::PerishSong]>0
          score*=4
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::ARENATRAP) || (!attacker.abilitynulled && attacker.ability == PBAbilities::SHADOWTAG)
          score*=0
        end
        if opponent.effects[PBEffects::Attract]>=0
          score*=1.3
        end
        if opponent.effects[PBEffects::LeechSeed]>=0
          score*=1.3
        end
        if opponent.effects[PBEffects::Curse]
          score*=1.5
        end
        miniscore*=0.7 if attacker.moves.any? {|moveloop| (PBStuff::SWITCHOUTMOVE).include?(moveloop.id)}
        if !hasgreatmoves(initialscores,scoreindex,skill,true,true)
          ministat=(-5)*statchangecounter(opponent,1,7)
          ministat+=100
          ministat/=100.0
          score*=ministat
        end
        if opponent.effects[PBEffects::Confusion]>0
          score*=1.1
        end
      end
    when 0x156 # Thousand Arrows - to do
    when 0x157 # Hyperspace Hole
      if checkAImoves(PBStuff::PROTECTMOVE,aimem)
        score*=1.1
        ratesharers=[
          391,   # Protect
          121,   # Detect
          122,   # Quick Guard
          515,   # Wide Guard
          361,   # Endure
          584,   # King's Shield
          603,    # Spiky Shield
          641,    # Baneful Bunker
          786    # Obstruct  
        ]
        if !ratesharers.include?(opponent.lastMoveUsed)
          score*=1.2
        end
      end
      if !(!attacker.abilitynulled && attacker.ability == PBAbilities::NOGUARD) && !(!opponent.abilitynulled && opponent.ability == PBAbilities::NOGUARD)
        if attacker.stages[PBStats::ACCURACY]<0
          miniscore = (-5)*attacker.stages[PBStats::ACCURACY]
          miniscore+=100
          miniscore/=100.0
          score*=miniscore
        end
        if opponent.stages[PBStats::EVASION]>0
          miniscore = (5)*opponent.stages[PBStats::EVASION]
          miniscore+=100
          miniscore/=100.0
          score*=miniscore
        end
        if (oppitemworks && opponent.item == PBItems::LAXINCENSE) || (oppitemworks && opponent.item == PBItems::BRIGHTPOWDER)
          score*=1.2
        end
        if ((!opponent.abilitynulled && opponent.ability == PBAbilities::SANDVEIL) && pbWeather==PBWeather::SANDSTORM) || ((!opponent.abilitynulled && opponent.ability == PBAbilities::SNOWCLOAK) && pbWeather==PBWeather::HAIL)
          score*=1.3
        end
        if opponent.vanished && ((attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0))
          score*=3
        end
      end
    when 0x158 # Oblivion Wing
      minimini = score*0.01
      miniscore = (opponent.hp*minimini)*(3.0/4.0)
      if miniscore > (attacker.totalhp-attacker.hp)
        miniscore = (attacker.totalhp-attacker.hp)
      end
      if attacker.totalhp>0
        miniscore/=(attacker.totalhp).to_f
      end
      if attacker.hasWorkingItem(:BIGROOT)
        miniscore*=1.3
      end
      miniscore+=1
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::LIQUIDOOZE)
        miniscore = (2-miniscore)
      end
      if (attacker.hp!=attacker.totalhp || ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0))) && opponent.effects[PBEffects::Substitute]==0
        score*=miniscore
      end
    when 0x159 # Hyperspace Fury
      startscore = score
      if attacker.species==720 && attacker.form==1 # Hoopa-U
        if checkAImoves(PBStuff::PROTECTMOVE,aimem)
          score*=1.1
          ratesharers=[
            391,   # Protect
            121,   # Detect
            122,   # Quick Guard
            515,   # Wide Guard
            361,   # Endure
            584,   # King's Shield
            603,    # Spiky Shield
            641,    # Baneful Bunker
            786    # Obstruct  
          ]
          if !ratesharers.include?(opponent.lastMoveUsed)
            score*=1.2
          end
        end
        if !(!attacker.abilitynulled && attacker.ability == PBAbilities::NOGUARD) && !(!opponent.abilitynulled && opponent.ability == PBAbilities::NOGUARD)
          if attacker.stages[PBStats::ACCURACY]<0
            miniscore = (-5)*attacker.stages[PBStats::ACCURACY]
            miniscore+=100
            miniscore/=100.0
            score*=miniscore
          end
          if opponent.stages[PBStats::EVASION]>0
            miniscore = (5)*opponent.stages[PBStats::EVASION]
            miniscore+=100
            miniscore/=100.0
            score*=miniscore
          end
          if (oppitemworks && opponent.item == PBItems::LAXINCENSE) || (oppitemworks && opponent.item == PBItems::BRIGHTPOWDER)
            score*=1.2
          end
          if ((!opponent.abilitynulled && opponent.ability == PBAbilities::SANDVEIL) && pbWeather==PBWeather::SANDSTORM) || ((!opponent.abilitynulled && opponent.ability == PBAbilities::SNOWCLOAK) && pbWeather==PBWeather::HAIL)
            score*=1.3
          end
          if opponent.vanished && (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
            score*=3
          end
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
          score*=1.7
        else
          if startscore<100
            score*=0.8
            if (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
              score*=1.2
            else
              score*=0.8
            end
            score*=0.7 if checkAIhealing(aimem)
            if initialscores.length>0
              score*=0.5 if hasgreatmoves(initialscores,scoreindex,skill)
            end
            miniscore=100
            if opponent.pbNonActivePokemonCount!=0
              miniscore*=opponent.pbNonActivePokemonCount
              miniscore/=1000.0
              miniscore= 1-miniscore
              score*=miniscore
            end
            if opponent.pbNonActivePokemonCount!=0 && attacker.pbNonActivePokemonCount==0
              score*=0.7
            end
          end
        end
      else
        score*=0
      end
    when 0x15A # Future Sight Dummy
    when 0x15B # Aurora Veil
      if attacker.pbOwnSide.effects[PBEffects::AuroraVeil]<=0
        if pbWeather==PBWeather::HAIL || (skill>=PBTrainerAI.highSkill && ($fefieldeffect==28 || $fefieldeffect==30 || $fefieldeffect==34 || $fefieldeffect==39 || $fefieldeffect==4 || $fefieldeffect==9 || $fefieldeffect==13 || $fefieldeffect==25))
          score*=1.5
          if attacker.pbOwnSide.effects[PBEffects::AuroraVeil]>0
            score*=0.1
          end
          if (attitemworks && attacker.item == PBItems::LIGHTCLAY) 
            score*=1.5
          end
          if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
            score*=1.1
            score*=2 if checkAIdamage(aimem,attacker,opponent,skill)>attacker.hp && (checkAIdamage(aimem,attacker,opponent,skill)/2.0)<attacker.hp
          end
          if attacker.hp==attacker.totalhp && ((attacker.hasWorkingItem(:FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) && !attacker.moldbroken) || (isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST)))  && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
            score*=1.3
          end
          for i in pbParty(opponent.index)
            next if i.nil?
            if (i.ability == PBAbilities::SCREENCLEANER) && i.hp>0
              score*=0.7
            end
          end
          score*=0.1 if checkAImoves([PBMoves::DEFOG],aimem)
          if @doublebattle && !opponent.pbPartner.isFainted?
            score*=0.1 if checkAImoves([PBMoves::DEFOG],aimem2)
          end
          score*=0.1 if checkAImoves([PBMoves::SNATCH],aimem)
          if @doublebattle && !opponent.pbPartner.isFainted?
            score*=0.1 if checkAImoves([PBMoves::SNATCH],aimem2)
          end
          score*=0.1 if checkAImoves(PBStuff::SCREENBREAKERMOVE,aimem)
          breakcheck=false
          if !(opponent.pbPartner.nil?)
            if @doublebattle && @aiMoveMemory[2][opponent.pbPartner.pokemonIndex].length>0 && opponent.pbPartner.hp>0 
              for j in @aiMoveMemory[2][opponent.pbPartner.pokemonIndex]
                breakcheck = true if (PBStuff::SCREENBREAKERMOVE).include?(j.id)
              end
            end
          end
          score*=0.1 if breakcheck
          if skill>=PBTrainerAI.highSkill
            if $fefieldeffect==30 # Mirror
              score*=1.5
            end
          end
        else
          score=0
        end
      else
        score=0
      end
    when 0x15C # Baneful Bunker
      if opponent.effects[PBEffects::Taunt]==0
        score*=0.3 if opponent.moves.any? {|moveloop| (PBStuff::SETUPMOVE).include?(moveloop.id)}
      end
      if ((!attacker.abilitynulled && attacker.ability == PBAbilities::SPEEDBOOST) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STEAMENGINE) && $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==21 || $fefieldeffect==22 || $fefieldeffect==45)) && attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill) && @trickroom==0
        score*=4 if (attacker.pbSpeed*1.5>pbRoughStat(opponent,PBStats::SPEED,skill))
        score*=6 if initialscores.length>0 && hasgreatmoves(initialscores,scoreindex,skill)
      end
      score*=1.1 if (isConst?(opponent.species,PBSpecies,:FERALIGATR) && oppitemworks && opponent.item == PBItems::FERACREST && opponent.turncount==0)
      score*=1.2 if (opponent.status==PBStatuses::POISON || opponent.status==PBStatuses::BURN)
      score*=1.3 if opponent.effects[PBEffects::Toxic]>0
      hpchange=(EndofTurnHPChanges(attacker,opponent,false,false,true)) # what % of our hp will change after end of turn effects go through
      maxdam=checkAIdamage(aimem,attacker,opponent,skill)
      if hpchange>1 ## we are going to be healing more hp than we take chip damage for  
        if attacker.hp!=attacker.totalhp
          score*=(1.3*hpchange) 
          if maxdam>attacker.hp
            healing=((attacker.totalhp*(hpchange-1)))
            if attacker.hp+(healing)>maxdam
              score*=2
            end
          end
        end
      elsif hpchange<1 ## we are going to be taking more chip damage than we are going to heal
        score*=(1*hpchange)
        score*=0.3 if attacker.effects[PBEffects::Toxic]>4
      elsif hpchange<=0 ## we are going to die to future sight/doom desire or huge overstack of end of turn effects. hence we should just not heal.
        score*=0.1
      end
      score*=2 if opponent.effects[PBEffects::PerishSong]!=0
      opphpchange=(EndofTurnHPChanges(opponent,attacker,false,false,true)) # what % of our hp will change after end of turn effects go through
      maxdam2=checkAIdamage(aimem,opponent,attacker,skill)
      if opphpchange!=1
        if opphpchange<1
          opphploss=1-opphpchange
          if opphploss<1
            opphploss=(opphploss*opponent.totalhp)
            if opphploss>(opponent.totalhp/4)
              score*=1.5
              if maxdam>attacker.hp
                score*=2
              end
            end
            if opphploss>opponent.hp
              if !(attacker.lastMoveUsed == 391)
                score*=2
              end
              if ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) 
                if maxdam>attacker.hp
                  score*=4
                  if attacker.lastMoveUsed == 391
                    score/=(attacker.effects[PBEffects::ProtectRate]*3.0)
                  end
                end
              end
            else
              if ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) && maxdam>attacker.hp
                score*=4
              else
                if maxdam>attacker.hp
                  score*=4
                  if attacker.lastMoveUsed == 391
                    score/=(attacker.effects[PBEffects::ProtectRate]*3.0)
                  end
                end
              end
            end
          end
        end
      end
      if pbWeather!=@weatherbackup
        score*=2 if (!attacker.abilitynulled && attacker.ability == PBAbilities::SWIFTSWIM) && (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) && @weatherbackup==PBWeather::RAINDANCE && @weatherduration==1
        score*=2 if (!attacker.abilitynulled && attacker.ability == PBAbilities::SANDRUSH) && (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) && @weatherbackup==PBWeather::SANDSTORM && @weatherduration==1
        score*=2 if (!attacker.abilitynulled && attacker.ability == PBAbilities::CHLOROPHYLL) && (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) && @weatherbackup==PBWeather::SUNNYDAY && @weatherduration==1
        score*=2 if (!attacker.abilitynulled && attacker.ability == PBAbilities::SLUSHRUSH) && (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) && @weatherbackup==PBWeather::HAIL && @weatherduration==1
      end
      score*=0.3 if opponent.status==PBStatuses::SLEEP || opponent.status==PBStatuses::FROZEN
      if opponent.vanished
        score*=2
        score*=1.5 if (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
      end
      if @doublebattle && !(attacker.lastMoveUsed == 693)
        if !(opponent.isFainted?) && !(opponent.pbPartner.isFainted?)
          maxdam3=checkAIdamage(aimem,opponent,attacker.pbPartner,skill)
          maxdam4=checkAIdamage(aimem,opponent.pbPartner,attacker.pbPartner,skill)
          maxdam5=checkAIdamage(aimem,attacker.pbPartner,opponent,skill)
          maxdam6=checkAIdamage(aimem,attacker.pbPartner,opponent.pbPartner,skill)
          maxdam7=checkAIdamage(aimem,attacker,opponent.pbPartner,skill)
          if ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0) && (((attacker.pbPartner.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0) && maxdam3>opponent.hp) || ((attacker.pbSpeed<pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0) && (attacker.pbPartner.pbSpeed>pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0) && maxdam4>opponent.pbPartner.hp)))
            if (maxdam>attacker.hp || maxdam7>attacker.hp || maxdam+maxdam7>attacker.hp && (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0) && (attacker.pbSpeed<pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0))
              score*=4
            end
          end
        end
      end
      if attacker.effects[PBEffects::KingsShield]== true  ||
        attacker.effects[PBEffects::BanefulBunker]== true ||
        attacker.effects[PBEffects::SpikyShield]== true
        score*=0
      end
      score*=0.1 if checkAImoves(PBStuff::PROTECTIGNORINGMOVE,aimem)
      if !(opponent.effects[PBEffects::Attacking]==true)
        if !(opponent.effects[PBEffects::AttackingTarget].include?(attacker.index))
          rnd=pbAIRandom(10)
          if rnd>=7
            score*=0.01 
          end
        end
      end
      if attacker.effects[PBEffects::Wish]>0
        if attacker.hp!=attacker.totalhp
          if checkAIdamage(aimem,attacker,opponent,skill)>attacker.hp
            score*=10
          else
            score*=3
          end
          score*=6 if initialscores.length>0 && hasgreatmoves(initialscores,scoreindex,skill)
        end
      end
      if aimem.length > 0
        contactcheck=false
        maxdam=0
        for j in aimem
          contactcheck=j.isContactMove?
        end
      end
      if opponent.status!=0
        score*=0.8
      else
        if opponent.pbCanPoison?(false)
          score*=1.3 if contactcheck
          score*=1.3 if ((!attacker.abilitynulled && attacker.ability == PBAbilities::MERCILESS) || attacker.pbHasMove?(getID(PBMoves,:VENOSHOCK)) || (isConst?(attacker.species,PBSpecies,:ARIADOS) && attacker.hasWorkingItem(:ARIACREST)))
          score*=0.3 if (!opponent.abilitynulled && opponent.ability == PBAbilities::POISONHEAL) || (isConst?(opponent.species,PBSpecies,:ZANGOOSE) && isConst?(opponent.item,PBItems,:ZANGCREST))
          score*=0.7 if (!opponent.abilitynulled && opponent.ability == PBAbilities::TOXICBOOST) || (!opponent.abilitynulled && opponent.ability == PBAbilities::GUTS) || (!opponent.abilitynulled && opponent.ability == PBAbilities::QUICKFEET)
        end
      end
      ratesharers=[391,121,122,515,361,584,603,641,786]   # Protect, Detect, Quick Guard, Wide Guard, Endure, King's Shield, Spiky Shield, Baneful Bunker, Obstruct in that order
      score/=(attacker.effects[PBEffects::ProtectRate]*2.0) if ratesharers.include?(attacker.lastMoveUsed)
    when 0x15D # Beak Blast
      contactcheck = false
      if aimem.length > 0
        for j in aimem
          if j.isContactMove?
            contactcheck=true
          end
        end
      end
      if opponent.pbCanBurn?(false)
        miniscore=120
        ministat = 5*opponent.stages[PBStats::ATTACK]
        if ministat>0
          ministat+=100
          ministat/=100.0
          miniscore*=ministat
        end
        if !opponent.abilitynulled
          miniscore*=0.3 if opponent.ability == PBAbilities::NATURALCURE
          miniscore*=0.7 if opponent.ability == PBAbilities::MARVELSCALE || SilvallyCheck(opponent,"water")
          miniscore*=0.1 if opponent.ability == PBAbilities::GUTS || opponent.ability == PBAbilities::FLAREBOOST
          miniscore*=0.7 if opponent.ability == PBAbilities::SHEDSKIN
          miniscore*=0.5 if opponent.ability == PBAbilities::SYNCHRONIZE && attacker.status==0
          miniscore*=0.5 if opponent.ability == PBAbilities::MAGICGUARD
          miniscore*=0.3 if opponent.ability == PBAbilities::QUICKFEET
          miniscore*=1.1 if opponent.ability == PBAbilities::STURDY
        end
        miniscore*=0.1 if checkAImoves([PBMoves::REST],aimem)
        miniscore*=0.2 if checkAImoves([PBMoves::FACADE],aimem)
        if opponent.attack > opponent.spatk
          miniscore*=1.7
        end
        if opponent.effects[PBEffects::Yawn]>0
          miniscore*=0.4
        end
        if startscore==110
          miniscore*=0.8
        end
        miniscore-=100
        minimini = 100
        if contactcheck
          minimini*=1.5
        else
          if opponent.attack>opponent.spatk
            minimini*=1.3
          else
            minimini*=0.3
          end
        end
        minimini/=100.0
        miniscore*=minimini
        miniscore+=100
        miniscore/=100.0
        score*=miniscore
      end
      if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        score*=0.7
      end
    when 0x15E # Burn Up
      maxdam=0
      maxtype = -1
      healvar=false
      if aimem.length > 0
        for j in aimem
          healvar=true if j.isHealingMove?
          tempdam = pbRoughDamage(j,opponent,attacker,skill,j.basedamage)
          if tempdam>maxdam
            maxdam=tempdam
            maxtype = j.type
          end
        end
      end
      if !attacker.pbHasType?(:FIRE)
        score*=0
      else
        if score<100
          score*=0.9
          if healvar
            score*=0.5
          end
        end
        if initialscores.length>0
          score*=0.5 if hasgreatmoves(initialscores,scoreindex,skill)
        end
        miniscore=100
        if opponent.pbNonActivePokemonCount!=0
          miniscore*=opponent.pbNonActivePokemonCount
          miniscore/=100.0
          miniscore*=0.05
          miniscore = 1-miniscore
          score*=miniscore
        end
        if attacker.pbNonActivePokemonCount==0 && opponent.pbNonActivePokemonCount!=0
          score*=0.7
        end
        effcheck = PBTypes.getCombinedEffectiveness(opponent.type1,(PBTypes::FIRE),(PBTypes::FIRE))
        if effcheck > 4
          score*=1.5
        else
          if effcheck<4
            score*=0.5
          end
        end
        effcheck = PBTypes.getCombinedEffectiveness(opponent.type2,(PBTypes::FIRE),(PBTypes::FIRE))
        if effcheck > 4
          score*=1.5
        else
          if effcheck<4
            score*=0.5
          end
        end
        if maxtype!=-1
          effcheck = PBTypes.getCombinedEffectiveness(maxtype,(PBTypes::FIRE),(PBTypes::FIRE))
          if effcheck > 4
            score*=1.5
          else
            if effcheck<4
              score*=0.5
            end
          end
        end
      end
    when 0x15F # Clanging Scales
      maxdam=0
      maxphys = false
      healvar=false
      privar=false
      if aimem.length > 0
        for j in aimem
          healvar=true if j.isHealingMove?
          privar=true if j.priority>0
          tempdam = pbRoughDamage(j,opponent,attacker,skill,j.basedamage)
          if tempdam>maxdam
            maxdam=tempdam
            maxphys = j.pbIsPhysical?(j.type)
          end
        end
      end
      maxdam=checkAIdamage(aimem,attacker,opponent,skill)
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        score*=1.5
      else
        if score<100
          score*=0.8
          if (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
            score*=1.3
          else
            score*=1.2 if checkAIpriority(aimem)
          end
          score*=0.5 if checkAIhealing(aimem)
        end
        if initialscores.length>0
          if !(attitemworks && (attacker.item == PBItems::THROATSPRAY || attacker.item == PBItems::WHITEHERB))
            score*=0.5 if hasgreatmoves(initialscores,scoreindex,skill)
          end
        end
        miniscore=100
        if opponent.pbNonActivePokemonCount!=0
          miniscore*=opponent.pbNonActivePokemonCount
          miniscore/=100.0
          miniscore*=0.05
          miniscore = 1-miniscore
          score*=miniscore
        end
        if attacker.pbNonActivePokemonCount==0 && opponent.pbNonActivePokemonCount!=0
          score*=0.7
        end
        if opponent.attack>opponent.spatk
          score*=0.7
        end
        score*=0.7 if checkAIbest(aimem,2,[],false,attacker,opponent,skill)
      end
    when 0x160 # Core Enforcer
      if !((PBStuff::FIXEDABILITIES).include?(opponent.ability))  && !opponent.effects[PBEffects::GastroAcid]
        miniscore = getAbilityDisruptScore(move,attacker,opponent,skill)
        if (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
          miniscore*=1.3
        else
          miniscore*=0.5
        end
        miniscore*=1.3 if checkAIpriority(aimem)
        score*=miniscore
      end
    when 0x161 # First Impression
      if attacker.turncount!=0
        score=0
      end
    when 0x162 # Floral Healing
      if !@doublebattle || attacker.pbIsOpposing?(opponent.index)
        score*=0
      else
        if !attacker.pbIsOpposing?(opponent.index)
          if opponent.hp*(1.0/opponent.totalhp)<0.7 && opponent.hp*(1.0/opponent.totalhp)>0.3
            score*=1.5
          end
          if opponent.status==PBStatuses::POISON || opponent.status==PBStatuses::BURN || opponent.effects[PBEffects::LeechSeed]>=0 || opponent.effects[PBEffects::Curse]
            score*=0.8
            if opponent.effects[PBEffects::Toxic]>0
              score*=0.7
            end
          end
          if opponent.hp*(1.0/opponent.totalhp)>0.8
            if ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) && ((attacker.pbSpeed<pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0))
              score*=0.5
            else
              score*=0
            end
          end
        else
          score*=0
        end
      end
      if $fefieldeffect==2 || $fefieldeffect==31 || ($fefieldeffect==33 && $fecounter>1)
        score*=1.5
      end
      if attacker.status!=PBStatuses::POISON && ($fefieldeffect==10 || $fefieldeffect==11)
        score*=0.2
      end
    when 0x163 # Gear Up
      if !((!attacker.abilitynulled && attacker.ability == PBAbilities::PLUS) || (!attacker.abilitynulled && attacker.ability == PBAbilities::MINUS) || (!attacker.pbPartner.abilitynulled && attacker.pbPartner.ability == PBAbilities::PLUS) || (!attacker.pbPartner.abilitynulled && attacker.pbPartner.ability == PBAbilities::MINUS))
        score*=0
      else
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::PLUS) || (!attacker.abilitynulled && attacker.ability == PBAbilities::MINUS)
          miniscore = setupminiscore(attacker,opponent,skill,move,true,5,false,initialscores,scoreindex)
          if opponent.stages[PBStats::SPEED]<0
            ministat = 5*opponent.stages[PBStats::SPEED]
            ministat+=100
            ministat/=100.0
            miniscore*=ministat
          end
          ministat=0
          ministat+=opponent.stages[PBStats::ATTACK]
          ministat+=opponent.stages[PBStats::SPEED]
          ministat+=opponent.stages[PBStats::SPATK]
          if ministat>0
            ministat*=(-5)
            ministat+=100
            ministat/=100.0
            miniscore*=ministat
          end
          score*=miniscore
          miniscore=100
          miniscore*=1.3 if checkAIhealing(aimem)
          if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
            miniscore*=1.5
          end
          if roles.include?(PBMonRoles::SWEEPER)
            miniscore*=1.3
          end
          if attacker.status==PBStatuses::BURN || attacker.status==PBStatuses::PARALYSIS
            miniscore*=0.5
          end
          miniscore*=0.3 if checkAImoves([PBMoves::FOULPLAY],aimem)
          if attacker.hp==attacker.totalhp && ((attacker.hasWorkingItem(:FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) && !attacker.moldbroken) || (isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST)))  && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
            miniscore*=1.4
          end
          miniscore*=0.3 if checkAIpriority(aimem)
          physmove=false
          for j in attacker.moves
            if j.pbIsPhysical?(j.type)
              physmove=true
            end
          end
          specmove=false
          for j in attacker.moves
            if j.pbIsSpecial?(j.type)
              specmove=true
            end
          end
          if (!physmove || !attacker.pbTooHigh?(PBStats::ATTACK)) && (!specmove || !attacker.pbTooHigh?(PBStats::SPATK))
            miniscore/=100.0
            score*=miniscore
          end
        elsif @doublebattle && (!attacker.pbPartner.abilitynulled && attacker.pbPartner.ability == PBAbilities::PLUS) || (!attacker.pbPartner.abilitynulled && attacker.pbPartner.ability == PBAbilities::MINUS)
          if initialscores.length>0
            score*=1.3 if hasbadmoves(initialscores,scoreindex,20)
          end
          if attacker.pbPartner.hp>attacker.pbPartner.totalhp*0.75
            score*=1.1
          end
          if attacker.pbPartner.effects[PBEffects::Yawn]>0 || attacker.pbPartner.effects[PBEffects::LeechSeed]>=0 || attacker.pbPartner.effects[PBEffects::Attract]>=0 || attacker.pbPartner.status!=0
            score*=0.3
          end
          if movecheck
            score*=0.3
          end
          if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent,PBTypes::FAIRY)
            score*=0.5
          end
        else
          score*=0
        end
      end
    when 0x164 # Instruct
      if !@doublebattle || opponent!=attacker.pbPartner || opponent.lastMoveUsedSketch<=0
        score*=0
      else
        score*=3
        if attacker.pbPartner.hp*2 < attacker.pbPartner.totalhp
          score*=0.5
        else
          if attacker.pbPartner.hp==attacker.pbPartner.totalhp
            score*=1.2
          end
        end
        if initialscores.length>0
          badmoves=true
          for i in 0...initialscores.length
            next if attacker.moves[i].basedamage<=0
            next if i==scoreindex
            if initialscores[i]>20
              badmoves=false
            end
          end
          score*=1.3 if badmoves
        end
        if ((attacker.pbPartner.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) && ((attacker.pbPartner.pbSpeed<pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0))
          score*=1.5
        end
        ministat = [attacker.pbPartner.attack,attacker.pbPartner.spatk].max
        minimini = [attacker.attack,attacker.spatk].max
        ministat-=minimini
        ministat+=100
        ministat/=100.0
        score*=ministat
        if attacker.pbPartner.hp==0
          score*=0
        end
      end
    when 0x165 # Laser Focus
      if !(!opponent.abilitynulled && opponent.ability == PBAbilities::BATTLEARMOR) && !(!opponent.abilitynulled && opponent.ability == PBAbilities::SHELLARMOR) && attacker.effects[PBEffects::LaserFocus]==0
        miniscore = 100
        ministat=0
        ministat+=opponent.stages[PBStats::DEFENSE]
        ministat+=opponent.stages[PBStats::SPDEF]
        if ministat>0
          miniscore+= 10*ministat
        end
        ministat=0
        ministat+=attacker.stages[PBStats::ATTACK]
        ministat+=attacker.stages[PBStats::SPATK]
        if ministat>0
          miniscore+= 10*ministat
        end
        if attacker.effects[PBEffects::FocusEnergy]>0
          miniscore *= 0.8**attacker.effects[PBEffects::FocusEnergy]
        end
        miniscore/=100.0
        score*=miniscore
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::ANGERPOINT) && opponent.stages[PBStats::ATTACK] !=6
          score*=0.7
          if opponent.attack>opponent.spatk
            score*=0.2
          end
        end
      else
        score*=0
      end
    when 0x166 # Moongeist Beam
      damcount = 0
      firemove = false
      for m in attacker.moves
        if m.basedamage>0
          damcount+=1
          if m.type==(PBTypes::FIRE)
            firemove = true
          end
        end
      end
      if !opponent.moldbroken && !opponent.abilitynulled
        if opponent.ability == PBAbilities::SANDVEIL
          if pbWeather!=PBWeather::SANDSTORM
            score*=1.1
          end
        elsif opponent.ability == PBAbilities::VOLTABSORB || opponent.ability == PBAbilities::LIGHTNINGROD
          if move.type==(PBTypes::ELECTRIC)
            if damcount==1
              score*=3
            end
            if PBTypes.getCombinedEffectiveness((PBTypes::ELECTRIC),opponent.type1,opponent.type2)>4
              score*=2
            end
          end
        elsif opponent.ability == PBAbilities::WATERABSORB || opponent.ability == PBAbilities::STORMDRAIN || opponent.ability == PBAbilities::DRYSKIN
          if move.type==(PBTypes::WATER)
            if damcount==1
              score*=3
            end
            if PBTypes.getCombinedEffectiveness((PBTypes::WATER),opponent.type1,opponent.type2)>4
              score*=2
            end
          end
          if opponent.ability == PBAbilities::DRYSKIN && firemove
            score*=0.5
          end
        elsif opponent.ability == PBAbilities::FLASHFIRE
          if move.type==(PBTypes::FIRE)
            if damcount==1
              score*=3
            end
            if PBTypes.getCombinedEffectiveness((PBTypes::FIRE),opponent.type1,opponent.type2)>4
              score*=2
            end
          end
        elsif opponent.ability == PBAbilities::LEVITATE
          if move.type==(PBTypes::GROUND)
            if damcount==1
              score*=3
            end
            if PBTypes.getCombinedEffectiveness((PBTypes::GROUND),opponent.type1,opponent.type2)>4
              score*=2
            end
          end
        elsif opponent.ability == PBAbilities::WONDERGUARD
          score*=5
        elsif opponent.ability == PBAbilities::SOUNDPROOF
          if move.isSoundBased?
            score*=3
          end
        elsif opponent.ability == PBAbilities::THICKFAT  || SilvallyCheck(opponent,PBTypes::ICE)
          if move.type==(PBTypes::FIRE) || move.type==(PBTypes::ICE)
            score*=1.5
          end
        elsif opponent.ability == PBAbilities::MOLDBREAKER
          score*=1.1
        elsif opponent.ability == PBAbilities::UNAWARE  || SilvallyCheck(opponent,PBTypes::FAIRY)
          score*=1.7
        elsif opponent.ability == PBAbilities::MULTISCALE || SilvallyCheck(opponent,PBTypes::DRAGON)
          if attacker.hp==attacker.totalhp
            score*=1.5
          end
        elsif opponent.ability == PBAbilities::SAPSIPPER
          if move.type==(PBTypes::GRASS)
            if damcount==1
              score*=3
            end
            if PBTypes.getCombinedEffectiveness((PBTypes::GRASS),opponent.type1,opponent.type2)>4
              score*=2
            end
          end
        elsif opponent.ability == PBAbilities::SNOWCLOAK
          if pbWeather!=PBWeather::HAIL
            score*=1.1
          end
        elsif opponent.ability == PBAbilities::FURCOAT
          if attacker.attack>attacker.spatk
            score*=1.5
          end
        elsif opponent.ability == PBAbilities::FLUFFY
          score*=1.5
          if move.type==(PBTypes::FIRE)
            score*=0.5
          end
        elsif opponent.ability == PBAbilities::WATERBUBBLE
          score*=1.5
          if move.type==(PBTypes::FIRE)
            score*=1.3
          end
        end
      end
    when 0x167 # Pollen Puff
      if opponent==attacker.pbPartner
        score = 15
        if opponent.hp>opponent.totalhp*0.3 && opponent.hp<opponent.totalhp*0.7
          score*=1.5
        end
        if opponent.status==PBStatuses::POISON || opponent.status==PBStatuses::BURN || opponent.effects[PBEffects::LeechSeed]>=0 || opponent.effects[PBEffects::Curse]
          score*=0.8
          if opponent.effects[PBEffects::Toxic]>0
            score*=0.7
          end
        end
        if opponent.hp*(1.0/opponent.totalhp)>0.8
          if ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) && ((attacker.pbSpeed<pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0))
            score*=0.5
          else
            score*=0
          end
        end
        if attacker.effects[PBEffects::HealBlock]>0 || opponent.effects[PBEffects::HealBlock]>0
          score*=0
        end
      end
    when 0x168 # Psychic Terrain
      psyvar=false
      for mon in pbParty(attacker.index)
        next if mon.nil?
        if mon.hasType?(:PSYCHIC)
          psyvar=true
        end
      end
      pricheck = false
      for m in attacker.moves
        if m.priority>0
          pricheck=true
          break
        end
      end
      if @field.effects[PBEffects::Terrain]==0 && $fefieldeffect!=22
        $fefieldeffect!=35 && $fefieldeffect!=37
        miniscore = getFieldDisruptScore(attacker,opponent,skill)
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::TELEPATHY)
          miniscore*=1.5
        end
        if attacker.pbHasType?(:PSYCHIC)
          miniscore*=1.5
        end
        if psyvar
          miniscore*=2
        end
        if opponent.pbHasType?(:PSYCHIC)
          miniscore*=0.5
        end
        if pricheck
          miniscore*=0.7
        end
        miniscore*=1.3 if checkAIpriority(aimem)
        if (attitemworks && attacker.item == PBItems::AMPLIFIELDROCK)
          miniscore*=2
        end
        score*=miniscore
      else
        score*=0
      end
      if @field.effects[PBEffects::PsychicTerrain]>0
        score*=0
      end   
    when 0x169 # Purify
      if opponent==attacker.pbPartner && opponent.status!=0
        score*=1.5
        if opponent.hp>opponent.totalhp*0.8
          score*=0.8
        else
          if opponent.hp>opponent.totalhp*0.3
            score*=2
          end
        end
        if opponent.effects[PBEffects::Toxic]>3
          score*=1.3
        end
        if opponent.pbHasMove?(getID(PBMoves,:HEX))
          score*=1.3
        end
      else
        score*=0
      end
    when 0x16A # Revelation Dance - to do
    when 0x16B # Shell Trap
      maxdam=0
      specialvar = false
      if aimem.length > 0
        for j in aimem
          tempdam = pbRoughDamage(j,opponent,attacker,skill,j.basedamage)
          if tempdam>maxdam
            maxdam=tempdam
            if j.pbIsSpecial?(j.type)
              specialvar = true
            else
              specialvar = false
            end
          end
        end
      end
      if (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        score*=0.5
      end
      if attacker.hp==attacker.totalhp && ((attacker.hasWorkingItem(:FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) && !attacker.moldbroken) || (isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST)))  && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
        score*=1.2
      else
        score*=0.8
        score*=0.8 if checkAIdamage(aimem,attacker,opponent,skill)>attacker.hp
      end
      if attacker.lastMoveUsed==671
        score*=0.7
      end
      score*=0.6 if checkAImoves(PBStuff::SETUPMOVE,aimem)
      miniscore = attacker.hp*(1.0/attacker.totalhp)
      score*=miniscore
      if opponent.spatk > opponent.attack
        score*=0.3
      end
      score*=0.05 if checkAIbest(aimem,3,[],false,attacker,opponent,skill)
    when 0x16C # Shore Up
      fastermon=(attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0) || (attacker.hasWorkingAbility(:PRANKSTER) || attacker.hasWorkingAbility(:TRIAGE)) 
      halfhealth=(attacker.totalhp/2)
      maxdam = checkAIdamage(aimem,attacker,opponent,skill)
      if maxdam>attacker.hp
        if maxdam>(attacker.hp+halfhealth)
          score=0
        else
          if maxdam>=halfhealth
            score*=1.5
          else
            score*=5
            if initialscores.length>0
              score*=3 if hasgreatmoves(initialscores,scoreindex,skill)
            end
          end
        end
      else
        if maxdam*1.5>attacker.hp
          score*=2
        end
        if !fastermon
          if maxdam*2>attacker.hp
            score*=5
            if initialscores.length>0
              score*=3 if hasgreatmoves(initialscores,scoreindex,skill)
            end
          end
        end
      end
      hpchange=(EndofTurnHPChanges(attacker,opponent,false,false,true)) # what % of our hp will change after end of turn effects go through
      thisdam=(maxdam*1.1)
      hplost=(attacker.totalhp-attacker.hp)
      hplost+=maxdam if !fastermon
      livecount2=0
      for i in pbParty(attacker.index)
        next if i.nil?
        livecount2+=1 if i.hp!=0
      end
      if hpchange<1 ## we are going to be taking more chip damage than we are going to heal
        chipdamage=((attacker.totalhp*(1-hpchange)))
        thisdam+=chipdamage
      elsif hpchange>1 ## we are going to be healing more hp than we take chip damage for  
        healing=((attacker.totalhp*(hpchange-1)))
        thisdam-=healing if !(thisdam>attacker.hp)
      elsif hpchange<=0 ## we are going to die to future sight/doom desire or huge overstack of end of turn effects. hence we should just not heal.
        score*=0
      end
      if thisdam>hplost
        score*=0.1
      else
        if livecount2==1 && hplost<(halfhealth*1.1)
          score*=0.01
        end
        if thisdam<(halfhealth)
           score*=3
        end
      end
      if opponent.effects[PBEffects::Taunt]==0
        score*=0.7 if opponent.moves.any? {|moveloop| (PBStuff::SETUPMOVE).include?(moveloop.id)}
      end
      if ((attacker.hp.to_f)<=halfhealth)
        score*=1.5
      else
        score*=0.8
      end
      score/=(attacker.effects[PBEffects::Toxic]) if attacker.effects[PBEffects::Toxic]>0
      score*=0.8 if maxdam>halfhealth
      if (oppitemworks && opponent.item == PBItems::METRONOME)
        met=(1.0+opponent.effects[PBEffects::Metronome]*0.2) 
        score/=met
      end
      score*=1.1 if attacker.status==PBStatuses::PARALYSIS || attacker.effects[PBEffects::Attract]>=0 || attacker.effects[PBEffects::Confusion]>0
      if opponent.status==PBStatuses::POISON || opponent.status==PBStatuses::BURN || opponent.effects[PBEffects::LeechSeed]>=0 || opponent.effects[PBEffects::Curse] || opponent.effects[PBEffects::MultiTurn]>0
        score*=1.3
        score*=1.3 if opponent.effects[PBEffects::Toxic]>0
        score*=1.3 if ((attacker.item == PBItems::BINDINGBAND) ||  ((($fefieldeffect==12 || $fefieldeffect==20) && opponent.effects[PBEffects::MultiTurnAttack]==232) || ($fefieldeffect==15 && opponent.effects[PBEffects::MultiTurnAttack]==582) || (($fefieldeffect==21 || $fefieldeffect==22) && opponent.effects[PBEffects::MultiTurnAttack]==553) ||
        ($fefieldeffect==32 && opponent.effects[PBEffects::MultiTurnAttack]==130) || (($fefieldeffect==7 || $fefieldeffect==40) && opponent.effects[PBEffects::MultiTurnAttack]==147)))
        score *= 1.3 if (opponent.effects[PBEffects::MultiTurnAttack]==582) && $fefieldeffect == 33 && $fecounter > 1
        score *= 2 if (opponent.effects[PBEffects::MultiTurnAttack]==582) && $fefieldeffect == 33 && $fecounter > 2
        score *= 2.6667 if (opponent.effects[PBEffects::MultiTurnAttack]==582) && $fefieldeffect == 33 && $fecounter > 3
      end
      score*=1.5 if pbWeather==PBWeather::SANDSTORM || $fefieldeffect==12 || $fefieldeffect==20 || (($fefieldeffect==21 || $fefieldeffect==26) && pbRoughStat(opponent,PBStats::ATTACK,skill)>pbRoughStat(opponent,PBStats::SPATK,skill))
      score*=1.3 if checkAImoves(PBStuff::CONTRARYBAITMOVE,aimem)
      score*=1.2 if opponent.vanished || opponent.effects[PBEffects::HyperBeam]>0
      score*=0.1 if ((attacker.hp.to_f)/attacker.totalhp)>0.8
      score*=0.6 if ((attacker.hp.to_f)/attacker.totalhp)>0.6
      score*=2 if ((attacker.hp.to_f)/attacker.totalhp)<0.25
      score=0 if attacker.effects[PBEffects::Wish]>0
    when 0x16D # Sparkling Aria
      if opponent.status==PBStatuses::BURN
        score*=0.9
      end
    when 0x16E # Spectral Thief
      if opponent.effects[PBEffects::Substitute]>0
        score*=1.2
      end
      ministat= 10*statchangecounter(opponent,1,7)
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        ministat*=(-1)
      end
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::SIMPLE)
        ministat*=2
      end
      ministat+=100
      ministat/=100.0
      score*=ministat
    when 0x16F # Speed Swap
      if (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        miniscore= (10)*opponent.stages[PBStats::SPEED]
        minimini= (-10)*attacker.stages[PBStats::SPEED]
        if miniscore==0 && minimini==0
          score*=0
        else
          miniscore+=minimini
          miniscore+=100
          miniscore/=100.0
          score*=miniscore
          if @doublebattle
            score*=0.8
          end
        end
      else
        score*=0
      end
    when 0x170 # Spotlight
      maxdam=0
      maxtype = -1
      contactcheck = false
      if aimem.length > 0
        for j in aimem
          tempdam = pbRoughDamage(j,opponent,attacker,skill,j.basedamage)
          if tempdam>maxdam
            maxdam=tempdam
            maxtype = j.type
            contactcheck = j.isContactMove?
          end
        end
      end
      if @doublebattle && opponent==attacker.pbPartner
        if !opponent.abilitynulled
          if opponent.ability == PBAbilities::FLASHFIRE 
            score*=3 if checkAIbest(aimem,1,[PBTypes::FIRE],false,attacker,opponent,skill)
          elsif opponent.ability == PBAbilities::STORMDRAIN || opponent.ability == PBAbilities::DRYSKIN || opponent.ability == PBAbilities::WATERABSORB
            score*=3 if checkAIbest(aimem,1,[PBTypes::WATER],false,attacker,opponent,skill)
          elsif opponent.ability == PBAbilities::MOTORDRIVE || opponent.ability == PBAbilities::LIGHTNINGROD || opponent.ability == PBAbilities::VOLTABSORB ||  SilvallyCheck(opponent, "electric")
            score*=3 if checkAIbest(aimem,1,[PBTypes::ELECTRIC],false,attacker,opponent,skill)
          elsif opponent.ability == PBAbilities::SAPSIPPER
            score*=3 if checkAIbest(aimem,1,[PBTypes::GRASS],false,attacker,opponent,skill)
          end
        end
        if opponent.pbHasMove?((PBMoves::KINGSSHIELD)) || opponent.pbHasMove?((PBMoves::BANEFULBUNKER)) || opponent.pbHasMove?((PBMoves::SPIKYSHIELD))
          if checkAIbest(aimem,4,[],false,attacker,opponent,skill)
            score*=2
          end
        end
        if opponent.pbHasMove?((PBMoves::COUNTER)) || opponent.pbHasMove?((PBMoves::METALBURST)) || opponent.pbHasMove?((PBMoves::MIRRORCOAT))
          score*=2
        end
        if (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
          score*=1.5
        end
        if (attacker.pbSpeed<pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0)
          score*=1.5
        end
      else
        score=1
      end
    when 0x171 # Stomping Tantrum
      if $fefieldeffect==5
        psyvar=false
        for mon in pbParty(attacker.index)
          next if mon.nil?
          if mon.hasType?(:PSYCHIC)
            psyvar=true
          end
        end
        if !attacker.pbHasType?(:PSYCHIC)
          score*=1.3
        end
        if !psyvar
          score*=1.8
        else
          score*=0.7
        end
      end
    when 0x172 # Strength Sap
      if opponent.effects[PBEffects::Substitute]<=0
        if attacker.effects[PBEffects::HealBlock]>0
          score*=0
        else
          if checkAIdamage(aimem,attacker,opponent,skill)>attacker.hp
            score*=3
            if skill>=PBTrainerAI.highSkill
              if checkAIdamage(aimem,attacker,opponent,skill)*1.5 > attacker.hp
                score*=1.5
              end
              if (attacker.pbSpeed<pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0)
                if checkAIdamage(aimem,attacker,opponent,skill)*2 > attacker.hp
                  score*=2
                else
                  score*=0.2
                end
              end
            end
          end
        end
        if opponent.pbHasMove?((PBMoves::CALMMIND)) || opponent.pbHasMove?((PBMoves::WORKUP)) || opponent.pbHasMove?((PBMoves::NASTYPLOT)) || opponent.pbHasMove?((PBMoves::TAILGLOW)) || opponent.pbHasMove?((PBMoves::GROWTH)) || opponent.pbHasMove?((PBMoves::QUIVERDANCE))
          score*=0.7
        end
        if (attacker.hp.to_f)/attacker.totalhp<0.5
          score*=1.5
        else
          score*=0.5
        end
        if !(roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL))
          score*=0.8
        end
        if opponent.status==PBStatuses::POISON || opponent.status==PBStatuses::BURN || opponent.effects[PBEffects::LeechSeed]>=0 || opponent.effects[PBEffects::Curse]
          score*=1.3
          if opponent.effects[PBEffects::Toxic]>0
            score*=1.3
          end
        end
        score*=1.2 if checkAImoves(PBStuff::CONTRARYBAITMOVE,aimem)
        if opponent.vanished || opponent.effects[PBEffects::HyperBeam]>0
          score*=1.2
        end
        ministat = opponent.attack
        ministat/=(attacker.totalhp).to_f
        ministat+=0.5
        score*=ministat
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::LIQUIDOOZE)
          score*=0.2
        end
        if $fefieldeffect==15 || $fefieldeffect==8
          score*=1.3
        end
        if (attitemworks && attacker.item == PBItems::BIGROOT)
          score*=1.3
        end
        miniscore=100
        if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
          miniscore*=1.3
        end
        count=-1
        party=pbParty(attacker.index)
        sweepvar=false
        for i in 0...party.length
          count+=1
          next if (count==attacker.pokemonIndex || party[i].nil?)
          temproles = pbGetMonRole(party[i],opponent,skill,count,party)
          if temproles.include?(PBMonRoles::SWEEPER)
            sweepvar=true
          end
        end
        if sweepvar
          miniscore*=1.1
        end
        livecount2=0
        for i in pbParty(opponent.index)
          next if i.nil?
          livecount2+=1 if i.hp!=0
        end
        if livecount2==1 || (!attacker.abilitynulled && attacker.ability == PBAbilities::SHADOWTAG) || opponent.effects[PBEffects::MeanLook]>0
          miniscore*=1.4
        end
        if opponent.status==PBStatuses::POISON
          miniscore*=1.2
        end
        if opponent.stages[PBStats::ATTACK]<0
          minimini = 5*opponent.stages[PBStats::ATTACK]
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        if attacker.pbHasMove?((PBMoves::FOULPLAY))
          miniscore*=0.5
        end
        if opponent.status==PBStatuses::BURN
          miniscore*=0.5
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || (!opponent.abilitynulled && opponent.ability == PBAbilities::COMPETITIVE) || SilvallyCheck(opponent,PBTypes::FAIRY)
          miniscore*=0.1
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::DEFIANT) || (!opponent.abilitynulled && opponent.ability == PBAbilities::CONTRARY) || SilvallyCheck(opponent,"fighting")
          score*=0.3
        end
        miniscore/=100.0
        if attacker.stages[PBStats::ATTACK]!=6
          score*=miniscore
        end
      else
        score = 0
      end
    when 0x173 # Throat Chop
      maxdam=0
      maxsound = false
      soundcheck = false
      for j in opponent.moves
        soundcheck=true if j.isSoundBased?
        tempdam = pbRoughDamage(j,opponent,attacker,skill,j.basedamage)
        if tempdam>maxdam
          maxdam=tempdam
          maxsound = j.isSoundBased?
        end
      end
      if maxsound
        score*=1.5
      else
        if soundcheck
          score*=1.3
        end
      end
    when 0x174 # Toxic Thread
      if opponent.pbCanPoison?(false)
        miniscore=100
        miniscore*=1.2
        ministat=0
        ministat+=opponent.stages[PBStats::DEFENSE]
        ministat+=opponent.stages[PBStats::SPDEF]
        ministat+=opponent.stages[PBStats::EVASION]
        if ministat>0
          minimini=5*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::NATURALCURE)
          miniscore*=0.3
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::MARVELSCALE) || SilvallyCheck(opponent, "water")
          miniscore*=0.7
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::TOXICBOOST) || (!opponent.abilitynulled && opponent.ability == PBAbilities::GUTS)
          miniscore*=0.2
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::POISONHEAL) || (!opponent.abilitynulled && opponent.ability == PBAbilities::MAGICGUARD) ||
          (isConst?(opponent.species,PBSpecies,:ZANGOOSE) && isConst?(opponent.item,PBItems,:ZANGCREST))
          miniscore*=0.1
        end
        if attacker.pbHasMove?(getID(PBMoves,:VENOSHOCK)) ||
          attacker.pbHasMove?(getID(PBMoves,:VENOMDRENCH)) ||
          (!attacker.abilitynulled && attacker.ability == PBAbilities::MERCILESS) ||
          (isConst?(attacker.species,PBSpecies,:ARIADOS) && attacker.hasWorkingItem(:ARIACREST))
          miniscore*=1.6
        end
        miniscore*=0.2 if checkAImoves([PBMoves::FACADE],aimem)
        miniscore*=0.1 if checkAImoves([PBMoves::REST],aimem)
        if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
          miniscore*=1.5
        end
        if initialscores.length>0
          miniscore*=1.2 if hasbadmoves(initialscores,scoreindex,30)
        end
        if opponent.effects[PBEffects::Yawn]>0
          miniscore*=0.4
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::SHEDSKIN)
          miniscore*=0.7
        end
        miniscore/=100.0
        score*=miniscore
      else
        score*=0.5
      end
      if opponent.stages[PBStats::SPEED]>0 || opponent.stages[PBStats::SPEED]==-6
        score*=0.5
      else
        miniscore=100
        if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
          miniscore*=1.1
        end
        livecount1=0
        for i in pbParty(attacker.index)
          next if i.nil?
          livecount1+=1 if i.hp!=0
        end
        livecount2=0
        for i in pbParty(opponent.index)
          next if i.nil?
          livecount2+=1 if i.hp!=0
        end
        if livecount2==1 || (!attacker.abilitynulled && attacker.ability == PBAbilities::SHADOWTAG) || opponent.effects[PBEffects::MeanLook]>0
          miniscore*=1.4
        end
        if opponent.stages[PBStats::SPEED]<0
          minimini = 5*opponent.stages[PBStats::SPEED]
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        if livecount1==1
          miniscore*=0.5
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || (!opponent.abilitynulled && opponent.ability == PBAbilities::COMPETITIVE) || (!opponent.abilitynulled && opponent.ability == PBAbilities::DEFIANT) || (!opponent.abilitynulled && opponent.ability == PBAbilities::CONTRARY) || SilvallyCheck(opponent,PBTypes::FAIRY)  || SilvallyCheck(opponent,"fighting")
          miniscore*=0.1
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::SPEEDBOOST)
          miniscore*=0.5
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEAMENGINE)
          if $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==21 || $fefieldeffect==22 || $fefieldeffect==45
            miniscore*=0.5
          end
        end
        if attacker.pbHasMove?((PBMoves::ELECTROBALL))
          miniscore*=1.5
        end
        if attacker.pbHasMove?((PBMoves::GYROBALL))
          miniscore*=0.5
        end
        miniscore*=0.1 if  @trickroom!=0 || checkAImoves([PBMoves::TRICKROOM],aimem)
        if (oppitemworks && opponent.item == PBItems::LAGGINGTAIL) || (oppitemworks && opponent.item == PBItems::IRONBALL)
          miniscore*=0.1
        end
        miniscore*=1.3 if checkAImoves([PBMoves::ELECTROBALL],aimem)
        miniscore*=0.5 if checkAImoves([PBMoves::GYROBALL],aimem)
        if (attacker.pbSpeed>pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0)
          score*=0.5
        end
        miniscore/=100.0
        score*=miniscore
      end
    when 0x175 # Photon Geyser
      damcount = 0
      firemove = false
      for m in attacker.moves
        if m.basedamage>0
          damcount+=1
          if m.type==getConst(PBTypes,:FIRE)
            firemove = true
          end
        end
      end
      if !opponent.moldbroken && !opponent.abilitynulled
        if opponent.ability == PBAbilities::SANDVEIL
          if pbWeather!=PBWeather::SANDSTORM
            score*=1.1
          end
        elsif opponent.ability == PBAbilities::VOLTABSORB || opponent.ability == PBAbilities::LIGHTNINGROD
          if move.type==(PBTypes::ELECTRIC)
            if damcount==1
              score*=3
            end
            if PBTypes.getCombinedEffectiveness((PBTypes::ELECTRIC),opponent.type1,opponent.type2)>4
              score*=2
            end
          end
        elsif opponent.ability == PBAbilities::WATERABSORB || opponent.ability == PBAbilities::STORMDRAIN || opponent.ability == PBAbilities::DRYSKIN
          if move.type==(PBTypes::WATER)
            if damcount==1
              score*=3
            end
            if PBTypes.getCombinedEffectiveness((PBTypes::WATER),opponent.type1,opponent.type2)>4
              score*=2
            end
          end
          if opponent.ability == PBAbilities::DRYSKIN && firemove
            score*=0.5
          end
        elsif opponent.ability == PBAbilities::FLASHFIRE
          if move.type==(PBTypes::FIRE)
            if damcount==1
              score*=3
            end
            if PBTypes.getCombinedEffectiveness((PBTypes::FIRE),opponent.type1,opponent.type2)>4
              score*=2
            end
          end
        elsif opponent.ability == PBAbilities::LEVITATE || opponent.ability == PBAbilities::SOLARIDOL || opponent.ability == PBAbilities::LUNARIDOL
          if move.type==(PBTypes::GROUND)
            if damcount==1
              score*=3
            end
            if PBTypes.getCombinedEffectiveness((PBTypes::GROUND),opponent.type1,opponent.type2)>4
              score*=2
            end
          end
        elsif opponent.ability == PBAbilities::WONDERGUARD
          score*=5
        elsif opponent.ability == PBAbilities::SOUNDPROOF
          if move.isSoundBased?
            score*=3
          end
        elsif opponent.ability == PBAbilities::THICKFAT  || SilvallyCheck(opponent,PBTypes::ICE)
          if move.type==(PBTypes::FIRE) || move.type==(PBTypes::ICE)
            score*=1.5
          end
        elsif opponent.ability == PBAbilities::MOLDBREAKER
          score*=1.1
        elsif opponent.ability == PBAbilities::UNAWARE  || SilvallyCheck(opponent,PBTypes::FAIRY)
          score*=1.7
        elsif opponent.ability == PBAbilities::MULTISCALE || SilvallyCheck(opponent,PBTypes::DRAGON)
          if attacker.hp==attacker.totalhp
            score*=1.5
          end
        elsif opponent.ability == PBAbilities::SAPSIPPER
          if move.type==(PBTypes::GRASS)
            if damcount==1
              score*=3
            end
            if PBTypes.getCombinedEffectiveness((PBTypes::GRASS),opponent.type1,opponent.type2)>4
              score*=2
            end
          end
        elsif opponent.ability == PBAbilities::SNOWCLOAK
          if pbWeather!=PBWeather::HAIL
            score*=1.1
          end
        elsif opponent.ability == PBAbilities::FURCOAT
          if attacker.attack>attacker.spatk
            score*=1.5
          end
        elsif opponent.ability == PBAbilities::FLUFFY
          score*=1.5
          if move.type==(PBTypes::FIRE)
            score*=0.5
          end
        elsif opponent.ability == PBAbilities::WATERBUBBLE
          score*=1.5
          if move.type==(PBTypes::FIRE)
            score*=1.3
          end
        end
      end
    when 0x176 # Mind Blown
      startscore = score
      maxdam = checkAIdamage(aimem,attacker,opponent,skill)
      if (!(!attacker.abilitynulled && attacker.ability == PBAbilities::MAGICGUARD) && attacker.hp<attacker.totalhp*0.5) || (attacker.hp<attacker.totalhp*0.75 && ((opponent.pbSpeed>attacker.pbSpeed) ^ (@trickroom!=0))) ||  $fefieldeffect==3 || $fefieldeffect==8 || pbCheckGlobalAbility(:DAMP)
        score*=0
        if !(!attacker.abilitynulled && attacker.ability == PBAbilities::MAGICGUARD)
          score*=0.7
          if startscore < 100
            score*=0.7
          end
          if (attacker.pbSpeed<pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0)
            score*=0.5
          end
          if maxdam < attacker.totalhp*0.2
            score*=1.3
          end
          healcheck = false
          for m in attacker.moves
            healcheck=true if m.isHealingMove?
            break
          end
          if healcheck
            score*=1.2
          end
          if initialscores.length>0
            score*=1.3 if hasbadmoves(initialscores,scoreindex,25)
          end
          score*=0.5 if checkAImoves(PBStuff::PROTECTMOVE,aimem)
          ministat=0
          ministat+=opponent.stages[PBStats::EVASION]
          minimini=(-10)*ministat
          minimini+=100
          minimini/=100.0
          score*=minimini
          ministat=0
          ministat+=attacker.stages[PBStats::ACCURACY]
          minimini=(10)*ministat
          minimini+=100
          minimini/=100.0
          score*=minimini
          if (oppitemworks && opponent.item == PBItems::LAXINCENSE) || (oppitemworks && opponent.item == PBItems::BRIGHTPOWDER)
            score*=0.7
          end
          if ((!opponent.abilitynulled && opponent.ability == PBAbilities::SANDVEIL) && pbWeather==PBWeather::SANDSTORM) || ((!opponent.abilitynulled && opponent.ability == PBAbilities::SNOWCLOAK) && pbWeather==PBWeather::HAIL)
            score*=0.7
          end
        else
          score*=1.1
        end
        firevar=false
        grassvar=false
        bugvar=false
        poisonvar=false
        icevar=false
        for mon in pbParty(attacker.index)
          next if mon.nil?
          if mon.hasType?(:FIRE)
            firevar=true
          end
          if mon.hasType?(:GRASS)
            grassvar=true
          end
          if mon.hasType?(:BUG)
            bugvar=true
          end
          if mon.hasType?(:POISON)
            poisonvar=true
          end
          if mon.hasType?(:ICE)
            icevar=true
          end
        end
        if $fefieldeffect==2 || $fefieldeffect==15 || ($fefieldeffect==33 && $fecounter>1)
          if firevar && !bugvar && !grassvar
            score*=2
          end
        elsif $fefieldeffect==16
          if firevar
            score*=2
          end
        elsif $fefieldeffect==11
          if !poisonvar
            score*=1.2
          end
          if attacker.hp*5 < attacker.totalhp
            score*=2
          end
          if opponent.pbNonActivePokemonCount==0
            score*=5
          end
        elsif $fefieldeffect==13 || $fefieldeffect==28
          if !icevar
            score*=1.5
          end
        end
      end
    when 0x177 # Plasma Fists
      maxdam = 0
      maxtype = -1
      if aimem.length > 0
        for j in aimem
          tempdam = pbRoughDamage(j,opponent,attacker,skill,j.basedamage)
          if tempdam>maxdam
            maxdam=tempdam
            maxtype = j.type
          end
        end
      end
      if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        miniscore=100
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::VOLTABSORB)
          if attacker.hp<attacker.totalhp*0.8
            miniscore*=1.5
          end
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::LIGHTNINGROD)
          if attacker.spatk > attacker.attack && attacker.stages[PBStats::SPATK]!=6
            miniscore*=1.5
          end
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::MOTORDRIVE) || SilvallyCheck(attacker,PBTypes::ELECTRIC)
          if attacker.stages[PBStats::SPEED]!=6
            miniscore*=1.2
          end
        end
        if attacker.pbHasType?(:GROUND)
          miniscore*=1.3
        end
        miniscore*=0.5 if checkAIpriority(aimem)
        if maxtype == (PBTypes::NORMAL)
          miniscore*=2 
        end
        score*=miniscore
      end
    when 0x179 # Snipe Shot 
      if (opponent.pbHasMove?((PBMoves::FOLLOWME))  || 
          opponent.pbHasMove?((PBMoves::RAGEPOWDER)))
        score*=1.2
      elsif @doublebattle
        if (opponent.pbPartner.pbHasMove?((PBMoves::FOLLOWME)) || opponent.pbPartner.pbHasMove?((PBMoves::RAGEPOWDER)))
          score*=1.2
        end
      end
    when 0x17A # Stuff Cheeks
      if pbIsBerry?(attacker.item)
        miniscore = setupminiscore(attacker,opponent,skill,move,false,2,true,initialscores,scoreindex)
        if attacker.stages[PBStats::DEFENSE]>0
          ministat=attacker.stages[PBStats::DEFENSE]
          minimini=-15*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        if pbRoughStat(opponent,PBStats::ATTACK,skill)>pbRoughStat(opponent,PBStats::SPATK,skill)
          miniscore*=1.3
        end
        if skill>=PBTrainerAI.mediumSkill
          maxdam = checkAIdamage(aimem,attacker,opponent,skill)
          if (maxdam.to_f/attacker.hp)<0.12 
            miniscore*=0.3
          end
        end
        if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
          miniscore*=1.3
        end
        healmove=false
        for j in attacker.moves
          if j.isHealingMove?
            healmove=true
          end
        end
        if healmove
          miniscore*=1.3
        end
        if attacker.pbHasMove?((PBMoves::LEECHSEED))
          miniscore*=1.3
        end
        if attacker.pbHasMove?((PBMoves::PAINSPLIT))
          miniscore*=1.2
        end
        if move.basedamage>0
          score*=serenegracecheck(move,attacker,miniscore)
          if attacker.pbTooHigh?(PBStats::DEFENSE)
            miniscore=1
          end
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
            miniscore*=0.5
          end
        else
          miniscore/=100.0
          if attacker.pbTooHigh?(PBStats::DEFENSE)
            miniscore=0
          end
          miniscore*=0 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
            miniscore*=0
          end
          if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE)
            miniscore*=1
          end
        end
        score*=miniscore
        case attacker.item
        when (PBItems::LUMBERRY)
          score*=2 if attacker.status!=0
        when (PBItems::SITRUSBERRY)
          score*=1.6 if attacker.hp*(1.0/attacker.totalhp)<0.66
        when (PBItems::LIECHIBERRY)
          score*=1.5 if attacker.attack>attacker.spatk
        when (PBItems::PETAYABERRY)
          score*=1.5 if attacker.spatk>attacker.attack
        when (PBItems::APICOTBERRY), (PBItems::GANLONBERRY), (PBItems::STARFBERRY)
          score*=1.5 
        when (PBItems::CUSTAPBERRY), (PBItems::SALACBERRY)
          score*=1.1
          score*=1.5 if ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0))
        end
        if (opponent.level-5)>attacker.level
          score*=0.6
          if (opponent.level-10)>attacker.level
            score*=0.2
          end
        end
      else
        score*=0
      end
    when 0x17B # No Retreat
      if !attacker.effects[PBEffects::NoRetreat]
        miniscore = setupminiscore(attacker,opponent,skill,move,false,31,true,initialscores,scoreindex)
        miniscore/=100.0
        score*=miniscore
        miniscore=100
        if attacker.stages[PBStats::SPEED]<0
          ministat=attacker.stages[PBStats::SPEED]
          minimini=5*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        ministat=0
        ministat+=opponent.stages[PBStats::ATTACK]
        ministat+=opponent.stages[PBStats::SPATK]
        ministat+=opponent.stages[PBStats::SPEED]
        if ministat>0
          minimini=(-5)*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        healmove=false
        for j in attacker.moves
          if j.isHealingMove?
            healmove=true
          end
        end
        if healmove
          miniscore*=1.7
        end
        if attacker.pbHasMove?((PBMoves::LEECHSEED))
          miniscore*=1.3
        end
        if attacker.pbHasMove?((PBMoves::PAINSPLIT))
          miniscore*=1.2
        end
        if (attacker.hp.to_f)/attacker.totalhp>0.75
          miniscore*=1.1
        end
        if opponent.effects[PBEffects::HyperBeam]>0
          miniscore*=1.2
        end
        if opponent.effects[PBEffects::Yawn]>0
          miniscore*=1.3
        end
        if skill>=PBTrainerAI.mediumSkill
          maxdam = checkAIdamage(aimem,attacker,opponent,skill)
          if maxdam<(attacker.hp/3.0) 
            miniscore*=1.1
          else
            if move.basedamage==0
              miniscore*=0.8
              if maxdam>attacker.hp
                miniscore*=0.1
              end
            end
          end
        end
        if attacker.turncount<2
          miniscore*=1.1
        end
        if opponent.status!=0
          miniscore*=1.1
        end
        if $fefieldeffect==44 # Big Top
          miniscore*=2
        end
        if opponent.status==PBStatuses::SLEEP || opponent.status==PBStatuses::FROZEN
          miniscore*=1.3
        end
        if opponent.effects[PBEffects::Encore]>0
          if opponent.moves[(opponent.effects[PBEffects::EncoreIndex])].basedamage==0
            miniscore*=1.3
          end
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::SIMPLE)
          miniscore*=2
        end
        if @doublebattle
          miniscore*=0.8
        end
        if attacker.hp==attacker.totalhp && ((attacker.hasWorkingItem(:FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) && !attacker.moldbroken) || (isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST)))  && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
          miniscore*=1.4
        end
        miniscore*=0.6 if checkAIpriority(aimem)
        if attacker.pbTooHigh?(PBStats::ATTACK) && attacker.pbTooHigh?(PBStats::DEFENSE) && attacker.pbTooHigh?(PBStats::SPATK) && attacker.pbTooHigh?(PBStats::SPDEF) && attacker.pbTooHigh?(PBStats::SPEED)
          miniscore=0
        end
        if (opponent.level-5)>attacker.level
          score*=0.6
          if (opponent.level-10)>attacker.level
            score*=0.2
          end
        end
        if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
          miniscore*=0.9
        end
        miniscore*=0 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
          score *= 0
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
          miniscore*=0.5
        end
        if miniscore > 1
          score*=miniscore
        end
        if attacker.pbTooHigh?(PBStats::ATTACK) && attacker.pbTooHigh?(PBStats::DEFENSE) && attacker.pbTooHigh?(PBStats::SPATK) && attacker.pbTooHigh?(PBStats::SPDEF) && attacker.pbTooHigh?(PBStats::SPEED)
          score*=0
        end
      else
        score*=0
      end
    when 0x17C # Tar Shot
      if ((pbRoughStat(opponent,PBStats::SPEED,skill)<attacker.pbSpeed) ^ (@trickroom!=0)) || opponent.stages[PBStats::SPEED]>0 || (!opponent.pbCanReduceStatStage?(PBStats::SPEED) || opponent.effects[PBEffects::TarShot]==true)
        if move.basedamage==0
          score=0
        end
      else
        miniscore=100
        if opponent.stages[PBStats::SPEED]<0
          minimini = 5*opponent.stages[PBStats::SPEED]
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        if $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==41
          score*=2
        end
        if $fefieldeffect==26 
          score*=1.5
        end
        greatmoves = hasgreatmoves(initialscores,scoreindex,skill)
        miniscore*=unsetupminiscore(attacker,opponent,skill,move,roles,3,false,greatmoves,initialscores,scoreindex)
        miniscore/=100.0
        score*=miniscore
      end
    when 0x17D # Magic Powder
      sevar = false
      for i in attacker.moves
        if (i.type == PBTypes::BUG) || (i.type == PBTypes::GHOST) || (i.type == PBTypes::DARK)
          sevar = true
        end
      end
      if sevar
        score*=1.5
      else
        score*=0.7
      end
      if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
        if attacker.pbHasMove?((PBMoves::TOXIC))
          if opponent.pbHasType?(:STEEL) || opponent.pbHasType?(:POISON)
            score*=1.5
          end
        end
      end
      if aimem.length > 0
        movecheck=false
        for j in aimem
          movecheck=true if (j.type == PBTypes::PSYCHIC)
        end
        if movecheck
          score*=0.5
        else
          score*=1.1
        end
      end
      if (opponent.type1==(PBTypes::PSYCHIC) && opponent.type1==(PBTypes::PSYCHIC)) || (opponent.pbHasType?(:GRASS)) || (!opponent.abilitynulled && opponent.ability == PBAbilities::OVERCOAT) || (oppitemworks && opponent.item == PBItems::SAFETYGOGGLES)
        score=0
      end
      if ($fefieldeffect==31 || $fefieldeffect==40 || $fefieldeffect==42)
        if opponent.pbCanSleep?(false) && opponent.effects[PBEffects::Yawn]==0 
          miniscore=100
          miniscore*=1.3
          if attacker.pbHasMove?((PBMoves::DREAMEATER)) || attacker.pbHasMove?((PBMoves::NIGHTMARE)) ||
            (!attacker.abilitynulled && attacker.ability == PBAbilities::BADDREAMS)
            miniscore*=1.5
          end
          miniscore*=1.3 if attacker.moves.any? {|moveloop| (PBStuff::SETUPMOVE).include?(moveloop.id)}
          if attacker.pbHasMove?((PBMoves::LEECHSEED))
            miniscore*=1.3
          end
          if attacker.pbHasMove?((PBMoves::SUBSTITUTE))
            miniscore*=1.3
          end
          if opponent.hp==opponent.totalhp
            miniscore*=1.2
          end
          ministat = statchangecounter(opponent,1,7)
          if ministat>0
            minimini=5*ministat
            minimini+=100
            minimini/=100.0
            miniscore*=minimini
          end
          miniscore*=0.1 if checkAImoves([PBMoves::SLEEPTALK,PBMoves::SNORE,PBMoves::HOTTEMPO],aimem)
          if !opponent.abilitynulled
            miniscore*=0.3 if opponent.ability == PBAbilities::NATURALCURE
            miniscore*=0.7 if opponent.ability == PBAbilities::MARVELSCALE || SilvallyCheck(opponent, "water")
            miniscore*=0.5 if opponent.ability == PBAbilities::SYNCHRONIZE && attacker.status==0
          end
          if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL) || roles.include?(PBMonRoles::CLERIC) || roles.include?(PBMonRoles::PIVOT)
            miniscore*=1.2
          end
          if (pbRoughStat(opponent,PBStats::SPEED,skill)<attacker.pbSpeed) ^ (@trickroom!=0)
            miniscore*=1.3
          end
          if (attitemworks && attacker.item == PBItems::LEFTOVERS) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::POISONHEAL) || (isConst?(attacker.species,PBSpecies,:ZANGOOSE) && isConst?(attacker.item,PBItems,:ZANGCREST)) && attacker.status==PBStatuses::POISON)
            miniscore*=1.2
          end
          if opponent.effects[PBEffects::Confusion]>0
            miniscore*=0.6
          end
          if opponent.effects[PBEffects::Attract]>=0
            miniscore*=0.7
          end
          if initialscores.length>0
            miniscore*=1.3 if hasbadmoves(initialscores,scoreindex,35)
          end
          if (!opponent.abilitynulled && opponent.ability == PBAbilities::HYDRATION) && (pbWeather==PBWeather::RAINDANCE || $fefieldeffect == 21 || $fefieldeffect == 22)
            miniscore=0
          end
        else
          if move.basedamage==0
            score=0
          end
        end
      end
    when 0x17E # Dragon Darts - Handled in betterbasedamage
    when 0x17F # Teatime - To Do
    when 0x180 # Octolock
      if !(opponent.effects[PBEffects::MeanLook]>=0 || opponent.effects[PBEffects::Ingrain] || opponent.pbHasType?(:GHOST)) && opponent.effects[PBEffects::Substitute]<=0
        score*=0.1 if checkAImoves(PBStuff::PIVOTMOVE,aimem)
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::RUNAWAY)
          score*=0.1
        end
        if attacker.pbHasMove?((PBMoves::PERISHSONG))
          score*=1.5
        end
        if opponent.effects[PBEffects::PerishSong]>0
          score*=4
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::ARENATRAP) || (!attacker.abilitynulled && attacker.ability == PBAbilities::SHADOWTAG)
          score*=0
        end
        if opponent.effects[PBEffects::Attract]>=0
          score*=1.3
        end
        if opponent.effects[PBEffects::LeechSeed]>=0
          score*=1.3
        end
        if opponent.effects[PBEffects::Curse]
          score*=1.5
        end
        miniscore=100
        if !opponent.pbCanReduceStatStage?(PBStats::DEFENSE) && !opponent.pbCanReduceStatStage?(PBStats::SPDEF)
          if move.basedamage==0
            miniscore*=0.5
          end
        else
          if opponent.stages[PBStats::DEFENSE]+opponent.stages[PBStats::SPDEF]<0
            minimini = 5*opponent.stages[PBStats::DEFENSE]
            minimini+= 5*opponent.stages[PBStats::SPDEF]
            minimini+=100
            minimini/=100.0
            miniscore*=minimini
          end
          miniscore*= unsetupminiscore(attacker,opponent,skill,move,roles,2,true,false,initialscores,scoreindex)
        end
        miniscore/=100.0
        score*=miniscore
        miniscore=100
        physmove=false
        for j in attacker.moves
          if j.pbIsPhysical?(j.type)
            physmove=true
          end
        end
        if !physmove || opponent.stages[PBStats::DEFENSE]>0 || !opponent.pbCanReduceStatStage?(PBStats::DEFENSE)
          if move.basedamage==0
            miniscore*=0.5
          end
        else
          miniscore*= unsetupminiscore(attacker,opponent,skill,move,roles,2,true,false,initialscores,scoreindex)
        end
        miniscore/=100.0
        score*=miniscore
      else
        score*=0
      end
    when 0x181 # Bolt Beak & Fishious Rend
      miniscore=(-5)*statchangecounter(opponent,1,7,-1)
      miniscore+=100
      miniscore/=100.0        
      if opponent.effects[PBEffects::Confusion]>0
        miniscore*=1.2
      end
      if opponent.effects[PBEffects::LeechSeed]>=0
        miniscore*=1.5
      end
      if opponent.effects[PBEffects::Attract]>=0
        miniscore*=1.3
      end
      if opponent.effects[PBEffects::Substitute]>0
        miniscore*=0.7
      end
      if opponent.effects[PBEffects::Yawn]>0
        miniscore*=1.5
      end
      if pbTypeModNoMessages(bettertype,attacker,opponent,move,skill)>4
        miniscore*=1.5
      end
      if (pbRoughStat(attacker,PBStats::SPEED,skill)>opponent.pbSpeed) ^ (@trickroom!=0)
        miniscore*=2
      end  
      score*=miniscore
    when 0x182 # Court Change
      if attacker.pbNonActivePokemonCount>0
        score += 30 if attacker.pbOwnSide.effects[PBEffects::StealthRock]
        score += 50 if attacker.pbOwnSide.effects[PBEffects::StickyWeb]
        score += (10*attacker.pbOwnSide.effects[PBEffects::Spikes])
        score += (15*attacker.pbOwnSide.effects[PBEffects::ToxicSpikes])
        score -= 50 if attacker.pbOwnSide.effects[PBEffects::Tailwind]>0
        score -= 30 if (attacker.pbOwnSide.effects[PBEffects::Reflect]>0 || attacker.pbOwnSide.effects[PBEffects::LightScreen]>0) 
        score -= 50 if attacker.pbOwnSide.effects[PBEffects::AuroraVeil]>0
        score -= 10 if attacker.pbOwnSide.effects[PBEffects::Safeguard]>0
        score -= (10*opponent.pbOwnSide.effects[PBEffects::Spikes])
        score -= (15*opponent.pbOwnSide.effects[PBEffects::ToxicSpikes])
        score -= 75 if opponent.pbOwnSide.effects[PBEffects::StickyWeb]
        score -= 30 if opponent.pbOwnSide.effects[PBEffects::StealthRock]
        score += 50 if opponent.pbOwnSide.effects[PBEffects::Tailwind]>0
        score += 30 if (opponent.pbOwnSide.effects[PBEffects::Reflect]>0 || opponent.pbOwnSide.effects[PBEffects::LightScreen]>0) 
        score += 50 if opponent.pbOwnSide.effects[PBEffects::AuroraVeil]>0
        score += 10 if opponent.pbOwnSide.effects[PBEffects::Safeguard]>0
      else
        score*=0
      end
    when 0x183 # Clangorous Soul
      miniscore = setupminiscore(attacker,opponent,skill,move,false,31,true,initialscores,scoreindex)
      fastermon = (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
      miniscore/=100.0
      score*=miniscore
      miniscore=100
      if attacker.stages[PBStats::SPEED]<0
        ministat=attacker.stages[PBStats::SPEED]
        minimini=5*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      ministat=0
      ministat+=opponent.stages[PBStats::ATTACK]
      ministat+=opponent.stages[PBStats::SPATK]
      ministat+=opponent.stages[PBStats::SPEED]
      if ministat>0
        minimini=(-5)*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      healmove=false
      for j in attacker.moves
        if j.isHealingMove?
          healmove=true
        end
      end
      if healmove
        miniscore*=1.7
      end
      if attacker.pbHasMove?((PBMoves::LEECHSEED))
        miniscore*=1.3
      end
      if attacker.pbHasMove?((PBMoves::PAINSPLIT))
        miniscore*=1.2
      end
      if (attacker.hp.to_f)/attacker.totalhp>0.75
        miniscore*=1.1
      end
      if opponent.effects[PBEffects::HyperBeam]>0
        miniscore*=1.2
      end
      if opponent.effects[PBEffects::Yawn]>0
        miniscore*=1.3
      end
      if skill>=PBTrainerAI.mediumSkill
        maxdam = checkAIdamage(aimem,attacker,opponent,skill)
        if maxdam<(attacker.hp/4.0) 
          miniscore*=1.4
        else
          if move.basedamage==0
            miniscore*=0.8
            if maxdam>attacker.hp
              miniscore*=0.1
            end
          end
        end
      else
        if move.basedamage==0
          effcheck = PBTypes.getCombinedEffectiveness(opponent.type1,attacker.type1,attacker.type2)
          if effcheck > 4
            miniscore*=0.5
          end
          effcheck2 = PBTypes.getCombinedEffectiveness(opponent.type2,attacker.type1,attacker.type2)
          if effcheck2 > 4
            miniscore*=0.5
          end
        end
      end
      if attacker.turncount<2
        miniscore*=1.1
      end
      if opponent.status!=0
        miniscore*=1.1
      end
      if opponent.status==PBStatuses::SLEEP || opponent.status==PBStatuses::FROZEN
        miniscore*=1.3
      end
      if opponent.effects[PBEffects::Encore]>0
        if opponent.moves[(opponent.effects[PBEffects::EncoreIndex])].basedamage==0
          miniscore*=1.3
        end
      end
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::SIMPLE)
        miniscore*=2
      end
      if $fefieldeffect==6 # Big Top
        miniscore*=2
      end
      if @doublebattle
        miniscore*=0.8
      end
      if attacker.hp==attacker.totalhp && ((attacker.hasWorkingItem(:FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) && !attacker.moldbroken) || (isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST)))  && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
        miniscore*=1.4
      end
      miniscore*=0.6 if checkAIpriority(aimem)
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
      if fastermon
        miniscore*=0.9
      end
      miniscore*=0.5 if checkAImoves(PBStuff::PHASEMOVE,aimem)
      miniscore*=0.5 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem) && fastermon
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        score *= 0
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
        miniscore*=0.5
      end
      if miniscore > 1
        score*=miniscore
      end
      if attacker.pbTooHigh?(PBStats::ATTACK) && attacker.pbTooHigh?(PBStats::DEFENSE) && attacker.pbTooHigh?(PBStats::SPATK) && attacker.pbTooHigh?(PBStats::SPDEF) && attacker.pbTooHigh?(PBStats::SPEED)
        score*=0
      end
    when 0x184 # Body Press - handled in betterbasedamage
    when 0x185 # Decorate - to do
    when 0x186 # Aura Wheel
      move.type = move.pbType(move.type,attacker,opponent)
      miniscore=100
      if attacker.attack<attacker.spatk
        if attacker.stages[PBStats::SPATK]<0
          ministat=attacker.stages[PBStats::SPATK]
          minimini=5*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
      else
        if attacker.stages[PBStats::ATTACK]<0
          ministat=attacker.stages[PBStats::ATTACK]
          minimini=5*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
      end
      ministat=0
      ministat+=opponent.stages[PBStats::DEFENSE]
      ministat+=opponent.stages[PBStats::SPDEF]
      if ministat>0
        minimini=(-5)*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      if roles.include?(PBMonRoles::SWEEPER)
        miniscore*=1.3
      end
      if @trickroom!=0 || checkAImoves([PBMoves::TRICKROOM],aimem)
        miniscore*=0.2
      end
      if attacker.status==PBStatuses::PARALYSIS
        miniscore*=0.2
      end
      if attacker.hp==attacker.totalhp && ((attacker.hasWorkingItem(:FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) && !attacker.moldbroken) || (isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST)))  && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
        miniscore*=1.4
      end
      miniscore*=0.6 if checkAIpriority(aimem)
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::MOXIE) || SilvallyCheck(attacker,PBTypes::FIRE)
        miniscore*=1.3
      end
      if skill>=PBTrainerAI.highSkill
        ghostvar=false
        for mon in pbParty(attacker.index)
          next if mon.nil?
          if mon.hasType?(:GHOST)
            ghostvar=true
          end
        end
        if $fefieldeffect==17# Factory
          miniscore*=1.1
          if ghostvar
            miniscore*=1.3
          end
        end
        if $fefieldeffect==18  # Short-Circuit
          miniscore*=1.1
          if ghostvar
            miniscore*=0.8
          end
        end
      end
      if move.basedamage>0
        miniscore-=100
        if move.addlEffect.to_f != 100
          miniscore*=(move.addlEffect.to_f/100)
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
            miniscore*=2
          end
        end
        miniscore+=100
        miniscore/=100.0
        if attacker.pbTooHigh?(PBStats::SPEED)
          miniscore=1
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
          miniscore*=0.5
        end
        score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !hasgreatmoves(initialscores,scoreindex,skill,true)
      else
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::SPEEDBOOST)
          miniscore*=0.6
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEAMENGINE)
          if $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==21 || $fefieldeffect==22 || $fefieldeffect==45
            miniscore*=0.6
          end
        end
        miniscore/=100.0
        miniscore*=0.8 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
          miniscore*=0
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
          miniscore*=1
        end
        score*=miniscore
      end
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
    when 0x187 # Life Dew
      maxdam=0
      fastermon=(attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
      maxdam=checkAIdamage(aimem,attacker,opponent,skill)
      if (maxdam>attacker.hp || maxdam>attacker.pbPartner.hp) && fastermon
        score*=3
      else
        if (maxdam*1.5>attacker.hp || maxdam*1.5>attacker.pbPartner.hp) && fastermon
          score*=1.5
        end
        if !fastermon
          if maxdam*2>attacker.hp || maxdam*2>attacker.pbPartner.hp
            score*=2
          end
        end
      end
      if opponent.pbHasMove?(getID(PBMoves,:SWORDSDANCE)) || opponent.pbHasMove?(getID(PBMoves,:DRAGONDANCE)) || opponent.pbHasMove?(getID(PBMoves,:CALMMIND)) || opponent.pbHasMove?(getID(PBMoves,:WORKUP)) || opponent.pbHasMove?(getID(PBMoves,:NASTYPLOT)) || opponent.pbHasMove?(getID(PBMoves,:TAILGLOW)) || opponent.pbHasMove?(getID(PBMoves,:BELLYDRUM)) || opponent.pbHasMove?(getID(PBMoves,:BULKUP)) || opponent.pbHasMove?(getID(PBMoves,:COIL)) || opponent.pbHasMove?(getID(PBMoves,:CURSE)) || opponent.pbHasMove?(getID(PBMoves,:GROWTH)) || opponent.pbHasMove?(getID(PBMoves,:HONECLAWS)) || opponent.pbHasMove?(getID(PBMoves,:QUIVERDANCE)) || opponent.pbHasMove?(getID(PBMoves,:SHELLSMASH))
        score*=0.5
      end
      if (attacker.hp.to_f)/attacker.totalhp<0.5 || (attacker.pbPartner.hp.to_f)/attacker.pbPartner.totalhp<0.5
        score*=1.5
        if attacker.effects[PBEffects::Curse] && !($fefieldeffect== 9) ### healing identical to damage in this case
          score*=0
        end
        if (attacker.hp*4<attacker.totalhp) || (attacker.pbPartner.hp*4<attacker.pbPartner.totalhp)
          if (attacker.status==PBStatuses::POISON) || (attacker.pbPartner.status==PBStatuses::POISON) 
            if ($fefieldeffect== 9 || $fefieldeffect== 29) # Rainbow or Holy
              score*=1.5
            else
              score*=1.2
            end
          end
          if attacker.effects[PBEffects::LeechSeed]>=0
            score*=1.5
          end
          if attacker.hp<attacker.totalhp*0.13
            if attacker.status==PBStatuses::BURN
              score*=2
            end
            if (pbWeather==PBWeather::HAIL && !attacker.pbHasType?(:ICE)) || (pbWeather==PBWeather::SANDSTORM && !attacker.pbHasType?(:ROCK) && !attacker.pbHasType?(:GROUND) && !attacker.pbHasType?(:STEEL))
              score*=2
            end
          end
        end
      else
        score*=0.7
      end
      if attacker.effects[PBEffects::Toxic]>0
        score*=0.5
        if attacker.effects[PBEffects::Toxic]>4
          score*=0.2
        end
      end
      if attacker.status==PBStatuses::PARALYSIS || attacker.effects[PBEffects::Attract]>=0 || attacker.effects[PBEffects::Confusion]>0
        score*=1.1
      end
      if !(roles.include?("Physical Wall") || roles.include?("Special Wall"))
        score*=0.8
      end
      if opponent.status==PBStatuses::POISON || opponent.status==PBStatuses::BURN || opponent.effects[PBEffects::LeechSeed]>=0 || opponent.effects[PBEffects::Curse]
        score*=1.3
        if opponent.effects[PBEffects::Toxic]>0
          score*=1.3
        end
      end
      if skill>=PBTrainerAI.highSkill
        if aimem.length>0
          movecheck=false
          for j in aimem
            movecheck=true if j.id==getID(PBMoves,:SUPERPOWER) || j.id==getID(PBMoves,:OVERHEAT) || j.id==getID(PBMoves,:DRACOMETEOR) || j.id==getID(PBMoves,:LEAFSTORM) || j.id==getID(PBMoves,:FLEURCANNON) || j.id==getID(PBMoves,:PSYCHOBOOST)
          end
          score*=1.2 if movecheck
        end
      end
      if opponent.vanished || opponent.effects[PBEffects::HyperBeam]>0
        score*=1.2
      end
      if skill>=PBTrainerAI.highSkill
        if $fefieldeffect== 9 || $fefieldeffect== 29 # Rainbow or Holy
          score*=2
        end
      end
      if ((attacker.hp.to_f)/attacker.totalhp)>0.8
        score=0
      else
        if ((attacker.hp.to_f)/attacker.totalhp)<0.25
          score*=2
        end
      end
      if attacker.effects[PBEffects::Wish]>0
        score=0
      end
    when 0x188 # Obstruct
      score*=0.3 if opponent.moves.any? {|moveloop| (PBStuff::SETUPMOVE).include?(moveloop.id)}
      if ((!attacker.abilitynulled && attacker.ability == PBAbilities::SPEEDBOOST) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STEAMENGINE) && $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==21 || $fefieldeffect==22 || $fefieldeffect==45)) && attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill) && @trickroom==0
        score*=4 if (attacker.pbSpeed*1.5>pbRoughStat(opponent,PBStats::SPEED,skill))
        score*=6 if initialscores.length>0 && hasgreatmoves(initialscores,scoreindex,skill)
      end
      score*=1.1 if (isConst?(opponent.species,PBSpecies,:FERALIGATR) && oppitemworks && opponent.item == PBItems::FERACREST && opponent.turncount==0)
      score*=1.2 if (opponent.status==PBStatuses::POISON || opponent.status==PBStatuses::BURN)
      score*=1.3 if opponent.effects[PBEffects::Toxic]>0
      hpchange=(EndofTurnHPChanges(attacker,opponent,false,false,true)) # what % of our hp will change after end of turn effects go through
      maxdam=checkAIdamage(aimem,attacker,opponent,skill)
      if hpchange>1 ## we are going to be healing more hp than we take chip damage for  
        if attacker.hp!=attacker.totalhp
          score*=(1.3*hpchange) 
          if maxdam>attacker.hp
            healing=((attacker.totalhp*(hpchange-1)))
            if attacker.hp+(healing)>maxdam
              score*=2
            end
          end
        end
      elsif hpchange<1 ## we are going to be taking more chip damage than we are going to heal
        score*=(1*hpchange)
        score*=0.3 if attacker.effects[PBEffects::Toxic]>4
      elsif hpchange<=0 ## we are going to die to future sight/doom desire or huge overstack of end of turn effects. hence we should just not heal.
        score*=0.1
      end
      opphpchange=(EndofTurnHPChanges(opponent,attacker,false,false,true)) # what % of our hp will change after end of turn effects go through
      maxdam2=checkAIdamage(aimem,opponent,attacker,skill)
      if opphpchange!=1
        if opphpchange<1
          opphploss=1-opphpchange
          if opphploss<1
            opphploss=(opphploss*opponent.totalhp)
            if opphploss>(opponent.totalhp/4)
              score*=1.5
              if maxdam>attacker.hp
                score*=2
              end
            end
            if opphploss>opponent.hp
              if !(attacker.lastMoveUsed == 391)
                score*=2
              end
              if ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) 
                if maxdam>attacker.hp
                  score*=4
                  if attacker.lastMoveUsed == 391
                    score/=(attacker.effects[PBEffects::ProtectRate]*3.0)
                  end
                end
              end
            else
              if ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) && maxdam>attacker.hp
                score*=4
              else
                if maxdam>attacker.hp
                  score*=4
                  if attacker.lastMoveUsed == 391
                    score/=(attacker.effects[PBEffects::ProtectRate]*3.0)
                  end
                end
              end
            end
          end
        end
      end
      score*=2 if opponent.effects[PBEffects::PerishSong]!=0
      opppri=false
      ourpridam=0
      for i in opponent.moves
        #if (attacker.pbSpeed<=pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
          if (i.priority>0 && !(i.id==(PBMoves::FAKEOUT) && opponent.turncount!=0)) ||
            (!opponent.abilitynulled && opponent.ability == PBAbilities::GALEWINGS && move.type==PBTypes::FLYING && opponent.hp==opponent.totalhp) || 
            ((opponent.species == PBSpecies::FERALIGATR) && oppitemworks && opponent.item == PBItems::FERACREST && opponent.turncount==0) ||
            (!opponent.abilitynulled && opponent.ability == PBAbilities::TRIAGE && move.isHealingMove?)
            temppridam = pbRoughDamage(i,opponent,attacker,skill,i.basedamage)
            opppri=true
            if temppridam>ourpridam
              ourpridam = temppridam
            end
          end
        #end
      end
      if @doublebattle && !(attacker.lastMoveUsed == 786)
        if !(opponent.isFainted?) && !(opponent.pbPartner.isFainted?)
          maxdam3=checkAIdamage(aimem,opponent,attacker.pbPartner,skill)
          maxdam4=checkAIdamage(aimem,opponent.pbPartner,attacker.pbPartner,skill)
          maxdam5=checkAIdamage(aimem,attacker.pbPartner,opponent,skill)
          maxdam6=checkAIdamage(aimem,attacker.pbPartner,opponent.pbPartner,skill)
          maxdam7=checkAIdamage(aimem,attacker,opponent.pbPartner,skill)
          if ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0) && (((attacker.pbPartner.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0) && maxdam3>opponent.hp) || ((attacker.pbSpeed<pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0) && (attacker.pbPartner.pbSpeed>pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0) && maxdam4>opponent.pbPartner.hp)))
            if (maxdam>attacker.hp || maxdam7>attacker.hp || maxdam+maxdam7>attacker.hp && (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0) && (attacker.pbSpeed<pbRoughStat(opponent.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0))
              score*=4
            end
          end
        end
      end
      if pbWeather!=@weatherbackup
        score*=2 if (!attacker.abilitynulled && attacker.ability == PBAbilities::SWIFTSWIM) && (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) && @weatherbackup==PBWeather::RAINDANCE && @weatherduration==1
        score*=2 if (!attacker.abilitynulled && attacker.ability == PBAbilities::SANDRUSH) && (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) && @weatherbackup==PBWeather::SANDSTORM && @weatherduration==1
        score*=2 if (!attacker.abilitynulled && attacker.ability == PBAbilities::CHLOROPHYLL) && (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) && @weatherbackup==PBWeather::SUNNYDAY && @weatherduration==1
        score*=2 if (!attacker.abilitynulled && attacker.ability == PBAbilities::SLUSHRUSH) && (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) && @weatherbackup==PBWeather::HAIL && @weatherduration==1
      end
      score*=0.3 if opponent.status==PBStatuses::SLEEP || opponent.status==PBStatuses::FROZEN
      if opponent.vanished
        score*=2
        score*=1.5 if (attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
      end
      score*=0.1 if checkAImoves(PBStuff::PROTECTIGNORINGMOVE,aimem)
      score*=0.01 if !(opponent.effects[PBEffects::Attacking]==true)
      if attacker.effects[PBEffects::Wish]>0
        if attacker.hp!=attacker.totalhp
          if checkAIdamage(aimem,attacker,opponent,skill)>attacker.hp
            score*=10
          else
            score*=3
          end
          score*=6 if initialscores.length>0 && hasgreatmoves(initialscores,scoreindex,skill)
        end
      end
      if attacker.effects[PBEffects::KingsShield]== true  ||
        attacker.effects[PBEffects::BanefulBunker]== true ||
        attacker.effects[PBEffects::SpikyShield]== true
        score*=0
      end
      if aimem.length > 0
        contactcheck=false
        maxdam=0
        for j in aimem
          contactcheck=j.isContactMove?
        end
        score*=1.3 if contactcheck && !(!opponent.abilitynulled && (opponent.ability == PBAbilities::DEFIANT || opponent.ability == PBAbilities::COMPETITIVE || opponent.ability == PBAbilities::MIRRORARMOR || opponent.ability == PBAbilities::CONTRARY)) 
      end
      ratesharers=[391,121,122,515,361,584,603,641,786]   # Protect, Detect, Quick Guard, Wide Guard, Endure, King's Shield, Spiky Shield, Baneful Bunker, Obstruct in that order
      score/=(attacker.effects[PBEffects::ProtectRate]*2.0) if ratesharers.include?(attacker.lastMoveUsed)
    when 0x201 # Barbed Web - to do
      if opponent.pbOwnSide.effects[PBEffects::StickyWeb]==true
        if attacker.pbOpposingSide.effects[PBEffects::Spikes]!=3
          if roles.include?(PBMonRoles::LEAD)
            score*=1.2
          end
          if checkAIHas?([PBMoves::STICKYWEB],attacker.pbPartner) && (attacker.pbSpeed<pbRoughStat(attacker.pbPartner,PBStats::SPEED,skill)) ^ (@trickroom!=0)
            score*=1.5
          end
          if skill>=PBTrainerAI.highSkill
            for k in 0...pbParty(opponent.index).length
              next if pbParty(opponent.index)[k].nil?
              if @aiMoveMemory[2][k].length>0
                movecheck=false
                for j in @aiMoveMemory[2][k]
                  movecheck=true if j.id==(PBMoves::DEFOG) || j.id==(PBMoves::RAPIDSPIN)
                end
                score*=0.8 if movecheck
              end
            end
          elsif skill>=PBTrainerAI.mediumSkill
            score*=0.8 if checkAImoves([PBMoves::DEFOG,PBMoves::RAPIDSPIN],aimem)
          end
        end
      end
    when 0x202 # Gale Strike - to do
    when 0x203 # Fever Pitch - to do
      if attacker.status==PBStatuses::SLEEP && attacker.statusCount>1
        score*=10
      end
    when 0x204 # Arenite Wall
      if attacker.pbOwnSide.effects[PBEffects::AreniteWall]<=0
        if pbWeather==PBWeather::SANDSTORM || (skill>=PBTrainerAI.highSkill && ($fefieldeffect==12 || $fefieldeffect==20))
          score*=1.2
          movetypemod=0
          maxdam=0
          if attacker.pbOwnSide.effects[PBEffects::AreniteWall]>0
            score*=0.1
          end
          if attacker.hasWorkingItem(:LIGHTCLAY) || $fefieldeffect==12 || $fefieldeffect==20 || $fefieldeffect==23 
            score*=1.5
          end
          for i in opponent.moves
            tempdamage = pbRoughDamage(i,opponent,attacker,skill,i.basedamage) 
            if (tempdamage>maxdam) 
              maxdam = tempdamage 
              movetypemod=pbTypeModNoMessages(i.type,opponent,attacker,i,skill)
            end
            if !(opponent.item == PBItems::INTERCEPTZ2) && pbCanZMove?(opponent.index)
              if opponent.pbCompatibleZMoveFromMove?(i)
                if i.id == PBMoves::NATUREPOWER
                  moveid = pbChangeMove(PBMoves::NATUREPOWER,opponent)
                  newmove = PokeBattle_Move.pbFromPBMove(battle,PBMove.new(moveid),opponent)
                else
                  newmove=i
                end
                zmove = PokeBattle_ZMoves2.new(newmove,opponent.item)
                tempdam = pbRoughDamage(zmove,opponent,attacker,skill,zmove.basedamage) 
                if tempdam>maxdam
                  maxdam=tempdam
                  movetypemod=pbTypeModNoMessages(i.type,opponent,attacker,i,skill)
                end
              end
            end
          end
          if movetypemod<=4
            score*=0.6
          end
          if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
            score*=1.1
            if (maxdam>attacker.hp && (maxdam/2.0)<attacker.hp) && movetypemod>4
              score*=2
            end   
          elsif opponent.effects[PBEffects::Switching]==true
            score*=1.5
          elsif
            if (maxdam<attacker.hp && (maxdam*2)>attacker.hp) && movetypemod>4
              score*=2
            end   
          end
          if attacker.hp==attacker.totalhp && ((attacker.hasWorkingItem(:FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) && !attacker.moldbroken) || (isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST))) && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
            score*=1.3
          end
          score*=0.1 if checkAImoves(PBStuff::SCREENBREAKERMOVE,aimem)
          breakcheck=false
          if !(opponent.pbPartner.nil?)
            if @doublebattle && @aiMoveMemory[2][opponent.pbPartner.pokemonIndex].length>0 && opponent.pbPartner.hp>0 
              for j in @aiMoveMemory[2][opponent.pbPartner.pokemonIndex]
                breakcheck = true if (PBStuff::SCREENBREAKERMOVE).include?(j.id)
              end
            end
          end
          score*=0.1 if breakcheck
        else
          score=0
        end
      else
        score=0
      end
    when 0x205 # Matrix Shot - to do
    when 0x206 # Desert's Mark
      sevar = false
      healmove=false
      for i in attacker.moves
        if isConst?(i.type,PBTypes,:GRASS) || isConst?(i.type,PBTypes,:WATER) || isConst?(i.type,PBTypes,:ICE)
          sevar = true
        end
        if i.isHealingMove?
          healmove=true
        end
      end
      if sevar
        score*=1.3
      end
      if healmove
        score*=1.5
      end
      if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
        if attacker.pbHasMove?(getID(PBMoves,:TOXIC)) 
          if opponent.pbHasType?(:STEEL) || opponent.pbHasType?(:POISON)
            score*=1.5
          end
        end
      end
      if !opponent.pbHasType?(PBTypes::GROUND) && !((!opponent.abilitynulled && opponent.ability == PBAbilities::LIBERO) || (!opponent.abilitynulled && opponent.ability == PBAbilities::PROTEAN))
        score*=1.5
      end
      if (opponent.effects[PBEffects::Substitute]>0)
        score*=1.5
      end
      if (opponent.effects[PBEffects::DesertsMark]==true && opponent.effects[PBEffects::MultiTurn]>0)
        score*=0.2
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::MULTITYPE) || (!opponent.abilitynulled && opponent.ability == PBAbilities::RKSSYSTEM)
        score*=0
      end
    when 0x207 # Thunder Raid
      miniscore=100
      miniscore*= unsetupminiscore(attacker,opponent,skill,move,roles,4,false)
      miniscore/=100.0
      score*=miniscore
    when 0x208 # Super UMD Move
      miniscore=100
      if ultramegadeath==0
        miniscore *= unsetupminiscore(attacker,opponent,skill,move,roles,2,true,false,initialscores,scoreindex)
      else
        miniscore *= unsetupminiscore(attacker,opponent,skill,move,roles,1,true,false,initialscores,scoreindex)
      end
      miniscore/=100.0
      score*=miniscore if !hasgreatmoves(initialscores,scoreindex,skill,true)
    when 0x210 # Aquabatics 
      miniscore = setupminiscore(attacker,opponent,skill,move,true,20,false,initialscores,scoreindex)
      ministat=0
      ministat+=opponent.stages[PBStats::ATTACK]
      ministat+=opponent.stages[PBStats::SPATK]
      ministat+=opponent.stages[PBStats::SPEED]
      if ministat>0
        minimini=(-5)*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      miniscore/=100.0
      score*=miniscore
      miniscore=100
      miniscore*=1.2 if checkAIhealing(aimem)
      if (attacker.pbSpeed<=pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        miniscore*=1.3
      end
      if roles.include?(PBMonRoles::SWEEPER)
        miniscore*=1.3
      end
      if attacker.status==PBStatuses::PARALYSIS
        miniscore*=0.5
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::SPEEDBOOST)
        miniscore*=0.3
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::STEAMENGINE)
        if $fefieldeffect==7 || $fefieldeffect==16 || $fefieldeffect==21 || $fefieldeffect==22 || $fefieldeffect==45
          miniscore*=0.8
        end
      end
      specmove=false
      for j in attacker.moves
        if j.pbIsSpecial?(j.type)
          specmove=true
        end
      end
      if specmove && !attacker.pbTooHigh?(PBStats::SPATK)
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect==6 # Big Top
            miniscore*=2
          end
        end
        miniscore/=100.0
        score*=miniscore
      end
      miniscore=100
      if attacker.stages[PBStats::SPATK]<0
        ministat=attacker.stages[PBStats::SPATK]
        minimini=5*ministat
        minimini+=100
        minimini/=100.0
        miniscore*=minimini
      end
      if (attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)
        miniscore*=0.8
      end
      if @trickroom!=0
        miniscore*=0.2
      else
        miniscore*=0.2 if checkAImoves([PBMoves::TRICKROOM],aimem)
      end
      if !attacker.pbTooHigh?(PBStats::SPEED)
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect==6 # Big Top
            miniscore*=2
          end
        end
        miniscore/=100.0
        score*=miniscore
      end
      if (opponent.level-5)>attacker.level
        score*=0.6
        if (opponent.level-10)>attacker.level
          score*=0.2
        end
      end
      score*=0.3 if checkAImoves([PBMoves::CLEARSMOG,PBMoves::HAZE],aimem)
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        score=0
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
        score=0
      end
      if attacker.pbTooHigh?(PBStats::SPATK) && attacker.pbTooHigh?(PBStats::SPEED)
        score*=0
      end
    when 0x211 # Hexing Slash
      if opponent.pbCanPoison?(false)
        miniscore=100
        miniscore*=1.2
        ministat=0
        ministat+=opponent.stages[PBStats::DEFENSE]
        ministat+=opponent.stages[PBStats::SPDEF]
        ministat+=opponent.stages[PBStats::EVASION]
        if ministat>0
          minimini=5*ministat
          minimini+=100
          minimini/=100.0
          miniscore*=minimini
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::NATURALCURE)
          miniscore*=0.3
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::MARVELSCALE) || SilvallyCheck(opponent, "water")
          miniscore*=0.7
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::TOXICBOOST) || (!opponent.abilitynulled && opponent.ability == PBAbilities::GUTS)
          miniscore*=0.2
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::POISONHEAL) || (!opponent.abilitynulled && opponent.ability == PBAbilities::MAGICGUARD) ||
          (isConst?(opponent.species,PBSpecies,:ZANGOOSE) && isConst?(opponent.item,PBItems,:ZANGCREST))
          miniscore*=0.1
        end
        if roles.include?(PBMonRoles::PHYSICALWALL) || roles.include?(PBMonRoles::SPECIALWALL)
          miniscore*=1.5
        end
        if initialscores.length>0
          badmoves=true
          for i in 0...initialscores.length
            next if i==scoreindex
            if initialscores[i]>30
              badmoves=false
            end
          end
          miniscore*=1.2 if badmoves
        end
        miniscore*=0.1 if checkAImoves([PBMoves::REST],aimem)
        miniscore*=0.2 if checkAImoves([PBMoves::FACADE],aimem)
        if attacker.pbHasMove?(getID(PBMoves,:VENOSHOCK)) ||
          attacker.pbHasMove?(getID(PBMoves,:VENOMDRENCH)) ||
          (!attacker.abilitynulled && attacker.ability == PBAbilities::MERCILESS) ||
          (isConst?(attacker.species,PBSpecies,:ARIADOS) && attacker.hasWorkingItem(:ARIACREST))
          miniscore*=1.6
        end
        if opponent.effects[PBEffects::Yawn]>0
          miniscore*=0.4
        end
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::SHEDSKIN)
          miniscore*=0.7
        end
        miniscore-=100
        miniscore*=(move.addlEffect.to_f/100)
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
          miniscore*=2
        end
        miniscore+=100
        miniscore/=100.0
        score*=miniscore
      end
      minimini = score*0.01
      miniscore = (opponent.hp*minimini)/2.0
      if miniscore > (attacker.totalhp-attacker.hp)
        miniscore = (attacker.totalhp-attacker.hp)
      end
      if attacker.totalhp>0
        miniscore/=(attacker.totalhp).to_f
      end
      if attacker.hasWorkingItem(:BIGROOT)
        miniscore*=1.3
      end
      miniscore+=1
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::LIQUIDOOZE)
        miniscore = (2-miniscore)
      end
      if (attacker.hp!=attacker.totalhp || ((attacker.pbSpeed<pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0))) && opponent.effects[PBEffects::Substitute]==0
        score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !((!opponent.abilitynulled && opponent.ability == PBAbilities::SHIELDDUST) && !opponent.moldbroken) && !hasgreatmoves(initialscores,scoreindex,skill,true)
      end
    when 0x214 # Spectral Scream
      miniscore=100
      if (attacker.hp.to_f)/attacker.totalhp>0.75
        miniscore*=1.1
      end
      if opponent.effects[PBEffects::HyperBeam]>0
        miniscore*=1.2
      end
      if opponent.effects[PBEffects::Yawn]>0
        miniscore*=1.3
      end
      if opponent.status!=0
        miniscore*=1.1
      end
      if opponent.status==PBStatuses::SLEEP || opponent.status==PBStatuses::FROZEN
        miniscore*=1.3
      end
      if opponent.effects[PBEffects::Encore]>0
        if opponent.moves[(opponent.effects[PBEffects::EncoreIndex])].basedamage==0
          miniscore*=1.3
        end
      end
      miniscore*=0.2 if checkAImoves(PBStuff::SWITCHOUTMOVE,aimem)
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::SIMPLE)
        miniscore*=2
      end
      if attacker.hp==attacker.totalhp && ((attacker.hasWorkingItem(:FOCUSSASH) || ((!attacker.abilitynulled && attacker.ability == PBAbilities::STURDY) && !attacker.moldbroken) || (isConst?(attacker.species,PBSpecies,:RAMPARDOS) && isConst?(attacker.item,PBItems,:RAMPCREST)))  && (pbWeather!=PBWeather::HAIL || attacker.pbHasType?(:ICE)) && (pbWeather!=PBWeather::SANDSTORM || attacker.pbHasType?(:ROCK) || attacker.pbHasType?(:GROUND) || attacker.pbHasType?(:STEEL)))
        miniscore*=1.4
      end
      miniscore/=100.0
      if attacker.pbTooHigh?(PBStats::DEFENSE) && attacker.pbTooHigh?(PBStats::SPDEF) 
        miniscore=0
      end
      miniscore-=100
      if move.addlEffect.to_f != 100
        miniscore*=(move.addlEffect.to_f/100)
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::SERENEGRACE)
          miniscore*=2
        end
      end
      miniscore+=100
      miniscore/=100.0
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CONTRARY)
        score *= 0.9
      end
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
        miniscore*=0.9
      end
      if miniscore > 1
        score*=miniscore if !(!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) && !hasgreatmoves(initialscores,scoreindex,skill,true)
      end
    end
    ###### END FUNCTION CODES
    if (!opponent.abilitynulled && opponent.ability == PBAbilities::DANCER)
      if (PBStuff::DANCEMOVE).include?(move.id)
        score*=0.5
        score*=0.1 if $fefieldeffect==6
      end
    elsif (!attacker.pbPartner.abilitynulled && attacker.pbPartner.ability == PBAbilities::DANCER)
      if (PBStuff::DANCEMOVE).include?(move.id)
        score*=1.3
        score*=2 if $fefieldeffect==6
      end
    end
    ioncheck = false
    destinycheck = false
    widecheck = false
    powdercheck = false
    shieldcheck = false
    if skill>=PBTrainerAI.averageSkill
      ioncheck = true if checkAImoves([PBMoves::IONDELUGE],aimem)
      destinycheck = true if checkAImoves([PBMoves::DESTINYBOND],aimem)
      widecheck = true if checkAImoves([PBMoves::WIDEGUARD],aimem)
      powdercheck = true if  checkAImoves([PBMoves::POWDER],aimem)
      shieldcheck = true if checkAImoves([PBMoves::SPIKYSHIELD],aimem) || checkAImoves([PBMoves::KINGSSHIELD],aimem) ||  checkAImoves([PBMoves::BANEFULBUNKER],aimem)
      if !(opponent.pbPartner.nil?)
        if @doublebattle && @aiMoveMemory[2][opponent.pbPartner.pokemonIndex].length>0 && opponent.pbPartner.hp>0 
          for j in @aiMoveMemory[2][opponent.pbPartner.pokemonIndex]
            widecheck = true if j.id==(PBMoves::WIDEGUARD)
            powdercheck = true if j.id==(PBMoves::POWDER)
          end
        end
      end
    end
    if ioncheck == true
      if move.type == PBTypes::NORMAL
        if (!opponent.pbPartner.abilitynulled && opponent.pbPartner.ability == PBAbilities::LIGHTNINGROD) || (!opponent.abilitynulled && opponent.ability == PBAbilities::LIGHTNINGROD) ||
          (!opponent.abilitynulled && opponent.ability == PBAbilities::VOLTABSORB) || (!opponent.abilitynulled && opponent.ability == PBAbilities::MOTORDRIVE) || SilvallyCheck(opponent,"electric")
          score *= 0.3
        end
      end
    end
    if (move.target==PBTargets::SingleNonUser || move.target==PBTargets::RandomOpposing || move.target==PBTargets::AllOpposing || move.target==PBTargets::SingleOpposing || move.target==PBTargets::OppositeOpposing)
      if move.type==PBTypes::ELECTRIC || (ioncheck == true && move.type == PBTypes::NORMAL)
        if (!opponent.pbPartner.abilitynulled && opponent.pbPartner.ability == PBAbilities::LIGHTNINGROD)
          score*=0
        elsif (!attacker.pbPartner.abilitynulled && attacker.pbPartner.ability == PBAbilities::LIGHTNINGROD)
          score*=0.3
        end
      elsif move.type==PBTypes::WATER
        if (!opponent.pbPartner.abilitynulled && opponent.pbPartner.ability == PBAbilities::LIGHTNINGROD)
          score*=0
        elsif (!attacker.pbPartner.abilitynulled && attacker.pbPartner.ability == PBAbilities::LIGHTNINGROD)
          score*=0.3
        end
      end
    end
    if move.isSoundBased?
      if ((!opponent.abilitynulled && opponent.ability == PBAbilities::SOUNDPROOF) && !opponent.moldbroken) || attacker.effects[PBEffects::ThroatChop]!=0
        score*=0
      else
        score *= 0.6 if checkAImoves([PBMoves::THROATCHOP],aimem)
      end
      if (attitemworks && attacker.item == PBItems::THROATSPRAY)
        score*=1.5
      end
    end
    if move.flags&0x80!=0 && !move.id==152 # Boosted crit moves 
      if !((!opponent.abilitynulled && opponent.ability == PBAbilities::SHELLARMOR) || (!opponent.abilitynulled && opponent.ability == PBAbilities::BATTLEARMOR) || attacker.effects[PBEffects::LaserFocus]>0)
        boostercount = 1
        if move.pbIsPhysical?(move.type)
          boostercount += opponent.stages[PBStats::DEFENSE] if opponent.stages[PBStats::DEFENSE]>0
          boostercount -= attacker.stages[PBStats::ATTACK] if attacker.stages[PBStats::ATTACK]<0
        elsif move.pbIsSpecial?(move.type)
          boostercount += opponent.stages[PBStats::SPDEF] if opponent.stages[PBStats::SPDEF]>0
          boostercount -= attacker.stages[PBStats::SPATK] if attacker.stages[PBStats::SPATK]<0
        end
        score*=(1.02*boostercount)
      end
    end
    if move.basedamage>0
      if skill>=PBTrainerAI.averageSkill
        if opponent.effects[PBEffects::DestinyBond]
          score*=0.1
        else
          if ((opponent.pbSpeed>attacker.pbSpeed) ^ (@trickroom!=0)) && destinycheck
            score*=0.7
          end
        end
      end
    end
    if widecheck && ((move.target == PBTargets::AllOpposing) || (move.target == PBTargets::AllNonUsers)) && opponent.index!=attacker.pbPartner.index
      if !((opponent.statusCount>1 && opponent.status==PBStatuses::SLEEP  && opponent.pbHasMove?(PBMoves::WIDEGUARD)) || (opponent.pbPartner.statusCount>1 && opponent.pbPartner.status==PBStatuses::SLEEP  && opponent.pbPartner.pbHasMove?(PBMoves::WIDEGUARD)))
        score*=0.2
      end
    end
    if powdercheck && move.type==PBTypes::FIRE
      score*=0.2
    end
    if opponent.ability == PBAbilities::COTTONDOWN 
      if attacker.pbCanReduceStatStage?(PBStats::SPEED)
        score*=0.9
        if ((pbRoughStat(opponent,PBStats::SPEED,skill)<attacker.pbSpeed) ^ (@trickroom!=0))
          score*=0.8
        end
      end
    end
    if move.isContactMove? && !(attacker.item == PBItems::PROTECTIVEPADS) && !(!attacker.abilitynulled && attacker.ability == PBAbilities::LONGREACH)
      if (oppitemworks && opponent.item == PBItems::ROCKYHELMET) || shieldcheck
        score*=0.85
      end
      if (isConst?(attacker.species,PBSpecies,:TYPHLOSION) && attacker.hasWorkingItem(:TYPHCREST))
        score*=1.1
      end
      if !opponent.abilitynulled
        if opponent.ability == PBAbilities::ROUGHSKIN || opponent.ability == PBAbilities::IRONBARBS
          score*=0.85
        elsif opponent.ability == PBAbilities::EFFECTSPORE && attacker.status==0
          if (!hasgreatmoves(initialscores,scoreindex,skill,true,true) || hasgreatmoves(initialscores,scoreindex,skill))
            score*=0.75
          end
        elsif opponent.ability == PBAbilities::PERISHBODY 
          if (!hasgreatmoves(initialscores,scoreindex,skill,true,true) || hasgreatmoves(initialscores,scoreindex,skill))
            score*=0.75
          end
        elsif opponent.ability == PBAbilities::FLAMEBODY && attacker.pbCanBurn?(false)
          if (!hasgreatmoves(initialscores,scoreindex,skill,true,true) || hasgreatmoves(initialscores,scoreindex,skill))
            score*=0.75
          end
        elsif opponent.ability == PBAbilities::STATIC && attacker.pbCanParalyze?(false)
          if (!hasgreatmoves(initialscores,scoreindex,skill,true,true) || hasgreatmoves(initialscores,scoreindex,skill))
            score*=0.75
          end
        elsif opponent.ability == PBAbilities::POISONPOINT && attacker.pbCanPoison?(false)
          if (!hasgreatmoves(initialscores,scoreindex,skill,true,true) || hasgreatmoves(initialscores,scoreindex,skill))
            score*=0.75
          end
        elsif opponent.ability == PBAbilities::CUTECHARM && attacker.effects[PBEffects::Attract]<0
          if initialscores.length>0
            if initialscores[scoreindex] < 102
              score*=0.8
            end
          end
        elsif opponent.ability == PBAbilities::GOOEY || opponent.ability == PBAbilities::TANGLINGHAIR 
          if attacker.pbCanReduceStatStage?(PBStats::SPEED)
            score*=0.9
            if ((pbRoughStat(opponent,PBStats::SPEED,skill)<attacker.pbSpeed) ^ (@trickroom!=0))
              score*=0.8
            end
          end
        elsif opponent.ability == PBAbilities::WANDERINGSPIRIT
          if !attacker.abilitynulled && !((PBStuff::FIXEDABILITIES).include?(attacker.ability)) && !(attacker.ability == PBAbilities::WANDERINGSPIRIT || attacker.ability == PBAbilities::SHIELDDUST)
            spiritscore = getAbilityDisruptScore(move,opponent,attacker,skill)
            if spiritscore < 2
              spiritscore = 2 - spiritscore
            else
              spiritscore = 0.1
            end
          end
        elsif opponent.ability == PBAbilities::MUMMY
          if !attacker.abilitynulled && !((PBStuff::FIXEDABILITIES).include?(attacker.ability)) && !(attacker.ability == PBAbilities::MUMMY || attacker.ability == PBAbilities::SHIELDDUST)
            mummyscore = getAbilityDisruptScore(move,opponent,attacker,skill)
            if mummyscore < 2
              mummyscore = 2 - mummyscore
            else
              mummyscore = 0.1
            end
            score*=mummyscore
          end
        end
      end
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::POISONTOUCH) && opponent.pbCanPoison?(false)
        score*=1.1
      end
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::PICKPOCKET) && opponent.item!=0 && !pbIsUnlosableItem(opponent,opponent.item)
        score*=1.1
      end
      if (opponent.effects[PBEffects::KingsShield]== true && !(!attacker.abilitynulled && attacker.ability == PBAbilities::DEFIANT)) ||
        opponent.effects[PBEffects::BanefulBunker]== true ||
        opponent.effects[PBEffects::SpikyShield]== true
        score *=0.01
      end
      #maxdam=0
      # for i in attacker.moves
      #   next if i.isContactMove?
      #   tempdam = pbRoughDamage(i,opponent,attacker,skill,i.basedamage)
      #   if tempdam>maxdam
      #     maxdam=tempdam
      #   end
      # end
      # for i in opponent.moves
      #   if (i.id==(PBMoves::KINGSSHIELD) || i.id==(PBMoves::OBSTRUCT))
      #     if maxdam>opponent.hp
      #       score*=0.8
      #     end
      #   end
      # end
    end
    if move.basedamage>0 && (opponent.effects[PBEffects::SpikyShield] ||
        opponent.effects[PBEffects::BanefulBunker] || opponent.effects[PBEffects::KingsShield])
      score*=0.2
    elsif move.basedamage==0 && (opponent.effects[PBEffects::SpikyShield] || opponent.effects[PBEffects::BanefulBunker] || opponent.effects[PBEffects::KingsShield])
      score+=1
    end
    if (move.pbTargetsAll?(attacker) && move.basedamage>0) && (opponent.effects[PBEffects::Disguise] || opponent.effects[PBEffects::IceFace])
      score*=1.1
    end
    if skill>=PBTrainerAI.bestSkill 
      suckerdam=0
      for i in opponent.moves
        if i.id==(PBMoves::SUCKERPUNCH)
          suckerdam = pbRoughDamage(i,opponent,attacker,skill,i.basedamage)
        end
      end
      if ((attacker.pbSpeed>pbRoughStat(opponent,PBStats::SPEED,skill)) ^ (@trickroom!=0)) 
        if (suckerdam>(attacker.hp*0.5))
          if move.basedamage==0 || move.priority>0 && (suckerdam>(attacker.hp))
            suckerevade=true
            if (move.id==PBMoves::WILLOWISP && !(opponent.hasWorkingItem(:RAWSTBERRY) || opponent.hasWorkingItem(:LUMBERRY)) && opponent.pbCanBurn?(false)) || ((PBStuff::SLEEPMOVE).include?(move.id) && !(opponent.hasWorkingItem(:CHESTOBERRY) || opponent.hasWorkingItem(:LUMBERRY)) && opponent.pbCanSleep?(false))
              if (score>80 && score<100)
                score*=1.3 
              elsif (suckerdam>(attacker.hp))
                score*=1.5
                if hasgreatmoves(initialscores,scoreindex,skill) && score<85
                  score*=1.5
                end
              end
            end
          end
        end
      end 
    end
    if move.basedamage==0 && !(opponent.effects[PBEffects::SpikyShield] ||
      opponent.effects[PBEffects::BanefulBunker] || opponent.effects[PBEffects::KingsShield])
      if hasgreatmoves(initialscores,scoreindex,skill) && (!(attacker.status==PBStatuses::SLEEP && attacker.statusCount>1 && move.id==PBMoves::SLEEPTALK) && !(move.id==PBMoves::TRICKROOM)  && !(move.id==PBMoves::NATUREPOWER) && !(PBStuff::PROTECTMOVE).include?(move.id)) && !move.id!=getID(PBMoves,:ARENITEWALL) 
        maxdam=checkAIdamage(aimem,attacker,opponent,skill,true)
        maxdam2=checkAIdamage(aimem,opponent,attacker,skill,true)
        if (move.id==PBMoves::DRAGONDANCE)
          sweeping = setupminiscore(attacker,opponent,skill,move,true,17,false,initialscores,scoreindex,true)
        elsif move.function == 0x30
          sweeping = setupminiscore(attacker,opponent,skill,move,true,16,false,initialscores,scoreindex,true)
        elsif (move.id==PBMoves::AQUABATICS)
          sweeping = setupminiscore(attacker,opponent,skill,move,true,20,false,initialscores,scoreindex,true)
        elsif (move.id==PBMoves::SWORDSDANCE)
          sweeping = setupminiscore(attacker,opponent,skill,move,true,1,false,initialscores,scoreindex,true)
        elsif (move.id==PBMoves::BULKUP)
          sweeping = setupminiscore(attacker,opponent,skill,move,true,3,false,initialscores,scoreindex,true)
        elsif (move.id==PBMoves::NASTYPLOT)
          sweeping = setupminiscore(attacker,opponent,skill,move,true,4,false,initialscores,scoreindex,true)
        elsif move.name=="Z-Conversion"
          sweeping = setupminiscore(attacker,opponent,skill,move,true,31,false,initialscores,scoreindex,true)
        end
        if ((move.id==PBMoves::HYPNOSIS  && !(opponent.hasWorkingItem(:CHESTOBERRY) || opponent.hasWorkingItem(:LUMBERRY)) || move.id==PBMoves::WILLOWISP  && !(opponent.hasWorkingItem(:RAWSTBERRY) || opponent.hasWorkingItem(:LUMBERRY))) && (opponent.species==PBSpecies::PARASECT && opponent.form==1 || opponent.species==PBSpecies::MIMIKYU && opponent.effects[PBEffects::Disguise]) || suckerevade==true && !@doublebattle) 
          score*=1
        elsif (move.id==PBMoves::GRASSWHISTLE && attacker.ability==PBAbilities::PRANKSTER && ((pbRoughStat(opponent,PBStats::SPEED,skill)>attacker.pbSpeed) ^ (@trickroom!=0)) && maxdam>attacker.hp)
          score*=0.9
        elsif (sweeping==true)
          if (((maxdam>0 && maxdam<(attacker.hp*0.3)) || (move.id==PBMoves::DRAGONDANCE)) && opponent.pbNonActivePokemonCount>0)
            score*=0.8
          else
            score*=0.7
          end
        elsif ((attacker.effects[PBEffects::KingsShield] || attacker.effects[PBEffects::BanefulBunker] || attacker.effects[PBEffects::SpikyShield]) || (opponent.pbHasMove?(getID(PBMoves,:QUIVERDANCE)) && attacker.spatk>attacker.attack && (maxdam2*0.66<opponent.hp)) || (maxdam>0 && maxdam<(attacker.hp*0.3))) && !(opponent.effects[PBEffects::KingsShield]== true || opponent.effects[PBEffects::BanefulBunker]== true || opponent.effects[PBEffects::SpikyShield]== true) 
          score*=0.6
        else
          score*=0.2 ### highly controversial, revert to 0.1 if shit sucks
        end
      end
    end
    ispowder = (move.id==214 || move.id==218 || move.id==220 || move.id==445 || move.id==600 || move.id==18 || move.id==219)
    if ispowder && (opponent.pbHasType?(PBTypes::GRASS) || (!opponent.abilitynulled && opponent.ability == PBAbilities::OVERCOAT) || (oppitemworks && opponent.item == PBItems::SAFETYGOGGLES))
      score*=0
    end
    # A score of 0 here means it should absolutely not be used
    if score<=0
      if move.id < 1000
        PBDebug.log(sprintf("%s: final score: %d",PBMoves.getName(move.id),score)) if $INTERNAL && shutup==false
      else
        PBDebug.log(sprintf("%s: final score: %d",attacker.moves[4].name,score)) if $INTERNAL && shutup==false
      end
      PBDebug.log(sprintf(" ")) if $INTERNAL
      return score
    end
    ##### Other score modifications ################################################
    # Prefer damaging moves if AI has no more Pokémon
    if attacker.pbNonActivePokemonCount==0
      if skill>=PBTrainerAI.mediumSkill && !(skill>=PBTrainerAI.averageSkill && opponent.pbNonActivePokemonCount>0)
        if move.basedamage==0 && !(attacker.status==PBStatuses::SLEEP && attacker.statusCount>1 && move.id==PBMoves::SLEEPTALK) && !(move.id==PBMoves::TRICKROOM)  && !(move.id==PBMoves::NATUREPOWER) && !(move.id==PBMoves::PROTECT)
          PBDebug.log("[Not preferring status move]") if $INTERNAL && shutup==false
          score*=0.9
        elsif opponent.hp<=opponent.totalhp/2 
          PBDebug.log("[Preferring damaging move]") if $INTERNAL && shutup==false
          score*=1.1
        end
      end
    end
    # Don't prefer attacking the opponent if they'd be semi-invulnerable
    if opponent.effects[PBEffects::TwoTurnAttack]>0 && skill>=PBTrainerAI.averageSkill
      invulmove=$pkmn_move[opponent.effects[PBEffects::TwoTurnAttack]][0]
      if move.accuracy>0 && ([0xC9,0xCA,0xCB,0xCC,0xCD,0xCE].include?(invulmove) || opponent.effects[PBEffects::SkyDrop]) && ((attacker.pbSpeed>opponent.pbSpeed) ^ (@trickroom!=0)) # Checks accuracy, i.e. targets opponent
        if skill>=PBTrainerAI.highSkill   # Can get past semi-invulnerability
          miss=false
          case invulmove
          when 0xC9, 0xCC # Fly, Bounce
            miss=true unless move.function==0x08 ||  # Thunder
            move.function==0x15 ||  # Hurricane
            move.function==0x77 ||  # Gust
            move.function==0x78 ||  # Twister
            move.function==0x11B || # Sky Uppercut
            move.function==0x11C || # Smack Down
            isConst?(move.id,PBMoves,:WHIRLWIND)
          when 0xCA # Dig
            miss=true unless move.function==0x76 || # Earthquake
            move.function==0x95    # Magnitude
          when 0xCB # Dive
            miss=true unless move.function==0x75 || # Surf
            move.function==0xD0 || # Whirlpool
            move.function==0x12D   # Shadow Storm
          when 0xCD # Shadow Force
            miss=true
          when 0xCE # Sky Drop
            miss=true unless move.function==0x08 ||  # Thunder
            move.function==0x15 ||  # Hurricane
            move.function==0x77 ||  # Gust
            move.function==0x78 ||  # Twister
            move.function==0x11B || # Sky Uppercut
            move.function==0x11C    # Smack Down
          end
          if opponent.effects[PBEffects::SkyDrop]
            miss=true unless move.function==0x08 ||  # Thunder
            move.function==0x15 ||  # Hurricane
            move.function==0x77 ||  # Gust
            move.function==0x78 ||  # Twister
            move.function==0x11B || # Sky Uppercut
            move.function==0x11C    # Smack Down
          end
          score*=0 if miss
        else
          score*=0
        end
      end
    end
    # Pick a good move for the Choice items
    if (attitemworks && (attacker.item == PBItems::CHOICEBAND || attacker.item == PBItems::CHOICESPECS || attacker.item == PBItems::CHOICESCARF)) || !attacker.abilitynulled && (attacker.ability == PBAbilities::GORILLATACTICS) 
      if move.basedamage==0 && move.function!=0xF2 # Trick
        score*=0.1
      end
      if ((move.type == PBTypes::NORMAL) && $fefieldeffect!=29) || ((move.type == PBTypes::GHOST)&& $fefieldeffect!=40) || (move.type == PBTypes::FIGHTING) || (move.type == PBTypes::DRAGON) || (move.type == PBTypes::PSYCHIC) || (move.type == PBTypes::GROUND) || (move.type == PBTypes::ELECTRIC) || (move.type == PBTypes::POISON)
        score*=0.95
      end
      if (move.type == PBTypes::FIRE) || (move.type == PBTypes::WATER) || (move.type == PBTypes::GRASS) || (move.type == PBTypes::ELECTRIC)
        score*=0.95
      end
      if move.accuracy > 0
        miniacc = (move.accuracy/100.0)
        score *= miniacc
      end
      if move.pp < 6
        score *= 0.9
      end
    end
    # Prefer moves that miss if you have Blunder Policy.
    if move.accuracy<100 && attacker.item == PBItems::BLUNDERPOLICY
      score*=1.2
    end
    #If user is frozen, prefer a move that can thaw the user
    if attacker.status==PBStatuses::FROZEN
      if skill>=PBTrainerAI.mediumSkill
        if move.canThawUser?
          score+=30
        else
          hasFreezeMove=false
          for m in attacker.moves
            if m.canThawUser?
              hasFreezeMove=true; break
            end
          end
          score*=0 if hasFreezeMove
        end
      end
    end
    # If target is frozen, don't prefer moves that could thaw them
    if opponent.status==PBStatuses::FROZEN
      if (move.type == PBTypes::FIRE)
        score *= 0.1
      end
    end
    opponentdamage=checkAIdamage(aimem,attacker,opponent,skill,true,true)[0]
    opponentstrongmove=checkAIdamage(aimem,attacker,opponent,skill,true,true)[1]
    nextdamage=checkAIdamage(aimem,attacker,opponent,skill,true,true)[2]
    opponent2ndstrongmove=checkAIdamage(aimem,attacker,opponent,skill,true,true)[3]
    if opponentstrongmove!=0
      if opponentstrongmove.id == getID(PBMoves,:FOCUSPUNCH)
        if move.basedamage==0 && !((move.id==(PBMoves::SLEEPTALK) || (move.id==(PBMoves::NATUREPOWER))))
          if nextdamage<(opponentdamage/2) #&& opponent.effects[PBEffects::Attacking]==true
            score*=0.5
          end
        end
      end    
    end
    # Adjust score based on how much damage it can deal
    if move.basedamage>0
      typemod=pbTypeModNoMessages(move.type,attacker,opponent,move,skill)
      if typemod==0 || score<=0
        if $fefieldeffect==29
          if (move.id==(PBMoves::SPECTRALSCREAM)) || (move.id==(PBMoves::PHANTOMFORCE)) || (move.id==(PBMoves::OMINOUSWIND))
            ghostvar=false
            for mon in pbParty(attacker.index)
              next if mon.nil?
              next if mon.hp==0
              if isConst?(i.type,PBTypes,:GHOST)
                ghostvar=true
              end
            end
            score*=1.3 if ghostvar
          end 
        else
          score=0
        end
      elsif skill>=PBTrainerAI.mediumSkill && !(!attacker.abilitynulled && (attacker.ability == PBAbilities::MOLDBREAKER || attacker.ability == PBAbilities::TURBOBLAZE || attacker.ability == PBAbilities::TERAVOLT))
        if !opponent.abilitynulled
          if (move.type == PBTypes::GROUND && move.name!="Thousand Arrows" && (opponent.ability == PBAbilities::LEVITATE || opponent.ability == PBAbilities::SOLARIDOL || opponent.ability == PBAbilities::LUNARIDOL || (isConst?(opponent.species,PBSpecies,:SKUNTANK) && opponent.hasWorkingItem(:SKUNCREST)) || (oppitemworks && opponent.item == PBItems::AIRBALLOON) || opponent.effects[PBEffects::MagnetRise]>0)) ||
            (move.type == PBTypes::FIRE && opponent.ability == PBAbilities::FLASHFIRE) ||
            (move.type == PBTypes::WATER && (opponent.ability == PBAbilities::WATERABSORB || opponent.ability == PBAbilities::STORMDRAIN || opponent.ability == PBAbilities::DRYSKIN)) ||
            (move.type == PBTypes::GRASS && (opponent.ability == PBAbilities::SAPSIPPER || (isConst?(opponent.species,PBSpecies,:WHISCASH) && opponent.hasWorkingItem(:WHISCREST)))) ||
            (move.type == PBTypes::ELECTRIC && (opponent.ability == PBAbilities::VOLTABSORB || opponent.ability == PBAbilities::LIGHTNINGROD || opponent.ability == PBAbilities::MOTORDRIVE)) ||
            (typemod<=4 && opponent.ability == PBAbilities::WONDERGUARD)  
            score=0
          end
        end
      else
        if move.type == PBTypes::GROUND && (opponent.ability == PBAbilities::LEVITATE || opponent.ability == PBAbilities::SOLARIDOL || opponent.ability == PBAbilities::LUNARIDOL || (oppitemworks && opponent.item == PBItems::AIRBALLOON) || opponent.effects[PBEffects::MagnetRise]>0)
          if move.name!="Thousand Arrows"
            score=0
          end
        end
      end
      if score != 0
        # Calculate how much damage the move will do (roughly)
        realBaseDamage=move.basedamage
        realBaseDamage=60 if move.basedamage==1
        if skill>=PBTrainerAI.mediumSkill
          realBaseDamage=pbBetterBaseDamage(move,attacker,opponent,skill,realBaseDamage)
        end
      end
    else # non-damaging moves
      if !opponent.abilitynulled
        if ((move.type == PBTypes::GROUND && !(move.id==(PBMoves::DESERTSMARK)) && !(move.id==(PBMoves::SPIKES)) && (opponent.ability == PBAbilities::LEVITATE || opponent.ability == PBAbilities::SOLARIDOL || opponent.ability == PBAbilities::LUNARIDOL || (isConst?(opponent.species,PBSpecies,:SKUNTANK) && opponent.hasWorkingItem(:SKUNCREST)) || (oppitemworks && opponent.item == PBItems::AIRBALLOON) || opponent.effects[PBEffects::MagnetRise]>0)) ||
          (move.type == PBTypes::FIRE && opponent.ability == PBAbilities::FLASHFIRE) ||
          (move.type == PBTypes::WATER && (opponent.ability == PBAbilities::WATERABSORB || opponent.ability == PBAbilities::STORMDRAIN || opponent.ability == PBAbilities::DRYSKIN)) ||
          (move.type == PBTypes::GRASS && opponent.ability == PBAbilities::SAPSIPPER || (isConst?(opponent.species,PBSpecies,:WHISCASH) && opponent.hasWorkingItem(:WHISCREST))) ||
          (move.type == PBTypes::ELECTRIC && (opponent.ability == PBAbilities::VOLTABSORB || opponent.ability == PBAbilities::LIGHTNINGROD || opponent.ability == PBAbilities::MOTORDRIVE))) &&  (move.target==PBTargets::SingleNonUser || move.target==PBTargets::RandomOpposing || move.target==PBTargets::AllOpposing || move.target==PBTargets::OpposingSide || move.target==PBTargets::SingleOpposing || move.target==PBTargets::OppositeOpposing)
          score=0
        end
      end
    end
    accuracy=pbRoughAccuracy(move,attacker,opponent,skill)
    if accuracy<70
      score*=accuracy/100.0
    end
    #score=0 if score<=10 && skill>=PBTrainerAI.averageSkill
    if move.basedamage==0 && (move.target==PBTargets::SingleNonUser || move.target==PBTargets::RandomOpposing || move.target==PBTargets::AllOpposing || move.target==PBTargets::OpposingSide || move.target==PBTargets::SingleOpposing || move.target==PBTargets::OppositeOpposing) &&
      (((opponent.ability == PBAbilities::MAGICBOUNCE) || SilvallyCheck(opponent,PBTypes::PSYCHIC)) || opponent.effects[PBEffects::MagicCoat]==true)
      if move.id!=PBMoves::DEFOG
        score=0
      end
    elsif move.basedamage==0 && (move.target==PBTargets::RandomOpposing || move.target==PBTargets::AllOpposing || move.target==PBTargets::OpposingSide) && ((@doublebattle && opponent.pbPartner.hasWorkingAbility(:MAGICBOUNCE)) || (@doublebattle && SilvallyCheck(opponent.pbPartner, "psychic")))
      if move.id!=PBMoves::DEFOG
        score=0
      end
    end
    if skill>=PBTrainerAI.mediumSkill
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::PRANKSTER)
        if opponent.pbHasType?(:DARK) && !($fefieldeffect==42)
          if move.basedamage==0 && move.priority>-1 && (move.target==PBTargets::SingleOpposing || move.target==PBTargets::SingleNonUser)
            score=0
          end
        end
      end
    end
    score=score.to_i
    score=0 if score<0
    if move.id < 1000
      PBDebug.log(sprintf("%s: final score: %d",PBMoves.getName(move.id),score)) if $INTERNAL && shutup==false
    else
      PBDebug.log(sprintf("%s: final score: %d",attacker.moves[4].name,score)) if $INTERNAL && shutup==false
    end
    PBDebug.log(sprintf(" ")) if $INTERNAL && shutup==false
    return score
  end
  
  ################################################################################
  # Get type effectiveness and approximate stats.
  ################################################################################
  def pbTypeModifierAI(type,attacker,opponent,zorovar=false)
    return 4 if type<0
    return 4 if isConst?(type,PBTypes,:GROUND) && opponent.pbHasType?(:FLYING) &&
    opponent.hasWorkingItem(:IRONBALL)
    atype=type # attack type
    otype1=opponent.type1
    otype2=opponent.type2
    if zorovar # ai being fooled by illusion
      otype1=opponent.effects[PBEffects::Illusion].type1 #17
      otype2=opponent.effects[PBEffects::Illusion].type2 #17
    end
=begin
    if id == PBMoves::VENAMSKISS
      if isConst?(otype1,PBTypes,:STEEL)
        if !isConst?(otype2,PBTypes,:GRASS)
          otype1=getConst(PBTypes,:GRASS) || 0
          if isConst?(otype2,PBTypes,:STEEL)
            otype2=getConst(PBTypes,:GRASS) || 0
          end
        else
          otype1=getConst(PBTypes,:FAIRY) || 0
        end
      end
      if isConst?(otype2,PBTypes,:STEEL)
        if !isConst?(otype1,PBTypes,:GRASS)
          otype2=getConst(PBTypes,:GRASS) || 0
        else
          otype2=getConst(PBTypes,:FAIRY) || 0
        end
      end
    end
=end
    if isConst?(otype1,PBTypes,:FLYING) && opponent.effects[PBEffects::Roost]
      if isConst?(otype2,PBTypes,:FLYING)
        otype1=getConst(PBTypes,:NORMAL) || 0
      else
        otype1=otype2
      end
    end
    if isConst?(otype2,PBTypes,:FLYING) && opponent.effects[PBEffects::Roost]
      otype2=otype1
    end
    if isConst?(otype1,PBTypes,:FIRE) && opponent.effects[PBEffects::BurnUp]
      if isConst?(otype2,PBTypes,:FIRE)
        otype1=getConst(PBTypes,:QMARKS) || 0
      else
        otype1=otype2
      end
    end
    if isConst?(otype2,PBTypes,:FIRE) && opponent.effects[PBEffects::BurnUp]
      otype2=otype1
    end
    mod1=PBTypes.getEffectiveness(atype,otype1)
    mod2=(otype1==otype2) ? 2 : PBTypes.getEffectiveness(atype,otype2)
    if $fefieldeffect == 23 #|| id == PBMoves::THOUSANDARROWS
      mod1=2 if isConst?(otype1,PBTypes,:FLYING) && isConst?(atype,PBTypes,:GROUND)
      mod2=2 if isConst?(otype2,PBTypes,:FLYING) && isConst?(atype,PBTypes,:GROUND)
    end
    if opponent.hasWorkingItem(:RINGTARGET)
      mod1=2 if mod1==0
      mod2=2 if mod2==0
    end
    if (!attacker.abilitynulled && attacker.ability == PBAbilities::SCRAPPY) || SilvallyCheck(attacker,PBTypes::NORMAL) ||
      opponent.effects[PBEffects::Foresight]
      mod1=2 if isConst?(otype1,PBTypes,:GHOST) &&
      (isConst?(atype,PBTypes,:NORMAL) || isConst?(atype,PBTypes,:FIGHTING))
      mod2=2 if isConst?(otype2,PBTypes,:GHOST) &&
      (isConst?(atype,PBTypes,:NORMAL) || isConst?(atype,PBTypes,:FIGHTING))
    end
    if attacker.hasWorkingAbility(:ADAPTABILITY) && $fefieldeffect==5
      mod1=1 if mod1==0
      mod2=1 if mod2==0
    end
    if $fefieldeffect == 29
      mod1=2 if isConst?(otype1,PBTypes,:GHOST) &&
      isConst?(atype,PBTypes,:NORMAL)
      mod2=2 if isConst?(otype2,PBTypes,:GHOST) &&
      isConst?(atype,PBTypes,:NORMAL)
    end
    if $fefieldeffect == 40
      mod1=2 if isConst?(otype1,PBTypes,:NORMAL) &&
      isConst?(atype,PBTypes,:GHOST)
      mod2=2 if isConst?(otype2,PBTypes,:NORMAL) &&
      isConst?(atype,PBTypes,:GHOST)
    end
    if (!attacker.abilitynulled && attacker.ability == PBAbilities::PIXILATE) ||
      (!attacker.abilitynulled && attacker.ability == PBAbilities::AERILATE) ||
      (!attacker.abilitynulled && attacker.ability == PBAbilities::REFRIGERATE) ||
      (!attacker.abilitynulled && attacker.ability == PBAbilities::GALVANIZE) ||
      ((!attacker.abilitynulled && attacker.ability == PBAbilities::LIQUIDVOICE))
      mod1=2 if isConst?(otype1,PBTypes,:GHOST) && isConst?(atype,PBTypes,:NORMAL)
      mod2=2 if isConst?(otype2,PBTypes,:GHOST) && isConst?(atype,PBTypes,:NORMAL)
    end
    if (!attacker.abilitynulled && attacker.ability == PBAbilities::NORMALIZE)
      mod1=2 if isConst?(otype1,PBTypes,(:GROUND || :FAIRY || :FLYING || :NORMAL || :DARK))
      mod1=1 if isConst?(otype1,PBTypes,:STEEL)
      mod1=0 if isConst?(otype1,PBTypes,:GHOST) && !opponent.effects[PBEffects::Foresight]
      mod2=2 if isConst?(otype2,PBTypes,(:GROUND || :FAIRY || :FLYING || :NORMAL || :DARK))
      mod2=1 if isConst?(otype2,PBTypes,:STEEL)
      mod2=0 if isConst?(otype2,PBTypes,:GHOST) && !opponent.effects[PBEffects::Foresight]
    end
    if opponent.effects[PBEffects::Electrify]
      mod1=0 if isConst?(otype1,PBTypes,:GROUND)
      mod1=4 if isConst?(otype1,PBTypes,:FLYING)
      mod1=2 if isConst?(otype1,PBTypes,(:GHOST || :FAIRY || :NORMAL || :DARK))
      mod2=0 if isConst?(otype2,PBTypes,:GROUND)
      mod2=4 if isConst?(otype2,PBTypes,:FLYING)
      mod2=2 if isConst?(otype2,PBTypes,(:GHOST || :FAIRY || :NORMAL || :DARK))
    end
    if $fefieldeffect == 24
      mod1=0 if isConst?(otype1,PBTypes,:GHOST) && isConst?(atype,PBTypes,(:FAIRY || :DARK || :STEEL))
      mod2=0 if isConst?(otype2,PBTypes,:GHOST) && isConst?(atype,PBTypes,(:FAIRY || :DARK || :STEEL))
    end
    if opponent.effects[PBEffects::Ingrain] ||
      opponent.effects[PBEffects::SmackDown] ||
      @field.effects[PBEffects::Gravity]>0
      mod1=2 if isConst?(otype1,PBTypes,:FLYING) && isConst?(atype,PBTypes,:GROUND)
      mod2=2 if isConst?(otype2,PBTypes,:FLYING) && isConst?(atype,PBTypes,:GROUND)
    end
    if opponent.effects[PBEffects::MiracleEye]
      mod1=2 if isConst?(otype1,PBTypes,:DARK) && isConst?(atype,PBTypes,:PSYCHIC)
      mod2=2 if isConst?(otype2,PBTypes,:DARK) && isConst?(atype,PBTypes,:PSYCHIC)
    end
    typemod = mod1*mod2
    if $fefieldeffect == 36 # Inverse Field
      temptypemod = typemod
      temptypemod = 8 if typemod == 0
      temptypemod = 16 if typemod == 1
      temptypemod = 8 if typemod == 2
      temptypemod = 2 if typemod == 8
      temptypemod = 1 if typemod == 16
      typemod = temptypemod
    end
    if !($fefieldeffect==36) && isConst?(opponent.species,PBSpecies,:TORTERRA) && 
      isConst?(opponent.item,PBItems,:TORCREST)
      temptypemod = typemod
      #temptypemod = 8 if typemod == 0 
      temptypemod = 16 if typemod == 1
      temptypemod = 8 if typemod == 2
      temptypemod = 2 if typemod == 8
      temptypemod = 1 if typemod == 16
      temptypemod = 0.5 if typemod == 32
      temptypemod = 32 if typemod == 0.5
      typemod = temptypemod
    end
    return typemod
  end
  
  def pbTypeModifier2(battlerThis,battlerOther)
    if battlerThis.type1==battlerThis.type2
      return 4*pbTypeModifier(battlerThis.type1,battlerThis,battlerOther)
    else
      ret=pbTypeModifier(battlerThis.type1,battlerThis,battlerOther)
      ret*=pbTypeModifier(battlerThis.type2,battlerThis,battlerOther)
      return ret # 0,1,2,4,8,_16_,32,64,128,256
    end
  end
  
  def pbRoughStat(battler,stat,skill)
    if skill>=PBTrainerAI.averageSkill && stat==PBStats::SPEED
      return battler.pbSpeed
    end
    stagemul=[2,2,2,2,2,2,2,3,4,5,6,7,8]
    stagediv=[8,7,6,5,4,3,2,2,2,2,2,2,2]
    stage=battler.stages[stat]+6
    value=0
    value=battler.attack if stat==PBStats::ATTACK
    value=battler.defense if stat==PBStats::DEFENSE
    value=battler.speed if stat==PBStats::SPEED
    value=battler.spatk if stat==PBStats::SPATK
    value=battler.spdef if stat==PBStats::SPDEF
    return (value*1.0*stagemul[stage]/stagediv[stage]).floor
  end
  
  def pbBetterBaseDamage(move,attacker,opponent,skill,basedamage,hardswitch=false)
    # Covers all function codes which have their own def pbBaseDamage
    aimem = getAIMemory(skill,opponent.pokemonIndex)
    case move.function
    when 0x43 # Gravapple
      if $fefieldeffect==15 && isConst?(move.id,PBMoves,:GRAVAPPLE)
        basedamage=120
      end
    when 0x6A # SonicBoom
      basedamage=20
      if $fefieldeffect==9 || @field.effects[PBEffects::Rainbow]>0
        basedamage=140
      end
    when 0x6B # Dragon Rage
      basedamage=40
    when 0x6C # Super Fang
      basedamage=(opponent.hp/2.0).floor
      if isConst?(move.id,PBMoves,:NATURESMADNESS) && ($fefieldeffect == 2 || $fefieldeffect == 15 || $fefieldeffect == 29 || $fefieldeffect == 35 || $fefieldeffect == 42)
        basedamage=(opponent.hp*0.75).floor
      end
    when 0x6D # Night Shade
      basedamage=attacker.level
      if isConst?(move.id,PBMoves,:NIGHTSHADE) && ($fefieldeffect == 40)
        basedamage=(attacker.level*1.5).floor
      end
    when 0x6E # Endeavor
      if !hardswitch
        basedamage=opponent.hp-attacker.hp
      else
        basedamage=attacker.totalhp-attacker.hp
      end
    when 0x6F # Psywave
      if $game_variables[200]==2
         basedamage=attacker.level*1.35
         basedamage=basedamage.to_i
      else
        basedamage=attacker.level
      end
    when 0x70 # OHKO
      if attacker.level>=opponent.level
        basedamage=opponent.totalhp
      else
        basedamage=1
      end
    when 0x71 # Counter
      maxdam=60
      for j in opponent.moves
        next if j.pbIsSpecial?(j.type)
        next if j.basedamage<=1
        tempdam = pbRoughDamage(j,opponent,attacker,skill,j.basedamage)*2
        if tempdam>maxdam
          maxdam=tempdam
        end
        if !(opponent.item == PBItems::INTERCEPTZ2) && pbCanZMove?(opponent.index) && (pbOwnedByPlayer?(opponent.index))
          if opponent.pbCompatibleZMoveFromMove?(j)
            zmove = PokeBattle_ZMoves2.new(j,opponent.item)
            tempdam = pbRoughDamage(zmove,opponent,attacker,skill,zmove.basedamage) 
            if tempdam>maxdam
              maxdam=tempdam
            end
          end
        end
      end
      basedamage = maxdam
    when 0x72 # Mirror Coat
      maxdam=60
      for j in opponent.moves
        next if j.pbIsPhysical?(j.type)
        next if j.basedamage<=1
        tempdam = pbRoughDamage(j,opponent,attacker,skill,j.basedamage)*2
        if tempdam>maxdam
          maxdam=tempdam
        end
        if !(opponent.item == PBItems::INTERCEPTZ2) && pbCanZMove?(opponent.index) && (pbOwnedByPlayer?(opponent.index))
          if opponent.pbCompatibleZMoveFromMove?(j)
            zmove = PokeBattle_ZMoves2.new(j,opponent.item)
            tempdam = pbRoughDamage(zmove,opponent,attacker,skill,zmove.basedamage) 
            if tempdam>maxdam
              maxdam=tempdam
            end
          end
        end
      end
      basedamage = maxdam
    when 0x73 # Metal Burst
      maxdam=45
      for j in opponent.moves
        next if j.basedamage<=1
        tempdam = pbRoughDamage(j,opponent,attacker,skill,j.basedamage)* 1.5
        if tempdam>maxdam
          maxdam=tempdam
        end
        if !(opponent.item == PBItems::INTERCEPTZ2) && pbCanZMove?(opponent.index) && (pbOwnedByPlayer?(opponent.index))
          if opponent.pbCompatibleZMoveFromMove?(j)
            zmove = PokeBattle_ZMoves2.new(j,opponent.item)
            tempdam = pbRoughDamage(zmove,opponent,attacker,skill,zmove.basedamage) 
            if tempdam>maxdam
              maxdam=tempdam
            end
          end
        end
      end
      basedamage = maxdam
    when 0x75, 0x12D # Surf, Shadow Storm
      basedamage*=2 if $pkmn_move[opponent.effects[PBEffects::TwoTurnAttack]][0] == 0xCB # Dive
    when 0x76 # Earthquake
      basedamage*=2 if $pkmn_move[opponent.effects[PBEffects::TwoTurnAttack]][0] == 0xCA # Dig
    when 0x77, 0x78 # Gust, Twister
      basedamage*=2 if $pkmn_move[opponent.effects[PBEffects::TwoTurnAttack]][0] == 0xC9 # Fly
      $pkmn_move[opponent.effects[PBEffects::TwoTurnAttack]][0] == 0xCC # Bounce
      $pkmn_move[opponent.effects[PBEffects::TwoTurnAttack]][0] == 0xCE # Sky Drop
    when 0x79 # Fusion Bolt
      basedamage*=2 if previousMove == 127 || previousMove == 131
    when 0x7A # Fusion Flare
      basedamage*=2 if previousMove == 64 || previousMove == 68
    when 0x7B # Venoshock
      if opponent.status==PBStatuses::POISON
        basedamage*=2
      elsif skill>=PBTrainerAI.highSkill
        if $fefieldeffect==10 || $fefieldeffect==11 || $fefieldeffect==19 || $fefieldeffect==26 # Corrosive/Corromist/Wasteland/Murkwater
          basedamage*=2
        end
      end
    when 0x7C # SmellingSalt
      basedamage*=2 if opponent.status==PBStatuses::PARALYSIS
    when 0x7D # Wake-Up Slap
      basedamage*=2 if opponent.status==PBStatuses::SLEEP
    when 0x7E # Facade
      basedamage*=2 if attacker.status==PBStatuses::POISON ||
      attacker.status==PBStatuses::BURN ||
      attacker.status==PBStatuses::PARALYSIS
    when 0x7F # Hex
      basedamage*=2 if opponent.status!=0 || (opponent.hasWorkingItem(:MAGICALSEED))
    when 0x80 # Brine
      basedamage*=2 if opponent.hp<=(opponent.totalhp/2).floor
    when 0x85 # Retaliate
      basedamage*=2 if attacker.pbOwnSide.effects[PBEffects::Retaliate]
    when 0x86 # Acrobatics
      basedamage*=2 if attacker.item==0 || attacker.hasWorkingItem(:FLYINGGEM) || $fefieldeffect == 6 || $fefieldeffect == 43 || ((PBStuff::TELLURICFIELDS).include?($fefieldeffect) && attacker.hasWorkingItem(:TELLURICSEED)) ||
      ((PBStuff::ELEMENTALFIELDS).include?($fefieldeffect) && attacker.hasWorkingItem(:ELEMENTALSEED)) || ((PBStuff::MAGICALFIELDS).include?($fefieldeffect) && attacker.hasWorkingItem(:MAGICALSEED)) || 
      ((PBStuff::SYNTHETICFIELDS).include?($fefieldeffect) && attacker.hasWorkingItem(:SYNTHETICSEED))
    when 0x87 # Weather Ball
    when 0x89 # Return
      basedamage=[(attacker.happiness*2/5).floor,1].max
    when 0x8A # Frustration
      basedamage=[((255-attacker.happiness)*2/5).floor,1].max
    when 0x8B # Eruption
      basedamage=[(150*(attacker.hp.to_f)/attacker.totalhp).floor,1].max
    when 0x8C # Crush Grip
      basedamage=[(120*opponent.hp/opponent.totalhp).floor,1].max
    when 0x8D # Gyro Ball
      ospeed=pbRoughStat(opponent,PBStats::SPEED,skill)
      aspeed=pbRoughStat(attacker,PBStats::SPEED,skill)
      basedamage=[[(25*ospeed/aspeed).floor,150].min,1].max
    when 0x8E # Stored Power
      mult=0
      for i in [PBStats::ATTACK,PBStats::DEFENSE,PBStats::SPEED,
          PBStats::SPATK,PBStats::SPDEF,PBStats::ACCURACY,PBStats::EVASION]
        mult+=attacker.stages[i] if attacker.stages[i]>0
      end
      basedamage=20*(mult+1)
    when 0x8F # Punishment
      mult=0
      for i in [PBStats::ATTACK,PBStats::DEFENSE,PBStats::SPEED,
          PBStats::SPATK,PBStats::SPDEF,PBStats::ACCURACY,PBStats::EVASION]
        mult+=opponent.stages[i] if opponent.stages[i]>0
      end
      basedamage=[20*(mult+3),200].min
      #   when 0x90 # Hidden Power
      #     hp=pbHiddenPower(attacker.iv)
    when 0x91 # Fury Cutter
      basedamage=basedamage<<(attacker.effects[PBEffects::FuryCutter]-1)
    when 0x92 # Echoed Voice
      if attacker.effects[PBEffects::EchoedVoice]>0
        basedamage*=attacker.effects[PBEffects::EchoedVoice] 
      else
        basedamage=basedamage
      end
    when 0x94 # Present
      basedamage=50
    when 0x95 # Magnitude
      basedamage=71
      basedamage*=2 if $pkmn_move[opponent.effects[PBEffects::TwoTurnAttack]][0] == 0xCA # Dig
    when 0x96 # Natural Gift
      damagearray={
        60 => [:CHERIBERRY,:CHESTOBERRY,:PECHABERRY,:RAWSTBERRY,:ASPEARBERRY,
          :LEPPABERRY,:ORANBERRY,:PERSIMBERRY,:LUMBERRY,:SITRUSBERRY,
          :FIGYBERRY,:WIKIBERRY,:MAGOBERRY,:AGUAVBERRY,:IAPAPABERRY,
          :RAZZBERRY,:OCCABERRY,:PASSHOBERRY,:WACANBERRY,:RINDOBERRY,
          :YACHEBERRY,:CHOPLEBERRY,:KEBIABERRY,:SHUCABERRY,:COBABERRY,
          :PAYAPABERRY,:TANGABERRY,:CHARTIBERRY,:KASIBBERRY,:HABANBERRY,
          :COLBURBERRY,:BABIRIBERRY,:CHILANBERRY],
        70 => [:BLUKBERRY,:NANABBERRY,:WEPEARBERRY,:PINAPBERRY,:POMEGBERRY,
          :KELPSYBERRY,:QUALOTBERRY,:HONDEWBERRY,:GREPABERRY,:TAMATOBERRY,
          :CORNNBERRY,:MAGOSTBERRY,:RABUTABERRY,:NOMELBERRY,:SPELONBERRY,
          :PAMTREBERRY],
        80 => [:WATMELBERRY,:DURINBERRY,:BELUEBERRY,:LIECHIBERRY,:GANLONBERRY,
          :SALACBERRY,:PETAYABERRY,:APICOTBERRY,:LANSATBERRY,:STARFBERRY,
          :ENIGMABERRY,:MICLEBERRY,:CUSTAPBERRY,:JABOCABERRY,:ROWAPBERRY]
      }
      haveanswer=false
      for i in damagearray.keys
        data=damagearray[i]
        if data
          for j in data
            if isConst?(attacker.item,PBItems,j)
              basedamage=i; haveanswer=true; break
            end
          end
        end
        break if haveanswer
      end
    when 0x97 # Trump Card
      dmgs=[200,80,60,50,40]
      ppleft=[move.pp-1,4].min   # PP is reduced before the move is used
      basedamage=dmgs[ppleft]
    when 0x98 # Flail
      n=(48*(attacker.hp.to_f)/attacker.totalhp).floor
      basedamage=20
      basedamage=40 if n<33
      basedamage=80 if n<17
      basedamage=100 if n<10
      basedamage=150 if n<5
      basedamage=200 if n<2
    when 0x99 # Electro Ball
      n=(attacker.pbSpeed/opponent.pbSpeed).floor
      basedamage=40
      basedamage=60 if n>=1
      basedamage=80 if n>=2
      basedamage=120 if n>=3
      basedamage=150 if n>=4
    when 0x9A # Low Kick
      weight=opponent.weight
      basedamage=20
      basedamage=40 if weight>100
      basedamage=60 if weight>250
      basedamage=80 if weight>500
      basedamage=100 if weight>1000
      basedamage=120 if weight>2000
    when 0x9B # Heavy Slam
      n=(attacker.weight/opponent.weight).floor
      basedamage=40
      basedamage=60 if n>=2
      basedamage=80 if n>=3
      basedamage=100 if n>=4
      basedamage=120 if n>=5
    when 0xA0 # Frost Breath
      basedamage*=1.5
    when 0xBD, 0xBE # Double Kick, Twineedle
      basedamage*=2
    when 0xBF # Triple Kick
      basedamage*=6
    when 0xC0 # Fury Attack
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::SKILLLINK)
        basedamage*=5
      else
        if (pbOwnedByPlayer?(attacker.index))
          basedamage=(basedamage*11/3).floor
        else
          basedamage=(basedamage*19/6).floor
        end
      end
    when 0xC1 # Beat Up
      party=pbParty(attacker.index)
      participants=[]
      for i in 0...party.length
        participants.push(i) if party[i] && !party[i].isEgg? &&
                                 party[i].hp>0 && party[i].status==0 && !party[i].nil?
      end
      if participants.length>0
        atk=party[participants[0]].baseStats[1]
        participants[0]=nil; participants.compact!
        basedamage= 5+(atk/10)
        mult=0
        for i in 0...party.length
          mult+=1 if party[i] && !party[i].isEgg? &&
                      party[i].hp>0 && party[i].status==0
        end
        basedamage*=mult
        basedamage*=1.1
      else
        basedamage=basedamage
      end
    when 0xC4 # SolarBeam
      if pbWeather!=0 && pbWeather!=PBWeather::SUNNYDAY
        basedamage=(basedamage*0.5).floor
      end
    when 0xD0 # Whirlpool
      if skill>=PBTrainerAI.mediumSkill
        basedamage*=2 if PBMoveData.new(opponent.effects[PBEffects::TwoTurnAttack]).function==0xCB # Dive
      end
    when 0xD3 # Rollout
      if skill>=PBTrainerAI.mediumSkill
        basedamage*=2 if attacker.effects[PBEffects::DefenseCurl]
      end
    when 0xD4 # Bide
      maxdam=30
      if skill>=PBTrainerAI.highSkill
        if @aiMoveMemory[2][opponent.pokemonIndex].length>0
          for j in @aiMoveMemory[2][opponent.pokemonIndex]
            next if j.basedamage<=1
            tempdam = pbRoughDamage(j,opponent,attacker,skill,j.basedamage)*1.5
            if tempdam>maxdam
              maxdam=tempdam
            end
          end
        end
      elsif skill>=PBTrainerAI.averageSkill
        if @aiMoveMemory[1].length>0
          for j in @aiMoveMemory[1]
            next if j.basedamage<=1
            tempdam = pbRoughDamage(j,opponent,attacker,skill,j.basedamage)*1.5
            if tempdam>maxdam
              maxdam=tempdam
            end
          end
        end
      elsif skill>=PBTrainerAI.mediumSkill
        if @aiMoveMemory[0].length>0
          for j in @aiMoveMemory[0]
            next if j.basedamage<=1
            tempdam = pbRoughDamage(j,opponent,attacker,skill,j.basedamage)*1.5
            if tempdam>maxdam
              maxdam=tempdam
            end
          end
        end
      end
      basedamage = maxdam
    when 0xE1 # Final Gambit
      basedamage=attacker.hp
    when 0xF7 # Fling
      def flingarray
        return {
          130 => [:IRONBALL],
          100 => [:ARMORFOSSIL,:CLAWFOSSIL,:COVERFOSSIL,:DOMEFOSSIL,:HARDSTONE,
            :HELIXFOSSIL,:OLDAMBER,:PLUMEFOSSIL,:RAREBONE,:ROOTFOSSIL,
            :SKULLFOSSIL,:FOSSILIZEDBIRD,:FOSSILIZEDDINO,:FOSSILIZEDDRAKE,
            :FOSSILIZEDFISH,:ROOMSERVICE],
          90 => [:DEEPSEATOOTH,:DRACOPLATE,:DREADPLATE,:EARTHPLATE,:FISTPLATE,
            :FLAMEPLATE,:GRIPCLAW,:ICICLEPLATE,:INSECTPLATE,:IRONPLATE,
            :MEADOWPLATE,:MINDPLATE,:SKYPLATE,:SPLASHPLATE,:SPOOKYPLATE,
            :STONEPLATE,:THICKCLUB,:TOXICPLATE,:ZAPPLATE],
          80 => [:DAWNSTONE,:DUSKSTONE,:ELECTIRIZER,:MAGMARIZER,:ODDKEYSTONE,
            :OVALSTONE,:PROTECTOR,:QUICKCLAW,:RAZORCLAW,:SHINYSTONE,
            :STICKYBARB,:ASSAULTVEST,:CHIPPEDPOT,:CRACKEDPOT,
            :HEAVYDUTYBOOTS,:BLUNDERPOLICY],
          70 => [:BURNDRIVE,:CHILLDRIVE,:DOUSEDRIVE,:DRAGONFANG,:POISONBARB,
            :POWERANKLET,:POWERBAND,:POWERBELT,:POWERBRACER,:POWERLENS,
            :POWERWEIGHT,:SHOCKDRIVE],
          60 => [:ADAMANTORB,:DAMPROCK,:HEATROCK,:LUSTROUSORB,:MACHOBRACE,
            :ROCKYHELMET,:STICK,:AMPLIFIELDROCK,:ADRENALINEORB,
            :UTILITYUMBRELLA],
          50 => [:DUBIOUSDISC,:SHARPBEAK,:EJECTPACK],
          40 => [:EVIOLITE,:ICYROCK,:LUCKYPUNCH,:PROTECTIVEPADS],
          30 => [:ABILITYURGE,:ABSORBBULB,:AMULETCOIN,:ANTIDOTE,:AWAKENING,
            :BALMMUSHROOM,:BERRYJUICE,:BIGMUSHROOM,:BIGNUGGET,:BIGPEARL,
            :BINDINGBAND,:BLACKBELT,:BLACKFLUTE,:BLACKGLASSES,:BLACKSLUDGE,
            :BLUEFLUTE,:BLUESHARD,:BURNHEAL,:CALCIUM,:CARBOS,
            :CASTELIACONE,:CELLBATTERY,:CHARCOAL,:CLEANSETAG,:COMETSHARD,
            :DAMPMULCH,:DEEPSEASCALE,:DIREHIT,:DIREHIT2,:DIREHIT3,
            :DRAGONSCALE,:EJECTBUTTON,:ELIXIR,:ENERGYPOWDER,:ENERGYROOT,
            :ESCAPEROPE,:ETHER,:EVERSTONE,:EXPSHARE,:FIRESTONE,
            :FLAMEORB,:FLOATSTONE,:FLUFFYTAIL,:FRESHWATER,:FULLHEAL,
            :FULLRESTORE,:GOOEYMULCH,:GREENSHARD,:GROWTHMULCH,:GUARDSPEC,
            :HEALPOWDER,:HEARTSCALE,:HONEY,:HPUP,:HYPERPOTION,
            :ICEHEAL,:IRON,:ITEMDROP,:ITEMURGE,:KINGSROCK,
            :LAVACOOKIE,:LEAFSTONE,:LEMONADE,:LIFEORB,:LIGHTBALL,
            :LIGHTCLAY,:LUCKYEGG,:MAGNET,:MAXELIXIR,:MAXETHER,
            :MAXPOTION,:MAXREPEL,:MAXREVIVE,:METALCOAT,:METRONOME,
            :MIRACLESEED,:MOOMOOMILK,:MOONSTONE,:MYSTICWATER,:NEVERMELTICE,
            :NUGGET,:OLDGATEAU,:PARLYZHEAL,:PEARL,:PEARLSTRING,
            :POKEDOLL,:POKETOY,:POTION,:PPMAX,:PPUP,
            :PRISMSCALE,:PROTEIN,:RAGECANDYBAR,:RARECANDY,:RAZORFANG,
            :REDFLUTE,:REDSHARD,:RELICBAND,:RELICCOPPER,:RELICCROWN,
            :RELICGOLD,:RELICSILVER,:RELICSTATUE,:RELICVASE,:REPEL,
            :RESETURGE,:REVIVALHERB,:REVIVE,:SACREDASH,:SCOPELENS,
            :SHELLBELL,:SHOALSALT,:SHOALSHELL,:SMOKEBALL,:SODAPOP,
            :SOULDEW,:SPELLTAG,:STABLEMULCH,:STARDUST,:STARPIECE,
            :SUNSTONE,:SUPERPOTION,:SUPERREPEL,:SWEETHEART,:THUNDERSTONE,
            :TINYMUSHROOM,:TOXICORB,:TWISTEDSPOON,:UPGRADE,:WATERSTONE,
            :WHITEFLUTE,:XACCURACY,:XACCURACY2,:XACCURACY3,:XACCURACY6,
            :XATTACK,:XATTACK2,:XATTACK3,:XATTACK6,:XDEFEND,
            :XDEFEND2,:XDEFEND3,:XDEFEND6,:XSPDEF,:XSPDEF2,
            :XSPDEF3,:XSPDEF6,:XSPECIAL,:XSPECIAL2,:XSPECIAL3,
            :XSPECIAL6,:XSPEED,:XSPEED2,:XSPEED3,:XSPEED6,
            :YELLOWFLUTE,:YELLOWSHARD,:ZINC,:BIGMALASADA,:ICESTONE,
            :SWEETAPPLE,:TARTAPPLE,:THROATSPRAY,:EXPCANDYXS,
            :EXPCANDYS,:EXPCANDYM,:EXPCANDYL,:EXPCANDYXL],
          20 => [:CLEVERWING,:GENIUSWING,:HEALTHWING,:MUSCLEWING,:PRETTYWING,
            :RESISTWING,:SWIFTWING],
          10 => [:AIRBALLOON,:BIGROOT,:BLUESCARF,:BRIGHTPOWDER,:CHOICEBAND,
            :CHOICESCARF,:CHOICESPECS,:DESTINYKNOT,:EXPERTBELT,:FOCUSBAND,
            :FOCUSSASH,:FULLINCENSE,:GREENSCARF,:LAGGINGTAIL,:LAXINCENSE,
            :LEFTOVERS,:LUCKINCENSE,:MENTALHERB,:METALPOWDER,:MUSCLEBAND,
            :ODDINCENSE,:PINKSCARF,:POWERHERB,:PUREINCENSE,:QUICKPOWDER,
            :REAPERCLOTH,:REDCARD,:REDSCARF,:RINGTARGET,:ROCKINCENSE,
            :ROSEINCENSE,:SEAINCENSE,:SHEDSHELL,:SILKSCARF,:SILVERPOWDER,
            :SMOOTHROCK,:SOFTSAND,:SOOTHEBELL,:WAVEINCENSE,:WHITEHERB,
            :WIDELENS,:WISEGLASSES,:YELLOWSCARF,:ZOOMLENS,:BLUEMIC,
            :VANILLAIC,:STRAWBIC,:CHOCOLATIC,:ADAMANTMINT,:LONELYMINT,
            :NAUGHTYMINT,:BRAVEMINT,:BOLDMINT,:IMPISHMINT,:LAXMINT,
            :RELAXEDMINT,:MODESTMINT,:MILDMINT,:RASHMINT,:QUIETMINT,
            :CALMMINT,:GENTLEMINT,:CAREFULMINT,:SASSYMINT,:TIMIDMINT,
            :HASTYMINT,:JOLLYMINT,:NAIVEMINT,:SERIOUSMINT]
        }
      end
      if attacker.item==0
        basedamage=0
      else
        basedamage=10 if pbIsBerry?(attacker.item)
        for i in flingarray.keys
          data=flingarray[i]
          if data
            for j in data
              basedamage = i if isConst?(attacker.item,PBItems,j)
            end
          end
        end
      end
    when 0x113 # Spit Up
      basedamage = 100*attacker.effects[PBEffects::Stockpile]
    when 0x171 # Stomping Tantrum
      if attacker.effects[PBEffects::Tantrum]
        basedamage*=2
      end
    when 0x17E # Dragon Darts
      if !@doublebattle
        basedamage*=2
      end
    when 0x203 # Fever Pitch
      if !($game_variables[200] == 2)
        basedamage=50  if $game_variables[115] >= 50
        basedamage=70  if $game_variables[115] >= 100
        basedamage=100 if $game_variables[115] >= 300
        basedamage=130 if $game_variables[115] >= 325
      else
        basedamage=130
      end
    when 0x207 # Thunder Raid
      basedamage*=5
    when 0x212 # Bunraku Beatdown
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::WORLDOFNIGHTMARES)
        basedamage=(15*opponent.pbFaintedPokemonCount)
      else
        basedamage+=(15*attacker.pbFaintedPokemonCount)
      end
    when 0x215 # Gilded Arrow/s
      if move.id == PBMoves::GILDEDARROWS
        basedamage*=2
      end
    end
    return basedamage
  end
  
  def pbStatusDamage(move)
    if (move.id == PBMoves::AFTERYOU || move.id == PBMoves::BESTOW ||
        move.id == PBMoves::CRAFTYSHIELD || move.id == PBMoves::LUCKYCHANT ||
        move.id == PBMoves::SPLASH || move.id == PBMoves::SWEETSCENT ||
        move.id == PBMoves::SHADOWMIST ||
        move.id == PBMoves::TELEKINESIS || move.id == PBMoves::TELEPORT)
      return 0
    elsif (move.id == PBMoves::ALLYSWITCH || move.id == PBMoves::AROMATICMIST ||
        move.id == PBMoves::ENTRAINMENT || move.id == PBMoves::FORESIGHT ||
        move.id == PBMoves::GUARDSWAP || move.id == PBMoves::HEALBLOCK ||
        move.id == PBMoves::IMPRISON || move.id == PBMoves::INSTRUCT ||
        move.id == PBMoves::FAIRYLOCK || move.id == PBMoves::LASERFOCUS ||
        move.id == PBMoves::HELPINGHAND || move.id == PBMoves::MAGICROOM ||
        move.id == PBMoves::LOCKON || move.id == PBMoves::MINDREADER ||
        move.id == PBMoves::MIRACLEEYE || move.id == PBMoves::MUDSPORT ||
        move.id == PBMoves::ODORSLEUTH ||
        move.id == PBMoves::POWERSPLIT || 
        move.id == PBMoves::GRUDGE || move.id == PBMoves::GUARDSPLIT ||
        move.id == PBMoves::POWERTRICK || move.id == PBMoves::QUICKGUARD ||
        move.id == PBMoves::RECYCLE ||
        move.id == PBMoves::ROTOTILLER || move.id == PBMoves::SANDATTACK ||
        move.id == PBMoves::SNATCH ||
        move.id == PBMoves::MAGICCOAT || 
        move.id == PBMoves::SPOTLIGHT || move.id == PBMoves::TEETERDANCE || 
        move.id == PBMoves::WATERSPORT)
      return 5
    elsif (move.id == PBMoves::ACUPRESSURE || move.id == PBMoves::CAMOUFLAGE ||
        move.id == PBMoves::CHARM || move.id == PBMoves::CONFIDE ||
        move.id == PBMoves::DEFENSECURL || move.id == PBMoves::EMBARGO || 
        move.id == PBMoves::GROWL || move.id == PBMoves::HARDEN ||
        move.id == PBMoves::HOWL || move.id == PBMoves::KINESIS || 
        move.id == PBMoves::LEER || move.id == PBMoves::FLASH ||
        move.id == PBMoves::METALSOUND || move.id == PBMoves::NOBLEROAR ||
        move.id == PBMoves::PLAYNICE || move.id == PBMoves::POWDER ||
        move.id == PBMoves::DEFOG ||  
        move.id == PBMoves::PSYCHUP || move.id == PBMoves::SHARPEN ||
        move.id == PBMoves::SMOKESCREEN || move.id == PBMoves::STRINGSHOT ||
        move.id == PBMoves::SUPERSONIC || move.id == PBMoves::TAILWHIP ||
        move.id == PBMoves::TEARFULLOOK ||
        move.id == PBMoves::WITHDRAW)
      return 10
    elsif (move.id == PBMoves::ASSIST  || 
        move.id == PBMoves::BABYDOLLEYES || move.id == PBMoves::CELEBRATE || 
        move.id == PBMoves::CAPTIVATE || move.id == PBMoves::COTTONSPORE ||
        move.id == PBMoves::DARKVOID ||   
        move.id == PBMoves::DOUBLETEAM || move.id == PBMoves::EERIEIMPULSE ||
        move.id == PBMoves::FAKETEARS || move.id == PBMoves::FEATHERDANCE ||
        move.id == PBMoves::FLORALHEALING || move.id == PBMoves::HOLDHANDS || 
        move.id == PBMoves::HAPPYHOUR || move.id == PBMoves::HEALINGWISH ||
        move.id == PBMoves::HEALPULSE || move.id == PBMoves::INGRAIN ||
        move.id == PBMoves::QUASH || move.id == PBMoves::SAFEGUARD ||
        move.id == PBMoves::LUNARDANCE || move.id == PBMoves::MEFIRST ||
        move.id == PBMoves::MEDITATE || move.id == PBMoves::MIMIC ||
        move.id == PBMoves::MEMENTO ||  move.id == PBMoves::NIGHTMARE || 
        move.id == PBMoves::POISONPOWDER || move.id == PBMoves::REFRESH ||
        move.id == PBMoves::ROLEPLAY || move.id == PBMoves::SCARYFACE ||
        move.id == PBMoves::ENDURE ||
        move.id == PBMoves::SCREECH || move.id == PBMoves::SPITE ||
        move.id == PBMoves::SHADOWDOWN || move.id == PBMoves::CONVERSION && (!move.zmove) || 
        move.id == PBMoves::SKETCH || move.id == PBMoves::SKILLSWAP || 
        move.id == PBMoves::TICKLE || move.id == PBMoves::CHARGE ||
        move.id == PBMoves::TRICKORTREAT || move.id == PBMoves::VENOMDRENCH ||
        move.id == PBMoves::GEARUP || move.id == PBMoves::MAGNETICFLUX)
      return 15
    elsif (move.id == PBMoves::AQUARING || move.id == PBMoves::BLOCK ||
        move.id == PBMoves::REFLECTTYPE || move.id == PBMoves::WISH ||
        move.id == PBMoves::CONVERSION2 || move.id == PBMoves::ELECTRIFY ||
        move.id == PBMoves::FLATTER || move.id == PBMoves::GASTROACID ||
        move.id == PBMoves::HEARTSWAP || move.id == PBMoves::IONDELUGE ||
        move.id == PBMoves::HAZE || move.id == PBMoves::WORKUP ||
        move.id == PBMoves::GROWTH || move.id == PBMoves::TORMENT ||
        move.id == PBMoves::PARTINGSHOT || move.id == PBMoves::POWERSWAP ||
        move.id == PBMoves::SPEEDSWAP ||
        move.id == PBMoves::MEANLOOK || move.id == PBMoves::STUFFCHEEKS || 
        move.id == PBMoves::TEATIME || move.id == PBMoves::OCTOLOCK ||
        move.id == PBMoves::METRONOME || move.id == PBMoves::COPYCAT ||
        move.id == PBMoves::MIRRORMOVE || move.id == PBMoves::MIST ||
        move.id == PBMoves::PERISHSONG || move.id == PBMoves::REST ||
        move.id == PBMoves::ROAR || move.id == PBMoves::SIMPLEBEAM ||
        move.id == PBMoves::SPIDERWEB || move.id == PBMoves::FLOWERSHIELD ||
        move.id == PBMoves::SWAGGER || move.id == PBMoves::SWEETKISS ||
        move.id == PBMoves::POISONGAS || move.id == PBMoves::TOXICTHREAD ||
        move.id == PBMoves::TRANSFORM || move.id == PBMoves::WHIRLWIND ||
        move.id == PBMoves::WORRYSEED || move.id == PBMoves::YAWN)
      return 20
    elsif (move.id == PBMoves::AMNESIA || move.id == PBMoves::ATTRACT ||
        move.id == PBMoves::ACIDARMOR ||  move.id == PBMoves::BARRIER ||
        move.id == PBMoves::BELLYDRUM || move.id == PBMoves::COSMICPOWER ||
        move.id == PBMoves::CONFUSERAY || move.id == PBMoves::DESTINYBOND ||
        move.id == PBMoves::DISABLE || move.id == PBMoves::DECORATE ||
        move.id == PBMoves::FORESTSCURSE || move.id == PBMoves::AGILITY ||
        move.id == PBMoves::MAGNETRISE || move.id == PBMoves::SPIKYSHIELD || 
        move.id == PBMoves::COTTONGUARD || move.id == PBMoves::DEFENDORDER ||
        move.id == PBMoves::FOCUSENERGY || move.id == PBMoves::GRASSWHISTLE || 
        move.id == PBMoves::SING || move.id == PBMoves::HYPNOSIS ||
        move.id == PBMoves::FOLLOWME || move.id == PBMoves::AUTOTOMIZE ||
        move.id == PBMoves::IRONDEFENSE || move.id == PBMoves::MINIMIZE ||
        move.id == PBMoves::PSYCHOSHIFT || move.id == PBMoves::GRAVITY ||
        move.id == PBMoves::RAGEPOWDER || move.id == PBMoves::ROCKPOLISH ||
        move.id == PBMoves::STOCKPILE || move.id == PBMoves::SUBSTITUTE ||
        move.id == PBMoves::SHADOWHALF || move.id == PBMoves::SHADOWPANIC ||
        move.id == PBMoves::SHADOWSHED || move.id == PBMoves::STUNSPORE ||
        move.id == PBMoves::SWITCHEROO ||  move.id == PBMoves::SWALLOW ||
        move.id == PBMoves::TAUNT || move.id == PBMoves::TOPSYTURVY ||
        move.id == PBMoves::TRICK)
      return 25
    elsif (move.id == PBMoves::BATONPASS || move.id == PBMoves::BULKUP ||
        move.id == PBMoves::CALMMIND || move.id == PBMoves::COIL ||
        move.id == PBMoves::CURSE || move.id == PBMoves::ELECTRICTERRAIN ||
        move.id == PBMoves::ENCORE || move.id == PBMoves::SOAK ||
        move.id == PBMoves::MAGICPOWDER || move.id == PBMoves::LIFEDEW || 
        move.id == PBMoves::LEECHSEED || move.id == PBMoves::MORNINGSUN ||
        move.id == PBMoves::PAINSPLIT || move.id == PBMoves::MILKDRINK ||
        move.id == PBMoves::SHOREUP || move.id == PBMoves::SLACKOFF ||
        move.id == PBMoves::ROOST || move.id == PBMoves::RECOVER ||
        move.id == PBMoves::SYNTHESIS || move.id == PBMoves::THUNDERWAVE ||
        move.id == PBMoves::PROTECT || move.id == PBMoves::DETECT ||
        move.id == PBMoves::HEALORDER || move.id == PBMoves::MOONLIGHT ||
        move.id == PBMoves::SOFTBOILED || move.id == PBMoves::STRENGTHSAP ||
        move.id == PBMoves::GRASSYTERRAIN || move.id == PBMoves::MISTYTERRAIN ||
        move.id == PBMoves::NATUREPOWER || move.id == PBMoves::PSYCHICTERRAIN ||
        move.id == PBMoves::PURIFY || move.id == PBMoves::SLEEPTALK ||
        move.id == PBMoves::SANDSTORM || move.id == PBMoves::HAIL ||
        move.id == PBMoves::TOXICSPIKES || move.id == PBMoves::SPIKES ||
        move.id == PBMoves::SUNNYDAY || move.id == PBMoves::RAINDANCE ||
        move.id == PBMoves::SHADOWSKY || move.id == PBMoves::TRICKROOM || 
        move.id == PBMoves::WONDERROOM)
      return 30
    elsif (move.id == PBMoves::AROMATHERAPY || move.id == PBMoves::BANEFULBUNKER ||
        move.id == PBMoves::HEALBELL || move.id == PBMoves::LOVELYKISS ||
        move.id == PBMoves::LIGHTSCREEN || move.id == PBMoves::MATBLOCK ||
        move.id == PBMoves::ARENITEWALL || move.id == PBMoves::STEALTHROCK ||
        move.id == PBMoves::NASTYPLOT || move.id == PBMoves::REFLECT ||
        move.id == PBMoves::TAILWIND || move.id == PBMoves::WILLOWISP || 
        move.id == PBMoves::TOXIC || move.id == PBMoves::GLARE ||
        move.id == PBMoves::DESERTSMARK || move.id == PBMoves::COURTCHANGE ||
        move.id == PBMoves::KINGSSHIELD || PBMoves::EXTREMEEVOBOOST ||
        move.id == PBMoves::OBSTRUCT || move.id == PBMoves::TARSHOT ||
        move.id == PBMoves::WIDEGUARD ||
        move.id == PBMoves::HONECLAWS || move.id == PBMoves::SLEEPPOWDER ||
        move.id == PBMoves::SWORDSDANCE || move.id == PBMoves::TAILGLOW)
      return 35
    elsif (move.id == PBMoves::DRAGONDANCE || move.id == PBMoves::GEOMANCY ||
        move.id == PBMoves::AQUABATICS || move.id == PBMoves::CONVERSION && (move.zmove) ||
        move.id == PBMoves::QUIVERDANCE || move.id == PBMoves::SHELLSMASH ||
        move.id == PBMoves::SHIFTGEAR || move.id == PBMoves::NORETREAT || 
        move.id == PBMoves::CLANGOROUSSOUL)
      return 40
    elsif (move.id == PBMoves::AURORAVEIL || move.id == PBMoves::STICKYWEB ||
        move.id == PBMoves::SPORE)
      return 60
    end
  end
  
  def pbAegislashStats(aegi)
    if aegi.form==1
      shieldcheck = aegi.clone
      shieldcheck.stages = aegi.stages.clone
      shieldcheck.form = 0
      shieldcheck.pbUpdate(true)
      if ($fefieldeffect==5 || $fefieldeffect==31) && shieldcheck.stages[PBStats::DEFENSE]<6
        shieldcheck.stages[PBStats::DEFENSE] += 1
      end
      return shieldcheck
    else
      bladecheck = aegi.clone
      bladecheck.stages = aegi.stages.clone
      bladecheck.form = 1
      bladecheck.pbUpdate(true)
      if ($fefieldeffect==5 || $fefieldeffect==31) && bladecheck.stages[PBStats::ATTACK]<6
        bladecheck.stages[PBStats::ATTACK] += 1
      end
      return bladecheck
    end
  end

  
  def pbChangeMove(move,attacker)
    move = PokeBattle_Move.pbFromPBMove(self,PBMove.new(move.id),attacker)
    case move.id
    when PBMoves::WEATHERBALL
      weather=pbWeather
      move.type=getConst(PBTypes,:NORMAL)
      move.type=(getConst(PBTypes,:FIRE) ) if (weather==PBWeather::SUNNYDAY)
      move.type=(getConst(PBTypes,:WATER)) if (weather==PBWeather::RAINDANCE)
      move.type=(getConst(PBTypes,:ROCK) ) if weather==PBWeather::SANDSTORM
      move.type=(getConst(PBTypes,:ICE)  ) if weather==PBWeather::HAIL
      move.type=(getConst(PBTypes,:SHADOW)  ) if weather==PBWeather::SHADOWSKY
      move.type=(getConst(PBTypes,:FLYING)) if (weather==PBWeather::STRONGWINDS || $fefieldeffect==43)
      if pbWeather !=0 || $fefieldeffect==9 || $fefieldeffect==43
        move.basedamage*=2 if move.basedamage == 50
      end
    when PBMoves::JUDGMENT, PBMoves::MULTIATTACK,PBMoves::TECHNOBLAST
      if attacker
        move.type = move.pbType(move.type,attacker,nil)
      end
    when PBMoves::HIDDENPOWER
      if attacker
        move.type = move.pbType(move.type,attacker,nil)
      end
    when PBMoves::GILDEDARROW, PBMoves::GILDEDARROWS
      if !(attacker.nil?)
        if (attacker.type1!=attacker.type2) && (attacker.type2!=PBTypes::FAIRY && attacker.type2!=PBTypes::DARK)
          move.type=attacker.type2
        else
          move.type=attacker.type1
        end
      end
    when PBMoves::REVELATIONDANCE
      if !(attacker.nil?)
        move.type=attacker.type1
      end
    when PBMoves::NATUREPOWER
      newmove=0
      case $fefieldeffect
      when 1
        newmove=getConst(PBMoves,:THUNDERBOLT) || 0
      when 2
        newmove=getConst(PBMoves,:ENERGYBALL) || 0
      when 3
        newmove=getConst(PBMoves,:MISTBALL) || 0
      when 4
        newmove=getConst(PBMoves,:DARKPULSE) || 0
      when 5
        newmove=getConst(PBMoves,:ANCIENTPOWER) || 0
      when 6
        newmove=getConst(PBMoves,:ACROBATICS) || 0
      when 7
        newmove=getConst(PBMoves,:FLAMETHROWER) || 0
      when 8
        newmove=getConst(PBMoves,:MUDDYWATER) || 0
      when 9
        newmove=getConst(PBMoves,:AURORABEAM) || 0
      when 10
        newmove=getConst(PBMoves,:ACID) || 0
      when 11
        newmove=getConst(PBMoves,:ACIDSPRAY) || 0
      when 12
        newmove=getConst(PBMoves,:SANDTOMB) || 0
      when 13
        newmove=getConst(PBMoves,:ICEBEAM) || 0
      when 14
        newmove=getConst(PBMoves,:ROCKSMASH) || 0
      when 15
        newmove=getConst(PBMoves,:WOODHAMMER) || 0
      when 16
        newmove=getConst(PBMoves,:HEATWAVE) || 0
      when 17
        newmove=getConst(PBMoves,:GEARGRIND) || 0
      when 18
        newmove=getConst(PBMoves,:DISCHARGE) || 0
      when 19
        newmove=getConst(PBMoves,:GUNKSHOT) || 0
      when 20
        newmove=getConst(PBMoves,:MEDITATE) || 0
      when 21
        newmove=getConst(PBMoves,:WHIRLPOOL) || 0
      when 22
        newmove=getConst(PBMoves,:WATERPULSE) || 0
      when 23
        newmove=getConst(PBMoves,:ROCKTOMB) || 0
      when 24
        newmove=getConst(PBMoves,:METRONOME) || 0
      when 25
        newmove=getConst(PBMoves,:POWERGEM) || 0
      when 26
        newmove=getConst(PBMoves,:SLUDGEWAVE) || 0
      when 27
        newmove=getConst(PBMoves,:ROCKSLIDE) || 0
      when 28
        newmove=getConst(PBMoves,:AVALANCHE) || 0
      when 29
        newmove=getConst(PBMoves,:JUDGMENT) || 0
      when 30
        newmove=getConst(PBMoves,:MIRRORSHOT) || 0
      when 31
        newmove=getConst(PBMoves,:SECRETSWORD) || 0
      when 32
        newmove=getConst(PBMoves,:DRAGONPULSE) || 0
      when 33
        if $fecounter == 4
          newmove=getConst(PBMoves,:PETALBLIZZARD) || 0
        else
          newmove=getConst(PBMoves,:GROWTH) || 0
        end
      when 34
        newmove=getConst(PBMoves,:MOONBLAST) || 0
      when 35
        newmove=getConst(PBMoves,:SPACIALREND) || 0
      when 36
        newmove=getConst(PBMoves,:TRICKROOM) || 0
      when 37
        newmove=getConst(PBMoves,:PSYCHIC) || 0
      when 38
        newmove=getConst(PBMoves,:DARKPULSE) || 0
      when 39
        newmove=getConst(PBMoves,:ICEBEAM) || 0
      when 40
        newmove=getConst(PBMoves,:PHANTOMFORCE) || 0
      when 41
        newmove=getConst(PBMoves,:GUNKSHOT) || 0
      when 42
        newmove=getConst(PBMoves,:DAZZLINGGLEAM) || 0
      when 43
        newmove=getConst(PBMoves,:SKYATTACK) || 0
      else
        newmove=getConst(PBMoves,:TRIATTACK) || 0 
      end
      move = PokeBattle_Move.pbFromPBMove(self,PBMove.new(newmove),attacker)
    end
    return move
  end
  
  def pbRoughDamage(move,attacker,opponent,skill,basedamage,hardswitch=false)
    if (opponent.species==0 || attacker.species==0)
      return 0
    end
    if move != attacker.moves[4] && !(move.zmove)
      move = pbChangeMove(move,attacker) 
    end
    basedamage = move.basedamage
    if move.basedamage==0
      return 0
    end
    oldmold=opponent.moldbroken
    if (!attacker.abilitynulled && (attacker.ability == PBAbilities::MOLDBREAKER || attacker.ability == PBAbilities::TURBOBLAZE || attacker.ability == PBAbilities::TERAVOLT || attacker.ability == PBAbilities::SHADOWTAG && $fefieldeffect==40))   
      opponent.moldbroken = true
    end
    # Technician
    if skill>=PBTrainerAI.mediumSkill
      if ((!attacker.abilitynulled && attacker.ability == PBAbilities::TECHNICIAN) || (isConst?(attacker.species,PBSpecies,:DUSKNOIR) && isConst?(attacker.item,PBItems,:DUSKCREST))) &&
        (((basedamage<=60)) || ($fefieldeffect == 17 && basedamage<=80))
        basedamage=(basedamage*1.5).round
       end
    end
    if skill>=PBTrainerAI.averageSkill
      basedamage = pbBetterBaseDamage(move,attacker,opponent,skill,basedamage)
    end
    # Fixed damage moves
    if move.function==0x6A ||   # SonicBoom
      move.function==0x6B ||   # Dragon Rage
      move.function==0x6C ||   # Super Fang
      move.function==0x6D ||   # Night Shade
      move.function==0x6E ||   # Endeavor
      move.function==0x6F ||   # Psywave
      move.function==0x70 ||   # OHKO
      move.function==0x71 ||   # Counter
      move.function==0x72 ||   # Mirror Coat
      move.function==0x73 ||   # Metal Burst
      move.function==0xD4 ||   # Bide
      move.function==0xE1      # Final Gambit
      type=move.type
      type=move.pbType(type,attacker,opponent)
      typemod=pbTypeModNoMessages(type,attacker,opponent,move,skill)
      if typemod==0
        basedamage*=0
      end
      return basedamage
    end
    type=move.type
    # Type Boosting abilities - Moved later to match pbCalcDamage
    # More accurate move type (includes Normalize, most type-changing moves, etc.)
    if skill>=PBTrainerAI.minimumSkill
      type=move.pbType(type,attacker,opponent)
    end
    if attacker.species == PBSpecies::CINCCINO && attacker.hasWorkingItem(:CINCCREST) && !move.pbIsMultiHit
      basedamage=(basedamage*0.3).round
    end
    if (attacker.species == PBSpecies::CINCCINO && attacker.hasWorkingItem(:CINCCREST) && !move.pbIsMultiHit)
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::SKILLLINK)
        basedamage*=5
      else
        basedamage=(basedamage*19/6).floor
      end
    end
    # Iron Fist
    if skill>=PBTrainerAI.mediumSkill
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::IRONFIST) && move.isPunchingMove?
        basedamage=(basedamage*1.2).round
      end
    end
    # Ledian Crest
    if skill>=PBTrainerAI.mediumSkill
      if isConst?(attacker.species,PBSpecies,:LEDIAN) && attacker.hasWorkingItem(:LEDICREST) &&
        move.isPunchingMove?
        basedamage=(basedamage*4.0).round
      end
    end
    # Strong Jaw
    if skill>=PBTrainerAI.mediumSkill
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::STRONGJAW) || SilvallyCheck(attacker,PBTypes::DARK)
        if (move.id == PBMoves::BITE || move.id == PBMoves::CRUNCH ||
            move.id == PBMoves::THUNDERFANG || move.id == PBMoves::FIREFANG ||
            move.id == PBMoves::ICEFANG || move.id == PBMoves::POISONFANG ||
            move.id == PBMoves::HYPERFANG || move.id == PBMoves::PSYCHICFANGS ||
            move.id == PBMoves::JAWLOCK || move.id == PBMoves::FISHIOUSREND)
          basedamage=(basedamage*1.5).round
        end
      end
    end
    # Feraligatr Crest
    if skill>=PBTrainerAI.mediumSkill
      if isConst?(attacker.species,PBSpecies,:FERALIGATR) && attacker.hasWorkingItem(:FERACREST)
        if (move.id == PBMoves::BITE || move.id == PBMoves::CRUNCH ||
            move.id == PBMoves::THUNDERFANG || move.id == PBMoves::FIREFANG ||
            move.id == PBMoves::ICEFANG || move.id == PBMoves::POISONFANG ||
            move.id == PBMoves::HYPERFANG || move.id == PBMoves::PSYCHICFANGS ||
            move.id == PBMoves::JAWLOCK || move.id == PBMoves::FISHIOUSREND)
          basedamage=(basedamage*1.5).round
        end
      end
    end
    # Boltund Crest
    if skill>=PBTrainerAI.mediumSkill
      if isConst?(attacker.species,PBSpecies,:BOLTUND) && attacker.hasWorkingItem(:BOLTCREST) && ((attacker.pbSpeed>opponent.pbSpeed) ^ (@trickroom!=0))
        if (move.id == PBMoves::BITE || move.id == PBMoves::CRUNCH ||
            move.id == PBMoves::THUNDERFANG || move.id == PBMoves::FIREFANG ||
            move.id == PBMoves::ICEFANG || move.id == PBMoves::POISONFANG ||
            move.id == PBMoves::HYPERFANG || move.id == PBMoves::PSYCHICFANGS ||
            move.id == PBMoves::JAWLOCK || move.id == PBMoves::FISHIOUSREND)
          basedamage=(basedamage*1.5).round
        end
      end
    end
    # Claydol Crest
    if skill>=PBTrainerAI.mediumSkill
      if isConst?(attacker.species,PBSpecies,:CLAYDOL) && attacker.hasWorkingItem(:CLAYCREST) &&
        move.isBeamMove?
        basedamage=(basedamage*1.5).round
      end
    end
    # Druddigon Crest
    if skill>=PBTrainerAI.mediumSkill
      if isConst?(attacker.species,PBSpecies,:DRUDDIGON) && attacker.hasWorkingItem(:DRUDDICREST) && (isConst?(type,PBTypes,:DRAGON) || isConst?(type,PBTypes,:FIRE))
        basedamage=(basedamage*1.3).round
      end
    end
    # Typh Crest
    if skill>=PBTrainerAI.mediumSkill
      if isConst?(attacker.species,PBSpecies,:TYPHLOSION) && attacker.hasWorkingItem(:TYPHCREST) && move.isContactMove?
        basedamage=(basedamage*1.3).round
      end
    end
    # Tough Claws
    if skill>=PBTrainerAI.mediumSkill
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::TOUGHCLAWS) && move.isContactMove?
        basedamage=(basedamage*1.3).round
      end
    end
    # Reckless
    if skill>=PBTrainerAI.mediumSkill
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::RECKLESS)
        if (move.function==0xFA ||  # Take Down, etc.
          move.function==0xFB ||  # Double-Edge, etc.
          move.function==0xFC ||  # Head Smash
          move.function==0xFD ||  # Volt Tackle
          move.function==0xFE ||  # Flare Blitz
          move.function==0x10B || # Jump Kick, Hi Jump Kick
          move.function==0x130)    # Shadow End
          basedamage=(basedamage*1.2).round
        end
      end
    end
    # Flare Boost
    if skill>=PBTrainerAI.mediumSkill
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::FLAREBOOST) &&
        (attacker.status==PBStatuses::BURN || $fefieldeffect == 7) &&
        move.pbIsSpecial?(type)
        basedamage=(basedamage*1.5).round
      end
    end
    # Toxic Boost
    if skill>=PBTrainerAI.mediumSkill
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::TOXICBOOST) &&
        (attacker.status==PBStatuses::POISON ||
          $fefieldeffect == 10 || $fefieldeffect == 11 ||
          $fefieldeffect == 19 || $fefieldeffect == 26) && move.pbIsPhysical?(type)
        basedamage=(basedamage*1.5).round
      end
    end
    # Analytic
    if skill>=PBTrainerAI.mediumSkill
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::ANALYTIC) && (opponent.hasMovedThisRound?) #|| hardswitch)
        basedamage = (basedamage*1.3).round
      end
    end
    # Rivalry
    if skill>=PBTrainerAI.mediumSkill
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::RIVALRY) &&
        attacker.gender!=2 && opponent.gender!=2
        if attacker.gender==opponent.gender
          basedamage=(basedamage*1.25).round
        else
          basedamage=(basedamage*0.75).round
        end
      end
    end
    # Sand Force
    if skill>=PBTrainerAI.mediumSkill
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::SANDFORCE) &&
        pbWeather==PBWeather::SANDSTORM &&
        (isConst?(type,PBTypes,:ROCK) ||
          isConst?(type,PBTypes,:GROUND) ||
          isConst?(type,PBTypes,:STEEL))
        basedamage=(basedamage*1.3).round
      end
    end
    # Solar Idol
    if skill>=PBTrainerAI.mediumSkill
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::SOLARIDOL)  &&
        (isConst?(type,PBTypes,:FIRE))
        basedamage=(basedamage*1.5).round
      end
    end
    # Solar Idol
    if skill>=PBTrainerAI.mediumSkill
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::LUNARIDOL)  &&
        (isConst?(type,PBTypes,:ICE))
        basedamage=(basedamage*1.5).round
      end
    end
    # Heatproof
    if skill>=PBTrainerAI.mediumSkill
      if ((!opponent.abilitynulled && opponent.ability == PBAbilities::HEATPROOF) || SilvallyCheck(opponent,PBTypes::STEEL)) &&
        isConst?(type,PBTypes,:FIRE)
        basedamage=(basedamage*0.5).round
      end
    end
    # Dry Skin
    if skill>=PBTrainerAI.mediumSkill
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::DRYSKIN) &&
        isConst?(type,PBTypes,:FIRE)
        basedamage=(basedamage*1.25).round
      end
    end
    # Sheer Force
    if skill>=PBTrainerAI.mediumSkill
      if ((!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) || SilvallyCheck(attacker,PBTypes::GROUND)) && move.addlEffect>0
        basedamage=(basedamage*1.3).round
      end
    end
    # Type-boosting items
    if skill>=PBTrainerAI.mediumSkill
      if (attacker.hasWorkingItem(:SILKSCARF) && isConst?(type,PBTypes,:NORMAL)) ||
        (attacker.hasWorkingItem(:BLACKBELT) && isConst?(type,PBTypes,:FIGHTING)) ||
        (attacker.hasWorkingItem(:SHARPBEAK) && isConst?(type,PBTypes,:FLYING)) ||
        (attacker.hasWorkingItem(:POISONBARB) && isConst?(type,PBTypes,:POISON)) ||
        (attacker.hasWorkingItem(:SOFTSAND) && isConst?(type,PBTypes,:GROUND)) ||
        (attacker.hasWorkingItem(:HARDSTONE) && isConst?(type,PBTypes,:ROCK)) ||
        (attacker.hasWorkingItem(:SILVERPOWDER) && isConst?(type,PBTypes,:BUG)) ||
        (attacker.hasWorkingItem(:SPELLTAG) && isConst?(type,PBTypes,:GHOST)) ||
        (attacker.hasWorkingItem(:METALCOAT) && isConst?(type,PBTypes,:STEEL)) ||
        (attacker.hasWorkingItem(:CHARCOAL) && isConst?(type,PBTypes,:FIRE)) ||
        (attacker.hasWorkingItem(:MYSTICWATER) && isConst?(type,PBTypes,:WATER)) ||
        (attacker.hasWorkingItem(:MIRACLESEED) && isConst?(type,PBTypes,:GRASS)) ||
        (attacker.hasWorkingItem(:MAGNET) && isConst?(type,PBTypes,:ELECTRIC)) ||
        (attacker.hasWorkingItem(:TWISTEDSPOON) && isConst?(type,PBTypes,:PSYCHIC)) ||
        (attacker.hasWorkingItem(:NEVERMELTICE) && isConst?(type,PBTypes,:ICE)) ||
        (attacker.hasWorkingItem(:DRAGONFANG) && isConst?(type,PBTypes,:DRAGON)) ||
        (attacker.hasWorkingItem(:BLACKGLASSES) && isConst?(type,PBTypes,:DARK))
        basedamage=(basedamage*1.2).round
      end
      if (attacker.hasWorkingItem(:FISTPLATE) && isConst?(type,PBTypes,:FIGHTING)) ||
        (attacker.hasWorkingItem(:SKYPLATE) && isConst?(type,PBTypes,:FLYING)) ||
        (attacker.hasWorkingItem(:TOXICPLATE) && isConst?(type,PBTypes,:POISON)) ||
        (attacker.hasWorkingItem(:EARTHPLATE) && isConst?(type,PBTypes,:GROUND)) ||
        (attacker.hasWorkingItem(:STONEPLATE) && isConst?(type,PBTypes,:ROCK)) ||
        (attacker.hasWorkingItem(:INSECTPLATE) && isConst?(type,PBTypes,:BUG)) ||
        (attacker.hasWorkingItem(:SPOOKYPLATE) && isConst?(type,PBTypes,:GHOST)) ||
        (attacker.hasWorkingItem(:IRONPLATE) && isConst?(type,PBTypes,:STEEL)) ||
        (attacker.hasWorkingItem(:FLAMEPLATE) && isConst?(type,PBTypes,:FIRE)) ||
        (attacker.hasWorkingItem(:SPLASHPLATE) && isConst?(type,PBTypes,:WATER)) ||
        (attacker.hasWorkingItem(:MEADOWPLATE) && isConst?(type,PBTypes,:GRASS)) ||
        (attacker.hasWorkingItem(:ZAPPLATE) && isConst?(type,PBTypes,:ELECTRIC)) ||
        (attacker.hasWorkingItem(:MINDPLATE) && isConst?(type,PBTypes,:PSYCHIC)) ||
        (attacker.hasWorkingItem(:ICICLEPLATE) && isConst?(type,PBTypes,:ICE)) ||
        (attacker.hasWorkingItem(:DRACOPLATE) && isConst?(type,PBTypes,:DRAGON)) ||
        (attacker.hasWorkingItem(:DREADPLATE) && isConst?(type,PBTypes,:DARK)) ||
        (attacker.hasWorkingItem(:PIXIEPLATE) && isConst?(type,PBTypes,:FAIRY))
        basedamage=(basedamage*1.2).round
      end
      if (attacker.hasWorkingItem(:NORMALGEM) && isConst?(type,PBTypes,:NORMAL)) ||
        (attacker.hasWorkingItem(:FIGHTINGGEM) && isConst?(type,PBTypes,:FIGHTING)) ||
        (attacker.hasWorkingItem(:FLYINGGEM) && isConst?(type,PBTypes,:FLYING)) ||
        (attacker.hasWorkingItem(:POISONGEM) && isConst?(type,PBTypes,:POISON)) ||
        (attacker.hasWorkingItem(:GROUNDGEM) && isConst?(type,PBTypes,:GROUND)) ||
        (attacker.hasWorkingItem(:ROCKGEM) && isConst?(type,PBTypes,:ROCK)) ||
        (attacker.hasWorkingItem(:BUGGEM) && isConst?(type,PBTypes,:BUG)) ||
        (attacker.hasWorkingItem(:GHOSTGEM) && isConst?(type,PBTypes,:GHOST)) ||
        (attacker.hasWorkingItem(:STEELGEM) && isConst?(type,PBTypes,:STEEL)) ||
        (attacker.hasWorkingItem(:FIREGEM) && isConst?(type,PBTypes,:FIRE)) ||
        (attacker.hasWorkingItem(:WATERGEM) && isConst?(type,PBTypes,:WATER)) ||
        (attacker.hasWorkingItem(:GRASSGEM) && isConst?(type,PBTypes,:GRASS)) ||
        (attacker.hasWorkingItem(:ELECTRICGEM) && isConst?(type,PBTypes,:ELECTRIC)) ||
        (attacker.hasWorkingItem(:PSYCHICGEM) && isConst?(type,PBTypes,:PSYCHIC)) ||
        (attacker.hasWorkingItem(:ICEGEM) && isConst?(type,PBTypes,:ICE)) ||
        (attacker.hasWorkingItem(:DRAGONGEM) && isConst?(type,PBTypes,:DRAGON)) ||
        (attacker.hasWorkingItem(:DARKGEM) && isConst?(type,PBTypes,:DARK)) ||
        (attacker.hasWorkingItem(:FAIRYGEM) && isConst?(type,PBTypes,:FAIRY))
        basedamage=(basedamage*1.5).round
      end
      if attacker.hasWorkingItem(:ROCKINCENSE) && isConst?(type,PBTypes,:ROCK)
        basedamage=(basedamage*1.2).round
      end
      if attacker.hasWorkingItem(:ROSEINCENSE) && isConst?(type,PBTypes,:GRASS)
        basedamage=(basedamage*1.2).round
      end
      if attacker.hasWorkingItem(:SEAINCENSE) && isConst?(type,PBTypes,:WATER)
        basedamage=(basedamage*1.2).round
      end
      if attacker.hasWorkingItem(:WAVEINCENSE) && isConst?(type,PBTypes,:WATER)
        basedamage=(basedamage*1.2).round
      end
      if attacker.hasWorkingItem(:ODDINCENSE) && isConst?(type,PBTypes,:PSYCHIC)
        basedamage=(basedamage*1.2).round
      end
      # Muscle Band
      if attacker.hasWorkingItem(:MUSCLEBAND) && move.pbIsPhysical?(type)
        basedamage=(basedamage*1.1).round
      end
      # Wise Glasses
      if attacker.hasWorkingItem(:WISEGLASSES) && move.pbIsSpecial?(type)
        basedamage=(basedamage*1.1).round
      end
      # Legendary Orbs
      if isConst?(attacker.species,PBSpecies,:PALKIA) &&
        attacker.hasWorkingItem(:LUSTROUSORB) &&
        (isConst?(type,PBTypes,:DRAGON) || isConst?(type,PBTypes,:WATER))
        basedamage=(basedamage*1.2).round
      end
      if isConst?(attacker.species,PBSpecies,:DIALGA) &&
        attacker.hasWorkingItem(:ADAMANTORB) &&
        (isConst?(type,PBTypes,:DRAGON) || isConst?(type,PBTypes,:STEEL))
        basedamage=(basedamage*1.2).round
      end
      if isConst?(attacker.species,PBSpecies,:GIRATINA) &&
        attacker.hasWorkingItem(:GRISEOUSORB) &&
        (isConst?(type,PBTypes,:DRAGON) || isConst?(type,PBTypes,:GHOST))
        basedamage=(basedamage*1.2).round
      end
      if isConst?(attacker.species,PBSpecies,:LATIAS) || isConst?(attacker.species,PBSpecies,:LATIOS) &&
        attacker.hasWorkingItem(:SOULDEW) &&
        (isConst?(type,PBTypes,:DRAGON) || isConst?(type,PBTypes,:PSYCHIC))
        basedamage=(basedamage*1.2).round
      end
    end
    # pbBaseDamageMultiplier - TODO
    # Me First
    # Charge
    if skill>=PBTrainerAI.mediumSkill
      if attacker.effects[PBEffects::Charge]>0 && isConst?(type,PBTypes,:ELECTRIC)
        basedamage=(basedamage*2.0).round
      end
    end
    # Helping Hand
    if skill>=PBTrainerAI.mediumSkill
      if attacker.effects[PBEffects::HelpingHand]
        basedamage=(basedamage*1.5).round
      end
    end
    # Tar Shot
    if skill>=PBTrainerAI.mediumSkill
      if isConst?(type,PBTypes,:FIRE)
        if opponent.effects[PBEffects::TarShot]
          basedamage=(basedamage*2).round
        end
      end
    end
    # Water Sport
    if skill>=PBTrainerAI.mediumSkill
      if isConst?(type,PBTypes,:FIRE)
        if @field.effects[PBEffects::WaterSport]>0
          basedamage=(basedamage*0.33).round
        end
      end
    end
    # Mud Sport
    if skill>=PBTrainerAI.mediumSkill
      if isConst?(type,PBTypes,:ELECTRIC)
        if @field.effects[PBEffects::MudSport]>0
          basedamage=(basedamage*0.33).round
        end
      end
    end
    # Aerilate
    if skill>=PBTrainerAI.mediumSkill
      if isConst?(type,PBTypes,:NORMAL) &&
        isConst?(attacker.ability,PBAbilities,:AERILATE)
        type=PBTypes::FLYING
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect == 16 || $fefieldeffect == 27 || $fefieldeffect == 28 || $fefieldeffect == 43 # Mountain and Sky fields
            basedamage=(basedamage*1.5).round
          else
            basedamage=(basedamage*1.2).round
          end
        else
          basedamage=(basedamage*1.2).round
        end
      end
    end
    # Galvanize
    if skill>=PBTrainerAI.mediumSkill
      if isConst?(type,PBTypes,:NORMAL) &&
        isConst?(attacker.ability,PBAbilities,:GALVANIZE)
        type=PBTypes::ELECTRIC 
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect == 1 || $fefieldeffect == 17 || @field.effects[PBEffects::ElectricTerrain]>0 # Electric or Factory Fields
            basedamage=(basedamage*1.5).round
          elsif $fefieldeffect == 18 # Short-Circuit Field
            basedamage=(basedamage*2).round
          else
            basedamage=(basedamage*1.2).round
          end
        else
          basedamage=(basedamage*1.2).round
        end        
      end      
    end
    # Liquid Voice
    if skill>=PBTrainerAI.mediumSkill
      if move.isSoundBased? &&
        isConst?(attacker.ability,PBAbilities,:LIQUIDVOICE)
        type=PBTypes::WATER 
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect == 13 
            type=PBTypes::ICE 
          end
        end        
      end      
    end
    # Dark Aura/Aurabreak
    if skill>=PBTrainerAI.mediumSkill
      if isConst?(type,PBTypes,:DARK)
        for i in @battlers
          if isConst?(i.ability,PBAbilities,:DARKAURA)
            breakaura=0
            for j in @battlers
              if isConst?(j.ability,PBAbilities,:AURABREAK)
                breakaura+=1
              end
            end
            if breakaura!=0
              basedamage=(basedamage*2/3).round
            else
              basedamage=(basedamage*1.3).round
            end
          end
        end
      end
    end
    # Fairy Aura/Aurabreak
    if skill>=PBTrainerAI.mediumSkill
      if isConst?(type,PBTypes,:FAIRY)
        for i in @battlers
          if isConst?(i.ability,PBAbilities,:FAIRYAURA)
            breakaura=0
            for j in @battlers
              if isConst?(j.ability,PBAbilities,:AURABREAK)
                breakaura+=1
              end
            end
            if breakaura!=0
              basedamage=(basedamage*2/3).round
            else
              basedamage=(basedamage*1.3).round
            end
          end
        end
      end
    end
    # Pixilate
    if skill>=PBTrainerAI.mediumSkill
      if isConst?(type,PBTypes,:NORMAL) &&
        isConst?(attacker.ability,PBAbilities,:PIXILATE)
        type=PBTypes::FAIRY
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect == 3 # Misty Field
            basedamage=(basedamage*1.5).round
          else
            basedamage=(basedamage*1.2).round
          end
        else
          basedamage=(basedamage*1.2).round
        end
      end
    end
    # Refrigerate
    if skill>=PBTrainerAI.mediumSkill
      if isConst?(type,PBTypes,:NORMAL) &&
        isConst?(attacker.ability,PBAbilities,:REFRIGERATE)
        type=PBTypes::ICE
        if skill>=PBTrainerAI.highSkill
          if $fefieldeffect == 13 || $fefieldeffect == 28 # Icy Fields
            basedamage=(basedamage*1.5).round
          else
            basedamage=(basedamage*1.2).round
          end
        else
          basedamage=(basedamage*1.2).round
        end
      end
    end
    # Normalize
    if skill>=PBTrainerAI.mediumSkill
      if isConst?(attacker.ability,PBAbilities,:NORMALIZE)
        basedamage=(basedamage*1.2).round
      end
    end
    if ($fefieldeffect == 31) && 
      (move.id == PBMoves::CUT || move.id == PBMoves::SLASH || move.id == PBMoves::SACREDSWORD || move.id == PBMoves::SECRETSWORD)
      type=PBTypes::STEEL
    end
    if ($fefieldeffect == 32) && 
      (move.id == PBMoves::ROCKCLIMB || move.id == PBMoves::STRENGTH)
      type=PBTypes::FIRE
    end
    # Knock Off
    if skill>=PBTrainerAI.mediumSkill
      if move.id == PBMoves::KNOCKOFF && (!(opponent.ability == PBAbilities::STICKYHOLD && !opponent.abilitynulled) || opponent.moldbroken) &&
        opponent.item && !pbIsUnlosableItem(opponent,opponent.item)
        basedamage=(basedamage*1.5).round
      end
    end
    if @field.effects[PBEffects::ElectricTerrain]>0
			if (move.id == PBMoves::EXPLOSION || move.id == PBMoves::SELFDESTRUCT ||
					move.id == PBMoves::HURRICANE || move.id == PBMoves::SURF ||
					move.id == PBMoves::SMACKDOWN || move.id == PBMoves::MUDDYWATER ||
					move.id == PBMoves::THOUSANDARROWS)
				basedamage=(basedamage*1.3).round
			end
			if move.id == PBMoves::MAGNETBOMB || move.id == PBMoves::PLASMAFISTS
				basedamage=(basedamage*2).round
			end  
		end  
		if @field.effects[PBEffects::GrassyTerrain]>0
			if (move.id == PBMoves::OMINOUSWIND || move.id == PBMoves::ICYWIND ||
        move.id == PBMoves::SILVERWIND || move.id == PBMoves::TWISTER ||
        move.id == PBMoves::RAZORWIND || move.id == PBMoves::FAIRYWIND ||
        move.id == PBMoves::GUST) 
				basedamage=(basedamage*1.5).round
			end
		end  
		if (@field.effects[PBEffects::MistyTerrain]>0) && $fefieldeffect!=3
			if (move.id == PBMoves::MYSTICALFIRE ||
          move.id == PBMoves::MAGICALLEAF ||
					move.id == PBMoves::DOOMDUMMY || move.id == PBMoves::ICYWIND ||
					move.id == PBMoves::HIDDENPOWER ||
					move.id == PBMoves::MISTBALL || move.id == PBMoves::AURASPHERE ||
					move.id == PBMoves::STEAMERUPTION ||
					move.id == PBMoves::SILVERWIND || move.id == PBMoves::MOONGEISTBEAM)
          basedamage=(basedamage*1.3).round
			end      
		end  
		if (@field.effects[PBEffects::PsychicTerrain]>0) && $fefieldeffect!=37
			if (move.id == PBMoves::HEX || move.id == PBMoves::MAGICALLEAF || move.id == PBMoves::MOONBLAST ||
					move.id == PBMoves::MYSTICALFIRE || move.id == PBMoves::AURASPHERE)
				basedamage=(basedamage*1.3).round
			end     
		end
		if (@field.effects[PBEffects::Rainbow]>0) && $fefieldeffect!=9
			if (move.id == PBMoves::SILVERWIND || move.id == PBMoves::MYSTICALFIRE ||
					move.id == PBMoves::DRAGONPULSE || move.id == PBMoves::TRIATTACK ||
					move.id == PBMoves::SACREDFIRE || move.id == PBMoves::FIREPLEDGE ||
					move.id == PBMoves::WATERPLEDGE || move.id == PBMoves::GRASSPLEDGE ||
					move.id == PBMoves::AURORABEAM || move.id == PBMoves::JUDGMENT ||
					move.id == PBMoves::RELICSONG || move.id == PBMoves::HIDDENPOWER ||
					move.id == PBMoves::SECRETPOWER || move.id == PBMoves::WEATHERBALL ||
					move.id == PBMoves::LUSTERPURGE || move.id == PBMoves::HEARTSTAMP ||
					move.id == PBMoves::ZENHEADBUTT ||
					move.id == PBMoves::SPARKLINGARIA || move.id == PBMoves::FLEURCANNON ||
					move.id == PBMoves::PRISMATICLASER)           
				basedamage=(basedamage*1.3).round
			end    
		end    
    # Specific Field Effect Boosts
    if skill>=PBTrainerAI.highSkill
      case $fefieldeffect
      when 1 # Electric Field
        if (move.id == PBMoves::EXPLOSION || move.id == PBMoves::SELFDESTRUCT ||
            move.id == PBMoves::HURRICANE || move.id == PBMoves::SURF ||
            move.id == PBMoves::SMACKDOWN || move.id == PBMoves::MUDDYWATER ||
            move.id == PBMoves::THOUSANDARROWS)
          basedamage=(basedamage*1.5).round
        end
        if move.id == PBMoves::MAGNETBOMB || move.id == PBMoves::PLASMAFISTS
          basedamage=(basedamage*2).round
        end
      when 2 # Grassy Field
        if (move.id == PBMoves::FAIRYWIND || move.id == PBMoves::SILVERWIND)
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::MUDDYWATER || move.id == PBMoves::SURF || move.id == PBMoves::EARTHQUAKE ||
            move.id == PBMoves::MAGNITUDE || move.id == PBMoves::BULLDOZE)
          basedamage=(basedamage*0.5).round
        end
      when 3 # Misty Field
        if (move.id == PBMoves::MYSTICALFIRE || move.id == PBMoves::MAGICALLEAF ||
            move.id == PBMoves::DOOMDESIRE || move.id == PBMoves::ICYWIND ||
            move.id == PBMoves::MISTBALL || move.id == PBMoves::AURASPHERE ||
            move.id == PBMoves::STEAMERUPTION || move.id == PBMoves::SILVERWIND || 
            move.id == PBMoves::CLEARSMOG || move.id == PBMoves::SMOG || 
            move.id == PBMoves::STRANGESTEAM)
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::DARKPULSE || move.id == PBMoves::SHADOWBALL ||
            move.id == PBMoves::NIGHTDAZE || move.id == PBMoves::NEVERENDINGNIGHTMARE)
          basedamage=(basedamage*0.5).round
        end
      when 4 # Dark Crystal Cavern
        if (move.id == PBMoves::DARKPULSE || move.id == PBMoves::PHOTONGEYSER ||
            move.id == PBMoves::NIGHTDAZE || move.id == PBMoves::NIGHTSLASH ||
            move.id == PBMoves::SHADOWBALL || move.id == PBMoves::SHADOWPUNCH ||
            move.id == PBMoves::SHADOWCLAW || move.id == PBMoves::SHADOWSNEAK ||
            move.id == PBMoves::SHADOWFORCE || move.id == PBMoves::SHADOWBONE || 
            move.id == PBMoves::BLACKHOLEECLIPSE)
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::AURORABEAM || move.id == PBMoves::SIGNALBEAM ||
            move.id == PBMoves::FLASHCANNON || move.id == PBMoves::LUSTERPURGE ||
            move.id == PBMoves::DAZZLINGGLEAM || move.id == PBMoves::MIRRORSHOT ||
            move.id == PBMoves::TECHNOBLAST || move.id == PBMoves::DOOMDESIRE ||
            move.id == PBMoves::POWERGEM || move.id == PBMoves::MOONGEISTBEAM ||
            move.id == PBMoves::MENACINGMOONRAZEMAELSTROM)
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::PRISMATICLASER)
          basedamage=(basedamage*2).round
        end
      when 5 # Chess Board
        if (move.id == PBMoves::STRENGTH || move.id == PBMoves::ANCIENTPOWER ||
            move.id == PBMoves::PSYCHIC || move.id == PBMoves::ROCKTHROW)
          basedamage=(basedamage*1.5).round
          if isConst?(opponent.ability,PBAbilities,:ADAPTABILITY) ||
            isConst?(opponent.ability,PBAbilities,:ANTICIPATION) ||
            isConst?(opponent.ability,PBAbilities,:SYNCHRONIZE) ||
            isConst?(opponent.ability,PBAbilities,:TELEPATHY)
            basedamage=(basedamage*0.5).round
          end
          if isConst?(opponent.ability,PBAbilities,:OBLIVIOUS) ||
            isConst?(opponent.ability,PBAbilities,:KLUTZ) ||
            isConst?(opponent.ability,PBAbilities,:UNAWARE) ||
            SilvallyCheck(opponent, PBTypes::FAIRY) ||
            isConst?(opponent.ability,PBAbilities,:SIMPLE) ||
            opponent.effects[PBEffects::Confusion]>0
            basedamage=(basedamage*2).round
          end
          if attacker.effects[PBEffects::KinesisBoost]  
            basedamage=(basedamage*2).round  
          end  
        end  
        if (move.id == PBMoves::BARRAGE)  
          basedamage=(basedamage*2.0).round  
          if isConst?(opponent.ability,PBAbilities,:ADAPTABILITY) ||  
            isConst?(opponent.ability,PBAbilities,:ANTICIPATION) ||  
            isConst?(opponent.ability,PBAbilities,:SYNCHRONIZE) ||  
            isConst?(opponent.ability,PBAbilities,:TELEPATHY)  
            basedamage=(basedamage*0.5).round  
          end  
          if isConst?(opponent.ability,PBAbilities,:OBLIVIOUS) ||  
            isConst?(opponent.ability,PBAbilities,:KLUTZ) ||  
            isConst?(opponent.ability,PBAbilities,:UNAWARE) ||  
            SilvallyCheck(opponent, PBTypes::FAIRY) ||  
            isConst?(opponent.ability,PBAbilities,:SIMPLE) ||  
            opponent.effects[PBEffects::Confusion]>0  
            basedamage=(basedamage*2).round  
          end  
          if attacker.effects[PBEffects::KinesisBoost]  
            basedamage=(basedamage*2).round  
          end
        end
        if move.id == PBMoves::GILDEDARROW 
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::FEINT || move.id == PBMoves::FEINTATTACK || 
            move.id == PBMoves::FAKEOUT || move.id == PBMoves::SUCKERPUNCH)
          basedamage=(basedamage*1.5).round
        end
      when 6 # Big Top
        if ((move.type==PBTypes::FIGHTING && move.pbIsPhysical?(move.type)) ||
            (move.id == PBMoves::STRENGTH || move.id == PBMoves::WOODHAMMER ||
            move.id == PBMoves::DUALCHOP || move.id == PBMoves::HEATCRASH ||
            move.id == PBMoves::SKYDROP || move.id == PBMoves::BULLDOZE ||
            move.id == PBMoves::ICICLECRASH || move.id == PBMoves::BODYSLAM ||
            move.id == PBMoves::STOMP || move.id == PBMoves::POUND ||
            move.id == PBMoves::SLAM || move.id == PBMoves::GIGAIMPACT ||
            move.id == PBMoves::SMACKDOWN || move.id == PBMoves::IRONTAIL ||
            move.id == PBMoves::METEORMASH || move.id == PBMoves::DRAGONRUSH ||
            move.id == PBMoves::CRABHAMMER || move.id == PBMoves::BOUNCE ||
            move.id == PBMoves::HEAVYSLAM || move.id == PBMoves::MAGNITUDE ||
            move.id == PBMoves::EARTHQUAKE || move.id == PBMoves::STOMPINGTANTRUM ||
            move.id == PBMoves::BRUTALSWING || move.id == PBMoves::HIGHHORSEPOWER ||
            move.id == PBMoves::ICEHAMMER || move.id == PBMoves::DRAGONHAMMER ||
            move.id == PBMoves::GRAVAPPLE || move.id == PBMoves::DOUBLEIRONBASH ||
            move.id == PBMoves::CONTINENTALCRUSH))
          if (!attacker.abilitynulled && attacker.ability == PBAbilities::HUGEPOWER) ||
            (!attacker.abilitynulled && attacker.ability == PBAbilities::GUTS) ||
            (!attacker.abilitynulled && attacker.ability == PBAbilities::IRONFIST) ||
            (!attacker.abilitynulled && attacker.ability == PBAbilities::PUREPOWER) ||
            (!attacker.abilitynulled && attacker.ability == PBAbilities::SHEERFORCE) ||
            SilvallyCheck(attacker,PBTypes::GROUND)
            basedamage=(basedamage*2.5).round
          else
            basedamage=(basedamage*1.5).round
          end
        end
        if (move.id == PBMoves::PAYDAY)
          basedamage=(basedamage*2).round
        end
        if (move.id == PBMoves::VINEWHIP || move.id == PBMoves::POWERWHIP ||
            move.id == PBMoves::FIRELASH)
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::FIERYDANCE || move.id == PBMoves::PETALDANCE ||
            move.id == PBMoves::REVELATIONDANCE || move.id == PBMoves::DRUMBEATING)
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::FLY || move.id == PBMoves::ACROBATICS)
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::FIRSTIMPRESSION)
          basedamage=(basedamage*1.5).round
        end
        if move.isSoundBased?
          basedamage=(basedamage*1.5).round
        end
      when 7 # Burning Field
        if (move.id == PBMoves::SMOG || move.id == PBMoves::CLEARSMOG)
          basedamage=(basedamage*2).round
        end
        if (move.id == PBMoves::SMACKDOWN || move.id == PBMoves::THOUSANDARROWS ||
            move.id == PBMoves::ROCKSLIDE)
          basedamage=(basedamage*1.5).round
        end
      when 8 # Swamp Field
        if (move.id == PBMoves::MUDBOMB || move.id == PBMoves::MUDSHOT ||
            move.id == PBMoves::MUDSLAP || move.id == PBMoves::MUDDYWATER ||
            move.id == PBMoves::SURF || move.id == PBMoves::SLUDGEWAVE ||
            move.id == PBMoves::GUNKSHOT || move.id == PBMoves::BRINE ||
            move.id == PBMoves::SMACKDOWN || move.id == PBMoves::THOUSANDARROWS
            move.id == PBMoves::HYDROVORTEX)
          basedamage=(basedamage*1.5).round
        end
      when 9 # Rainbow Field
        if (move.id == PBMoves::SILVERWIND || move.id == PBMoves::MYSTICALFIRE ||
            move.id == PBMoves::DRAGONPULSE || move.id == PBMoves::TRIATTACK ||
            move.id == PBMoves::SACREDFIRE || move.id == PBMoves::FIREPLEDGE ||
            move.id == PBMoves::WATERPLEDGE || move.id == PBMoves::GRASSPLEDGE ||
            move.id == PBMoves::AURORABEAM || move.id == PBMoves::JUDGMENT ||
            move.id == PBMoves::RELICSONG || move.id == PBMoves::HIDDENPOWER ||
            move.id == PBMoves::SECRETPOWER || move.id == PBMoves::WEATHERBALL ||
            move.id == PBMoves::MISTBALL || move.id == PBMoves::HEARTSTAMP ||
            move.id == PBMoves::MOONBLAST || move.id == PBMoves::ZENHEADBUTT ||
            move.id == PBMoves::SPARKLINGARIA || move.id == PBMoves::FLEURCANNON ||
            move.id == PBMoves::PRISMATICLASER || move.id == PBMoves::TWINKLETACKLE)
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::DARKPULSE || move.id == PBMoves::SHADOWBALL ||
            move.id == PBMoves::NIGHTDAZE || move.id == PBMoves::NEVERENDINGNIGHTMARE)
          basedamage=(basedamage*0.5).round
        end
      when 10 # Corrosive Field
        if (move.id == PBMoves::SMACKDOWN || move.id == PBMoves::MUDSLAP ||
            move.id == PBMoves::MUDSHOT || move.id == PBMoves::MUDBOMB ||
            move.id == PBMoves::MUDDYWATER || move.id == PBMoves::WHIRLPOOL ||
            move.id == PBMoves::THOUSANDARROWS || move.id == PBMoves::APPLEACID)
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::ACID || move.id == PBMoves::ACIDSPRAY ||
            move.id == PBMoves::GRASSKNOT || move.id == PBMoves::SNAPTRAP)
          basedamage=(basedamage*2).round
        end
      when 11 # Corrosive Mist Field
        if (move.id == PBMoves::BUBBLEBEAM || move.id == PBMoves::ACIDSPRAY ||
            move.id == PBMoves::BUBBLE || move.id == PBMoves::SMOG ||
            move.id == PBMoves::CLEARSMOG || move.id == PBMoves::SPARKLINGARIA ||
            move.id == PBMoves::APPLEACID)
          basedamage=(basedamage*1.5).round
        end
      when 12 # Desert Field
        if (move.id == PBMoves::NEEDLEARM || move.id == PBMoves::PINMISSILE  || move.id == PBMoves::SCALD || move.id == PBMoves::STEAMERUPTION ||
            move.id == PBMoves::DIG || move.id == PBMoves::SANDTOMB ||  move.id == PBMoves::SCORCHINGSANDS || 
            move.id == PBMoves::HEATWAVE || move.id == PBMoves::THOUSANDWAVES ||
            move.id == PBMoves::BURNUP)
          basedamage=(basedamage*1.5).round
        end
      when 13 # Icy Field
        if (move.id == PBMoves::SCALD || move.id == PBMoves::STEAMERUPTION)
          basedamage=(basedamage*0.5).round
        end
      when 14 # Rocky Field
        if (move.id == PBMoves::ROCKSMASH)
          basedamage=(basedamage*2).round
        end
        if (move.id == PBMoves::ROCKCLIMB || move.id == PBMoves::STRENGTH ||
            move.id == PBMoves::MAGNITUDE || move.id == PBMoves::EARTHQUAKE ||
            move.id == PBMoves::BULLDOZE || move.id == PBMoves::ACCELEROCK)
          basedamage=(basedamage*1.5).round
        end
      when 15 # Forest Field
        if (move.id == PBMoves::CUT)
          basedamage=(basedamage*2).round
        end
        if (move.id == PBMoves::SLASH || move.id == PBMoves::AIRSLASH ||
            move.id == PBMoves::GALESTRIKE || move.id == PBMoves::FURYCUTTER ||
            move.id == PBMoves::AIRCUTTER || move.id == PBMoves::PSYCHOCUT ||
            move.id == PBMoves::ATTACKORDER || move.id == PBMoves::BREAKINGSWIPE)
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::SURF || move.id == PBMoves::MUDDYWATER)
          basedamage=(basedamage*0.5).round
        end
      when 16 # Superheated Field
        if (move.id == PBMoves::STEAMERUPTION)
          basedamage=(basedamage*1.667).round
        end
        if (move.id == PBMoves::THUNDER)
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::ERUPTION || move.id == PBMoves::HEATWAVE ||
          move.id == PBMoves::MAGMASTORM || move.id == PBMoves::LAVAPLUME ||
          move.id == PBMoves::LAVASURF)
          basedamage=(basedamage*1.3).round
        end
        if (move.id == PBMoves::OMINOUSWIND || move.id == PBMoves::SILVERWIND ||
            move.id == PBMoves::RAZORWIND || move.id == PBMoves::ICYWIND ||
            move.id == PBMoves::GUST || move.id == PBMoves::TWISTER ||
            move.id == PBMoves::PRECIPICEBLADES || move.id == PBMoves::SMOG ||
            move.id == PBMoves::CLEARSMOG)
          basedamage=(basedamage*1.2).round
        end
      when 17 # Factory Field
        if (move.id == PBMoves::FLASHCANNON || move.id == PBMoves::GYROBALL ||
            move.id == PBMoves::MAGNETBOMB || move.id == PBMoves::GEARGRIND ||
            move.id == PBMoves::DOUBLEIRONBASH)
          basedamage=(basedamage*2).round
        end
        if (move.id == PBMoves::STEAMROLLER || move.id == PBMoves::TECHNOBLAST)
          basedamage=(basedamage*1.5).round
        end
      when 18 # Shortcircuit Field
        if isConst?(move.type,PBTypes,:ELECTRIC)
          if @field.effects[PBEffects::ElectricTerrain]>0
            basedamage=(basedamage*2).round
          else
            basedamage=(basedamage*1.2).round
          end
        end
        if (move.id == PBMoves::DAZZLINGGLEAM)
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::DARKPULSE || move.id == PBMoves::PHANTOMFORCE ||
            move.id == PBMoves::NIGHTDAZE || move.id == PBMoves::NIGHTSLASH ||
            move.id == PBMoves::SHADOWBALL || move.id == PBMoves::SHADOWPUNCH ||
            move.id == PBMoves::SHADOWCLAW || move.id == PBMoves::SHADOWSNEAK ||
            move.id == PBMoves::SHADOWFORCE || move.id == PBMoves::SHADOWBONE)
          basedamage=(basedamage*1.3).round
        end
        if (move.id == PBMoves::SURF || move.id == PBMoves::MUDDYWATER ||
            move.id == PBMoves::MAGNETBOMB || move.id == PBMoves::GYROBALL ||
            move.id == PBMoves::FLASHCANNON || move.id == PBMoves::GEARGRIND)
          basedamage=(basedamage*1.5).round
        end
      when 19 # Wasteland
        if (move.id == PBMoves::OCTAZOOKA || move.id == PBMoves::SLUDGE ||
            move.id == PBMoves::GUNKSHOT || move.id == PBMoves::SLUDGEWAVE ||
            move.id == PBMoves::SLUDGEBOMB || move.id == PBMoves::ACID)
          basedamage=(basedamage*1.2).round
        end
        if (move.id == PBMoves::SPITUP)
          basedamage=(basedamage*2).round
        end
        if (move.id == PBMoves::VINEWHIP || move.id == PBMoves::POWERWHIP)
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::MUDSLAP || move.id == PBMoves::MUDBOMB ||
            move.id == PBMoves::MUDSHOT)
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::EARTHQUAKE || move.id == PBMoves::MAGNITUDE ||
            move.id == PBMoves::BULLDOZE)
          basedamage=(basedamage*0.25).round
        end
      when 20 # Ashen Beach
        if (move.id == PBMoves::MUDSLAP || move.id == PBMoves::MUDSHOT ||
            move.id == PBMoves::MUDBOMB)
          basedamage=(basedamage*2).round
        end
        if (move.id == PBMoves::HIDDENPOWER || move.id == PBMoves::STRENGTH)
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::LANDSWRATH || move.id == PBMoves::THOUSANDWAVES ||
            move.id == PBMoves::SANDTOMB)
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::PSYCHIC)
          basedamage=(basedamage*1.2).round
        end
        if (move.id == PBMoves::STOREDPOWER || move.id == PBMoves::ZENHEADBUTT ||
            move.id == PBMoves::FOCUSBLAST || move.id == PBMoves::AURASPHERE)
          basedamage=(basedamage*1.3).round
        end
        if (move.id == PBMoves::SURF|| move.id == PBMoves::MUDDYWATER || move.id == PBMoves::HYDROVORTEX)
          basedamage=(basedamage*1.5).round
        end
      when 21 # Water Surface
        if (move.id == PBMoves::SURF || move.id == PBMoves::MUDDYWATER ||
            move.id == PBMoves::WHIRLPOOL || move.id == PBMoves::DIVE ||
            move.id == PBMoves::SLUDGEWAVE || move.id == PBMoves::HYDROVORTEX)
          basedamage=(basedamage*1.5).round
        end
      when 22 # Underwater
        if (move.id == PBMoves::WATERPULSE || move.id == PBMoves::SLUDGEWAVE)
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::ANCHORSHOT || move.id == PBMoves::DRAGONDARTS)
          basedamage=(basedamage*2.0).round
        end
      when 23 # Cave
        if move.isSoundBased?
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::ROCKTOMB)
          basedamage=(basedamage*1.5).round
        end
      when 25 # Crystal Cavern
        if (move.id == PBMoves::AURORABEAM || move.id == PBMoves::SIGNALBEAM ||
            move.id == PBMoves::FLASHCANNON || move.id == PBMoves::DAZZLINGGLEAM ||
            move.id == PBMoves::MIRRORSHOT || move.id == PBMoves::TECHNOBLAST ||
            move.id == PBMoves::DOOMDUMMY || move.id == PBMoves::MOONGEISTBEAM || 
            move.id == PBMoves::MENACINGMOONRAZEMAELSTROM)
          basedamage=(basedamage*1.3).round
        end
        if (move.id == PBMoves::POWERGEM || move.id == PBMoves::DIAMONDSTORM ||
            move.id == PBMoves::ANCIENTPOWER || move.id == PBMoves::JUDGMENT ||
            move.id == PBMoves::ROCKSMASH || move.id == PBMoves::ROCKTOMB ||
            move.id == PBMoves::STRENGTH || move.id == PBMoves::ROCKCLIMB ||
            move.id == PBMoves::MULTIATTACK || move.id == PBMoves::PRISMATICLASER ||
            move.id == PBMoves::LUSTERPURGE || move.id == PBMoves::PHOTONGEYSER
            move.id == PBMoves::LIGHTTHATBURNSTHESKY)
          basedamage=(basedamage*1.5).round
        end
      when 26 # Murkwater Surface
        if (move.id == PBMoves::MUDBOMB || move.id == PBMoves::MUDSLAP ||
            move.id == PBMoves::MUDSHOT || move.id == PBMoves::SMACKDOWN ||
            move.id == PBMoves::ACID || move.id == PBMoves::ACIDSPRAY ||
            move.id == PBMoves::BRINE || move.id == PBMoves::THOUSANDWAVES ||
            move.id == PBMoves::APPLEACID)
          basedamage=(basedamage*1.5).round
        end
      when 27 # Mountain
        if (move.id == PBMoves::VITALTHROW || move.id == PBMoves::CIRCLETHROW ||
            move.id == PBMoves::STORMTHROW)
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::OMINOUSWIND || move.id == PBMoves::ICYWIND ||
            move.id == PBMoves::SILVERWIND || move.id == PBMoves::TWISTER ||
            move.id == PBMoves::RAZORWIND || move.id == PBMoves::FAIRYWIND)
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::OMINOUSWIND || move.id == PBMoves::ICYWIND ||
            move.id == PBMoves::SILVERWIND || move.id == PBMoves::TWISTER ||
            move.id == PBMoves::RAZORWIND || move.id == PBMoves::FAIRYWIND ||
            move.id == PBMoves::GUST) && pbWeather==PBWeather::STRONGWINDS
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::THUNDER || move.id == PBMoves::ERUPTION ||
            move.id == PBMoves::AVALANCHE)
          basedamage=(basedamage*1.5).round
        end
      when 28 # Snowy Mountain
        if (move.id == PBMoves::VITALTHROW || move.id == PBMoves::CIRCLETHROW ||
            move.id == PBMoves::STORMTHROW)
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::OMINOUSWIND ||
            move.id == PBMoves::SILVERWIND || move.id == PBMoves::TWISTER ||
            move.id == PBMoves::RAZORWIND || move.id == PBMoves::FAIRYWIND)
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::ICYWIND)
          basedamage=(basedamage*2).round
        end
        if (move.id == PBMoves::OMINOUSWIND || move.id == PBMoves::ICYWIND ||
            move.id == PBMoves::SILVERWIND || move.id == PBMoves::TWISTER ||
            move.id == PBMoves::RAZORWIND || move.id == PBMoves::FAIRYWIND ||
            move.id == PBMoves::GUST) && pbWeather==PBWeather::STRONGWINDS
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::SCALD || move.id == PBMoves::STEAMERUPTION)
          basedamage=(basedamage*0.5).round
        end
        if (move.id == PBMoves::AVALANCHE || move.id == PBMoves::POWDERSNOW)
          basedamage=(basedamage*1.5).round
        end
      when 29 # Holy
        if (move.id == PBMoves::MYSTICALFIRE || move.id == PBMoves::MAGICALLEAF ||
            move.id == PBMoves::JUDGMENT || move.id == PBMoves::SACREDFIRE ||
            move.id == PBMoves::ANCIENTPOWER)
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::PSYSTRIKE || move.id == PBMoves::AEROBLAST ||
            move.id == PBMoves::SACREDFIRE || move.id == PBMoves::ORIGINPULSE ||
            move.id == PBMoves::DOOMDUMMY || move.id == PBMoves::JUDGMENT ||
            move.id == PBMoves::MISTBALL || move.id == PBMoves::CRUSHGRIP ||
            move.id == PBMoves::LUSTERPURGE || move.id == PBMoves::SECRETSWORD ||
            move.id == PBMoves::PSYCHOBOOST || move.id == PBMoves::RELICSONG ||
            move.id == PBMoves::SPACIALREND || move.id == PBMoves::HYPERSPACEHOLE ||
            move.id == PBMoves::ROAROFTIME || move.id == PBMoves::LANDSWRATH ||
            move.id == PBMoves::PRECIPICEBLADES || move.id == PBMoves::DRAGONASCENT ||
            move.id == PBMoves::MOONGEISTBEAM || move.id == PBMoves::SUNSTEELSTRIKE ||
            move.id == PBMoves::PRISMATICLASER || move.id == PBMoves::FLEURCANNON ||
            move.id == PBMoves::BEHEMOTHBLADE || move.id == PBMoves::BEHEMOTHBASH ||
            move.id == PBMoves::DYNAMAXCANNON || move.id == PBMoves::ETERNABEAM || 
            move.id == PBMoves::GENESISSUPERNOVA || (move.id == PBMoves::MULTIPULSE && move.type != PBTypes::NORMAL))
          basedamage=(basedamage*1.3).round
        end
      when 30 # Mirror
        if (move.id == PBMoves::MIRRORSHOT)
          basedamage=(basedamage*2).round
        end
        if (move.id == PBMoves::CHARGEBEAM || move.id == PBMoves::SOLARBEAM ||
            move.id == PBMoves::PSYBEAM || move.id == PBMoves::TRIATTACK ||
            move.id == PBMoves::BUBBLEBEAM || move.id == PBMoves::HYPERBEAM ||
            move.id == PBMoves::ICEBEAM || move.id == PBMoves::ORIGINPULSE ||
            move.id == PBMoves::MOONGEISTBEAM || move.id == PBMoves::FLEURCANNON) &&
          basedamage=(basedamage*2).round
        end
        if (move.id == PBMoves::AURORABEAM || move.id == PBMoves::SIGNALBEAM ||
            move.id == PBMoves::FLASHCANNON || move.id == PBMoves::LUSTERPURGE ||
            move.id == PBMoves::DAZZLINGGLEAM || move.id == PBMoves::TECHNOBLAST ||
            move.id == PBMoves::DOOMDUMMY || move.id == PBMoves::PRISMATICLASER)
          basedamage=(basedamage*1.5).round
        end
      when 31 # Fairy Tale
        if (move.id == PBMoves::DRAININGKISS || move.id == PBMoves::MISTBALL)
          basedamage=(basedamage*2).round
        end
        if (move.id == PBMoves::NIGHTSLASH || move.id == PBMoves::LEAFBLADE ||
            move.id == PBMoves::PSYCHOCUT || move.id == PBMoves::SMARTSTRIKE ||
            move.id == PBMoves::SOLARBLADE || move.id == PBMoves::BEHEMOTHBASH ||
            move.id == PBMoves::RAZORSHELL || move.id == PBMoves::BEHEMOTHBLADE)
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::MAGICALLEAF || move.id == PBMoves::MYSTICALFIRE ||
            move.id == PBMoves::ANCIENTPOWER || move.id == PBMoves::RELICSONG ||
            move.id == PBMoves::SPARKLINGARIA || move.id == PBMoves::MOONGEISTBEAM ||
            move.id == PBMoves::FLEURCANNON || move.id == PBMoves::MISTBALL)
          basedamage=(basedamage*1.5).round
        end
      when 32 # Dragon's Den
        if (move.id == PBMoves::MEGAKICK ||
            move.id == PBMoves::ROCKCLIMB || move.id == PBMoves::STRENGTH)
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::SMACKDOWN || move.id == PBMoves::THOUSANDARROWS)
          basedamage=(basedamage*2).round
        end
        if (move.id == PBMoves::MAGMASTORM || move.id == PBMoves::LAVAPLUME ||
            move.id == PBMoves::STOMPINGTANTRUM || move.id == PBMoves::EARTHPOWER ||
            move.id == PBMoves::POWERGEM || move.id == PBMoves::DIAMONDSTORM ||
            move.id == PBMoves::MATRIXSHOT || move.id == PBMoves::LAVASURF ||
            move.id == PBMoves::SHELLTRAP)
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::DRAGONASCENT ||  move.id == PBMoves::LUSTERPURGE ||
          move.id == PBMoves::MISTBALL)
          basedamage=(basedamage*2).round
        end
        if (move.id == PBMoves::PAYDAY)
          basedamage=(basedamage*2).round
        end
        case basefield
        when 4
          if (move.id == PBMoves::DARKPULSE ||
              move.id == PBMoves::NIGHTDAZE || move.id == PBMoves::NIGHTSLASH ||
              move.id == PBMoves::SHADOWBALL || move.id == PBMoves::SHADOWPUNCH ||
              move.id == PBMoves::SHADOWCLAW || move.id == PBMoves::SHADOWSNEAK ||
              move.id == PBMoves::SHADOWFORCE || move.id == PBMoves::SHADOWBONE)
            basedamage=(basedamage*1.5).round
          end
          if (move.id == PBMoves::AURORABEAM || move.id == PBMoves::SIGNALBEAM ||
              move.id == PBMoves::FLASHCANNON || move.id == PBMoves::LUSTERPURGE ||
              move.id == PBMoves::DAZZLINGGLEAM || move.id == PBMoves::MIRRORSHOT ||
              move.id == PBMoves::TECHNOBLAST || move.id == PBMoves::DOOMDUMMY ||
              move.id == PBMoves::POWERGEM || move.id == PBMoves::MOONGEISTBEAM)
            basedamage=(basedamage*1.5).round
          end
        when 23
          if move.isSoundBased?
            basedamage=(basedamage*1.5).round
          end
        when 25
          if (move.id == PBMoves::AURORABEAM || move.id == PBMoves::SIGNALBEAM ||
              move.id == PBMoves::FLASHCANNON || move.id == PBMoves::DAZZLINGGLEAM ||
              move.id == PBMoves::MIRRORSHOT || move.id == PBMoves::TECHNOBLAST ||
              move.id == PBMoves::DOOMDUMMY || move.id == PBMoves::MOONGEISTBEAM)
            basedamage=(basedamage*1.3).round
          end
          if (move.id == PBMoves::LUSTERPURGE)
            basedamage=(basedamage*1.5).round
          end
        when 41
          if (move.id == PBMoves::SEEDFLARE)
            basedamage=(basedamage*1.5).round
          end
        end
      when 33 # Flower Garden
        if (move.id == PBMoves::CUT) && $fecounter > 0
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::PETALBLIZZARD || move.id == PBMoves::PETALDANCE || move.id == PBMoves::FLEURCANNON) && $fecounter = 2
          basedamage=(basedamage*1.2).round
        end
        if (move.id == PBMoves::PETALBLIZZARD || move.id == PBMoves::PETALDANCE || move.id == PBMoves::FLEURCANNON) && $fecounter > 2
          basedamage=(basedamage*1.5).round
        end
      when 34 # Starlight Arena
        if (move.id == PBMoves::AURORABEAM || move.id == PBMoves::SIGNALBEAM ||
            move.id == PBMoves::FLASHCANNON || move.id == PBMoves::LUSTERPURGE ||
            move.id == PBMoves::GENESISSUPERNOVA || move.id == PBMoves::SOULSTEALING7STARSTRIKE || 
            move.id == PBMoves::DAZZLINGGLEAM || move.id == PBMoves::MIRRORSHOT ||
            move.id == PBMoves::TECHNOBLAST || move.id == PBMoves::SOLARBEAM)
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::MOONBLAST)
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::DRACOMETEOR || move.id == PBMoves::METEORMASH ||
            move.id == PBMoves::COMETPUNCH || move.id == PBMoves::SPACIALREND ||
            move.id == PBMoves::MENACINGMOONRAZEMAELSTROM || move.id == PBMoves::SEARINGSUNRAZESMASH || move.id == PBMoves::LIGHTTHATBURNSTHESKY
            move.id == PBMoves::SWIFT || move.id == PBMoves::HYPERSPACEHOLE ||
            move.id == PBMoves::HYPERSPACEFURY || move.id == PBMoves::MOONGEISTBEAM ||
            move.id == PBMoves::SUNSTEELSTRIKE || move.id == PBMoves::METEORASSAULT)
          basedamage=(basedamage*2).round
        end
        if (move.id == PBMoves::DOOMDUMMY)
          basedamage=(basedamage*4).round
        end
      when 35 # New World
        if (move.id == PBMoves::AURORABEAM || move.id == PBMoves::SIGNALBEAM ||
            move.id == PBMoves::FLASHCANNON || move.id == PBMoves::DAZZLINGGLEAM ||
            move.id == PBMoves::GENESISSUPERNOVA || move.id == PBMoves::SOULSTEALING7STARSTRIKE || 
            move.id == PBMoves::MIRRORSHOT)
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::EARTHPOWER || move.id == PBMoves::POWERGEM ||
            move.id == PBMoves::ERUPTION)
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::PSYSTRIKE || move.id == PBMoves::AEROBLAST ||
            move.id == PBMoves::SACREDFIRE || move.id == PBMoves::MISTBALL ||
            move.id == PBMoves::LUSTERPURGE || move.id == PBMoves::ORIGINPULSE ||
            move.id == PBMoves::PRECIPICEBLADES || move.id == PBMoves::DRAGONASCENT ||
            move.id == PBMoves::PSYCHOBOOST || move.id == PBMoves::ROAROFTIME ||
            move.id == PBMoves::MAGMASTORM || move.id == PBMoves::CRUSHGRIP ||
            move.id == PBMoves::JUDGMENT || move.id == PBMoves::SEEDFLARE ||
            move.id == PBMoves::MENACINGMOONRAZEMAELSTROM || move.id == PBMoves::SEARINGSUNRAZESMASH ||
            move.id == PBMoves::SHADOWFORCE || move.id == PBMoves::SEARINGSHOT ||
            move.id == PBMoves::VCREATE || move.id == PBMoves::SECRETSWORD ||
            move.id == PBMoves::SACREDSWORD || move.id == PBMoves::RELICSONG ||
            move.id == PBMoves::FUSIONBOLT || move.id == PBMoves::FUSIONFLARE ||
            move.id == PBMoves::ICEBURN || move.id == PBMoves::FREEZESHOCK ||
            move.id == PBMoves::BOLTSTRIKE || move.id == PBMoves::BLUEFLARE ||
            move.id == PBMoves::TECHNOBLAST || move.id == PBMoves::OBLIVIONWING ||
            move.id == PBMoves::LANDSWRATH || move.id == PBMoves::THOUSANDARROWS ||
            move.id == PBMoves::THOUSANDWAVES || move.id == PBMoves::DIAMONDSTORM ||
            move.id == PBMoves::STEAMERUPTION || move.id == PBMoves::COREENFORCER ||
            move.id == PBMoves::FLEURCANNON || move.id == PBMoves::PRISMATICLASER ||
            move.id == PBMoves::SUNSTEELSTRIKE || move.id == PBMoves::SPECTRALTHIEF ||
            move.id == PBMoves::MOONGEISTBEAM || move.id == PBMoves::MULTIATTACK)
          basedamage=(basedamage*1.5).round
        end
        if (move.id == PBMoves::VACUUMWAVE || move.id == PBMoves::DRACOMETEOR ||
            move.id == PBMoves::METEORMASH || move.id == PBMoves::MOONBLAST ||
            move.id == PBMoves::COMETPUNCH || move.id == PBMoves::SWIFT ||
            move.id == PBMoves::HYPERSPACEHOLE || move.id == PBMoves::SPACIALREND ||
            move.id == PBMoves::HYPERSPACEFURY|| move.id == PBMoves::ANCIENTPOWER ||
            move.id == PBMoves::FUTUREDUMMY)
          basedamage=(basedamage*2).round
        end
        if (move.id == PBMoves::DOOMDUMMY || move.id == PBMoves::LIGHTTHATBURNSTHESKY)
          basedamage=(basedamage*4).round
        end
      when 37 # Psychic Terrain
        if (move.id == PBMoves::HEX || move.id == PBMoves::MAGICALLEAF ||
            move.id == PBMoves::MYSTICALFIRE || move.id == PBMoves::MOONBLAST ||
            move.id == PBMoves::AURASPHERE)
          basedamage=(basedamage*1.5).round
        end
      when 38 # Dimensional Field
        if (move.id == PBMoves::DARKPULSE || move.id == PBMoves::NIGHTDAZE)
          basedamage=(basedamage*1.2).round
        end
        if (move.id == PBMoves::HYPERSPACEHOLE || move.id == PBMoves::HYPERSPACEFURY || 
            move.id == PBMoves::DYNAMAXCANNON || move.id == PBMoves::ETERNABEAM || 
            move.id == PBMoves::SHADOWFORCE)
          basedamage=(basedamage*1.5).round
        end
      when 39 # Frozen Dimensional Field
        if (move.id == PBMoves::SURF || move.id == PBMoves::MUDDYWATER ||
            move.id == PBMoves::WATERPULSE || move.id == PBMoves::HYDROPUMP ||
            move.id == PBMoves::NIGHTSLASH || move.id == PBMoves::DARKPULSE ||
            move.id == PBMoves::HYPERSPACEHOLE || move.id == PBMoves::HYPERSPACEFURY)
          basedamage=(basedamage*1.2).round
        end
      when 40 # Haunted Field
        if (move.id == PBMoves::FLAMEBURST || move.id == PBMoves::INFERNO ||
            move.id == PBMoves::FIRESPIN || move.id == PBMoves::FLAMECHARGE)
          basedamage=(basedamage*1.3).round
        end
        if (move.id == PBMoves::SPIRITBREAK)
          basedamage=(basedamage*1.5).round
        end
      when 41 # Corrupted Cave
        if (move.id == PBMoves::SEEDFLARE || move.id == PBMoves::APPLEACID)
          basedamage=(basedamage*1.5).round
        end
      when 42 # Bewitched Woods
        if (move.id == PBMoves::DARKPULSE || move.id == PBMoves::NIGHTDAZE ||
            move.id == PBMoves::MOONBLAST)
          basedamage=(basedamage*1.2).round
        end
        if (move.id == PBMoves::ICEBEAM || move.id == PBMoves::HYPERBEAM ||
            move.id == PBMoves::SIGNALBEAM || move.id == PBMoves::AURORABEAM ||
            move.id == PBMoves::BUBBLEBEAM || move.id == PBMoves::CHARGEBEAM ||
            move.id == PBMoves::PSYBEAM || move.id == PBMoves::FLASHCANNON ||
            move.id == PBMoves::MAGICALLEAF)
          basedamage=(basedamage*1.4).round
        end
        if (move.id == PBMoves::HEX || move.id == PBMoves::MYSTICALFIRE ||
            move.id == PBMoves::HEXDUMMY || move.id == PBMoves::SPIRITBREAK)
          basedamage=(basedamage*1.5).round
        end
      when 43 # Sky Field
        if (move.id == PBMoves::ICYWIND || move.id == PBMoves::OMINOUSWIND ||
            move.id == PBMoves::SILVERWIND || move.id == PBMoves::RAZORWIND ||
            move.id == PBMoves::FAIRYWIND || move.id == PBMoves::AEROBLAST ||
            move.id == PBMoves::SKYUPPERCUT || move.id == PBMoves::FLYINGPRESS ||
            move.id == PBMoves::THUNDERSHOCK || move.id == PBMoves::THUNDERBOLT ||
            move.id == PBMoves::THUNDER || move.id == PBMoves::STEELWING ||
            move.id == PBMoves::TWISTER || move.id == PBMoves::DRAGONDARTS ||
            move.id == PBMoves::GRAVAPPLE || move.id == PBMoves::DRAGONASCENT)
          basedamage=(basedamage*1.5).round
        end
      when 44 # Colosseum Field  
        if (move.id == PBMoves::BEATUP || move.id == PBMoves::FELLSTINGER ||  
            move.id == PBMoves::PAYDAY || move.id == PBMoves::REVERSAL ||   
            move.id == PBMoves::PURSUIT)  
          basedamage=(basedamage*2.0).round  
        end  
        if (move.id == PBMoves::ELECTROWEB || move.id == PBMoves::VINEWHIP ||  
            move.id == PBMoves::PSYCHOCUT || move.id == PBMoves::NIGHTSLASH ||  
            move.id == PBMoves::BONEMERANG || move.id == PBMoves::FIRSTIMPRESSION ||  
            move.id == PBMoves::BONERUSH || move.id == PBMoves::BONECLUB ||  
            move.id == PBMoves::LEAFBLADE || move.id == PBMoves::PAYBACK ||  
            move.id == PBMoves::PUNISHMENT || move.id == PBMoves::METEORMASH ||  
            move.id == PBMoves::BULLETPUNCH || move.id == PBMoves::CLANGINGSCALES ||  
            move.id == PBMoves::STEAMROLLER || move.id == PBMoves::BRUTALSWING ||  
            move.id == PBMoves::SACREDSWORD || move.id == PBMoves::SECRETSWORD ||  
            move.id == PBMoves::SUBMISSION || move.id == PBMoves::METEORASSAULT ||  
            move.id == PBMoves::SMARTSTRIKE || move.id == PBMoves::SMACKDOWN)  
          basedamage=(basedamage*1.5).round  
        end  
        if (move.id == PBMoves::WOODHAMMER || move.id == PBMoves::DRAGONHAMMER ||  
            move.id == PBMoves::POWERWHIP || move.id == PBMoves::SPIRITSHACKLE ||  
            move.id == PBMoves::DRILLRUN || move.id == PBMoves::DRILLPECK ||  
            move.id == PBMoves::ICEHAMMER || move.id == PBMoves::ICICLESPEAR ||  
            move.id == PBMoves::ANCHORSHOT || move.id == PBMoves::CRABHAMMER ||  
            move.id == PBMoves::SHADOWBONE || move.id == PBMoves::FIRELASH ||  
            move.id == PBMoves::SUCKERPUNCH || move.id == PBMoves::THROATCHOP ||  
            move.id == PBMoves::STORMTHROW)  
          basedamage=(basedamage*1.2).round  
        end  
      when 45 # Infernal Field  
        if (move.id == PBMoves::BLASTBURN || move.id == PBMoves::EARTHPOWER ||  
            move.id == PBMoves::PRECIPICEBLADES || move.id == PBMoves::INFERNO)  
          basedamage=(basedamage*1.5).round  
        end  
        if (move.id == PBMoves::PUNISHMENT || move.id == PBMoves::SMOG ||  
            move.id == PBMoves::DREAMEATER)  
          basedamage=(basedamage*2.0).round  
        end
      end
    end
    # Setting up stat stuff.
    stagemul=[2,2,2,2,2,2,2,3,4,5,6,7,8]
    stagediv=[8,7,6,5,4,3,2,2,2,2,2,2,2]
    critrate = pbAICritRate(attacker,opponent,move)
    # Get base attack stat
    atk=pbRoughStat(attacker,PBStats::ATTACK,skill)
    atkstage=attacker.stages[PBStats::ATTACK]+6
    critrate = pbAICritRate(attacker,opponent,move)
    if critrate>=2
      if attacker.stages[PBStats::ATTACK]<0
        atk=attacker.attack
      end
    end
    if attacker.species==681 && attacker.form==0
      originalform = attacker.form
      dummymon = pbAegislashStats(attacker)
      dummymon.pbUpdate
      atk=pbRoughStat(dummymon,PBStats::ATTACK,skill)
      dummymon.form = originalform
      dummymon.pbUpdate
    end
    if move.function==0x121 # Foul Play
      atk=pbRoughStat(opponent,PBStats::ATTACK,skill)
      atkstage=opponent.stages[PBStats::ATTACK]+6
    end
    if move.function==0x184 # Body Press
      atk=pbRoughStat(attacker,PBStats::DEFENSE,skill)
      atkstage=attacker.stages[PBStats::DEFENSE]+6
    end
    if move.function==0x209
      atk=pbRoughStat(attacker,PBStats::SPDEF,skill)
      atkstage=attacker.stages[PBStats::SPDEF]+6
    end
    if (isConst?(attacker.species,PBSpecies,:TYPHLOSION) && attacker.hasWorkingItem(:TYPHCREST)) # Typh Crest
      atk=pbRoughStat(attacker,PBStats::SPATK,skill)
      atkstage=attacker.stages[PBStats::SPATK]+6
    end
    if (isConst?(attacker.species,PBSpecies,:DEDENNE) && attacker.hasWorkingItem(:DEDECREST)) # Dedenne Crest
      atk=pbRoughStat(attacker,PBStats::SPEED,skill)
      atkstage=attacker.stages[PBStats::SPEED]+6
    end
    if type>=0 && (move.pbIsSpecial?(type) || move.function==0x208)
      atk=pbRoughStat(attacker,PBStats::SPATK,skill)
      atkstage=attacker.stages[PBStats::SPATK]+6
      if critrate>=2
        if attacker.stages[PBStats::SPATK]<0
          atk=attacker.spatk
        end
      end
      if attacker.species==681 && attacker.form==0
        originalform = attacker.form
        dummymon = pbAegislashStats(attacker)
        dummymon.pbUpdate
        atk=pbRoughStat(dummymon,PBStats::SPATK,skill)
        dummymon.form = originalform
        dummymon.pbUpdate
      end
      if (isConst?(attacker.species,PBSpecies,:CLAYDOL) && attacker.hasWorkingItem(:CLAYCREST)) # Clay Crest
        atk=pbRoughStat(attacker,PBStats::DEFENSE,skill)
      end
      if move.function==0x121 # Foul Play
        atk=pbRoughStat(opponent,PBStats::SPATK,skill)
        atkstage=opponent.stages[PBStats::SPATK]+6
      end
      if $fefieldeffect == 24
        gl1 = 0
        gl2 = 0
        gl3 = 0
        gl4 = 0
        avBoost = 1
        specsBoost = 1
        evioBoost = 1
        dstBoost = 1
        lbBoost = 1
        # dewBoost = 1
        dssBoost = 1
        mpBoost = 1
        fbBoost = 1
        minusBoost = 1
        plusBoost = 1
        solarBoost = 1
        fgBoost = 1
        batteryBoost = 1
        avBoost = 1.5 if attacker.hasWorkingItem(:ASSAULTVEST)
        specsBoost = 1.5 if attacker.hasWorkingItem(:CHOICESPECS)
        evioBoost = 1.5 if attacker.hasWorkingItem(:EVIOLITE) && pbGetEvolvedFormData(attacker.species).length>0
        dstBoost = 2 if attacker.hasWorkingItem(:DEEPSEATOOTH) && isConst?(attacker.species,PBSpecies,:CLAMPERL)
        lbBoost = 2 if attacker.hasWorkingItem(:LIGHTBALL) && isConst?(attacker.species,PBSpecies,:PIKACHU)
        dssBoost = 2 if attacker.hasWorkingItem(:DEEPSEASCALE) && isConst?(attacker.species,PBSpecies,:CLAMPERL)
        mpBoost = 1.5 if attacker.hasWorkingItem(:METALPOWDER) && isConst?(attacker.species,PBSpecies,:DITTO)
        fbBoost = 1.5 if (!attacker.abilitynulled && attacker.ability == PBAbilities::FLAREBOOST) && attacker.status==PBStatuses::BURN
        minusboost = 1.5 if (!attacker.abilitynulled && attacker.ability == PBAbilities::MINUS) && attacker.pbPartner.hasWorkingAbility(:PLUS)
        plusboost = 1.5 if (!attacker.abilitynulled && attacker.ability == PBAbilities::PLUS) && attacker.pbPartner.hasWorkingAbility(:MINUS)
        solarBoost = 1.5 if ((!attacker.abilitynulled && attacker.ability == PBAbilities::SOLARPOWER) || (isConst?(attacker.species,PBSpecies,:CASTFORM) && isConst?(attacker.item,PBItems,:CASTCREST) && attacker.form==1) ) && pbWeather==PBWeather::SUNNYDAY
        fgBoost = 1.5 if (!attacker.abilitynulled && attacker.ability == PBAbilities::FLOWERGIFT) && pbWeather==PBWeather::SUNNYDAY
        batteryBoost = 1.3 if attacker.pbPartner.hasWorkingAbility(:BATTERY)
        gl1 = attacker.spatk
        gl2 = attacker.spdef
        gl3 = attacker.stages[PBStats::SPDEF]+6
        gl4 = attacker.stages[PBStats::SPATK]+6
        gl2=(gl2*1.0*avBoost*evioBoost*dssBoost*fgBoost*stagemul[gl3]/stagediv[gl3]).floor
        gl1=(gl1*1.0*specsBoost*dstBoost*lbBoost*fbBoost*minusBoost*plusBoost*solarBoost*batteryBoost*stagemul[gl4]/stagediv[gl4]).floor
        if gl1 < gl2
          atk=pbRoughStat(attacker,PBStats::SPDEF,skill)
          atkstage=attacker.stages[PBStats::SPDEF]+6
        end
      end
    end
    if move.function==0x208 # Super UMD  
      atk=pbRoughStat(attacker,PBStats::SPDEF,skill)
      atkstage=attacker.stages[PBStats::SPDEF]+6
    end
    if (opponent.ability == PBAbilities::UNAWARE && !opponent.moldbroken) || SilvallyCheck(opponent, PBTypes::FAIRY)
      atkstage=6
    end
    # Hustle
    if skill>=PBTrainerAI.mediumSkill
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::HUSTLE) && move.pbIsPhysical?(type)
        atk=(atk*1.5).round
      end
    end
    if skill>=PBTrainerAI.averageSkill
      if (move.pbIsSpecial?(type) || move.function==0x208) && @function!=0x122
        if attacker.hasWorkingItem(:ASSAULTVEST) && (move.pbIsSpecial?(type) || move.function==0x208) && $fefieldeffect == 24
          if gl1 < gl2
            atk=(atk*1.5).round
          end
        end
        if attacker.hasWorkingItem(:DEEPSEASCALE) && isConst?(attacker.species,PBSpecies,:CLAMPERL) &&
          $fefieldeffect == 24
          if gl1 < gl2
            atk=(atk*2).round
          end
        end
        if attacker.hasWorkingItem(:METALPOWDER) &&
          isConst?(attacker.species,PBSpecies,:DITTO) && $fefieldeffect == 24
          if gl1 < gl2
            atk=(atk*1.5).round
          end
        end
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::FLOWERGIFT) &&
          pbWeather==PBWeather::SUNNYDAY && $fefieldeffect == 24
          if gl1 < gl2
            atk=(atk*1.5).round
          end
        end
      end
    end
    # Thick Fat
    if skill>=PBTrainerAI.mediumSkill
      if ((!opponent.abilitynulled && opponent.ability == PBAbilities::THICKFAT) || SilvallyCheck(opponent,PBTypes::ICE)) &&
        (isConst?(type,PBTypes,:ICE) || isConst?(type,PBTypes,:FIRE))
        atk=(atk*0.5).round
      end
    end
    # Pastel Veil
    if skill>=PBTrainerAI.mediumSkill
      if ((!opponent.abilitynulled && opponent.ability == PBAbilities::PASTELVEIL)) && ($fefieldeffect==3 || $fefieldeffect==9|| @field.effects[PBEffects::MistyTerrain]>0 ) &&
        (isConst?(type,PBTypes,:POISON))
        atk=(atk*0.5).round
      end
    end
    if !(pbOwnedByPlayer?(attacker.index)) && move.pbIsPhysical?(type) && pbPlayer.numbadges>=12 && $game_variables[200]==2
      atk=(atk*1.1).round
    end
    if !(pbOwnedByPlayer?(attacker.index)) && move.pbIsSpecial?(type) && pbPlayer.numbadges>=12 && $game_variables[200]==2
      atk=(atk*1.1).round
    end
    # Pinch abilities
    if skill>=PBTrainerAI.mediumSkill
      if attacker.hp<=(attacker.totalhp/3).floor
        if ((!attacker.abilitynulled && attacker.ability == PBAbilities::OVERGROW) && isConst?(type,PBTypes,:GRASS)) ||
          ((!attacker.abilitynulled && attacker.ability == PBAbilities::BLAZE) && isConst?(type,PBTypes,:FIRE)) ||
          ((!attacker.abilitynulled && attacker.ability == PBAbilities::TORRENT) && isConst?(type,PBTypes,:WATER)) ||
          ((!attacker.abilitynulled && attacker.ability == PBAbilities::SWARM) && isConst?(type,PBTypes,:BUG))
          atk=(atk*1.5).round
        end
      end
    end
    if skill>=PBTrainerAI.highSkill
      if $fefieldeffect == 7 && ((!attacker.abilitynulled && attacker.ability == PBAbilities::BLAZE) &&
          isConst?(type,PBTypes,:FIRE))
        atk=(atk*1.5).round
      elsif $fefieldeffect == 15 && ((!attacker.abilitynulled && attacker.ability == PBAbilities::OVERGROW) &&
          isConst?(type,PBTypes,:GRASS))
        atk=(atk*1.5).round
      elsif $fefieldeffect == 15 && ((!attacker.abilitynulled && attacker.ability == PBAbilities::SWARM) &&
          isConst?(type,PBTypes,:BUG))
        atk=(atk*1.5).round
      elsif ($fefieldeffect == 21 || $fefieldeffect == 22) &&
        ((!attacker.abilitynulled && attacker.ability == PBAbilities::TORRENT) && isConst?(type,PBTypes,:WATER))
        atk=(atk*1.5).round
      elsif $fefieldeffect == 33 && ((!attacker.abilitynulled && attacker.ability == PBAbilities::SWARM) &&
          isConst?(type,PBTypes,:BUG))
        atk=(atk*1.5).round if $fecounter == 0 || $fecounter == 1
        atk=(atk*2).round if $fecounter == 2 || $fecounter == 3
        atk=(atk*3).round if $fecounter == 4
      elsif $fefieldeffect == 33 && ((!attacker.abilitynulled && attacker.ability == PBAbilities::OVERGROW) &&
          isConst?(type,PBTypes,:GRASS))
        case $fecounter
        when 1
          if attacker.hp<=(attacker.totalhp*0.67).floor
            atk=(atk*1.5).round
          end
        when 2
          atk=(atk*1.5).round
        when 3
          atk=(atk*2).round
        when 4
          atk=(atk*3).round
        end
      end
    end
    # Execution
    if (!attacker.abilitynulled && attacker.ability == PBAbilities::EXECUTION)
      if opponent.hp <= (opponent.totalhp/2).floor
        atk=(atk*2).round
      end
    end
    # Guts
    if skill>=PBTrainerAI.mediumSkill
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::GUTS) &&
        attacker.status!=0 && move.pbIsPhysical?(type)
        atk=(atk*1.5).round
      end
    end
    # Plus, Minus
    if skill>=PBTrainerAI.mediumSkill
      if ((!attacker.abilitynulled && attacker.ability == PBAbilities::PLUS) ||
          (!attacker.abilitynulled && attacker.ability == PBAbilities::MINUS)) && move.pbIsSpecial?(type)
        partner=attacker.pbPartner
        if partner.hasWorkingAbility(:PLUS) || partner.hasWorkingAbility(:MINUS)
          atk=(atk*1.5).round
        elsif ($fefieldeffect == 1 || field.effects[PBEffects::ElectricTerrain]>0  || $fefieldeffect == 18) && skill>=PBTrainerAI.highSkill
          atk=(atk*1.5).round
        end
      end
    end
    # Battery
    if skill>=PBTrainerAI.mediumSkill
      if (attacker.pbPartner).hasWorkingAbility(:BATTERY) &&
        move.pbIsSpecial?(type)
        atk=(atk*1.3).round
      end
    end
    # Defeatist
    if skill>=PBTrainerAI.mediumSkill
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::DEFEATIST) &&
        attacker.hp<=(attacker.totalhp/2).floor
        atk=(atk*0.5).round
      end
    end
    # Pure Power, Huge Power
    if skill>=PBTrainerAI.mediumSkill
      if (((!attacker.abilitynulled && attacker.ability == PBAbilities::PUREPOWER) && $fefieldeffect!=37) ||
          (!attacker.abilitynulled && attacker.ability == PBAbilities::HUGEPOWER)) && move.pbIsPhysical?(type)
        atk=(atk*2.0).round
      end
    end
    if skill>=PBTrainerAI.highSkill
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::PUREPOWER) && $fefieldeffect==37 &&
        move.pbIsSpecial?(type)
        atk=(atk*2.0).round
      end
    end
    # Solar Power
    if skill>=PBTrainerAI.mediumSkill
      if ((!attacker.abilitynulled && attacker.ability == PBAbilities::SOLARPOWER) ||
          (isConst?(attacker.species,PBSpecies,:CASTFORM) && isConst?(attacker.item,PBItems,:CASTCREST) && attacker.form==1)) &&
        pbWeather==PBWeather::SUNNYDAY && move.pbIsSpecial?(type)
        atk=(atk*1.5).round
      end
    end
    # Flash Fire
    if skill>=PBTrainerAI.mediumSkill
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::FLASHFIRE) &&
        attacker.effects[PBEffects::FlashFire] && isConst?(type,PBTypes,:FIRE)
        atk=(atk*1.5).round
      end
    end
    # Slow Start
    if skill>=PBTrainerAI.mediumSkill
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::SLOWSTART) &&
        attacker.turncount<5 && move.pbIsPhysical?(type)
        atk=(atk*0.5).round
      end
    end
    # Flower Gift
    if skill>=PBTrainerAI.mediumSkill
      if (pbWeather==PBWeather::SUNNYDAY || $fefieldeffect == 33 || $fefieldeffect == 42 ||
          (attacker.hasWorkingItem(:CHERCREST) && isConst?(attacker.species,PBSpecies,:CHERRIM)) ||
          (attacker.pbPartner.hasWorkingItem(:CHERCREST) && isConst?(attacker.pbPartner.species,PBSpecies,:CHERRIM)) ) &&
        move.pbIsPhysical?(type)
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::FLOWERGIFT) &&
          isConst?(attacker.species,PBSpecies,:CHERRIM)
          atk=(atk*1.5).round
        end
        if attacker.pbPartner.hasWorkingAbility(:FLOWERGIFT) &&
          isConst?(attacker.pbPartner.species,PBSpecies,:CHERRIM)
          atk=(atk*1.5).round
        end
      end
    end
    # Attack-boosting items
    if skill>=PBTrainerAI.averageSkill
      if attacker.hasWorkingItem(:THICKCLUB) &&
        (isConst?(attacker.species,PBSpecies,:CUBONE) ||
          isConst?(attacker.species,PBSpecies,:MAROWAK)) && move.pbIsPhysical?(type)
        atk=(atk*2.0).round
      end
      if attacker.hasWorkingItem(:DEEPSEATOOTH) &&
        isConst?(attacker.species,PBSpecies,:CLAMPERL) && move.pbIsSpecial?(type)
        atk=(atk*2.0).round
      end
      if attacker.hasWorkingItem(:LIGHTBALL) &&
        isConst?(attacker.species,PBSpecies,:PIKACHU)
        atk=(atk*2.0).round
      end
      if attacker.hasWorkingItem(:CHOICEBAND) && move.pbIsPhysical?(type)
        atk=(atk*1.5).round
      end
      if attacker.hasWorkingItem(:CHOICESPECS) && move.pbIsSpecial?(type)
        atk=(atk*1.5).round
      end
      if isConst?(attacker.species,PBSpecies,:STANTLER) && attacker.hasWorkingItem(:STANTCREST) &&
        move.pbIsPhysical?(type)
        atk=(atk*1.5).round
      end
      if isConst?(attacker.species,PBSpecies,:HYPNO) && attacker.hasWorkingItem(:HYPCREST) &&
        move.pbIsSpecial?(type)
        atk=(atk*1.5).round
      end
      if isConst?(opponent.species,PBSpecies,:BEHEEYEM) && opponent.hasWorkingItem(:BEHECREST)
        priorityAttacker = pbGetPriority(attacker)
        priorityOpponent = pbGetPriority(opponent)
        if priorityAttacker < priorityOpponent
          atk=(atk*0.66).round
        end
      end
      if isConst?(attacker.species,PBSpecies,:SPIRITOMB) && attacker.hasWorkingItem(:SPIRITCREST)
        allyfainted = attacker.pbFaintedPokemonCount
        modifier = (allyfainted * 0.2) + 1.0
        atk=(atk*modifier).round
      end      
      if isConst?(attacker.species,PBSpecies,:DELCATTY) && isConst?(attacker.item,PBItems,:DELCREST)
        party=pbParty(attacker.index)
        for mon in party
          if !mon || mon==attacker.index || mon.hp <= 0
            next
          end
          atk+=(0.1 * mon.attack) if move.pbIsPhysical?(type)
          atk+=(0.1 * mon.spatk) if move.pbIsSpecial?(type)
        end
      end
    end
    # Victory Star Field Boosts
    if skill>=PBTrainerAI.highSkill
      if $fefieldeffect == 34 || $fefieldeffect == 35
        if (!attacker.abilitynulled && attacker.ability == PBAbilities::VICTORYSTAR)
          atk=(atk*1.5).round
        end
        partner=attacker.pbPartner
        if partner && partner.hasWorkingAbility(:VICTORYSTAR)
          atk=(atk*1.5).round
        end
      end
    end
    # Queenly Majesty Field Boosts
    if skill>=PBTrainerAI.highSkill
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::QUEENLYMAJESTY) && ($fefieldeffect==5 || $fefieldeffect==31)
        atk=(atk*1.5).round
      end
    end
    if isConst?(attacker.species,PBSpecies,:THIEVUL) &&
      isConst?(attacker.item,PBItems,:THIEVCREST)
      opposing=attacker.pbOppositeOpposing
      atk+=(0.5*opposing.attack)
    end
    # Long Reach Field Boosts
    if skill>=PBTrainerAI.highSkill
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::LONGREACH) && ($fefieldeffect==27 || $fefieldeffect==28)
        atk=(atk*1.5).round
      end
    end
    # Corrosion Field Boosts
    if skill>=PBTrainerAI.highSkill
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::CORROSION) && ($fefieldeffect==10 || $fefieldeffect==11 || $fefieldeffect==31)
        atk=(atk*1.5).round
      end
    end
    # Get base defense stat
    critrate = pbAICritRate(attacker,opponent,move)
    if critrate>=2
      defense=opponent.defense
    else
      defense=pbRoughStat(opponent,PBStats::DEFENSE,skill)
      defstage=opponent.stages[PBStats::DEFENSE]+6
    end
    applysandstorm=false
    if type>=0 && move.pbIsSpecial?(type)
      if move.function!=0x122 # Psyshock
        if critrate>=2
          defense=opponent.spdef
        else
          defense=pbRoughStat(opponent,PBStats::SPDEF,skill)
          defstage=opponent.stages[PBStats::SPDEF]+6
        end
        if opponent.species==681 && opponent.form==1
          originalform = attacker.form
          dummymon = pbAegislashStats(attacker)
          dummymon.pbUpdate
          if critrate>=2
            defense=dummymon.spdef
          else
            defense=pbRoughStat(dummymon,PBStats::SPDEF,skill)
          end
          dummymon.form = originalform
          dummymon.pbUpdate
        end
        if $fefieldeffect == 24
          gl1 = 0
          gl2 = 0
          gl3 = 0
          gl4 = 0
          avBoost = 1
          specsBoost = 1
          evioBoost = 1
          dstBoost = 1
          lbBoost = 1
          #        dewBoost = 1
          dssBoost = 1
          mpBoost = 1
          fbBoost = 1
          minusBoost = 1
          plusBoost = 1
          solarBoost = 1
          fgBoost = 1
          batteryBoost = 1
          wiseBoost = 1
          avBoost = 1.5 if opponent.hasWorkingItem(:ASSAULTVEST)
          specsBoost = 1.5 if opponent.hasWorkingItem(:CHOICESPECS)
          evioBoost = 1.5 if opponent.hasWorkingItem(:EVIOLITE) && pbGetEvolvedFormData(opponent.species).length>0
          dstBoost = 2 if opponent.hasWorkingItem(:DEEPSEATOOTH) && isConst?(opponent.species,PBSpecies,:CLAMPERL)
          lbBoost = 2 if opponent.hasWorkingItem(:LIGHTBALL) && isConst?(opponent.species,PBSpecies,:PIKACHU)
          #        dewBoost = 1.5 if opponent.hasWorkingItem(:SOULDEW) && (isConst?(opponent.species,PBSpecies,:LATIAS) || isConst?(opponent.species,PBSpecies,:LATIOS))
          dssBoost = 2 if opponent.hasWorkingItem(:DEEPSEASCALE) && isConst?(opponent.species,PBSpecies,:CLAMPERL)
          mpBoost = 1.5 if opponent.hasWorkingItem(:METALPOWDER) && isConst?(opponent.species,PBSpecies,:DITTO)
          fbBoost = 1.5 if (!opponent.abilitynulled && opponent.ability == PBAbilities::FLAREBOOST) && opponent.status==PBStatuses::BURN
          minusboost = 1.5 if (!opponent.abilitynulled && opponent.ability == PBAbilities::MINUS) && opponent.pbPartner.hasWorkingAbility(:PLUS)
          plusboost = 1.5 if (!opponent.abilitynulled && opponent.ability == PBAbilities::PLUS) && opponent.pbPartner.hasWorkingAbility(:MINUS)
          solarBoost = 1.5 if (!opponent.abilitynulled && opponent.ability == PBAbilities::SOLARPOWER) && pbWeather==PBWeather::SUNNYDAY
          fgBoost = 1.5 if (!opponent.abilitynulled && opponent.ability == PBAbilities::FLOWERGIFT) && pbWeather==PBWeather::SUNNYDAY
          batteryBoost = 1.3 if opponent.pbPartner.hasWorkingAbility(:BATTERY)
          wiseBoost = 1.1 if opponent.hasWorkingItem(:WISEGLASSES)
          gl1 = pbRoughStat(opponent,PBStats::SPATK,skill)
          gl2 = pbRoughStat(opponent,PBStats::SPDEF,skill)
          gl3 = opponent.stages[PBStats::SPDEF]+6
          gl4 = opponent.stages[PBStats::SPATK]+6
          gl2=(gl2*1.0*avBoost*evioBoost*dssBoost*fgBoost*stagemul[gl3]/stagediv[gl3]).floor
          gl1=(gl1*1.0*specsBoost*dstBoost*lbBoost*fbBoost*minusBoost*plusBoost*solarBoost*wiseBoost*batteryBoost*stagemul[gl4]/stagediv[gl4]).floor
          if gl1 > gl2
            defense=pbRoughStat(opponent,PBStats::SPATK,skill)
            if critrate>=2
              defense=opponent.spatk
            else
              defense=pbRoughStat(opponent,PBStats::SPATK,skill)
              defstage=opponent.stages[PBStats::SPATK]+6
            end
          end
        end
        applysandstorm=true
      end
    end
    if opponent.effects[PBEffects::PowerTrick]
      defense=pbRoughStat(opponent,PBStats::ATTACK,skill)
    end
    #defense=(defense*1.0*stagemul[defstage]/stagediv[defstage]).floor
    defense = 1 if (defense == 0 || !defense)
    # Sandstorm weather
    if skill>=PBTrainerAI.mediumSkill
      if pbWeather==PBWeather::SANDSTORM &&
        opponent.pbHasType?(:ROCK) && applysandstorm
        defense=(defense*1.5).round
      end
    end
    if move.pbIsSpecial?(type) && @function!=0x122
      # Glitch Specs
      if skill>=PBTrainerAI.averageSkill
        if opponent.hasWorkingItem(:CHOICESPECS) && $fefieldeffect == 24
          if gl1 > gl2
            defense=(defense*1.5).round
          end
        end
      end
      # Glitchsea Tooth
      if skill>=PBTrainerAI.averageSkill
        if opponent.hasWorkingItem(:DEEPSEATOOTH) &&
          isConst?(opponent.species,PBSpecies,:CLAMPERL) && $fefieldeffect == 24
          if gl1 > gl2
            defense=(defense*2).round
          end
        end
      end
      # Glitch Lightball
      if skill>=PBTrainerAI.averageSkill
        if opponent.hasWorkingItem(:LIGHTBALL) &&
          isConst?(opponent.species,PBSpecies,:PIKACHU) && $fefieldeffect == 24
          if gl1 > gl2
            defense=(defense*2).round
          end
        end
      end
      if skill>=PBTrainerAI.averageSkill
        if opponent.hasWorkingItem(:WISEGLASSES)  && $fefieldeffect == 24
          if gl1 > gl2
            defense=(defense*1.1).round
          end
        end
      end
      if skill>=PBTrainerAI.averageSkill 
        # Glitch Flare Boost
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::FLAREBOOST) &&
          opponent.status==PBStatuses::BURN && $fefieldeffect == 24
          if gl1 > gl2
            defense=(defense*1.5).round
          end
        end
        # Glitch Minus
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::MINUS) &&
          opponent.pbPartner.hasWorkingAbility(:PLUS) && $fefieldeffect == 24
          if gl1 > gl2
            defense=(defense*1.5).round
          end
        end
        # Glitch Plus
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::PLUS) &&
          opponent.pbPartner.hasWorkingAbility(:MINUS) && $fefieldeffect == 24
          if gl1 > gl2
            defense=(defense*1.5).round
          end
        end
        # Glitch Battery
        if opponent.pbPartner.hasWorkingAbility(:BATTERY) && $fefieldeffect == 24
          if gl1 > gl2
            defense=(defense*1.3).round
          end
        end
        # Glitch Solar Power
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::SOLARPOWER) &&
          pbWeather==PBWeather::SUNNYDAY && $fefieldeffect == 24
          if gl1 > gl2
            defense=(defense*1.5).round
          end
        end
      end
    end
    # Marvel Scale
    if skill>=PBTrainerAI.mediumSkill
      if ((!opponent.abilitynulled && opponent.ability == PBAbilities::MARVELSCALE) || SilvallyCheck(opponent, "water")) &&
        move.pbIsPhysical?(type)
        if opponent.status>0
          defense=(defense*1.5).round
        elsif ($fefieldeffect == 3 || $fefieldeffect == 9 ||
            $fefieldeffect == 31 || $fefieldeffect == 32 || $fefieldeffect == 34) &&
          skill>=PBTrainerAI.highSkill
          defense=(defense*1.5).round
        end
      end
    end
    if isConst?(opponent.species,PBSpecies,:DELCATTY) && isConst?(opponent.item,PBItems,:DELCREST)
      party=pbParty(opponent.index)
      for mon in party
        if !mon || mon==opponent.index || mon.hp <= 0
          next
        end
        defense += (0.1 * mon.defense) if move.pbIsPhysical?(type)
        defense += (0.1 * mon.spdef) if move.pbIsSpecial?(type)
      end
    end
    # Grass Pelt
    if skill>=PBTrainerAI.mediumSkill
      if isConst?(opponent.ability,PBAbilities,:GRASSPELT) && move.pbIsPhysical?(type) &&
        ($fefieldeffect == 2 || $fefieldeffect == 15 || field.effects[PBEffects::GrassyTerrain]>0) # Grassy Field
        defense=(defense*1.5).round
      end
    end
    if skill>=PBTrainerAI.mediumSkill
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::STALWART) && move.pbIsPhysical?(type) && !(opponent.moldbroken) && (PBStuff::SYNTHETICFIELDS).include?($fefieldeffect)
        defense=(defense*2).round
      end
    end
    # Fluffy
    if skill>=PBTrainerAI.mediumSkill
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::FLUFFY) && !(opponent.moldbroken)
        if move.isContactMove? && !(!attacker.abilitynulled && attacker.ability == PBAbilities::LONGREACH)
          defense=(defense*2).round
        end
        if isConst?(type,PBTypes,:FIRE)
          defense=(defense*0.5).round
        end
      end
    end
    # Fur Coat
    if skill>=PBTrainerAI.mediumSkill
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::FURCOAT) && move.pbIsPhysical?(type) && !(opponent.moldbroken) && 
        defense=(defense*2).round
      end
    end
    # Ice Scales
    if skill>=PBTrainerAI.mediumSkill
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::ICESCALES) && move.pbIsSpecial?(type) && !(opponent.moldbroken) && 
        defense=(defense*2).round
      end
    end
    # Various field boosts
    if skill>=PBTrainerAI.highSkill
      if $fefieldeffect == 3 && move.pbIsSpecial?(type) &&
        opponent.pbHasType?(:FAIRY)
        defense=(defense*1.5).round
      end
      if $fefieldeffect == 12 && move.pbIsSpecial?(type) &&
        opponent.pbHasType?(:GROUND)
        defense=(defense*1.5).round
      end
      if $fefieldeffect == 22 && move.pbIsPhysical?(type) &&
        !isConst?(type,PBTypes,:WATER)
        defense=(defense*1.5).round
      end
    end
    # Flower Gift
    if skill>=PBTrainerAI.mediumSkill
      if (pbWeather==PBWeather::SUNNYDAY || $fefieldeffect == 33 || $fefieldeffect == 42 ||
          (opponent.hasWorkingItem(:CHERCREST) && isConst?(opponent.species,PBSpecies,:CHERRIM)) ||
          (opponent.pbPartner.hasWorkingItem(:CHERCREST) && isConst?(opponent.pbPartner.species,PBSpecies,:CHERRIM)) ) &&
        move.pbIsSpecial?(type)
        if (!opponent.abilitynulled && opponent.ability == PBAbilities::FLOWERGIFT) &&
          isConst?(opponent.species,PBSpecies,:CHERRIM)
          defense=(defense*1.5).round
        end
        if opponent.pbPartner.hasWorkingAbility(:FLOWERGIFT) &&
          isConst?(opponent.pbPartner.species,PBSpecies,:CHERRIM)
          defense=(defense*1.5).round
        end
      end
    end
    # Glitch Field Explosion
    if move.function==0xE0 && $fefieldeffect==24 
      defense=(defense*0.5).round
    end
    # Defense-boosting items
    if skill>=PBTrainerAI.averageSkill
      if opponent.hasWorkingItem(:EVIOLITE)
        evos=pbGetEvolvedFormData(opponent.species)
        if evos && evos.length>0
          defense=(defense*1.5).round
        end
      end
      if opponent.hasWorkingItem(:ASSAULTVEST) && move.pbIsSpecial?(type)
        defense=(defense*1.5).round
      end
      if opponent.hasWorkingItem(:DEEPSEASCALE) &&
        isConst?(opponent.species,PBSpecies,:CLAMPERL) && move.pbIsSpecial?(type)
        defense=(defense*2.0).round
      end
      if opponent.hasWorkingItem(:METALPOWDER) &&
        isConst?(opponent.species,PBSpecies,:DITTO) &&
        !opponent.effects[PBEffects::Transform] && move.pbIsPhysical?(type)
        defense=(defense*2.0).round
      end
      #      if opponent.hasWorkingItem(:SOULDEW) &&
      #         (isConst?(opponent.species,PBSpecies,:LATIAS) ||
      #         isConst?(opponent.species,PBSpecies,:LATIOS)) && move.pbIsSpecial?(type)
      #        defense=(defense*1.5).round
      #      end
    end
    # Prism Armor & Shadow Shield
    if skill>=PBTrainerAI.highSkill
      if ((!attacker.abilitynulled && attacker.ability == PBAbilities::PRISMARMOR) ||
          (!attacker.abilitynulled && attacker.ability == PBAbilities::SHADOWSHIELD)) && $fefieldeffect==4
        defense=(defense*2.0).round
      end
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::PRISMARMOR) && ($fefieldeffect==9 || $fefieldeffect==25)
        defense=(defense*2.0).round
      end
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::SHADOWSHIELD) && ($fefieldeffect==34 || $fefieldeffect==35)
        defense=(defense*2.0).round
      end
    end
    # Main damage calculation
    damage=(((2.0*attacker.level/5+2).floor*basedamage*atk/defense).floor/50).floor+2 if basedamage >= 0
    # Multi-targeting attacks
    if skill>=PBTrainerAI.mediumSkill
      if move.pbTargetsAll?(attacker)
        damage=(damage*0.75).round
      end
    end
    # Terrain Boosts
    if @field.effects[PBEffects::ElectricTerrain]>0 && $fefieldeffect!=1 && $fefieldeffect!=18  
      if isConst?(type,PBTypes,:ELECTRIC)
        isgrounded=pbTypeModifierAI(PBTypes::GROUND,opponent,attacker)
        if $fefieldeffect==22
          damage=(damage*2).floor
        elsif isgrounded != 0 || $fefieldeffect==17 || $fefieldeffect==21 || $fefieldeffect==26
          damage=(damage*1.5).floor
        end
      end      
    end  
    if isConst?(type,PBTypes,:GRASS) && @field.effects[PBEffects::GrassyTerrain]>0 && $fefieldeffect!=2
      isgrounded=pbTypeModifierAI(PBTypes::GROUND,opponent,attacker)
      if $fefieldeffect==33
        case $fecounter
        when 1
          damage=(damage*1.5).floor
        when 2
          damage=(damage*1.5).floor            
        when 3
          damage=(damage*2).floor            
        when 4
          damage=(damage*3).floor
        end
      elsif isgrounded != 0 || $fefieldeffect==2 || $fefieldeffect==14
        damage=(damage*1.3).floor
      end
    end  
    if isConst?(type,PBTypes,:FAIRY) && @field.effects[PBEffects::MistyTerrain]>0 && $fefieldeffect!=3 
      damage=(damage*1.5).floor
    end
    if @field.effects[PBEffects::PsychicTerrain]>0 && $fefieldeffect!=37    
      if isConst?(type,PBTypes,:PSYCHIC)
        isgrounded=pbTypeModifierAI(PBTypes::GROUND,opponent,attacker)
        if isgrounded != 0  || $fefieldeffect==24 || $fefieldeffect==29 || $fefieldeffect==34
          damage=(damage*1.5).floor
        end
      end      
    end  
    # Field Boosts
    if skill>=PBTrainerAI.highSkill
      case $fefieldeffect
      when 1 # Electric Field
        if isConst?(type,PBTypes,:ELECTRIC)
          isgrounded=pbTypeModifierAI(PBTypes::GROUND,opponent,attacker)
          if isgrounded != 0
            damage=(damage*1.5).floor
          end
        end
      when 2 # Grassy Field
        if isConst?(type,PBTypes,:GRASS)
          isgrounded=pbTypeModifierAI(PBTypes::GROUND,opponent,attacker)
          if isgrounded != 0
            damage=(damage*1.5).floor
          end
        end
        if isConst?(type,PBTypes,:FIRE)
          isgrounded=pbTypeModifierAI(PBTypes::GROUND,attacker,opponent)
          if isgrounded != 0
            damage=(damage*1.5).floor
          end
        end
      when 3 # Misty Field
        if isConst?(type,PBTypes,:DRAGON)
          damage=(damage*0.5).floor
        end
        if isConst?(type,PBTypes,:FAIRY)
          damage=(damage*1.5).floor
        end
      when 7 # Burning Field
        if isConst?(type,PBTypes,:FIRE)
          isgrounded=pbTypeModifierAI(PBTypes::GROUND,opponent,attacker)
          if isgrounded != 0
            damage=(damage*1.5).floor
          end
        end
        if isConst?(type,PBTypes,:GRASS)
          isgrounded=pbTypeModifierAI(PBTypes::GROUND,attacker,opponent)
          if isgrounded != 0
            damage=(damage*0.5).floor
          end
        end
        if isConst?(type,PBTypes,:ICE)
          damage=(damage*0.5).floor
        end
      when 8 # Swamp Field
        if isConst?(type,PBTypes,:POISON)
          isgrounded=pbTypeModifierAI(PBTypes::GROUND,attacker,opponent)
          if isgrounded != 0
            damage=(damage*1.5).floor
          end
        end
      when 9 # Rainbow Field
        if isConst?(type,PBTypes,:NORMAL)
          damage=(damage*1.5).floor
        end
      when 11 # Corrosive Field
        if isConst?(type,PBTypes,:FIRE)
          damage=(damage*1.5).floor
        end
      when 12 # DESERT Field
        if isConst?(type,PBTypes,:WATER)  && move.id!=PBMoves::SCALD && move.id!=PBMoves::STEAMERUPTION
          isgrounded=pbTypeModifierAI(PBTypes::GROUND,opponent,attacker)
          if isgrounded != 0
            damage=(damage*0.5).floor
          end
        end
        if isConst?(type,PBTypes,:ELECTRIC)
          isgrounded=pbTypeModifierAI(PBTypes::GROUND,attacker,opponent)
          if isgrounded != 0
            damage=(damage*0.5).floor
          end
        end
      when 13 # Icy Field
        if isConst?(type,PBTypes,:FIRE)
          damage=(damage*0.5).floor
        end
        if isConst?(type,PBTypes,:ICE)
          damage=(damage*1.5).floor
        end
      when 14 # Rocky Field
        if isConst?(type,PBTypes,:ROCK)
          damage=(damage*1.5).floor
        end
      when 15 # Forest Field
        if isConst?(type,PBTypes,:GRASS) && @field.effects[PBEffects::GrassyTerrain]==0
          damage=(damage*1.5).floor
        end
        if isConst?(type,PBTypes,:BUG) &&
          !move.pbIsPhysical?(move.pbType(type,attacker,opponent))
          damage=(damage*1.5).floor
        end
      when 16 # Volcanic Top Field
        if isConst?(type,PBTypes,:FIRE)
          damage=(damage*1.2).floor
        end
        if isConst?(type,PBTypes,:ICE)
          damage=(damage*0.5).floor
        end
        if isConst?(type,PBTypes,:WATER) && move.id!=PBMoves::STEAMERUPTION
          if move.pbIsPhysical?(move.pbType(type,attacker,opponent))
            damage=(damage*0.9).floor
          else
            damage=(damage*0.5).floor
          end
        end
      when 17 # Factory Field
        if isConst?(type,PBTypes,:ELECTRIC) && @field.effects[PBEffects::ElectricTerrain]==0
          damage=(damage*1.2).floor
        end
      when 21 # Water Surface
        if isConst?(type,PBTypes,:WATER)
          damage=(damage*1.5).floor
        end
        if isConst?(type,PBTypes,:ELECTRIC) && @field.effects[PBEffects::ElectricTerrain]==0
          damage=(damage*1.5).floor
        end
        if isConst?(type,PBTypes,:FIRE)
          isgrounded=pbTypeModifierAI(PBTypes::GROUND,attacker,opponent)
          if isgrounded != 0
            damage=(damage*0.5).floor
          end
        end
      when 22 # Underwater
        if isConst?(type,PBTypes,:WATER)
          damage=(damage*1.5).floor
        end
        if isConst?(type,PBTypes,:ELECTRIC) && @field.effects[PBEffects::ElectricTerrain]==0
          damage=(damage*2).floor
        end
      when 23 # Cave
        if isConst?(type,PBTypes,:FLYING) && !(move.isContactMove?) #not a contact move
          damage=(damage*0.5).floor
        end
        if isConst?(type,PBTypes,:ROCK)
          damage=(damage*1.5).floor
        end
      when 24 # Glitch
        if isConst?(type,PBTypes,:PSYCHIC) && @field.effects[PBEffects::PsychicTerrain]==0
          damage=(damage*1.2).floor
        end
      when 25 # Crystal Cavern
        if isConst?(type,PBTypes,:ROCK)
          damage=(damage*1.5).floor
        end
        if isConst?(type,PBTypes,:DRAGON)
          damage=(damage*1.5).floor
        end
      when 26 # Murkwater Surface
        if isConst?(type,PBTypes,:WATER) || isConst?(type,PBTypes,:POISON)
          damage=(damage*1.5).floor
        end
        if isConst?(type,PBTypes,:ELECTRIC)  && @field.effects[PBEffects::ElectricTerrain]==0
          damage=(damage*1.5).floor
        end
      when 27 # Mountain
        if isConst?(type,PBTypes,:ROCK)
          damage=(damage*1.5).floor
        end
        if isConst?(type,PBTypes,:FLYING)
          damage=(damage*1.5).floor
        end
        if isConst?(type,PBTypes,:FLYING) &&
          !move.pbIsPhysical?(move.pbType(type,attacker,opponent)) &&
          pbWeather==PBWeather::STRONGWINDS
          damage=(damage*1.5).floor
        end
      when 28 # Snowy Mountain
        if isConst?(type,PBTypes,:ROCK) || isConst?(type,PBTypes,:ICE)
          damage=(damage*1.5).floor
        end
        if isConst?(type,PBTypes,:FLYING)
          damage=(damage*1.5).floor
        end
        if isConst?(type,PBTypes,:FLYING) &&
          !move.pbIsPhysical?(move.pbType(type,attacker,opponent)) &&
          pbWeather==PBWeather::STRONGWINDS
          damage=(damage*1.5).floor
        end
        if isConst?(type,PBTypes,:FIRE)
          damage=(damage*0.5).floor
        end
      when 29 # Holy Field
        if isConst?(type,PBTypes,:GHOST) || (isConst?(type,PBTypes,:DARK) &&
            !move.pbIsPhysical?(move.pbType(type,attacker,opponent)))
          damage=(damage*0.5).floor
        end
        if (isConst?(type,PBTypes,:FAIRY) && @field.effects[PBEffects::MistyTerrain]==0) || (isConst?(type,PBTypes,:NORMAL) &&
            !move.pbIsPhysical?(move.pbType(type,attacker,opponent)))
          damage=(damage*1.5).floor
        end
        if (isConst?(type,PBTypes,:PSYCHIC) && @field.effects[PBEffects::PsychicTerrain]==0) || isConst?(type,PBTypes,:DRAGON)
          damage=(damage*1.2).floor
        end
      when 31# Fairy Tale
        if isConst?(type,PBTypes,:STEEL)
          damage=(damage*1.5).floor
        end
        if isConst?(type,PBTypes,:FAIRY) && @field.effects[PBEffects::MistyTerrain]==0
          damage=(damage*1.5).floor
        end
        if isConst?(type,PBTypes,:DRAGON)
          damage=(damage*2).floor
        end
      when 32 # Dragon's Den
        if isConst?(type,PBTypes,:ROCK)
          damage=(damage*1.3).floor
        end
        if isConst?(type,PBTypes,:FIRE)
          damage=(damage*1.5).floor
        end
        if isConst?(type,PBTypes,:ICE) || isConst?(type,PBTypes,:WATER)
          damage=(damage*0.5).floor
        end
        if isConst?(type,PBTypes,:DRAGON)
          damage=(damage*1.5).floor
        end
        if isConst?(type,PBTypes,:ROCK) && @basefield==23
          damage=(damage*1.5).floor
        end
        if isConst?(type,PBTypes,:POISON) && @basefield==41
          damage=(damage*1.5).floor
        end
      when 33 # Flower Field
        if isConst?(type,PBTypes,:GRASS) && @field.effects[PBEffects::GrassyTerrain]==0
          case $fecounter
          when 1
            damage=(damage*1.2).floor
          when 2
            damage=(damage*1.5).floor
          when 3
            damage=(damage*2).floor
          when 4
            damage=(damage*3).floor
          end
        end
        if $fecounter > 1
          if isConst?(type,PBTypes,:FIRE)
            damage=(damage*1.5).floor
          end
        end
        if $fecounter > 3
          if isConst?(type,PBTypes,:BUG)
            damage=(damage*2).floor
          end
        elsif $fecounter > 1
          if isConst?(type,PBTypes,:BUG)
            damage=(damage*1.5).floor
          end
        end
      when 34 # Starlight Arena
        if isConst?(type,PBTypes,:DARK)
          damage=(damage*1.5).floor
        end
        if isConst?(type,PBTypes,:PSYCHIC) && @field.effects[PBEffects::PsychicTerrain]==0
          damage=(damage*1.5).floor
        end
        if isConst?(type,PBTypes,:FAIRY) && @field.effects[PBEffects::MistyTerrain]==0
          damage=(damage*1.3).floor
        end
      when 35 # New World
        if isConst?(type,PBTypes,:DARK)
          damage=(damage*1.5).floor
        end
      when 37 # Psychic Terrain
        if isConst?(type,PBTypes,:PSYCHIC)
          isgrounded=pbTypeModifierAI(PBTypes::GROUND,opponent,attacker)
          if isgrounded != 0
            damage=(damage*1.5).floor
          end
        end
      when 38 # Dimensional Field
        if isConst?(type,PBTypes,:DARK) || isConst?(type,PBTypes,:SHADOW)
          damage=(damage*1.5).floor
        end
        if isConst?(type,PBTypes,:GHOST) 
          damage=(damage*1.2).floor
        end
        if isConst?(type,PBTypes,:FAIRY)
          damage=(damage*0.5).floor
        end
      when 39 # Frozen Dimensional Field
        if isConst?(type,PBTypes,:ICE)
          damage=(damage*1.5).floor
        end
        if isConst?(type,PBTypes,:DARK)
          damage=(damage*1.2).floor
        end
        if isConst?(type,PBTypes,:FIRE)
          damage=(damage*0.5).floor
        end
      when 40 # Haunted Field
        if isConst?(type,PBTypes,:GHOST)
          damage=(damage*1.5).floor
        end
      when 41 # Corrupted Cave
        if isConst?(type,PBTypes,:POISON)
          damage=(damage*1.5).floor
        end
        if isConst?(type,PBTypes,:ROCK) || isConst?(type,PBTypes,:GRASS)
          damage=(damage*1.2).floor
        end
        if isConst?(type,PBTypes,:FAIRY)
          damage=(damage*0.5).floor
        end
        if isConst?(type,PBTypes,:FLYING) && !(move.isContactMove?) #not a contact move
          damage=(damage*0.5).floor
        end
      when 42 # Bewitched Woods
        if isConst?(type,PBTypes,:DARK)
          damage=(damage*1.3).floor
        end
        if (isConst?(type,PBTypes,:FAIRY) && @field.effects[PBEffects::MistyTerrain]==0) || (isConst?(type,PBTypes,:GRASS) && @field.effects[PBEffects::GrassyTerrain]==0)
          damage=(damage*1.5).floor
        end
      when 43 # Sky Field
        if isConst?(type,PBTypes,:FLYING)
          damage=(damage*1.5).floor
        end
      when 44 # Colosseum Field  
        if isConst?(type,PBTypes,:FLYING)  
          damage=(damage*0.5).floor  
        end  
      when 45 # Infernal Field  
        if isConst?(type,PBTypes,:FIRE) || isConst?(type,PBTypes,:DARK)  
          damage=(damage*1.5).floor  
        end  
        if isConst?(type,PBTypes,:FAIRY) || isConst?(type,PBTypes,:WATER)  
          if (move.id != PBMoves::SPIRITBREAK)  
            damage=(damage*0.5).floor  
          end  
        end
      end
    end
    if skill>=PBTrainerAI.highSkill
      # FIELD TRANSFORMATIONS
      case $fefieldeffect
      when 2 # Grassy Field
        if (move.id == PBMoves::SLUDGEWAVE || move.id == PBMoves::ACIDDOWNPOUR)
          damage=(damage*1.3).floor if damage >= 0
        end
      when 3 # Misty Field
        if (move.id == PBMoves::WHIRLWIND || move.id == PBMoves::GUST ||
            move.id == PBMoves::RAZORWIND || move.id == PBMoves::HURRICANE||
            move.id == PBMoves::DEFOG || move.id == PBMoves::TAILWIND ||
            move.id == PBMoves::TWISTER || move.id == PBMoves::SUPERSONICSKYSTRIKE)
          damage=(damage*1.3).floor if damage >= 0
        end
        if (move.id == PBMoves::CLEARSMOG || move.id == PBMoves::SMOG ||
            move.id == PBMoves::POISONGAS || move.id == PBMoves::ACIDDOWNPOUR)
          damage=(damage*1.3).floor if damage >= 0
        end
      when 4 # Dark Crystal Cavern
        if (move.id == PBMoves::EARTHQUAKE || move.id == PBMoves::BULLDOZE ||
            move.id == PBMoves::MAGNITUDE || move.id == PBMoves::TECTONICRAGE)
          damage=(damage*1.3).floor if damage >= 0
        end
      when 7 # Volcanic Field
        if (move.id == PBMoves::SLUDGEWAVE || move.id == PBMoves::CONTINENTALCRUSH)
          damage=(damage*1.3).floor if damage >= 0
        end
        if (move.id == PBMoves::WHIRLWIND || move.id == PBMoves::GUST ||
            move.id == PBMoves::RAZORWIND || move.id == PBMoves::DEFOG ||
            move.id == PBMoves::TAILWIND || move.id == PBMoves::HURRICANE)
          damage=(damage*1.3).floor if damage >= 0
        end
        if (move.id == PBMoves::SURF || move.id == PBMoves::MUDDYWATER ||
            move.id == PBMoves::WATERSPORT || move.id == PBMoves::WATERSPOUT ||
            move.id == PBMoves::WATERPLEDGE || move.id == PBMoves::SPARKLINGARIA
            move.id == PBMoves::HYDROVORTEX || move.id == PBMoves::OCEANICOPERETTA)
          damage=(damage*1.3).floor if damage >= 0
        end
        if (move.id == PBMoves::SANDTOMB)
          damage=(damage*1.3).floor if damage >= 0
        end
        if (move.id == PBMoves::BLIZZARD || move.id == PBMoves::SUBZEROSLAMMER)
          damage=(damage*1.3).floor if damage >= 0
        end
      when 10 # Corrosive Field
        if (move.id == PBMoves::SEEDFLARE)
          damage=(damage*1.3).floor if damage >= 0
        end
      when 11 # Corrosive Mist Field
        if (move.id == PBMoves::HEATWAVE || move.id == PBMoves::ERUPTION ||
            move.id == PBMoves::SEARINGSHOT || move.id == PBMoves::FLAMEBURST ||
            move.id == PBMoves::LAVAPLUME || move.id == PBMoves::FIREPLEDGE ||
            move.id == PBMoves::EXPLOSION || move.id == PBMoves::SELFDESTRUCT ||
            move.id == PBMoves::TWISTER || move.id == PBMoves::INFERNOOVERDRIVE)
          damage=(damage*1.3).floor if damage >= 0
        end
        if (move.id == PBMoves::GUST || move.id == PBMoves::HURRICANE ||
            move.id == PBMoves::RAZORWIND || move.id == PBMoves::SUPERSONICSKYSTRIKE)
          damage=(damage*1.3).floor if damage >= 0
        end
      when 13 # Icy Field
        if (move.id == PBMoves::HEATWAVE || move.id == PBMoves::ERUPTION ||
            move.id == PBMoves::SEARINGSHOT || move.id == PBMoves::FLAMEBURST ||
            move.id == PBMoves::LAVAPLUME || move.id == PBMoves::FIREPLEDGE ||
            move.id == PBMoves::INFERNOOVERDRIVE || move.id == PBMoves::LAVASURF)
          damage=(damage*1.3).floor if damage >= 0
        end
        if (move.id == PBMoves::EARTHQUAKE || move.id == PBMoves::MAGNITUDE ||
            move.id == PBMoves::BULLDOZE || move.id == PBMoves::TECTONICRAGE)
          damage=(damage*1.3).floor if damage >= 0
        end
      when 16 # Volcanic Top Field
        if (move.id == PBMoves::BLIZZARD || move.id == PBMoves::GLACIATE || move.id == PBMoves::SUBZEROSLAMMER)
          damage=(damage*1.3).floor if damage >= 0
        end
        if (move.id == PBMoves::FLY || move.id == PBMoves::BOUNCE || move.id == PBMoves::HEAVENLYWING)
          damage=(damage*1.3).floor if damage >= 0
        end
      when 17 # Factory Field
        if (move.id == PBMoves::DISCHARGE || move.id == PBMoves::GIGAVOLTHAVOC || move.id == PBMoves::AURAWHEEL
            move.id == PBMoves::EXPLOSION || move.id == PBMoves::CORKSCREWCRASH || move.id == PBMoves::OVERDRIVE)
          damage=(damage*1.3).floor if damage >= 0
        end
        if (move.id == PBMoves::EXPLOSION || move.id == PBMoves::SELFDESTRUCT ||
            move.id == PBMoves::MAGNITUDE || move.id == PBMoves::EARTHQUAKE ||
            move.id == PBMoves::BULLDOZE || move.id == PBMoves::TECTONICRAGE)
          damage=(damage*1.3).floor if damage >= 0
        end
      when 18 # Shortcircuit Field
        if (move.id == PBMoves::DISCHARGE || move.id == PBMoves::GIGAVOLTHAVOC || move.id == PBMoves::AURAWHEEL)
          damage=(damage*1.3).floor if damage >= 0
        end
        if (move.id == PBMoves::PARABOLICCHARGE ||
            move.id == PBMoves::WILDCHARGE || move.id == PBMoves::CHARGEBEAM)
          damage=(damage*1.3).floor if damage >= 0
        end
      when 21 # Water Surface
        if (move.id == PBMoves::DIVE || move.id == PBMoves::ANCHORSHOT)
          damage=(damage*1.3).floor if damage >= 0
        end
        if (move.id == PBMoves::BLIZZARD || move.id == PBMoves::GLACIATE || move.id == PBMoves::SUBZEROSLAMMER)
          damage=(damage*1.3).floor if damage >= 0
        end
        if (move.id == PBMoves::SLUDGEWAVE || move.id == PBMoves::ACIDDOWNPOUR)
          damage=(damage*1.3).floor if damage >= 0
        end
      when 22 # Underwater
        if (move.id == PBMoves::DIVE || move.id == PBMoves::SKYDROP ||
            move.id == PBMoves::FLY || move.id == PBMoves::BOUNCE)
          damage=(damage*1.3).floor if damage >= 0
        end
        if (move.id == PBMoves::SLUDGEWAVE || move.id == PBMoves::ACIDDOWNPOUR)
          damage=(damage*2).floor if damage >= 0
        end
      when 23 # Cave Field
        if (move.id == PBMoves::POWERGEM || move.id == PBMoves::DIAMONDSTORM)
          damage=(damage*1.3).floor if damage >= 0
        end
        if (move.id == PBMoves::HOTTEMPO || move.id == PBMoves::LAVASURF ||
            move.id == PBMoves::ERUPTION || move.id == PBMoves::LAVAPLUME ||
            move.id == PBMoves::HEATWAVE || move.id == PBMoves::INFERNO ||
            move.id == PBMoves::OVERHEAT || move.id == PBMoves::FIRELASH ||
            move.id == PBMoves::FUSIONFLARE)
          damage=(damage*1.3).floor if damage >= 0
        end
        if (move.id == PBMoves::SLUDGEWAVE || move.id == PBMoves::ACIDDOWNPOUR)
          damage=(damage*1.3).floor if damage >= 0
        end
        if (move.id == PBMoves::BLIZZARD || move.id == PBMoves::DRACOMETEOR || move.id == PBMoves::DRAGONPULSE ||
            move.id == PBMoves::SUBZEROSLAMMER)
          damage=(damage*1.3).floor if damage >= 0
        end
      when 25 # Crystal Cavern
        if (move.id == PBMoves::DARKPULSE || move.id == PBMoves::NIGHTDAZE ||
            move.id == PBMoves::BULLDOZE|| move.id == PBMoves::EARTHQUAKE ||
            move.id == PBMoves::MAGNITUDE || move.id == PBMoves::TECTONICRAGE)
          damage=(damage*1.3).floor if damage >= 0
        end
      when 26 # Murkwater Surface
        if (move.id == PBMoves::BLIZZARD || move.id == PBMoves::GLACIATE ||
            move.id == PBMoves::WHIRLPOOL || move.id == PBMoves::HYDROVORTEX || move.id == PBMoves::SUBZEROSLAMMER)
          damage=(damage*1.3).floor if damage >= 0
        end
        if (move.id == PBMoves::SEEDFLARE)
          damage=(damage*1.3).floor if damage >= 0
        end
      when 27 # Mountain
        if (move.id == PBMoves::BLIZZARD || move.id == PBMoves::SUBZEROSLAMMER)
          damage=(damage*1.3).floor if damage >= 0
        end
        if (move.id == PBMoves::LAVAPLUME || move.id == PBMoves::LAVASURF ||
            move.id == PBMoves::ERUPTION)
          damage=(damage*1.3).floor if damage >= 0
        end
        if (move.id == PBMoves::FLY || move.id == PBMoves::BOUNCE || move.id == PBMoves::HEAVENLYWING)
          damage=(damage*1.3).floor if damage >= 0
        end
      when 28 # Snowy Mountain
        if (move.id == PBMoves::HEATWAVE || move.id == PBMoves::FLAMEBURST ||
            move.id == PBMoves::LAVAPLUME || move.id == PBMoves::SEARINGSHOT ||
            move.id == PBMoves::FIREPLEDGE || move.id == PBMoves::ACIDDOWNPOUR)
          damage=(damage*1.3).floor if damage >= 0
        end
        if (move.id == PBMoves::FLY || move.id == PBMoves::BOUNCE || move.id == PBMoves::HEAVENLYWING)
          damage=(damage*1.3).floor if damage >= 0
        end
        if (move.id == PBMoves::ERUPTION || move.id == PBMoves::LAVASURF)
          damage=(damage*1.3).floor if damage >= 0
        end
      when 29 # Holy Field
        if (move.id == PBMoves::SHADOWFORCE || move.id == PBMoves::OMINOUSWIND || 
            move.id == PBMoves::SPECTRALSCREAM || move.id == PBMoves::NEVERENDINGNIGHTMARE)
          damage=(damage*1.3).floor if damage >= 0
        end
      when 30 # Mirror Arena
        if (move.id == PBMoves::BOOMBURST || move.id == PBMoves::BULLDOZE ||
            move.id == PBMoves::HYPERVOICE || move.id == PBMoves::EARTHQUAKE ||
            move.id == PBMoves::MAGNITUDE)
          damage=(damage*1.3).floor if damage >= 0
        end
      when 32 # Dragon's Den
        if (move.id == PBMoves::GLACIATE)
          damage=(damage*1.3).floor if damage >= 0
        end
        if (move.id == PBMoves::MISTBALL)
          damage=(damage*1.3).floor if damage >= 0
        end
      when 33 # Flower Garden Field
        if $fecounter > 1
          if (move.id == PBMoves::HEATWAVE || move.id == PBMoves::ERUPTION ||
              move.id == PBMoves::SEARINGSHOT || move.id == PBMoves::FLAMEBURST ||
              move.id == PBMoves::LAVAPLUME || move.id == PBMoves::FIREPLEDGE || 
              move.id == PBMoves::INFERNOOVERDRIVE) &&
            field.effects[PBEffects::WaterSport] <= 0 &&
            pbWeather != PBWeather::RAINDANCE
            damage=(damage*1.3).floor if damage >= 0
          end
        end
      when 38 # Dimensional Field
        if (move.id == PBMoves::BLIZZARD || move.id == PBMoves::COLDTRUTH ||
            move.id == PBMoves::ICEBURN || move.id == PBMoves::FREEZESHOCK ||
            move.id == PBMoves::GLACIATE || move.id == PBMoves::SUBZEROSLAMMER)
          damage=(damage*1.3).floor if damage >= 0
        end
        if (move.id == PBMoves::SEEDFLARE)
          damage=(damage*1.3).floor if damage >= 0
        end
      when 39 # Frozen Dimensional Field
        if (move.id == PBMoves::BLASTBURN || move.id == PBMoves::INFERNO ||
            move.id == PBMoves::LAVAPLUME || move.id == PBMoves::HEATWAVE ||
            move.id == PBMoves::ERUPTION || move.id == PBMoves::FLAMEBURST ||
            move.id == PBMoves::BURNUP || move.id == PBMoves::INFERNOOVERDRIVE)
          damage=(damage*1.3).floor if damage >= 0
        end
        if (move.id == PBMoves::SEEDFLARE)
          damage=(damage*1.3).floor if damage >= 0
        end
      when 40 # Haunted Field
        if (move.id == PBMoves::JUDGMENT || move.id == PBMoves::ORIGINPULSE ||
            move.id == PBMoves::SACREDFIRE)
          damage=(damage*1.3).floor if damage >= 0
        end
      when 41 # Corrupted Cave
        if (move.id == PBMoves::HEATWAVE || move.id == PBMoves::BLASTBURN ||
            move.id == PBMoves::ERUPTION || move.id == PBMoves::LAVAPLUME)
          damage=(damage*1.3).floor if damage >= 0
        end
        if (move.id == PBMoves::SOLARBLADE || move.id == PBMoves::SOLARBEAM ||
            move.id == PBMoves::SEEDFLARE)
          damage=(damage*1.3).floor if damage >= 0
        end
      when 43 # Sky Field
        if (move.id == PBMoves::SMACKDOWN || move.id == PBMoves::THOUSANDARROWS ||
            move.id == PBMoves::GRAVAPPLE)
          damage=(damage*1.3).floor if damage >= 0
        end
      end
    end
    # Weather
    if skill>=PBTrainerAI.mediumSkill
      case pbWeather
      when PBWeather::SUNNYDAY
        if field.effects[PBEffects::HarshSunlight] &&
          isConst?(type,PBTypes,:WATER)
          damage=0
        end
        if isConst?(type,PBTypes,:FIRE)
          damage=(damage*1.5).round
        elsif isConst?(type,PBTypes,:WATER)
          damage=(damage*0.5).round
        end
      when PBWeather::RAINDANCE
        if field.effects[PBEffects::HeavyRain] &&
          isConst?(type,PBTypes,:FIRE)
          damage=0
        end
        if isConst?(type,PBTypes,:FIRE)
          damage=(damage*0.5).round
        elsif isConst?(type,PBTypes,:WATER)
          damage=(damage*1.5).round
        end
      end
    end
    if skill>=PBTrainerAI.mediumSkill
      # Water Bubble
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::WATERBUBBLE) && type == PBTypes::WATER
        damage=(damage*=2).round
      end
      # Punk Rock
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::PUNKROCK) && move.isSoundBased?
        if ($fefieldeffect == 6 || $fefieldeffect == 23)
          damage=(damage*=1.5).round
        else
          damage=(damage*=1.3).round
        end
      end
      # Power Spot
      if (!attacker.pbPartner.abilitynulled && attacker.pbPartner.ability == PBAbilities::POWERSPOT) 
        if ($fefieldeffect == 29 || $fefieldeffect == 37 || 
            $fefieldeffect == 40 ||$fefieldeffect == 42)
          damage=(damage*1.5).round
        else
          damage=(damage*1.3).round
        end
      end
      # Steely Spirit
      if ((!attacker.abilitynulled && attacker.ability == PBAbilities::STEELYSPIRIT) || (!attacker.pbPartner.abilitynulled && attacker.pbPartner.ability == PBAbilities::STEELYSPIRIT))  && type == PBTypes::STEEL
        if $fefieldeffect == 31
          damage=(damage*=2).round
        else
          damage=(damage*=1.5).round
        end
      end
    end
    # STAB
    if (((attacker.pbHasType?(type)) || attacker.isShadow? && (type==attacker.pokemon.type1 || type==attacker.pokemon.type2) || (!attacker.abilitynulled && attacker.ability == PBAbilities::PROTEAN) || (!attacker.abilitynulled && attacker.ability == PBAbilities::LIBERO)) && !((attacker.pokemon.species == PBSpecies::SILVALLY) && SilvallyCheck(attacker,type))) && !(attacker.effects[PBEffects::DesertsMark])
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::ADAPTABILITY)
        damage=(damage*=2).round
      else
        damage=(damage*=1.5).round
      end
    elsif attacker.species==PBSpecies::PARASECT && attacker.form==2
      if (type==attacker.type1 || type==attacker.type2)
        damage=(damage*=1.5).round
      end
    elsif (attacker.pokemon.species == PBSpecies::SILVALLY) && SilvallyCheck(attacker,type)
      damage=(damage*=1.8).round
    elsif ((!attacker.abilitynulled && attacker.ability == PBAbilities::STEELWORKER) && move.type == PBTypes::STEEL) 
      if $fefieldeffect==17 # Factory Field
        damage=(damage*=2).round
      else
        damage=(damage*=1.5).round
      end
    elsif (((attacker.pokemon.species == PBSpecies::EMPOLEON) && attacker.hasWorkingItem(:EMPCREST) && move.type == PBTypes::ICE) ||
        ((attacker.pokemon.species == PBSpecies::LUXRAY) && attacker.hasWorkingItem(:LUXCREST) && move.type == PBTypes::DARK) ||
        ((attacker.pokemon.species == PBSpecies::SAMUROTT) && attacker.hasWorkingItem(:SAMUCREST) && move.type == PBTypes::FIGHTING) ||
        ((attacker.pokemon.species == PBSpecies::NOCTOWL) && attacker.hasWorkingItem(:NOCCREST) && move.type == PBTypes::PSYCHIC))
      damage=(damage*=1.5).round
    end
    # Type effectiveness
    #    typemod=pbTypeModifier(type,attacker,opponent)
    typemod=pbTypeModNoMessages(type,attacker,opponent,move,skill)
    if skill>=PBTrainerAI.minimumSkill
      damage=(damage*typemod*1.0/4).round
    end
    # Critical hits - n/a
    outgoingdamage = true
    # if attacker.index == 2 && pbOwnedByPlayer?(attacker.index) == false
    #   if opponent.index==1 || opponent.index==3
    #     outgoingdamage = true
    #   end
    # else
    #   if opponent.index==0 || opponent.index==2
    #     outgoingdamage = true
    #   end
    # end
    # if $game_switches[1409]==true
    #   outgoingdamage = true
    # end
    if outgoingdamage == true
      random=92
      damage=(damage*random/100.0).floor
    end
    # Water Bubble
    if skill>=PBTrainerAI.mediumSkill
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::WATERBUBBLE) && type == PBTypes::FIRE
        damage=(damage*=0.5).round
      end
    end
    # Punk Rock [Damage from Sound moves]
    if skill>=PBTrainerAI.mediumSkill
      if (!opponent.abilitynulled && opponent.ability == PBAbilities::PUNKROCK) && move.isSoundBased?
        damage=(damage*=0.5).round
      end
    end
    # Burn
    if skill>=PBTrainerAI.mediumSkill
      if attacker.status==PBStatuses::BURN && move.pbIsPhysical?(type) && !(!attacker.abilitynulled && attacker.ability == PBAbilities::GUTS)
        damage=(damage*0.5).round
      end
    end
    # Make sure damage is at least 1
    damage=1 if damage<1
    # Reflect
    if skill>=PBTrainerAI.averageSkill
      if opponent.pbOwnSide.effects[PBEffects::Reflect]>0 && move.pbIsPhysical?(type) && opponent.pbOwnSide.effects[PBEffects::AuroraVeil]==0
        if !opponent.pbPartner.isFainted?
          damage=(damage*0.66).round
        else
          damage=(damage*0.5).round
        end
      end
    end
    # Light Screen
    if skill>=PBTrainerAI.averageSkill
      if opponent.pbOwnSide.effects[PBEffects::LightScreen]>0 && move.pbIsSpecial?(type) && opponent.pbOwnSide.effects[PBEffects::AuroraVeil]==0
        if !opponent.pbPartner.isFainted?
          damage=(damage*0.66).round
        else
          damage=(damage*0.5).round
        end
      end
    end
    # Aurora Veil
    if skill>=PBTrainerAI.averageSkill
      if opponent.pbOwnSide.effects[PBEffects::AuroraVeil]>0
        if !opponent.pbPartner.isFainted?
          damage=(damage*0.66).round
        else
          damage=(damage*0.5).round
        end
      end
    end
    # Arenite Wall
    if skill>=PBTrainerAI.averageSkill
      if opponent.pbOwnSide.effects[PBEffects::AreniteWall]>0 && typemod>4
        if !opponent.pbPartner.isFainted? 
          damage=(damage*0.66).round
        else
          damage=(damage*0.5).round
        end
      end
    end
    # Multiscale
    if skill>=PBTrainerAI.mediumSkill
      if ((!opponent.abilitynulled && opponent.ability == PBAbilities::MULTISCALE) || (!opponent.abilitynulled && opponent.ability == PBAbilities::SHADOWSHIELD) || SilvallyCheck(opponent,PBTypes::DRAGON)) &&
        opponent.hp==opponent.totalhp && !(opponent.moldbroken) && !(hardswitch==true)
        damage=(damage*0.5).round
      end
    end
    # Tinted Lens
    if skill>=PBTrainerAI.mediumSkill
      if ((!attacker.abilitynulled && attacker.ability == PBAbilities::TINTEDLENS) || SilvallyCheck(attacker,PBTypes::BUG)) && typemod<4
        damage=(damage*2.0).round
      end
    end
    # Neuroforce
    if skill>=PBTrainerAI.mediumSkill
      if !attacker.abilitynulled && (attacker.ability == PBAbilities::NEUROFORCE || attacker.ability == PBAbilities::EXECUTION) && typemod>4
        damage=(damage*1.25).round
      end 
    end 
    # Friend Guard
    if skill>=PBTrainerAI.mediumSkill
      if opponent.pbPartner.hasWorkingAbility(:FRIENDGUARD)
        damage=(damage*0.75).round
      end
    end
    # Flower Veil + Flower Garden Shenanigans
    if skill>=PBTrainerAI.highSkill
      if $fefieldeffect == 33 && $fecounter >1
        if ((opponent.pbPartner.hasWorkingAbility(:FLOWERVEIL) || SilvallyCheck(opponent,PBTypes::GRASS)) &&
            opponent.pbHasType?(:GRASS)) ||
          (!opponent.abilitynulled && opponent.ability == PBAbilities::FLOWERVEIL) || SilvallyCheck(opponent,PBTypes::GRASS)
          damage=(damage*0.5).round
        end
        case $fecounter
        when 2
          if opponent.pbHasType?(:GRASS)
            damage=(damage*0.75).round
          end
        when 3
          if opponent.pbHasType?(:GRASS)
            damage=(damage*0.67).round
          end
        when 4
          if opponent.pbHasType?(:GRASS)
            damage=(damage*0.5).round
          end
        end
      end
    end
    # Solid Rock, Filter, Prism Armor
    if skill>=PBTrainerAI.mediumSkill
      if ((!opponent.abilitynulled && opponent.ability == PBAbilities::SOLIDROCK) || (!opponent.abilitynulled && opponent.ability == PBAbilities::FILTER) ||
          (!opponent.abilitynulled && opponent.ability == PBAbilities::PRISMARMOR) || SilvallyCheck(opponent,PBTypes::ROCK)) && typemod>4
        damage=(damage*0.75).round
      end
    end
    # Stakeout
    if skill>=PBTrainerAI.mediumSkill
      if (!attacker.abilitynulled && attacker.ability == PBAbilities::STAKEOUT) && (switchedOut[opponent.index] || hardswitch==true)
        damage=(damage*2.0).round
      end
    end
    if ((!opponent.abilitynulled && opponent.ability == PBAbilities::STALWART) && (PBStuff::SYNTHETICFIELDS).include?($fefieldeffect)) && typemod>4
      damage=(damage*0.5).round
    end
    # Final damage-altering items
    if skill>=PBTrainerAI.averageSkill
      if attacker.hasWorkingItem(:METRONOME)
        if attacker.effects[PBEffects::Metronome]>4
          damage=(damage*2.0).round
        else
          met=1.0+attacker.effects[PBEffects::Metronome]*0.2
          damage=(damage*met).round
        end
      end
      if attacker.hasWorkingItem(:EXPERTBELT) && typemod>4
        damage=(damage*1.2).round
      end
      if attacker.hasWorkingItem(:LIFEORB)
        damage=(damage*1.3).round
      end
    end
    if !hardswitch
      if typemod>4 && skill>=PBTrainerAI.averageSkill && !(attacker.hasWorkingAbility(:UNNERVE) || attacker.pbPartner.hasWorkingAbility(:UNNERVE))
        if (opponent.hasWorkingItem(:CHOPLEBERRY) && isConst?(type,PBTypes,:FIGHTING)) ||
          (opponent.hasWorkingItem(:COBABERRY) && isConst?(type,PBTypes,:FLYING)) ||
          (opponent.hasWorkingItem(:KEBIABERRY) && isConst?(type,PBTypes,:POISON)) ||
          (opponent.hasWorkingItem(:SHUCABERRY) && isConst?(type,PBTypes,:GROUND)) ||
          (opponent.hasWorkingItem(:CHARTIBERRY) && isConst?(type,PBTypes,:ROCK)) ||
          (opponent.hasWorkingItem(:TANGABERRY) && isConst?(type,PBTypes,:BUG)) ||
          (opponent.hasWorkingItem(:KASIBBERRY) && isConst?(type,PBTypes,:GHOST)) ||
          (opponent.hasWorkingItem(:BABIRIBERRY) && isConst?(type,PBTypes,:STEEL)) ||
          (opponent.hasWorkingItem(:OCCABERRY) && isConst?(type,PBTypes,:FIRE)) ||
          (opponent.hasWorkingItem(:PASSHOBERRY) && isConst?(type,PBTypes,:WATER)) ||
          (opponent.hasWorkingItem(:RINDOBERRY) && isConst?(type,PBTypes,:GRASS)) ||
          (opponent.hasWorkingItem(:WACANBERRY) && isConst?(type,PBTypes,:ELECTRIC)) ||
          (opponent.hasWorkingItem(:PAYAPABERRY) && isConst?(type,PBTypes,:PSYCHIC)) ||
          (opponent.hasWorkingItem(:YACHEBERRY) && isConst?(type,PBTypes,:ICE)) ||
          (opponent.hasWorkingItem(:HABANBERRY) && isConst?(type,PBTypes,:DRAGON)) ||
          (opponent.hasWorkingItem(:COLBURBERRY) && isConst?(type,PBTypes,:DARK)) ||
          (opponent.hasWorkingItem(:ROSELIBERRY) && isConst?(type,PBTypes,:FAIRY))
          if move.function==0xBE
            damage=(damage*(15/19)).round
          else
            damage=(damage*0.5).round
          end
        end
      end
      if opponent.hasWorkingItem(:CHILANBERRY) && isConst?(type,PBTypes,:NORMAL)
        damage=(damage*0.5).round
      end
    end
    if isConst?(opponent.species,PBSpecies,:GLACEON) && opponent.hasWorkingItem(:GLACCREST) &&
      (isConst?(type,PBTypes,:ROCK) || isConst?(type,PBTypes,:FIGHTING))
      damage=(damage*0.25).round
    end
    if isConst?(opponent.species,PBSpecies,:LUXRAY) && opponent.hasWorkingItem(:LUXCREST)
      if (isConst?(type,PBTypes,:GHOST) || isConst?(type,PBTypes,:DARK))
        damage=(damage*0.5).round
      elsif (isConst?(type,PBTypes,:PSYCHIC))
        damage=(damage*0).round
      end
    end
    if isConst?(opponent.species,PBSpecies,:NOCTOWL) && opponent.hasWorkingItem(:NOCCREST) && 
      (isConst?(type,PBTypes,:FIGHTING) || isConst?(type,PBTypes,:PSYCHIC))
      damage=(damage*0.5).round
    end
    if isConst?(opponent.species,PBSpecies,:SAMUROTT) && opponent.hasWorkingItem(:SAMUCREST) && 
      (isConst?(type,PBTypes,:BUG) || isConst?(type,PBTypes,:DARK) || isConst?(type,PBTypes,:ROCK))
      damage=(damage*0.5).round
    end
    if isConst?(opponent.species,PBSpecies,:LEAFEON) && opponent.hasWorkingItem(:LEAFCREST) &&
      (isConst?(type,PBTypes,:FIRE) || isConst?(type,PBTypes,:FLYING))
      damage=(damage*0.25).round
    end
    if (isConst?(opponent.species,PBSpecies,:MEGANIUM) && opponent.hasWorkingItem(:MEGCREST)) ||
      (isConst?(opponent.pbPartner.species,PBSpecies,:MEGANIUM) && opponent.pbPartner.hasWorkingItem(:MEGCREST))
      damage=(damage*0.8).round
    end
    if (isConst?(attacker.species,PBSpecies,:SEVIPER) && attacker.hasWorkingItem(:SEVCREST))
      multiplier = 0.5*(opponent.pokemon.hp*1.0)/(opponent.pokemon.totalhp*1.0)
      multiplier += 1.0
      damage=(damage*multiplier).round
    end
    # pbModifyDamage - TODO
    # "AI-specific calculations below"
    # Increased critical hit rates
    if skill>=PBTrainerAI.mediumSkill
      critrate = pbAICritRate(attacker,opponent,move)
      if !(opponent.ability == PBAbilities::SHELLARMOR || opponent.ability == PBAbilities::BATTLEARMOR)
        if critrate<2
          if (isConst?(attacker.species,PBSpecies,:FEAROW) && attacker.hasWorkingItem(:FEARCREST) && (!attacker.abilitynulled && attacker.ability == PBAbilities::SNIPER))
            damage=(damage*1.5).round
          end
        else
          if critrate==2
            if (!attacker.abilitynulled && attacker.ability == PBAbilities::SNIPER)
              if (attacker.index==0 || attacker.index==2)
                damage=(damage*2.25).round 
              else
                damage=(damage*1.88).round 
              end
            else
              damage=(damage*1.25).round
            end
          elsif critrate>2
            if (!attacker.abilitynulled && attacker.ability == PBAbilities::SNIPER)
              damage=(damage*2.25).round 
            else
              damage=(damage*1.5).round
            end
          end
        end
      end
    end
    if $game_variables[699]>0
      attackerhitnum=$game_variables[699] 
      if attacker.isBoss
        damage*=attackerhitnum
      end
    end
    opponent.moldbroken=oldmold
    return damage
  end
  
  def pbTypeModNoMessages(type,attacker,opponent,move,skill)
    return 4 if type<0
    id = move.id
    if isConst?(type,PBTypes,:NORMAL) && (!attacker.abilitynulled && attacker.ability == PBAbilities::GALVANIZE)
      type=PBTypes::ELECTRIC
    end
    if isConst?(type,PBTypes,:NORMAL) && (!attacker.abilitynulled && attacker.ability == PBAbilities::AERILATE)
      type=PBTypes::FLYING
    end
    if isConst?(type,PBTypes,:NORMAL) && (!attacker.abilitynulled && attacker.ability == PBAbilities::PIXILATE)
      type=PBTypes::FAIRY
    end
    if isConst?(type,PBTypes,:NORMAL) && (!attacker.abilitynulled && attacker.ability == PBAbilities::REFRIGERATE)
      type=PBTypes::ICE
    end
    if move.isSoundBased? && (!attacker.abilitynulled && attacker.ability == PBAbilities::LIQUIDVOICE)
      type=PBTypes::WATER
    end
    if (!attacker.abilitynulled && attacker.ability == PBAbilities::NORMALIZE)
      type=PBTypes::NORMAL
    end
    if $fefieldeffect == 31 # Fairy Tale
      if id == PBMoves::CUT || id == PBMoves::SACREDSWORD ||
       id == PBMoves::SLASH || id == PBMoves::SECRETSWORD
        type=PBTypes::STEEL
      end
    end
    if (id == PBMoves::WEATHERBALL)
      weather=pbWeather
      type=getConst(PBTypes,:NORMAL)
      type=(getConst(PBTypes,:FIRE) ) if (weather==PBWeather::SUNNYDAY)
      type=(getConst(PBTypes,:WATER)) if (weather==PBWeather::RAINDANCE)
      type=(getConst(PBTypes,:ROCK) ) if weather==PBWeather::SANDSTORM
      type=(getConst(PBTypes,:ICE)  ) if weather==PBWeather::HAIL
      type=(getConst(PBTypes,:SHADOW)  ) if weather==PBWeather::SHADOWSKY
      type=(getConst(PBTypes,:FLYING)) if (weather==PBWeather::STRONGWINDS || $fefieldeffect==43)
    end
    if (id == PBMoves::GILDEDARROW || id == PBMoves::GILDEDARROWS)
      if (attacker.type1!=attacker.type2) && (attacker.type2!=PBTypes::FAIRY && attacker.type2!=PBTypes::DARK)
        type=attacker.type2
      else
        type=attacker.type1
      end
    end
    # UPDATE Implementing Flying Press + Freeze Dry
    faintedcount=0
    for i in pbParty(opponent.index)
      next if i.nil?
      faintedcount+=1 if (i.hp==0 && i.hp!=0)
    end
    if opponent.effects[PBEffects::Illusion]
      if skill>=PBTrainerAI.highSkill
        if !(opponent.turncount>=1 || faintedcount>2)
          zorovar=true
        else
          zorovar=false
        end
      elsif skill>=PBTrainerAI.averageSkill
        if !(faintedcount>4)
          zorovar=true
        else
          zorovar=false
        end
      else
        zorovar=true
      end
    else
      zorovar=false
    end
    # oppability=opponent.ability
    # if zorovar # ai being fooled by illusion 
    #   if oppability==PBAbilities::ILLUSION
    #     opponent.ability=opponent.effects[PBEffects::Illusion].ability #17
    #   end
    # end
    if ((!opponent.abilitynulled && opponent.ability == PBAbilities::SAPSIPPER) || (isConst?(opponent.species,PBSpecies,:WHISCASH) && opponent.hasWorkingItem(:WHISCREST))) && !(opponent.moldbroken) && (isConst?(type,PBTypes,:GRASS) || move.FieldTypeChange(attacker,opponent,1,true)==PBTypes::GRASS)
      return 0
    end
    if ((!opponent.abilitynulled && opponent.ability == PBAbilities::LEVITATE || opponent.effects[PBEffects::MagnetRise]>0 || opponent.ability == PBAbilities::SOLARIDOL || opponent.ability == PBAbilities::LUNARIDOL) && !(opponent.moldbroken) || (isConst?(opponent.species,PBSpecies,:SKUNTANK) && opponent.hasWorkingItem(:SKUNCREST)) || isConst?(opponent.item,PBItems,:AIRBALLOON)) && (move.type==(PBTypes::GROUND) || move.FieldTypeChange(attacker,opponent,1,true)==PBTypes::GROUND) 
      if opponent.effects[PBEffects::DesertsMark]==false && move.name!="Thousand Arrows"
        return 0
      end
    end
    if (((!opponent.abilitynulled && opponent.ability == PBAbilities::STORMDRAIN) && (isConst?(type,PBTypes,:WATER) || move.FieldTypeChange(attacker,opponent,1,true)==PBTypes::WATER)) ||
      ((!opponent.abilitynulled && opponent.ability == PBAbilities::LIGHTNINGROD) && (isConst?(type,PBTypes,:ELECTRIC) || move.FieldTypeChange(attacker,opponent,1,true)==PBTypes::ELECTRIC))) &&
      !(opponent.moldbroken)
      return 0
    end
    if @doublebattle
      if !(opponent.pbPartner.isFainted?)
        if (((!opponent.pbPartner.abilitynulled && opponent.pbPartner.ability == PBAbilities::STORMDRAIN) && (isConst?(type,PBTypes,:WATER) || move.FieldTypeChange(attacker,opponent.pbPartner,1,true)==PBTypes::WATER)) ||
            ((!opponent.pbPartner.abilitynulled && opponent.pbPartner.ability == PBAbilities::LIGHTNINGROD) && (isConst?(type,PBTypes,:ELECTRIC) || move.FieldTypeChange(attacker,opponent.pbPartner,1,true)==PBTypes::ELECTRIC))) &&
            !(opponent.pbPartner.moldbroken)
          return 0
        end
      end
    end
    if (isConst?(opponent.ability,PBAbilities,:MOTORDRIVE)) &&
      (isConst?(type,PBTypes,:ELECTRIC) || move.FieldTypeChange(attacker,opponent,1,true)==PBTypes::ELECTRIC) &&
      !(opponent.moldbroken)
      return 0
    end
    if (((!opponent.abilitynulled && opponent.ability == PBAbilities::DRYSKIN) && !(opponent.moldbroken)) && (isConst?(type,PBTypes,:WATER) || move.FieldTypeChange(attacker,opponent,1,true)==PBTypes::WATER)) ||
      ((!opponent.abilitynulled && opponent.ability == PBAbilities::VOLTABSORB) && !(opponent.moldbroken) && (isConst?(type,PBTypes,:ELECTRIC) || move.FieldTypeChange(attacker,opponent,1,true)==PBTypes::ELECTRIC)) ||
      ((!opponent.abilitynulled && opponent.ability == PBAbilities::WATERABSORB) && !(opponent.moldbroken) && (isConst?(type,PBTypes,:WATER) || move.FieldTypeChange(attacker,opponent,1,true)==PBTypes::WATER))
      if opponent.effects[PBEffects::HealBlock]==0
        return 0
      end
    end
    if isConst?(opponent.ability,PBAbilities,:BULLETPROOF) && !(opponent.moldbroken)
      if (id == PBMoves::ACIDSPRAY || id == PBMoves::AURASPHERE ||
          id == PBMoves::BARRAGE || id == PBMoves::BULLETSEED ||
          id == PBMoves::EGGBOMB || id == PBMoves::ELECTROBALL ||
          id == PBMoves::ENERGYBALL || id == PBMoves::FOCUSBLAST ||
          id == PBMoves::GYROBALL || id == PBMoves::ICEBALL ||
          id == PBMoves::MAGNETBOMB || id == PBMoves::MISTBALL ||
          id == PBMoves::MUDBOMB || id == PBMoves::OCTAZOOKA ||
          id == PBMoves::ROCKWRECKER || id == PBMoves::SEARINGSHOT ||
          id == PBMoves::SEEDBOMB || id == PBMoves::SHADOWBALL ||
          id == PBMoves::SLUDGEBOMB || id == PBMoves::WEATHERBALL ||
          id == PBMoves::ZAPCANNON || id == PBMoves::BEAKBLAST)
        return 0
      end
    end
    if $fefieldeffect == 14 && (opponent.effects[PBEffects::Substitute]>0 ||
        opponent.stages[PBStats::EVASION] > 0)
      if (id == PBMoves::ACIDSPRAY || id == PBMoves::AURASPHERE ||
          id == PBMoves::BARRAGE || id == PBMoves::BULLETSEED ||
          id == PBMoves::EGGBOMB || id == PBMoves::ELECTROBALL ||
          id == PBMoves::ENERGYBALL || id == PBMoves::FOCUSBLAST ||
          id == PBMoves::GYROBALL || id == PBMoves::ICEBALL ||
          id == PBMoves::MAGNETBOMB || id == PBMoves::MISTBALL ||
          id == PBMoves::MUDBOMB || id == PBMoves::OCTAZOOKA ||
          id == PBMoves::ROCKWRECKER || id == PBMoves::SEARINGSHOT ||
          id == PBMoves::SEEDBOMB || id == PBMoves::SHADOWBALL ||
          id == PBMoves::SLUDGEBOMB || id == PBMoves::WEATHERBALL ||
          id == PBMoves::ZAPCANNON || id == PBMoves::BEAKBLAST)
        return 0
      end
    end
    if ((!opponent.abilitynulled && opponent.ability == PBAbilities::FLASHFIRE) || (isConst?(opponent.species,PBSpecies,:DRUDDIGON) && opponent.hasWorkingItem(:DRUDDICREST))) && !(opponent.moldbroken) && (isConst?(type,PBTypes,:FIRE) || move.FieldTypeChange(attacker,opponent,1,true)==PBTypes::FIRE)
      return 0
    end
    if (isConst?(opponent.species,PBSpecies,:GENESECT) && opponent.hasWorkingItem(:BURNDRIVE)) && (isConst?(type,PBTypes,:FIRE) || move.FieldTypeChange(attacker,opponent,1,true)==PBTypes::FIRE)
      return 0
    end
    if (!opponent.abilitynulled && opponent.ability == PBAbilities::MAGMAARMOR) && (isConst?(type,PBTypes,:FIRE) || move.FieldTypeChange(attacker,opponent,1,true)==PBTypes::FIRE) &&
      ($fefieldeffect == 32 || $fefieldeffect == 16 || $fefieldeffect == 45) && !(opponent.moldbroken)
      return 0
    end
    if ($fefieldeffect == 21 || $fefieldeffect == 26) &&
      (isConst?(type,PBTypes,:GROUND) || move.FieldTypeChange(attacker,opponent,1,true)==PBTypes::GROUND)
      return 0
    end
    if $fefieldeffect == 22 && (isConst?(type,PBTypes,:FIRE) || move.FieldTypeChange(attacker,opponent,1,true)==PBTypes::FIRE)
      return 0
    end
    # if oppability==PBAbilities::ILLUSION
    #   opponent.ability=PBAbilities::ILLUSION
    # end
    #Telepathy
    if (!opponent.abilitynulled && opponent.ability == PBAbilities::TELEPATHY) &&
      move.basedamage>0 &&
      !(opponent.moldbroken)
      partner=attacker.pbPartner
      if opponent.index == partner.index
        return 0
      end
    end
    typemod=pbTypeModifierAI(type,attacker,opponent,zorovar)
    typemod2= nil
    typemod3= nil
    if isConst?(type,PBTypes,:WATER) && (opponent.pbHasType?(PBTypes::WATER)) && $fefieldeffect == 22
      typemod*= 2
    end
    if $fefieldeffect == 24
      if isConst?(type,PBTypes,:DRAGON)
        typemod = 4
      end
      if isConst?(type,PBTypes,:GHOST) && (opponent.pbHasType?(PBTypes::PSYCHIC))
        typemod = 0
      end
      if isConst?(type,PBTypes,:BUG) && (opponent.pbHasType?(PBTypes::POISON))
        typemod*= 4
      end
      if isConst?(type,PBTypes,:ICE) && (opponent.pbHasType?(PBTypes::FIRE))
        typemod*= 2
      end
      if isConst?(type,PBTypes,:POISON) && (opponent.pbHasType?(PBTypes::BUG))
        typemod*= 2
      end
      if (isConst?(type,PBTypes,:GHOST) || isConst?(type,PBTypes,:DARK)) &&
        opponent.pbHasType?(PBTypes::STEEL)
         typemod /= 2
       end
    end
    if $fefieldeffect == 29
      if isConst?(type,PBTypes,:NORMAL) && (opponent.pbHasType?(PBTypes::DARK) ||
          opponent.pbHasType?(PBTypes::GHOST))
        typemod*= 2
      end
    end
    if $fefieldeffect == 31
      if isConst?(type,PBTypes,:STEEL) && (opponent.pbHasType?(PBTypes::DRAGON))
        typemod*= 2
      end
    end
    if $fefieldeffect == 40
      if isConst?(type,PBTypes,:GHOST) && (opponent.pbHasType?(PBTypes::NORMAL))
        typemod *= 2
      end
    end
    if $fefieldeffect == 42
      if isConst?(type,PBTypes,:FAIRY) && (opponent.pbHasType?(PBTypes::STEEL))
        typemod*= 4
      end
      if isConst?(type,PBTypes,:GRASS) && (opponent.pbHasType?(PBTypes::STEEL))
        typemod*= 4
      end
      if isConst?(type,PBTypes,:DARK) && (opponent.pbHasType?(PBTypes::FAIRY))
        typemod*= 4
      end
      if isConst?(type,PBTypes,:FAIRY) && (opponent.pbHasType?(PBTypes::DARK))
        typemod*= 0.5
      end
      if isConst?(type,PBTypes,:POISON) && (opponent.pbHasType?(PBTypes::GRASS))
        typemod*= 0.5
      end
      if isConst?(type,PBTypes,:POISON) && (opponent.pbHasType?(PBTypes::FAIRY))
        typemod*= 0.5
      end
    end
    if id == PBMoves::FREEZEDRY && (opponent.pbHasType?(PBTypes::WATER))
      typemod*= 4
    end
    if id == PBMoves::VENAMSKISS && (opponent.pbHasType?(PBTypes::STEEL))
      typemod=4
      typemod*= 2
    end
    if (id == PBMoves::SPIRITBREAK && opponent.pbHasType?(PBTypes::GHOST) && ($fefieldeffect == 29 || $fefieldeffect == 40))
      typemod *= 2
    end   
    if id == PBMoves::CUT && (opponent.pbHasType?(PBTypes::GRASS)) &&
      $fefieldeffect == 33 && $fecounter > 0
      typemod*= 2
    end
    if pbWeather==PBWeather::STRONGWINDS &&
      ((opponent.pbHasType?(PBTypes::FLYING)) &&
        !opponent.effects[PBEffects::Roost]) &&
      (isConst?(type,PBTypes,:ELECTRIC) || isConst?(type,PBTypes,:ICE) ||
        isConst?(type,PBTypes,:ROCK))
      typemod /= 2
    end
    if $fefieldeffect == 32 && # Dragons Den Multiscale
      ((!opponent.abilitynulled && opponent.ability == PBAbilities::MULTISCALE) || SilvallyCheck(opponent,PBTypes::DRAGON)) &&
      (isConst?(type,PBTypes,:FAIRY) || isConst?(type,PBTypes,:ICE) ||
        isConst?(type,PBTypes,:DRAGON)) && !(opponent.moldbroken)
      typemod /= 2
    end
    if $fefieldeffect == 42 && # Bewitched Woods Pastel Veil
      ((!opponent.abilitynulled && opponent.ability == PBAbilities::PASTELVEIL)) &&
      (isConst?(type,PBTypes,:STEEL) || isConst?(type,PBTypes,:POISON)) && !(opponent.moldbroken)
      typemod /= 2
    end
    if (($fefieldeffect == 28)) && # Snowy Mountain Ice Scales
      (opponent.hasWorkingAbility(:ICESCALES)) && 
      (isConst?(type,PBTypes,:FIRE) || isConst?(type,PBTypes,:ROCK) || isConst?(type,PBTypes,:FLYING) || isConst?(type,PBTypes,:FIGHTING)) && 
      !(opponent.moldbroken)
      typemod /= 2
    end
    if (opponent.hasWorkingAbility(:WONDERGUARD))
      if typemod<4
        typemod*=0
      end
    end
    if id == PBMoves::FLYINGPRESS
      if $fefieldeffect==43 
        if (opponent.pbHasType?(PBTypes::GRASS) || opponent.pbHasType?(PBTypes::FIGHTING) || opponent.pbHasType?(PBTypes::BUG) || opponent.pbHasType?(PBTypes::FIGHTING))
          typemod*=2
        end
      else
        typemod2=move.pbTypeModifier(PBTypes::FLYING,attacker,opponent,zorovar)
        typemod3= ((typemod*typemod2)/4.0)
        typemod=typemod3
      end
    end
    if $fefieldeffect == 36 # Inverse Field
      temptypemod = typemod
      temptypemod = 16 if typemod == 0
      temptypemod = 16 if typemod == 1
      temptypemod = 8 if typemod == 2
      temptypemod = 2 if typemod == 8
      temptypemod = 1 if typemod == 16
      typemod = temptypemod
    end
    # if !($fefieldeffect==36) && isConst?(opponent.species,PBSpecies,:TORTERRA) && 
    #   isConst?(opponent.item,PBItems,:TORCREST)
    #   temptypemod = typemod
    #   #temptypemod = 8 if typemod == 0 
    #   temptypemod = 16 if typemod == 1
    #   temptypemod = 8 if typemod == 2
    #   temptypemod = 2 if typemod == 8
    #   temptypemod = 1 if typemod == 16
    #   temptypemod = 0.5 if typemod == 32
    #   temptypemod = 32 if typemod == 0.5
    #   typemod = temptypemod
    # end
    # Field Effect type changes go here
    if @field.effects[PBEffects::ElectricTerrain]>0 && $fefieldeffect!=1 
      if ((id == PBMoves::EXPLOSION || id == PBMoves::SELFDESTRUCT ||
            id == PBMoves::SMACKDOWN || id == PBMoves::HURRICANE ||
            id == PBMoves::THOUSANDARROWS) && $fefieldeffect!=1) || 
        ((id == PBMoves::SURF || id == PBMoves::MUDDYWATER) && $fefieldeffect!=18 && $fefieldeffect!=1)      
        typemod2=move.pbTypeModifier(PBTypes::ELECTRIC,attacker,opponent)
        typemod3= ((typemod*typemod2) * 0.25).ceil
        typemod=typemod3
      end  
    end
    typemod=move.FieldTypeChange(attacker,opponent,typemod,false)
    if typemod==0
      if @function==0x111 
        return 1
      end
    end
    return typemod
  end
  
  def pbAICritRate(attacker,opponent,move)
    if ((!opponent.abilitynulled && opponent.ability == PBAbilities::BATTLEARMOR) ||
        (!opponent.abilitynulled && opponent.ability == PBAbilities::SHELLARMOR)) &&
      !(opponent.moldbroken)
      return 0
    end
    return 0 if opponent.pbOwnSide.effects[PBEffects::LuckyChant]>0
    $buffs = 0
    if $fefieldeffect == 30
      $buffs = attacker.stages[PBStats::EVASION] if attacker.stages[PBStats::EVASION] > 0
      $buffs = $buffs.to_i + attacker.stages[PBStats::ACCURACY] if attacker.stages[PBStats::ACCURACY] > 0
      $buffs = $buffs.to_i - opponent.stages[PBStats::EVASION] if opponent.stages[PBStats::EVASION] < 0
      $buffs = $buffs.to_i - opponent.stages[PBStats::ACCURACY] if opponent.stages[PBStats::ACCURACY] < 0
      $buffs = $buffs.to_i
    end
    if attacker.effects[PBEffects::LaserFocus]>0
      return 3
    end
    return 3 if move.function==0xA0 # Frost Breath
    return 3 if move.function==0x202 && attacker.hp<=((attacker.totalhp)*0.5).floor # Gale Strike
    return 3 if ((!attacker.abilitynulled && attacker.ability == PBAbilities::MERCILESS) ||
      (isConst?(attacker.species,PBSpecies,:ARIADOS) && attacker.hasWorkingItem(:ARIACREST))) && (opponent.status == PBStatuses::POISON ||
      $fefieldeffect==10 || $fefieldeffect==11 || $fefieldeffect==19 || $fefieldeffect==26)
    c=0
    c+=attacker.effects[PBEffects::FocusEnergy]
    if move.hasHighCriticalRate?
      c+=1
    end
    if (attacker.inHyperMode? rescue false) && isConst?(move.type,PBTypes,:SHADOW)
      c+=1
    end
    if (!attacker.abilitynulled && attacker.ability == PBAbilities::SUPERLUCK)
      c+=1 
    end
    if attacker.hasWorkingItem(:STICK) &&
      (isConst?(attacker.species,PBSpecies,:FARFETCHD) || isConst?(attacker.species,PBSpecies,:SIRFETCHD))
      c+=2
    end
    if attacker.hasWorkingItem(:LUCKYPUNCH) && isConst?(attacker.species,PBSpecies,:CHANSEY)
      c+=2
    end
    c+=1 if attacker.hasWorkingItem(:RAZORCLAW)
    c+=1 if attacker.hasWorkingItem(:SCOPELENS)
    if (attacker.speed > opponent.speed) && $fefieldeffect == 24
      c+=1 
    end
    if $fefieldeffect == 30
      c += $buffs if $buffs > 0
    end
    if isConst?(attacker.species,PBSpecies,:FEAROW) && attacker.hasWorkingItem(:FEARCREST) && (opponent.hp<=opponent.totalhp/2)
      c+=3
    end
    c=3 if c>3
    return c
  end
  
  def pbRoughAccuracy(move,attacker,opponent,skill)
    # Get base accuracy
    baseaccuracy=move.accuracy  
    case $fefieldeffect
    when 2 # Grassy Field
      if move.id==getID(PBMoves,:GRASSWHISTLE)
        baseaccuracy=80
      end
    when 3 # Misty Field
      if move.id==getID(PBMoves,:SWEETKISS)
        baseaccuracy=100
      end
    when 4 # Dark Crystal Cavern
      if move.id==getID(PBMoves,:DARKVOID)
        baseaccuracy=100
      end
    when 6 # Big Top
      if move.id==getID(PBMoves,:SING)
        baseaccuracy=100
      end
    when 7 # Burning Field
      if move.id==getID(PBMoves,:WILLOWISP)
        baseaccuracy=100
      end
    when 8 # Swamp Field
      if move.id==getID(PBMoves,:SLEEPPOWDER)
        baseaccuracy=100
      end
    when 10 # Corrosive Field
      if move.id==getID(PBMoves,:POISONPOWDER) || move.id==getID(PBMoves,:SLEEPPOWDER) ||
        move.id==getID(PBMoves,:STUNSPORE) || move.id==getID(PBMoves,:TOXIC)
        baseaccuracy=100
      end
    when 11 # Corrosive Mist Field
      if move.id==getID(PBMoves,:TOXIC)
        baseaccuracy=100
      end
    when 18 # Shortcircuit Field
      if move.id==getID(PBMoves,:ZAPCANNON)
        baseaccuracy=80
      end
    when 24 # Glitch Field
      if move.id==getID(PBMoves,:BLIZZARD)
        baseaccuracy=90
      end
    when 32 # Dragon's Den
      if move.id==getID(PBMoves,:DRAGONRUSH)
        baseaccuracy=100
      end
    when 33 # Flower Garden
      if $fecounter > 1
        if move.id==getID(PBMoves,:SLEEPPOWDER) || move.id==getID(PBMoves,:STUNSPORE) ||
          move.id==getID(PBMoves,:POISONPOWDER)
          baseaccuracy=100
        end
      end
    when 35 # New World
      if move.id==getID(PBMoves,:DARKVOID)
        baseaccuracy=100
      end
    when 37 # Psychic Terrain
      if move.id==getID(PBMoves,:HYPNOSIS)
        baseaccuracy=90
      end
    when 38 # Dimensional Field
      if move.id==getID(PBMoves,:DARKVOID)
        baseaccuracy=100
      end
    when 39 # Frozen Dimensional Field
      if move.id==getID(PBMoves,:DARKVOID)
        baseaccuracy=100
      end
    when 40 # Haunted
      if move.id==getID(PBMoves,:WILLOWISP) || move.id==getID(PBMoves,:HYPNOSIS)
        baseaccuracy=90
      end
    when 42 # Darchlight Field
      if move.id==getID(PBMoves,:POISONPOWDER) || move.id==getID(PBMoves,:SLEEPPOWDER) ||
        move.id==getID(PBMoves,:GRASSWHISTLE) || move.id==getID(PBMoves,:STUNSPORE)
        baseaccuracy=95
      end
    end 
    if skill>=PBTrainerAI.mediumSkill
      if pbWeather==PBWeather::SUNNYDAY &&
        (move.function==0x08 || move.function==0x15) # Thunder, Hurricane
        accuracy=50
      end
    end
    # Accuracy stages
    accstage=attacker.stages[PBStats::ACCURACY]
    accstage=0 if (!opponent.abilitynulled && opponent.ability == PBAbilities::UNAWARE) || SilvallyCheck(opponent, PBTypes::FAIRY)
    accuracy=(accstage>=0) ? (accstage+3)*100.0/3 : 300.0/(3-accstage)
    evastage=opponent.stages[PBStats::EVASION]
    evastage-=2 if @field.effects[PBEffects::Gravity]>0
    evastage=-6 if evastage<-6
    evastage=0 if opponent.effects[PBEffects::Foresight] ||
    opponent.effects[PBEffects::MiracleEye] ||
    move.function==0xA9 || # Chip Away
    (!attacker.abilitynulled && attacker.ability == PBAbilities::UNAWARE) ||
    SilvallyCheck(attacker,PBTypes::FAIRY)
    evasion=(evastage>=0) ? (evastage+3)*100.0/3 : 300.0/(3-evastage)
    accuracy*=baseaccuracy/evasion
    # Accuracy modifiers
    if skill>=PBTrainerAI.mediumSkill
      accuracy*=1.3 if (!attacker.abilitynulled && attacker.ability == PBAbilities::COMPOUNDEYES)
      if attacker.hasWorkingItem(:MICLEBERRY)
        accuracy*=1.2 if ((!attacker.abilitynulled && attacker.ability == PBAbilities::GLUTTONY) &&
          attacker.hp<=(attacker.totalhp/2).floor) ||
        attacker.hp<=(attacker.totalhp/4).floor
      end
      accuracy*=1.1 if (!attacker.abilitynulled && attacker.ability == PBAbilities::VICTORYSTAR)
      if !pbOwnedByPlayer?(attacker.index) && ($game_variables[200] == 2)  
        accuracy*=1.1 
        if pbPlayer.numbadges>=11 && move.basedamage>0
          accuracy*=1.2
        end
      end
      if skill>=PBTrainerAI.averageSkill
        partner=attacker.pbPartner
        accuracy*=1.1 if partner && partner.hasWorkingAbility(:VICTORYSTAR)
      end
      accuracy*=1.1 if attacker.hasWorkingItem(:WIDELENS)
      accuracy*=1.2 if attacker.hasWorkingItem(:ZOOMLENS) && attacker.pbSpeed<opponent.pbSpeed
      if skill>=PBTrainerAI.averageSkill
        accuracy*=0.8 if (!attacker.abilitynulled && attacker.ability == PBAbilities::HUSTLE) &&
        move.basedamage>0 &&
        move.pbIsPhysical?(move.pbType(move.type,attacker,opponent))
      end
      accuracy*=1.5 if isConst?(attacker.species,PBSpecies,:STANTLER) && attacker.hasWorkingItem(:STANTCREST)
      accuracy*=1.5 if isConst?(attacker.species,PBSpecies,:HYPNO) && attacker.hasWorkingItem(:HYPCREST)
      if skill>=PBTrainerAI.highSkill
        accuracy/=2 if (!opponent.abilitynulled && opponent.ability == PBAbilities::WONDERSKIN) &&
        move.basedamage==0 &&
        attacker.pbIsOpposing?(opponent.index)
        accuracy/=1.2 if (!opponent.abilitynulled && opponent.ability == PBAbilities::TANGLEDFEET) &&
        opponent.effects[PBEffects::Confusion]>0
        accuracy/=1.2 if pbWeather==PBWeather::SANDSTORM &&
        (!opponent.abilitynulled && opponent.ability == PBAbilities::SANDVEIL)
        accuracy/=1.2 if pbWeather==PBWeather::HAIL &&
        (!opponent.abilitynulled && opponent.ability == PBAbilities::SNOWCLOAK)
      end
      if skill>=PBTrainerAI.averageSkill
        accuracy/=1.1 if opponent.hasWorkingItem(:BRIGHTPOWDER)
        accuracy/=1.1 if opponent.hasWorkingItem(:LAXINCENSE)
      end
    end
    # Override accuracy
    accuracy=100 if move.accuracy==0   # Doesn't do accuracy check (always hits)
    accuracy=100 if move.function==0xA5 # Swift
    if skill>=PBTrainerAI.mediumSkill
      accuracy=100 if opponent.effects[PBEffects::LockOn]>0 &&
      opponent.effects[PBEffects::LockOnPos]==attacker.index
      if skill>=PBTrainerAI.averageSkill
        accuracy=100 if (!attacker.abilitynulled && attacker.ability == PBAbilities::NOGUARD) ||
        (!opponent.abilitynulled && opponent.ability == PBAbilities::NOGUARD)
      end
      accuracy=100 if opponent.effects[PBEffects::Telekinesis]>0
      case pbWeather
      when PBWeather::HAIL
        accuracy=100 if move.function==0x0D # Blizzard
      when PBWeather::RAINDANCE
        accuracy=100 if move.function==0x08 || move.function==0x15 # Thunder, Hurricane
      end
      accuracy=100 if move.function==0x08 && # Thunder
      ($fefieldeffect==16 || $fefieldeffect==27 || $fefieldeffect==28)
      accuracy=100 if attacker.pbHasType?(:POISON) && move.id==getID(PBMoves,:TOXIC)
      accuracy=100 if (move.function==0x10 || move.function==0x9B || move.id==getID(PBMoves,:BODYSLAM) || move.id==getID(PBMoves,:FLYINGPRESS)) &&
      opponent.effects[PBEffects::Minimize] # Flying Press, Stomp, DRush
      if $fefieldeffect==30
        if move.id==getID(PBMoves,:AURORABEAM) || move.id==getID(PBMoves,:SIGNALBEAM) ||
          move.id==getID(PBMoves,:FLASHCANNON) || move.id==getID(PBMoves,:LUSTERPURGE) ||
          move.id==getID(PBMoves,:DAZZLINGBEAM) || move.id==getID(PBMoves,:TECHNOBLAST) ||
          move.id==getID(PBMoves,:DOOMDUMMY) || move.id==getID(PBMoves,:MIRRORSHOT) ||
          move.id==getID(PBMoves,:PRISMATICLASER)
          accuracy=100
        end
      end
      if $fefieldeffect==38
        if move.id==getID(PBMoves,:DARKPULSE) || move.id==getID(PBMoves,:DARKVOID) ||
          move.id==getID(PBMoves,:NIGHTDAZE)
          accuracy=100
        end
      end
      accuracy=100 if (move.function==0x08 || move.function==0x15) && # Thunder, Hurricane
      $fefieldeffect==43
      if move.function==0x70 # OHKO moves
        accuracy=move.accuracy+attacker.level-opponent.level
        accuracy=0 if (!opponent.abilitynulled && opponent.ability == PBAbilities::STURDY) || (isConst?(opponent.species,PBSpecies,:RAMPARDOS) && isConst?(opponent.item,PBItems,:RAMPCREST))
        accuracy=0 if opponent.level>attacker.level
      end
    end
    accuracy=100 if accuracy>100
    return accuracy
  end
  
  def pbGetMonRole(mon,opponent,skill,position=0,party=nil)
    #PBDebug.log(sprintf("Beginning role assignment for %s",PBSpecies.getName(mon.species))) if $INTERNAL
    monRoles=[]
    monability = mon.ability.to_i
    curemove=false
    healingmove=false
    wishmove=false
    phasemove=false
    priorityko=false
    pivotmove=false
    spinmove=false
    batonmove=false
    tauntmove=false
    hazardmove=false
    sleepmove=false
    restmove=false
    screenmove=false
    weathermove=false
    fieldmove=false
    setupmove=false
    statusmove=0
    #Getting the class differences out of the way at the start
    if mon.class == PokeBattle_Battler
      movelist = mon.moves
      monRoles.push(PBMonRoles::LEAD) if (mon.pokemonIndex==0 || position==0 || position==(pbParty(mon.index).length-6)) 
      if @opponent.is_a?(Array)  && @opponent!=nil 
        monRoles.push(PBMonRoles::ACE) if (position==(pbParty(mon.index).length-1) || position==(pbParty(mon.index).length+5) || (position==(pbParty(mon.index).length-7))) 
      else 
        monRoles.push(PBMonRoles::ACE) if (position==(pbParty(mon.index).length-1) || position==(pbParty(mon.index).length+5))
      end
      secondhighest=true  
      if pbParty(mon.index).length>2  
        for i in 0..(pbParty(mon.index).length-2)  
          next if pbParty(mon.index)[i].nil?  
          if mon.level<pbParty(mon.index)[i].level  
            secondhighest=false  
          end  
        end  
      end
    elsif mon.class == PokeBattle_Pokemon
      movelist = []
      for i in mon.moves
        next if i.nil?
        next if i.id == 0
        movedummy = PokeBattle_Move.pbFromPBMove(self,i,mon)
        movelist.push(movedummy)
      end
      monRoles.push(PBMonRoles::LEAD) if position==0
      if (position==(party.length-1) || position==(party.length+5))
        monRoles.push(PBMonRoles::ACE) 
      end
      secondhighest=true  
      if party.length>2
        for i in 0..(party.length-2)
          next if party[i].nil?
          if mon.level<party[i].level
            secondhighest=false
          end
        end
      end
    else #Something has been called wrong- return with nothing
      return monRoles
    end
    for i in movelist
      next if i.nil?
      next if i.id == 0
      if mon.class == PokeBattle_Battler
        if i.priority>0
          dam=pbRoughDamage(i,mon,opponent,skill,i.basedamage)
          if opponent.hp>0
            percentage=(dam*100.0)/opponent.hp
            priorityko=true if percentage>100
          end
        end
      else
        priorityko=false
        for i in movelist
          next if i.priority<1
          next if i.basedamage<10
          priorityko=true
        end
      end
      if (i.id == (PBMoves::LEECHSEED) || i.id == (PBMoves::TOXIC) ||
        i.id == (PBMoves::SUBSTITUTE) || i.id == (PBMoves::LEECHSEED))
        statusmove+=1
      end
      if i.isHealingMove?
        healingmove=true
        statusmove+=1
      end
      if (i.id == (PBMoves::STEALTHROCK) || i.id == (PBMoves::SPIKES) ||
        i.id == (PBMoves::TOXICSPIKES) || i.id == (PBMoves::STICKYWEB))
        hazardmove=true
      end
      if (PBStuff::SETUPMOVE).include?(i.id)
        if (i.id == (PBMoves::SWORDSDANCE) || i.id == (PBMoves::NASTYPLOT) ||
          i.id == (PBMoves::DRAGONDANCE) || i.id == (PBMoves::AGILITY) ||
          i.id == (PBMoves::AQUABATICS))
          setupmove=true
        end
      end
      if (i.id == (PBMoves::HEALBELL) || i.id == (PBMoves::AROMATHERAPY))
        curemove=true
      end
      if (i.id == (PBMoves::WISH))
        wishmove=true
      end
      if (i.id == (PBMoves::YAWN) || i.id == (PBMoves::PERISHSONG) ||
          i.id == (PBMoves::DRAGONTAIL) || i.id == (PBMoves::CIRCLETHROW) ||
          i.id == (PBMoves::WHIRLWIND) || i.id == (PBMoves::ROAR))
        phasemove=true
      end
      if (i.id == (PBMoves::UTURN) || i.id == (PBMoves::VOLTSWITCH) ||
          i.id == (PBMoves::PARTINGSHOT) || i.id == (PBMoves::ALLYSWITCH))
        pivotmove=true
      end
      if (i.id == (PBMoves::RAPIDSPIN))
        spinmove=true
      end
      if (i.id == (PBMoves::SLEEPPOWDER) || i.id == (PBMoves::SPORE) ||
          i.id == (PBMoves::HYPNOSIS) || i.id == (PBMoves::GRASSWHISTLE) ||
          i.id == (PBMoves::SING) || i.id == (PBMoves::DARKVOID))
        sleepmove=true
        statusmove+=1
      end
      if (i.id == (PBMoves::BATONPASS))
        batonmove=true
      end
      if (i.id == (PBMoves::ARENITEWALL)) || (i.id == (PBMoves::AURORAVEIL))
        screenmove=true
      end
      if (i.id == (PBMoves::TAUNT))
        tauntmove=true
      end
      if (i.id == (PBMoves::REST))
        restmove=true
      end
      if (i.id == (PBMoves::SUNNYDAY) || i.id == (PBMoves::RAINDANCE) ||
          i.id == (PBMoves::HAIL) || i.id == (PBMoves::SANDSTORM))
        weathermove=true
      end
      if (i.id == (PBMoves::GRASSYTERRAIN) || i.id == (PBMoves::ELECTRICTERRAIN) ||
          i.id == (PBMoves::MISTYTERRAIN) || i.id == (PBMoves::PSYCHICTERRAIN) ||
          i.id == (PBMoves::MIST) || i.id == (PBMoves::IONDELUGE) ||
          i.id == (PBMoves::TOPSYTURVY))
        fieldmove=true
      end
    end
    if mon.ev[3]>251 && (mon.nature==PBNatures::MODEST ||
        mon.nature==PBNatures::JOLLY || mon.nature==PBNatures::TIMID ||
        mon.nature==PBNatures::ADAMANT) || (mon.item==(PBItems::CHOICEBAND) ||
        mon.item==(PBItems::CHOICESPECS) || mon.item==(PBItems::CHOICESCARF) || mon.item==(PBItems::LIFEORB) ||
        setupmove==true)
      monRoles.push(PBMonRoles::SWEEPER)
    end
    if healingmove && ((mon.ev[2]>251 || ((mon.item==(PBItems::TELLURICSEED)) && $fefieldeffect==12)) && (mon.nature==PBNatures::BOLD ||
          mon.nature==PBNatures::RELAXED || mon.nature==PBNatures::IMPISH ||
          mon.nature==PBNatures::LAX))
      monRoles.push(PBMonRoles::PHYSICALWALL)
    end
    if healingmove && (mon.ev[5]>251 && (mon.nature==PBNatures::CALM ||
          mon.nature==PBNatures::GENTLE || mon.nature==PBNatures::SASSY ||
          mon.nature==PBNatures::CAREFUL))
      monRoles.push(PBMonRoles::SPECIALWALL)
    end
    if curemove || (wishmove && mon.ev[0]>251)
      monRoles.push(PBMonRoles::CLERIC)
    end
    if phasemove == true
      monRoles.push(PBMonRoles::PHAZER)
    end
    if mon.item==(PBItems::LIGHTCLAY) || screenmove
      monRoles.push(PBMonRoles::SCREENER)
    end
    if priorityko || (mon.speed>opponent.spe